// SSCTF4 Shader File //

textures/ssctf4/s_ssctf4sky
{
	q3map_lightimage textures/skies/stars_red.tga
	qer_editorimage textures/skies/killsky_1.tga

	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm nomarks
	q3map_globaltexture
	q3map_lightsubdivide 512 

	// q3map_sun <red> <green> <blue> <intensity> <degrees> <elevation>
	q3map_sun .5 .37 .19 70 314 85

	q3map_surfacelight 80
	skyparms - 512 -
	{
		map textures/skies/killsky_1.tga
		tcMod scroll 0.05 .1
		tcMod scale 2 2
		depthWrite
	}
	{
		map textures/skies/killsky_2.tga
		blendfunc GL_ONE GL_ONE
		tcMod scroll 0.05 0.06
		tcMod scale 3 2
	}
}


textures/ssctf4/clang_clip
{
	qer_trans 0.40
	surfaceparm nodraw
	surfaceparm playerclip
 	surfaceparm metalsteps	   
}

// Red Base Fog (based off id fog shader)
textures/ssctf4/ssctf4_fog
{
	qer_editorimage textures/sfx/fog_red.tga
	surfaceparm	trans
	surfaceparm	nonsolid
	surfaceparm	fog
	surfaceparm 	nodrop
	surfaceparm 	nolightmap
	q3map_globaltexture
	q3map_surfacelight 50
	fogparms ( .55 .11 .1 ) 300

	
	{
		map textures/liquids/kc_fogcloud3.tga
		blendfunc gl_dst_color gl_zero
		tcmod scale -.05 -.05
		tcmod scroll .01 -.01
		rgbgen identity
	}
	{
		map textures/liquids/kc_fogcloud3.tga
		blendfunc gl_dst_color gl_zero
		tcmod scale .05 .05
		tcmod scroll .01 -.01
		rgbgen identity
	}
}
// Red Base Fog (based off id fog shader) + BRIGHTER
textures/ssctf4/ssctf4_fog_bright
{
	qer_editorimage textures/sfx/fog_red.tga
	surfaceparm	trans
	surfaceparm	nonsolid
	surfaceparm	fog
	surfaceparm 	nodrop
	surfaceparm 	nolightmap
	q3map_globaltexture
	q3map_surfacelight 250
	fogparms ( .55 .11 .1 ) 300

	
	{
		map textures/liquids/kc_fogcloud3.tga
		blendfunc gl_dst_color gl_zero
		tcmod scale -.05 -.05
		tcmod scroll .01 -.01
		rgbgen identity
	}
	{
		map textures/liquids/kc_fogcloud3.tga
		blendfunc gl_dst_color gl_zero
		tcmod scale .05 .05
		tcmod scroll .01 -.01
		rgbgen identity
	}
}

textures/ssctf4/ssctf4_fogblue
{
	qer_editorimage textures/sfx/fog_blue.tga
	surfaceparm	trans
	surfaceparm	nonsolid
	surfaceparm	fog
	surfaceparm 	nodrop
	surfaceparm 	nolightmap
	q3map_globaltexture
//	fogparms ( .1 .11 .55 ) 300
	fogparms ( .1 .11 .35 ) 300
	q3map_surfacelight 50
	
	{
		map textures/liquids/kc_fogcloud3.tga
		blendfunc gl_dst_color gl_zero
		tcmod scale -.05 -.05
		tcmod scroll .01 -.01
		rgbgen identity
	}
	{
		map textures/liquids/kc_fogcloud3.tga
		blendfunc gl_dst_color gl_zero
		tcmod scale .05 .05
		tcmod scroll .01 -.01
		rgbgen identity
	}
}

textures/ssctf4/ssctf4_fogblue_bright
{
	qer_editorimage textures/sfx/fog_blue.tga
	surfaceparm	trans
	surfaceparm	nonsolid
	surfaceparm	fog
	surfaceparm 	nodrop
	surfaceparm 	nolightmap
	q3map_globaltexture
//	fogparms ( .1 .11 .55 ) 300
	fogparms ( .1 .11 .35 ) 300
	q3map_surfacelight 200 // was 250

	{
		map textures/liquids/kc_fogcloud3.tga
		blendfunc gl_dst_color gl_zero
		tcmod scale -.05 -.05
		tcmod scroll .01 -.01
		rgbgen identity
	}
	{
		map textures/liquids/kc_fogcloud3.tga
		blendfunc gl_dst_color gl_zero
		tcmod scale .05 .05
		tcmod scroll .01 -.01
		rgbgen identity
	}
}

// Less Buldge For Spiny Under RL
textures/ssctf4/s_gkcspinemove
{
	qer_editorimage textures/gothic_block/gkc17d.tga
	tessSize 128
//	deformVertexes wave 100 sin 3 2 0 0.3
//	deformVertexes bulge 3 10 1
	deformVertexes bulge 3 2 1
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/gothic_block/gkc17d.tga
		blendFunc GL_DST_COLOR GL_SRC_ALPHA
		rgbGen identity
		alphaGen lightingSpecular
	}
	
}

// This variant is for greener light for blue base
textures/ssctf4/s_pentagram_light1_1K
{
	qer_editorimage textures/ssctf4/s_pentagram_light1.tga
	q3map_surfacelight 1000
	q3map_flare flareShader
	surfaceparm nomarks
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/ssctf4/s_pentagram_light1.tga
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
	{
		map textures/ssctf4/s_pentagram_light1_blend.tga
		blendfunc GL_ONE GL_ONE
		rgbGen wave sin .8 .2 0 1
	}
}
textures/ssctf4/s_pentagram_light1_2K
{
	qer_editorimage textures/ssctf4/s_pentagram_light1.tga
	q3map_surfacelight 2000
	q3map_flare flareShader
	surfaceparm nomarks
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/ssctf4/s_pentagram_light1.tga
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
	{
		map textures/ssctf4/s_pentagram_light1_blend.tga
		blendfunc GL_ONE GL_ONE
		rgbGen wave sin .8 .2 0 1
	}
}
textures/ssctf4/s_pentagram_light1_3K
{
	qer_editorimage textures/ssctf4/s_pentagram_light1.tga
	q3map_surfacelight 3000
	q3map_flare flareShader
	surfaceparm nomarks
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/ssctf4/s_pentagram_light1.tga
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
	{
		map textures/ssctf4/s_pentagram_light1_blend.tga
		blendfunc GL_ONE GL_ONE
		rgbGen wave sin .8 .2 0 1
	}
}
textures/ssctf4/s_pentagram_light1_4K
{
	qer_editorimage textures/ssctf4/s_pentagram_light1.tga
	q3map_surfacelight 4000
	q3map_flare flareShader
	surfaceparm nomarks
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/ssctf4/s_pentagram_light1.tga
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
	{
		map textures/ssctf4/s_pentagram_light1_blend.tga
		blendfunc GL_ONE GL_ONE
		rgbGen wave sin .8 .2 0 1
	}
}
textures/ssctf4/s_pentagram_light1_5K
{
	qer_editorimage textures/ssctf4/s_pentagram_light1.tga
	q3map_surfacelight 5000
	q3map_flare flareShader
	surfaceparm nomarks
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/ssctf4/s_pentagram_light1.tga
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
	{
		map textures/ssctf4/s_pentagram_light1_blend.tga
		blendfunc GL_ONE GL_ONE
		rgbGen wave sin .8 .2 0 1
	}
}
textures/ssctf4/s_pentagram_light1_10K
{
	qer_editorimage textures/ssctf4/s_pentagram_light1.tga
	q3map_surfacelight 10000
	q3map_flare flareShader
	surfaceparm nomarks
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/ssctf4/s_pentagram_light1.tga
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
	{
		map textures/ssctf4/s_pentagram_light1_blend.tga
		blendfunc GL_ONE GL_ONE
		rgbGen wave sin .8 .2 0 1
	}
}
textures/ssctf4/s_pentagram_light1_15K
{
	qer_editorimage textures/ssctf4/s_pentagram_light1.tga
	q3map_surfacelight 15000
	q3map_flare flareShader
	surfaceparm nomarks
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/ssctf4/s_pentagram_light1.tga
		blendFunc GL_DST_COLOR GL_ZERO
		rgbGen identity
	}
	{
		map textures/ssctf4/s_pentagram_light1_blend.tga
		blendfunc GL_ONE GL_ONE
		rgbGen wave sin .8 .2 0 1
	}
}

textures/ssctf4/s_redrustlit
{
	qer_editorimage textures/gothic_trim/pitted_rustred.tga
	q3map_lightimage textures/gothic_trim/pitted_rustred.tga
	q3map_surfacelight 200
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/gothic_trim/pitted_rustred.tga
		blendFunc GL_DST_COLOR GL_ZERO
	}
}


// no trans id shader
textures/ssctf4/metalsupport4b_notrans
{
	qer_editorimage textures/gothic_trim/metalsupport4b.tga
	{
		map $lightmap
		rgbGen identity
	
	}
	{
		map textures/gothic_trim/metalsupport4b.tga
		rgbGen identity
		blendFunc GL_DST_COLOR GL_ZERO

	
	}
}

// id's flame, new light value

textures/ssctf4/s_flameanim_red
{
	qer_editorimage textures/sfx/r_flame1.tga
	q3map_lightimage textures/sfx/r_flame3.tga
	surfaceparm trans
	surfaceparm nomarks
	surfaceparm nolightmap
	cull none
	q3map_surfacelight 400
	{
		animMap 10 textures/sfx/r_flame1.tga textures/sfx/r_flame2.tga textures/sfx/r_flame3.tga textures/sfx/r_flame4.tga textures/sfx/r_flame5.tga textures/sfx/r_flame6.tga textures/sfx/r_flame7.tga textures/sfx/r_flame8.tga
		blendFunc GL_ONE GL_ONE
		rgbGen wave inverseSawtooth 0 1 0 10
		
	}	
	{
		animMap 10 textures/sfx/r_flame2.tga textures/sfx/r_flame3.tga textures/sfx/r_flame4.tga textures/sfx/r_flame5.tga textures/sfx/r_flame6.tga textures/sfx/r_flame7.tga textures/sfx/r_flame8.tga textures/sfx/r_flame1.tga
		blendFunc GL_ONE GL_ONE
		rgbGen wave sawtooth 0 1 0 10
	}	
//	{
//		map textures/sfx/r_flameball.tga
//		blendFunc GL_ONE GL_ONE
//		rgbGen wave sin .6 .2 0 .6	
//	}
}


textures/ssctf4/s_flameanim_blue
{
	qer_editorimage textures/sfx/b_flame7.tga
	q3map_lightimage textures/ctf_q3w/b_flame7bright.tga				  
	surfaceparm trans
	surfaceparm nomarks
	surfaceparm nolightmap
	cull none
	q3map_surfacelight 400

	{
		animMap 10 textures/sfx/b_flame1.tga textures/sfx/b_flame2.tga textures/sfx/b_flame3.tga textures/sfx/b_flame4.tga textures/sfx/b_flame5.tga textures/sfx/b_flame6.tga textures/sfx/b_flame7.tga textures/sfx/b_flame8.tga
		blendFunc GL_ONE GL_ONE
		rgbGen wave inverseSawtooth 0 1 0 10
		
	}	
	{
		animMap 10 textures/sfx/b_flame2.tga textures/sfx/b_flame3.tga textures/sfx/b_flame4.tga textures/sfx/b_flame5.tga textures/sfx/b_flame6.tga textures/sfx/b_flame7.tga textures/sfx/b_flame8.tga textures/sfx/b_flame1.tga
		blendFunc GL_ONE GL_ONE
		rgbGen wave sawtooth 0 1 0 10
	}	
}

textures/ssctf4/s_skin
{
	qer_editorimage textures/skin/skin6.tga
	tessSize 128
//	deformVertexes wave 100 sin 4 3 0 0.3
	deformVertexes bulge 3 2 1
	surfaceparm nonsolid
	{
		map $lightmap
		rgbGen identity
	
	}
	{
		map textures/skin/skin6.tga
		rgbGen identity
		blendFunc GL_DST_COLOR GL_ZERO

	
	}
}
// no bulge
textures/ssctf4/s_skin_bulge
{
	qer_editorimage textures/skin/skin6.tga
	tessSize 128
//	surfaceparm nonsolid
// solid again 
	{
		map $lightmap
		rgbGen identity
	
	}
	{
		map textures/skin/skin6.tga
		blendFunc GL_DST_COLOR GL_SRC_ALPHA
		rgbGen identity
		alphaGen lightingSpecular
	}
}

// solid version
textures/ssctf4/s_pitted_rust3
{
	qer_editorimage textures/gothic_trim/pitted_rust3.tga
//	surfaceparm nonsolid
	{
		map $lightmap
		rgbGen identity
	
	}
	{
		map textures/gothic_trim/pitted_rust3.tga
		rgbGen identity
		blendFunc GL_DST_COLOR GL_ZERO
	}
}

textures/ssctf4/s_metal7_98
{
	surfaceparm nonsolid
	surfaceparm trans
	qer_editorimage textures/ssctf4/s_q1metal7_98.tga
	{
		map $lightmap
		rgbGen identity
	
	}
	{
		map textures/ssctf4/s_q1metal7_98.tga
		rgbGen identity
		blendFunc GL_DST_COLOR GL_ZERO
	}
}

// No Alpha Shadows so light looks less blotchy from fog
textures/ssctf4/s_proto_rustygrate
{
	surfaceparm	metalsteps	
	    surfaceparm trans	
	// surfaceparm alphashadow
	cull none
        nopicmip
	// A RUSTY GRATE OR GRILL THAT CAN BE SEEN FROM BOTH SIDES
	{
		map textures/ssctf4/s_proto_rustygrate.tga
		// tcMod scale 2 2
		blendFunc GL_ONE GL_ZERO
		alphaFunc GE128
		depthWrite
		rgbGen identity
	}
	{
		map $lightmap
		rgbGen identity
		blendFunc GL_DST_COLOR GL_ZERO
		depthFunc equal
	}
}

textures/ssctf4/s_proto_rustygrate2
{
	surfaceparm	metalsteps	
        surfaceparm trans	
//	surfaceparm alphashadow
	cull none
        nopicmip
	// A RUSTY GRATE OR GRILL THAT CAN BE SEEN FROM BOTH SIDES
	{
		map textures/ssctf4/s_proto_rustygrate2.tga
		// tcMod scale 2 2
		blendFunc GL_ONE GL_ZERO
		alphaFunc GE128
		depthWrite
		rgbGen identity
	}
	{
		map $lightmap
		rgbGen identity
		blendFunc GL_DST_COLOR GL_ZERO
		depthFunc equal
	}
}

textures/ssctf4/id_chain_rept
{
	surfaceparm trans
	surfaceparm nonsolid
	surfaceparm alphashadow
	cull none
	{
		map textures/ssctf4/id_chain_rept.tga
		alphafunc ge128
		depthwrite
		rgbgen identity
	}
	{
		map $lightmap
		rgbgen identity
		blendFunc gl_dst_color gl_zero
		depthFunc equal
	}
}

textures/ssctf4/s_scancode
{    
	surfaceparm nomarks   
	surfaceparm trans
	surfaceparm pointlight   
	{
		map textures/ssctf4/s_scancode.tga
                blendFunc add
		rgbGen vertex
	}
}

textures/ssctf4/radio_itg
{    
	surfaceparm nomarks   
	surfaceparm trans
	surfaceparm pointlight   
	{
		map textures/ssctf4/radio_itg.tga
                blendFunc add
		rgbGen vertex
	}
}
