//**********************************************************************//
//									//
//	stratosphere.shader for Q3Radiant				//
//	by Sock - 23rd November 2000					//
//									//
//**********************************************************************//

textures/pink_knot/stratosphere
{
	qer_editorimage textures/pink_knot/stratosphere/strat_view.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	q3map_globaltexture
	q3map_lightsubdivide 256
	q3map_surfacelight 50
	surfaceparm sky
	q3map_sun 0.941 0.984 1.00 150 270 45
	skyparms env/pink_knot/stratosphere/stratosphere - -
}


textures/pink_knot/glass
{
	qer_editorimage textures/pink_knot/effects/chrome4.tga
	surfaceparm trans
	cull disable
	qer_trans 0.5
	{
		map textures/pink_knot/effects/chrome4.tga
		blendfunc add
		tcGen environment
		tcmod scale 2 2
	}
}

textures/pink_knot/water
{
	qer_editorimage textures/pink_knot/effects/water2.tga
	q3map_globaltexture
	qer_trans .75
	surfaceparm trans
	surfaceparm nonsolid
	surfaceparm water
	surfaceparm nomarks
	surfaceparm nolightmap
	q3map_surfacelight 25
	cull none
	tesssize 64
	deformVertexes wave 64 sin 1 1 0.25 0.6
	{
		map textures/pink_knot/effects/water2.tga
		blendFunc GL_dst_color GL_one
		rgbgen identity
		tcmod scale .25 .25
		tcmod scroll .02 .01
	}
	{
		map textures/pink_knot/effects/water1.tga
		blendFunc GL_dst_color GL_one
		tcmod scale -.25 -.25
		tcmod scroll .02 .02
	}
	{
		map textures/pink_knot/effects/pooltint.tga
		blendFunc filter
		rgbgen identity
		tcmod scale .5 .5
		tcmod scroll .02 .01
	}
}

textures/pink_knot/waterflow
{
	qer_editorimage textures/pink_knot/effects/water2.tga
	q3map_globaltexture
	qer_trans .75
	surfaceparm trans
	surfaceparm nonsolid
	surfaceparm water
	surfaceparm nomarks
	surfaceparm nolightmap
	q3map_surfacelight 25
	cull none
	tesssize 64
	deformVertexes wave 64 sin 1 1 0.25 0.6
	{
		map textures/pink_knot/effects/water2.tga
		blendFunc GL_dst_color GL_one
		rgbgen identity
		tcmod scale .25 .25
		tcmod scroll .02 .01
	}
	{
		map textures/pink_knot/effects/water1.tga
		blendFunc GL_dst_color GL_one
		tcmod scale -.25 -.25
		tcmod scroll .02 .02
	}
	{
		map textures/pink_knot/effects/flow.tga
		blendFunc GL_dst_color GL_one
		tcmod scale .25 .25
		tcmod scroll .5 .0
	}
	{
		map textures/pink_knot/effects/pooltint.tga
		blendFunc filter
		rgbgen identity
		tcmod scale .5 .5
		tcmod scroll .02 .01
	}
}

textures/pink_knot/metal
{
	qer_editorimage textures/pink_knot/effects/metal.tga

	if deluxe
	{
		material textures/pink_knot/effects/metal.tga textures/pink_knot/effects/metal_norm.tga textures/pink_knot/effects/metal_gloss.tga
	}
	endif

	if ! deluxe
	{
		map $lightmap
	}
	{
		map $dlight
		blendFunc add
	}
	{
		map textures/pink_knot/effects/metal.tga
		blendFunc filter
	}
	endif
}

textures/pink_knot/floorpanels
{
   qer_editorimage textures/pink_knot/effects/floorpanels.tga
   q3map_globaltexture

   if deluxe
      {
         material textures/pink_knot/effects/floorpanels.tga textures/pink_knot/effects/floorpanels_norm.tga textures/pink_knot/effects/floorpanels_gloss.tga
      }
   endif

   if ! deluxe
      {
      		map $lightmap
      }
      {
		map $dlight
		blendfunc add
      }
   	{
		map textures/pink_knot/effects/floorpanels.tga
		blendfunc filter
      }
   endif
}

textures/pink_knot/floortiles
{
   qer_editorimage textures/pink_knot/effects/floortiles.tga
   q3map_globaltexture

   if deluxe
      {
         material textures/pink_knot/effects/floortiles.tga textures/pink_knot/effects/floortiles_norm.tga textures/pink_knot/effects/floortiles_gloss.tga
      }
   endif

   if ! deluxe
      {
      		map $lightmap
      }
      {
		map $dlight
		blendfunc add
      }
   	{
		map textures/pink_knot/effects/floortiles.tga
		blendfunc filter
      }
   endif
}
