//**********************************************************************//
//
//	simple.shader for Q3 by Sims
// Description : Simple stuff
//	Website : http://www.simonoc.com/
//
//**********************************************************************//
//

// ======================================================================
// Used inside skybox portal only on model
//
textures/silentrun/skyportal
{
	qer_editorimage textures/silentrun/env/alpine_up.jpg

	q3map_noFog
	q3map_globalTexture
	surfaceparm sky
	surfaceparm noimpact
	surfaceparm nolightmap
	skyparms textures/silentrun/env/alpine 1500 -
	nopicmip

	{
		map textures/silentrun/skybox_mask.tga
		blendFunc GL_ONE_MINUS_SRC_ALPHA GL_SRC_ALPHA
		tcMod transform 0.25 0 0 0.25 0.1075 0.1075
		rgbGen identityLighting
	}
}

// ======================================================================
// Used to link together the sky surface in the map and the portal sky
//
textures/silentrun/sky
{
	qer_editorimage textures/silentrun/alpine_view.jpg

	//red green blue intensity degrees elevation deviance samples
	// Slow - Final
	q3map_sunExt 1 1 .93 100 35 85 2 32
	q3map_skyLight 100 6

	q3map_noFog
	q3map_globalTexture
	surfaceparm sky
	surfaceparm noimpact
	surfaceparm nolightmap
	nopicmip
	// No texture needed, uses portal instead
	skyparms - - -
}

// ----------------------------------------------------------------------
textures/silentrun/skybox_fog
{
	surfaceparm trans
	surfaceparm nonsolid

	qer_alphaFunc gequal 0.5
	qer_trans 0.8
	cull none
	{
		map textures/silentrun/skybox_fog.tga
		blendFunc blend
		alphaGen vertex
   }
}

// ----------------------------------------------------------------------
textures/silentrun/skybox_fog_nodraw
{
	surfaceparm trans
	surfaceparm nonsolid
	surfaceparm nodraw

	qer_alphaFunc gequal 0.5
	qer_trans 0.8
}

// ======================================================================
// Glass
// ======================================================================
//
// ----------------------------------------------------------------------
textures/simple/glass_wire
{
	qer_editorimage textures/simple/glass_wire.tga
	qer_alphafunc greater 0.5
	surfaceparm trans
	surfaceparm nolightmap
	qer_trans 0.8

	{
		map textures/simple/glass_wire.tga
		blendFunc ADD
		rgbGen vertex
	}
	{
		map textures/simple/glass_gold.tga
		blendFunc BLEND
		tcmod scale .5 .5
		tcGen environment
	}
}

// ----------------------------------------------------------------------
textures/simple/glass_wire_solid
{
	qer_editorimage textures/simple/glass_wire_solid.tga
	qer_alphafunc greater 0.5
	surfaceparm trans
	qer_trans 0.8

	{
		map textures/simple/glass_wire.tga
		blendFunc GL_ONE GL_ZERO
		alphaFunc GE128
		depthWrite
		rgbGen identity
	}
	{
		map textures/simple/glass_gold.tga
		blendFunc BLEND
		tcmod scale .5 .5
		tcGen environment
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
		depthFunc equal
		rgbGen identity
	}
}

// ----------------------------------------------------------------------
// works like weapon clip

textures/simple/glass_impact
{
	surfaceparm nodraw
 	surfaceparm nolightmap
	surfaceparm trans
	surfaceparm nomarks
}

// ======================================================================
// Blue/Red Banners
// ======================================================================
//
// ----------------------------------------------------------------------
textures/simple/banner_blue
{
	tessSize 128
	deformVertexes wave 192 sin 0 2 0 .1
	deformVertexes normal .3 .2
	surfaceparm trans
	surfaceparm nonsolid
	surfaceparm nomarks
	surfaceparm alphashadow
	cull none
	
	{
		map textures/simple/banner_blue.tga
		rgbGen identity
	}
	{
		map textures/simple/banner_blue.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ONE_MINUS_DST_ALPHA
		rgbGen identity
	}
}

textures/simple/banner_red
{
	tessSize 128
	deformVertexes wave 192 sin 0 2 0 .1
	deformVertexes normal .3 .2
	surfaceparm trans
	surfaceparm nonsolid
	surfaceparm nomarks
	surfaceparm alphashadow
	cull none
	
	{
		map textures/simple/banner_red.tga
		rgbGen identity
	}
	{
		map textures/simple/banner_red.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen identity
	}
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ONE_MINUS_DST_ALPHA
		rgbGen identity
	}
}

// ======================================================================
// Blue/Red CTF Jumppads
// ======================================================================
//
// ----------------------------------------------------------------------
textures/simple/marker_jp_blue
{    
	surfaceparm nolightmap
	surfaceparm trans
	surfaceparm nonsolid
	surfaceparm nomarks
	polygonOffset
	nomipmaps
	qer_alphafunc greater 0.5
	qer_trans 0.9
   
	{
		map textures/simple/marker_jp_blue.tga
		blendFunc ADD
		rgbGen vertex
	}
	{
		clampMap textures/simple/swirl4_blue.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		tcMod rotate 45
		rgbGen wave sin 0.9 0.1 0.2 0.1
	}
	{
		clampMap textures/simple/swirl1_blue.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		tcMod rotate 180
		rgbGen const ( 0.75 1.0 0.25 )
		tcMod stretch sin 0.9 0.1 0 0.2
	}
}

// ----------------------------------------------------------------------
textures/simple/marker_jp_red
{    
	surfaceparm nolightmap
	surfaceparm trans
	surfaceparm nonsolid
	surfaceparm nomarks
	polygonOffset
	nomipmaps
	qer_alphafunc greater 0.5
	qer_trans 0.9
   
	{
		map textures/simple/marker_jp_red.tga
		blendFunc ADD
		rgbGen vertex
	}
	{
		clampMap textures/simple/swirl4_red.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		tcMod rotate 45
		rgbGen wave sin 0.9 0.1 0.2 0.1
	}
	{
		clampMap textures/simple/swirl1_red.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		tcMod rotate 180
		rgbGen const ( 0.75 1.0 0.25 )
		tcMod stretch sin 0.9 0.1 0 0.2
	}
}

// ----------------------------------------------------------------------
textures/simple/marker_jp_yellow
{    
	surfaceparm nolightmap
	surfaceparm trans
	surfaceparm nonsolid
	surfaceparm nomarks
	polygonOffset
	nomipmaps
	qer_alphafunc greater 0.5
	qer_trans 0.9
   
	{
		map textures/simple/marker_jp_yellow.tga
		blendFunc ADD
		rgbGen vertex
	}
	{
		clampMap textures/simple/swirl4_yellow.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		tcMod rotate 45
		rgbGen wave sin 0.9 0.1 0.2 0.1
	}
	{
		clampMap textures/simple/swirl1_yellow.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		tcMod rotate 180
		rgbGen const ( 0.75 1.0 0.25 )
		tcMod stretch sin 0.9 0.1 0 0.2
	}
}

// ======================================================================
// Surface Markers
// Weapons and Flag Base
// ======================================================================
//
// ----------------------------------------------------------------------
textures/simple/marker_weapon
{    
	surfaceparm nolightmap
	surfaceparm trans
	surfaceparm nonsolid
	surfaceparm nomarks
	polygonOffset
	nomipmaps
	qer_alphafunc greater 0.5
	qer_trans 0.9
   
	{
		map textures/simple/marker_weapon.tga
		blendFunc ADD
		rgbGen vertex
	}
	{
		clampMap textures/simple/swirl4_yellow.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		tcMod rotate 45
		rgbGen wave sin 0.9 0.1 0.2 0.1
		tcMod stretch sin 0.8 0.15 0 0.2
	}
	{
		clampMap textures/simple/swirl1_yellow.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		tcMod rotate 180
		rgbGen const ( 0.75 1.0 0.25 )
		tcMod stretch sin 0.7 0.1 0 0.1
	}
}

// ----------------------------------------------------------------------
textures/simple/marker_flag_blue
{
	surfaceparm nolightmap
	surfaceparm trans
	surfaceparm nonsolid
	surfaceparm nomarks
	polygonOffset
	nomipmaps
	qer_alphafunc greater 0.5
	qer_trans 0.9

	{
		map textures/simple/marker_flag_blue.tga
		blendFunc ADD
		rgbGen vertex
	}
	{
		clampMap textures/simple/swirl4_blue.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		tcMod rotate 45
		rgbGen wave sin 0.9 .1 .2 0.1
		tcMod stretch sin 0.7 0.1 0 .1
	}
	{
		clampMap textures/simple/swirl1_blue.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		tcMod rotate 180
		rgbGen const ( 0.75 1.0 0.25 )
		tcMod stretch sin 0.5 0.1 0 .05
	}
}

// ----------------------------------------------------------------------
textures/simple/marker_flag_red
{
	surfaceparm nolightmap
	surfaceparm trans
	surfaceparm nonsolid
	surfaceparm nomarks
	polygonOffset
	nomipmaps
	qer_alphafunc greater 0.5
	qer_trans 0.9

	{
		map textures/simple/marker_flag_red.tga
		blendFunc ADD
		rgbGen vertex
	}
	{
		clampMap textures/simple/swirl4_red.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		tcMod rotate 45
		rgbGen wave sin 0.9 .1 .2 0.1
		tcMod stretch sin 0.7 0.1 0 .1
	}
	{
		clampMap textures/simple/swirl1_red.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		tcMod rotate 180
		rgbGen const ( 0.75 1.0 0.25 )
		tcMod stretch sin 0.5 0.1 0 .05
	}
}

// ----------------------------------------------------------------------
textures/simple/marker_flag_yellow
{
	surfaceparm nolightmap
	surfaceparm trans
	surfaceparm nonsolid
	surfaceparm nomarks
	polygonOffset
	nomipmaps
	qer_alphafunc greater 0.5
	qer_trans 0.9

	{
		map textures/simple/marker_flag_yellow.tga
		blendFunc ADD
		rgbGen vertex
	}
	{
		clampMap textures/simple/swirl4_yellow.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		tcMod rotate 45
		rgbGen wave sin 0.9 .1 .2 0.1
		tcMod stretch sin 0.7 0.1 0 .1
	}
	{
		clampMap textures/simple/swirl1_yellow.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		tcMod rotate 180
		rgbGen const ( 0.75 1.0 0.25 )
		tcMod stretch sin 0.5 0.1 0 .05
	}
}

// ======================================================================
// Hong Phong Goodness
// ======================================================================
//
// ----------------------------------------------------------------------
textures/simple/trim_set1red_phong
{
	q3map_nonplanar
	q3map_shadeangle 90
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/simple/trim_set1red.tga
		blendFunc FILTER
	}
}

// ----------------------------------------------------------------------
textures/simple/trim_set1blue_phong
{
	q3map_nonplanar
	q3map_shadeangle 90
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/simple/trim_set1blue.tga
		blendFunc FILTER
	}
}

// ----------------------------------------------------------------------
textures/simple/generic_grey_phong
{
	q3map_nonplanar
	q3map_shadeangle 90
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/simple/generic_grey.tga
		blendFunc FILTER
	}
}

// ----------------------------------------------------------------------
textures/simple/generic_brown_phong
{
	q3map_nonplanar
	q3map_shadeangle 90
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/simple/generic_brown.tga
		blendFunc FILTER
	}
}

// ----------------------------------------------------------------------
textures/simple/generic_lightgrey
{
	q3map_nonplanar
	q3map_shadeangle 90
	{
		map $lightmap
		rgbGen identity
	}
	{
		map textures/simple/generic_lightgrey.tga
		blendFunc FILTER
	}
}

// ======================================================================
// alpha fade shaders
// (c) 2004 randy reddig
// http://www.shaderlab.com
// ======================================================================
// Only needed for compiling
//
textures/silentrun/alpha_000
{
	q3map_alphaMod volume
	q3map_alphaMod set 0
	surfaceparm nodraw
	surfaceparm nonsolid
	surfaceparm trans
	qer_trans 0.75
}

textures/silentrun/alpha_100
{
	q3map_alphaMod volume
	q3map_alphaMod set 1.0
	surfaceparm nodraw
	surfaceparm nonsolid
	surfaceparm trans
	qer_trans 0.75
}
