// DO NOT CHANGE or OVERWRITE THIS SHADER FILE!
// This shader files contains a master list of skies that have been used in
// iD Tech 3, Space Engine & Source engines. Duplicates & bad quality skies have been removed.
// Conatins +3700 custom skies.
// Shaders updated to use new q3map2 directives in favor of quality & realism.
// Direction, elevation, sun value & skylight checked & fixed on ALL shaders.
// Sun values match existing sun/moon/star/brightest point(s) in skybox texture.
// If no 'sun' in sky texture, q3map_sunExt is removed and replaced with higher
// q3map_skyLight 'amount'. Use r_drawSun "0" for best visuals.
// New root folder created 'skpk' to avoid conflicting textures.
// Shaders broken into sub-directories: skies_MASTER, _MASTER2, _MASTER3, _MASTER4, 
// _MASTER5 & _MASTER6 to avoid lengthy load times in radiant.
// Shaders grouped as best as possible. IE: most dynamic skies can be found in _MASTER6
// DO NOT CHANGE or OVERWRITE THIS SHADER FILE! Copy to your shader file, rename shader & adjust values as needed. 
//
//
// Switches used for testing: -meta -v; -light -fast -v
// Mappers config used for testing. Can be found on Trello.
//
// https://trello.com/b/zJp4pE3m/id-tech-3-mapping
// https://github.com/Garux/netradiant-custom
// https://defrag.racing/
// https://discord.q3df.run/
// http://ws.q3df.org/
// http://www.q3df.org/
// https://spaceengine.org/
//
// Shaders compiled, checked and fixed by: Ghost & FM rev. August 15, 2022.
// 
// Skies generated in Space Egnine are NOT to be used commercially.
// DO NOT CHANGE or OVERWRITE THIS SHADER FILE!

textures/skies_MASTER/ame_ash
{
	qer_editorImage skpk/qer/env/ame_ash/ashcanyon.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt .7 .8 1 90 270 33 2 16     //r g b intensity degree elevation deviance samples
	q3map_LightMapFilterRadius 0 8          //self other
//	q3map_skylight 50 4 0 90 1              //amount iterations horizon_min horizon_max sample_color
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/ame_ash/ashcanyon - -
}

textures/skies_MASTER/ame_ash-clouds
{
	qer_editorImage skpk/qer/env/ame_ash/ashcanyon-clouds.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 0.965 75 270 33 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/ame_ash/ashcanyon - -
	{
		map skpk/env/ame_darkgloom/clouds.tga
		blendFunc filter
		tcMod scroll 0.010 0.005
		tcMod scale 2 2
	}
}

textures/skies_MASTER/ame_bluefreeze
{
	qer_editorImage skpk/qer/env/ame_bluefreeze/bluefreeze.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt .7 .8 1 90 0 20 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/ame_bluefreeze/bluefreeze - -
}

textures/skies_MASTER/ame_cotton
{
	qer_editorImage skpk/qer/env/ame_cotton/cottoncandy.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 .8 .7 100 270 8 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/ame_cotton/cottoncandy - -
}

textures/skies_MASTER/ame_darkgloom
{
	qer_editorImage skpk/qer/env/ame_darkgloom/darkgloom-clouds.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt .934 0.835 1.00 25 330 25 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/ame_darkgloom/darkgloom - -
	{
		map skpk/env/ame_darkgloom/clouds.tga
		blendFunc filter
		tcMod scroll 0.005 0.005
		tcMod scale 3 3
	}
}

textures/skies_MASTER/ame_desert
{
	qer_editorImage skpk/qer/env/ame_desert/desertsky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt .934 .835 1 75 210 35 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/ame_desert/desertsky - -
}

textures/skies_MASTER/ame_emerald
{
	qer_editorImage skpk/qer/env/ame_emerald/emeraldfog.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt .8 1 .9 75 0 31 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/ame_emerald/emeraldfog - -
}

textures/skies_MASTER/ame_fade
{
	qer_editorImage skpk/qer/env/ame_fade/fadeaway.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 .9 75 90 30 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/ame_fade/fadeaway - -
}

textures/skies_MASTER/ame_fade-clouds
{
	qer_editorImage skpk/qer/env/ame_fade/fadeaway-clouds.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 .9 75 90 30 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/ame_fade/fadeaway - -
	{
		map skpk/env/ame_darkgloom/clouds.tga
		blendFunc filter
		tcMod scroll 0.005 0.005
		tcMod scale 3 3
	}
}

textures/skies_MASTER/ame_flatrock
{
	qer_editorImage skpk/qer/env/ame_flatrock/flatrock.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 70 161 81 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/ame_flatrock/flatrock - -
}

textures/skies_MASTER/ame_frozen
{
	qer_editorImage skpk/qer/env/ame_frozen/frozen.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt .9 .8 1 75 179 29 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/ame_frozen/frozen - -
}

textures/skies_MASTER/ame_greenhaze
{
	qer_editorImage skpk/qer/env/ame_greenhaze/greenhaze.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt .834 1 .862 75 -29 10 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 60 4
	nopicmip
	skyparms skpk/env/ame_greenhaze/greenhaze - -
}

textures/skies_MASTER/ame_greywash
{
	qer_editorImage skpk/qer/env/ame_greywash/greywash.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 70 90 25 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/ame_greywash/greywash - -
}

textures/skies_MASTER/ame_iceflats
{
	qer_editorImage skpk/qer/env/ame_iceflats/iceflats.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt .95 .9 1 100 270 25 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/ame_iceflats/iceflats - -
}

textures/skies_MASTER/ame_leather
{
	qer_editorImage skpk/qer/env/ame_leather/leatherduster.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 .9 .8 115 270 40 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/ame_leather/leatherduster - -
}

textures/skies_MASTER/ame_lilac
{
	qer_editorImage skpk/qer/env/ame_lilac/lilacisles.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt .95 .95 1 115 180 18 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/ame_lilac/lilacisles - -
}

textures/skies_MASTER/ame_limon
{
	qer_editorImage skpk/qer/env/ame_limon/limon.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt .9 1 .8 115 180 75 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/ame_limon/limon - -
}

textures/skies_MASTER/ame_majesty
{
	qer_editorImage skpk/qer/env/ame_majesty/majesty.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 .9 1 100 270 35 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/ame_majesty/majesty - -
}

textures/skies_MASTER/ame_mudskip
{
	qer_editorImage skpk/qer/env/ame_mudskip/mudskipper.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 .7 .6 80 0 28 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/ame_mudskip/mudskipper - -
}

textures/skies_MASTER/ame_nebula
{
	qer_editorImage skpk/qer/env/ame_nebula/purplenebula.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/ame_nebula/purplenebula - -
}

textures/skies_MASTER/ame_oasis
{
	qer_editorImage skpk/qer/env/ame_oasis/oasisnight.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 .95 .8 40 270 17 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 30 4
	nopicmip
	skyparms skpk/env/ame_oasis/oasisnight - -
}

textures/skies_MASTER/ame_powder
{
	qer_editorImage skpk/qer/env/ame_powder/powderpeak.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt .934 .835 1 90 -107 11 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/ame_powder/powderpeak - -
}

textures/skies_MASTER/ame_purple
{
	qer_editorImage skpk/qer/env/ame_purple/purplevalley.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 .965 75 180 35 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/ame_purple/purplevalley - -
}

textures/skies_MASTER/ame_purple-clouds
{
	qer_editorImage skpk/qer/env/ame_purple/purplevalley-clouds.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 .965 75 180 35 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/ame_purple/purplevalley - -
	{
		map skpk/env/ame_darkgloom/clouds.tga
		blendFunc filter
		tcMod scroll 0.010 0.010
		tcMod scale 1 1
	}
}

textures/skies_MASTER/ame_rapture
{
	qer_editorImage skpk/qer/env/ame_rapture/rapture.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 .9 .8 115 163 12.5 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/ame_rapture/rapture - -
}

textures/skies_MASTER/ame_redplanet
{
	qer_editorImage skpk/qer/env/ame_redplanet/redplanet.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 .835 .72 75 0 30 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/ame_redplanet/redplanet - -
}

textures/skies_MASTER/ame_redplanet-clouds
{
	qer_editorImage skpk/qer/env/ame_redplanet/redplanet-clouds.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 .835 .72 75 0 30 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/ame_redplanet/redplanet - -
	{
		map skpk/env/ame_darkgloom/clouds.tga
		blendFunc filter
		tcMod scroll 0.005 0.005
		tcMod scale 3 3
	}
}

textures/skies_MASTER/ame_rocky
{
	qer_editorImage skpk/qer/env/ame_rocky/rockyvalley.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 .965 75 270 30 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/ame_rocky/rockyvalley - -
}

textures/skies_MASTER/ame_rocky-clouds
{
	qer_editorImage skpk/qer/env/ame_rocky/rockyvalley-clouds.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 .965 75 270 30 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/ame_rocky/rockyvalley - -
	{
		map skpk/env/ame_darkgloom/clouds.tga
		blendFunc filter
		tcMod scroll 0.010 0.005
		tcMod scale 2 2
	}
}

textures/skies_MASTER/ame_shadow
{
	qer_editorImage skpk/qer/env/ame_shadow/shadowpeak.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 100 0 35 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 80 4
	nopicmip
	skyparms skpk/env/ame_shadow/shadowpeak - -
}

textures/skies_MASTER/ame_siege
{
	qer_editorImage skpk/qer/env/ame_siege/siege.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 .965 75 330 24 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/ame_siege/siege - -
}

textures/skies_MASTER/ame_snowy
{
	qer_editorImage skpk/qer/env/ame_snowy/snowy.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt .9 .95 1 75 180 25 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/ame_snowy/snowy - -
}

textures/skies_MASTER/ame_starfield
{
	qer_editorImage skpk/qer/env/ame_starfield/starfield.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/ame_starfield/starfield - -
}

textures/skies_MASTER/ame_water
{
	qer_editorImage skpk/qer/env/ame_water/underwater1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/ame_water/underwater1 - -
}

textures/skies_MASTER/arctic
{
	qer_editorImage skpk/qer/env/arctic/arctic.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 .8 .8 75 290 16 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/arctic/arctic - -
}

textures/skies_MASTER/kothic_arrakisday
{
	qer_editorImage skpk/qer/env/arrakisday/arrakisday.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 .9 .9 100 170 50 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/arrakisday/arrakisday - -
}

textures/skies_MASTER/darkskies
{
	qer_editorImage skpk/qer/env/darkskies/darkskies.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 150 4
	nopicmip
	skyparms skpk/env/darkskies/darkskies - -
}

textures/skies_MASTER/ely_cloudtop
{
	qer_editorImage skpk/qer/env/ely_cloudtop/cloudtop.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 100 106 16 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/ely_cloudtop/cloudtop - -
}

textures/skies_MASTER/ely_darkcity
{
	qer_editorImage skpk/qer/env/ely_darkcity/darkcity.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/ely_darkcity/darkcity - -
}

textures/skies_MASTER/ely_hills
{
	qer_editorImage skpk/qer/env/ely_hills/hills.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 100 21 23 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/ely_hills/hills - -
}

textures/skies_MASTER/ely_hills2
{
	qer_editorImage skpk/qer/env/ely_hills2/hills2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 10 157 29 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/ely_hills2/hills2 - -
}

textures/skies_MASTER/ely_lakes
{
	qer_editorImage skpk/qer/env/ely_lakes/lakes.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 100 29 15 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/ely_lakes/lakes - -
}

textures/skies_MASTER/ely_mountain
{
	qer_editorImage skpk/qer/env/ely_mountain/mountain.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 60 337 34 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/ely_mountain/mountain - -
}

textures/skies_MASTER/ely_nevada
{
	qer_editorImage skpk/qer/env/ely_nevada/nevada.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 60 98 31 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/ely_nevada/nevada - -
}

textures/skies_MASTER/ely_peaks
{
	qer_editorImage skpk/qer/env/ely_peaks/peaks.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 40 23 39 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 80 4
	nopicmip
	skyparms skpk/env/ely_peaks/peaks - -
}

textures/skies_MASTER/ely_snow
{
	qer_editorImage skpk/qer/env/ely_snow/snow.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 5 280 32 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/ely_snow/snow - -
}

textures/skies_MASTER/ely_sunset
{
	qer_editorImage skpk/qer/env/ely_sunset/sunset.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 .7 .7 80 350 10 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/ely_sunset/sunset - -
}

textures/skies_MASTER/hip_grimm
{
	qer_editorImage skpk/qer/env/hip_grimm/grimmnight.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 40 341 22 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/hip_grimm/grimmnight - -
}

textures/skies_MASTER/hip_inter
{
	qer_editorImage skpk/qer/env/hip_inter/interstellar.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_sunExt 1 1 1 80 340 49 11 16
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/hip_inter/interstellar - -
}

textures/skies_MASTER/hip_miramar
{
	qer_editorImage skpk/qer/env/hip_miramar/miramar.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 70 -37 55 3 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/hip_miramar/miramar - -
}

textures/skies_MASTER/hip_stormy
{
	qer_editorImage skpk/qer/env/hip_stormy/stormydays.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 100 225 40 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/hip_stormy/stormydays - -
}

textures/skies_MASTER/hip_violent
{
	qer_editorImage skpk/qer/env/hip_violent/violentdays.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 100 315 40 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/hip_violent/violentdays - -
}

textures/skies_MASTER/hw_alps
{
	qer_editorImage skpk/qer/env/hw_alps/alps.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 100 250 38 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/hw_alps/alps - -
}

textures/skies_MASTER/hw_arctic
{
	qer_editorImage skpk/qer/env/hw_arctic/arctic.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 100 240 42 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/hw_arctic/arctic - -
}

textures/skies_MASTER/hw_blue
{
	qer_editorImage skpk/qer/env/hw_blue/blue.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 100 90 5 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/hw_blue/blue - -
}

textures/skies_MASTER/hw_canyon
{
	qer_editorImage skpk/qer/env/hw_canyon/canyon.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 100 225 30 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/hw_canyon/canyon - -
}

textures/skies_MASTER/hw_city
{
	qer_editorImage skpk/qer/env/hw_city/city.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.927291 0.79202 0.402258 70 40 15 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 75 4
	nopicmip
	skyparms skpk/env/hw_city/city - -
}

textures/skies_MASTER/hw_crater
{
	qer_editorImage skpk/qer/env/hw_crater/craterlake.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 100 90 46 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/hw_crater/craterlake - -
}

textures/skies_MASTER/hw_deepsea
{
	qer_editorImage skpk/qer/env/hw_deepsea/underwater.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 100 0 90 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/hw_deepsea/underwater - -
}

textures/skies_MASTER/hw_desertnight
{
	qer_editorImage skpk/qer/env/hw_desertnight/desert_night.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 100 104 31 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/hw_desertnight/desert_night - -
}

textures/skies_MASTER/hw_entropic
{
	qer_editorImage skpk/qer/env/hw_entropic/entropic.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 100 4
	nopicmip
	skyparms skpk/env/hw_entropic/entropic - -
}

textures/skies_MASTER/hw_glacier
{
	qer_editorImage skpk/qer/env/hw_glacier/glacier.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 100 177 26 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/hw_glacier/glacier - -
}

textures/skies_MASTER/hw_green
{
	qer_editorImage skpk/qer/env/hw_green/green.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 100 110 25 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/hw_green/green - -
}

textures/skies_MASTER/hw_hourglass
{
	qer_editorImage skpk/qer/env/hw_hourglass/hourglass.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 100 180 27 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/hw_hourglass/hourglass - -
}

textures/skies_MASTER/hw_jungle
{
	qer_editorImage skpk/qer/env/hw_jungle/jungle.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 100 106 11 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/hw_jungle/jungle - -
}

textures/skies_MASTER/hw_lagoon
{
	qer_editorImage skpk/qer/env/hw_lagoon/lagoon.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 100 310 19 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/hw_lagoon/lagoon - -
}

textures/skies_MASTER/hw_lunar
{
	qer_editorImage skpk/qer/env/hw_lunar/lunar.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 77 4
	nopicmip
	skyparms skpk/env/hw_lunar/lunar - -
}

textures/skies_MASTER/hw_morning
{
	qer_editorImage skpk/qer/env/hw_morning/morning.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 100 110 15 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/hw_morning/morning - -
}

textures/skies_MASTER/hw_mystic
{
	qer_editorImage skpk/qer/env/hw_mystic/mystic.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 100 48 25 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/hw_mystic/mystic - -
}

textures/skies_MASTER/hw_nightsky
{
	qer_editorImage skpk/qer/env/hw_nightsky/nightsky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 100 223 33 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/hw_nightsky/nightsky - -
}

textures/skies_MASTER/hw_red
{
	qer_editorImage skpk/qer/env/hw_red/red.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 130 4
	nopicmip
	skyparms skpk/env/hw_red/red - -
}

textures/skies_MASTER/hw_ruins
{
	qer_editorImage skpk/qer/env/hw_ruins/ruins.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 60 -30 30 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 95 4
	nopicmip
	skyparms skpk/env/hw_ruins/ruins - -
}

textures/skies_MASTER/hw_sahara
{
	qer_editorImage skpk/qer/env/hw_sahara/sahara.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 100 270 18 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/hw_sahara/sahara - -
}

textures/skies_MASTER/hw_sandstorm
{
	qer_editorImage skpk/qer/env/hw_sandstorm/sandstorm.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.967605 0.954314 0.608972 100 150 32 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/hw_sandstorm/sandstorm - -
}

textures/skies_MASTER/hw_spires
{
	qer_editorImage skpk/qer/env/hw_spires/spires.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 100 235 35 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/hw_spires/spires - -
}

textures/skies_MASTER/hw_thunder
{
	qer_editorImage skpk/qer/env/hw_thunder/thunder.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 100 242 20 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/hw_thunder/thunder - -
}

textures/skies_MASTER/icyhell
{
	qer_editorImage skpk/qer/env/icyhell/icyhell.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt .8 .8 .8 100 40 35 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/icyhell/icyhell - -
}

textures/skies_MASTER/jaj_cannons
{
	qer_editorImage skpk/qer/env/jaj_cannons/jajcannons1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt .75 .75 .6 60 337 33 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 40 4
	nopicmip
	skyparms skpk/env/jaj_cannons/jajcannons1 - -
}

textures/skies_MASTER/jajlake1
{
	qer_editorImage skpk/qer/env/jajlake1/jajlake1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_sunExt 1.00 0.9 0.85 90 330 23 7 16
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/jajlake1/jajlake1 - -
}

textures/skies_MASTER/jajlake2
{
	qer_editorImage skpk/qer/env/jajlake2/jajlake2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt .65 .8 .9 50 330 25 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/jajlake2/jajlake2 - -
}

textures/skies_MASTER/jaj_lands2
{
	qer_editorImage skpk/qer/env/jaj_lands/jajlands2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt .7 .85 .6 90 330 30 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/jaj_lands/jajlands2 - -
}

textures/skies_MASTER/jaj_snow
{
	qer_editorImage skpk/qer/env/jaj_snow/jajsnow1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt .6 .75 .92 25 320 6 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 60 4
	nopicmip
	skyparms skpk/env/jaj_snow/jajsnow1 - -
}

textures/skies_MASTER/jaj_sundown
{
	qer_editorImage skpk/qer/env/jaj_sundown/jajsundown1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt .9 .7 .6 60 310 15 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/jaj_sundown/jajsundown1 - -
}

textures/skies_MASTER/jf_nuke
{
	qer_editorImage skpk/qer/env/jf_nuke/nuke.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 10 135 70 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 80 4
	nopicmip
	skyparms skpk/env/jf_nuke/nuke - -
}

textures/skies_MASTER/jf_nuke2
{
	qer_editorImage skpk/qer/env/jf_nuke/nuke2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 10 135 70 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 80 4
	nopicmip
	skyparms skpk/env/jf_nuke/nuke2 - -
}

textures/skies_MASTER/jf_plague
{
	qer_editorImage skpk/qer/env/jf_plague/plague.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/jf_plague/plague - -
}

textures/skies_MASTER/jf_plague-flare
{
	qer_editorImage skpk/qer/env/jf_plague/flareplague512.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 255 250 230 50 0 90 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/jf_plague/flareplague512 - -
}

textures/skies_MASTER/lmcity
{
	qer_editorImage skpk/qer/env/lmcity/lmcity.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 30 0 90 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 60 4
	nopicmip
	skyparms skpk/env/lmcity/lmcity - -
}

textures/skies_MASTER/misty
{
	qer_editorImage skpk/qer/env/misty/misty.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 30 331 25 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/misty/misty - -
}

textures/skies_MASTER/mnight
{
	qer_editorImage skpk/qer/env/mnight/mnight.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 15 180 22 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 60 4
	nopicmip
	skyparms skpk/env/mnight/mnight - -
}

textures/skies_MASTER/morose
{
	qer_editorImage skpk/qer/env/morose/morose.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt .3 .4 .65 10 185 57 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/morose/morose - -
}

textures/skies_MASTER/mp_5dim
{
	qer_editorImage skpk/qer/env/mp_5dim/5dim.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 50 180 0 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/mp_5dim/5dim - -
}

textures/skies_MASTER/mp_ac
{
	qer_editorImage skpk/qer/env/mp_ac/ac.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt .8 .8 1 70 100 9 2 16  //blue star
	q3map_sunExt 1 .8 .8 70 -93 12 2 16 //red star
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/mp_ac/ac - -
}

textures/skies_MASTER/mp_ae
{
	qer_editorImage skpk/qer/env/mp_ae/ae.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 125 4
	nopicmip
	skyparms skpk/env/mp_ae/ae - -
}

textures/skies_MASTER/mp_aft
{
	qer_editorImage skpk/qer/env/mp_aft/aft.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 15 135 25 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 60 4
	nopicmip
	skyparms skpk/env/mp_aft/aft - -
}

textures/skies_MASTER/mp_alpha
{
	qer_editorImage skpk/qer/env/mp_alpha/alpha-island.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 15 272 40 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/mp_alpha/alpha-island - -
}

textures/skies_MASTER/mp_amh
{
	qer_editorImage skpk/qer/env/mp_amh/amh.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 5 210 30 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/mp_amh/amh - -
}

textures/skies_MASTER/mp_arctic
{
	qer_editorImage skpk/qer/env/mp_arctic/arctic-ice.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 5 315 25 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/mp_arctic/arctic-ice - -
}

textures/skies_MASTER/mp_asbestos
{
	qer_editorImage skpk/qer/env/mp_asbestos/asbestos-gorge.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 20 240 33 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/mp_asbestos/asbestos-gorge - -
}

textures/skies_MASTER/mp_awup
{
	qer_editorImage skpk/qer/env/mp_awup/awup.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/mp_awup/awup - -
}

textures/skies_MASTER/mp_ayden
{
	qer_editorImage skpk/qer/env/mp_ayden/ayden.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 .7 70 280 60 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/mp_ayden/ayden - -
}

textures/skies_MASTER/mp_badlands
{
	qer_editorImage skpk/qer/env/mp_badlands/badlands.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/mp_badlands/badlands - -
}

textures/skies_MASTER/mp_badomen
{
	qer_editorImage skpk/qer/env/mp_badomen/badomen.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 .6 .8 50 -25 5 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/mp_badomen/badomen - -
}

textures/skies_MASTER/mp_blackgold
{
	qer_editorImage skpk/qer/env/mp_blackgold/blackgold.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 80 4
	nopicmip
	skyparms skpk/env/mp_blackgold/blackgold - -
}

textures/skies_MASTER/mp_bleak
{
	qer_editorImage skpk/qer/env/mp_bleak/bleak-outlook.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 80 283 11 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/mp_bleak/bleak-outlook - -
}

textures/skies_MASTER/mp_chill-blizzard
{
	qer_editorImage skpk/qer/env/mp_blizzard/blizzard.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 75 4
	nopicmip
	skyparms skpk/env/mp_blizzard/blizzard - -
}

textures/skies_MASTER/mp_blood
{
	qer_editorImage skpk/qer/env/mp_blood/blood.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 00.985 0.010 0 90 20 18 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/mp_blood/blood - -
}

textures/skies_MASTER/mp_bloodgorge
{
	qer_editorImage skpk/qer/env/mp_bloodgorge/blood-stain-gorge.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 40 35 40 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 60 4
	nopicmip
	skyparms skpk/env/mp_bloodgorge/blood-stain-gorge - -
}

textures/skies_MASTER/mp_bloodvalley
{
	qer_editorImage skpk/qer/env/mp_bloodvalley/blood-valley.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 15 225 35 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 60 4
	nopicmip
	skyparms skpk/env/mp_bloodvalley/blood-valley - -
}

textures/skies_MASTER/mp_sandtrap-bluemoon
{
	qer_editorImage skpk/qer/env/mp_bluemoon/bluemoon.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 15 0 90 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 80 4
	nopicmip
	skyparms skpk/env/mp_bluemoon/bluemoon - -
}

textures/skies_MASTER/mp_boulder
{
	qer_editorImage skpk/qer/env/mp_boulder/boulder-bay.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 50 315 44 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/mp_boulder/boulder-bay - -
}

textures/skies_MASTER/mp_bromene
{
	qer_editorImage skpk/qer/env/mp_bromene/bromene-bay.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 60 350 70 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/mp_bromene/bromene-bay - -
}

textures/skies_MASTER/mp_carbon
{
	qer_editorImage skpk/qer/env/mp_carbon/carbon-creek.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 100 260 35 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/mp_carbon/carbon-creek - -
}

textures/skies_MASTER/mp_cc
{
	qer_editorImage skpk/qer/env/mp_cc/cc.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/mp_cc/cc - -
}

textures/skies_MASTER/mp_chlorine
{
	qer_editorImage skpk/qer/env/mp_chlorine/chlorine-bay.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.987 1 0.816 80 96 35 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/mp_chlorine/chlorine-bay - -
}

textures/skies_MASTER/mp_classm
{
	qer_editorImage skpk/qer/env/mp_classm/classmplanet.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 80 0 62 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/mp_classm/classmplanet - -
}

textures/skies_MASTER/mp_cloud9
{
	qer_editorImage skpk/qer/env/mp_cloud9/cloud9.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/mp_cloud9/cloud9 - -
}

textures/skies_MASTER/mp_coward
{
	qer_editorImage skpk/qer/env/mp_coward/coward-cove.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.997 0.893 0.168 20 -48 5 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/mp_coward/coward-cove - -
}

textures/skies_MASTER/mp_cp
{
	qer_editorImage skpk/qer/env/mp_cp/cp.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 90 4
	nopicmip
	skyparms skpk/env/mp_cp/cp - -
}

textures/skies_MASTER/mp_crimelem
{
	qer_editorImage skpk/qer/env/mp_crimelem/criminal-element.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 70 20 50 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/mp_crimelem/criminal-element - -
}

textures/skies_MASTER/mp_crimimpact
{
	qer_editorImage skpk/qer/env/mp_crimimpact/criminal-impact.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 70 80 60 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/mp_crimimpact/criminal-impact - -
}

textures/skies_MASTER/mp_crimintent
{
	qer_editorImage skpk/qer/env/mp_crimintent/criminal-intentions.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 80 4
	nopicmip
	skyparms skpk/env/mp_crimintent/criminal-intentions - -
}

textures/skies_MASTER/mp_crimmind
{
	qer_editorImage skpk/qer/env/mp_crimmind/criminalmind.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.835294 0.823529 0.921569 40 8 20 2 16                    //blue
	q3map_sunExt 0.960784 0.709804 0.407843 40 -51 45 2 16                  //orange
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 65 4
	nopicmip
	skyparms skpk/env/mp_crimmind/criminalmind - -
}

textures/skies_MASTER/mp_crimson
{
	qer_editorImage skpk/qer/env/mp_crimson/crimson-tide.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 90 4
	nopicmip
	skyparms skpk/env/mp_crimson/crimson-tide - -
}

textures/skies_MASTER/mp_cupertin
{
	qer_editorImage skpk/qer/env/mp_cupertin/cupertin-lake.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 0.77 0 90 300 32 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/mp_cupertin/cupertin-lake - -
}

textures/skies_MASTER/mp_cybtech
{
	qer_editorImage skpk/qer/env/mp_cybtech/cybortech.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt .894 .933 1 50 215 60 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/mp_cybtech/cybortech - -
}

textures/skies_MASTER/mp_cyclone
{
	qer_editorImage skpk/qer/env/mp_cyclone/cyclone-island.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 10 81 13 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 90 4
	nopicmip
	skyparms skpk/env/mp_cyclone/cyclone-island - -
}

textures/skies_MASTER/mp_dab
{
	qer_editorImage skpk/qer/env/mp_dab/day-at-the-beach.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 15 33 35 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 60 4
	nopicmip
	skyparms skpk/env/mp_dab/day-at-the-beach - -
}

textures/skies_MASTER/mp_deception
{
	qer_editorImage skpk/qer/env/mp_deception/deception_pass.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 90 4
	nopicmip
	skyparms skpk/env/mp_deception/deception_pass - -
}

textures/skies_MASTER/mp_dejavu
{
	qer_editorImage skpk/qer/env/mp_dejavu/dejavu.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 140 4
	nopicmip
	skyparms skpk/env/mp_dejavu/dejavu - -
}

textures/skies_MASTER/mp_delirious
{
	qer_editorImage skpk/qer/env/mp_delirious/delirious.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 5 300 25 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 90 4
	nopicmip
	skyparms skpk/env/mp_delirious/delirious - -
}

textures/skies_MASTER/mp_depression
{
	qer_editorImage skpk/qer/env/mp_depression/depression-pass.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 90 4
	nopicmip
	skyparms skpk/env/mp_depression/depression-pass - -
}

textures/skies_MASTER/mp_deviladv
{
	qer_editorImage skpk/qer/env/mp_deviladv/devils_advocate.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 0.77 0 30 -50 14 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 65 4
	nopicmip
	skyparms skpk/env/mp_deviladv/devils_advocate - -
}

textures/skies_MASTER/mp_deviltooth
{
	qer_editorImage skpk/qer/env/mp_deviltooth/devils-tooth.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 .5 0 45 75 2 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 110 4
	nopicmip
	skyparms skpk/env/mp_deviltooth/devils-tooth - -
}

textures/skies_MASTER/mp_di
{
	qer_editorImage skpk/qer/env/mp_di/di.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 80 4
	nopicmip
	skyparms skpk/env/mp_di/di - -
}

textures/skies_MASTER/mp_dispair
{
	qer_editorImage skpk/qer/env/mp_dispair/dispair-ridge.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 50 225 24 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/mp_dispair/dispair-ridge - -
}

textures/skies_MASTER/mp_dot
{
	qer_editorImage skpk/qer/env/mp_dot/dawn-of-time.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 70 66 30 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/mp_dot/dawn-of-time - -
}

textures/skies_MASTER/mp_downunder
{
	qer_editorImage skpk/qer/env/mp_downunder/down-under.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/mp_downunder/down-under - -
}

textures/skies_MASTER/mp_drakeq
{
	qer_editorImage skpk/qer/env/mp_drakeq/drakeq.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 90 0 22 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/mp_drakeq/drakeq - -
}

textures/skies_MASTER/mp_druidcove
{
	qer_editorImage skpk/qer/env/mp_druidcove/druidcove.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 90 4
	nopicmip
	skyparms skpk/env/mp_druidcove/druidcove - -
}

textures/skies_MASTER/mp_ec
{
	qer_editorImage skpk/qer/env/mp_ec/ec.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 90 4
	nopicmip
	skyparms skpk/env/mp_ec/ec - -
}

textures/skies_MASTER/mp_elemental
{
	qer_editorImage skpk/qer/env/mp_elemental/elemental.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 90 4
	nopicmip
	skyparms skpk/env/mp_elemental/elemental - -
}

textures/skies_MASTER/mp_emerald
{
	qer_editorImage skpk/qer/env/mp_emerald/emerald-summit.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 15 130 30 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 80 4
	nopicmip
	skyparms skpk/env/mp_emerald/emerald-summit - -
}

textures/skies_MASTER/mp_fcih
{
	qer_editorImage skpk/qer/env/mp_fcih/fat-chance-in-hell.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 140 4
	nopicmip
	skyparms skpk/env/mp_fcih/fat-chance-in-hell - -
}

textures/skies_MASTER/mp_chill-firestorm
{
	qer_editorImage skpk/qer/env/mp_firestorm/fire-storm.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.981659 0.595483 0.404242 25 -80 14 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 110 4
	nopicmip
	skyparms skpk/env/mp_firestorm/fire-storm - -
}

textures/skies_MASTER/mp_gatekeeper
{
	qer_editorImage skpk/qer/env/mp_gatekeeper/gatekeeper.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 90 45 0 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/mp_gatekeeper/gatekeeper - -
}

textures/skies_MASTER/mp_goldrush
{
	qer_editorImage skpk/qer/env/mp_goldrush/goldrush.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 .8 70 200 60 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/mp_goldrush/goldrush - -
}

textures/skies_MASTER/mp_gritty
{
	qer_editorImage skpk/qer/env/mp_gritty/gritty-residue.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 20 260 20 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 60 4
	nopicmip
	skyparms skpk/env/mp_gritty/gritty-residue - -
}

textures/skies_MASTER/mp_habitual
{
	qer_editorImage skpk/qer/env/mp_habitual/habitual-pain.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/mp_habitual/habitual-pain - -
}

textures/skies_MASTER/mp_hallowed
{
	qer_editorImage skpk/qer/env/mp_hallowed/hg.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/mp_hallowed/hg - -
}

textures/skies_MASTER/mp_chill-hanging
{
	qer_editorImage skpk/qer/env/mp_hanging/hangingstone.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 80 4
	nopicmip
	skyparms skpk/env/mp_hanging/hangingstone - -
}

textures/skies_MASTER/mp_heresy
{
	qer_editorImage skpk/qer/env/mp_heresy/bloody-heresy.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 50 135 17 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/mp_heresy/bloody-heresy - -
}

textures/skies_MASTER/mp_hexagon
{
	qer_editorImage skpk/qer/env/mp_hexagon/hexagon.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 0.84 0.57 50 320 45 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/mp_hexagon/hexagon - -
}

textures/skies_MASTER/mp_impaler
{
	qer_editorImage skpk/qer/env/mp_impaler/impaler-point.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 30 60 36 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/mp_impaler/impaler-point - -
}

textures/skies_MASTER/mp_jasper
{
	qer_editorImage skpk/qer/env/mp_jasper/jaspercoast.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 10 90 50 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/mp_jasper/jaspercoast - -
}

textures/skies_MASTER/mp_mainframe
{
	qer_editorImage skpk/qer/env/mp_mainframe/mainframe.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 70 150 45 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/mp_mainframe/mainframe - -
}

textures/skies_MASTER/mp_majestic
{
	qer_editorImage skpk/qer/env/mp_majestic/majestic.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 .9 80 -77 19 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/mp_majestic/majestic - -
}

textures/skies_MASTER/mp_mandaris
{
	qer_editorImage skpk/qer/env/mp_mandaris/mandaris.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 0.893 0 90 253 -8 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/mp_mandaris/mandaris - -
}

textures/skies_MASTER/mp_marvelous
{
	qer_editorImage skpk/qer/env/mp_marvelous/bloody-marvelous.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 20 306 15 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 60 4
	nopicmip
	skyparms skpk/env/mp_marvelous/bloody-marvelous - -
}

textures/skies_MASTER/mp_mercury
{
	qer_editorImage skpk/qer/env/mp_mercury/mercury.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 0.215 0 100 0 90 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/mp_mercury/mercury - -
}

textures/skies_MASTER/mp_met
{
	qer_editorImage skpk/qer/env/mp_met/met.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 80 4
	nopicmip
	skyparms skpk/env/mp_met/met - -
}

textures/skies_MASTER/mp_midnight
{
	qer_editorImage skpk/qer/env/mp_midnight/midnight-silence.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 80 4
	nopicmip
	skyparms skpk/env/mp_midnight/midnight-silence - -
}

textures/skies_MASTER/mp_mistylake
{
	qer_editorImage skpk/qer/env/mp_mistylake/mistylake.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 80 4
	nopicmip
	skyparms skpk/env/mp_mistylake/mistylake - -
}

textures/skies_MASTER/mp_moondust
{
	qer_editorImage skpk/qer/env/mp_moondust/moondust512.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 100 4
	nopicmip
	skyparms skpk/env/mp_moondust/moondust512 - -
}

textures/skies_MASTER/mp_moondust-flare
{
	qer_editorImage skpk/qer/env/mp_moondust/moondust-lf512.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 80 175 33 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/mp_moondust/moondust-lf512 - -
}

textures/skies_MASTER/mp_moonwaw
{
	qer_editorImage skpk/qer/env/mp_moonwaw/moonwaw.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 90 298 30 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/mp_moonwaw/moonwaw - -
}

textures/skies_MASTER/mp_morningdew
{
	qer_editorImage skpk/qer/env/mp_morningdew/morningdew.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 80 4
	nopicmip
	skyparms skpk/env/mp_morningdew/morningdew - -
}

textures/skies_MASTER/mp_murderbay
{
	qer_editorImage skpk/qer/env/mp_murderbay/murder-bay.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 80 4
	nopicmip
	skyparms skpk/env/mp_murderbay/murder-bay - -
}

textures/skies_MASTER/mp_nightwalk1
{
	qer_editorImage skpk/qer/env/mp_nightwalk1/nightwalker-ftd.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 80 4
	nopicmip
	skyparms skpk/env/mp_nightwalk1/nightwalker-ftd - -
}

textures/skies_MASTER/mp_nightwalk2
{
	qer_editorImage skpk/qer/env/mp_nightwalk2/nightwalker-id.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 10 77 18 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 60 4
	nopicmip
	skyparms skpk/env/mp_nightwalk2/nightwalker-id - -
}

textures/skies_MASTER/mp_nordic
{
	qer_editorImage skpk/qer/env/mp_nordic/nordic-pass.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 .6 0 20 90 20 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/mp_nordic/nordic-pass - -
}

textures/skies_MASTER/mp_normandy
{
	qer_editorImage skpk/qer/env/mp_normandy/normandy.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/mp_normandy/normandy - -
}

textures/skies_MASTER/mp_northlight
{
	qer_editorImage skpk/qer/env/mp_northlight/northlight.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 80 4
	nopicmip
	skyparms skpk/env/mp_northlight/northlight - -
}

textures/skies_MASTER/mp_nottingham
{
	qer_editorImage skpk/qer/env/mp_nottingham/nottingham.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 80 4
	nopicmip
	skyparms skpk/env/mp_nottingham/nottingham - -
}

textures/skies_MASTER/mp_nwo
{
	qer_editorImage skpk/qer/env/mp_nwo/nwo.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 100 4
	nopicmip
	skyparms skpk/env/mp_nwo/nwo - -
}

textures/skies_MASTER/mp_omega
{
	qer_editorImage skpk/qer/env/mp_omega/omega.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 90 4
	nopicmip
	skyparms skpk/env/mp_omega/omega - -
}

textures/skies_MASTER/mp_orbital
{
	qer_editorImage skpk/qer/env/mp_orbital/orbital-element.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 100 4
	nopicmip
	skyparms skpk/env/mp_orbital/orbital-element - -
}

textures/skies_MASTER/mp_organic
{
	qer_editorImage skpk/qer/env/mp_organic/organic.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 15 59 15 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 80 4
	nopicmip
	skyparms skpk/env/mp_organic/organic - -
}

textures/skies_MASTER/mp_overrated
{
	qer_editorImage skpk/qer/env/mp_overrated/highly-overrated.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 20 36 22 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 60 4
	nopicmip
	skyparms skpk/env/mp_overrated/highly-overrated - -
}

textures/skies_MASTER/mp_patrol
{
	qer_editorImage skpk/qer/env/mp_patrol/patrol.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 90 4
	nopicmip
	skyparms skpk/env/mp_patrol/patrol - -
}

textures/skies_MASTER/mp_pd
{
	qer_editorImage skpk/qer/env/mp_pd/painteddst.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 100 4
	nopicmip
	skyparms skpk/env/mp_pd/painteddst - -
}

textures/skies_MASTER/mp_perdicus
{
	qer_editorImage skpk/qer/env/mp_perdicus/perdicus.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt .7 .8 1 90 3 61 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/mp_perdicus/perdicus - -
}

textures/skies_MASTER/mp_petesoasis
{
	qer_editorImage skpk/qer/env/mp_petesoasis/petesoasis.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 90 4
	nopicmip
	skyparms skpk/env/mp_petesoasis/petesoasis - -
}

textures/skies_MASTER/mp_plains
{
	qer_editorImage skpk/qer/env/mp_plains/plains-of-abraham.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 10 123 15 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/mp_plains/plains-of-abraham - -
}

textures/skies_MASTER/mp_po
{
	qer_editorImage skpk/qer/env/mp_po/po.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 5 -107 80 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/mp_po/po - -
}

textures/skies_MASTER/mp_poc
{
	qer_editorImage skpk/qer/env/mp_poc/point-of-contention.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 100 4
	nopicmip
	skyparms skpk/env/mp_poc/point-of-contention - -
}

textures/skies_MASTER/mp_portal
{
	qer_editorImage skpk/qer/env/mp_portal/portal.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.999847 0.746365 0.407065 70 268 9 3 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/mp_portal/portal - -
}

textures/skies_MASTER/mp_pr
{
	qer_editorImage skpk/qer/env/mp_pr/pr.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 80 4
	nopicmip
	skyparms skpk/env/mp_pr/pr - -
}

textures/skies_MASTER/mp_problem
{
	qer_editorImage skpk/qer/env/mp_problem/problem-child.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 100 4
	nopicmip
	skyparms skpk/env/mp_problem/problem-child - -
}

textures/skies_MASTER/mp_progress
{
	qer_editorImage skpk/qer/env/mp_progress/progress.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 90 4
	nopicmip
	skyparms skpk/env/mp_progress/progress - -
}

textures/skies_MASTER/mp_rainforest
{
	qer_editorImage skpk/qer/env/mp_rainforest/rainforest.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 10 38 65 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyparms skpk/env/mp_rainforest/rainforest - -
}

textures/skies_MASTER/mp_rip
{
	qer_editorImage skpk/qer/env/mp_rip/rip.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 90 4
	nopicmip
	skyparms skpk/env/mp_rip/rip - -
}

textures/skies_MASTER/mp_rubycr
{
	qer_editorImage skpk/qer/env/mp_rubycr/rubycreek.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 60 325 48 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/mp_rubycr/rubycreek - -
}

textures/skies_MASTER/mp_ryegel7
{
	qer_editorImage skpk/qer/env/mp_ryegel7/ryegel7.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyparms skpk/env/mp_ryegel7/ryegel7 - -
}

textures/skies_MASTER/mp_sandcastle
{
	qer_editorImage skpk/qer/env/mp_sandcastle/sandcastle.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 95 4
	nopicmip
	skyparms skpk/env/mp_sandcastle/sandcastle - -
}

textures/skies_MASTER/mp_sandtrap
{
	qer_editorImage skpk/qer/env/mp_sandtrap/sandtrap.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 60 340 22 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/mp_sandtrap/sandtrap - -
}

textures/skies_MASTER/mp_sc
{
	qer_editorImage skpk/qer/env/mp_sc/sc.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 100 4
	nopicmip
	skyparms skpk/env/mp_sc/sc - -
}

textures/skies_MASTER/mp_seeingred
{
	qer_editorImage skpk/qer/env/mp_seeingred/seeingred.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 140 4
	nopicmip
	skyparms skpk/env/mp_seeingred/seeingred - -
}

textures/skies_MASTER/mp_sep
{
	qer_editorImage skpk/qer/env/mp_sep/sep.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 .42 0 40 80 25 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/mp_sep/sep - -
}

textures/skies_MASTER/mp_sincity
{
	qer_editorImage skpk/qer/env/mp_sincity/sincity.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 80 4
	nopicmip
	skyparms skpk/env/mp_sincity/sincity - -
}

textures/skies_MASTER/mp_sist
{
	qer_editorImage skpk/qer/env/mp_sist/sist.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyparms skpk/env/mp_sist/sist - -
}

textures/skies_MASTER/mp_sorbin
{
	qer_editorImage skpk/qer/env/mp_sorbin/sorbin.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 .9 .8 90 40 75 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/mp_sorbin/sorbin - -
}

textures/skies_MASTER/mp_ss
{
	qer_editorImage skpk/qer/env/mp_ss/ss.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 100 4
	nopicmip
	skyparms skpk/env/mp_ss/ss - -
}

textures/skies_MASTER/mp_subzero
{
	qer_editorImage skpk/qer/env/mp_subzero/subzero.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 20 140 50 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/mp_subzero/subzero - -
}

textures/skies_MASTER/mp_st
{
	qer_editorImage skpk/qer/env/mp_st/st.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 90 4
	nopicmip
	skyparms skpk/env/mp_st/st - -
}

textures/skies_MASTER/mp_tf
{
	qer_editorImage skpk/qer/env/mp_tf/thefog.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 0.953 0.722 30 0 90 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/mp_tf/thefog - -
}

textures/skies_MASTER/mp_tidepool
{
	qer_editorImage skpk/qer/env/mp_tidepool/tidepool.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 10 -92 11 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 75 4
	nopicmip
	skyparms skpk/env/mp_tidepool/tidepool - -
}

textures/skies_MASTER/mp_titan
{
	qer_editorImage skpk/qer/env/mp_titan/titan.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/mp_titan/titan - -
}

textures/skies_MASTER/mp_toh
{
	qer_editorImage skpk/qer/env/mp_toh/toh.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 0.36 0.013 70 117 58 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/mp_toh/toh - -
}

textures/skies_MASTER/mp_totality
{
	qer_editorImage skpk/qer/env/mp_totality/totality.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 5 350 40 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 90 4
	nopicmip
	skyparms skpk/env/mp_totality/totality - -
}

textures/skies_MASTER/mp_troubled
{
	qer_editorImage skpk/qer/env/mp_troubled/troubled-waters.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 20 315 60 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/mp_troubled/troubled-waters - -
}

textures/skies_MASTER/mp_trueblue
{
	qer_editorImage skpk/qer/env/mp_trueblue/trueblue.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 20 -79 28 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 85 4
	nopicmip
	skyparms skpk/env/mp_trueblue/trueblue - -
}

textures/skies_MASTER/mp_ultar
{
	qer_editorImage skpk/qer/env/mp_ultar/ultar.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 90 4
	nopicmip
	skyparms skpk/env/mp_ultar/ultar - -
}

textures/skies_MASTER/mp_us
{
	qer_editorImage skpk/qer/env/mp_us/urbansp.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 .3 .1 60 0 90 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 60 4
	nopicmip
	skyparms skpk/env/mp_us/urbansp - -
}

textures/skies_MASTER/mp_utc
{
	qer_editorImage skpk/qer/env/mp_utc/up-the-creek.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.846 1 0.366 80 350 25 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/mp_utc/up-the-creek - -
}

textures/skies_MASTER/mp_utopia
{
	qer_editorImage skpk/qer/env/mp_utopia/utopiaatoll.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 80 4
	nopicmip
	skyparms skpk/env/mp_utopia/utopiaatoll - -
}

textures/skies_MASTER/mp_velcor
{
	qer_editorImage skpk/qer/env/mp_velcor/velcor.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 90 4
	nopicmip
	skyparms skpk/env/mp_velcor/velcor - -
}

textures/skies_MASTER/mp_vendetta
{
	qer_editorImage skpk/qer/env/mp_vendetta/vendetta-cove.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 50 40 27 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 60 4
	nopicmip
	skyparms skpk/env/mp_vendetta/vendetta-cove - -
}

textures/skies_MASTER/mp_vod
{
	qer_editorImage skpk/qer/env/mp_vod/valley-of-the-dead.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 80 4
	nopicmip
	skyparms skpk/env/mp_vod/valley-of-the-dead - -
}

textures/skies_MASTER/mp_vr
{
	qer_editorImage skpk/qer/env/mp_vr/vr.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.566 1 0.959 80 1 2 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/mp_vr/vr - -
}

textures/skies_MASTER/mp_wcamp
{
	qer_editorImage skpk/qer/env/mp_wcamp/wkcamp.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 .53 0 100 40 10 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 75 4
	nopicmip
	skyparms skpk/env/mp_wcamp/wkcamp - -
}

textures/skies_MASTER/mp_whirlpool
{
	qer_editorImage skpk/qer/env/mp_whirlpool/whirlpool.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt .7 .7 1 25 0 90 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/mp_whirlpool/whirlpool - -
}

textures/skies_MASTER/mp_chill-solstice
{
	qer_editorImage skpk/qer/env/mp_winsol/winter-solstice.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 0.839 0 40 271 10 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/mp_winsol/winter-solstice - -
}

textures/skies_MASTER/mp_wisdom
{
	qer_editorImage skpk/qer/env/mp_wisdom/conventional-wisdom.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 90 4
	nopicmip
	skyparms skpk/env/mp_wisdom/conventional-wisdom - -
}

textures/skies_MASTER/mp_yukon
{
	qer_editorImage skpk/qer/env/mp_yukon/yukongold.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 20 -93 11 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/mp_yukon/yukongold - -
}

textures/skies_MASTER3/muad_spire
{
	qer_editorImage skpk/qer/env/muad_spire/spire.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 100 4
	nopicmip
	skyparms skpk/env/muad_spire/spire - -
}

textures/skies_MASTER3/muad_stormy
{
	qer_editorImage skpk/qer/env/muad_stormy/stormy.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 25 350 70 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 65 4
	nopicmip
	skyparms skpk/env/muad_stormy/stormy - -
}

textures/skies_MASTER/nec_city
{
	qer_editorImage skpk/qer/env/nec_city/city.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 30 119 67 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/nec_city/city - -
}

textures/skies_MASTER/nec_hell
{
	qer_editorImage skpk/qer/env/nec_hell/hell.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/nec_hell/hell - -
}

textures/skies_MASTER/nec_night
{
	qer_editorImage skpk/qer/env/nec_night/night.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 5 0 90 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/nec_night/night - -
}

textures/skies_MASTER/rockq3
{
	qer_editorImage skpk/qer/env/rockq3/rockq3.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 5 0 90 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/rockq3/rockq3 - -
}

textures/skies_MASTER/sb_desert
{
	qer_editorImage skpk/qer/env/sb_desert/desert.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 .95 .977 80 200 50 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/sb_desert/desert - -
}

textures/skies_MASTER/sb_devilpunch
{
	qer_editorImage skpk/qer/env/sb_devilpunch/devpun.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt .6 .6 .6 60 135 70 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/sb_devilpunch/devpun - -
}

textures/skies_MASTER/sb_emerald
{
	qer_editorImage skpk/qer/env/sb_emerald/emerald.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt .6 .6 .6 60 140 70 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/sb_emerald/emerald - -
}

textures/skies_MASTER/sb_frozen
{
	qer_editorImage skpk/qer/env/sb_frozen/frozen.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 227 237 254 80 55 49 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/sb_frozen/frozen - -
}

textures/skies_MASTER/sb_frozendusk
{
	qer_editorImage skpk/qer/env/sb_frozendusk/frozendusk.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 0.84 0 85 250 20 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/sb_frozendusk/frozendusk - -
}

textures/skies_MASTER/sb_graveyard
{
	qer_editorImage skpk/qer/env/sb_graveyard/grave.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt .934 .956 1 15 0 50 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/sb_graveyard/grave - -
}

textures/skies_MASTER/sb_iceflow
{
	qer_editorImage skpk/qer/env/sb_iceflow/iceflow.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt .884 .94 1 85 -32 39 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/sb_iceflow/iceflow - -
}

textures/skies_MASTER/sb_mars
{
	qer_editorImage skpk/qer/env/sb_mars/mars.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 .9 .9 75 135 50 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/sb_mars/mars - -
}

textures/skies_MASTER/sb_nightball
{
	qer_editorImage skpk/qer/env/sb_nightball/nightball.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt .851 .945 1 15 310 45 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/sb_nightball/nightball - -
}

textures/skies_MASTER/sb_strato
{
	qer_editorImage skpk/qer/env/sb_strato/stratosphere.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.941 0.984 1.00 85 270 50 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/sb_strato/stratosphere - -
}

textures/skies_MASTER/ame_siege_clouds
{
	qer_editorImage skpk/qer/env/ame_siege/siege-clouds.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 .965 75 330 24 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/ame_siege/siege - -
	{
		map skpk/env/ame_darkgloom/clouds.tga
		blendFunc filter
		tcMod scroll 0.005 0.005
		tcMod scale 2 2
	}
}

textures/skies_MASTER/sor_alien
{
	qer_editorImage skpk/qer/env/sor_alien/alien.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt .8 1 .8 45 270 40 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/sor_alien/alien - -
}

textures/skies_MASTER/sor_beach
{
	qer_editorImage skpk/qer/env/sor_beach/beach.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 255 245 235 20 65 5 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 60 4
	nopicmip
	skyparms skpk/env/sor_beach/beach - -
}

textures/skies_MASTER/sor_borg
{
	qer_editorImage skpk/qer/env/sor_borg/borg.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 60 150 73 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/sor_borg/borg - -
}

textures/skies_MASTER/sor_cwd
{
	qer_editorImage skpk/qer/env/sor_cwd/cwd.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 60 50 76 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/sor_cwd/cwd - -
}

textures/skies_MASTER/sor_hills
{
	qer_editorImage skpk/qer/env/sor_hills/hills.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 85 4
	nopicmip
	skyparms skpk/env/sor_hills/hills - -
}

textures/skies_MASTER/sor_lake1
{
	qer_editorImage skpk/qer/env/sor_lake1/lake1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 80 57 20 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/sor_lake1/lake1 - -
}

textures/skies_MASTER/sor_lake2
{
	qer_editorImage skpk/qer/env/sor_lake2/lake2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 80 60 22 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/sor_lake2/lake2 - -
}

textures/skies_MASTER/sor_land
{
	qer_editorImage skpk/qer/env/sor_land/land.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 80 270 25 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/sor_land/land - -
}

textures/skies_MASTER/sor_mars
{
	qer_editorImage skpk/qer/env/sor_mars/mars.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 80 0 50 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/sor_mars/mars - -
}

textures/skies_MASTER/sor_sea
{
	qer_editorImage skpk/qer/env/sor_sea/sea.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 0 20 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/sor_sea/sea - -
}

textures/skies_MASTER/stonegods
{
	qer_editorImage skpk/qer/env/stonegods/sgod.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt .8 .8 .8 50 350 28 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/stonegods/sgod - -
}

textures/skies_MASTER/sky_12
{
	qer_editorImage skpk/qer/env/sky_12/sky12.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt .8 .6 .5 45 -155 12 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/sky_12/sky12 - -
}

textures/skies_MASTER/sky_33
{
	qer_editorImage skpk/qer/env/sky_33/sky33.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt .5 .8 .9 50 270 10 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/sky_33/sky33 - -
}

textures/skies_MASTER/sky_34
{
	qer_editorImage skpk/qer/env/sky_34/sky34.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 .9 80 270 45 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/sky_34/sky34 - -
}

textures/skies_MASTER/sky_38
{
	qer_editorImage skpk/qer/env/sky_38/sky38.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 35 -46 67 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/sky_38/sky38 - -
}

textures/skies_MASTER/sky_50
{
	qer_editorImage skpk/qer/env/sky_50/sky50.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0 0.626 1 65 270 1 1 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/sky_50/sky50 - -
}

textures/skies_MASTER/asteroid
{
	qer_editorImage skpk/qer/env/asteroid_sky/asteroids.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 0.6875 0.375 90 25 47 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/asteroid_sky/asteroids - -
}

textures/skies_MASTER/jf_asteroid
{
	qer_editorImage skpk/qer/env/jf_asteroid/astr.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 .98 .9 35 -89 19 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 110 4
	nopicmip
	skyparms skpk/env/jf_asteroid/astr - -
}

textures/skies_MASTER/kothic_ares
{
	qer_editorImage skpk/qer/env/ares/ares.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 45 235 135 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 130 4
	nopicmip
	skyparms skpk/env/ares/ares - -
}

textures/skies_MASTER/kothic_atsea
{
	qer_editorImage skpk/qer/env/atsea/atsea.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 40 0 62 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 95 4
	nopicmip
	skyparms skpk/env/atsea/atsea - -
}

textures/skies_MASTER/kothic_bloodline
{
	qer_editorImage skpk/qer/env/bloodline/bloodline.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 .5 .4 10 0 90 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 130 4
	nopicmip
	skyparms skpk/env/bloodline/bloodline - -
}

textures/skies_MASTER/kothic_brightblue
{
	qer_editorImage skpk/qer/env/brightblue/brightblue.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 100 350 77 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 150 4
	nopicmip
	skyparms skpk/env/brightblue/brightblue - -
}

textures/skies_MASTER/boxtim1
{
	qer_editorImage skpk/qer/env/boxtim1/boxtim1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 32 270 31 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/boxtim1/boxtim1 - -
}

textures/skies_MASTER/kothic_intheclouds
{
	qer_editorImage skpk/qer/env/intheclouds/intheclouds.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 50 240 25 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 110 4
	nopicmip
	skyparms skpk/env/intheclouds/intheclouds - -
}

textures/skies_MASTER2/bug2_skybox
{
	qer_editorImage skpk/qer/env/bug2/skybox.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt .5 .37 .19 155 300 14 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 130 4
	nopicmip
	skyparms skpk/env/bug2/skybox - -
}

textures/skies_MASTER2/bug4_skybox
{
	qer_editorImage skpk/qer/env/bug4/skybox.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt .95 .5 .44 50 171 6 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 95 4
	nopicmip
	skyparms skpk/env/bug4/skybox - -
}

textures/skies_MASTER2/bug7_skybox
{
	qer_editorImage skpk/qer/env/bug7/skybox.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt .98 .5 .44 40 315 10 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 25 4
	nopicmip
	skyparms skpk/env/bug7/skybox - -
}

textures/skies_MASTER/bug_blackrockchimneys
{
	qer_editorImage skpk/qer/env/bug_blackrockchimneys/blackrockchimneys.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt .93 .945 .91 30 0 90 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 25 4
	nopicmip
	skyparms skpk/env/bug_blackrockchimneys/blackrockchimneys - -
}

textures/skies_MASTER/bug_walakpabay
{
	qer_editorImage skpk/qer/env/bug_walakpabay/walakpabay.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt .99 .97 .8 40 275 8 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 25 4
	nopicmip
	skyparms skpk/env/bug_walakpabay/walakpabay - -
}

textures/skies_MASTER2/arcsky2
{
	qer_editorImage skpk/qer/env/arcsky/arcsky2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 100 0 70 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 120 4
	nopicmip
	skyparms skpk/env/arcsky/arcsky2 - -
}

textures/skies_MASTER/kothic_captivation-blue
{
	qer_editorImage skpk/qer/env/captivation-blue/captivation-blue.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 130 4
	nopicmip
	skyparms skpk/env/captivation-blue/captivation-blue - -
}

textures/skies_MASTER/kothic_captivation-red
{
	qer_editorImage skpk/qer/env/captivation-red/captivation-red.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 130 4
	nopicmip
	skyparms skpk/env/captivation-red/captivation-red - -
}

textures/skies_MASTER/chiroptera
{
	qer_editorImage skpk/qer/env/chiroptera/chiroptera.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt .89 .929 .99 20 320 32 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/chiroptera/chiroptera - -
}

textures/skies_MASTER2/danight
{
	qer_editorImage skpk/qer/env/danight/danight.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt .5 .37 .19 30 267 7 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 20 4
	nopicmip
	skyparms skpk/env/danight/danight - -
}

textures/skies_MASTER/kothic_deepblue
{
	qer_editorImage skpk/qer/env/deepblue/deepblue.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 22 0 90 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 166 4
	nopicmip
	skyparms skpk/env/deepblue/deepblue - -
}

textures/skies_MASTER/kothic_dragonfire
{
	qer_editorImage skpk/qer/env/dragonfire/dragonfire.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 .8 .7 99 358 35 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 166 4
	nopicmip
	skyparms skpk/env/dragonfire/dragonfire - -
}

textures/skies_MASTER/kothic_dragonheart
{
	qer_editorImage skpk/qer/env/dragonheart/dragonheart.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 .9 .8 66 290 35 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 111 4
	nopicmip
	skyparms skpk/env/dragonheart/dragonheart - -
}

textures/skies_MASTER3/giger-hive-dark
{
	qer_editorImage skpk/qer/env/hive/hive.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 100 4
	nopicmip
	skyparms skpk/env/hive/hive 720 -
}

textures/skies_MASTER/kothic_dragonmoon
{
	qer_editorImage skpk/qer/env/dragonmoon/dragonmoon.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 88 0 90 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 150 4
	nopicmip
	skyparms skpk/env/dragonmoon/dragonmoon - -
}

textures/skies_MASTER/kothic_dragonmoon-clouds
{
	qer_editorImage skpk/qer/env/dragonmoon/dragonmoon-clouds.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 88 0 90 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 150 4
	nopicmip
	skyparms skpk/env/dragonmoon/dragonmoon - -
	{
		map skpk/textures/skies/dragonclouds.tga
		blendFunc GL_ONE GL_ONE
		tcMod scale 3 3
		tcMod scroll 0.01 0.02
	}
}

textures/skies_MASTER/kothic_dragonvale
{
	qer_editorImage skpk/qer/env/dragonvale/dragonvale.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 .9 .7 60 290 35 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 120 4
	nopicmip
	skyparms skpk/env/dragonvale/dragonvale - -
}

textures/skies_MASTER/dss_arcania
{
	qer_editorImage skpk/qer/env/dss_arcania/dss_arcania.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt .8 .9 1 50 180 30 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 75 4
	nopicmip
	skyParms skpk/env/dss_arcania/dss_arcania - -
}

textures/skies_MASTER/dss_canyon2
{
	qer_editorImage skpk/qer/env/dss_canyon2/dss_canyon2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 123 270 25 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 150 4
	nopicmip
	skyParms skpk/env/dss_canyon2/dss_canyon2 - -
}

textures/skies_MASTER/dss_iceworld2
{
	qer_editorImage skpk/qer/env/dss_iceworld2/dss_iceworld2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt .6 .95 .99 85 270 10 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 75 4
	nopicmip
	skyParms skpk/env/dss_iceworld2/dss_iceworld2 - -
}

textures/skies_MASTER/dustball
{
	qer_editorImage skpk/qer/env/dustball/dustball.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 .82 .733 75 320 40 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 75 4
	nopicmip
	skyparms skpk/env/dustball/dustball - -
}

textures/skies_MASTER/egyptsunset
{
	qer_editorImage skpk/qer/env/egypt-sunset/eg.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt .8 .8 .8 90 90 11 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/egypt-sunset/eg - -
}

textures/skies_MASTER/elbrus
{
	qer_editorImage skpk/qer/env/elbrus/elbrus.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt .8 .75 .55 50 36 66 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 85 4
	nopicmip
	skyparms skpk/env/elbrus/elbrus - -
}

textures/skies_MASTER/kothic_dunes
{
	qer_editorImage skpk/qer/env/dunes/dunes.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 90 100 40 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 75 4
	nopicmip
	skyparms skpk/env/dunes/dunes - -
}

textures/skies_MASTER/kothic_dust
{
	qer_editorImage skpk/qer/env/dust/dust.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.698039 0.654902 0.54902 80 260 50 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 75 4
	nopicmip
	skyparms skpk/env/dust/dust - -
}

textures/skies_MASTER/kothic_labyrinthus
{
	qer_editorImage skpk/qer/env/labyrinthus/labyrinthus.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.74902 0.607843 0.439216 80 155 75 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 75 4
	nopicmip
	skyparms skpk/env/labyrinthus/labyrinthus - -
}

textures/skies_MASTER/kothic_shol
{
	qer_editorImage skpk/qer/env/shol/shol.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 20 0 90 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 65 4
	nopicmip
	skyparms skpk/env/shol/shol - -
}

textures/skies_MASTER/kothic_shol-clouds
{
	qer_editorImage skpk/qer/env/shol/shol-clouds.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 20 0 90 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 65 4
	nopicmip
	skyparms skpk/env/shol/shol - -
	{
		map skpk/textures/skies/sholclouds.tga
		blendfunc add
		tcMod scale 2 2
		tcMod scroll 0.02 0.02
	}
}

textures/skies_MASTER/kothic_med-amour
{
	qer_editorImage skpk/qer/env/med-amour/med-amour.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 15 80 65 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 60 4
	nopicmip
	skyparms skpk/env/med-amour/med-amour - -
}

textures/skies_MASTER/kothic_med-siesta
{
	qer_editorImage skpk/qer/env/med-siesta/med-siesta.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 70 45 54 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/med-siesta/med-siesta - -
}

textures/skies_MASTER/kothic_wakeworld
{
	qer_editorImage skpk/qer/env/wakeworld/wakeworld.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_sunExt 1 1 1 50 -169 43 5 16
	q3map_skylight 80 4
	nopicmip
	skyparms skpk/env/wakeworld/wakeworld - -
}

textures/skies_MASTER/kothic_whitecrispness
{
	qer_editorImage skpk/qer/env/whitecrispness/whitecrispness.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 50 7 30 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/whitecrispness/whitecrispness - -
}

textures/skies_MASTER/kothic_mensae
{
	qer_editorImage skpk/qer/env/mensae/mensae.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 0.750607 0.384497 45 82 24 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/mensae/mensae - -
}

textures/skies_MASTER/kothic_kradegar
{
	qer_editorImage skpk/qer/env/kradegar/kradegar.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 20 10 45 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/kradegar/kradegar - -
}

textures/skies_MASTER/kothic_duske
{
	qer_editorImage skpk/qer/env/duske/duske.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.996078 0.827451 0.517647 70 1 17 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 75 4
	nopicmip
	skyparms skpk/env/duske/duske - -
}

textures/skies_MASTER/kothic_grassland
{
	qer_editorImage skpk/qer/env/grassland/grassland.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 70 59 39 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/grassland/grassland - -
}

textures/skies_MASTER/kothic_eaglesdare
{
	qer_editorImage skpk/qer/env/eaglesdare/eaglesdare.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 122 73 25 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 88 4
	nopicmip
	skyparms skpk/env/eaglesdare/eaglesdare - -
}

textures/skies_MASTER/eta_nebula
{
	qer_editorImage skpk/qer/env/eta_nebula/eta_nebula.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 33 267 72 5 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 88 4
	nopicmip
	skyParms skpk/env/eta_nebula/eta_nebula - -
}

textures/skies_MASTER/exosystem2
{
	qer_editorImage skpk/qer/env/exosystem/exosystem.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.930022 0.708537 0.656092 85 60 40 3 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 65 4
	nopicmip
	skyparms skpk/env/exosystem/exosystem - -
}

textures/skies_MASTER/kothic_floodland
{
	qer_editorImage skpk/qer/env/floodland/floodland.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 60 260 30 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 88 4
	nopicmip
	skyparms skpk/env/floodland/floodland - -
}

textures/skies_MASTER/forge
{
	qer_editorImage skpk/qer/env/forge/forge.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.992157 0.960784 0.54902 25 41 30 2 16
	q3map_sunExt 0.992157 0.960784 0.54902 25 -42 29 2 16
	q3map_sunExt 0.992157 0.960784 0.54902 25 -138 29 2 16
	q3map_sunExt 0.992157 0.960784 0.54902 25 139 29 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 90 4
	nopicmip
	skyParms skpk/env/forge/forge - -
}

textures/skies_MASTER/kothic_gehenna
{
	qer_editorImage skpk/qer/env/gehenna/gehenna.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 140 4
	nopicmip
	skyparms skpk/env/gehenna/gehenna - -
}

textures/skies_MASTER2/gfxsphere
{
	qer_editorImage skpk/qer/env/gfxsphere/gfxsphere.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.641123 0.747936 0.952926 80 80 84 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 75 4
	nopicmip
	skyparms skpk/env/gfxsphere/gfxsphere - -
}

textures/skies_MASTER/hallucion
{
	qer_editorImage skpk/qer/env/hallucion/hallucion.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt .9 .25 .75 80 280 90 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/hallucion/hallucion - -
}

textures/skies_MASTER/kothic_heather
{
	qer_editorImage skpk/qer/env/heather/heather.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 88 145 30 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 77 4
	nopicmip
	skyparms skpk/env/heather/heather - -
}

textures/skies_MASTER/heaven
{
	qer_editorImage skpk/qer/env/heaven/heaven.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 0.853391 0.556786 80 45 90 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 75 4
	nopicmip
	skyparms skpk/env/heaven/heaven - -
}

textures/skies_MASTER2/frozencolors-mirrored
{
	qer_editorImage skpk/qer/env/heaven_sky/heaven.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 80 138 36 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 75 4
	nopicmip
	skyparms skpk/env/heaven_sky/heaven - -
}

textures/skies_MASTER/heaven2
{
	qer_editorImage skpk/qer/env/heaven2/heaven2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_sunExt 1 1 1 75 -119 24 9 16
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/heaven2/heaven2 - -
}

textures/skies_MASTER/sb_devilpunch-hellcave
{
	qer_editorImage skpk/qer/env/hell_cave/hellcave.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyparms skpk/env/hell_cave/hellcave - -
}

textures/skies_MASTER/kothic_highlandspring
{
	qer_editorImage skpk/qer/env/highlandspring/highlandspring.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 58 23 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 130 4
	nopicmip
	skyparms skpk/env/highlandspring/highlandspring - -
}

textures/skies_MASTER/kothic_horus
{
	qer_editorImage skpk/qer/env/horus/horus.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 -160 55 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 80 4
	nopicmip
	skyparms skpk/env/horus/horus - -
}

textures/skies_MASTER2/frozencolors-pale
{
	qer_editorImage skpk/qer/env/ice/ice640.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 50 315 33 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 40 4
	nopicmip
	skyparms skpk/env/ice/ice640 - -
}

textures/skies_MASTER/jf_forest
{
	qer_editorImage skpk/qer/env/jf_forest/forest512.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt .941 .984 1 75 45 55 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 80 4
	nopicmip
	skyparms skpk/env/jf_forest/forest512 - -
}

textures/skies_MASTER/invadercity
{
	qer_editorImage skpk/qer/env/invadercity/invadercity.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_sunExt 0.964706 0.858824 0.6 35 -46 45 11 16
	q3map_skyLight 110 5
	nopicmip
	skyparms skpk/env/invadercity/invadercity - -
}

textures/skies_MASTER/jajalien
{
	qer_editorImage skpk/qer/env/jajalien1/jajalien1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 .75 .65 85 -30 45 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 75 4
	nopicmip
	skyparms skpk/env/jajalien1/jajalien1 - -
}

textures/skies_MASTER/jajdarkland1
{
	qer_editorImage skpk/qer/env/jajdarkland1/jajdarkland1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt .75 .7 .7 85 -30 39 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 75 4
	nopicmip
	skyparms skpk/env/jajdarkland1/jajdarkland1 - -
}

textures/skies_MASTER/jajdesert1_skybox
{
	qer_editorImage skpk/qer/env/jajdesert1/jajdesert1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 .7 .5 85 330 30 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 75 4
	nopicmip
	skyparms skpk/env/jajdesert1/jajdesert1 - -
}

textures/skies_MASTER3/casa_desert
{
	qer_editorImage skpk/qer/env/jk_desert/desert.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 .98 85 -79 79 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 75 4
	nopicmip
	skyparms skpk/env/jk_desert/desert - -
}

textures/skies_MASTER3/jk_yavin-cloudy
{
	qer_editorImage skpk/qer/env/jk_yavin/yavin.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyparms skpk/env/jk_yavin/yavin - -
}

textures/skies_MASTER2/joshsky
{
	qer_editorImage skpk/qer/env/joshsky1/joshsky1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 .9 .7 80 330 24 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/joshsky1/joshsky1 - -
}

textures/skies_MASTER/kothic_khem_fix
{
	qer_editorImage skpk/qer/env/khem_fix/khem.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 130 50 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 75 4
	nopicmip
	skyparms skpk/env/khem_fix/khem - -
}

textures/skies_MASTER/kothic_luna
{
	qer_editorImage skpk/qer/env/luna/luna.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 80 265 70 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 65 4
	nopicmip
	skyparms skpk/env/luna/luna - -
}

textures/skies_MASTER/kothic_tramonto
{
	qer_editorImage skpk/qer/env/med-tramonto/med-tramonto.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.968627 0.792157 0.364706 80 252 11 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/med-tramonto/med-tramonto - -
}

textures/skies_MASTER/kothic_troubadour
{
	qer_editorImage skpk/qer/env/med-troubadour/med-troubadour.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 115 48 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 75 4
	nopicmip
	skyparms skpk/env/med-troubadour/med-troubadour - -
}

textures/skies_MASTER/mega_coldsun
{
	qer_editorImage skpk/qer/env/mega_coldsun/mega_coldsun.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.996078 0.752941 0.0235294 85 110 6 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 75 4
	nopicmip
	skyparms skpk/env/mega_coldsun/mega_coldsun - -
}

textures/skies_MASTER/mega_forest
{
	qer_editorImage skpk/qer/env/mega_forest/mega_forest.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 140 4
	nopicmip
	skyparms skpk/env/mega_forest/mega_forest - -
}

textures/skies_MASTER/mega_losted_ice
{
	qer_editorImage skpk/qer/env/mega_losted_ice/mega_losted_ice.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 .949 .977 100 3 16 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 75 4
	nopicmip
	skyparms skpk/env/mega_losted_ice/mega_losted_ice - -
}

textures/skies_MASTER/mega_pyramids
{
	qer_editorImage skpk/qer/env/mega_pyramids/mega_pyramids.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 .949 .977 100 200 45 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 75 4
	nopicmip
	skyparms skpk/env/mega_pyramids/mega_pyramids - -
}

textures/skies_MASTER/mega_redspace
{
	qer_editorImage skpk/qer/env/mega_redspace/mega_redspace.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 150 4
	nopicmip
	skyparms skpk/env/mega_redspace/mega_redspace - -
}

textures/skies_MASTER/mega_winter
{
	qer_editorImage skpk/qer/env/mega_winter/mega_winter.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 .949 .977 60 146 29 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 90 4
	nopicmip
	skyparms skpk/env/mega_winter/mega_winter - -
}

textures/skies_MASTER2/mk_castlesky
{
	qer_editorImage skpk/qer/env/mk_castlesky/castlesky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 155 4
	nopicmip
	skyparms skpk/env/mk_castlesky/castlesky - -
}

textures/skies_MASTER2/restnormal
{
	qer_editorImage skpk/qer/textures/hipshot_pn2_sky/env/restnormal.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 90 340 21 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/textures/hipshot_pn2_sky/env/restnormal - -
}

textures/skies_MASTER/mudriver
{
	qer_editorImage skpk/qer/env/mudriver/valley.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.924 0.948 1.000 35 220 60 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/mudriver/valley - -
}

textures/skies_MASTER2/nansen
{
	qer_editorImage skpk/qer/env/nansen/nansen.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.6 0.8 0.8 7 330 40 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 60 4
	nopicmip
	skyparms skpk/env/nansen/nansen - -
}

textures/skies_MASTER/nebula3-grid-green
{
	qer_editorImage skpk/qer/env/nebulax/nebulax.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 90 4
	nopicmip
	skyparms skpk/env/nebulax/nebulax - -
}

textures/skies_MASTER2/nouren_sky
{
	qer_editorImage skpk/qer/env/noruen/AcSky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt .87 .84 .84 5 210 45 2 16      //nebula
	q3map_sunExt .87 .84 .84 70 89.5 7.5 2 16   //star
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 85 4
	nopicmip
	skyparms skpk/env/noruen/AcSky - -
}

textures/skies_MASTER/kothic_ofelas
{
	qer_editorImage skpk/qer/env/ofelas/ofelas.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 88 4
	nopicmip
	skyparms skpk/env/ofelas/ofelas - -
}

textures/skies_MASTER/kothic_olos
{
	qer_editorImage skpk/qer/env/olos/olos.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 90 4
	nopicmip
	skyParms skpk/env/olos/olos - -
}

textures/skies_MASTER/kothic_ozymandias
{
	qer_editorImage skpk/qer/env/ozymandias/ozymandias.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 0.9 0.5 88 61 14 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/ozymandias/ozymandias - -
}

textures/skies_MASTER2/pillar_sky
{
	qer_editorImage skpk/qer/env/pillar_sky/pillar_sky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyparms skpk/env/pillar_sky/pillar_sky - -
}

textures/skies_MASTER2/pillsky
{
	qer_editorimage skpk/qer/env/pillsky/pillsky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 90 4
	nopicmip
	skyparms skpk/env/pillsky/pillsky - -
}

textures/skies_MASTER2/pillsky2
{
	qer_editorImage skpk/qer/env/pillsky/v2/pillsky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 90 4
	nopicmip
	skyparms skpk/env/pillsky/v2/pillsky - -
}

textures/skies_MASTER/kothic_predator
{
	qer_editorImage skpk/qer/env/predator/predator.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.879423 0.510994 0.259281 10 -116 76 2 16
	q3map_sunExt 0.879423 0.510994 0.259281 10 77 74 2 16
	q3map_sunExt 0.879423 0.510994 0.259281 10 11 66 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 130 4
	nopicmip
	skyparms skpk/env/predator/predator - -
}

textures/skies_MASTER/kothic_purplepeopleeater
{
	qer_editorImage skpk/qer/env/purplepeopleeater/purplepeopleeater.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 75 60 54 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 80 4
	nopicmip
	skyparms skpk/env/purplepeopleeater/purplepeopleeater - -
}

textures/skies_MASTER2/rexor_sky
{
	qer_editorImage skpk/qer/env/rexor/rexor.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 70 165 35 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/rexor/rexor - -
}

textures/skies_MASTER2/rknight2
{
	qer_editorImage skpk/qer/env/rknight2/rknight2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 140 4
	nopicmip
	skyparms skpk/env/rknight2/rknight2 - -
}

textures/skies_MASTER/kothic_rlyeh
{
	qer_editorImage skpk/qer/env/rlyeh/rlyeh.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 66 127 62 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 90 4
	nopicmip
	skyparms skpk/env/rlyeh/rlyeh - -
}

textures/skies_MASTER/kothic_saltflats
{
	qer_editorImage skpk/qer/env/saltflats/saltflats.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 70 57 41 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/saltflats/saltflats - -
}

textures/skies_MASTER/mp_doornthree
{
	qer_editorImage skpk/qer/env/mp_doornthree/doornthree512.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.996078 0.643458 0.345098 35 0 5 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 80 4
	nopicmip
	skyparms skpk/env/mp_doornthree/doornthree512 - -
}

textures/skies_MASTER/kothic_scapulaflow
{
	qer_editorImage skpk/qer/env/scapulaflow/scapulaflow.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 40 305 40 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/scapulaflow/scapulaflow - -
}

textures/skies_MASTER/kothic_seraphim
{
	qer_editorImage skpk/qer/env/seraphim/seraphim.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt .9 0.9 1 80 267 18 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/seraphim/seraphim - -
}

textures/skies_MASTER/Skybox_for_hyper
{
	qer_editorImage skpk/qer/env/Skybox_for_hyper/Skybox_for_hyper.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 100 4
	nopicmip
	skyparms skpk/env/Skybox_for_hyper/Skybox_for_hyper - -
}

textures/skies_MASTER2/halfskyeasi
{
	qer_editorImage skpk/qer/env/halfskyeasi/halfskyeasi.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_sunExt 222 255 255 70 175 50 20 16
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/halfskyeasi/halfskyeasi - -
}

textures/skies_MASTER2/sp01
{
	qer_editorImage skpk/qer/env/sp01.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 .98 30 -88 -2 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/sp01 - -
}

textures/skies_MASTER3/spa-jump2
{
	qer_editorImage skpk/qer/env/jump2/jump2_512.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 60 21 37 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/jump2/jump2_512 - -
}

textures/skies_MASTER/kothic_snowmoon
{
	qer_editorImage skpk/qer/env/snowmoon/snowmoon.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 44 64 22 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/snowmoon/snowmoon - -
}

textures/skies_MASTER/kothic_starfrost
{
	qer_editorImage skpk/qer/env/starfrost/starfrost.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 68 283 35 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/starfrost/starfrost - -
}

textures/skies_MASTER/kothic_verdanis-cool
{
	qer_editorImage skpk/qer/env/verdanis-cool/verdanis-cool.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 35 305 23 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/verdanis-cool/verdanis-cool - -
}

textures/skies_MASTER/kothic_verdanis-warm
{
	qer_editorImage skpk/qer/env/verdanis-warm/verdanis-warm.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 0.723323 0.56286 50 305 23 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 75 4
	nopicmip
	skyparms skpk/env/verdanis-warm/verdanis-warm - -
}

textures/skies_MASTER/mp_awup-vattenbla
{
	qer_editorImage skpk/qer/env/vattenbla/vattenbla.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 150 4
	nopicmip
	skyparms skpk/env/vattenbla/vattenbla - -
}

textures/skies_MASTER2/0fear-wfa
{
	qer_editorImage skpk/qer/env/0fear-wfa/blue.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 255 255 245 30 4 85 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 40 4
	nopicmip
	skyparms skpk/env/0fear-wfa/blue - -
}

textures/skies_MASTER2/5th_dskdesrt
{
	qer_editorImage skpk/qer/env/5th_dskdesrt/desrtsky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 255 250 222 70 -30 44 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 60 4
	nopicmip
	skyparms skpk/env/5th_dskdesrt/desrtsky - -
}

textures/skies_MASTER2/5th_starsky
{
	qer_editorImage skpk/qer/env/5th_starsky/starzsky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 70 38 52 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 20 4
	nopicmip
	skyparms skpk/env/5th_starsky/starzsky - -
}

textures/skies_MASTER/algier1
{
	qer_editorImage skpk/qer/env/algier1/algierssky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 120 4
	nopicmip
	skyparms skpk/env/algier1/algierssky - -
}

textures/skies_MASTER/algiers
{
	qer_editorImage skpk/qer/env/algiers/algierssky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 255 255 240 80 140 38 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/algiers/algierssky - -
}

textures/skies_MASTER/arcn2
{
	qer_editorImage skpk/qer/env/arc/arcn.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 255 255 240 20 180 23 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/arc/arcn - -
}

textures/skies_MASTER/arcticsky
{
	qer_editorImage skpk/qer/textures/ut_cargo_lite/env/articsky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 40 149 10 1 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 20 4
	nopicmip
	skyparms skpk/textures/ut_cargo_lite/env/articsky - -
}

textures/skies_MASTER/deepsea
{
	qer_editorImage skpk/qer/env/atlantis/deepseasky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_sunExt 1 1 1 10 125 72 33 16
	q3map_skylight 100 4
	nopicmip
	skyparms skpk/env/atlantis/deepseasky - -
}

textures/skies_MASTER/austria
{
	qer_editorImage skpk/qer/env/austria/austriasky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.847059 0.666667 0.356863 80 140 29 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/austria/austriasky - -
}

textures/skies_MASTER/kothic_dust-pale
{
	qer_editorImage skpk/qer/env/bhd/bhdsky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 210 204 188 70 100 49 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 30 4
	nopicmip
	skyparms skpk/env/bhd/bhdsky - -
}

textures/skies_MASTER2/bl4b
{
	qer_editorImage skpk/qer/env/bl4b.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 120 4
	nopicmip
	skyparms skpk/env/bl4b - -
}

textures/skies_MASTER2/blk
{
	qer_editorImage skpk/qer/env/blk.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 100 4
	nopicmip
	skyparms skpk/env/blk - -
}

textures/skies_MASTER/jf_forest-yellow
{
	qer_editorImage skpk/qer/env/bludmaya.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 235 153 95 30 46 56 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 60 4
	nopicmip
	skyparms skpk/env/bludmaya - -
}

textures/skies_MASTER/box15
{
	qer_editorImage skpk/qer/env/box15/box15.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 255 245 200 70 -160 11 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 40 4
	nopicmip
	skyparms skpk/env/box15/box15 - -
}

textures/skies_MASTER/box15-clouds
{
	qer_editorImage skpk/qer/env/box15/box15-clouds.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 255 245 200 70 -160 11 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 40 4
	nopicmip
	skyparms skpk/env/box15/box15 - -
	{
		map skpk/textures/sky/clouds.tga
		blendfunc blend
		tcMod scale 3 3
		tcMod scroll 0.005 0.007
	}
}

textures/skies_MASTER/box15n
{
	qer_editorImage skpk/qer/env/box15/box15n.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 255 150 106 50 -2 4 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/box15/box15n - -
}

textures/skies_MASTER/box22
{
	qer_editorImage skpk/qer/textures/ut_oilrig/env/box22/box22.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 255 205 68 60 180 7 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 30 4
	nopicmip
	skyparms skpk/textures/ut_oilrig/env/box22/box22 - -
}

textures/skies_MASTER/box271
{
	qer_editorImage skpk/qer/env/box271/box271.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 150 4
	nopicmip
	skyparms skpk/env/box271/box271 - -
}

textures/skies_MASTER/box293
{
	qer_editorImage skpk/qer/env/box293/box293.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 111 4
	nopicmip
	skyparms skpk/env/box293/box293 - -
}

textures/skies_MASTER/box293-clouds
{
	qer_editorImage skpk/qer/env/box293/box293-clouds.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 111 4
	nopicmip
	skyparms skpk/env/box293/box293 - -
	{
		map skpk/textures/sky/clouds.tga
		blendfunc blend
		tcMod scale 3 3
		tcMod scroll 0.005 0.007
	}
}

textures/skies_MASTER/box365
{
	qer_editorImage skpk/qer/env/box365/box365.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.874189 0.714153 0.45713 75 107 10 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/box365/box365 - -
}

textures/skies_MASTER/box513
{
	qer_editorImage skpk/qer/env/box513/box513.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 80 4
	nopicmip
	skyparms skpk/env/box513/box513 - -
}

textures/skies_MASTER/bridge
{
	qer_editorImage skpk/qer/env/bridge/kon.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 40 -74 86 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 20 4
	nopicmip
	skyparms skpk/env/bridge/kon - -
}

textures/skies_MASTER2/c1
{
	qer_editorImage skpk/qer/env/c1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 120 4
	nopicmip
	skyparms skpk/env/c1 - -
}

textures/skies_MASTER/darkhollow-dim
{
	qer_editorImage skpk/qer/env/bubctf1/bubctf1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 90 4
	nopicmip
	skyparms skpk/env/bubctf1/bubctf1 - -
}

textures/skies_MASTER2/c2nite
{
	qer_editorImage skpk/qer/env/c2nite.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 90 4
	nopicmip
	skyparms skpk/env/c2nite - -
}

textures/skies_MASTER2/c2nitemod
{
	qer_editorImage skpk/qer/env/c2nitemod/c2nite.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 30 45 45 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/c2nitemod/c2nite - -
}

textures/skies_MASTER/kothic_captivation-gray
{
	qer_editorImage skpk/qer/env/captivation-gray/captivation-gray.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 90 4
	nopicmip
	skyparms skpk/env/captivation-gray/captivation-gray - -
}

textures/skies_MASTER/tropseaday
{
	qer_editorImage skpk/qer/env/tropday/tropday.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 255 250 240 80 153 43 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 40 4
	nopicmip
	skyparms skpk/env/tropday/tropday - -
}

textures/skies_MASTER/ame_chocolatemilk
{
	qer_editorImage skpk/qer/env/amethyst7/chocolatemilk/chocolatemilk.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 255 250 215 40 90 23 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 60 4
	nopicmip
	skyparms skpk/env/amethyst7/chocolatemilk/chocolatemilk - -
}

textures/skies_MASTER/contradasky
{
	qer_editorImage skpk/qer/env/contradasky/contradasky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 255 245 240 80 -3 69 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/contradasky/contradasky - -
}

textures/skies_MASTER/crenshawsky
{
	qer_editorImage skpk/qer/env/crenshawsky/crenshawsky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 255 255 240 50 122 86 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 20 4
	nopicmip
	skyparms skpk/env/crenshawsky/crenshawsky - -
}

textures/skies_MASTER/jf_plague-empty
{
	qer_editorImage skpk/qer/env/crossing/kell.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 90 4
	nopicmip
	skyparms skpk/env/crossing/kell - -
}

textures/skies_MASTER/darkhollow
{
	qer_editorImage skpk/qer/env/darkhollow/darkhollow.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 90 4
	nopicmip
	skyparms skpk/env/darkhollow/darkhollow - -
}

textures/skies_MASTER/dd_casa
{
	qer_editorImage skpk/qer/env/dd_casa_sky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 255 250 240 80 -134 70 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/dd_casa_sky - -
}

textures/skies_MASTER/deepsea-dark
{
	qer_editorImage skpk/qer/env/deepsea1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 15 126 67 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 120 4
	nopicmip
	skyparms skpk/env/deepsea1 - -
}

textures/skies_MASTER/dek1
{
	qer_editorImage skpk/qer/env/dek1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 120 4
	nopicmip
	skyparms skpk/env/dek1 - -
}

textures/skies_MASTER/desgrass02
{
	qer_editorImage skpk/qer/env/desgrass02/desgrass02.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 255 255 235 80 0 44 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/desgrass02/desgrass02 - -
}

textures/skies_MASTER/tropical
{
	qer_editorImage skpk/qer/env/tropical/tropical.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 255 253 225 20 37 44 0 1
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 90 4
	nopicmip
	skyparms skpk/env/tropical/tropical - -
}

textures/skies_MASTER/dk_pc
{
	qer_editorImage skpk/qer/env/dk_pc/pc.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 130 4
	nopicmip
	skyparms skpk/env/dk_pc/pc - -
}

textures/skies_MASTER3/snow2-dark
{
	qer_editorImage skpk/qer/env/drksky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 240 245 255 40 -127 60 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 20 4
	nopicmip
	skyparms skpk/env/drksky - -
}

textures/skies_MASTER/dufsunny
{
	qer_editorImage skpk/qer/env/dufsunny/dufsunny.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_sunExt 255 250 222 80 40 11 5 16
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/dufsunny/dufsunny - -
}

textures/skies_MASTER/durdm1
{
	qer_editorImage skpk/qer/env/durdm1/sky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 255 250 235 80 -33 42 6 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/durdm1/sky - -
}

textures/skies_MASTER/dwell
{
	qer_editorImage skpk/qer/env/dwell.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 218 41 34 50 -90 3 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/dwell - -
}

textures/skies_MASTER3/streets-dark
{
	qer_editorImage skpk/qer/env/masheen/sky1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 80 4
	nopicmip
	skyparms skpk/env/masheen/sky1 - -
}

textures/skies_MASTER/eggdm1sky
{
	qer_editorImage skpk/qer/env/eggdm1sky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 240 255 250 80 -30 25 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/eggdm1sky - -
}

textures/skies_MASTER/kothic_grassland-dim
{
	qer_editorImage skpk/qer/env/farmsky/farmsky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 255 255 245 70 120 37 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 60 4
	nopicmip
	skyparms skpk/env/farmsky/farmsky - -
}

textures/skies_MASTER2/firmsky
{
	qer_editorImage skpk/qer/env/firmsky/firmsky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_sunExt 255 255 245 70 -34 26 30 16
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/firmsky/firmsky - -
}

textures/skies_MASTER/fullmoon
{
	qer_editorImage skpk/qer/env/fullmoon/fullmoon.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 241 224 255 80 -97 29 3 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 20 4
	nopicmip
	skyparms skpk/env/fullmoon/fullmoon - -
}

textures/skies_MASTER/ghost
{
	qer_editorImage skpk/qer/env/ghost/ghost.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_sunExt 255 220 151 70 -2 11 15 16
	q3map_skylight 40 4
	nopicmip
	skyparms skpk/env/ghost/ghost - -
}

textures/skies_MASTER2/golf
{
	qer_editorImage skpk/qer/env/golf.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 255 255 240 80 120 25 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 60 4
	nopicmip
	skyparms skpk/env/golf - -
}

textures/skies_MASTER/gpcell
{
	qer_editorImage skpk/qer/env/gpcell/gpcell2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 255 250 240 50 170 61 0 1
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 33 4
	nopicmip
	skyparms skpk/env/gpcell/gpcell2 - -
}

textures/skies_MASTER6/0color_gradientBlue
{
	qer_editorImage skpk/qer/env/hdsbox2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 100 4
	nopicmip
	skyparms skpk/env/hdsbox2 - -
}

textures/skies_MASTER/horror
{
	qer_editorImage skpk/qer/env/horror/moonlight_sky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 255 250 240 70 -91 33 0 1
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 33 4
	nopicmip
	skyparms skpk/env/horror/moonlight_sky - -
}

textures/skies_MASTER/hybsun
{
	qer_editorImage skpk/qer/env/hybsun/hybsun.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 255 250 235 60 -20 20 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/hybsun/hybsun - -
}

textures/skies_MASTER/tropseadusk-empty
{
	qer_editorImage skpk/qer/env/inletdusk/inletdusk.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 205 117 93 70 163 7 3 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 30 4
	nopicmip
	skyparms skpk/env/inletdusk/inletdusk - -
}

textures/skies_MASTER/sb_strato-yellowish
{
	qer_editorImage skpk/qer/env/instaCTFstratosphere/stratosphere.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_sunExt 255 255 250 70 -90 45 20 16
	q3map_skylight 60 4
	nopicmip
	skyparms skpk/env/instaCTFstratosphere/stratosphere - -
}

textures/skies_MASTER/japan
{
	qer_editorImage skpk/qer/env/japan/japan.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 255 255 245 70 180 24 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 60 4
	nopicmip
	skyparms skpk/env/japan/japan - -
}

textures/skies_MASTER/jhnebula2
{
	qer_editorImage skpk/qer/env/jhnebula3.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 100 4 -90 90 1
	nopicmip
	skyparms skpk/env/jhnebula3 - -
}

textures/skies_MASTER/jhnebula3
{
	qer_editorImage skpk/qer/env/JHNEBULA/jhnebula3.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 100 4 -90 90 1
	nopicmip
	skyparms skpk/env/JHNEBULA/jhnebula3 - -
}

textures/skies_MASTER/juliesky1
{
	qer_editorImage skpk/qer/env/julieplay3/juliesky1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 100 4
	nopicmip
	skyparms skpk/env/julieplay3/juliesky1 - -
}

textures/skies_MASTER/laneway
{
	qer_editorImage skpk/qer/env/laneway/lanewaysky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 255 250 210 80 -3 42 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/laneway/lanewaysky - -
}

textures/skies_MASTER/ldaforestsky
{
	qer_editorImage skpk/qer/env/LDAforestsky_x.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/LDAforestsky_x - -
}

textures/skies_MASTER/Leviathan
{
	qer_editorImage skpk/qer/env/Leviathan/Leviathan.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_sunExt 255 250 245 70 -53 45 33 16
	q3map_skylight 60 4
	nopicmip
	skyparms skpk/env/Leviathan/Leviathan - -
}

textures/skies_MASTER2/alpine2
{
	qer_editorImage skpk/qer/env/lloydmdm2/lloydmdm2sky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 255 250 235 70 158 22 3 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/lloydmdm2/lloydmdm2sky - -
}

textures/skies_MASTER/ame_lostatseanight
{
	qer_editorImage skpk/qer/env/amethyst7/lostatseanight/lostatseanight.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 50 0 19 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/amethyst7/lostatseanight/lostatseanight - -
}

textures/skies_MASTER/madm05
{
	qer_editorImage skpk/qer/env/madm05.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 140 4
	nopicmip
	skyparms skpk/env/madm05 - -
}

textures/skies_MASTER/nebula3-green
{
	qer_editorImage skpk/qer/env/madm05a.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 110 4
	nopicmip
	skyparms skpk/env/madm05a - -
}

textures/skies_MASTER/madm05b
{
	qer_editorImage skpk/qer/env/madm05b.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 150 4
	nopicmip
	skyparms skpk/env/madm05b - -
}

textures/skies_MASTER/malrav1
{
	qer_editorImage skpk/qer/env/malrav1/malrav1sky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 255 255 245 80 -30 24 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/malrav1/malrav1sky - -
}

textures/skies_MASTER/mbox1
{
	qer_editorImage skpk/qer/env/mbox1/mbox1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 255 255 245 80 1 23 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/mbox1/mbox1 - -
}

textures/skies_MASTER/MilanBsky
{
	qer_editorImage skpk/qer/env/MilanBsky/MilanBsky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_sunExt 0.72549 0.560784 0.313726 60 158 33 5 16
	q3map_skylight 60 4
	nopicmip
	skyparms skpk/env/MilanBsky/MilanBsky - -
}

textures/skies_MASTER/ame_milkchocolate
{
	qer_editorImage skpk/qer/env/amethyst7/milkchocolate/milkchocolate.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 255 250 215 40 -90 19 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 60 4
	nopicmip
	skyparms skpk/env/amethyst7/milkchocolate/milkchocolate - -
}

textures/skies_MASTER/grnplsnt
{
	qer_editorImage skpk/qer/env/grnplsnt/grnplsnt.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.840696 0.773144 0.507759 80 60 19 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/grnplsnt/grnplsnt - -
}

textures/skies_MASTER2/ds-grass-warm
{
	qer_editorImage skpk/qer/env/mountains.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 120 4
	nopicmip
	skyparms skpk/env/mountains - -
}

textures/skies_MASTER/nebula3
{
	qer_editorImage skpk/qer/env/nebula3/nebula3.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 120 4
	nopicmip
	skyparms skpk/env/nebula3/nebula3 - -
}

textures/skies_MASTER/night1
{
	qer_editorImage skpk/qer/env/night1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 10 152 74 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/night1 - -
}

textures/skies_MASTER/paradise
{
	qer_editorImage skpk/qer/env/paradise.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_sunExt 255 250 240 70 60 22 5 16
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/paradise - -
}

textures/skies_MASTER/mp_parallax-error
{
	qer_editorImage skpk/qer/env/mp_parallax/parallax-error512.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 15 -152 28 1 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 80 4
	nopicmip
	skyparms skpk/env/mp_parallax/parallax-error512 - -
}

textures/skies_MASTER/mp_parallax-error-flare
{
	qer_editorImage skpk/qer/env/mp_parallax/parallax-errorlf512.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 237 188 189 15 -152 28 1 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 80 4
	nopicmip
	skyparms skpk/env/mp_parallax/parallax-errorlf512 - -
}

textures/skies_MASTER/polaris
{
	qer_editorImage skpk/qer/env/polaris/polaris.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 150 4
	nopicmip
	skyparms skpk/env/polaris/polaris - -
}

textures/skies_MASTER/prick
{
	qer_editorImage skpk/qer/env/prick.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 255 255 245 80 59 44 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/prick - -
}

textures/skies_MASTER6/0color_gradientWhite
{
	qer_editorImage skpk/qer/env/cardigan/purewhitej.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 120 4
	nopicmip
	skyparms skpk/env/cardigan/purewhitej - -
}

textures/skies_MASTER/q3tc_nightsky
{
	qer_editorImage skpk/qer/env/q3tc_nightsky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/q3tc_nightsky - -
}

textures/skies_MASTER/q3tc_nightsky2
{
	qer_editorImage skpk/qer/env/q3tc_nightsky2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 100 4
	nopicmip
	skyparms skpk/env/q3tc_nightsky2 - -
}

textures/skies_MASTER/q3tc_urbsky
{
	qer_editorImage skpk/qer/env/q3tc_urbsky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.769436 0.662089 0.443824 50 122 13 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/q3tc_urbsky - -
}

textures/skies_MASTER3/re_jerez
{
	qer_editorImage skpk/qer/env/re_jerez/jereznight.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 30 0 90 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/re_jerez/jereznight - -
}

textures/skies_MASTER/jf_forest-dark
{
	qer_editorImage skpk/qer/env/rommel.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 255 250 235 70 45 55 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/rommel - -
}

textures/skies_MASTER3/sat
{
	qer_editorImage skpk/qer/env/sat.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 240 230 255 20 -76 15 1 16
	q3map_LightMapFilterRadius 0 8
	q3map_sunExt 255 255 240 70 91 10 70 16
	q3map_skylight 20 4
	nopicmip
	skyparms skpk/env/sat - -
}

textures/skies_MASTER2/sp07
{
	qer_editorImage skpk/qer/env/sp07.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.545098 0.545098 0.74902 35 -89 -7 1 16       //blue
	q3map_sunExt 0.67451 0.47451 0.52549 35 86 -9 1 16          //red
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 150 4
	nopicmip
	skyparms skpk/env/sp07 - -
}

textures/skies_MASTER3/scrotch-cove
{
	qer_editorImage skpk/qer/env/scrotch/cove512.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 255 245 235 20 -144 19 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/scrotch/cove512 - -
}

textures/skies_MASTER3/scrotch-coveb
{
	qer_editorImage skpk/qer/env/scrotch/coveb512.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 20 -148 25 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/scrotch/coveb512 - -
}

textures/skies_MASTER3/sgskybox3
{
	qer_editorImage skpk/qer/env/sgskybox3/sgsky3.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 255 250 235 100 120 34 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/sgskybox3/sgsky3 - -
}

textures/skies_MASTER3/siberia
{
	qer_editorImage skpk/qer/env/siberia/siberia.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 50 -30 24 3 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 100 4
	nopicmip
	skyparms skpk/env/siberia/siberia - -
}

textures/skies_MASTER3/muad_sierra
{
	qer_editorImage skpk/qer/env/muad_sierra/sierra.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 254 253 235 80 -115 10 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/muad_sierra/sierra - -
}

textures/skies_MASTER3/sky_1
{
	qer_editorImage skpk/qer/env/sky1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 253 249 204 90 135 35 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 60 4
	nopicmip
	skyparms skpk/env/sky1 - -
}

textures/skies_MASTER3/space_planets
{
	qer_editorImage skpk/qer/env/space.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 50 94 26 2 16
	q3map_sunExt 1 1 1 30 144 61 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/space - -
}

textures/skies_MASTER3/ssctf3
{
	qer_editorImage skpk/qer/env/ssctf3/ssctf3.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 228 189 150 50 54 69 4 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 80 4
	nopicmip
	skyparms skpk/env/ssctf3/ssctf3 - -
}

textures/skies_MASTER3/simpsons_sky
{
	qer_editorImage skpk/qer/env/ssky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 150 4
	nopicmip
	skyparms skpk/env/ssky - -
}

textures/skies_MASTER3/starlight
{
	qer_editorImage skpk/qer/env/Starlight.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 255 250 235 20 174 18 1 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 120 4
	nopicmip
	skyparms skpk/env/Starlight - -
}

textures/skies_MASTER3/stonevilleskyA
{
	qer_editorImage skpk/qer/env/stonevilleskyA/stonevilleskyA.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 80 4
	nopicmip
	skyparms skpk/env/stonevilleskyA/stonevilleskyA - -
}

textures/skies_MASTER3/streets
{
	qer_editorImage skpk/qer/env/heinsky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/heinsky - -
}

textures/skies_MASTER3/streetsky2
{
	qer_editorImage skpk/qer/env/streetsky2/streetsky2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 255 255 240 100 -90 44 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/streetsky2/streetsky2 - -
}

textures/skies_MASTER3/sunset_1
{
	qer_editorImage skpk/qer/env/sunset1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 252 200 50 50 -30 8 3 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/sunset1 - -
}

textures/skies_MASTER3/sunset002
{
	qer_editorImage skpk/qer/env/sunset002.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_sunExt 250 194 59 100 99 -7 20 16
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/sunset002 - -
}

textures/skies_MASTER4/arc_night2
{
	qer_editorImage skpk/qer/env/sw_txts/eagle.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 100 -141 18 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/sw_txts/eagle - -
}

textures/skies_MASTER/swamp1
{
	qer_editorImage skpk/qer/env/swamp1/swamp1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/swamp1/swamp1 - -
}

textures/skies_MASTER/thdmrp11
{
	qer_editorImage skpk/qer/env/thdmrp11/thdmrp11sky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 255 255 245 100 -40 24 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/thdmrp11/thdmrp11sky - -
}

textures/skies_MASTER/toxic2skybox
{
	qer_editorImage skpk/qer/env/toxic2skybox/toxic2sky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 248 188 50 80 50 5 3 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 60 4
	nopicmip
	skyparms skpk/env/toxic2skybox/toxic2sky - -
}

//top sky only
textures/skies_MASTER/toxicskybox
{
	qer_editorImage skpk/qer/env/toxicskybox/toxicsky1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 240 119 14 80 150 3 3 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 30 4
	nopicmip
	skyparms skpk/env/toxicskybox/toxicsky1 - -
}

textures/skies_MASTER/tropseadusk
{
	qer_editorImage skpk/qer/env/tropseadusk/tropseadusk512.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 235 93 50 80 163 8 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/tropseadusk/tropseadusk512 - -
}

textures/skies_MASTER/tropseadusk-darker
{
	qer_editorImage skpk/qer/env/tropseadusk512.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 235 93 19 80 163 8 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/tropseadusk512 - -
}

textures/skies_MASTER2/tunis
{
	qer_editorImage skpk/qer/env/tunis/sky1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 255 255 235 100 180 45 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/tunis/sky1 - -
}

textures/skies_MASTER2/birdofprey
{
	qer_editorImage skpk/qer/env/birdofprey/birdofprey512.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 248 236 138 80 180 3 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/birdofprey/birdofprey512 - -
}

textures/skies_MASTER/ut_berchtesgaden
{
	qer_editorImage skpk/qer/env/ut_berchtesgaden/ut_berchtesgadensky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_sunExt 1 1 1 45 179 26 22 16
	q3map_skylight 85 4
	nopicmip
	skyparms skpk/env/ut_berchtesgaden/ut_berchtesgadensky - -
}

textures/skies_MASTER/jf_forest-yellowish
{
	qer_editorImage skpk/qer/textures/ut_druglord/env/dlsky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 235 153 95 50 46 56 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 80 4
	nopicmip
	skyparms skpk/textures/ut_druglord/env/dlsky - -
}

textures/skies_MASTER/ut_harambique
{
	qer_editorImage skpk/qer/env/desnoon/desnoon.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 100 150 57 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/desnoon/desnoon - -
}

textures/skies_MASTER/ut_mbase2
{
	qer_editorImage skpk/qer/env/ut_mbase2/mbase2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 150 4
	nopicmip
	skyparms skpk/env/ut_mbase2/mbase2 - -
}

textures/skies_MASTER3/grass-nuclear
{
	qer_editorImage skpk/qer/textures/ut_nuclear/env/skybox.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 150 4
	nopicmip
	skyparms skpk/textures/ut_nuclear/env/skybox - -
}

textures/skies_MASTER2/london
{
	qer_editorImage skpk/qer/env/london/london.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/london/london - -
}

textures/skies_MASTER2/londonday
{
	qer_editorImage skpk/qer/textures/ut_pgrounds/env/londonday.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 100 4
	nopicmip
	skyparms skpk/textures/ut_pgrounds/env/londonday - -
}

textures/skies_MASTER/ut_pwnt
{
	qer_editorImage skpk/qer/env/ut_pwnt/ut_pwntsky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_sunExt 1 1 1 33 -140 15 22 16
	q3map_skylight 100 4
	nopicmip
	skyparms skpk/env/ut_pwnt/ut_pwntsky - -
}

textures/skies_MASTER/mp_badomen-dark
{
	qer_editorImage skpk/qer/env/ut_riyadh/badomen512.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_sunExt 214 158 63 20 -25 4 5 16
	q3map_skylight 80 4
	nopicmip
	skyparms skpk/env/ut_riyadh/badomen512 - -
}

textures/skies_MASTER/ut_subway
{
	qer_editorImage skpk/qer/env/ut_subway.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 254 253 233 70 -84 17 3 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/ut_subway - -
}

textures/skies_MASTER2/morningmount
{
	qer_editorImage skpk/qer/env/morningmount/morningmount.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 253 249 217 35 -35 6 3 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/morningmount/morningmount - -
}

textures/skies_MASTER/ame_comablack
{
	qer_editorImage skpk/qer/env/amethyst7/comablack/comablack.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 60 4
	nopicmip
	skyparms skpk/env/amethyst7/comablack/comablack - -
}

textures/skies_MASTER2/village
{
	qer_editorImage skpk/qer/env/village/villagesky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 100 150 25 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/village/villagesky - -
}

textures/skies_MASTER2/LMmnts_2
{
	qer_editorImage skpk/qer/env/LMmnts_2/LMmnts_2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 120 4
	nopicmip
	skyparms skpk/env/LMmnts_2/LMmnts_2 - -
}

textures/skies_MASTER2/stony
{
	qer_editorImage skpk/qer/env/stony/stony.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_sunExt 242 235 238 60 93 50 25 16
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/stony/stony - -
}

textures/skies_MASTER2/wizeguy
{
	qer_editorImage skpk/qer/textures/wizeguy/env/wiz3sky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 251 242 162 50 -90 3 3 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 80 4
	nopicmip
	skyparms skpk/textures/wizeguy/env/wiz3sky - -
}

//============================================

textures/skies_MASTER4/lone_alien_planet
{
	qer_editorImage skpk/qer/env/acid3dm9/sky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 100 4
	nopicmip
	skyparms skpk/env/acid3dm9/sky - -
}

textures/skies_MASTER4/arc_night
{
	qer_editorImage skpk/qer/env/arcn.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 55 -141 19 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 55 4
	nopicmip
	skyparms skpk/env/arcn - -
}

textures/skies_MASTER4/arctic2
{
	qer_editorImage skpk/qer/env/arctic2/arctic.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 0.977 0.588 65 -74 12 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 55 4
	nopicmip
	skyparms skpk/env/arctic2/arctic - -
}

textures/skies_MASTER4/berg2
{
	qer_editorImage skpk/qer/env/berg2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 75 60 24 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 55 4
	nopicmip
	skyparms skpk/env/berg2 - -
}

textures/skies_MASTER4/cemetary
{
	qer_editorImage skpk/qer/env/cemetary.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 150 4
	nopicmip
	skyparms skpk/env/cemetary - -
}

textures/skies_MASTER4/city
{
	qer_editorImage skpk/qer/env/city/citysky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 45 90 65 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 65 4
	nopicmip
	skyparms skpk/env/city/citysky - -
}

textures/skies_MASTER4/cr
{
	qer_editorImage skpk/qer/env/cr.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0 0 1 45 180 10 2 16   //blue
	q3map_sunExt 1 0 0 25 0 11 2 16     //red
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 75 4
	nopicmip
	skyparms skpk/env/cr - -
}

textures/skies_MASTER2/phobos
{
	qer_editorImage skpk/qer/env/phobos.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 95 4
	nopicmip
	skyparms skpk/env/phobos - -
}

textures/skies_MASTER2/danorth
{
	qer_editorImage skpk/qer/env/danorth.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.988 0.974 .720 75 -77 22 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 55 4
	nopicmip
	skyparms skpk/env/danorth - -
}

textures/skies_MASTER2/ds-grass
{
	qer_editorImage skpk/qer/env/ds/DS-Grass2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 75 -29 25 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 65 4
	nopicmip
	skyparms skpk/env/ds/DS-Grass2 - -
}

textures/skies_MASTER2/earth
{
	qer_editorImage skpk/qer/env/earth.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 75 -69 15 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 55 4
	nopicmip
	skyparms skpk/env/earth - -
}

textures/skies_MASTER2/eocspace
{
	qer_editorImage skpk/qer/textures/mperaser1/env/eocspace.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 170 4
	nopicmip
	skyparms skpk/textures/mperaser1/env/eocspace - -
}

textures/skies_MASTER2/green
{
	qer_editorImage skpk/qer/env/green.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 125 4
	nopicmip
	skyparms skpk/env/green - -
}

textures/skies_MASTER/jf_io
{
	qer_editorImage skpk/qer/env/jf_io/jf_io.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 55 50 -71 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 150 4
	nopicmip
	skyparms skpk/env/jf_io/jf_io - -
}

textures/skies_MASTER2/invis1
{
	qer_editorImage skpk/qer/env/invis1/invis1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 55 0 28 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 80 4
	nopicmip
	skyparms skpk/env/invis1/invis1 - -
}

textures/skies_MASTER2/jajspace1
{
	qer_editorImage skpk/qer/env/jajspace1/jajspace1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 150 4
	nopicmip
	skyparms skpk/env/jajspace1/jajspace1 - -
}

textures/skies_MASTER2/jajspace2
{
	qer_editorImage skpk/qer/env/jajspace2/jajspace2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyparms skpk/env/jajspace2/jajspace2 - -
}

textures/skies_MASTER3/muad_fiery
{
	qer_editorImage skpk/qer/env/muad_fiery/firey.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms skpk/env/muad_fiery/firey - -
}

textures/skies_MASTER2/lbsky2
{
	qer_editorImage skpk/qer/env/lbsky2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	nopicmip
	skyparms skpk/env/lbsky2 - -

	// light values tuned for -gamma 2 -compensate 4
	// 122 suns :)
	//				R		G		B		bright	yaw		pitch	dev	samp
	q3map_sunExt	1.00	0.90	0.80	180.0	17.123	48.822	0	16		// the big yellow one

	q3map_sunExt	0.7329	0.9208	1.0		10.6513	89.613	-66.69	2	16		// underlights
	q3map_sunExt	0.5994	0.8315	1.0		10.8072	258.36	-71.28	2	16
	q3map_sunExt	0.5990	0.8390	1.0		10.4978	327.14	-72.79	2	16
	q3map_sunExt	0.8041	0.9418	1.0		11.0879	33.591	-70.25	2	16
	q3map_sunExt	0.7405	0.9088	1.0		10.7015	197.01	-68.93	2	16
	q3map_sunExt	0.7783	0.9246	1.0		10.9546	142.06	-66.79	2	16
	q3map_sunExt	0.7451	0.9228	1.0		20.8505	127.32	-86.86	2	16

	q3map_sunExt	0.7415	0.9044	1.0		1.2333	173.79	-18.75	2	16		// the rest of the blue stuff
	q3map_sunExt	0.8389	0.9373	1.0		6.6010	175.55	23.015	2	16
	q3map_sunExt	0.7443	0.8936	1.0		1.8799	243.68	-1.394	2	16
	q3map_sunExt	0.2762	0.6545	1.0		1.4207	221.83	35.078	2	16
	q3map_sunExt	0.7347	0.9285	1.0		0.7111	217.39	-35.32	2	16
	q3map_sunExt	0.6873	0.8762	1.0		4.2276	105.49	2.9141	2	16
	q3map_sunExt	0.8551	0.9596	1.0		1.5355	129.53	-32.12	2	16
	q3map_sunExt	0.6645	0.8419	1.0		5.1380	129.71	38.400	2	16
	q3map_sunExt	0.8921	0.9633	1.0		2.4988	355.55	-23.01	2	16
	q3map_sunExt	0.6714	0.8729	1.0		9.9313	353.79	18.759	2	16
	q3map_sunExt	0.7389	0.8900	1.0		3.5149	63.682	1.3945	2	16
	q3map_sunExt	0.7839	0.9380	1.0		1.0089	41.830	-35.07	2	16
	q3map_sunExt	0.4945	0.7755	1.0		9.5803	37.399	35.329	2	16
	q3map_sunExt	0.7474	0.9022	1.0		2.2217	285.49	-2.914	2	16
	q3map_sunExt	0.6452	0.8375	1.0		6.3072	309.53	32.128	2	16
	q3map_sunExt	0.7980	0.9438	1.0		1.1175	309.71	-38.40	2	16
	q3map_sunExt	0.4813	0.7461	1.0		4.1235	78.366	71.285	2	16
	q3map_sunExt	0.6419	0.8251	1.0		4.6156	269.61	66.695	2	16
	q3map_sunExt	0.7008	0.8735	1.0		2.6714	206.35	0.5979	2	16
	q3map_sunExt	0.6039	0.8304	1.0		2.1635	142.92	3.0233	2	16
	q3map_sunExt	0.7397	0.8970	1.0		0.9118	171.14	-56.08	2	16
	q3map_sunExt	0.8447	0.9514	1.0		1.9548	85.863	-29.38	2	16
	q3map_sunExt	0.7095	0.8839	1.0		0.7305	358.63	-60.33	2	16
	q3map_sunExt	0.6785	0.8827	1.0		0.8571	263.22	-33.99	2	16
	q3map_sunExt	0.6395	0.8322	1.0		4.2932	265.86	29.387	2	16
	q3map_sunExt	0.3589	0.6863	1.0		1.5625	178.63	60.330	2	16
	q3map_sunExt	0.4516	0.7379	1.0		3.8085	83.228	33.998	2	16
	q3map_sunExt	0.7294	0.8934	1.0		5.0831	26.355	-0.597	2	16
	q3map_sunExt	0.6584	0.8480	1.0		9.9217	351.14	56.083	2	16
	q3map_sunExt	0.7483	0.9023	1.0		2.9484	322.92	-3.023	2	16
	q3map_sunExt	0.8120	0.9298	1.0		2.8463	337.34	-12.77	2	16
	q3map_sunExt	0.8911	0.9538	1.0		2.4733	317.59	-19.49	2	16
	q3map_sunExt	0.7197	0.8773	1.0		6.4394	317.26	13.319	2	16
	q3map_sunExt	0.7576	0.9023	1.0		2.6524	305.62	-3.137	2	16
	q3map_sunExt	0.8126	0.9329	1.0		6.0419	336.79	7.3258	2	16
	q3map_sunExt	0.4438	0.7333	1.0		5.8467	327.40	46.881	2	16
	q3map_sunExt	0.4716	0.7394	1.0		4.6595	322.06	66.796	2	16
	q3map_sunExt	0.4634	0.7380	1.0		7.3385	17.011	68.933	2	16
	q3map_sunExt	0.5547	0.8127	1.0		9.9246	352.72	38.834	2	16
	q3map_sunExt	0.8641	0.9603	1.0		9.8788	11.743	8.7114	2	16
	q3map_sunExt	0.6146	0.8392	1.0		9.9495	30.920	16.084	2	16
	q3map_sunExt	0.8098	0.9260	1.0		3.1106	32.759	-16.68	2	16
	q3map_sunExt	0.7695	0.9092	1.0		4.2623	43.610	0.3438	2	16
	q3map_sunExt	0.8011	0.9237	1.0		3.5108	12.751	-11.37	2	16
	q3map_sunExt	0.4877	0.7529	1.0		4.2342	94.591	19.960	2	16
	q3map_sunExt	0.4744	0.7463	1.0		5.6085	73.250	19.172	2	16
	q3map_sunExt	0.5082	0.7608	1.0		4.3806	82.010	51.256	2	16
	q3map_sunExt	0.4573	0.7575	1.0		5.9619	62.266	36.831	2	16
	q3map_sunExt	0.3919	0.6978	1.0		2.8316	103.99	38.348	2	16
	q3map_sunExt	0.4463	0.7303	1.0		2.1759	150.12	52.726	2	16
	q3map_sunExt	0.6964	0.8603	1.0		5.5020	147.14	72.797	2	16
	q3map_sunExt	0.2304	0.6261	1.0		1.2750	204.23	50.626	2	16
	q3map_sunExt	0.2761	0.6490	1.0		1.1326	213.59	70.256	2	16
	q3map_sunExt	0.3160	0.6713	1.0		1.9584	176.73	43.088	2	16
	q3map_sunExt	0.3007	0.6602	1.0		2.1553	246.24	33.984	2	16
	q3map_sunExt	0.5368	0.7670	1.0		3.1211	266.92	46.648	2	16
	q3map_sunExt	0.7343	0.8851	1.0		4.4957	275.63	14.647	2	16
	q3map_sunExt	0.5941	0.8030	1.0		4.6915	285.70	32.546	2	16
	q3map_sunExt	0.7972	0.9108	1.0		5.1333	254.81	15.417	2	16
	q3map_sunExt	0.7461	0.9177	1.0		0.7518	253.25	-19.17	2	16
	q3map_sunExt	0.6744	0.8647	1.0		0.7637	274.59	-19.96	2	16
	q3map_sunExt	0.6557	0.8529	1.0		0.7275	262.01	-51.25	2	16
	q3map_sunExt	0.6262	0.8629	1.0		0.6131	283.99	-38.34	2	16
	q3map_sunExt	0.7284	0.8994	1.0		0.9087	242.26	-36.83	2	16
	q3map_sunExt	0.7288	0.9041	1.0		0.7844	330.12	-52.72	2	16
	q3map_sunExt	0.7232	0.8937	1.0		0.7624	24.233	-50.62	2	16
	q3map_sunExt	0.8388	0.9434	1.0		1.4656	356.73	-43.08	2	16
	q3map_sunExt	0.8740	0.9648	1.0		1.4211	105.70	-32.54	2	16
	q3map_sunExt	0.8685	0.9591	1.0		1.4714	86.920	-46.64	2	16
	q3map_sunExt	0.7767	0.9126	1.0		3.1975	74.818	-15.41	2	16
	q3map_sunExt	0.8519	0.9610	1.0		1.3755	66.249	-33.98	2	16
	q3map_sunExt	0.7512	0.9027	1.0		3.0526	95.635	-14.64	2	16
	q3map_sunExt	0.7048	0.9048	1.0		0.5976	197.12	-48.82	2	16
	q3map_sunExt	0.8587	0.9561	1.0		1.6206	147.40	-46.88	2	16
	q3map_sunExt	0.8380	0.9489	1.0		1.4543	172.72	-38.83	2	16
	q3map_sunExt	0.7567	0.8964	1.0		4.3690	157.34	12.777	2	16
	q3map_sunExt	0.7238	0.8912	1.0		1.9681	156.79	-7.325	2	16
	q3map_sunExt	0.6820	0.8775	1.0		4.0164	125.62	3.1373	2	16
	q3map_sunExt	0.7759	0.9199	1.0		1.5245	137.26	-13.31	2	16
	q3map_sunExt	0.7481	0.8932	1.0		4.8007	137.59	19.499	2	16
	q3map_sunExt	0.6295	0.8308	1.0		4.9848	192.75	11.374	2	16
	q3map_sunExt	0.8258	0.9361	1.0		5.9075	212.75	16.685	2	16
	q3map_sunExt	0.7122	0.8898	1.0		1.4129	210.92	-16.08	2	16
	q3map_sunExt	0.7125	0.8748	1.0		2.8112	223.61	-0.343	2	16
	q3map_sunExt	0.7066	0.8725	1.0		2.0549	191.74	-8.711	2	16
	q3map_sunExt	0.5283	0.7968	1.0		7.0345	332.96	27.179	2	16
	q3map_sunExt	0.7527	0.8984	1.0		3.7793	354.66	-2.128	2	16
	q3map_sunExt	0.6259	0.8739	1.0		9.9599	13.894	28.792	2	16
	q3map_sunExt	0.7860	0.9124	1.0		9.8122	51.895	18.816	2	16
	q3map_sunExt	0.4473	0.7320	1.0		7.5309	48.643	54.730	2	16
	q3map_sunExt	0.7125	0.8651	1.0		6.5596	115.43	57.076	2	16
	q3map_sunExt	0.6884	0.8602	1.0		5.9424	307.32	86.861	2	16
	q3map_sunExt	0.2795	0.6521	1.0		1.4047	236.95	53.050	2	16
	q3map_sunExt	0.5850	0.8002	1.0		4.9306	297.09	50.914	2	16
	q3map_sunExt	0.7501	0.8974	1.0		6.1790	296.51	14.917	2	16
	q3map_sunExt	0.7474	0.8959	1.0		2.3860	264.57	-2.306	2	16
	q3map_sunExt	0.7872	0.9308	1.0		1.0186	296.12	-21.08	2	16
	q3map_sunExt	0.5515	0.8333	1.0		0.3982	295.43	-57.07	2	16
	q3map_sunExt	0.8563	0.9499	1.0		1.4454	334.58	-32.80	2	16
	q3map_sunExt	0.8497	0.9501	1.0		1.6724	17.258	-31.12	2	16
	q3map_sunExt	0.8090	0.9414	1.0		1.1589	56.953	-53.05	2	16
	q3map_sunExt	0.7745	0.9149	1.0		2.4389	53.859	-17.13	2	16
	q3map_sunExt	0.7515	0.8940	1.0		4.1481	84.578	2.3060	2	16
	q3map_sunExt	0.7885	0.9361	1.0		0.9493	228.64	-54.73	2	16
	q3map_sunExt	0.8200	0.9431	1.0		1.1340	117.09	-50.91	2	16
	q3map_sunExt	0.7481	0.8897	1.0		5.5626	154.58	32.801	2	16
	q3map_sunExt	0.8458	0.9499	1.0		1.4160	152.96	-27.17	2	16
	q3map_sunExt	0.8022	0.9261	1.0		1.9189	116.51	-14.91	2	16
	q3map_sunExt	0.5242	0.7729	1.0		4.3637	116.12	21.080	2	16
	q3map_sunExt	0.7076	0.8732	1.0		2.6345	174.66	2.1282	2	16
	q3map_sunExt	0.3855	0.7023	1.0		2.6832	197.25	31.121	2	16
	q3map_sunExt	0.4631	0.7378	1.0		3.8573	233.85	17.131	2	16
	q3map_sunExt	0.7625	0.9123	1.0		1.4190	231.89	-18.81	2	16
	q3map_sunExt	0.7805	0.9345	1.0		1.1819	193.89	-28.79	2	16
}

textures/skies_MASTER2/ik_lake-orange
{
	qer_editorImage skpk/qer/env/mkbase-actf/mkbase-actf.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.996 0.606 0.276 85 31 60 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/mkbase-actf/mkbase-actf - -
}

textures/skies_MASTER2/null_urt1
{
	qer_editorImage skpk/qer/env/null_urt1/sunset.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt .972 .741 .0504 75 40 11 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 60 4
	nopicmip
	skyparms skpk/env/null_urt1/sunset - -
}

textures/skies_MASTER2/ocean
{
	qer_editorImage skpk/qer/env/ocean01.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt .637 .965 1 75 -55 43 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 55 4
	nopicmip
	skyparms skpk/env/ocean01 - -
}

textures/skies_MASTER2/shibam
{
	qer_editorImage skpk/qer/env/shibam.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 242 135 83 40 -140 3 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 25 4
	nopicmip
	skyparms skpk/env/shibam - -
//	original
//	q3map_sunExt 242 135 83 40 217 8 1 32
//	q3map_LightMapFilterRadius 0 32
//	q3map_skylight 25 6
}

textures/skies_MASTER2/plduel1
{
	qer_editorImage skpk/qer/env/plduel1/sky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.949 0.805 0.332 40 -179 2 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 65 4
	nopicmip
	skyparms skpk/env/plduel1/sky - -
}

textures/skies_MASTER2/prophecy
{
	qer_editorImage skpk/qer/env/prophecy.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 5 0 90 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 75 4
	nopicmip
	skyparms skpk/env/prophecy - -
}

textures/skies_MASTER2/swampy
{
	qer_editorImage skpk/qer/env/swampy/swampy.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 95 4
	nopicmip
	skyparms skpk/env/swampy/swampy - -
}

textures/skies_MASTER2/yoda
{
	qer_editorImage skpk/qer/env/q3f_yoda_env/q3f_2garden2sky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 75 57 14 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 55 4
	nopicmip
	skyparms skpk/env/q3f_yoda_env/q3f_2garden2sky - -
}

textures/skies_MASTER2/grandcanyon
{
	qer_editorImage skpk/qer/env/q3r_grandcanyon/desert.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 75 -29 25 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 55 4
	nopicmip
	skyparms skpk/env/q3r_grandcanyon/desert - -
}

textures/skies_MASTER2/QP
{
	qer_editorImage skpk/qer/env/QP/qpca.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 1 74 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/QP/qpca - -
}

textures/skies_MASTER2/ra3shov1_jorsky
{
	qer_editorImage skpk/qer/env/ra3shov1/ra3shov1jorsky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 30 142 73 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/ra3shov1/ra3shov1jorsky - -
}

textures/skies_MASTER2/ra3shov1_sifsky
{
	qer_editorImage skpk/qer/env/ra3shov1/ra3shov1sifsky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 75 178 52 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/ra3shov1/ra3shov1sifsky - -
}

textures/skies_MASTER2/rroff3dm4
{
	qer_editorImage skpk/qer/env/rroff3dm4.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 .721 .445 35 -37 27 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 85 4
	nopicmip
	skyparms skpk/env/rroff3dm4 - -
}

textures/skies_MASTER2/lun4
{
	qer_editorImage skpk/qer/env/aty9sky/lun4.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 55 -58 60 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 75 4
	nopicmip
	skyparms skpk/env/aty9sky/lun4 - -
}

textures/skies_MASTER2/sky_2
{
	qer_editorImage skpk/qer/env/sky_2/sky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 3 -171 19 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 95 4
	nopicmip
	skyparms skpk/env/sky_2/sky - -
}

textures/skies_MASTER2/alpine
{
	qer_editorImage skpk/qer/textures/alpine/env/skybox.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 45 159 23 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 60 4
	nopicmip
	skyparms skpk/textures/alpine/env/skybox - -
}

textures/skies_MASTER3/byss
{
	qer_editorImage skpk/qer/env/sliceysky/byss.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 35 173 21 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/sliceysky/byss - -
}

textures/skies_MASTER3/korb
{
	qer_editorImage skpk/qer/env/sliceysky2/korb.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 .814 .336 55 -90 46 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/sliceysky2/korb - -
}

textures/skies_MASTER2/snorock
{
	qer_editorImage skpk/qer/env/snorock.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_lightRGB 180 200 255
	q3map_skylight 40 4 0 90 0
	nopicmip
	skyparms skpk/env/snorock - -
}

textures/skies_MASTER2/snowtest
{
	qer_editorImage skpk/qer/env/snowtest/snowtest.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 50 -131 21 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 55 4
	nopicmip
	skyparms skpk/env/snowtest/snowtest - -
}

textures/skies_MASTER2/space2k2
{
	qer_editorImage skpk/qer/env/space2k2/space2k2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 75 14 20 2 16    //mid-sky
	q3map_sunExt 1 0 1 5 108 0 2 16     //horizon
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 75 4
	nopicmip
	skyparms skpk/env/space2k2/space2k2 - -
}

textures/skies_MASTER2/sunset4
{
	qer_editorImage skpk/qer/env/sunset4/sunset004.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 50 6 4 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 55 4
	nopicmip
	skyparms skpk/env/sunset4/sunset004 - -
}

textures/skies_MASTER2/tig_ra3_mistyvalley
{
	qer_editorImage skpk/qer/env/tig_ra3/mistyvalley.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 60 79 17 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 65 4
	nopicmip
	skyparms skpk/env/tig_ra3/mistyvalley - -
}

textures/skies_MASTER2/tig_ra3_overcast
{
	qer_editorImage skpk/qer/env/tig_ra3/overcast.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 50 100 0 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 75 4
	nopicmip
	skyparms skpk/env/tig_ra3/overcast - -
}

textures/skies_MASTER2/tm2_asnagrim
{
	qer_editorImage skpk/qer/env/tm2_asnagrim/asnadarksky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 5 0 90 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 90 4
	nopicmip
	skyparms skpk/env/tm2_asnagrim/asnadarksky - -
}

textures/skies_MASTER2/Toxic
{
	qer_editorImage skpk/qer/env/Toxic/toxic.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt .404 .707 0 25 -134 50 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 80 4
	nopicmip
	skyparms skpk/env/Toxic/toxic - -
}

textures/skies_MASTER2/ut4_laberinto_beta
{
	qer_editorImage skpk/qer/env/ut4_laberinto_beta/med.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 75 138 66 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 55 4
	nopicmip
	skyparms skpk/env/ut4_laberinto_beta/med - -
}

//============================================

textures/skies_MASTER6/13dawn-sun
{
	qer_editorImage skpk/qer/6/13dawn-sun.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 0.9 0.7 50 -131 54 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 80 4
	nopicmip
	skyParms skpk/textures/13dawn/env/filter 512 -
	{
		map textures/skies/dimclouds.tga
		blendfunc filter
		rgbGen const ( 1 0.95 0.9 )
		tcMod scroll 0.05 0.1
		tcMod scale 2 2
	}
	{
		map skpk/textures/13dawn/sun.tga
		blendfunc add
		rgbGen wave noise 0.5 0.2 0 1
		tcMod scale 0.615 0.615
	}
}

textures/skies_MASTER6/13gate_xt
{
	qer_editorImage skpk/qer/6/13gate_xt.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 80 4
	nopicmip
	skyParms skpk/textures/13dawn/env/filter 384 -
	{
		map skpk/textures/13gate_xt/sky.tga
		blendfunc filter
		tcMod scroll 0.05 0.1
		tcMod scale 2 2
	}
}

textures/skies_MASTER6/13ground
{
	qer_editorImage skpk/qer/6/13ground.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 90 4
	nopicmip
	skyParms - 512 -
	{
		map textures/skies/inteldimclouds.tga
		tcMod scroll 0.1 0.1
		tcMod scale 3 2
		depthWrite
	}
	{
		map textures/skies/intelredclouds.tga
		blendfunc add
		tcMod scroll 0.05 0.05
		tcMod scale 3 3
	}
}

textures/skies_MASTER6/13matrix
{
	qer_editorImage skpk/qer/6/13matrix.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 90 4
	nopicmip
	skyParms - 512 -
	{
		map textures/skies/dimclouds.tga
		rgbGen const ( 0 0.2 0 )
		tcMod scale 3 2
		tcMod scroll 0.015 0.015
		depthWrite
	}
	{
		map textures/skies/topclouds.tga
		blendfunc add
		rgbGen const ( 0.2 0.2 0.2 )
		tcMod scale 2 3
		tcMod scroll 0.005 0.005
	}
}

textures/skies_MASTER6/13quake-q1sky
{
	qer_editorImage skpk/qer/6/13quake-q1sky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 90 4
	nopicmip
	skyParms - 256 -
	{
		map skpk/textures/13quake/clouds_top.tga
		tcMod scroll 0.005 0.0025
		tcMod scale 20 20
		depthWrite
	}
	{
		map skpk/textures/13quake/clouds_filter.tga
		blendfunc blend
		tcMod scroll 0.015 0.01
		tcMod scale 16 16
	}
}

textures/skies_MASTER6/13quake-q1sky2flash
{
	qer_editorImage skpk/qer/6/13quake-q1sky2flash.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 90 4
	nopicmip
	skyParms - 256 -
	{
		map skpk/textures/13quake/clouds_top.tga
		rgbGen wave noise 0.8 0.2 0 1
		tcMod scroll 0.005 0.0025
		tcMod scale 5 5
		depthWrite
	}
	{
		map skpk/textures/13quake/clouds_filter.tga
		blendfunc blend
		tcMod scroll 0.015 0.01
		tcMod scale 4 4
	}
}

textures/skies_MASTER6/13simple-topclouds
{
	qer_editorImage skpk/qer/6/13simple-topclouds.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 90 4
	nopicmip
	skyParms - 400 -
	{
		map textures/skies/dimclouds.tga
		rgbGen const ( 0.5 0.5 0.5 )
		tcMod scroll 0.01 0.004
		tcMod scale 8 8
	}
	{
		map skpk/textures/13simple/sky_filter.tga
		blendfunc filter
		rgbGen const ( 0.1 0.1 0.1 )
		tcMod scale 1.59 1.59
	}
}

textures/skies_MASTER2/13sky
{
	qer_editorImage skpk/qer/textures/13sky/env/sky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 90 4
	nopicmip
	skyParms skpk/textures/13sky/env/sky - -
}

textures/skies_MASTER/hip_grimm-clouds
{
	qer_editorImage skpk/qer/env/hip_grimm/grimmnight-clouds.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 40 341 22 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/hip_grimm/grimmnight - -
	{
		map textures/skies/dimclouds.tga
		rgbGen const ( 0.7 0.9 1 )
		blendfunc filter
		tcMod scroll 0.004 0.002
		tcMod scale 8 8
	}
}

textures/skies_MASTER2/20bspacesky
{
	qer_editorImage skpk/qer/textures/20bspace/spacesky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 100 4
	nopicmip
	skyparms skpk/textures/20bspace/spacesky - -
}

textures/skies_MASTER6/20kdm3
{
	qer_editorImage skpk/qer/6/20kdm3.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 90 4
	nopicmip
	skyparms - 512 -
	{
		map skpk/textures/20kdm3/tssfx16.tga
		tcMod scroll 0.05 .1
		tcMod scale 2 2
		depthWrite
	}
	{
		map skpk/textures/20kdm3/tssfx17.tga
		blendfunc GL_ONE GL_ONE
		tcMod scroll 0.05 0.06
		tcMod scale 3 2
	}
}

textures/skies_MASTER2/5th_starsky-clouds
{
	qer_editorImage skpk/qer/env/5th_starsky/starzsky-clouds.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.937 0.932 1. 15 38 52 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 75 4
	nopicmip
	skyparms skpk/env/5th_starsky/starzsky 512 -
	{
		map skpk/textures/5th_clouds/clouds-5.tga
		blendfunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		tcMod scale 3 3
		tcMod scroll 0.003 0.005
	}
}

textures/skies_MASTER2/K_sky-rabbit
{
	qer_editorImage skpk/qer/env/K_sky/rabbit.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 15 -129 76 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 85 4
	nopicmip
	skyparms skpk/env/K_sky/rabbit - -
}

textures/skies_MASTER2/79drgc2
{
	qer_editorImage skpk/qer/env/79drgc2/79drgc2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 95 4
	nopicmip
	skyParms skpk/env/79drgc2/79drgc2 - -
}

textures/skies_MASTER6/a-spec-q3-sky
{
	qer_editorImage skpk/qer/6/a-spec-q3-sky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 95 4
	nopicmip
	skyparms - 512 -
	{
		map skpk/textures/a-spec-cieux/a-spec-q3-sky_1.tga
		tcMod scroll 0.05 .1
		tcMod scale 2 2
	}
	{
		map skpk/textures/a-spec-cieux/a-spec-q3-sky_2.tga
		blendfunc GL_ONE GL_ONE
		tcMod scroll 0.05 0.06
		tcMod scale 3 2
	}
}

textures/skies_MASTER6/sclouds1
{
	qer_editorImage skpk/qer/6/sclouds1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 95 4
	nopicmip
	skyparms - 256 -
	{
		map skpk/textures/castle/sclouds1.tga
		tcMod scale 3 2
		tcMod scroll 0.025 0.025
		depthWrite
	}
	{
		map skpk/textures/castle/sclouds2.tga
		blendFunc GL_ONE GL_ONE
		tcMod scale 3 3
		tcMod scroll 0.015 0.015
	}
}

textures/skies_MASTER6/acid_rushed
{
	qer_editorImage skpk/qer/6/acid_rushed.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 75 4
	nopicmip
	skyParms - 512 -
	{
		map skpk/textures/acid_rushed/sky.tga
		blendfunc gl_one_minus_dst_color gl_src_alpha
		tcMod scroll 0.1 -0.1
		tcMod scale 4 4
	}
	{
		map skpk/textures/acid_rushed/sky_clouds.tga
		blendfunc filter
		tcMod scroll 0.1 0.1
		tcMod scale 4 4
	}
}

textures/skies_MASTER6/acua-qtj_sky1
{
	qer_editorImage skpk/qer/6/acua-qtj_sky1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 95 4
	nopicmip
	skyparms - 384 -
	{
		map skpk/textures/acua/qtj_sky1.tga
		tcMod scroll 0.03 0.05
		tcMod scale 2 2
		depthWrite
	}
	{
		map skpk/textures/acua/qtj_sky2.tga
		blendfunc GL_ONE GL_ONE
		tcMod scroll 0.0025 0.003
		tcMod scale 3 2
	}
}

textures/skies_MASTER6/ad5_purple-sky
{
	qer_editorImage skpk/qer/6/ad5_purple-sky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 95 4
	nopicmip
	skyparms - 512 -
	{
		map skpk/textures/ad5_sfx/purplesky2.tga
		tcMod scroll .07 .01
		tcMod scale 2 2
		depthWrite
	}
}

textures/skies_MASTER6/ad5_darkpurplesky
{
	qer_editorImage skpk/qer/6/ad5_darkpurplesky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 85 4
	nopicmip
	skyparms - 512 -
	{
		map skpk/textures/ad5_sfx/purplesky1.tga
		tcMod scale 3 2
		tcMod scroll 0.15 0.15
		depthWrite
	}
	{
		map skpk/textures/ad5_sfx/darkskytop.tga
		blendFunc GL_ONE GL_ONE
		tcMod scale 3 3
		tcMod scroll 0.07 0.05
	}
}

textures/skies_MASTER6/ad5_darkpurplesky2
{
	qer_editorImage skpk/qer/6/ad5_darkpurplesky2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 95 4
	nopicmip
	skyparms - 512 -
	{
		map skpk/textures/ad5_sfx/purplesky2.tga
		tcMod scale 3 2
		tcMod scroll 0.15 0.15
		depthWrite
	}
	{
		map skpk/textures/ad5_sfx/darkskytop.tga
		blendFunc GL_ONE GL_ONE
		tcMod scale 2 2
		tcMod scroll 0.05 0.05
	}
}

textures/skies_MASTER6/pj_dm9sky
{
	qer_editorImage skpk/qer/6/pj_dm9sky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 95 4
	nopicmip
	skyparms - 512 -
	{
		map textures/skies/bluedimclouds.tga
		tcMod scale 3 2
		tcMod scroll 0.15 0.15
		depthWrite
	}
	{
		map textures/skies/topclouds.tga
		blendFunc GL_ONE GL_ONE
		tcMod scale 3 3
		tcMod scroll 0.05 0.05
	}
}

textures/skies_MASTER6/dimclouds
{
	qer_editorImage skpk/qer/6/dimclouds.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 90 4
	nopicmip
	skyparms - 512 -
	{
		map textures/skies/dimclouds.tga
		tcMod scroll 0.02 0
		tcMod scale 1 1
		depthWrite
	}
	{
		map textures/skies/dimclouds.tga
		blendFunc GL_ONE GL_ONE
		tcMod scroll 0.02 0.01
		tcMod scale 3 3
	}
}

textures/skies_MASTER2/alien_skybox
{
	qer_editorImage skpk/qer/env/alien.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.552941 0.901961 0.568627 45 -44 86 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/alien - -
}

textures/skies_MASTER2/space_sky_high
{
	qer_editorImage skpk/qer/textures/env/ema_h.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.94902 0.815686 0.32549 70 -90 1 2 16
	q3map_sunExt 1 1 1 10 0 90 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 85 4
	nopicmip
	skyParms skpk/textures/env/ema_h - -
}

textures/skies_MASTER6/ikbase_xnight
{
	qer_editorImage skpk/qer/6/ikbase_xnight.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 20 -43 60 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 60 4
	nopicmip
	skyparms env/xnight2 512 -
	{
		map skpk/textures/ikbase_sky/ik_sky_night_back.tga
		blendfunc GL_ONE GL_ONE
		tcMod scroll 0.015 0.016
		tcMod scale 3 3
	}
	{
		map skpk/textures/ikbase_sky/ik_sky_night_front.tga
		blendFunc GL_ONE GL_ONE
		tcMod scroll -0.01 -0.012
		tcMod scale 5 5
	}
}

textures/skies_MASTER6/phobossky1
{
	qer_editorImage skpk/qer/6/phobossky1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 77 4
	nopicmip
	skyparms - 720 -
	{
		map skpk/textures/lun3dm3/sky1.tga
		tcMod scale 2 2
		tcMod scroll .006 .005
	}
	{
		map skpk/textures/lun3dm3/sky2.tga
		blendFunc GL_ONE GL_ONE
		tcMod scroll -0.006 0.00045
	}
}

textures/skies_MASTER6/stars_red_1
{
	qer_editorImage skpk/qer/6/stars_red_1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 100 4
	nopicmip
	skyparms - 384 -
	{
		map textures/skies/killsky_1.tga
		tcMod scroll 0.05 .1
		tcMod scale 2 2
		depthWrite
	}
	{
		map textures/skies/killsky_2.tga
		blendfunc GL_ONE GL_ONE
		tcMod scroll 0.05 0.06
		tcMod scale 3 2
	}
}

textures/skies_MASTER/ame_almostparadise
{
	qer_editorImage skpk/qer/env/amethyst7/almostparadise/almostparadise.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 .9 80 9 24 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 60 4
	nopicmip
	skyparms skpk/env/amethyst7/almostparadise/almostparadise - -
}

textures/skies_MASTER6/0color_alpine_assault
{
	qer_editorImage skpk/qer/6/0color_alpine_assault.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 95 4
	nopicmip
	skyparms skpk/env/mono/056-058-059 512 -
	{
		map skpk/textures/skies_sd/goldrush_clouds.tga
		tcMod scale 5 5
		tcMod scroll 0.0015 -0.003
		rgbGen identityLighting
	}
	{
		map skpk/textures/alpine_assault/nightsky_modi.tga
		blendfunc GL_ONE GL_ONE
		tcMod scale 10 10
	}
	{
		map skpk/textures/skies/nightsky1.tga
		tcMod scale 10 10
		blendfunc add
		rgbGen identityLighting
	}
	{
		clampmap skpk/textures/alpine_assault/aa_mask_modi2-077-077-077.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		tcMod scale 0.956 0.956
		tcMod transform 1 0 0 1 -1 -1
		rgbGen identityLighting
	}
}

textures/skies_MASTER6/Amon_nightsky-clouds
{
	qer_editorImage skpk/qer/6/Amon_nightsky-clouds.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt .1 .26 .55 25 -40 60 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/Amonxnight2 - -
	{
		map skpk/textures/Amon/pjbasesky_Amon.tga
		blendfunc GL_ONE GL_ONE
		tcMod scroll 0.05 0
		tcMod scale 1 1
	}
}

textures/skies_MASTER/ame_desert-clouds
{
	qer_editorImage skpk/qer/env/ame_desert/desertsky-clouds.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt .934 .835 1 75 210 35 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/ame_desert/desertsky - -
	{
		map skpk/env/ame_darkgloom/clouds.tga
		blendFunc filter
		tcMod scroll 0.005 0.005
		tcMod scale 3 3
	}
}

textures/skies_MASTER/mp_elemental-clouds
{
	qer_editorImage skpk/qer/env/mp_elemental/elemental-clouds.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 90 4
	nopicmip
	skyparms skpk/env/mp_elemental/elemental - -
	{
		map textures/skies/bluedimclouds.tga
		blendFunc add
		tcMod scroll 0.03 0.02
		tcMod scale 4 4
	}
}

textures/skies_MASTER6/0color_navyBlue_gradient
{
	qer_editorImage skpk/qer/env/cube.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_lightRGB 2 3 4
	q3map_skylight 90 4 0 90 0
	nopicmip
	skyParms skpk/env/cube - -
}

textures/skies_MASTER6/bluesky-annihilation
{
	qer_editorImage skpk/qer/6/bluesky-annihilation.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 90 4
	nopicmip
	skyparms - 512 -
	{
		map skpk/textures/bluesky/bluesky.tga
		tcMod scroll 0.1 0.1
		tcMod scale 3 2
	}
	{
		map skpk/textures/bluesky/bluesky.tga
		blendFunc add
		tcMod scroll .05 .05
		tcMod scale 3 3
	}
}

textures/skies_MASTER6/dimclouds-slow
{
	qer_editorImage skpk/qer/6/dimclouds-slow.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 90 4
	nopicmip
	skyparms - 512 -
	{
		map textures/skies/dimclouds.tga
		tcMod scroll 0.005 0
		tcMod scale 1 1
		depthWrite
	}
	{
		map textures/skies/dimclouds.tga
		blendFunc GL_ONE GL_ONE
		tcMod scroll 0.005 0.0025
		tcMod scale 3 3
	}
}

textures/skies_MASTER2/qbert_sky
{
	qer_editorImage skpk/qer/textures/aphooked_ctf1/env/qbert.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt .5 .37 .19 50 -90 0 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/textures/aphooked_ctf1/env/qbert - -
}

textures/skies_MASTER/deepsea-darker
{
	qer_editorImage skpk/qer/env/aquasea/aquasea.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 5 0 90 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 100 4
	nopicmip
	skyParms skpk/env/aquasea/aquasea - -
}

textures/skies_MASTER2/arcsky1
{
	qer_editorImage skpk/qer/env/arcsky/arcsky1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt .9 .9 1 70 45 30 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 100 4
	nopicmip
	skyparms skpk/env/arcsky/arcsky1 - -
}

textures/skies_MASTER2/arcsky2-clouds
{
	qer_editorImage skpk/qer/env/arcsky/arcsky2-clouds.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt .9 .9 1 45 0 70 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 100 4
	nopicmip
	skyparms skpk/env/arcsky/arcsky2 1024 -
	{
		map textures/skies/dimclouds.tga
		blendFunc add
		tcMod scroll 0.05 0.05
		tcMod scale 3 3
	}
}

textures/skies_MASTER6/AspecQ3dm4T0
{
	qer_editorImage skpk/qer/6/AspecQ3dm4T0.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 90 4
	nopicmip
	skyparms - 512 -
	{
		map skpk/textures/AspecQ3dm4/AspecQ3dm4T0_1.tga
		tcMod scroll 0.05 .1
		tcMod scale 2 2
	}
	{
		map skpk/textures/AspecQ3dm4/AspecQ3dm4T0_2.tga
		blendfunc GL_ONE GL_ONE
		tcMod scroll 0.05 0.06
		tcMod scale 3 2
	}
}

textures/skies_MASTER2/nubiansky2-clouds
{
	qer_editorImage skpk/qer/env/aty9sky/lun4-clouds.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 25 -58 60 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/aty9sky/lun4 768 -
	{
		map skpk/textures/aty3dm9/nubian3.tga
		tcMod scale 4 4
		tcMod scroll 0.05 0.05
		blendFunc GL_ONE GL_ONE
	}
}

textures/skies_MASTER6/auhsky
{
	qer_editorImage skpk/qer/6/auhsky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 90 4
	nopicmip
	skyparms - 512 -
	{
		map textures/skies/dimclouds.tga
		tcMod scroll 0.01 0.01
		tcMod scale 3 3
		depthWrite
	}
	{
		map skpk/textures/auh3dm1/auhsky.tga
		blendfunc GL_ONE GL_ONE
		tcMod scroll -0.01 -0.01
		tcMod scale 5 5
	}
}

textures/skies_MASTER6/avaspace-clouds
{
	qer_editorImage skpk/qer/6/avaspace-clouds.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.316383 0.324632 0.358662 10 90 0 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 95 4
	nopicmip
	skyparms skpk/env/avsky1 - -
	{
		map skpk/textures/avatar/avclouds3.tga
		blendFunc GL_ONE GL_ONE
		tcMod scroll 0.03 0.03
		tcMod scale 5 5
	}
}

textures/skies_MASTER6/avatar_cyan_clouds
{
	qer_editorImage skpk/qer/6/avatar_cyan_clouds.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 95 4
	nopicmip
	skyparms - 512 -
	{
		map skpk/textures/avatar/cyansky.tga
		tcMod scale 3 2
		tcMod scroll 0.15 0.15
		depthWrite
	}
	{
		map skpk/textures/avatar/avclouds2.tga
		blendFunc GL_ONE GL_ONE
		tcMod scale 3 3
		tcMod scroll 0.05 0.05
	}
}

textures/skies_MASTER6/avatar_firesky
{
	qer_editorImage skpk/qer/6/avatar_firesky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 95 4
	nopicmip
	skyparms - 512 -
	{
		map skpk/textures/avatar/firesky2.tga
		tcMod scale 7 7
		tcMod scroll 0.02 0.05
		depthWrite
	}
	{
		map skpk/textures/avatar/firesky1.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		tcMod scale 5 5
		tcMod scroll 0.03 0.06
	}
}

textures/skies_MASTER6/avatar_cloudyDay
{
	qer_editorImage skpk/qer/6/avatar_cloudyDay.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 95 4
	nopicmip
	skyparms - 512 -
	{
		map skpk/textures/avatar/greysky1.tga
		tcMod scale 7 7
		tcMod scroll 0.0 -0.02
		depthWrite
	}
	{
		map skpk/textures/avatar/bluesky2.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		tcMod scale 5 5
		tcMod scroll 0.0 -0.04
	}
}

textures/skies_MASTER6/avatar_firesky2
{
	qer_editorImage skpk/qer/6/avatar_firesky2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 95 4
	nopicmip
	skyparms - 512 -
	{
		map skpk/textures/avatar/firesky3.tga
		tcMod scale 1 1
		tcMod scroll 0.02 0.05
		depthWrite
	}
	{
		map skpk/textures/avatar/greysky1.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		tcMod scale 5 5
		tcMod scroll 0.03 0.06
	}
}

textures/skies_MASTER6/avatar_castlesky
{
	qer_editorImage skpk/qer/6/avatar_castlesky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 95 4
	nopicmip
	skyparms - 512 -
	{
		map skpk/textures/avatar/bluesky3.tga
		tcMod scale 7 7
		tcMod scroll 0.02 0.05
		depthWrite
	}
	{
		map skpk/textures/avatar/skyline1.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		tcMod scale 5 5
		tcMod scroll 0.03 0.06
	}
}

textures/skies_MASTER/ame_greywash-clouds
{
	qer_editorImage skpk/qer/env/ame_greywash/greywash-clouds.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 70 90 25 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/ame_greywash/greywash - -
	{
		map skpk/textures/chopcustom/starfield_clouds.tga
		blendFunc GL_ONE GL_ONE
		tcMod scale 5 5
		tcMod scroll 0.05 0.05
	}
}

textures/skies_MASTER2/bal3scrap_sky
{
	qer_editorImage skpk/qer/env/space1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 95 4
	nopicmip
	skyparms env/space1 - -
}

textures/skies_MASTER2/bap3dm1_skybox
{
	qer_editorImage skpk/qer/env/bap3dm1/bap3dm1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt .98 .77 .65 70 -29 43 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 65 4
	nopicmip
	skyparms skpk/env/bap3dm1/bap3dm1 - -
}

textures/skies_MASTER6/clocksky3
{
	qer_editorImage skpk/qer/6/clocksky3.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 95 4
	nopicmip
	skyparms - 512 -
	{
		map skpk/textures/bap3_dm2/ornjsky2.tga
		tcMod scale 2 2
		tcMod scroll 0.05 0.05
		depthWrite
	}
	{
		map skpk/textures/bap3_dm2/ornjsky1.tga
		blendFunc GL_ONE GL_ONE
		tcMod scale 3 3
		tcMod scroll 0.02 0.02
	}
}

textures/skies_MASTER6/overcast3
{
	qer_editorImage skpk/qer/6/overcast3.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 95 4
	nopicmip
	skyParms - 1280 -
	{
		map skpk/textures/df_skies/cloudsupper.tga
		rgbGen identity
		tcMod scroll 0.01 0.001
		depthWrite
	}
	{
		map textures/skies/dimclouds.tga
		rgbGen identity
		tcMod scroll 0.02 0.002
		depthWrite
	}
	{
		map textures/skies/dimclouds.tga
		blendfunc add
		rgbGen identity
		tcMod scroll 0.03 0.003
		tcMod scale 3 3
	}
}

textures/skies_MASTER/sb_frozendusk-topclouds
{
	qer_editorImage skpk/qer/env/sb_frozendusk/frozendusk-topclouds.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 0.84 0 85 250 20 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/sb_frozendusk/frozendusk - -
	{
		map textures/skies/topclouds.tga
		blendFunc GL_ONE GL_ONE
		tcMod scale 3 2
		tcMod scroll 0.025 0.025
	}
}

textures/skies_MASTER/sb_frozendusk-dimclouds
{
	qer_editorImage skpk/qer/env/sb_frozendusk/frozendusk-dimclouds.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 0.84 0 85 250 20 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/sb_frozendusk/frozendusk - -
	{
		map textures/skies/dimclouds.tga
		blendFunc GL_ONE GL_ONE
		tcMod scale 3 2
		tcMod scroll 0.025 0.025
	}
}

textures/skies_MASTER/sb_frozendusk-redclouds
{
	qer_editorImage skpk/qer/env/sb_frozendusk/frozendusk-redclouds.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 0.84 0 85 250 20 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/sb_frozendusk/frozendusk - -
	{
		map skpk/textures/bastir/topredclouds.tga
		blendFunc GL_ONE GL_ONE
		tcMod scale 3 2
		tcMod scroll 0.025 0.025
	}
}

textures/skies_MASTER2/m3a_bb1on1-red
{
	qer_editorImage skpk/qer/textures/bbq3dm2/bbq3dm2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 .73 .73 80 -92 29 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/textures/bbq3dm2/bbq3dm2 - -
}

textures/skies_MASTER6/xnight2-topclouds
{
	qer_editorImage skpk/qer/6/xnight2-topclouds.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 10 -41 55 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyParms env/xnight2 256 -
	{
		map textures/skies/topclouds.tga
		blendfunc add
		tcMod scroll 0.02 0.02
		tcMod scale 1.2 1.2
	}
}

textures/skies_MASTER6/0color_brown
{
	qer_editorImage skpk/qer/env/bensky/bensky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyparms skpk/env/bensky/bensky - -
}

textures/skies_MASTER6/0color_wurzburg_clouds
{
	qer_editorImage skpk/qer/6/0color_wurzburg_clouds.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_lightRGB 0.8 0.9 1.0
	q3map_skylight 95 4 0 90 0
	nopicmip
	skyparms skpk/env/mono/102-102-102 512 -
	{
		map skpk/textures/skies_sd/battery_clouds.tga
		tcMod scale 2.5 2.5
		tcMod scroll 0.0015 -0.003
		rgbGen identityLighting
	}
	{
		clampmap skpk/textures/skies_sd/battery_mask_ydnar-102-102-102.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		tcMod scale 0.956 0.956
		tcMod transform 1 0 0 1 -1 -1
		rgbGen identityLighting
	}
}

textures/skies_MASTER2/berky_fruit
{
	qer_editorImage skpk/qer/env/fruit.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt .9 .9 1 55 -29 23 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 65 4
	nopicmip
	skyparms skpk/env/fruit - -
}

textures/skies_MASTER2/bgc_rain
{
	qer_editorImage skpk/qer/env/rain/rain.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 95 4
	nopicmip
	skyparms skpk/env/rain/rain - -
}

textures/skies_MASTER3/spa-jump-dark
{
	qer_editorImage skpk/qer/env/bgmp0/spa-jump512.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt .462 1 .850 40 -37 12 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 75 4
	nopicmip
	skyparms skpk/env/bgmp0/spa-jump512 - -
}

textures/skies_MASTER/sb_strato-yellow
{
	qer_editorImage skpk/qer/env/bgmp1/bgmp1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_sunExt 0.882353 0.580392 0.505882 85 -90 48 11 16
	q3map_skylight 75 4
	nopicmip
	skyparms skpk/env/bgmp1/bgmp1 - -
}

textures/skies_MASTER6/firegorre
{
	qer_editorImage skpk/qer/6/firegorre.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 90 4
	nopicmip
	skyparms - 512 -
	{
		map textures/sfx/firegorre.tga
		tcMod scroll 0 0.4
		tcMod scale 1 1
		depthWrite
	}
	{
		map textures/sfx/firegorre.tga
		blendFunc GL_ONE GL_ONE
		tcMod scroll 0 0.2
		tcMod scale 3 3
	}
}

textures/skies_MASTER6/sour_clansky
{
	qer_editorImage skpk/qer/6/sour_clansky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 95 4
	nopicmip
	skyparms - 1024 -
	{
		map textures/skies/dimclouds.tga
		tcMod scroll 0.01 0.01
		tcMod scale 3 3
		depthWrite
	}
	{
		map textures/skies/pjbasesky.tga
		blendfunc GL_ONE GL_ONE
		tcMod scroll -0.01 -0.01
		tcMod scale 5 5
	}
}

textures/skies_MASTER6/blem_sky
{
	qer_editorImage skpk/qer/6/blem_sky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 105 4
	nopicmip
	skyparms - 512 -
	{
		map skpk/textures/blemish/clouds1.tga
		tcMod scale 3 2
		tcMod scroll 0.015 0.015
	}
	{
		map skpk/textures/blemish/clouds2.tga
		blendFunc GL_ONE GL_ONE
		tcMod scale 3 3
		tcMod scroll 0.005 0.005
	}
}

textures/skies_MASTER6/cloudsky-clouds
{
	qer_editorImage skpk/qer/6/cloudsky-clouds.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 100 4
	nopicmip
	skyParms skpk/env/cloudsky/cloudsky 64 -
	{
		map textures/skies/dimclouds.tga
		blendfunc add
		tcMod scroll 0.015 0.016
		tcMod scale 3 3
		depthWrite
	}
}

textures/skies_MASTER2/opus_1_magnetron_v2
{
	qer_editorImage skpk/qer/env/box_noob_opus_1_magnetron_v2/b_sky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt .627 .525 0.392 60 136 1 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 90 4
	nopicmip
	skyparms skpk/env/box_noob_opus_1_magnetron_v2/b_sky - -
}

textures/skies_MASTER2/opus_2_infinity_v2
{
	qer_editorImage skpk/qer/env/box_noob_opus_2_infinity_v2/b_sky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 100 4
	nopicmip
	skyparms skpk/env/box_noob_opus_2_infinity_v2/b_sky - -
}

textures/skies_MASTER6/wintersky-clouds
{
	qer_editorImage skpk/qer/6/wintersky-clouds.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 30 -35 10 5 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/whitesky/white 512 -
	{
		map skpk/textures/wintersky/wintersky_clouds.tga
		tcMod scale 2.5 2.5
		tcMod scroll 0.0015 -0.0003
		rgbGen identityLighting
	}
	{
		map skpk/textures/wintersky/wintersky_mask.tga
		blendFunc GL_ONE_MINUS_SRC_ALPHA GL_SRC_ALPHA
		tcMod transform 0.25 0 0 0.25 0.1075 0.1075
		rgbGen identityLighting
	}
}

textures/skies_MASTER6/velvet_sky
{
	qer_editorImage skpk/qer/6/velvet_sky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 120 4
	nopicmip
	skyparms - 512 -
	{
		map skpk/textures/bz_q1start/velvet_sky_b.tga
		tcMod scroll 0.05 0
		tcMod scale 2 2
		depthWrite
	}
	{
		map skpk/textures/bz_q1start/velvet_sky_a.tga
		blendFunc blend
		tcMod scroll 0.02 0.01
		tcMod scale 3 3
	}
}

textures/skies_MASTER6/redsky
{
	qer_editorImage skpk/qer/6/redsky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 130 4
	nopicmip
	skyparms - 512 -
	{
		map textures/skies/killsky_1.tga
		tcMod scroll 0.005 .01
		tcMod scale 4 4
		depthWrite
	}
	{
		map textures/skies/killsky_2.tga
		blendfunc GL_ONE GL_ONE
		tcMod scroll 0.05 0.06
		tcMod scale 4 3
	}
}

textures/skies_MASTER6/cardigan_purpStars
{
	qer_editorImage skpk/qer/6/cardigan_purpStars.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 100 4
	nopicmip
	skyParms skpk/env/cardigan/purewhitej 1200 -
	{
		map skpk/textures/cardigan_skies1/starfield2.tga
		blendfunc add
		rgbGen identity
		tcMod scroll 0.03 0.03
		tcMod scale 2 2
	}
	{
		map skpk/textures/cardigan_skies1/sparse_purple_nebula.tga
		blendfunc filter
		tcMod scroll 0.05 0.06
	}
}

textures/skies_MASTER6/cardigan_purpNebula
{
	qer_editorImage skpk/qer/6/cardigan_purpNebula.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 100 4
	nopicmip
	skyParms skpk/env/cardigan/purewhitej 1200 -
	{
		map skpk/textures/cardigan_skies1/sparse_purple_nebula.tga
		blendfunc filter
		tcMod scroll 0.05 0.06
	}
}

textures/skies_MASTER6/cardigan_purpLightning
{
	qer_editorImage skpk/qer/6/cardigan_purpLightning.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 105 4
	nopicmip
	skyParms skpk/env/cardigan/purewhitej 1200 -
	{
		map skpk/textures/cardigan_skies1/circlegradlightningblur2.tga
		blendfunc add
		rgbGen wave noise 0 1 0 10
		tcMod scale 0.32 0.32
		tcMod rotate -20
	}
	{
		map skpk/textures/cardigan_skies1/sparse_purple_nebula.tga
		blendfunc filter
		tcMod scroll 0.05 0.06
	}
}

textures/skies_MASTER6/cardigan_orangeStars
{
	qer_editorImage skpk/qer/6/cardigan_orangeStars.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 100 4
	nopicmip
	skyParms skpk/env/cardigan/purewhitej 1200 -
	{
		map skpk/textures/cardigan_skies1/starfield2.tga
		blendfunc add
		rgbGen identity
		tcMod scroll 0.04 0.01
		tcMod scale 3 3
	}
	{
		map skpk/textures/cardigan_skies1/sparse_orange_nebula.tga
		blendfunc filter
		tcMod scroll 0.06 0.02
	}
}

textures/skies_MASTER6/cardigan_orangeNebula
{
	qer_editorImage skpk/qer/6/cardigan_orangeNebula.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 100 4
	nopicmip
	skyParms skpk/env/cardigan/purewhitej 1200 -
	{
		map skpk/textures/cardigan_skies1/sparse_orange_nebula.tga
		blendfunc filter
		tcMod scroll 0.06 0.02
	}
}

textures/skies_MASTER6/cardigan_orangeLightning
{
	qer_editorImage skpk/qer/6/cardigan_orangeLightning.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 100 4
	nopicmip
	skyParms skpk/env/cardigan/purewhitej 1200 -
	{
		map skpk/textures/cardigan_skies1/circlegradlightningblur2.tga
		blendfunc add
		rgbGen wave noise 0 1 0 10
		tcMod scale 0.32 0.32
		tcMod rotate 20
	}
	{
		map skpk/textures/cardigan_skies1/sparse_orange_nebula.tga
		blendfunc filter
		tcMod scroll 0.06 0.02
	}
}

textures/skies_MASTER6/cardigan_greenStars
{
	qer_editorImage skpk/qer/6/cardigan_greenStars.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 100 4
	nopicmip
	skyParms skpk/env/cardigan/purewhitej 1200 -
	{
		map skpk/textures/cardigan_skies1/starfield2.tga
		blendfunc add
		rgbGen identity
		tcMod scroll -0.03 0.01
		tcMod scale 3 3
	}
	{
		map skpk/textures/cardigan_skies1/sparse_green_nebula.tga
		blendfunc filter
		tcMod scroll -0.05 0.02
	}
}

textures/skies_MASTER6/cardigan_greenNebula
{
	qer_editorImage skpk/qer/6/cardigan_greenNebula.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_lightRGB 0.654902 0.988235 0.705882
	q3map_skyLight 100 4 0 90 0
	nopicmip
	skyParms skpk/env/cardigan/purewhitej 1200 -
	{
		map skpk/textures/cardigan_skies1/sparse_green_nebula.tga
		blendfunc filter
		tcMod scroll -0.05 0.02
	}
}

textures/skies_MASTER6/cardigan_greenLightning
{
	qer_editorImage skpk/qer/6/cardigan_greenLightning.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_lightRGB 0.654902 0.988235 0.705882
	q3map_skyLight 100 4 0 90 0
	nopicmip
	skyParms skpk/env/cardigan/purewhitej 1200 -
	{
		map skpk/textures/cardigan_skies1/circlegradlightningblur2.tga
		blendfunc add
		rgbGen wave noise 0 1 0 10
		tcMod scale 0.32 0.32
		tcMod rotate -20
	}
	{
		map skpk/textures/cardigan_skies1/sparse_green_nebula.tga
		blendfunc filter
		tcMod scroll -0.05 0.02
	}
}

textures/skies_MASTER6/cardigan_blueStars
{
	qer_editorImage skpk/qer/6/cardigan_blueStars.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 100 4
	nopicmip
	skyParms skpk/env/cardigan/purewhitej 1200 -
	{
		map skpk/textures/cardigan_skies1/starfield2.tga
		blendfunc add
		rgbGen identity
		tcMod scroll -0.05 0
		tcMod scale 3 3
	}
	{
		map skpk/textures/cardigan_skies1/sparse_blue_nebula.tga
		blendfunc filter
		tcMod scroll -0.08 0
	}
}

textures/skies_MASTER6/cardigan_blueNebula
{
	qer_editorImage skpk/qer/6/cardigan_blueNebula.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 100 4
	nopicmip
	skyParms skpk/env/cardigan/purewhitej 1200 -
	{
		map skpk/textures/cardigan_skies1/sparse_blue_nebula.tga
		blendfunc filter
		tcMod scroll -0.08 0
	}
}

textures/skies_MASTER6/cardigan_blueLightning
{
	qer_editorImage skpk/qer/6/cardigan_blueLightning.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 100 4
	nopicmip
	skyParms skpk/env/cardigan/purewhitej 1200 -
	{
		map skpk/textures/cardigan_skies1/circlegradlightningblur2.tga
		blendfunc add
		rgbGen wave noise 0 1 0 10
		tcMod scale 0.32 0.32
		tcMod rotate 20
	}
	{
		map skpk/textures/cardigan_skies1/sparse_blue_nebula.tga
		blendfunc filter
		tcMod scroll -0.08 0
	}
}

textures/skies_MASTER6/cardigan_blueColorShift
{
	qer_editorImage skpk/qer/6/cardigan_blueColorShift.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 100 4
	nopicmip
	skyParms skpk/env/cardigan/purewhitej 1200 -
	{
		map skpk/textures/cardigan_skies1/circlegradclouds2.tga
		blendfunc add
		rgbGen const ( 1 0 0 )
		tcMod scale 0.32 0.32
		tcMod rotate 20
	}
	{
		map skpk/textures/cardigan_skies1/sparse_blue_nebula.tga
		blendfunc filter
		tcMod scroll -0.08 0
	}
}

textures/skies_MASTER6/cardigan_orangeColorShift
{
	qer_editorImage skpk/qer/6/cardigan_orangeColorShift.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 100 4
	nopicmip
	skyParms skpk/env/cardigan/purewhitej 1200 -
	{
		map skpk/textures/cardigan_skies1/circlegradcloudsdark.tga
		blendfunc add
		rgbGen const ( 0.94902 0.282353 0 )
		tcMod scale 0.32 0.32
		tcMod rotate 12
	}
	{
		map skpk/textures/cardigan_skies1/sparse_orange_nebula.tga
		blendfunc filter
		tcMod scroll 0.06 0.02
	}
}

textures/skies_MASTER6/cardigan_purpColorShift
{
	qer_editorImage skpk/qer/6/cardigan_purpColorShift.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 100 4
	nopicmip
	skyParms skpk/env/cardigan/purewhitej 1200 -
	{
		map skpk/textures/cardigan_skies1/circlegradcloudsdark.tga
		blendfunc add
		rgbGen const ( 0 0 0.756863 )
		tcMod scale 0.32 0.32
		tcMod rotate 12
	}
	{
		map skpk/textures/cardigan_skies1/sparse_purple_nebula.tga
		blendfunc filter
		tcMod scroll 0.05 0.06
	}
}

textures/skies_MASTER6/cardigan_greenStars2
{
	qer_editorImage skpk/qer/6/cardigan_greenStars2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 100 4
	nopicmip
	skyParms skpk/env/cardigan/purewhitej 1200 -
	{
		map skpk/textures/cardigan_skies1/starfield2.tga
		blendfunc add
		rgbGen wave noise 0.7 0.3 0 20
		tcMod scroll 0.01 0.02
		tcMod scale 2 2
	}
	{
		map skpk/textures/cardigan_skies1/dense_green_nebula.tga
		blendfunc filter
		tcMod scroll 0.05 0.06
	}
}

textures/skies_MASTER6/cardigan_greenNebula2
{
	qer_editorImage skpk/qer/6/cardigan_greenNebula2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 100 4
	nopicmip
	skyParms skpk/env/cardigan/purewhitej 1200 -
	{
		map skpk/textures/cardigan_skies1/dense_green_nebula.tga
		blendfunc filter
		tcMod scroll 0.05 0.06
	}
}

textures/skies_MASTER6/cardigan_orangeStars2
{
	qer_editorImage skpk/qer/6/cardigan_orangeStars2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 100 4
	nopicmip
	skyParms skpk/env/cardigan/purewhitej 1200 -
	{
		map skpk/textures/cardigan_skies1/starfield2.tga
		blendfunc add
		rgbGen wave noise 0.7 0.3 0 20
		tcMod scroll 0.02 0
		tcMod scale 2 2
	}
	{
		map skpk/textures/cardigan_skies1/dense_orange_nebula.tga
		blendfunc filter
		tcMod scroll 0.08 0
	}
}

textures/skies_MASTER6/cardiga_norangeNebula
{
	qer_editorImage skpk/qer/6/cardiga_norangeNebula.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 100 4
	nopicmip
	skyParms skpk/env/cardigan/purewhitej 1200 -
	{
		map skpk/textures/cardigan_skies1/dense_orange_nebula.tga
		blendfunc filter
		tcMod scroll 0.08 0
	}
}

textures/skies_MASTER6/cardigan_purpStars2
{
	qer_editorImage skpk/qer/6/cardigan_purpStars2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 100 4
	nopicmip
	skyParms skpk/env/cardigan/purewhitej 1200 -
	{
		map skpk/textures/cardigan_skies1/starfield2.tga
		blendfunc add
		rgbGen wave noise 0.7 0.3 0 20
		tcMod scroll 0.02 0.01
		tcMod scale 3 3
	}
	{
		map skpk/textures/cardigan_skies1/dense_purple_nebula.tga
		blendfunc filter
		tcMod scroll 0.08 0.06
	}
}

textures/skies_MASTER6/cardigan_purpNebula3
{
	qer_editorImage skpk/qer/6/cardigan_purpNebula3.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 100 4
	nopicmip
	skyParms skpk/env/cardigan/purewhitej 1200 -
	{
		map skpk/textures/cardigan_skies1/dense_purple_nebula.tga
		blendfunc filter
		tcMod scroll 0.08 0.06
	}
}

textures/skies_MASTER6/cardigan_blueStars2
{
	qer_editorImage skpk/qer/6/cardigan_blueStars2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 100 4
	nopicmip
	skyParms skpk/env/cardigan/purewhitej 1200 -
	{
		map skpk/textures/cardigan_skies1/starfield2.tga
		blendfunc add
		rgbGen wave noise 0.7 0.3 0 20
		tcMod scroll 0.01 0.02
		tcMod scale 3 3
	}
	{
		map skpk/textures/cardigan_skies1/dense_blue_nebula.tga
		blendfunc filter
		tcMod scroll 0.07 0.09
	}
}

textures/skies_MASTER6/cardigan_blueNebula2
{
	qer_editorImage skpk/qer/6/cardigan_blueNebula2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 100 4
	nopicmip
	skyParms skpk/env/cardigan/purewhitej 1200 -
	{
		map skpk/textures/cardigan_skies1/dense_blue_nebula.tga
		blendfunc filter
		tcMod scroll 0.07 0.09
	}
}

textures/skies_MASTER6/cardigan_blueLightning2
{
	qer_editorImage skpk/qer/6/cardigan_blueLightning2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 100 4
	nopicmip
	skyParms skpk/env/cardigan/purewhitej 1200 -
	{
		map skpk/textures/cardigan_skies1/circlegradlightningblur3.tga
		blendfunc add
		rgbGen wave noise 0 1 0 5
		tcMod scale 0.32 0.32
		tcMod rotate -20
	}
	{
		map skpk/textures/cardigan_skies1/dense_blue_nebula.tga
		blendfunc filter
		tcMod scroll 0.02 0.03
	}
}

textures/skies_MASTER6/cardigan_purpLightning2
{
	qer_editorImage skpk/qer/6/cardigan_purpLightning2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 100 4
	nopicmip
	skyParms skpk/env/cardigan/purewhitej 1200 -
	{
		map skpk/textures/cardigan_skies1/circlegradlightningblur3.tga
		blendfunc add
		rgbGen wave noise 0 1 0 10
		tcMod scale 0.32 0.32
		tcMod rotate -20
	}
	{
		map skpk/textures/cardigan_skies1/dense_purple_nebula.tga
		blendfunc filter
		tcMod scroll -0.03 0.05
	}
}

textures/skies_MASTER6/cardigan_orangeLightning2
{
	qer_editorImage skpk/qer/6/cardigan_orangeLightning2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 100 4
	nopicmip
	skyParms skpk/env/cardigan/purewhitej 1200 -
	{
		map skpk/textures/cardigan_skies1/circlegradlightningblur3.tga
		blendfunc add
		rgbGen wave noise 0 1 0 8
		tcMod scale 0.32 0.32
		tcMod rotate -20
	}
	{
		map skpk/textures/cardigan_skies1/dense_orange_nebula.tga
		blendfunc filter
		tcMod scroll 0.02 0.06
	}
}

textures/skies_MASTER6/cardigan_greenLightning2
{
	qer_editorImage skpk/qer/6/cardigan_greenLightning2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 100 4
	nopicmip
	skyParms skpk/env/cardigan/purewhitej 1200 -
	{
		map skpk/textures/cardigan_skies1/circlegradlightningblur3.tga
		blendfunc add
		rgbGen wave noise 0 1 0 4
		tcMod scale 0.32 0.32
		tcMod rotate 4
	}
	{
		map skpk/textures/cardigan_skies1/dense_green_nebula.tga
		blendfunc filter
		tcMod scroll 0.02 0.02
	}
}

textures/skies_MASTER6/cardigan_greenColorShift
{
	qer_editorImage skpk/qer/6/cardigan_greenColorShift.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 100 4
	nopicmip
	skyParms skpk/env/cardigan/purewhitej 1200 -
	{
		map skpk/textures/cardigan_skies1/circlegradcloudsdark.tga
		blendfunc add
		rgbGen const ( 0 0.647059 0.756863 )
		tcMod scale 0.32 0.32
		tcMod rotate 12
	}
	{
		map skpk/textures/cardigan_skies1/dense_green_nebula.tga
		blendfunc filter
		tcMod scroll 0.02 0.02
	}
}

textures/skies_MASTER6/cardigan_orangeColorShift2
{
	qer_editorImage skpk/qer/6/cardigan_orangeColorShift2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 100 4
	nopicmip
	skyParms skpk/env/cardigan/purewhitej 1200 -
	{
		map skpk/textures/cardigan_skies1/circlegradcloudsdark.tga
		blendfunc add
		rgbGen const ( 0.984314 0.933333 0 )
		tcMod scale 0.32 0.32
		tcMod rotate 12
	}
	{
		map skpk/textures/cardigan_skies1/dense_orange_nebula.tga
		blendfunc filter
		tcMod scroll 0.02 0.02
	}
}

textures/skies_MASTER6/cardigan_purpColorShift2
{
	qer_editorImage skpk/qer/6/cardigan_purpColorShift2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 100 4
	nopicmip
	skyParms skpk/env/cardigan/purewhitej 1200 -
	{
		map skpk/textures/cardigan_skies1/circlegradcloudsdark.tga
		blendfunc add
		rgbGen const ( 0 0 0.368627 )
		tcMod scale 0.32 0.32
		tcMod rotate 5
	}
	{
		map skpk/textures/cardigan_skies1/dense_purple_nebula.tga
		blendfunc filter
		tcMod scroll 0.02 0.02
	}
}

textures/skies_MASTER6/cardigan_greenClouds
{
	qer_editorImage skpk/qer/6/cardigan_greenClouds.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 100 4
	nopicmip
	skyParms skpk/env/cardigan/purewhitej 1200 -
	{
		map skpk/textures/cardigan_skies1/cloudmask5.tga
		blendfunc filter
		rgbGen const ( 0.494118 0.941177 0 )
		tcMod scroll 0.02 -0.03
	}
}

textures/skies_MASTER6/cardigan_greenClouds2
{
	qer_editorImage skpk/qer/6/cardigan_greenClouds2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 100 4
	nopicmip
	skyParms skpk/env/cardigan/purewhitej 1200 -
	{
		map skpk/textures/cardigan_skies1/cloudmask6.tga
		blendfunc filter
		rgbGen const ( 0.494118 0.941177 0 )
		tcMod scroll 0.02 -0.03
	}
}

textures/skies_MASTER6/cardigan_blueClouds
{
	qer_editorImage skpk/qer/6/cardigan_blueClouds.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 100 4
	nopicmip
	skyParms skpk/env/cardigan/purewhitej 1200 -
	{
		map skpk/textures/cardigan_skies1/cloudmask5.tga
		blendfunc filter
		rgbGen const ( 0 0 1 )
		tcMod scroll 0.02 -0.03
	}
}

textures/skies_MASTER6/cardigan_blueClouds2
{
	qer_editorImage skpk/qer/6/cardigan_blueClouds2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 100 4
	nopicmip
	skyParms skpk/env/cardigan/purewhitej 1200 -
	{
		map skpk/textures/cardigan_skies1/cloudmask6.tga
		blendfunc filter
		rgbGen const ( 0 0 1 )
		tcMod scroll 0.02 -0.03
	}
}

textures/skies_MASTER6/cardigan_purpClouds
{
	qer_editorImage skpk/qer/6/cardigan_purpClouds.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 100 4
	nopicmip
	skyParms skpk/env/cardigan/purewhitej 1200 -
	{
		map skpk/textures/cardigan_skies1/cloudmask5.tga
		blendfunc filter
		rgbGen const ( 0.87451 0 0.87451 )
		tcMod scroll 0.02 -0.03
	}
}

textures/skies_MASTER6/cardigan_purpClouds2
{
	qer_editorImage skpk/qer/6/cardigan_purpClouds2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 100 4
	nopicmip
	skyParms skpk/env/cardigan/purewhitej 1200 -
	{
		map skpk/textures/cardigan_skies1/cloudmask6.tga
		blendfunc filter
		rgbGen const ( 0.87451 0 0.87451 )
		tcMod scroll 0.02 -0.03
	}
}

textures/skies_MASTER6/cardigan_redClouds
{
	qer_editorImage skpk/qer/6/cardigan_redClouds.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 100 4
	nopicmip
	skyParms skpk/env/cardigan/purewhitej 1200 -
	{
		map skpk/textures/cardigan_skies1/cloudmask5.tga
		blendfunc filter
		rgbGen const ( 1 0 0 )
		tcMod scroll 0.02 -0.03
	}
}

textures/skies_MASTER6/cardigan_redClouds2
{
	qer_editorImage skpk/qer/6/cardigan_redClouds2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 100 4
	nopicmip
	skyParms skpk/env/cardigan/purewhitej 1200 -
	{
		map skpk/textures/cardigan_skies1/cloudmask6.tga
		blendfunc filter
		rgbGen const ( 1 0 0 )
		tcMod scroll 0.02 -0.03
	}
}

textures/skies_MASTER2/casablanca
{
	qer_editorImage skpk/qer/env/cb_env.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.95 0.9 1 20 -41 58 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 90 4
	nopicmip
	skyparms skpk/env/cb_env - -
}

textures/skies_MASTER6/xnight2-redclouds
{
	qer_editorImage skpk/qer/6/xnight2-redclouds.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 20 -41 58 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 85 4
	nopicmip
	skyparms env/xnight2 512 -
	{
		map skpk/textures/skies/black_up.tga
		blendFunc GL_ONE GL_ONE
		tcMod scroll 0.00 0.00
		tcMod scale 0 0
	}
	{
		map textures/skies/killsky_1.tga
		blendFunc GL_ONE GL_ONE
		tcMod scroll 0.01 0.01
		tcMod scale 3 3
	}
	{
		map skpk/textures/skies/bluetopclouds.tga
		blendFunc GL_ONE GL_ONE
		tcMod scroll 0.03 0.03
		tcMod scale 5 5
	}
}

textures/skies_MASTER6/xnight2-dimclouds
{
	qer_editorImage skpk/qer/6/xnight2-dimclouds.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 20 -41 58 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 85 4
	nopicmip
	skyparms env/xnight2 512 -
	{
		map textures/skies/dimclouds.tga
		blendFunc GL_ONE GL_ONE
		tcMod scroll 0.01 0.01
		tcMod scale 3 3
	}
}

textures/skies_MASTER6/xnight2-slowdimclouds
{
	qer_editorImage skpk/qer/6/xnight2-slowdimclouds.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 90 4
	nopicmip
	skyparms - 128 -
	{
		map textures/skies/dimclouds.tga
		tcMod scroll 0.001 0.001
		tcMod scale 3 3
		depthWrite
	}
}

textures/skies_MASTER6/catq3dm04
{
	qer_editorImage skpk/qer/6/catq3dm04.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 105 4
	nopicmip
	skyparms - 512 -
	{
		map skpk/textures/catq3dm04/egyptian_clouds_0.tga
		tcMod scale 3 2
		tcMod scroll 0.06 0.06
		depthWrite
	}
	{
		map skpk/textures/catq3dm04/egyptian_clouds_1.tga
		blendFunc GL_ONE GL_ONE
		tcMod scale 3 3
		tcMod scroll 0.01 0.01
	}
}

textures/skies_MASTER6/powerslave_sky
{
	qer_editorImage skpk/qer/6/powerslave_sky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 105 4
	nopicmip
	skyparms - 512 -
	{
		map skpk/textures/catq3tourney03/powerslave_clouds_0.tga
		tcMod scale 3 2
		tcMod scroll 0.06 0.06
		depthWrite
	}
	{
		map skpk/textures/catq3tourney03/powerslave_clouds_1.tga
		blendFunc GL_ONE GL_ONE
		tcMod scale 3 3
		tcMod scroll 0.01 0.01
	}
}

textures/skies_MASTER4/cemetary-clouds
{
	qer_editorImage skpk/qer/env/cemetary-clouds.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 150 4
	nopicmip
	skyparms skpk/env/cemetary 256 -
	{
		map textures/skies/killsky_2.tga
		blendfunc GL_ONE GL_ONE
		tcMod scroll 0.05 0.06
		tcMod scale 3 2
	}
}

textures/skies_MASTER6/dimsky_centipede
{
	qer_editorImage skpk/qer/6/dimsky_centipede.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 110 4
	nopicmip
	skyparms - 512 -
	{
		map textures/skies/dimclouds.tga
		tcMod scroll 0.05 0
		tcMod scale 2 2
		depthWrite
	}
}

textures/skies_MASTER2/myth_skies
{
	qer_editorImage skpk/qer/textures/myth_skies/cf.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt .5 .37 .19 70 -1 24 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 65 4
	nopicmip
	skyparms skpk/textures/myth_skies/cf - -
}

textures/skies_MASTER6/charondm11sky
{
	qer_editorImage skpk/qer/6/charondm11sky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 100 4
	nopicmip
	skyparms - - -
	{
		map skpk/textures/charon_dm11/charon_yellowclouds1.tga
		tcMod scale 3 2
		tcMod scroll 0.15 0.15
		depthWrite
	}
	{
		map skpk/textures/charon_dm11/charon_greenclouds1.tga
		blendFunc GL_ONE GL_ONE
		tcMod scale 3 3
		tcMod scroll 0.05 0.05
	}
}

textures/skies_MASTER6/chili_thunder
{
	qer_editorImage skpk/qer/6/chili_thunder.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 125 4
	nopicmip
	skyparms skpk/textures/chili_skies/env/sky 2048 -
	{
		map skpk/textures/chili_skies/sky_clouds.tga
		tcMod scale 1 1
		tcMod scroll 0.005 -0.0125
		rgbGen identityLighting
	}
	{
		animMap .9 skpk/textures/chili_skies/thunderbolt_1.tga skpk/textures/colors/black.tga skpk/textures/colors/black.tga skpk/textures/chili_skies/thunderbolt_2.tga skpk/textures/chili_skies/thunderbolt_3.tga skpk/textures/colors/black.tga skpk/textures/colors/black.tga
		blendFunc add
		rgbGen identity
		rgbGen wave Sin 0 1 0 1.1
	}
}

textures/skies_MASTER6/0color_grey-regent
{
	qer_editorImage skpk/qer/textures/chili_skies/env/sky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 125 4
	nopicmip
	skyparms skpk/textures/chili_skies/env/sky 2048 -
}

textures/skies_MASTER2/thedeepblue
{
	qer_editorImage skpk/qer/env/thedeepblue.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 20 0 90 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 90 4
	nopicmip
	skyparms skpk/env/thedeepblue - -
}

textures/skies_MASTER/ame_starfield-clouds
{
	qer_editorImage skpk/qer/env/ame_starfield/starfield-clouds.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 64
	q3map_skyLight 125 4
	nopicmip
	skyparms skpk/env/ame_starfield/starfield 256 -
	{
		map skpk/textures/chopcustom/starfield_clouds.tga
		blendFunc GL_ONE GL_ONE
		tcMod scale 3 3
		tcMod scroll 0.1 0.1
	}
}

textures/skies_MASTER2/chsky
{
	qer_editorImage skpk/qer/env/chsky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt .9 .7 .5 100 -10 19 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 90 4
	nopicmip
	skyparms skpk/env/chsky - -
}

textures/skies_MASTER2/z
{
	qer_editorImage skpk/qer/env/city/z.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_sunExt .75 .58 .42 70 235 60 25 16
	q3map_skyLight 33 4
	nopicmip
	skyparms skpk/env/city/z - -
}

textures/skies_MASTER2/city1_night
{
	qer_editorImage skpk/qer/env/night.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 105 4
	nopicmip
	skyparms skpk/env/night - -
}

textures/skies_MASTER6/greenkillsky
{
	qer_editorImage skpk/qer/6/greenkillsky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 100 4
	nopicmip
	skyparms - 512 -
	{
		map skpk/textures/alliance/killsky_1.tga
		tcMod scroll 0.005 .01
		tcMod scale 4 4
		depthWrite
	}
	{
		map textures/skies/killsky_2.tga
		blendfunc GL_ONE GL_ONE
		tcMod scroll 0.02 0.02
		tcMod scale 4 3
	}
}

textures/skies_MASTER6/clansky
{
	qer_editorImage skpk/qer/6/clansky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 70 4
	nopicmip
	skyparms - 512 -
	{
		map skpk/textures/auh3dm1/auhsky.tga
		tcMod scale 3 2
		tcMod scroll 0.15 0.15
		depthWrite
	}
	{
		map textures/skies/intelredclouds.tga
		blendFunc GL_ONE GL_ONE
		tcMod scale 3 3
		tcMod scroll 0.05 0.05
	}
}

textures/skies_MASTER6/classic2_sky-clouds
{
	qer_editorImage skpk/qer/6/classic2_sky-clouds.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 100 4
	nopicmip
	skyparms env/space1 230 -
	{
		map textures/skies/topclouds.tga
		blendfunc GL_ONE GL_ONE
		tcMod scroll 0.010 0.0022
		tcMod scale 3 2
	}
}

textures/skies_MASTER6/redclouds-slow
{
	qer_editorImage skpk/qer/6/redclouds-slow.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 100 4
	nopicmip
	skyparms - 512 -
	{
		map textures/skies/inteldimclouds.tga
		tcMod scroll 0.003 0.008
		tcMod scale 3 2
		depthWrite
	}
	{
		map textures/skies/intelredclouds.tga
		blendFunc GL_ONE GL_ONE
		tcMod scroll 0.005 0.012
		tcMod scale 3 3
	}
}

textures/skies_MASTER/ame_cliffsofinsanity
{
	qer_editorImage skpk/qer/env/amethyst7/cliffsofinsanity/cliffsofinsanity.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt .9 .7 1 60 -29 23 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 80 4
	nopicmip
	skyparms skpk/env/amethyst7/cliffsofinsanity/cliffsofinsanity - -
}

textures/skies_MASTER6/0color_blue-lavender
{
	qer_editorImage skpk/qer/env/codey1/oilbox03.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_lightRGB 0.784 0.816 1
	q3map_skyLight 105 4 0 90 0
	nopicmip
	skyparms skpk/env/codey1/oilbox03 - -
}

textures/skies_MASTER2/cod_sky1
{
	qer_editorImage skpk/qer/env/cod_sky1/cod_sky1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 245 255 255 30 0 73 3 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 55 4
	nopicmip
	skyparms skpk/env/cod_sky1/cod_sky1 - -
}

textures/skies_MASTER6/0color_black-oil
{
	qer_editorImage skpk/qer/env/compsky02/compsky02.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 145 4
	nopicmip
	skyparms skpk/env/compsky02/compsky02 - -
}

textures/skies_MASTER2/contortion
{
	qer_editorImage skpk/qer/env/contortion/contortionsky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 .949 .977 80 44 25 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 60 4
	nopicmip
	skyparms skpk/env/contortion/contortionsky - -
}

textures/skies_MASTER6/decker_night_sky
{
	qer_editorImage skpk/qer/6/decker_night_sky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 100 4
	nopicmip
	skyparms - 512 -
	{
		map skpk/textures/decker_sky/night_sky_back.tga
		tcMod scroll 0.01 .01
		tcMod scale 1 1
		depthWrite
	}
	{
		map skpk/textures/decker_sky/night_sky_front.tga
		blendFunc GL_ONE GL_ONE
		tcMod scroll 0.02 0.01
		tcMod scale 3 3
	}
}

textures/skies_MASTER6/senn_sky
{
	qer_editorImage skpk/qer/6/senn_sky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 100 4
	nopicmip
	skyparms - 512 -
	{
		map skpk/textures/senn/sennsky2.tga
		tcMod scroll 0 0.02
		tcMod scale 3 3
		depthWrite
	}
	{
		map skpk/textures/senn/sennsky1.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		tcMod scroll 0 0.03
		tcMod scale 3 3
	}
}

textures/skies_MASTER2/cpm23_nubiansky2-clouds
{
	qer_editorImage skpk/qer/env/aty9sky/lun4-nubianclouds.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 .9 .8 30 -59 60 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 80 4
	nopicmip
	skyparms skpk/env/aty9sky/lun4 768 -
	{
		map skpk/textures/aty3dm9/nubian5.tga
		tcMod scale 4 4
		tcMod scroll 0.05 0.05
		blendFunc GL_ONE GL_ONE
	}
}

textures/skies_MASTER6/cpm24_toxicskydim
{
	qer_editorImage skpk/qer/6/cpm24_toxicskydim.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 100 4
	nopicmip
	skyparms - 512 -
	{
		map textures/skies/inteldimclouds.tga
		tcMod scroll 0.05 0.05
		tcMod scale 3 2
		depthWrite
	}
	{
		map textures/skies/intelredclouds.tga
		blendFunc GL_ONE GL_ONE
		tcMod scroll 0.025 0.025
		tcMod scale 3 3
	}
}

textures/skies_MASTER/sb_iceflow-clouds
{
	qer_editorImage skpk/qer/env/sb_iceflow/iceflow-clouds.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt .884 .94 1 85 -32 39 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/sb_iceflow/iceflow - -
	{
		map skpk/textures/chopcustom/starfield_clouds.tga
		blendFunc GL_ONE GL_ONE
		tcMod scale 3 3
		tcMod scroll 0.1 0.1
	}
}

textures/skies_MASTER2/cpm3a_kos_iceflow
{
	qer_editorImage skpk/qer/textures/cpm3a_kos/iceflow.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 95 4
	nopicmip
	skyparms skpk/textures/cpm3a_kos/iceflow - -
}

textures/skies_MASTER/ame_snowy-clouds
{
	qer_editorImage skpk/qer/env/ame_snowy/snowy-clouds.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt .9 .95 1 75 180 25 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/ame_snowy/snowy 256 -
	{
		map skpk/textures/cpm4a/snowy_clouds.tga
		blendFunc GL_ONE GL_ONE
		tcMod scale 3 3
		tcMod scroll 0.1 0.1
	}
}

textures/skies_MASTER6/0color_greyWarm
{
	qer_editorImage skpk/qer/env/cr3q3w20b/cr3q3w20b.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 80 4
	nopicmip
	skyparms skpk/env/cr3q3w20b/cr3q3w20b - -
}

textures/skies_MASTER2/crueltricksky
{
	qer_editorImage skpk/qer/env/crueltrick/tricksky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.784314 0.47451 0.396078 55 -110 8 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 85 4
	nopicmip
	skyparms skpk/env/crueltrick/tricksky - -
}

textures/skies_MASTER/nec_city-blue
{
	qer_editorImage skpk/qer/env/csky/csky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 25 138 57 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 80 4
	nopicmip
	skyParms skpk/env/csky/csky - -
}

textures/skies_MASTER6/ct3tourney2_lightning
{
	qer_editorImage skpk/qer/6/ct3tourney2_lightning.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 110 4
	nopicmip
	skyparms - 2000 -
	{
		map skpk/textures/ct3tourney2/env/clouds.tga
		tcMod scroll .03 .005
		tcmod scale 2 2
		rgbGen identityLighting
	}
	{
		map skpk/textures/ct3tourney2/env/lightning.tga
		blendfunc add
		rgbGen wave noise 0 1 0 5
		tcMod scale 0.32 0.32
		tcMod rotate 20
	}
}

textures/skies_MASTER6/pj_dm10sky_green
{
	qer_editorImage skpk/qer/6/pj_dm10sky_green.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 110 4
	nopicmip
	skyparms - 512 -
	{
		map skpk/textures/ctctf1/greendimclouds.tga
		tcMod scale 3 2
		tcMod scroll 0.15 0.15
		depthWrite
	}
	{
		map skpk/textures/ctctf1/bluerdimclouds.tga
		tcMod scale 3 2
		tcMod scroll 0.1 0.1
		blendfunc add
	}
	{
		map textures/skies/topclouds.tga
		blendFunc GL_ONE GL_ONE
		tcMod scale 3 3
		tcMod scroll 0.05 0.05
	}
}

textures/skies_MASTER6/cas_killsky
{
	qer_editorImage skpk/qer/6/cas_killsky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 110 4
	nopicmip
	skyparms skpk/env/black 512 -
	{
		map textures/skies/killsky_1.tga
		tcMod scroll 0.05 .1
		tcMod scale 2 2
		depthWrite
	}
	{
		map textures/skies/killsky_2.tga
		blendfunc GL_ONE GL_ONE
		tcMod scroll 0.05 0.06
		tcMod scale 3 2
	}
}

textures/skies_MASTER6/ct3ctf2_sky
{
	qer_editorImage skpk/qer/6/ct3ctf2_sky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 100 4
	nopicmip
	skyparms - 256 -
	{
		map skpk/textures/ct_ct3ctf2/env/sky.tga
		tcMod scroll 0.005 0.005
		tcMod scale 4 4
		depthWrite
	}
}

textures/skies_MASTER6/ct3ctf2_skydark
{
	qer_editorImage skpk/qer/6/ct3ctf2_skydark.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 80 4
	nopicmip
	skyparms - 256 -
	{
		map skpk/textures/ct_ct3ctf2/env/sky_dark.tga
		tcMod scroll 0.005 0.005
		tcMod scale 4 4
		depthWrite
	}
}

textures/skies_MASTER6/shaderlab_ct_ct3
{
	qer_editorImage skpk/qer/6/shaderlab_ct_ct3.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 80 -37 29 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 60 4
	nopicmip
	skyparms skpk/textures/shaderlab_skybox/env/sky 1337 -
	{
		map skpk/textures/ct_ct3_20b2/sky_blue.tga
		tcMod scroll 0.0025 -0.0075
		rgbGen identityLighting
		tcmod scale 4 4
	}
	{
		map skpk/textures/shaderlab_skybox/sky_arc_masked.tga
		blendFunc GL_ONE_MINUS_SRC_ALPHA GL_SRC_ALPHA
		tcMod transform 0.25 0 0 0.25 0.1075 0.1075
		rgbGen identityLighting
	}
}

textures/skies_MASTER/ame_greywash-clouds2
{
	qer_editorImage skpk/qer/env/ame_greywash/greywash-clouds2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 70 90 25 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/ame_greywash/greywash 512 -
	{
		map skpk/textures/ct_hektik/sky/hektik_clouds.tga
		blendFunc GL_ONE GL_ONE
		tcMod scale 3 3
		tcMod scroll 0.004 0.004
	}
	{
		map skpk/textures/ct_hektik/sky/hektik_clouds_2.tga
		blendFunc GL_ONE GL_ONE
		tcMod scale 3 3
		tcMod scroll 0.005 0.005
		tcMod scale 0.003 0.003
	}
}

textures/skies_MASTER6/timhell_damn
{
	qer_editorImage skpk/qer/6/timhell_damn.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_lightRGB 1 0.77 0.77
	q3map_skyLight 75 4 0 90 0
	nopicmip
	skyParms - 450 -
	{
		map skpk/textures/damn_q3dm1/cloud2.tga
		tcMod scroll 0.05 0.1
		tcMod scale 2 2
		depthWrite
	}
	{
		map skpk/textures/damn_q3dm1/cloud1.tga
		blendfunc add
		tcMod scroll 0.05 0.06
		tcMod scale 2 1
	}
}

textures/skies_MASTER6/dangermax
{
	qer_editorImage skpk/qer/6/dangermax.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 50 -35 29 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 100 4
	nopicmip
	skyparms skpk/textures/dangermax/env/sky 1337 -
	{
		map skpk/textures/dangermax/sky_clouds.tga
		tcMod scroll 0.0025 -0.0075
		tcMod scale 0.5 0.5
		rgbGen identityLighting
	}
	{
		map skpk/textures/dangermax/sky_mask.tga
		blendFunc GL_ONE_MINUS_SRC_ALPHA GL_SRC_ALPHA
		tcMod transform 0.25 0 0 0.25 0.1075 0.1075
		rgbGen identityLighting
	}
}

textures/skies_MASTER6/0color_blue-aqua
{
	qer_editorImage skpk/qer/textures/dangermax/env/sky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 125 4
	nopicmip
	skyparms skpk/textures/dangermax/env/sky 1337 -
}

textures/skies_MASTER2/dante_skybox
{
	qer_editorImage skpk/qer/env/dante/dante.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 .82 .733 80 -29 25 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 65 4
	nopicmip
	skyparms skpk/env/dante/dante - -
}

textures/skies_MASTER6/darkhellsky-lightning
{
	qer_editorImage skpk/qer/6/darkhellsky-lightning.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 90 4
	nopicmip
	skyparms - 2000 -
	{
		map skpk/textures/pukka3tourney7/clouds.tga
		tcMod scroll .03 .005
		tcmod scale 2 2
		rgbGen identityLighting
	}
	{
		map skpk/textures/darkztn/lightning.tga
		blendfunc add
		rgbGen wave noise 0 1 0 10
		tcMod scale 0.32 0.32
		tcMod rotate 20
	}
}

textures/skies_MASTER2/daskybox1
{
	qer_editorImage skpk/qer/env/dasky1/dashsky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt .5 .37 .19 75 -98 10 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 85 4
	nopicmip
	skyparms skpk/env/dasky1/dashsky - -
}

textures/skies_MASTER2/daskybox2
{
	qer_editorImage skpk/qer/env/dasky2/desert.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt .5 .37 .19 75 -78 18 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 90 4
	nopicmip
	skyparms skpk/env/dasky2/desert - -
}

textures/skies_MASTER6/dcs_inteldimclouds
{
	qer_editorImage skpk/qer/6/dcs_inteldimclouds.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 115 4
	nopicmip
	skyparms - 512 -
	{
		map textures/skies/inteldimclouds.tga
		tcMod scroll 0.1 0.1
		tcMod scale 3 2
		depthWrite
	}
	{
		map textures/skies/bluedimclouds.tga
		blendFunc GL_ONE GL_ONE
		tcMod scroll 0.05 0.05
		tcMod scale 3 3
	}
}

textures/skies_MASTER6/dcs_night_sky
{
	qer_editorImage skpk/qer/6/dcs_night_sky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 110 4
	nopicmip
	skyparms - 512 -
	{
		map skpk/textures/dcs/dcs_night_clouds_1.tga
		tcMod scroll 0.1 0.1
		tcMod scale 3 2
		depthWrite
	}
	{
		map skpk/textures/dcs/dcs_night_clouds_2.tga
		blendFunc GL_ONE GL_ONE
		tcMod scroll 0.05 0.05
		tcMod scale 3 3
	}
}

textures/skies_MASTER6/dc_q3dm1sky
{
	qer_editorImage skpk/qer/6/dc_q3dm1sky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 110 4
	nopicmip
	skyparms - 768 -
	{
		map skpk/textures/skies/nightsky.tga
		rgbgen const ( 0.38 0.08 0.08 )
		tcmod scroll 0.01 0.05
		tcmod scale 4 4
		depthwrite
	}
	{
		map textures/skies/intelredclouds.tga
		rgbgen const ( 0.19 0.12 0.16 )
		blendfunc add
		tcmod scroll 0.06 0.08
		tcmod scale 5 5
	}
}

textures/skies_MASTER2/meat_sky_morning
{
	qer_editorImage skpk/qer/textures/meat_sky/meat_sky_morning.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 60 -84 20 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 80 4
	nopicmip
	skyparms skpk/textures/meat_sky/meat_sky_morning - -
}

textures/skies_MASTER6/bluedimclouds
{
	qer_editorImage skpk/qer/6/bluedimclouds.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 105 4
	nopicmip
	skyparms - 512 -
	{
		map skpk/textures/dead_simple/bluedimclouds.tga
		tcMod scroll 0.1 0.1
		tcMod scale 3 2
		depthWrite
	}
	{
		map skpk/textures/dead_simple/blueclouds.tga
		blendFunc GL_ONE GL_ONE
		tcMod scroll 0.05 0.05
		tcMod scale 3 3
	}
}

textures/skies_MASTER2/deimos
{
	qer_editorImage skpk/qer/env/deimos/deimos.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 95 4
	nopicmip
	skyparms skpk/env/deimos/deimos - -
}

textures/skies_MASTER2/stecki_night01
{
	qer_editorImage skpk/qer/textures/stecki/night01.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 100 4
	nopicmip
	skyparms skpk/textures/stecki/night01 - -
}

textures/skies_MASTER6/desctf1_sky
{
	qer_editorImage skpk/qer/6/desctf1_sky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 95 4
	nopicmip
	skyparms skpk/textures/desctf1/env/sky 1500 -
	{
		map skpk/textures/desctf1/env/clouds.tga
		tcMod scale 2 2
		tcMod scroll 0.0075 -0.0075
		blendFunc blend
		rgbGen identityLighting
	}
	{
		map skpk/textures/desctf1/env/mask.tga
		blendFunc GL_ONE_MINUS_SRC_ALPHA GL_SRC_ALPHA
		tcMod transform 0.25 0 0 0.25 0.1075 0.1075
		rgbGen identityLighting
	}
}

textures/skies_MASTER6/digital_sky
{
	qer_editorImage skpk/qer/6/digital_sky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 115 4
	nopicmip
	skyparms - 200 -
	{
		map skpk/textures/digital/sky2.tga
		tcMod scroll 0.05 0.02
		tcMod scale 1 1
		depthWrite
	}
	{
		map skpk/textures/digital/sky1.tga
		rgbGen wave sin 0.5 0.5 0 0.05
		tcMod scroll -0.07 -0.06
		tcMod scale 1 1
		blendfunc GL_ONE GL_ONE
	}
}

textures/skies_MASTER6/doomiisky
{
	qer_editorImage skpk/qer/6/doomiisky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 95 4
	nopicmip
	skyParms - 512 -
	{
		map textures/skies/dimclouds.tga
		tcMod scale 3 3
		tcMod scroll 0.2 -0.2
	}
	{
		map textures/skies/intelredclouds.tga
		blendfunc add
		tcMod scale 1.8 1.4
		tcMod scroll 0.03 0.05
	}
}

textures/skies_MASTER6/0color_grey_clouds2
{
	qer_editorImage skpk/qer/6/0color_grey_clouds2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 60 -35 29 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 75 4
	nopicmip
	skyparms skpk/textures/dk_2012/greysky/gs 1337 -
	{
		map skpk/textures/dk_2012/greysky/greysky.tga
		tcMod scroll 0.0025 -0.0075
		rgbGen identityLighting
		tcMod scale 4 4
	}
	{
		map skpk/textures/dk_2012/greysky/sky_mask.tga
		blendFunc GL_ONE_MINUS_SRC_ALPHA GL_SRC_ALPHA
		tcMod transform 0.25 0 0 0.25 0.1075 0.1075
		rgbGen identityLighting
	}
}

textures/skies_MASTER6/0color_grey5
{
	qer_editorImage skpk/qer/textures/dk_2012/greysky/gs.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 135 4
	nopicmip
	skyparms skpk/textures/dk_2012/greysky/gs 1337 -
}

textures/skies_MASTER6/tygersky-lightning
{
	qer_editorImage skpk/qer/6/tygersky-lightning.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 115 4
	nopicmip
	skyparms - 512 -
	{
		map skpk/textures/dk_aom/sky1.tga
		tcMod scale 3 2
		tcMod scroll 0.15 0.15
		depthWrite
	}
	{
		map skpk/textures/dk_aom/sky2.tga
		blendFunc GL_ONE GL_ONE
		tcMod scale 3 3
		tcMod scroll 0.05 0.05
	}
	{
		map skpk/textures/cardigan_skies1/circlegradlightningblur3.tga
		blendfunc add
		rgbGen wave noise 0 1 0 5
		tcMod scale 0.32 0.32
		tcMod rotate -20
	}
}

textures/skies_MASTER6/0color_red-oxide
{
	qer_editorImage skpk/qer/env/red/red.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 115 4
	nopicmip
	skyparms skpk/env/red/red - -
}

textures/skies_MASTER6/shaderlab_dk_decay
{
	qer_editorImage skpk/qer/6/shaderlab_dk_decay.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 30 -35 29 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 65 4
	nopicmip
	skyparms skpk/textures/shaderlab_skybox/env/sky 1337 -
	{
		map skpk/textures/dk_decay/clouds.tga
		tcMod scroll 0.0025 -0.0075
		rgbGen identityLighting
	}
	{
		map skpk/textures/shaderlab_skybox/sky_arc_masked.tga
		blendFunc GL_ONE_MINUS_SRC_ALPHA GL_SRC_ALPHA
		tcMod transform 0.25 0 0 0.25 0.1075 0.1075
		rgbGen identityLighting
	}
}

textures/skies_MASTER6/0color_green-pistachio
{
	qer_editorImage skpk/qer/env/green/dk.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 110 4
	nopicmip
	skyparms skpk/env/green/dk - -
}

textures/skies_MASTER6/shaderlab_dk_ng2
{
	qer_editorImage skpk/qer/6/shaderlab_dk_ng2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 55 -35 29 2 12
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 100 4
	nopicmip
	skyparms skpk/textures/shaderlab_skybox/env/sky 1337 -
	{
		map skpk/textures/dk_ng2/sky.tga
		tcMod scroll 0.0025 -0.0075
		rgbGen identityLighting
	}
	{
		map skpk/textures/shaderlab_skybox/sky_arc_masked.tga
		blendFunc GL_ONE_MINUS_SRC_ALPHA GL_SRC_ALPHA
		tcMod transform 0.25 0 0 0.25 0.1075 0.1075
		rgbGen identityLighting
	}
}

textures/skies_MASTER6/dk_ng3
{
	qer_editorImage skpk/qer/6/dk_ng3.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 105 4
	nopicmip
	skyparms - 1337 -
	{
		map skpk/textures/dk_q3w20b/pinksky/pinksky.tga
		tcMod scroll 0.0025 -0.0075
		rgbGen identityLighting
	}
}

textures/skies_MASTER6/dk_q3w20b
{
	qer_editorImage skpk/qer/6/dk_q3w20b.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 60 -35 30 2 12
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 75 4
	nopicmip
	skyparms skpk/textures/dk_q3w20b/pinksky/20b 1337 -
	{
		map skpk/textures/dk_q3w20b/pinksky/pinksky.tga
		tcMod scroll 0.0025 -0.0075
		rgbGen identityLighting
	}
	{
		map skpk/textures/dk_q3w20b/pinksky/sky_mask.tga
		blendFunc GL_ONE_MINUS_SRC_ALPHA GL_SRC_ALPHA
		tcMod transform 0.25 0 0 0.25 0.1075 0.1075
		rgbGen identityLighting
	}
}

textures/skies_MASTER6/0color_peachLight
{
	qer_editorimage skpk/qer/textures/dk_q3w20b/pinksky/20b.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 99 4
	nopicmip
	skyparms skpk/textures/dk_q3w20b/pinksky/20b 1337 -
}

textures/skies_MASTER6/shaderlab_dk_brownsky
{
	qer_editorImage skpk/qer/6/shaderlab_dk_brownsky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 80 -35 29 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 75 4
	nopicmip
	skyparms skpk/textures/shaderlab_skybox/env/sky 1337 -
	{
		map skpk/textures/dk_skies/sky_brown.tga
		tcMod scroll 0.0025 -0.0075
		rgbGen identityLighting
	}
	{
		map skpk/textures/shaderlab_skybox/sky_arc_masked.tga
		blendFunc GL_ONE_MINUS_SRC_ALPHA GL_SRC_ALPHA
		tcMod transform 0.25 0 0 0.25 0.1075 0.1075
		rgbGen identityLighting
	}
}

textures/skies_MASTER2/dktest_sky
{
	qer_editorImage skpk/qer/textures/dk_terrains/env/test/test.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 .9 .8 70 -30 25 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/textures/dk_terrains/env/test/test - -
}

textures/skies_MASTER6/0color_orange-fire
{
	qer_editorImage skpk/qer/6/0color_orange-fire.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 110 4
	nopicmip
	skyparms - 512 -
	{
		map skpk/textures/dk_ttgd/sky.tga
	}
}

textures/skies_MASTER6/dm1_blackskystarslight
{
	qer_editorImage skpk/qer/6/dm1_blackskystarslight.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 110 4
	nopicmip
	skyParms - 512 -
	{
		map skpk/textures/dm1/stars.tga
		tcMod scale 8 8
		tcMod turb 0 0.005 0 0.1
	}
}

textures/skies_MASTER6/dom_niebo2
{
	qer_editorImage skpk/qer/6/dom_niebo2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 110 4
	nopicmip
	skyparms - 512 -
	{
		map skpk/textures/dom/niebo2.tga
		tcMod scroll 0.01 0.01
		tcMod scale 3 2
		depthWrite
	}
	{
		map skpk/textures/dom/niebo2.tga
		blendFunc GL_ONE GL_ONE
		tcMod scroll 0.01 0.01
		tcMod scale 3 3
	}
}

textures/skies_MASTER2/drac_skybox
{
	qer_editorImage skpk/qer/env/drac/drac.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt .941 .984 1 80 -89 39 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 75 4
	nopicmip
	skyparms skpk/env/drac/drac - -
}

textures/skies_MASTER6/dub_rhapsky
{
	qer_editorImage skpk/qer/6/dub_rhapsky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 110 4
	nopicmip
	skyparms - 512 -
	{
		map skpk/textures/dubtex/dubrhap_sky.tga
		tcMod scale 3 2
		tcMod scroll 0.15 0.15
		depthWrite
	}
	{
		map textures/skies/dimclouds.tga
		blendFunc GL_ONE GL_ONE
		tcMod scale 3 2
		tcMod scroll 0.05 0.05
	}
}

textures/skies_MASTER6/dub_neon-sky
{
	qer_editorImage skpk/qer/6/dub_neon-sky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 110 4
	nopicmip
	skyparms - 512 -
	{
		map skpk/textures/dub_neoc/blueclouds.tga
		tcMod scroll 0.05 0.1
		tcMod scale 2 2
		depthWrite
	}
	{
		map skpk/textures/dub_neoc/blueclouds.tga
		blendFunc GL_ONE GL_ONE
		tcMod scale 3 2
		tcMod scroll 0.05 0.05
	}
}

textures/skies_MASTER6/e1m7ish_redclouds
{
	qer_editorImage skpk/qer/6/e1m7ish_redclouds.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 110 4
	nopicmip
	skyparms env/space1 512 -
	{
		map textures/skies/killsky_1.tga
		blendfunc GL_ONE GL_ONE
		tcMod scroll 0.005 .005
		tcMod scale 5 5
		depthWrite
	}
}

textures/skies_MASTER6/e7evilsky_1
{
	qer_editorImage skpk/qer/6/e7evilsky_1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 110 4
	nopicmip
	skyParms - 512 -
	{
		map skpk/textures/e7/e7evilsky_1.tga
		rgbGen identity
		tcMod scroll 0.05 0.1
		tcMod scale 2 2
	}
	{
		map skpk/textures/e7/e7evilsky_2.tga
		blendfunc add
		rgbGen identity
		tcMod scroll 0.08 -0.06
		tcMod scale 3 2
	}
}

textures/skies_MASTER6/e7sky_01
{
	qer_editorImage skpk/qer/6/e7sky_01.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 110 4
	nopicmip
	skyparms - 512 -
	{
		map skpk/textures/e7/e7sky_01.tga
		rgbGen identity
		tcMod scroll 0.05 0.03
		tcMod scale 2 2
	}
	{
		map skpk/textures/e7/e7sky_02.tga
		blendfunc add
		rgbGen identity
		tcMod scroll 0.01 0.02
		tcMod scale 3 2
	}
}

textures/skies_MASTER6/E=mc2dm1_sfx
{
	qer_editorImage skpk/qer/6/E=mc2dm1_sfx.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 110 4
	nopicmip
	skyparms - 512 -
	{
		map skpk/textures/E=mc2dm1_sfx/sky_01.tga
		tcMod scale 3 3
		tcMod scroll 0.035 0.035
		depthWrite
	}
	{
		map skpk/textures/E=mc2dm1_sfx/sky_02.tga
		blendFunc GL_ONE GL_ONE
		tcMod scale 3 3
		tcMod scroll 0.082 0.082
	}
}

textures/skies_MASTER6/efdat
{
	qer_editorImage skpk/qer/6/efdat.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 110 4
	nopicmip
	skyparms - 384 -
	{
		map skpk/textures/efdat/esky.tga
		tcMod scroll 0.09 0.12
		tcMod scale 4 3
		depthWrite
	}
	{
		map skpk/textures/efdat/esky1.tga
		blendFunc add
		tcMod scroll 0.04 0.03
		tcMod scale 2 2
	}
}

textures/skies_MASTER2/em_sky
{
	qer_editorImage skpk/qer/textures/em_sky/env/emsky1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 70 -29 26 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 75 4
	nopicmip
	skyparms skpk/textures/em_sky/env/emsky1 - -
}

textures/skies_MASTER2/em_sky2
{
	qer_editorImage skpk/qer/textures/em_sky2/env/emsky2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 70 -29 26 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 75 4
	nopicmip
	skyparms skpk/textures/em_sky2/env/emsky2 - -
}

textures/skies_MASTER2/endset_skybox
{
	qer_editorImage skpk/qer/env/end/endset.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.988205 0.722026 0.296696 80 115 16 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 70 4
	nopicmip
	skyparms skpk/env/end/endset - -
}

textures/skies_MASTER6/eo_sky
{
	qer_editorImage skpk/qer/6/eo_sky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 105 4
	nopicmip
	skyparms - 200 -
	{
		map skpk/textures/eo/eo_clouds.tga
		tcMod scroll 0.015 0.016
		tcMod scale 3 3
		depthWrite
	}
	{
		map skpk/textures/eo/eo_sky1.tga
		blendfunc GL_ONE GL_ONE
		tcMod scroll -0.01 -0.012
		tcMod scale 5 5
	}
}

textures/skies_MASTER6/exp13
{
	qer_editorImage skpk/qer/6/exp13.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 110 4
	nopicmip
	skyparms - 512 -
	{
		map skpk/textures/exp13/fhsky2.tga
		tcMod scroll 0.06 0
		tcMod scale 1 1
		depthWrite
	}
	{
		map skpk/textures/exp13/fhsky2.tga
		blendFunc GL_ONE GL_ONE
		tcMod scroll 0.02 0.01
		tcMod scale 3 3
	}
}

textures/skies_MASTER2/sembrados
{
	qer_editorImage skpk/qer/env/sembrados.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 .75 85 25 21 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 75 4
	nopicmip
	skyparms skpk/env/sembrados - -
}

textures/skies_MASTER/hip_inter-clouds
{
	qer_editorImage skpk/qer/env/hip_inter/interstellar-clouds.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_sunExt 1 1 1 80 340 49 11 16
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/hip_inter/interstellar - -
	{
		map skpk/textures/skies/sholclouds.tga
		blendfunc add
		tcMod scale 2 2
		tcMod scroll 0.02 0.02
	}
}

textures/skies_MASTER6/focal_skyportal
{
	qer_editorImage skpk/qer/6/focal_skyportal.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 5 -35 33 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 100 4
	nopicmip
	skyparms skpk/textures/focal/env/sky 1500 -
	{
		map skpk/textures/focal/cloud_edge.tga
		blendFunc GL_ONE_MINUS_SRC_ALPHA GL_SRC_ALPHA
		tcMod scale 2 2
		tcMod transform 0.125 0 0 0.125 0.1075 0.1075
		rgbGen identityLighting
	}
	{
		map skpk/textures/focal/env/sky_mask.tga
		blendFunc GL_ONE_MINUS_SRC_ALPHA GL_SRC_ALPHA
		tcMod transform 0.25 0 0 0.25 0.1075 0.1075
		rgbGen identityLighting
	}
}

textures/skies_MASTER2/forest
{
	qer_editorImage skpk/qer/env/forest/forest.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 227 237 254 50 -2 45 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 80 4
	nopicmip
	skyparms skpk/env/forest/forest - -
}

textures/skies_MASTER6/fs3dm3
{
	qer_editorImage skpk/qer/6/fs3dm3.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 105 4
	nopicmip
	skyparms - 256 -
	{
		map textures/skies/topclouds.tga
		tcMod scroll 0.01 0.01
		tcMod scale 3 3
		depthWrite
	}
	{
		map skpk/textures/fs3dm3/fs_sky.tga
		blendfunc GL_ONE GL_ONE
		tcMod scroll -0.01 -0.01
		tcMod scale 5 5
	}
}

textures/skies_MASTER2/fs_dm3
{
	qer_editorImage skpk/qer/env/fs_dm3.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 105 4
	nopicmip
	skyparms skpk/env/fs_dm3 - -
}

textures/skies_MASTER6/msnight_clouds
{
	qer_editorImage skpk/qer/6/msnight_clouds.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt .99 .77 .77 80 315 70 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 80 4
	nopicmip
	skyparms skpk/env/msnight 512 -
	{
		map textures/skies/pjbasesky.tga
		blendfunc GL_ONE GL_ONE
		tcMod scroll 0.01 .04
		tcMod scale 2 2
		depthWrite
	}
	{
		map textures/skies/killsky_2.tga
		blendfunc GL_ONE GL_ONE
		tcMod scroll 0.02 0.03
		tcMod scale 3 2
	}
}

textures/skies_MASTER2/msnight
{
	qer_editorImage skpk/qer/env/msnight.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt .99 .77 .77 80 -64 68 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 80 4
	nopicmip
	skyparms skpk/env/msnight 512 -
}

textures/skies_MASTER6/g0th_stranded
{
	qer_editorImage skpk/qer/6/g0th_stranded.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms - 512 -
	{
		map skpk/textures/g0th_stranded/bluedimclouds2.tga
		tcMod scale 3 2
		tcMod scroll 0.15 0.15
		depthWrite
	}
	{
		map textures/skies/topclouds.tga
		blendFunc GL_ONE GL_ONE
		tcMod scale 3 3
		tcMod scroll 0.05 0.05
	}
}

textures/skies_MASTER6/g1zm0_skies
{
	qer_editorImage skpk/qer/6/g1zm0_skies.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 120 4
	nopicmip
	skyparms - 512 -
	{
		map skpk/textures/g1zm0_skies/g1z_dimclouds.tga
		tcMod scale 3 2
		tcMod scroll 0.015 0.015
		depthWrite
	}
	{
		map skpk/textures/g1zm0_skies/g1z_blueclouds.tga
		blendFunc GL_ONE GL_ONE
		tcMod scale 3 3
		tcMod scroll 0.01 0.01
	}
}

textures/skies_MASTER2/bl4b_cloudsHigh
{
	qer_editorImage skpk/qer/env/bl4b-cloudsHigh.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.7 0.7 1 5 138 58 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 95 4
	nopicmip
	skyparms skpk/env/bl4b 512 -
	{
		map skpk/textures/tc_skies/clouds_high.tga
		blendfunc gl_one gl_one
		tcmod scale 3 3
		tcmod scroll 0.009 0.011
	}
}

textures/skies_MASTER/q3tc_urbsky-clouds
{
	qer_editorImage skpk/qer/env/q3tc_urbsky-clouds.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.93669 0.7337 0.33051 35 122 13 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 80 4
	nopicmip
	skyParms skpk/env/q3tc_urbsky 512 -
	{
		map skpk/textures/tc_skies/killsky_2.tga
		blendfunc gl_one gl_one
		tcMod scale 3 3
		tcMod scroll 0.05 0.07
	}
}

textures/skies_MASTER6/hellsky_dm1
{
	qer_editorImage skpk/qer/6/hellsky_dm1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 110 4
	nopicmip
	skyparms - 512 -
	{
		map textures/skies/dimclouds.tga
		tcMod scroll -0.04 -0.02
		tcMod scale 1 1
		depthWrite
	}
	{
		map textures/skies/dimclouds.tga
		tcMod scroll -0.02 -0.02
		tcMod scale 1.5 1.5
		blendfunc add
		detail
	}
}

textures/skies_MASTER6/ggr_sky
{
	qer_editorImage skpk/qer/6/ggr_sky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 110 4
	nopicmip
	skyParms - 512 -
	{
		map skpk/textures/skies/inteldimredclouds.tga
		tcMod scroll 0.1 0.1
		tcMod scale 3 2
		depthWrite
	}
	{
		map textures/skies/inteldimclouds.tga
		blendfunc add
		tcMod scroll 0.05 0.05
		tcMod scale 3 3
	}
}

textures/skies_MASTER6/ghost_whitesky
{
	qer_editorImage skpk/qer/6/ghost_whitesky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 100 4
	nopicmip
	skyparms - 512 -
	{
		map skpk/textures/ghost-custom/whitesky.tga
		tcMod scroll 0.05 .05
		tcMod scale 2 2
		depthWrite
	}
}

textures/skies_MASTER6/ghost_redsky
{
	qer_editorImage skpk/qer/6/ghost_redsky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 100 4
	nopicmip
	skyparms - 512 -
	{
		map skpk/textures/skies/redsky.tga
		tcMod scroll 0.05 .05
		tcMod scale 2 2
		depthWrite
	}
}

textures/skies_MASTER6/ghost_redsky2
{
	qer_editorImage skpk/qer/6/ghost_redsky2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 110 4
	nopicmip
	skyparms - 512 -
	{
		map skpk/textures/skies/redsky2.tga
		tcMod scroll .05 -0.05
		tcMod scale 2 2
		depthWrite
	}
}

textures/skies_MASTER6/ghost_pinksky1
{
	qer_editorImage skpk/qer/6/ghost_pinksky1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 130 4
	nopicmip
	skyparms - 512 -
	{
		map skpk/textures/skies/pinksky1.tga
		tcMod scroll -.05 0.05
		tcMod scale 2 2
		depthWrite
	}
}

textures/skies_MASTER6/ghost_pinksky2
{
	qer_editorImage skpk/qer/6/ghost_pinksky2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 130 4
	nopicmip
	skyparms - 512 -
	{
		map skpk/textures/skies/pinksky2.tga
		tcMod scroll -0.05 -.025
		tcMod scale 2 2
		depthWrite
	}
}

textures/skies_MASTER2/glwarfare
{
	qer_editorImage skpk/qer/env/glsky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.266383 0.274632 0.358662 80 -29 20 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 60 4
	nopicmip
	skyparms skpk/env/glsky - -
}

textures/skies_MASTER6/shaderlab_gm3tourney2
{
	qer_editorImage skpk/qer/6/shaderlab_gm3tourney2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 0.75 0.5 50 138 35 2 16
	q3map_sunExt 1 0.75 0.5 50 8 35 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 85 4
	nopicmip
	skyparms skpk/textures/shaderlab_skybox/env/sky 1024 -
	{
		map skpk/textures/e7/e7evilsky_1.tga
		tcMod scroll 0.025 0.015
		tcMod scale 3 3
		rgbGen identityLighting
	}
	{
		map skpk/textures/gm3tourney2/sky_arc_twinsun2.tga
		blendFunc GL_ONE_MINUS_SRC_ALPHA GL_SRC_ALPHA
		tcMod transform 0.25 0 0 0.25 0.1075 0.1075
		rgbGen identityLighting
	}
}

textures/skies_MASTER2/gon_skybox
{
	qer_editorImage skpk/qer/env/gon/gon.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.5 0.5 0.4 80 -47 12 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 75 4
	nopicmip
	skyparms skpk/env/gon/gon - -
}

textures/skies_MASTER2/crystalsea
{
	qer_editorImage skpk/qer/env/crystalsea/crystalsea.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.361320 0.365118 0.462233 80 94 46 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 60 4
	nopicmip
	skyparms skpk/env/crystalsea/crystalsea - -
}

textures/skies_MASTER6/gg_wildclouds
{
	qer_editorImage skpk/qer/6/gg_wildclouds.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 115 4
	nopicmip
	skyparms - 512 -
	{
		map skpk/textures/gormenghast/gg_wildclouds.tga
		tcMod scale 3 2
		tcMod scroll 0.15 0.15
		depthWrite
	}
	{
		map skpk/textures/gormenghast/gg_clouds.tga
		blendFunc GL_ONE GL_ONE
		tcMod scale 3 3
		tcMod scroll 0.05 0.05
	}
}

textures/skies_MASTER6/gpcell
{
	qer_editorImage skpk/qer/6/gpcell.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 115 4
	nopicmip
	skyparms - 512 -
	{
		map skpk/textures/gpcell/bluesky.tga
		tcMod scale 3 2
		tcMod scroll 0.10 0.10
		depthWrite
	}
	{
		map textures/skies/killsky_2.tga
		blendfunc GL_ONE GL_ONE
		tcMod scroll 0.010 0.020
		tcMod scale 3 2
	}
}

textures/skies_MASTER6/xnight2-killsky
{
	qer_editorImage skpk/qer/6/xnight2-killsky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 20 -43 60 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 60 4
	nopicmip
	skyparms env/xnight2 256 -
	{
		map textures/skies/killsky_2.tga
		blendfunc GL_ONE GL_ONE
		tcMod scroll 0.015 0.025
		tcMod scale 3 2
	}
}

textures/skies_MASTER2/destroyedcity_env
{
	qer_editorImage skpk/qer/env/gpcity_dark/gpcitydark4.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.892507 0.871009 1 25 -10 61 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 75 4
	nopicmip
	skyparms skpk/env/gpcity_dark/gpcitydark4 - -
}

textures/skies_MASTER6/gumchurchsky
{
	qer_editorImage skpk/qer/6/gumchurchsky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 115 4
	nopicmip
	skyparms - 512 -
	{
		map textures/skies/dimclouds.tga
		tcMod scroll 0.03 0.05
		tcMod scale 2 2
		depthWrite
	}
	{
		map skpk/textures/gummo/churchsky.tga
		blendfunc GL_ONE GL_ONE
		tcMod scroll 0.0025 0.003
		tcMod scale 3 2
	}
}

textures/skies_MASTER6/gumsky2
{
	qer_editorImage skpk/qer/6/gumsky2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_sunExt 0.892507 0.871009 1 25 -43 53 8 16
	q3map_lightRGB 255 200 200
	q3map_skyLight 75 4 0 90 0
	nopicmip
	skyparms skpk/textures/huntsky/env/moon - -
	{
		map textures/skies/killsky_1.tga
		blendFunc GL_ONE GL_ONE
		tcMod scale 2 2
		tcMod scroll 0.05 .1
	}
	{
		map textures/skies/killsky_2.tga
		blendfunc GL_ONE GL_ONE
		tcMod scroll 0.05 0.06
		tcMod scale 3 2
	}
}

textures/skies_MASTER/jf_palace
{
	qer_editorImage skpk/qer/env/jf_palace/jf_palace.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 80 133 48 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 55 4
	nopicmip
	skyparms skpk/env/jf_palace/jf_palace - -
}

textures/skies_MASTER6/hate
{
	qer_editorImage skpk/qer/6/hate.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_lightRGB 127 33 28
	q3map_skyLight 88 4 0 90 0
	nopicmip
	skyparms - 512 -
	{
		map skpk/textures/hate/redsky.tga
		tcMod scale 3 2
		tcMod scroll 0.05 0.01
		depthWrite
	}
	{
		map skpk/textures/hate/intelredclouds.tga
		blendFunc GL_ONE GL_ONE
		tcMod scale 3 3
		tcMod scroll 0.2 0.12
	}
}

textures/skies_MASTER6/0sky_north
{
	qer_editorImage skpk/qer/6/0sky_north.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 115 4
	nopicmip
	skyparms - 512 -
	{
		map skpk/textures/0sky/dimclouds.tga
		tcMod scroll 0.005 0.006
		tcMod scale 3 3
		depthWrite
	}
	{
		map skpk/textures/0sky/sky.tga
		blendfunc GL_ONE GL_ONE
		tcMod scroll -0.005 -0.012
		tcMod scale 5 5
	}
}

textures/skies_MASTER6/katiesky
{
	qer_editorImage skpk/qer/6/katiesky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 125 4
	nopicmip
	skyparms - - -
	{
		map skpk/textures/deathmatch/dm1skybot.tga
		tcMod scale 5 5
		tcMod scroll .01 0
		depthWrite
	}
	{
		map skpk/textures/deathmatch/dm1skytop.tga
		blendFunc GL_ONE GL_ONE
		tcMod scale 4 4
		tcMod scroll 0.07 0.07
	}
	{
		map skpk/textures/deathmatch/dm1skytop.tga
		blendFunc GL_ONE GL_ONE
		tcMod scale 1 1
		tcMod scroll -0.1 -0.1
	}
}

textures/skies_MASTER6/hex_greensky
{
	qer_editorImage skpk/qer/6/hex_greensky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 120 4
	nopicmip
	skyparms - 512 -
	{
		map textures/skies/dimclouds.tga
		tcMod scale 3 2
		tcMod scroll 0.15 0.15
		depthWrite
	}
	{
		map skpk/textures/hex3tourney1/hex_greensky.tga
		blendFunc GL_ONE GL_ONE
		tcMod scale 3 3
		tcMod scroll 0.05 0.05
	}
}

textures/skies_MASTER2/charon3dm12sky-dark
{
	qer_editorImage skpk/qer/env/hibernia/sea.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 105 4
	nopicmip
	skyparms skpk/env/hibernia/sea - -
}

textures/skies_MASTER6/hillkeepsky
{
	qer_editorImage skpk/qer/6/hillkeepsky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 115 4
	nopicmip
	skyparms - 512 -
	{
		map skpk/textures/skies/hilkdim.tga
		tcMod scale 3 2
		tcMod scroll 0.15 0.15
		depthWrite
	}
	{
		map skpk/textures/skies/hilktop.tga
		blendFunc GL_ONE GL_ONE
		tcMod scale 3 3
		tcMod scroll 0.05 0.05
	}
}

textures/skies_MASTER6/himmel_skyblue
{
	qer_editorImage skpk/qer/6/himmel_skyblue.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 125 4
	nopicmip
	skyparms - 512 -
	{
		map skpk/textures/himmel/skyblue.tga
		tcMod scale 3 2
		tcMod scroll 0.15 0.15
		depthWrite
	}
	{
		map skpk/textures/himmel/skyblue.tga
		blendFunc GL_ONE GL_ONE
		tcMod scale 3 3
		tcMod scroll 0.05 0.05
	}
}

textures/skies_MASTER2/hipshot_m10
{
	qer_editorImage skpk/qer/textures/hipshot_m10_sky/env/sky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 125 4
	nopicmip
	skyparms skpk/textures/hipshot_m10_sky/env/sky - -
}

textures/skies_MASTER2/hipshot_m13
{
	qer_editorImage skpk/qer/textures/hipshot_m13/env/sky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 125 4
	nopicmip
	skyparms skpk/textures/hipshot_m13/env/sky - -
}

textures/skies_MASTER6/hipshot_m15
{
	qer_editorImage skpk/qer/6/hipshot_m15.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 120 4
	nopicmip
	skyparms - 1000 -
	{
		map skpk/textures/hipshot_m15/clouds.tga
		tcMod scroll 0.004 -0.0025
		tcmod scale 4 4
		rgbGen identityLighting
	}
	{
		map skpk/textures/hipshot_m15/mask.tga
		blendFunc GL_ONE_MINUS_SRC_ALPHA GL_SRC_ALPHA
		tcMod transform 0.25 0 0 0.25 0.1075 0.1075
		rgbGen identityLighting
	}
}

textures/skies_MASTER6/hipshot_m7_sky
{
	qer_editorImage skpk/qer/6/hipshot_m7_sky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 120 4
	nopicmip
	skyparms - 500 -
	{
		map skpk/textures/hipshot_m7_sky/clouds.tga
		tcMod scroll 0.0150 -0.0050
		tcmod scale 5 5
		rgbGen identityLighting
	}
	{
		map skpk/textures/hipshot_m7_sky/clouds2.tga
		tcMod scroll 0.03 -0.02
		blendFunc blend
		tcmod scale 3 3
		rgbGen identityLighting
	}
}

textures/skies_MASTER2/hipshot_m9
{
	qer_editorImage skpk/qer/textures/hipshot_m9_sky/16.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 80 -117 32 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 60 4
	nopicmip
	skyparms skpk/textures/hipshot_m9_sky/16 - -
}

textures/skies_MASTER2/hipshot_dday
{
	qer_editorImage skpk/qer/env/dday2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 120 4
	nopicmip
	skyparms skpk/env/dday2 - -
}

textures/skies_MASTER6/hipshot_tvy
{
	qer_editorImage skpk/qer/6/hipshot_tvy.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 125 4
	nopicmip
	skyparms - 16000 -
	{
		map skpk/textures/hipshot_tvy_skybox/topgun.tga
		tcMod scroll 0.0315 0.0355
		rgbGen identityLighting
	}
	{
		map skpk/textures/hipshot_tvy_skybox/rain_mask.tga
		blendFunc GL_ONE_MINUS_SRC_ALPHA GL_SRC_ALPHA
		tcMod transform 0.25 0 0 0.25 0.1075 0.1075
		rgbGen identityLighting
		tcMod rotate 5
	}
}

textures/skies_MASTER6/avatar_bluesky
{
	qer_editorImage skpk/qer/6/avatar_bluesky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 115 4
	nopicmip
	skyparms - 512 -
	{
		map skpk/textures/avatar/bluesky2.tga
		tcmod scroll 0.01 0.02
	}
	{
		map textures/skies/bluedimclouds.tga
		blendfunc add
		tcmod scroll -0.02 -0.03
	}
}

textures/skies_MASTER2/hogwarts
{
	qer_editorImage skpk/qer/textures/hogwarts/env/h_env.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.6 0.7 1 15 -79 37 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 95 4
	nopicmip
	skyparms skpk/textures/hogwarts/env/h_env - -
}

textures/skies_MASTER2/hong_sky
{
	qer_editorImage skpk/qer/textures/half_snake/hong_sky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 110 45 34 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 75 4
	nopicmip
	skyparms skpk/textures/half_snake/hong_sky - -
}

textures/skies_MASTER2/ik_sky_lake
{
	qer_editorImage skpk/qer/env/ik3dm2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 0.9 0.7 85 21 48 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 65 4
	nopicmip
	skyparms skpk/env/ik3dm2 - -
}

textures/skies_MASTER6/ikbase_day-clouds
{
	qer_editorImage skpk/qer/6/ikbase_day-clouds.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 115 4
	nopicmip
	skyparms - 512 -
	{
		map skpk/textures/ikbase_sky/ik_sky_day_back.tga
		tcMod scale 2 2
		tcMod scroll 0.01 0.01
		depthWrite
	}
	{
		map skpk/textures/ikbase_sky/ik_sky_day_front.tga
		blendFunc GL_ONE GL_ONE
		tcMod scale 3 3
		tcMod scroll 0.02 0.02
	}
}

textures/skies_MASTER6/ikbase_dawn-clouds
{
	qer_editorImage skpk/qer/6/ikbase_dawn-clouds.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 115 4
	nopicmip
	skyparms - 512 -
	{
		map skpk/textures/ikbase_sky/ik_sky_dawn_back.tga
		tcMod scale 2 2
		tcMod scroll 0.01 0.01
		depthWrite
	}
	{
		map skpk/textures/ikbase_sky/ik_sky_dawn_front.tga
		blendFunc GL_ONE GL_ONE
		tcMod scale 3 3
		tcMod scroll 0.02 0.02
	}
}

textures/skies_MASTER2/ik_lake
{
	qer_editorImage skpk/qer/env/iklake.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 0.9 0.7 80 32 60 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 75 4
	nopicmip
	skyparms skpk/env/iklake - -
}

textures/skies_MASTER6/island_noon
{
	qer_editorImage skpk/qer/6/island_noon.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 115 4
	nopicmip
	skyparms - 512 -
	{
		map skpk/textures/post/gazeboTex099.tga
		depthWrite
	}
	{
		map skpk/textures/post/gazeboTex099.tga
		blendFunc GL_ONE GL_ONE
	}
}

textures/skies_MASTER6/himmel_jaget
{
	qer_editorImage skpk/qer/6/himmel_jaget.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 120 4
	nopicmip
	skyparms - 512 -
	{
		map skpk/textures/jaget/himmel.tga
		tcMod scroll 0.02 0
		tcMod scale 1 1
		depthWrite
	}
	{
		map skpk/textures/jaget/himmel.tga
		blendFunc GL_ONE GL_ONE
		tcMod scroll 0.02 0.01
		tcMod scale 3 3
	}
}

textures/skies_MASTER6/jalt2osp
{
	qer_editorImage skpk/qer/6/jalt2osp.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 120 4
	nopicmip
	skyparms - 512 -
	{
		map textures/skies/pjbasesky.tga
		tcMod scale 3 2
		tcMod scroll 0.15 0.15
		depthWrite
	}
	{
		map textures/skies/killsky_2.tga
		blendFunc GL_ONE GL_ONE
		tcMod scale 3 3
		tcMod scroll 0.05 0.05
	}
}

textures/skies_MASTER6/Eveningsky-nobottom
{
	qer_editorImage skpk/qer/6/Eveningsky-nobottom.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 115 4
	nopicmip
	skyparms - 256 -
	{
		map skpk/textures/a-japanhouse/sky_blue.tga
		tcMod scale 1 1
		depthWrite
	}
}

textures/skies_MASTER2/japrip
{
	qer_editorImage skpk/qer/env/japrip.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 115 4
	nopicmip
	skyparms skpk/env/japrip - -
}

textures/skies_MASTER6/jas3dm5
{
	qer_editorImage skpk/qer/6/jas3dm5.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 110 4
	nopicmip
	skyparms - 512 -
	{
		map textures/skies/topclouds.tga
		tcMod scroll 0.01 0.01
		tcMod scale 3 3
		depthWrite
	}
	{
		map textures/skies/bluedimclouds.tga
		blendfunc GL_ONE GL_ONE
		tcMod scroll 0.01 0.01
		tcMod scale 5 5
	}
}

textures/skies_MASTER6/jb3dm13
{
	qer_editorImage skpk/qer/6/jb3dm13.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 125 4
	nopicmip
	skyparms - 384 -
	{
		map skpk/textures/jb3dm13/jb_sky1_fog.tga
		tcMod scroll 0.03 0.05
		tcMod scale 2 2
		depthWrite
	}
	{
		map skpk/textures/jb3dm13/jb_sky3_detail.tga
		blendfunc GL_ONE GL_ONE
		tcMod scroll 0.025 0.03
		tcMod scale 3 2
	}
}

textures/skies_MASTER6/ikbase_jb3dm14
{
	qer_editorImage skpk/qer/6/ikbase_jb3dm14.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms - 384 -
	{
		map skpk/textures/jb3dm13/jb_sky1_fog.tga
		tcMod scroll 0.03 0.05
		tcMod scale 2 2
		depthWrite
	}
	{
		map skpk/textures/ikbase_sky/ik_sky_dawn_back.tga
		blendfunc GL_ONE GL_ONE
		tcMod scroll 0.025 0.03
		tcMod scale 3 2
	}
	{
		map skpk/textures/ikbase_sky/ik_sky_dawn_front.tga
		blendfunc GL_ONE GL_ONE
		tcMod scroll 0.075 0.003
		tcMod scale 3 2
	}
}

textures/skies_MASTER2/jerky_pork
{
	qer_editorImage skpk/qer/env/pork.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt .9 .9 1 60 -29 28 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 55 4
	nopicmip
	skyparms skpk/env/pork - -
}

textures/skies_MASTER2/jk_curved_skyr
{
	qer_editorImage skpk/qer/env/c1-cloudsR.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyParms skpk/env/c1 - -
	{
		map skpk/textures/alliance/jk_skyred.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		tcMod scroll 0.05 0
		tcMod scale 2 2
		depthWrite
	}
}

textures/skies_MASTER2/jk_curved_skyb
{
	qer_editorImage skpk/qer/env/c1-cloudsB.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 150 4
	nopicmip
	skyParms skpk/env/c1 - -
	{
		map skpk/textures/alliance/jk_skyblue.tga
		blendfunc GL_ONE GL_ONE
		tcMod scroll 0.05 0
		tcMod scale 2 2
		depthWrite
	}
}

textures/skies_MASTER6/jk_buriedskies
{
	qer_editorImage skpk/qer/6/jk_buriedskies.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 120 4
	nopicmip
	skyparms - 200 -
	{
		map textures/skies/dimclouds.tga
		tcMod scroll 0.003 0.003
		tcMod scale 3 3
		depthWrite
	}
	{
		map skpk/textures/alliance/jk_buriedsky.tga
		blendfunc GL_ONE GL_ONE
		tcMod scroll -0.004 -0.004
		tcMod scale 5 5
	}
}

textures/skies_MASTER6/jnydm1sky
{
	qer_editorImage skpk/qer/6/jnydm1sky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 120 4
	nopicmip
	skyparms - 384 -
	{
		map skpk/textures/jnydm1/jnydm1sky3.tga
		tcMod scale 3 2
		tcMod scroll 0.15 0.18
		depthWrite
	}
	{
		map skpk/textures/jnydm1/jnydm1sky4.tga
		blendFunc GL_ONE GL_ONE
		tcMod scale 2 2
		tcMod scroll 0.08 0.05
	}
}

textures/skies_MASTER/mp_hallowed-clouds
{
	qer_editorImage skpk/qer/env/mp_hallowed/hg-clouds.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 125 4
	nopicmip
	skyparms skpk/env/mp_hallowed/hg 512 -
	{
		map skpk/textures/jnydm1/jnydm1sky3.tga
		tcmod scroll .08 .05
		blendfunc add
	}
}

textures/skies_MASTER2/jul_b20
{
	qer_editorImage skpk/qer/textures/jul_b20/sky/b20.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 125 4
	nopicmip
	skyParms skpk/textures/jul_b20/sky/b20 - -
}

textures/skies_MASTER2/gwiazdy
{
	qer_editorImage skpk/qer/textures/env/gwiazdy/gwiazdy.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 125 4
	nopicmip
	skyParms skpk/textures/env/gwiazdy/gwiazdy - -
}

textures/skies_MASTER6/jul_jul32
{
	qer_editorImage skpk/qer/6/jul_jul32.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 95 4
	nopicmip
	skyParms skpk/env/whitesky/white 1024 -
	{
		map skpk/textures/jul_jul32/skybox/chmury.tga
		rgbGen identityLighting
		tcMod scale 1.5 1.5
		tcMod scroll 0.005 0.0135
	}
	{
		map skpk/textures/jul_jul32/skybox/sky_arc_masked.tga
		blendfunc gl_one_minus_src_alpha gl_src_alpha
		tcMod transform 0.25 0 0 0.25 0.1075 0.1075
	}
}

textures/skies_MASTER6/0color_blue-chalk
{
	qer_editorImage skpk/qer/textures/jul_jul32/skybox/box.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 95 4
	nopicmip
	skyParms skpk/textures/jul_jul32/skybox/box - -
}

textures/skies_MASTER6/jul_jul38
{
	qer_editorImage skpk/qer/6/jul_jul38.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 16
	q3map_lightRGB 0.9 0.96 1.0
	q3map_skyLight 95 4 0 90 0
	nopicmip
	skyParms skpk/env/whitesky/white 1280 -
	{
		map skpk/textures/jul_jul38/box/chmury.tga
		rgbGen identityLighting
		tcMod scale 2 2
		tcMod scroll 0.005 -0.0125
	}
	{
		map skpk/textures/jul_jul32/skybox/sky_arc_masked.tga
		blendfunc gl_one_minus_src_alpha gl_src_alpha
		tcMod transform 0.25 0 0 0.25 0.1075 0.1075
	}
}

textures/skies_MASTER2/hipshot_m10-dark
{
	qer_editorImage skpk/qer/textures/jul_julc/env2/sky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 100 4
	nopicmip
	skyParms skpk/textures/jul_julc/env2/sky - -
}

textures/skies_MASTER6/xmkc_ctf5sky
{
	qer_editorImage skpk/qer/6/xmkc_ctf5sky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 115 4
	nopicmip
	skyparms - 512 -
	{
		map skpk/textures/skies/nightsky.tga
		tcMod scale 5 8
		tcMod scroll 0.7 0.1
		depthWrite
	}
	{
		map skpk/textures/skies/nightsky_nocloud.tga
		blendFunc GL_DST_COLOR GL_ZERO
		tcMod scale 3 5
		tcMod scroll 0.3 0.1
	}
}

textures/skies_MASTER6/kamis
{
	qer_editorImage skpk/qer/6/kamis.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_lightRGB 196 242 233
	q3map_skyLight 140 4 0 90 0
	nopicmip
	skyparms skpk/env/kamis/ddd - -
	{
		map skpk/textures/skies/newclouds.tga
		tcMod scroll 0.05 0.07
		blendFunc GL_ONE GL_ONE
	}
	{
		map skpk/textures/tenshi/nuage2.tga
		tcMod scroll 0.03 0.02
		blendFunc GL_ONE GL_ONE
	}
}

textures/skies_MASTER6/0color_green-army
{
	qer_editorImage skpk/qer/6/0color_green-army.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 110 4
	nopicmip
	skyparms - 512 -
	{
		map skpk/textures/kazdm5_sfx/sfx_water_sky_64x64.tga
	}
}

textures/skies_MASTER/elbrus-clouds
{
	qer_editorImage skpk/qer/textures/kazsky/kazsky-clouds.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.8 0.75 0.6 5 37 66 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 95 4
	nopicmip
	skyparms skpk/textures/kazsky/kazsky - -
	{
		map skpk/textures/kazsky/cloudpass1.tga
		tcMod scroll 0.0025 -0.0075
		blendFunc add
	}
	{
		map skpk/textures/kazsky/cloudpass2.tga
		tcMod scroll -0.0025 0.0075
		blendFunc filter
	}
}

textures/skies_MASTER6/kfreesky
{
	qer_editorImage skpk/qer/6/kfreesky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 115 4
	nopicmip
	skyparms - 512 -
	{
		map skpk/textures/skies/kfreesky.tga
		tcMod scroll 0.04 0
		tcMod scale 2 2
		depthWrite
	}
}

textures/skies_MASTER/mp_doornthree-cloud
{
	qer_editorImage skpk/qer/env/mp_doornthree/doornthree512-clouds.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1.00 0.95 0.877 35 0 5 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/mp_doornthree/doornthree512 - -
	{
		map textures/skies/killsky_2.tga
		blendfunc GL_ONE GL_ONE
		tcMod scroll -0.025 -0.03
		tcMod scale 3 2
	}
}

textures/skies_MASTER6/kfsky00
{
	qer_editorImage skpk/qer/6/kfsky00.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 115 4
	nopicmip
	skyparms - 386 -
	{
		map skpk/textures/efdat/kfsky00.tga
		tcMod scroll 0.035 0.035
		tcMod scale 4 4
		depthWrite
	}
	{
		map skpk/textures/efdat/kfsky01.tga
		blendfunc GL_ONE GL_ONE
		tcMod scroll 0.06 0.06
		tcMod scale 5 5
	}
}

textures/skies_MASTER6/khaooohs
{
	qer_editorImage skpk/qer/6/khaooohs.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 115 4
	nopicmip
	skyparms - 512 -
	{
		map textures/skies/topclouds.tga
		tcMod scroll 0.015 0.016
		tcMod scale 3 3
	}
	{
		map textures/skies/topclouds.tga
		blendfunc GL_ONE GL_ONE
		tcMod scroll -0.01 -0.012
		tcMod scale 5 5
	}
}

textures/skies_MASTER2/cssa1sky
{
	qer_editorImage skpk/qer/textures/kiiia/cssa1/cssa1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_sunExt 249 251 230 45 40 67 9 16
	q3map_sunExt 212 194 232 25 -60 64 5 16
	q3map_skyLight 50 4
	nopicmip
	skyparms skpk/textures/kiiia/cssa1/cssa1 - -
}

textures/skies_MASTER6/avatar_bluesky3
{
	qer_editorImage skpk/qer/6/avatar_bluesky3.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 115 4
	nopicmip
	skyparms - 512 -
	{
		map textures/skies/dimclouds.tga
		tcMod scroll 0.04 0.04
		tcMod scale 3 3
		depthWrite
	}
	{
		map skpk/textures/avatar/bluesky2.tga
		blendfunc GL_ONE GL_ONE
		tcMod scroll 0.01 0.01
		tcMod scale 1 1
	}
}

textures/skies_MASTER2/berg3
{
	qer_editorImage skpk/qer/env/berg3.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.266383 0.274632 0.358662 70 60 13 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 60 4
	nopicmip
	skyparms skpk/env/berg3 - -
}

textures/skies_MASTER6/avatar_bluesky2
{
	qer_editorImage skpk/qer/6/avatar_bluesky2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 110 4
	nopicmip
	skyparms - 256 -
	{
		map textures/skies/dimclouds.tga
		tcMod scroll 0.01 0.01
		tcMod scale 3 3
		depthWrite
	}
	{
		map skpk/textures/avatar/bluesky2.tga
		blendfunc GL_ONE GL_ONE
		tcMod scroll -0.05 -0.05
		tcMod scale 5 5
	}
}

textures/skies_MASTER6/xnight2-purpleclouds
{
	qer_editorImage skpk/qer/6/xnight2-purpleclouds.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.4 0.3 0.6 25 330 70 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 90 4
	nopicmip
	skyparms env/xnight2 192 -
	{
		map skpk/textures/q1dm2/purpleclouds.tga
		blendFunc GL_ONE GL_ONE
		tcMod scale 1 2
		tcMod scroll 0.10 -0.10
	}
}

textures/skies_MASTER2/kitcapsule
{
	qer_editorImage skpk/qer/textures/kit_capsule/kitcapsulesky/city.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt .5 .37 .19 80 -96 18 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 55 4
	nopicmip
	skyparms skpk/textures/kit_capsule/kitcapsulesky/city - -
}

textures/skies_MASTER6/cardigan_purpLightning3
{
	qer_editorImage skpk/qer/6/cardigan_purpLightning3.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.968628 0.803922 0.984314 5 330 70 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 90 4
	nopicmip
	skyparms env/xnight2 - -
	{
		map skpk/textures/cardigan_skies1/circlegradlightningblur2.tga
		blendfunc add
		tcMod scale 0.32 0.32
		tcMod rotate -20
	}
	{
		map skpk/textures/cardigan_skies1/sparse_purple_nebula.tga
		blendfunc filter
		tcMod scroll 0.01 0.03
	}
}

textures/skies_MASTER/mp_mercury-lightning-cloud
{
	qer_editorImage skpk/qer/env/mp_mercury/mercury-clouds.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 0.215 0 100 0 90 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/mp_mercury/mercury - -
	{
		map skpk/textures/cardigan_skies1/circlegradlightningblur2.tga
		blendfunc add
		rgbGen wave noise 0 1 0 10
		tcMod scale 0.32 0.32
		tcMod rotate -20
	}
	{
		map skpk/textures/cardigan_skies1/sparse_purple_nebula.tga
		blendfunc filter
		tcMod scroll 0.05 0.06
	}
}

textures/skies_MASTER/ame_comedown
{
	qer_editorImage skpk/qer/env/amethyst7/comedown/comedown.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 105 4
	nopicmip
	skyparms skpk/env/amethyst7/comedown/comedown - -
}

textures/skies_MASTER3/mtnsun-clouds
{
	qer_editorImage skpk/qer/env/kvart/kvart-clouds.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 110 4
	nopicmip
	skyparms skpk/env/kvart/kvart - -
	{
		map textures/skies/dimclouds.tga
		blendfunc GL_ONE GL_ONE
		tcMod scroll 0.05 0
		tcMod scale 3 2
	}
}

textures/skies_MASTER6/greysky
{
	qer_editorImage skpk/qer/6/greysky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyParms - 512 -
	{
		map skpk/textures/lae3dm2/greybluesky.tga
		rgbGen identity
		tcMod scale 3 2
		tcMod scroll 0.15 0.15
		depthWrite
	}
	{
		map skpk/textures/lae3dm2/greysky1.tga
		blendfunc filter
		rgbGen identity
		tcMod scale 3 3
		tcMod scroll 0.05 0.05
	}
}

textures/skies_MASTER2/lastarenasky
{
	qer_editorImage skpk/qer/textures/lastarena/lastarenasky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 .875 .608 75 0 18 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 95 4
	nopicmip
	skyparms skpk/textures/lastarena/lastarenasky - -
}

textures/skies_MASTER6/sky_Daljabah06
{
	qer_editorImage skpk/qer/6/sky_Daljabah06.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 60 -97 79 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 70 4
	nopicmip
	skyParms skpk/env/Daljabah06 256 -
	{
		map skpk/textures/skies/sky_Daljabah06.tga
		blendfunc gl_dst_color gl_one_minus_dst_color
		tcMod scroll 0.0003 0.0002
		tcMod scale 6 5
		depthWrite
	}
}

textures/skies_MASTER/LDAforestsky_x
{
	qer_editorImage skpk/qer/env/LDAforestsky_x-clouds.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.0156863 0.0352941 0.0313726 15 -132 74 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 100 4
	nopicmip
	skyParms skpk/env/LDAforestsky_x 128 -
	{
		map skpk/textures/skies/LDAforestsky_x.tga
		blendfunc add
		tcMod scroll 0.02 0.03
		tcMod scale 3 2
	}
}

textures/skies_MASTER2/floodland
{
	qer_editorImage skpk/qer/textures/leafland/forest.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_lightRGB 255 255 227
	q3map_skylight 70 4 0 90 0
	nopicmip
	skyparms skpk/textures/leafland/forest - -
}

textures/skies_MASTER2/neptune_sky
{
	qer_editorImage skpk/qer/env/nineplanets/neptune.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 100 100 140 5 225 65 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 100 4
	nopicmip
	skyparms skpk/env/nineplanets/neptune - -
}

textures/skies_MASTER6/lffd_sfx
{
	qer_editorImage skpk/qer/6/lffd_sfx.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 100 4
	nopicmip
	skyParms - 256 -
	{
		map textures/skies/topclouds.tga
		tcMod scale 6.9 7.9
		tcMod scroll 0.005 0.01
	}
	{
		map textures/skies/dimclouds.tga
		blendfunc add
		tcMod scale 8 9
		tcMod scroll 0.01 0.005
	}
}

textures/skies_MASTER2/lloydmdm1
{
	qer_editorImage skpk/qer/env/lloydmdm1/lloydmdm1fsky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt .5 .37 .19 80 167 9 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 95 4
	nopicmip
	skyparms skpk/env/lloydmdm1/lloydmdm1fsky - -
}

textures/skies_MASTER/ame_lostatseaday
{
	qer_editorImage skpk/qer/env/amethyst7/lostatseaday/lostatseaday.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt .90 .95 1 80 -89 15 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 75 4
	nopicmip
	skyparms skpk/env/amethyst7/lostatseaday/lostatseaday - -
}

textures/skies_MASTER2/lostcolossus
{
	qer_editorImage skpk/qer/textures/lostcolossus/colossus_sky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.25 0.25 0.20 70 -89 60 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 65 4
	nopicmip
	skyparms skpk/textures/lostcolossus/colossus_sky - -
}

textures/skies_MASTER6/lotbotsky01
{
	qer_editorImage skpk/qer/6/lotbotsky01.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 105 4
	nopicmip
	skyParms - 512 -
	{
		map textures/skies/intelredclouds.tga
		tcMod scroll 0.05 0
		tcMod scale 2 2
		depthWrite
	}
}

textures/skies_MASTER/sb_desert-dimclouds
{
	qer_editorImage skpk/qer/env/sb_desert/desert-dimclouds.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 .95 .977 80 200 50 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/sb_desert/desert - -
	{
		map textures/skies/dimclouds.tga
		blendFunc GL_ONE GL_ONE
		tcMod scale 3 3
		tcMod scroll 0.10 0.10
	}
}

textures/skies_MASTER/fullmoon-dimclouds
{
	qer_editorImage skpk/qer/env/fullmoon/fullmoon-clouds.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 241 224 255 40 -97 29 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 80 4
	nopicmip
	skyparms skpk/env/fullmoon/fullmoon - -
	{
		map textures/skies/dimclouds.tga
		blendFunc GL_ONE GL_ONE
		tcMod scale 3 3
		tcMod scroll 0.05 0.05
	}
}

textures/skies_MASTER2/sky_lp20
{
	qer_editorImage skpk/qer/env/lp20.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	nopicmip
	skyparms skpk/env/lp20 - -

	//similar to
//	q3map_LightMapFilterRadius 0 8
//	q3map_skylight 105 5 -90 90 1
	//but slower

	q3map_sunExt 0.900 0.911 0.911 2.0 210.39 69.763 5 16
	q3map_sunExt 0.900 0.911 0.911 2.0 89.912 69.165 5 16
	q3map_sunExt 0.900 0.911 0.911 2.0 269.80 69.024 5 16
	q3map_sunExt 0.900 0.911 0.911 2.0 179.97 58.261 5 16
	q3map_sunExt 0.900 0.911 0.911 2.0 359.74 58.303 5 16
	q3map_sunExt 0.900 0.911 0.911 2.0 329.26 69.799 5 16
	q3map_sunExt 0.900 0.911 0.911 2.0 205.88 49.767 5 16
	q3map_sunExt 0.900 0.911 0.911 2.0 269.83 48.927 5 16
	q3map_sunExt 0.900 0.911 0.911 2.0 253.44 89.926 5 16
	q3map_sunExt 0.900 0.911 0.911 2.0 238.16 53.928 5 16
	q3map_sunExt 0.900 0.911 0.911 2.0 301.50 53.950 5 16
	q3map_sunExt 0.900 0.911 0.911 2.0 224.88 35.199 5 16
	q3map_sunExt 0.900 0.911 0.911 2.0 224.83 -35.32 5 16
	q3map_sunExt 0.900 0.911 0.911 2.0 134.81 -35.22 5 16
	q3map_sunExt 0.900 0.911 0.911 2.0 134.90 35.299 5 16
	q3map_sunExt 0.900 0.911 0.911 2.0 44.883 -35.19 5 16
	q3map_sunExt 0.900 0.911 0.911 2.0 44.833 35.329 5 16
	q3map_sunExt 0.900 0.911 0.911 2.0 314.81 35.229 5 16
	q3map_sunExt 0.900 0.911 0.911 2.0 314.90 -35.29 5 16
	q3map_sunExt 0.900 0.911 0.911 2.0 89.803 -69.02 5 16
	q3map_sunExt 0.900 0.911 0.911 2.0 269.91 -69.16 5 16
	q3map_sunExt 0.900 0.911 0.911 2.0 179.74 -58.30 5 16
	q3map_sunExt 0.900 0.911 0.911 2.0 89.845 -31.64 5 16
	q3map_sunExt 0.900 0.911 0.911 2.0 359.97 -58.26 5 16
	q3map_sunExt 0.900 0.911 0.911 2.0 269.87 -31.78 5 16
	q3map_sunExt 0.900 0.911 0.911 2.0 269.84 31.646 5 16
	q3map_sunExt 0.900 0.911 0.911 2.0 89.871 31.788 5 16
	q3map_sunExt 0.900 0.911 0.911 2.0 333.80 49.805 5 16
	q3map_sunExt 0.900 0.911 0.911 2.0 25.760 49.867 5 16
	q3map_sunExt 0.900 0.911 0.911 2.0 30.123 69.870 5 16
	q3map_sunExt 0.900 0.911 0.911 2.0 359.79 41.022 5 16
	q3map_sunExt 0.900 0.911 0.911 2.0 290.12 35.397 5 16
	q3map_sunExt 0.900 0.911 0.911 2.0 269.88 -49.06 5 16
	q3map_sunExt 0.900 0.911 0.911 2.0 290.18 -35.51 5 16
	q3map_sunExt 0.900 0.911 0.911 2.0 249.56 -35.53 5 16
	q3map_sunExt 0.900 0.911 0.911 2.0 329.65 -69.83 5 16
	q3map_sunExt 0.900 0.911 0.911 2.0 333.97 -49.82 5 16
	q3map_sunExt 0.900 0.911 0.911 2.0 25.889 -49.76 5 16
	q3map_sunExt 0.900 0.911 0.911 2.0 359.91 -40.98 5 16
	q3map_sunExt 0.900 0.911 0.911 2.0 30.397 -69.76 5 16
	q3map_sunExt 0.900 0.911 0.911 2.0 110.12 -35.39 5 16
	q3map_sunExt 0.900 0.911 0.911 2.0 89.834 -48.92 5 16
	q3map_sunExt 0.900 0.911 0.911 2.0 69.568 -35.38 5 16
	q3map_sunExt 0.900 0.911 0.911 2.0 205.76 -49.86 5 16
	q3map_sunExt 0.900 0.911 0.911 2.0 210.12 -69.87 5 16
	q3map_sunExt 0.900 0.911 0.911 2.0 153.80 -49.80 5 16
	q3map_sunExt 0.900 0.911 0.911 2.0 149.26 -69.79 5 16
	q3map_sunExt 0.900 0.911 0.911 2.0 179.79 -41.02 5 16
	q3map_sunExt 0.900 0.911 0.911 2.0 338.91 29.994 5 16
	q3map_sunExt 0.900 0.911 0.911 2.0 20.729 30.044 5 16
	q3map_sunExt 0.900 0.911 0.911 2.0 58.113 54.071 5 16
	q3map_sunExt 0.900 0.911 0.911 2.0 121.65 54.049 5 16
	q3map_sunExt 0.900 0.911 0.911 2.0 301.65 -54.04 5 16
	q3map_sunExt 0.900 0.911 0.911 2.0 338.99 -30.00 5 16
	q3map_sunExt 0.900 0.911 0.911 2.0 20.797 -29.95 5 16
	q3map_sunExt 0.900 0.911 0.911 2.0 58.167 -53.92 5 16
	q3map_sunExt 0.900 0.911 0.911 2.0 238.11 -54.07 5 16
	q3map_sunExt 0.900 0.911 0.911 2.0 73.445 -89.92 5 16
	q3map_sunExt 0.900 0.911 0.911 2.0 121.50 -53.95 5 16
	q3map_sunExt 0.900 0.911 0.911 2.0 158.99 30.005 5 16
	q3map_sunExt 0.900 0.911 0.911 2.0 158.91 -29.99 5 16
	q3map_sunExt 0.900 0.911 0.911 2.0 200.79 29.955 5 16
	q3map_sunExt 0.900 0.911 0.911 2.0 200.72 -30.04 5 16
	q3map_sunExt 0.900 0.911 0.911 2.0 89.882 49.068 5 16
	q3map_sunExt 0.900 0.911 0.911 2.0 69.561 35.530 5 16
	q3map_sunExt 0.900 0.911 0.911 2.0 110.18 35.515 5 16
	q3map_sunExt 0.900 0.911 0.911 2.0 153.97 49.829 5 16
	q3map_sunExt 0.900 0.911 0.911 2.0 149.65 69.834 5 16
	q3map_sunExt 0.900 0.911 0.911 2.0 179.91 40.981 5 16
	q3map_sunExt 0.900 0.911 0.911 2.0 249.56 35.383 5 16
	q3map_sunExt 0.725 0.760 0.760 1.5 179.83 -20.92 5 16
	q3map_sunExt 0.725 0.760 0.760 1.5 179.88 20.884 5 16
	q3map_sunExt 0.725 0.760 0.760 1.5 359.88 -20.88 5 16
	q3map_sunExt 0.725 0.760 0.760 1.5 359.83 20.925 5 16
	q3map_sunExt 0.725 0.760 0.760 1.5 342.28 -10.05 5 16
	q3map_sunExt 0.725 0.760 0.760 1.5 322.66 -16.43 5 16
	q3map_sunExt 0.725 0.760 0.760 1.5 322.62 16.384 5 16
	q3map_sunExt 0.725 0.760 0.760 1.5 342.25 10.054 5 16
	q3map_sunExt 0.725 0.760 0.760 1.5 17.437 10.096 5 16
	q3map_sunExt 0.725 0.760 0.760 1.5 37.053 16.469 5 16
	q3map_sunExt 0.725 0.760 0.760 1.5 37.079 -16.35 5 16
	q3map_sunExt 0.725 0.760 0.760 1.5 17.459 -10.01 5 16
	q3map_sunExt 0.725 0.760 0.760 1.5 100.40 17.377 5 16
	q3map_sunExt 0.725 0.760 0.760 1.5 79.322 17.385 5 16
	q3map_sunExt 0.725 0.760 0.760 1.5 280.38 17.246 5 16
	q3map_sunExt 0.725 0.760 0.760 1.5 259.31 17.238 5 16
	q3map_sunExt 0.725 0.760 0.760 1.5 259.32 -17.38 5 16
	q3map_sunExt 0.725 0.760 0.760 1.5 280.40 -17.37 5 16
	q3map_sunExt 0.725 0.760 0.760 1.5 79.317 -17.23 5 16
	q3map_sunExt 0.725 0.760 0.760 1.5 100.38 -17.24 5 16
	q3map_sunExt 0.725 0.760 0.760 1.5 162.28 10.057 5 16
	q3map_sunExt 0.725 0.760 0.760 1.5 162.25 -10.05 5 16
	q3map_sunExt 0.725 0.760 0.760 1.5 142.62 -16.38 5 16
	q3map_sunExt 0.725 0.760 0.760 1.5 142.66 16.436 5 16
	q3map_sunExt 0.725 0.760 0.760 1.5 197.45 10.014 5 16
	q3map_sunExt 0.725 0.760 0.760 1.5 217.07 16.350 5 16
	q3map_sunExt 0.725 0.760 0.760 1.5 217.05 -16.46 5 16
	q3map_sunExt 0.725 0.760 0.760 1.5 197.43 -10.09 5 16
	q3map_sunExt 0.725 0.760 0.760 1.5 58.134 18.071 5 16
	q3map_sunExt 0.725 0.760 0.760 1.5 301.55 17.950 5 16
	q3map_sunExt 0.725 0.760 0.760 1.5 301.59 -18.04 5 16
	q3map_sunExt 0.725 0.760 0.760 1.5 58.147 -17.92 5 16
	q3map_sunExt 0.725 0.760 0.760 1.5 121.55 -17.95 5 16
	q3map_sunExt 0.725 0.760 0.760 1.5 121.59 18.049 5 16
	q3map_sunExt 0.725 0.760 0.760 1.5 238.14 17.928 5 16
	q3map_sunExt 0.725 0.760 0.760 1.5 238.13 -18.07 5 16
	q3map_sunExt 0.550 0.600 0.600 1.0 48.856 0.0669 5 16
	q3map_sunExt 0.550 0.600 0.600 1.0 248.95 -0.073 5 16
	q3map_sunExt 0.550 0.600 0.600 1.0 110.76 0.0585 5 16
	q3map_sunExt 0.550 0.600 0.600 1.0 68.953 0.0734 5 16
	q3map_sunExt 0.550 0.600 0.600 1.0 290.76 -0.058 5 16
	q3map_sunExt 0.550 0.600 0.600 1.0 211.57 -0.054 5 16
	q3map_sunExt 0.550 0.600 0.600 1.0 148.14 0.0194 5 16
	q3map_sunExt 0.550 0.600 0.600 1.0 31.575 0.0548 5 16
	q3map_sunExt 0.550 0.600 0.600 1.0 328.14 -0.019 5 16
	q3map_sunExt 0.550 0.600 0.600 1.0 310.86 -0.039 5 16
	q3map_sunExt 0.550 0.600 0.600 1.0 130.86 0.0396 5 16
	q3map_sunExt 0.550 0.600 0.600 1.0 228.85 -0.066 5 16
	q3map_sunExt 0.550 0.600 0.600 1.0 359.85 0.0208 5 16
	q3map_sunExt 0.550 0.600 0.600 1.0 269.85 -0.070 5 16
	q3map_sunExt 0.550 0.600 0.600 1.0 89.858 0.0706 5 16
	q3map_sunExt 0.550 0.600 0.600 1.0 179.85 -0.020 5 16
}

textures/skies_MASTER6/lundessky1
{
	qer_editorImage skpk/qer/6/lundessky1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 110 4
	nopicmip
	skyparms - 512 -
	{
		map skpk/textures/lundesert/lundessky1.tga
		tcMod scroll 0.035 .015
		depthWrite
	}
	{
		map textures/skies/dimclouds.tga
		blendfunc GL_ONE GL_ONE
		tcMod scroll 0.015 0.016
		tcMod scale 3 2
	}
}

textures/skies_MASTER2/saa_aero
{
	qer_editorImage skpk/qer/env/aero.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.266383 0.274632 0.358662 60 58 30 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 100 4
	nopicmip
	skyparms skpk/env/aero - -
}

textures/skies_MASTER6/lunatic-clouds
{
	qer_editorImage skpk/qer/6/lunatic-clouds.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 100 4
	nopicmip
	skyparms - 512 -
	{
		map skpk/textures/tc_skies/clouds_dark.tga
		tcMod scale 3 2
		tcMod scroll 0.15 0.15
		depthWrite
	}
	{
		map skpk/textures/tc_skies/clouds_high.tga
		blendFunc GL_ONE GL_ONE
		tcMod scale 3 3
		tcMod scroll 0.05 0.05
	}
}

textures/skies_MASTER2/m3a_bb1on1
{
	qer_editorImage skpk/qer/textures/m3a_bb1on1/m3a_bb1vs1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.25 0.25 0.20 70 -90 24 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 60 4
	nopicmip
	skyparms skpk/textures/m3a_bb1on1/m3a_bb1vs1 - -
}

textures/skies_MASTER2/map_campgroundsredux
{
	qer_editorImage skpk/qer/textures/map_campgroundsredux/sky/act2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms skpk/textures/map_campgroundsredux/sky/act2 - -
}

textures/skies_MASTER2/exosystem2
{
	qer_editorImage skpk/qer/textures/map_oxodm7/env/exosystem2/exosystem2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 .40625 .17578125 90 -55 17 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 80 4
	nopicmip
	skyparms skpk/textures/map_oxodm7/env/exosystem2/exosystem2 - -
}

textures/skies_MASTER6/map_sandstorm
{
	qer_editorImage skpk/qer/6/map_sandstorm.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 4 3 3 65 -65 4 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 80 4
	nopicmip
	skyparms skpk/textures/map_sandstorm/sky/red - -
	{
		map textures/skies/killsky_2.tga
		blendfunc GL_ONE GL_ONE
		tcMod scroll 0.05 0.06
		tcMod scale 3 2
	}
}

textures/skies_MASTER6/mario_ctf
{
	qer_editorImage skpk/qer/6/mario_ctf.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 125 4
	nopicmip
	skyparms - 1024 -
	{
		map skpk/textures/mario/nuages.tga
		tcmod scale 2 2
		tcMod scroll 0.1 0.1
	}
}

textures/skies_MASTER/hip_miramar-green
{
	qer_editorImage skpk/qer/env/miramarg.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.266383 0.274632 0.358662 50 -37 55 3 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/miramarg - -
}

textures/skies_MASTER/hip_miramar-carmine
{
	qer_editorImage skpk/qer/env/miramarp.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 50 -37 55 3 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/miramarp - -
}

textures/skies_MASTER2/matlabcraterlakes
{
	qer_editorImage skpk/qer/env/matlabcrater/mattcraterlakes.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 4 3 2 60 -7 25 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 80 4
	nopicmip
	skyparms skpk/env/matlabcrater/mattcraterlakes - -
}

textures/skies_MASTER6/xnight2_Maxx
{
	qer_editorImage skpk/qer/6/xnight2_Maxx.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 95 4
	nopicmip
	skyParms env/xnight2 512 -
	{
		map skpk/textures/Maxx/trsky1dark.tga
		rgbGen identity
		tcMod scale 5 5
		tcMod scroll 0.03 0
		depthWrite
	}
	{
		map skpk/textures/Maxx/trsky1darker3.tga
		blendfunc add
		rgbGen identity
		tcMod scale 5 5
		tcMod scroll 0.04 0.01
	}
	{
		map skpk/textures/Maxx/trsky1lighter3.tga
		blendfunc add
		rgbGen identity
		tcMod scale 2 2
		tcMod scroll -0.1 -0.1
		depthWrite
	}
}

textures/skies_MASTER6/meat_sky
{
	qer_editorImage skpk/qer/6/meat_sky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 110 4
	nopicmip
	skyparms - 256 -
	{
		map skpk/textures/meat_sky/sky_blue.tga
		tcMod scale 3 3
		tcMod scroll 0.02 0.02
		depthWrite
	}
	{
		map skpk/textures/meat_sky/sky_clouds.tga
		blendFunc GL_ONE GL_ONE
		tcMod scale 4 4
		tcMod scroll 0.03 0.03
	}
}

textures/skies_MASTER6/meat_sky_red
{
	qer_editorImage skpk/qer/6/meat_sky_red.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 110 4
	nopicmip
	skyparms - 256 -
	{
		map skpk/textures/meat_sky/sky_red.tga
		tcMod scale 3 3
		tcMod scroll 0.02 0.02
		depthWrite
	}
	{
		map skpk/textures/meat_sky/sky_clouds.tga
		blendFunc GL_ONE GL_ONE
		tcMod scale 4 4
		tcMod scroll 0.03 0.03
	}
}

//top(ceiling) sky only
textures/skies_MASTER6/meat_sky02
{
	qer_editorImage skpk/qer/6/meat_sky02.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 110 4
	nopicmip
	skyparms - 128 -
	{
		map skpk/textures/meat_sky/sky_brown.tga
		tcMod scroll 0.001 0.002
		tcMod scale 10 10
		depthWrite
	}
	{
		map skpk/textures/meat_sky/sky_clouds.tga
		blendfunc GL_ONE GL_ONE
		tcMod scroll -0.001 -0.002
		tcMod scale 15 15
	}
}

//top(ceiling) sky only
textures/skies_MASTER6/meat_bluesky_02
{
	qer_editorImage skpk/qer/6/meat_bluesky_02.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms - 128 -
	{
		map skpk/textures/meat_sky/sky_blue.tga
		tcMod scroll 0.001 0.002
		tcMod scale 10 10
		depthWrite
	}
	{
		map skpk/textures/meat_sky/sky_clouds.tga
		blendfunc GL_ONE GL_ONE
		tcMod scroll -0.001 -0.002
		tcMod scale 15 15
	}
}

textures/skies_MASTER6/meat_sky_blue03
{
	qer_editorImage skpk/qer/6/meat_sky_blue03.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms - 256 -
	{
		map skpk/textures/meat_sky/sky_blue.tga
		tcMod scroll 0.01 0.02
		tcMod scale 1 1
		depthWrite
	}
	{
		map skpk/textures/meat_sky/sky_clouds.tga
		blendfunc GL_ONE GL_ONE
		tcMod scroll -0.004 -0.006
		tcMod scale 2 2
	}
}

textures/skies_MASTER/hip_miramar-sepia
{
	qer_editorImage skpk/qer/env/meka.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 60 -37 55 3 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/meka - -
}

textures/skies_MASTER2/meth_sky
{
	qer_editorImage skpk/qer/env/methsky/methsky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_sunExt 1 1 1 45 4 27 25 16
	q3map_skylight 80 4
	nopicmip
	skyparms skpk/env/methsky/methsky - -
}

textures/skies_MASTER2/mexicano
{
	qer_editorImage skpk/qer/textures/mexicano/stormy.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.8 0.8 0.9 5 215 90 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 80 4
	nopicmip
	skyParms skpk/textures/mexicano/stormy - -
}

textures/skies_MASTER6/orangesky
{
	qer_editorImage skpk/qer/6/orangesky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.8 0.8 0.9 0 0 90 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 105 4
	nopicmip
	skyparms - 2048 -
	{
		map skpk/textures/mics_tec/orange2.tga
		tcMod scroll 0 0.004
	}
	{
		map skpk/textures/mics_tec/wolken_or.tga
		blendFunc gl_one gl_one
		tcmod scale 1.2 1.2
		tcmod scroll 0.04 0
	}
	{
		map skpk/textures/mics_tec/wolken_or.tga
		blendFunc gl_one gl_one
		tcmod scale 1 1
		tcmod scroll 0.02 0
	}
}

textures/skies_MASTER6/miniman_sky
{
	qer_editorImage skpk/qer/6/miniman_sky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 100 4
	nopicmip
	skyparms - 256 -
	{
		map skpk/textures/miniman/sky1.tga
		tcMod scale 3 3
		tcMod scroll 0.02 0.02
		depthWrite
	}
	{
		map skpk/textures/post/gazeboTex099.tga
		blendFunc GL_ONE GL_ONE
		tcMod scale 4 4
		tcMod scroll 0.03 0.03
	}
}

textures/skies_MASTER2/miniman_ths_env65
{
	qer_editorImage skpk/qer/env/ths.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt .1 .1 .1 35 126 .5 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 80 4
	nopicmip
	skyparms skpk/env/ths - -
}

textures/skies_MASTER2/miniman_ths_env65_2
{
	qer_editorimage skpk/qer/env/ths/ths.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 255 250 240 35 126 .5 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 80 4
	nopicmip
	skyparms skpk/env/ths/ths - -
}

textures/skies_MASTER/hip_miramar-sepia2
{
	qer_editorImage skpk/qer/env/miramarc.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 60 -37 55 3 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/miramarc - -
}

textures/skies_MASTER6/mitch_dm1_sky
{
	qer_editorImage skpk/qer/6/mitch_dm1_sky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 110 4
	nopicmip
	skyparms - 512 -
	{
		map textures/skies/bluedimclouds.tga
		tcMod scale 3 2
		tcMod scroll 0.15 0.15
		depthWrite
	}
	{
		map textures/skies/killsky_2.tga
		blendFunc GL_ONE GL_ONE
		tcMod scale 3 3
		tcMod scroll 0.05 0.05
	}
}

textures/skies_MASTER6/mc-sm14-mjed
{
	qer_editorImage skpk/qer/6/mc-sm14-mjed.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms - 512 -
	{
		map skpk/textures/mc-sm14-mjed/clouds1.tga
		tcMod scale 3 2
		tcMod scroll 0.15 0.15
		depthWrite
	}
	{
		map skpk/textures/mc-sm14-mjed/clouds2.tga
		blendFunc GL_ONE GL_ONE
		tcMod scale 3 3
		tcMod scroll 0.05 0.05
	}
}

textures/skies_MASTER6/mkvdvsky
{
	qer_editorImage skpk/qer/6/mkvdvsky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 95 4
	nopicmip
	skyparms skpk/env/mkvdvsky - -
	{
		map skpk/textures/mkvdv/mkvdvsky_clouds.tga
		blendfunc GL_ONE GL_ONE
		tcMod scroll 0.02 0.02
		tcMod scale 2 2
	}
	{
		map skpk/textures/mkvdv/mkvdvsky_clouds.tga
		blendfunc GL_ONE GL_ONE
		tcMod scroll 0.01 0.01
		tcMod scale 1.5 1.5
	}
}

textures/skies_MASTER2/SKYkarstcity
{
	qer_editorImage skpk/qer/textures/momodora/SKYkarstcity.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.958511 0.501671 0.453635 10 139 45 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 95 4
	nopicmip
	skyParms skpk/textures/momodora/SKYkarstcity - -
}

textures/skies_MASTER6/moonstone
{
	qer_editorImage skpk/qer/6/moonstone.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 30 -35 30 5 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/moonstone/sky 1337 -
	{
		map skpk/textures/moonstone/sky_clouds.tga
		tcMod scroll 0.0025 -0.0075
		rgbGen identityLighting
	}
	{
		map skpk/textures/moonstone/sky_mask.tga
		blendFunc GL_ONE_MINUS_SRC_ALPHA GL_SRC_ALPHA
		tcMod transform 0.25 0 0 0.25 0.1075 0.1075
		rgbGen identityLighting
	}
}

textures/skies_MASTER6/0color_blue-carolina
{
	qer_editorImage skpk/qer/env/moonstone/sky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyparms skpk/env/moonstone/sky 1337 -
}

textures/skies_MASTER2/moses-dm7_env
{
	qer_editorImage skpk/qer/textures/moses-dm7_env/e8-stars.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 110 4
	nopicmip
	skyparms skpk/textures/moses-dm7_env/e8-stars - -
}

textures/skies_MASTER6/mrcq3dm5sky1
{
	qer_editorImage skpk/qer/6/mrcq3dm5sky1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms - 512 -
	{
		map skpk/textures/mrcq3dm5/mrcq3dm5sky1.tga
		tcMod scale 1.75 1.75
		tcMod scroll -0.008 -0.006
		depthWrite
	}
	{
		map skpk/textures/mrcq3dm5/mrcq3dm5sky2.tga
		blendfunc GL_ONE GL_ONE
		tcMod scroll -0.016 -0.018
	}
}

textures/skies_MASTER6/mrcq3t3sky
{
	qer_editorImage skpk/qer/6/mrcq3t3sky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms - 512 -
	{
		map skpk/textures/mrcq3t3/mrcredsky.tga
		tcMod scale 2 2
		tcMod scroll -0.005 0.005
		depthWrite
	}
	{
		map skpk/textures/mrcq3t3/mrccloud.tga
		blendfunc gl_dst_color gl_one_minus_src_alpha
		tcMod scale 2 2
		tcMod scroll -0.03 -0.01
		rgbgen identity
	}
}

textures/skies_MASTER6/mrcq3t6
{
	qer_editorImage skpk/qer/6/mrcq3t6.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms - 512 -
	{
		map textures/skies/intelredclouds.tga
		tcMod scroll 0.01 0.01
		tcMod scale 2 2
		depthWrite
	}
	{
		map textures/skies/inteldimclouds.tga
		blendfunc GL_ONE GL_ONE
		tcMod scroll 0.015 0.013
		tcMod scale 1.7 1.4
	}
}

textures/skies_MASTER6/mutt_redsky
{
	qer_editorImage skpk/qer/6/mutt_redsky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyParms - 512 -
	{
		map skpk/textures/muttdm/redcloudzup.tga
		rgbGen identity
		tcMod scale 2 3
		tcMod scroll 0.02 0.01
		depthWrite
	}
	{
		map skpk/textures/muttdm/redcloudzdn.tga
		blendfunc add
		rgbGen identity
		tcMod scale 3 4
		tcMod scroll 0.01 0.02
	}
}

textures/skies_MASTER6/mutt_redsky_stars-clouds
{
	qer_editorImage skpk/qer/6/mutt_redsky_stars-clouds.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyParms skpk/env/muttstars 512 -
	{
		map skpk/textures/muttdm/redcloudzup.tga
		blendfunc add
		rgbGen identity
		tcMod scale 2 3
		tcMod scroll 0.02 0.01
		depthWrite
	}
	{
		map skpk/textures/muttdm/redcloudzdn.tga
		blendfunc add
		rgbGen identity
		tcMod scale 3 4
		tcMod scroll 0.01 0.02
	}
}

textures/skies_MASTER6/mvdm_pureugly-a
{
	qer_editorImage skpk/qer/6/mvdm_pureugly-a.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 105 4
	nopicmip
	skyParms - 512 -
	{
		map skpk/textures/mvdm_pureugly/pu_skya.tga
		tcMod scale 3 2
		tcMod scroll 0.15 0.15
	}
	{
		map skpk/textures/mvdm_pureugly/pu_skyb.tga
		blendfunc add
		tcMod scale 3 3
		tcMod scroll 0.05 0.05
	}
}

textures/skies_MASTER6/mvdm_pureugly-b
{
	qer_editorImage skpk/qer/6/mvdm_pureugly-b.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 105 4
	nopicmip
	skyParms - 512 -
	{
		map skpk/textures/mvdm_pureugly/pu_skyb.tga
		tcMod scale 3 2
		tcMod scroll 0.15 0.15
	}
	{
		map skpk/textures/mvdm_pureugly/pu_skya.tga
		blendfunc add
		tcMod scale 3 3
		tcMod scroll 0.05 0.05
	}
}

textures/skies_MASTER6/xnight2-topclouds3
{
	qer_editorImage skpk/qer/6/xnight2-topclouds3.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 20 -43 60 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 60 4
	nopicmip
	skyparms env/xnight2 - -
	{
		map textures/skies/topclouds.tga
		blendfunc GL_ONE GL_ONE
		tcMod scroll 0.05 0.06
		tcMod scale 3 2
	}
}

textures/skies_MASTER/mp_perdicus-orange
{
	qer_editorImage skpk/qer/env/Mw514/Mw514.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt .924 .948 1 60 2 62 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 90 4
	nopicmip
	skyparms skpk/env/Mw514/Mw514 - -
}

textures/skies_MASTER6/mwheeler-clouds
{
	qer_editorImage skpk/qer/6/mwheeler-clouds.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_sunExt 1 1 1 20 66 23 12 16
	q3map_skylight 60 4
	nopicmip
	skyparms skpk/env/mwheeler 512 -
	{
		map skpk/textures/dm1/stars.tga
		blendfunc add
		tcMod scale 2 2
	}
	{
		map skpk/textures/mwheeler/cloudz.tga
		blendfunc blend
		tcMod scroll 0.05 0.06
		tcMod scale 3 2
	}
}

textures/skies_MASTER6/chaoscity
{
	qer_editorImage skpk/qer/6/chaoscity.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0 0.977264 1 25 66 32 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 65 4
	nopicmip
	skyparms skpk/env/chaoscity/chaoscity - -
	{
		map textures/skies/topclouds.tga
		blendfunc GL_ONE GL_ONE
		tcMod scroll 0.15 0.16
		tcMod scale 3 2
	}
}

textures/skies_MASTER2/mxl_noc
{
	qer_editorImage skpk/qer/env/03/mxlnoc.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 160 4
	nopicmip
	skyparms skpk/env/03/mxlnoc - -
}

textures/skies_MASTER2/natetrny1
{
	qer_editorImage skpk/qer/env/natetrny1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 253 246 185 85 -28 64 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 70 4
	nopicmip
	skyparms skpk/env/natetrny1 - -
}

textures/skies_MASTER2/nem06
{
	qer_editorImage skpk/qer/env/nem06/nem06.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 80 -45 26 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 65 4
	nopicmip
	skyparms skpk/env/nem06/nem06 - -
}

textures/skies_MASTER/jhnebula1
{
	qer_editorImage skpk/qer/env/jhnebula1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 100 4 -90 90 1
	nopicmip
	skyparms skpk/env/jhnebula1 - -
}

textures/skies_MASTER6/pul1duelsky
{
	qer_editorImage skpk/qer/6/pul1duelsky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 100 4
	nopicmip
	skyParms - 512 -
	{
		map skpk/textures/pulchr/pul1duelsky-a.tga
		tcMod scroll 0.045 0.055
		tcMod scale 3 2
		depthWrite
	}
	{
		map skpk/textures/pulchr/pul1duelsky-b.tga
		blendfunc add
		tcMod scroll 0.02 0.02
		tcMod scale 3 3
	}
}

textures/skies_MASTER6/shodnebula1
{
	qer_editorImage skpk/qer/6/shodnebula1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.882353 0.666667 0.45098 20 -174 21 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 80 4
	nopicmip
	skyParms skpk/env/shodnebula1 1280 -
	{
		map textures/skies/bluedimclouds.tga
		rgbGen wave sin 0.9 0 0 1
		blendfunc add
		tcMod scale 3 3
		tcMod scroll 0.02 0.02
	}
	{
		map textures/skies/dimclouds.tga
		rgbGen wave sin 0.5 0 0 1
		blendfunc add
		tcMod scale 4 4
		tcMod scroll 0.04 0.04
	}
}

textures/skies_MASTER6/newedge
{
	qer_editorImage skpk/qer/6/newedge.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyParms - 1280 -
	{
		map textures/skies/inteldimclouds.tga
		rgbGen identity
		tcMod scale 4 4
		tcMod scroll 0.05 0.05
		depthWrite
	}
	{
		map textures/skies/dimclouds.tga
		blendfunc add
		rgbGen identity
		tcMod scale 4 4
		tcMod scroll 0.03 0.03
	}
}

textures/skies_MASTER/nebula3-clouds
{
	qer_editorImage skpk/qer/env/nebula3/nebula3-clouds.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.882353 0.666667 0.45098 416 60 83 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 60 4
	nopicmip
	skyParms skpk/env/nebula3/nebula3 1280 -
	{
		map textures/skies/bluedimclouds.tga
		rgbGen wave sin 0.9 0 0 1
		blendfunc add
		tcMod scale 3 3
		tcMod scroll 0.02 0.02
	}
	{
		map textures/skies/dimclouds.tga
		rgbGen wave sin 0.5 0 0 1
		blendfunc add
		tcMod scale 4 4
		tcMod scroll 0.04 0.04
	}
}

textures/skies_MASTER2/nightctg_sky
{
	qer_editorImage skpk/qer/env/nightq/night.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 25 -73 18 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 80 4
	nopicmip
	skyparms skpk/env/nightq/night - -
}

textures/skies_MASTER6/nihil_dm
{
	qer_editorImage skpk/qer/6/nihil_dm.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms - 512 -
	{
		map skpk/textures/nihil_dm/ndminteldimclouds.tga
		tcMod scale 3 2
		tcMod scroll 0.02 0.01
		depthWrite
	}
	{
		map skpk/textures/nihil_dm/ndmintelredclouds.tga
		blendFunc GL_ONE GL_ONE
		tcMod scale 3 3
		tcMod scroll 0.06 0.05
	}
}

textures/skies_MASTER2/nkstrdm4
{
	qer_editorImage skpk/qer/textures/nkstrdm4/nkstr_sbox1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 .95 .9 80 -29 50 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 60 4
	nopicmip
	skyparms skpk/textures/nkstrdm4/nkstr_sbox1 - -
}

textures/skies_MASTER6/nkstr_bluishsky
{
	qer_editorImage skpk/qer/6/nkstr_bluishsky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms - 512 -
	{
		map textures/skies/pjbasesky.tga
		tcmod scroll 0.04 0.03
		tcmod scale 2 2
	}
	{
		map textures/skies/dimclouds.tga
		blendfunc filter
		tcmod scroll 0.01 -0.02
		tcmod scale 2 2
	}
}

textures/skies_MASTER6/nkstr_purpishsky
{
	qer_editorImage skpk/qer/6/nkstr_purpishsky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms - 512 -
	{
		map textures/skies/pjbasesky.tga
		tcmod scroll 0.04 0.03
		tcmod scale 2 2
	}
	{
		map textures/skies/killsky_1.tga
		blendfunc add
		tcmod scroll 0.01 -0.02
		tcmod scale 2 2
	}
	{
		map textures/skies/intelredclouds.tga
		blendfunc filter
		tcmod scroll -0.03 0.01
		tcmod scale 2 2
	}
}

textures/skies_MASTER6/nkstr_blueclouds
{
	qer_editorImage skpk/qer/6/nkstr_blueclouds.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms - 512 -
	{
		map skpk/textures/nkstrdm8/nkstr_blueclouds1.tga
		tcmod scroll 0.03 0.02
		tcmod scale 2 2
	}
	{
		map skpk/textures/nkstrdm8/nkstr_blueclouds2.tga
		blendfunc filter
		tcmod scroll 0.01 -0.02
		tcmod scale 2 2
	}
}

textures/skies_MASTER2/nook3dm2
{
	qer_editorImage skpk/qer/env/unit9nook.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.682353 0.74902 0.792157 15 -105 17 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 100 4
	nopicmip
	skyParms skpk/env/unit9nook - -
}

textures/skies_MASTER2/noruen_penumbra
{
	qer_editorImage skpk/qer/env/noruen/PuSky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.945098 0.698039 0.384314 150 75 15 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 100 4
	nopicmip
	skyparms skpk/env/noruen/PuSky - -
}

textures/skies_MASTER2/ut_city_sky
{
	qer_editorImage skpk/qer/env/woebane/city1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 105 4
	nopicmip
	skyparms skpk/env/woebane/city1 - -
}

textures/skies_MASTER2/killer
{
	qer_editorImage skpk/qer/env/killer.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_sunExt 163 68 70 85 90 0 22 16
	q3map_skylight 50 4 -90 90 1
	nopicmip
	skyparms skpk/env/killer - -
}

textures/skies_MASTER2/obliv_skybox
{
	qer_editorImage skpk/qer/env/cliffedge/cliffedge.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 72 167 10 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 60 4
	nopicmip
	skyparms skpk/env/cliffedge/cliffedge - -
}

textures/skies_MASTER2/ogcastle
{
	qer_editorImage skpk/qer/env/ogcastle/ogcastle.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 75 150 25 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 65 4
	nopicmip
	skyparms skpk/env/ogcastle/ogcastle - -
}

textures/skies_MASTER2/olt
{
	qer_editorImage skpk/qer/textures/olt/nightsky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_sunExt 1 1 1 55 104 43 11 16
	q3map_skyLight 65 4
	nopicmip
	skyparms skpk/textures/olt/nightsky - -
}

textures/skies_MASTER2/orbplat_space1
{
	qer_editorImage skpk/qer/env/orbplat/spscene.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.65 0.8 0.9 80 0 25 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 65 4
	nopicmip
	skyparms skpk/env/orbplat/spscene - -
}

textures/skies_MASTER6/ospdm8
{
	qer_editorImage skpk/qer/6/ospdm8.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 105 4
	nopicmip
	skyparms - 512 -
	{
		map skpk/textures/ospdm8/sky/sky1.tga
		tcMod scale 3 2
		tcMod scroll 0.005 0.005
		depthWrite
	}
	{
		map skpk/textures/ospdm8/sky/sky2.tga
		blendFunc GL_ONE GL_ONE
		tcMod scale 3 3
		tcMod scroll 0.1 0.1
	}
}

textures/skies_MASTER6/meth_clouds
{
	qer_editorImage skpk/qer/6/meth_clouds.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms - 512 -
	{
		map skpk/textures/qskies/meth_clouds.tga
		tcMod scale 3 2
		tcMod scroll 0.04 0.04
		depthWrite
	}
	{
		map skpk/textures/qskies/meth_clouds2.tga
		blendfunc GL_ONE GL_ONE
		tcMod scale 10 10
		tcMod scroll .1 .1
	}
	{
		map textures/skies/topclouds.tga
		blendFunc GL_ONE GL_ONE
		tcMod scale 3 3
		tcMod scroll 0.09 0.09
	}
}

textures/skies_MASTER6/meth_clouds_blue
{
	qer_editorImage skpk/qer/6/meth_clouds_blue.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 100 4
	nopicmip
	skyparms - 512 -
	{
		map skpk/textures/skies/meth_clouds_blue.tga
		tcMod scale 2 2
		tcMod scroll 0.01 0.01
		depthWrite
	}
	{
		map skpk/textures/skies/meth_clouds_blue2.tga
		blendfunc add
		tcMod scale 3 3
		tcMod scroll 0.02 0.02
	}
}

textures/skies_MASTER/nebula3qz
{
	qer_editorImage skpk/qer/textures/skies/env/qznebula3.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 110 4
	nopicmip
	skyparms skpk/textures/skies/env/qznebula3 - -
}

textures/skies_MASTER6/phantgothic
{
	qer_editorImage skpk/qer/6/phantgothic.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 108 4
	nopicmip
	skyparms - 512 -
	{
		map skpk/textures/phantgothic/phantgothic_sky_001.tga
		tcMod scale 8 8
		tcMod scroll .02 .05
		depthWrite
	}
	{
		map skpk/textures/phantgothic/phantgothic_sky_001.tga
		blendFunc GL_ONE GL_ONE
		tcMod scale 4 4
		tcMod scroll 0.03 0.05
	}
}

textures/skies_MASTER2/urban-chaos
{
	qer_editorImage skpk/qer/env/urban-chaos512.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.266383 0.274632 0.358662 90 -66 29 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 75 4
	nopicmip
	skyparms skpk/env/urban-chaos512 - -
}

textures/skies_MASTER2/fort-pad
{
	qer_editorImage skpk/qer/env/fort-pad512.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.266383 0.274632 0.358662 85 172 61 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 80 4
	nopicmip
	skyparms skpk/env/fort-pad512 - -
}

textures/skies_MASTER2/padboxctf
{
	qer_editorImage skpk/qer/env/padboxctf.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 105 4
	nopicmip
	skyparms skpk/env/padboxctf - -
}

textures/skies_MASTER2/paint2sky
{
	qer_editorImage skpk/qer/env/paint2sky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 33 -150 25 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 66 4
	nopicmip
	skyparms skpk/env/paint2sky 256 -
}

textures/skies_MASTER2/paint2sky_clouds
{
	qer_editorImage skpk/qer/env/paint2sky_clouds.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 33 -150 25 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 66 4
	nopicmip
	skyparms skpk/env/paint2sky 256 -
	{
		map skpk/textures/paintsky/paint2mist.tga
		blendFunc add
		tcMod scroll .002 .001
		tcMod scale 1 1
		tcMod turb .1 .1 .1 .1
	}
}

textures/skies_MASTER2/paprik1
{
	qer_editorImage skpk/qer/env/paprik1/paprik1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 .82 .0733 70 0 70 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 80 4
	nopicmip
	skyparms skpk/env/paprik1/paprik1 - -
}

textures/skies_MASTER6/mine_sky
{
	qer_editorImage skpk/qer/6/mine_sky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 105 4
	nopicmip
	skyParms - 1024 -
	{
		map skpk/textures/skies/nightsky.tga
		tcMod scroll 0.1 0.1
		tcMod scale 3 2
		depthWrite
	}
	{
		map skpk/textures/skies/nightsky_nocloud.tga
		blendfunc add
		tcMod scroll 0.05 0.05
		tcMod scale 3 3
	}
}

textures/skies_MASTER6/pdmq3duel5-orangesky
{
	qer_editorImage skpk/qer/6/pdmq3duel5-orangesky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 105 4
	nopicmip
	skyparms - 200 -
	{
		map textures/skies/inteldimclouds.tga
		tcMod scale 3 2
		tcMod scroll 0.15 0.15
		depthWrite
	}
	{
		map textures/skies/killsky_2.tga
		blendFunc GL_ONE GL_ONE
		tcMod scale 3 3
		tcMod scroll 0.05 0.05
	}
}

textures/skies_MASTER6/pdm_cloudsky
{
	qer_editorImage skpk/qer/6/pdm_cloudsky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 115 4
	nopicmip
	skyparms - 2048 -
	{
		map skpk/textures/skies/pdm_clearsky.tga
		tcMod scale 8 8
		depthWrite
	}
	{
		map skpk/textures/skies/pdm_clouds.tga
		blendfunc add
		tcMod scroll 0.01 0.01
		tcMod scale 3 2
	}
}

textures/skies_MASTER2/perramses_skybox
{
	qer_editorImage skpk/qer/env/perramses/perramses.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt .5 .37 .19 70 -31 3 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 80 4
	nopicmip
	skyparms skpk/env/perramses/perramses - -
}

textures/skies_MASTER6/phantq3dm3-tp_clouds
{
	qer_editorImage skpk/qer/6/phantq3dm3-tp_clouds.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 110 4
	nopicmip
	skyparms - 512 -
	{
		map skpk/textures/phantq3dm3/tp_clouds_001.tga
		tcMod scale 2 2
		depthWrite
	}
}

textures/skies_MASTER2/solarium_sky
{
	qer_editorImage skpk/qer/env/phantq3dm5/solarium.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 80 87 70 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 65 4
	nopicmip
	skyparms skpk/env/phantq3dm5/solarium - -
}

textures/skies_MASTER6/pjw_sky1
{
	qer_editorImage skpk/qer/6/pjw_sky1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyParms - 200 -
	{
		map skpk/textures/pjw3dm1/pjw_sky1_fog.tga
		rgbGen identity
		tcMod scroll 0.03 0.05
		tcMod scale 2 2
		depthWrite
	}
	{
		map skpk/textures/pjw3dm1/pjw_sky1_detail.tga
		blendfunc add
		rgbGen identity
		tcMod scroll 0.0025 0.003
		tcMod scale 3 2
	}
}

textures/skies_MASTER6/shaderlab_blackClouds
{
	qer_editorImage skpk/qer/6/shaderlab_blackClouds.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 55 -124 24 3 16
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 35 4 0 90 0
	nopicmip
	skyparms skpk/textures/shaderlab_skies/black 480 -
	{
		map skpk/textures/shaderlab_skies/clouds_2.tga
		tcMod scale 3 3
		tcMod scroll 0.01 0.0175
		rgbGen identityLighting
	}
	{
		clampMap skpk/textures/pjw3dm6/toxic.tga
		blendFunc GL_ONE_MINUS_SRC_ALPHA GL_SRC_COLOR
		tcMod transform 0.75 0 0 0.75 -0.678 -0.678
		tcMod stretch sin 1 0.1 0 .04
		rgbGen identityLighting
	}
}

textures/skies_MASTER6/0color_pinkLight_clouds
{
	qer_editorImage skpk/qer/6/0color_pinkLight_clouds.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 145 4
	nopicmip
	skyparms skpk/textures/pjw3quickie5/hipshot_pjw20 2000 -
	{
		map skpk/textures/pjw3quickie5/hipshot_clouds.tga
		tcMod scroll 0.0115 -0.0155
		tcmod scale 2 2
		blendFunc Add
		rgbGen identityLighting
	}
	{
		map skpk/textures/pjw3quickie5/ydnar_mask.tga
		blendFunc GL_ONE_MINUS_SRC_ALPHA GL_SRC_ALPHA
		tcMod transform 0.25 0 0 0.25 0.1075 0.1075
		rgbGen identityLighting
	}
}

textures/skies_MASTER6/0color_pinkLight
{
	qer_editorImage skpk/qer/textures/pjw3quickie5/hipshot_pjw20.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 150 4
	nopicmip
	skyparms skpk/textures/pjw3quickie5/hipshot_pjw20 - -
}

textures/skies_MASTER6/pjw3tourney3
{
	qer_editorImage skpk/qer/6/pjw3tourney3.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 150 4
	nopicmip
	skyparms - 512 -
	{
		map textures/skies/bluedimclouds.tga
		tcMod scale 3 2
		tcMod scroll 0.05 0.05
	}
	{
		map textures/skies/pjbasesky.tga
		blendFunc GL_ONE GL_ONE
		tcMod scale 3 3
		tcMod scroll 0.03 0.03
	}
}

textures/skies_MASTER2/pkbrave
{
	qer_editorImage skpk/qer/env/pkbrave/v.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.878431 0.658824 1 300 90 60 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 50 4
	nopicmip
	skyParms skpk/env/pkbrave/v - -
}

textures/skies_MASTER2/pl6sky
{
	qer_editorImage skpk/qer/env/pl6berg.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.266383 0.274632 0.358662 100 50 55 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 50 4
	nopicmip
	skyparms skpk/env/pl6berg - -
}

textures/skies_MASTER6/pluspack_toxicsky
{
	qer_editorImage skpk/qer/6/pluspack_toxicsky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms - 512 -
	{
		map textures/skies/bluedimclouds.tga
		tcMod scale 3 2
		tcMod scroll 0.05 0.05
		depthWrite
	}
	{
		map textures/skies/killsky_2.tga
		blendFunc GL_ONE GL_ONE
		tcMod scale 3 3
		tcMod scroll 0.025 0.025
	}
}

textures/skies_MASTER6/pohan3dm1
{
	qer_editorImage skpk/qer/6/pohan3dm1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 250 4
	nopicmip
	skyparms - 512 -
	{
		map skpk/textures/pohan3dm1/clouds_000_m.tga
		tcMod scroll 0.01 0.01
		tcMod scale 3 3
		depthWrite
	}
	{
		map skpk/textures/pohan3dm1/clouds_000_m.tga
		blendfunc GL_ONE GL_ONE
		tcMod scroll -0.01 -0.01
		tcMod scale 5 5
	}
}

textures/skies_MASTER6/pohan3dm2
{
	qer_editorImage skpk/qer/6/pohan3dm2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 250 4
	nopicmip
	skyparms - 512 -
	{
		map skpk/textures/pohan3dm2/clouds_000_r.tga
		tcMod scroll 0.01 0.01
		tcMod scale 3 3
		depthWrite
	}
	{
		map skpk/textures/pohan3dm2/clouds_000_r.tga
		blendfunc GL_ONE GL_ONE
		tcMod scroll -0.01 -0.01
		tcMod scale 5 5
	}
}

textures/skies_MASTER6/pohan3dm3
{
	qer_editorImage skpk/qer/6/pohan3dm3.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 250 4
	nopicmip
	skyparms - 512 -
	{
		map textures/skies/bluedimclouds.tga
		tcMod scroll 0.01 0.01
		tcMod scale 3 3
		depthWrite
	}
	{
		map textures/skies/bluedimclouds.tga
		blendfunc GL_ONE GL_ONE
		tcMod scroll 0.02 0.02
		tcMod scale 5 5
	}
}

textures/skies_MASTER6/pohan3dm4
{
	qer_editorImage skpk/qer/6/pohan3dm4.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 250 4
	nopicmip
	skyparms - 512 -
	{
		map skpk/textures/pohan3dm4/clouds.tga
		tcMod scale 5 5
		tcMod scroll -0.03 -0.03
		depthWrite
	}
	{
		map skpk/textures/pohan3dm4/clouds.tga
		blendFunc GL_ONE GL_ONE
		tcMod scale 3 3
		tcMod scroll 0.05 0.05
	}
}

textures/skies_MASTER6/horf_sky
{
	qer_editorImage skpk/qer/6/horf_sky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 95 4
	nopicmip
	skyparms - 256 -
	{
		map skpk/textures/ho/sky1.tga
		tcMod scale 3 3
		tcMod scroll 0.02 0.02
		depthWrite
	}
	{
		map skpk/textures/ho/clouds1.tga
		blendFunc GL_ONE GL_ONE
		tcMod scale 4 4
		tcMod scroll 0.03 0.03
	}
}

textures/skies_MASTER2/oberon
{
	qer_editorImage skpk/qer/env/woebane/oberon.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 140 4
	nopicmip
	skyparms skpk/env/woebane/oberon - -
}

textures/skies_MASTER6/prpl-flow
{
	qer_editorImage skpk/qer/6/prpl-flow.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 95 4
	nopicmip
	skyparms - 512 -
	{
		map skpk/textures/polotex_skies/circle4.tga
		tcMod scroll 0.02 0
		tcMod scale 2 2
		depthWrite
	}
	{
		map skpk/textures/polotex_skies/prpl-flow2.tga
		blendFunc GL_ONE GL_ONE
		tcMod scroll 0.02 0.01
		tcMod scale 2 2
	}
}

textures/skies_MASTER6/pompei_sky_dim
{
	qer_editorImage skpk/qer/6/pompei_sky_dim.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 95 4
	nopicmip
	skyparms - 256 -
	{
		map textures/skies/dimclouds.tga
		tcMod scroll 0.03 0.04
		tcMod scale 2 2
		depthWrite
	}
	{
		map textures/skies/dimclouds.tga
		blendfunc GL_ONE GL_ONE
		tcMod scroll 0.005 0.01
		tcMod scale 3 2
	}
}

textures/skies_MASTER6/shm_sky_1
{
	qer_editorImage skpk/qer/6/shm_sky_1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 95 4
	nopicmip
	skyparms - 512 -
	{
		map skpk/textures/portals/shmitz/shm_sky_grey1.tga
		tcMod scroll 0.05 .1
		tcMod scale 2 2
		depthWrite
	}
	{
		map textures/skies/killsky_2.tga
		blendfunc GL_ONE GL_ONE
		tcMod scroll 0.05 0.06
		tcMod scale 3 2
	}
}

textures/skies_MASTER6/nuclear-noon
{
	qer_editorImage skpk/qer/6/nuclear-noon.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 95 4
	nopicmip
	skyparms - 512 -
	{
		map skpk/textures/post/gazeboTex099.tga
		tcMod scale 3 2
		tcMod scroll 0.025 0.025
		depthWrite
	}
	{
		map skpk/textures/post/gazeboTex100.tga
		blendFunc GL_ONE GL_ONE
		tcMod scale 3 3
		tcMod scroll 0.015 0.015
	}
}

textures/skies_MASTER6/blacksky-clouds
{
	qer_editorImage skpk/qer/6/blacksky-clouds.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_sunExt 1 1 1 20 50 66 18 16
	q3map_skylight 95 4
	nopicmip
	skyparms skpk/env/black - -
	{
		map textures/skies/dimclouds.tga
		blendfunc GL_ONE GL_ONE
		tcMod scroll 0.05 0.06
		tcMod scale 2 1
	}
}

textures/skies_MASTER6/shaderlab_ppd
{
	qer_editorImage skpk/qer/6/shaderlab_ppd.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 88 4 0 90 0
	nopicmip
	skyparms skpk/textures/shaderlab_skies/black 1337 -
	{
		map skpk/textures/ppd/sky.tga
		rgbGen identityLighting
	}
}

textures/skies_MASTER6/ppp
{
	qer_editorImage skpk/qer/6/ppp.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt .75 .58 .42 87 150 25 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 100 4
	nopicmip
	skyparms skpk/env/ppp/ppp 128 -
	{
		map skpk/textures/ppp/nuage.tga
		blendFunc gl_one gl_one
		tcMod scroll 0.03 0.04
	}
	{
		map skpk/textures/ppp/nuage2.tga
		blendFunc gl_one gl_one
		tcMod scroll 0.01 0.02
	}
}

textures/skies_MASTER/sb_graveyard-green
{
	qer_editorImage skpk/qer/env/praetoriansky/praetoriansky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.934 0.956 1 75 0 50 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 65 4
	nopicmip
	skyparms skpk/env/praetoriansky/praetoriansky - -
}

textures/skies_MASTER/kothic_seraphim-clouds
{
	qer_editorImage skpk/qer/env/seraphim/seraphim-clouds.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt .9 0.9 1 80 267 18 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/seraphim/seraphim - -
	{
		map textures/skies/dimclouds.tga
		blendFunc GL_ONE GL_ONE
		tcMod scroll 0.02 0.01
		tcMod scale 3 3
	}
}

textures/skies_MASTER2/pinknoise_skybox
{
	qer_editorImage skpk/qer/env/psidm7/pinknoise.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1.00 0.80 0.90 70 -29 22 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 100 4
	nopicmip
	skyparms skpk/env/psidm7/pinknoise - -
}

textures/skies_MASTER/hip_grimm-clouds6
{
	qer_editorImage skpk/qer/env/hip_grimm/grimmnight-clouds6.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt .9 .95 .85 20 335 25 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/pukka3tourney7 768 -
	{
		map skpk/textures/pukka3tourney7/clouds.tga
		tcMod scale 2 2
		tcMod scroll 0.085 0.035
		rgbGen identity
		depthWrite
		blendFunc GL_ONE GL_ONE
	}
	{
		map skpk/textures/pukka3tourney7/clouds2.tga
		tcMod scale 4 4
		tcMod scroll .025 0.0125
		blendfunc blend
	}
}

textures/skies_MASTER2/qps_moon_sky
{
	qer_editorImage skpk/qer/env/pump/pump.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 110 4
	nopicmip
	skyparms skpk/env/pump/pump - -
}

textures/skies_MASTER6/q1dm4
{
	qer_editorImage skpk/qer/6/q1dm4.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 110 4
	nopicmip
	skyParms - 512 -
	{
		map skpk/textures/q1dm4/sky4.blend.tga
		tcMod scroll -0.004 0.003
		tcMod scale 7 7
	}
	{
		map skpk/textures/q1dm4/sky4.tga
		blendfunc blend
		rgbGen identity
		tcMod scroll 0.008 -0.006
		tcMod scale 6 6
	}
	{
		map skpk/textures/q1dm4/sky4.blend.tga
		blendfunc blend
		tcMod scroll 0 0.009
		tcMod scale 8 8
		alphaGen wave sin 0.5 0.1 0 1
	}
}

textures/skies_MASTER6/dm6sky
{
	qer_editorImage skpk/qer/6/dm6sky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 110 4
	nopicmip
	skyparms - 512 -
	{
		map skpk/textures/dm6/sky.tga
		tcMod scroll 0.05 .1
		tcMod scale 2 2
		depthWrite
	}
	{
		map skpk/textures/dm6/sky.tga
		blendfunc GL_ONE GL_ONE
		tcMod scroll 0.05 0.06
		tcMod scale 3 2
	}
}

textures/skies_MASTER6/q32thecore
{
	qer_editorImage skpk/qer/6/q32thecore.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 100 4
	nopicmip
	skyparms - 512 -
	{
		map skpk/textures/q32thecore_tourney3_fx/q32thecore3_sky_1.tga
		tcMod scroll 0.05 0.06
		tcMod scale 2 2
		depthWrite
	}
	{
		map skpk/textures/q32thecore_tourney3_fx/q32thecore3_sky_2.tga
		blendFunc GL_ONE GL_ONE
		tcMod scroll 0.08 0.09
		tcMod scale 3 2
	}
}

textures/skies_MASTER2/q3ctfp20brush
{
	qer_editorImage skpk/qer/textures/q3ctfp20brush/skybox.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 130 4
	nopicmip
	skyParms skpk/textures/q3ctfp20brush/skybox - -
}

textures/skies_MASTER6/Doom_Xsky01
{
	qer_editorImage skpk/qer/6/Doom_Xsky01.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms - 1024 -
	{
		map textures/skies/bluedimclouds.tga
		tcMod scale 3 2
		tcMod scroll 0.004 0.004
	}
}

textures/skies_MASTER6/q3dmp23_dark
{
	qer_editorImage skpk/qer/6/q3dmp23_dark.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 120 4
	nopicmip
	skyparms - 2000 -
	{
		map skpk/textures/ct3tourney2/env/clouds.tga
		tcMod scroll .03 .005
		tcmod scale 2 2
		rgbGen identityLighting
	}
}

textures/skies_MASTER6/q3ff7sky_skybox
{
	qer_editorImage skpk/qer/6/q3ff7sky_skybox.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 80 -90 4 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 75 4
	nopicmip
	skyparms skpk/env/q3ff7sky/q3ff7sky - -
	{
		map skpk/textures/tom_spec/tomsky_nuages.tga
		blendfunc GL_ONE GL_ONE
		tcMod scroll 0.05 0.06
		tcMod scale 3 2
	}
}

textures/skies_MASTER6/fluffybluesky1
{
	qer_editorImage skpk/qer/6/fluffybluesky1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyParms - 200 -
	{
		map textures/skies/dimclouds.tga
		tcMod scroll 0.005 0.003
		tcMod scale 3 3
		depthWrite
	}
	{
		map skpk/textures/q3f_towers/bluesky1.tga
		blendfunc add
		tcMod scroll 0.001 0.003
		tcMod scale 5 5
	}
}

textures/skies_MASTER6/ikbase_tf2knight
{
	qer_editorImage skpk/qer/6/ikbase_tf2knight.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 90 4
	nopicmip
	skyparms - 512 -
	{
		map skpk/textures/q3f_tf2k/xnight_sky.tga
		tcMod scale 2 2
		tcMod scroll 0.01 0.01
		depthWrite
	}
	{
		map skpk/textures/ikbase_sky/ik_sky_night_back.tga
		blendFunc GL_ONE GL_ONE
		tcMod scale 3 3
		tcMod scroll 0.02 0.02
	}
}

textures/skies_MASTER6/q3hht1grey_sky
{
	qer_editorImage skpk/qer/6/q3hht1grey_sky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms - 512 -
	{
		map textures/skies/dimclouds.tga
		tcMod scroll 0.005 0
		tcMod scale 2 2
		depthWrite
	}
}

textures/skies_MASTER6/clocksky1
{
	qer_editorImage skpk/qer/6/clocksky1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyParms - 512 -
	{
		map textures/skies/intelredclouds.tga
		rgbGen identity
		tcMod scroll 0.01 0.03
		tcMod scale 2 4
		depthWrite
	}
	{
		map skpk/textures/q3mb/polluted.tga
		blendfunc add
		rgbGen identity
		tcMod scroll 0.01 0.05
		tcMod scale 1 2
	}
}

textures/skies_MASTER6/q3shw16_sky
{
	qer_editorImage skpk/qer/6/q3shw16_sky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms - 512 -
	{
		map skpk/textures/q3shw16/inteldimclouds.tga
		tcMod scale 3 2
		tcMod scroll 0.15 0.15
		depthWrite
	}
	{
		map skpk/textures/q3shw16/intelgreenclouds.tga
		blendFunc GL_ONE GL_ONE
		tcMod scale 3 3
		tcMod scroll 0.05 0.05
	}
}

textures/skies_MASTER6/s_yucksky
{
	qer_editorImage skpk/qer/6/s_yucksky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms - 256 -
	{
		map skpk/textures/ssctf6/s_yuck.tga
		tcMod scroll 0.015 0.016
		tcMod scale 3 3
		depthWrite
	}
	{
		map skpk/textures/ssctf6/s_yuck.tga
		blendFunc gl_one gl_one
		tcMod scroll 0.01 0.012
		tcMod scale 5 5
	}
}

textures/skies_MASTER6/xnight2-topclouds2
{
	qer_editorImage skpk/qer/6/xnight2-topclouds2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 20 -43 60 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 60 4
	nopicmip
	skyparms env/xnight2 4096 -
	{
		map textures/skies/topclouds.tga
		blendfunc GL_ONE GL_ONE
		tcMod scroll 0 0.02
		tcMod scale 3.5 1
	}
	{
		map textures/skies/topclouds.tga
		blendfunc GL_ONE GL_ONE
		tcMod scroll 0.005 0.01
		tcMod scale 4 1
	}
}

textures/skies_MASTER6/q3_elkdm2
{
	qer_editorImage skpk/qer/6/q3_elkdm2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms - 512 -
	{
		map textures/skies/dimclouds.tga
		tcMod scroll 0.005 0.005
		tcMod scale 3 3
		depthWrite
	}
	{
		map skpk/textures/q3_elkdm2/blueclouds.tga
		blendfunc GL_ONE GL_ONE
		tcMod scroll -0.005 -0.005
		tcMod scale 5 5
	}
}

textures/skies_MASTER2/qbeast_skybox
{
	qer_editorImage skpk/qer/env/qbeast/qbeast.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms skpk/env/qbeast/qbeast - -
}

textures/skies_MASTER6/0color_gradientPinkGreen
{
	qer_editorImage skpk/qer/env/qdolphine/qdolphine.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms skpk/env/qdolphine/qdolphine - -
}

textures/skies_MASTER6/qdoom_sky2
{
	qer_editorImage skpk/qer/6/qdoom_sky2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyparms - 512 -
	{
		map skpk/textures/qdoom/disaster_fog2.tga
		tcMod scroll 0.005 0.005
		tcMod scale 2 2
	}
	{
		map skpk/textures/qdoom/disaster_sky2.tga
		blendFunc GL_ONE GL_ONE
		tcMod scroll 0.002 0.002
		tcMod scale 1.5 1.5
	}
}

textures/skies_MASTER2/qfraggel3_env
{
	qer_editorImage skpk/qer/env/qfraggel3/qfraggel3.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.32 0.32 0.16 28 240 25 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 75 4
	nopicmip
	skyParms skpk/env/qfraggel3/qfraggel3 - -
}

textures/skies_MASTER6/geom2sky
{
	qer_editorImage skpk/qer/6/geom2sky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms - 512 -
	{
		map skpk/textures/geom2jaj/geom2sky.tga
		tcMod scroll 0.031 .015
		depthWrite
	}
	{
		map textures/skies/dimclouds.tga
		blendfunc GL_ONE GL_ONE
		tcMod scroll 0.015 0.016
		tcMod scale 3 2
	}
}

textures/skies_MASTER6/cardigan_starfieldClouds
{
	qer_editorImage skpk/qer/6/cardigan_starfieldClouds.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyParms skpk/env/cardigan/purewhitej 1200 -
	{
		map skpk/textures/cardigan_skies1/starfield2.tga
		blendfunc add
		rgbGen identity
		tcMod scroll 0.01 0.01
		tcMod scale 2 2
	}
	{
		map skpk/textures/qxdm3/qxdm3_sky.tga
		blendfunc filter
		tcMod scroll 0.02 0.03
	}
}

textures/skies_MASTER6/0color_grey_clouds
{
	qer_editorImage skpk/qer/6/0color_grey_clouds.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms skpk/textures/qxdm4/env/sky 512 -
	{
		map skpk/textures/qxdm4/qxsky_clouds.tga
		tcMod scale 3 3
		tcMod scroll 0.005 -0.0125
		rgbGen identityLighting
	}
	{
		clampmap skpk/textures/qxdm4/qxsky_arc.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		tcMod transform 0.956 0 0 0.956 -1 -1
		rgbGen identityLighting
	}
}

textures/skies_MASTER6/0color_grey_qx
{
	qer_editorImage skpk/qer/textures/qxdm4/env/sky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms skpk/textures/qxdm4/env/sky 512 -
}

textures/skies_MASTER6/ra3combat2_sky
{
	qer_editorImage skpk/qer/6/ra3combat2_sky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 100 4
	nopicmip
	skyparms env/space1 512 -
	{
		map textures/skies/inteldimclouds.tga
		tcMod scale 3 2
		tcMod scroll 0.15 0.15
	}
	{
		map textures/skies/killsky_2.tga
		blendFunc GL_ONE GL_ONE
		tcMod scale 3 3
		tcMod scroll 0.05 0.05
	}
	{
		map textures/sfx/tesla1b.tga
		blendFunc GL_ONE GL_ONE
		rgbgen wave square 0 1 0 2
		tcmod scale 1 1
		tcMod scroll 0.20 -0.20
		tcmod rotate -9
	}
}

textures/skies_MASTER6/ra3combat2_sky2
{
	qer_editorImage skpk/qer/6/ra3combat2_sky2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms - 512 -
	{
		map textures/skies/dimclouds.tga
		tcMod scale 3 3
		tcMod scroll 0.10 0.10
		depthWrite
	}
	{
		map textures/skies/topclouds.tga
		blendfunc Add
		tcMod scale 1.2 0.9
		tcMod scroll .013 .002
	}
}

textures/skies_MASTER6/ra3combat2_sky3
{
	qer_editorImage skpk/qer/6/ra3combat2_sky3.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms - 512 -
	{
		map skpk/textures/ra3combat2/bluesky4.tga
		tcMod scale 3 3
		tcMod scroll 0.11 0.11
		depthWrite
	}
	{
		map skpk/textures/ra3combat2/bluesky1.tga
		blendfunc Add
		tcMod scale 1.2 0.9
		tcMod scroll .013 .002
	}
}

textures/skies_MASTER6/ra3combat2_sky4
{
	qer_editorImage skpk/qer/6/ra3combat2_sky4.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms - 512 -
	{
		map skpk/textures/ra3combat2/bluesky3.tga
		tcMod scale 3 3
		tcMod scroll 0.05 0.05
		depthWrite
	}
	{
		map skpk/textures/ra3combat2/bluesky2.tga
		blendfunc Add
		tcMod scale 1.2 0.9
		tcMod scroll .013 .002
	}
}

textures/skies_MASTER6/ra3combat2_sky5
{
	qer_editorImage skpk/qer/6/ra3combat2_sky5.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms - 512 -
	{
		map textures/skies/intelredclouds.tga
		tcMod scale 3 3
		tcMod scroll 0.10 0.10
		depthWrite
	}
	{
		map textures/skies/intelredclouds.tga
		blendfunc Add
		tcMod scale 1.2 0.9
		tcMod scroll .013 .002
	}
}

textures/skies_MASTER/mudriver-dimclouds
{
	qer_editorImage skpk/qer/env/mudriver/valley-clouds.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt .924 .948 1 35 220 60 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyParms skpk/env/mudriver/valley 2048 -
	{
		map textures/skies/dimclouds.tga
		blendfunc add
		rgbGen identity
		tcMod scale 3 3
		tcMod scroll 0.01 0.01
	}
}

textures/skies_MASTER2/storm_skybox
{
	qer_editorImage skpk/qer/env/storm/storm.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_sunExt 0.501961 1 1 45 123 20 25 16
	q3map_skylight 70 4
	nopicmip
	skyParms skpk/env/storm/storm - -
}

textures/skies_MASTER2/rebond_skybox
{
	qer_editorImage skpk/qer/env/rebond/rebond/rebond.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 15 0 30 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 105 4
	nopicmip
	skyparms skpk/env/rebond/rebond/rebond - -
}

textures/skies_MASTER/jhnebula1-clouds
{
	qer_editorImage skpk/qer/env/jhnebula1-clouds.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 100 4
	nopicmip
	skyparms skpk/env/jhnebula1 - -
	{
		map skpk/textures/ikbase_sky/ik_sky_night_back.tga
		blendfunc GL_ONE GL_ONE
		tcMod scroll 0.015 0.016
		tcMod scale 3 3
	}
	{
		map skpk/textures/ikbase_sky/ik_sky_night_front.tga
		blendFunc GL_ONE GL_ONE
		tcMod scroll -0.01 -0.012
		tcMod scale 5 5
	}
}

textures/skies_MASTER2/rh-vernichtung
{
	qer_editorImage skpk/qer/textures/rh-vernichtung/rhsky2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 45 124 30 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 95 4
	nopicmip
	skyparms skpk/textures/rh-vernichtung/rhsky2 - -
}

textures/skies_MASTER6/rjldom1_sky
{
	qer_editorImage skpk/qer/6/rjldom1_sky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 125 4
	nopicmip
	skyparms - 512 -
	{
		depthWrite
		tcMod scale 3 2
		tcMod scroll 0.15 0.15
		map skpk/textures/r3tina/cloud2_rjldom1.tga
	}
	{
		tcMod scale 3 3
		tcMod scroll 0.05 0.05
		map skpk/textures/r3tina/cloud1_rjldom1.tga
		blendFunc add
	}
}

textures/skies_MASTER2/marssky
{
	qer_editorImage skpk/qer/env/rktourney1/mars.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.6 0.298 0.169 95 -56 60 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 80 4
	nopicmip
	skyParms skpk/env/rktourney1/mars - -
}

textures/skies_MASTER2/rockisle_skybox
{
	qer_editorImage skpk/qer/env/rockisle/rockisle.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 50 125 24 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/rockisle/rockisle - -
}

textures/skies_MASTER6/rocknroland_sky1
{
	qer_editorImage skpk/qer/6/rocknroland_sky1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms - 512 -
	{
		map textures/skies/bluedimclouds.tga
		tcMod scroll 0.015 0.016
		tcMod scale 3 3
		depthWrite
	}
	{
		map textures/skies/topclouds.tga
		blendfunc GL_ONE GL_ONE
		tcMod scroll -0.01 -0.012
		tcMod scale 5 5
	}
}

textures/skies_MASTER3/korb-irem
{
	qer_editorImage skpk/qer/env/irem/irem.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 35 -89 46 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 60 4
	nopicmip
	skyparms skpk/env/irem/irem - -
}

textures/skies_MASTER2/nebe
{
	qer_editorImage skpk/qer/env/dm.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.780392 0.792157 0.839216 70 -119 25 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 75 4
	nopicmip
	skyParms skpk/env/dm - -
}

textures/skies_MASTER6/nebe2
{
	qer_editorImage skpk/qer/6/nebe2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyParms skpk/env/ver 512 -
	{
		map skpk/textures/rota3dm5/nebe_mraky_A.tga
		blendFunc GL_ONE GL_ONE
		tcMod scroll 0.01 0.01
		tcMod scale 3 3
	}
}

textures/skies_MASTER/sb_devilpunch-clouds
{
	qer_editorImage skpk/qer/env/sb_devilpunch/devpun-clouds.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt .6 .6 .6 60 135 70 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/sb_devilpunch/devpun - -
	{
		map skpk/textures/rotten_soul/nubian5.tga
		tcMod scale 4 4
		tcMod scroll 0.05 0.05
		blendFunc GL_ONE GL_ONE
	}
}

textures/skies_MASTER2/ROWDYBEARgoldstaub
{
	qer_editorImage skpk/qer/env/pumatourney4/ROWDYBEARgoldstaub.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.5 0.6 0.8 75 -160 66 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/pumatourney4/ROWDYBEARgoldstaub - -
}

textures/skies_MASTER6/rpg3dm2sky
{
	qer_editorImage skpk/qer/6/rpg3dm2sky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms - 512 -
	{
		map skpk/textures/rpg3dm2/rpgskyback.tga
		tcMod scale 2 2
		tcMod scroll 0.025 0.025
	}
	{
		map skpk/textures/rpg3dm2/rpgskyfront.tga
		blendFunc GL_ONE GL_ONE
		tcMod scale 2 2
		tcMod scroll 0.01 0.01
	}
}

textures/skies_MASTER6/rprtexpack
{
	qer_editorImage skpk/qer/6/rprtexpack.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 175 4
	nopicmip
	skyparms - 512 -
	{
		map skpk/textures/rprtexpack/sky-002.tga
		tcMod scroll 0.2 0.1
		tcMod scale 2 2
		depthWrite
	}
	{
		map skpk/textures/rprtexpack/sky-001.tga
		blendFunc GL_ONE GL_ONE
		tcMod scroll 0.1 0.05
		tcMod scale 1 1
	}
}

textures/skies_MASTER6/rsptn_FFA01_sky
{
	qer_editorImage skpk/qer/6/rsptn_FFA01_sky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms - 256 -
	{
		map textures/skies/dimclouds.tga
		tcMod scroll 0 0.025
		tcMod scale 2 2
		depthWrite
	}
}

textures/skies_MASTER/jf_plague-clouds
{
	qer_editorImage skpk/qer/env/jf_plague/plague-clouds.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 75 4
	nopicmip
	skyparms skpk/env/jf_plague/plague - -
	{
		map textures/skies/intelredclouds.tga
		blendfunc GL_ONE GL_ONE
		tcMod scroll 0.01 0.005
		tcMod scale 3 2
	}
}

textures/skies_MASTER3/avoc_arabian_nights-dark
{
	qer_editorImage skpk/qer/textures/rushers11/rushers11_sky/rushers11_sky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.5 0.35 0.34 40 -96 7 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 85 4
	nopicmip
	skyParms skpk/textures/rushers11/rushers11_sky/rushers11_sky - -
}

textures/skies_MASTER6/devsky
{
	qer_editorImage skpk/qer/6/devsky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 105 4
	nopicmip
	skyParms - 1280 -
	{
		map textures/skies/inteldimclouds.tga
		rgbGen identity
		tcMod scale 4 4
		tcMod scroll 0.05 0.05
		depthWrite
	}
	{
		map textures/skies/dimclouds.tga
		blendfunc add
		rgbGen identity
		tcMod scale 4 4
		tcMod scroll 0.03 0.03
	}
}

textures/skies_MASTER6/sanctum_sky_03
{
	qer_editorImage skpk/qer/6/sanctum_sky_03.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 100 4
	nopicmip
	skyparms - 512 -
	{
		map skpk/textures/sanctum/sanctum_sky_03.tga
		tcMod scale 3 2
		tcMod scroll 0.04 0.04
		depthWrite
	}
	{
		map skpk/textures/sanctum/sanctum_sky_04.tga
		blendfunc GL_ONE GL_ONE
		tcMod scale 10 10
		tcMod scroll .1 .1
	}
	{
		map textures/skies/topclouds.tga
		blendFunc GL_ONE GL_ONE
		tcMod scale 3 3
		tcMod scroll 0.09 0.09
	}
}

textures/skies_MASTER6/scampsky2
{
	qer_editorImage skpk/qer/6/scampsky2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms - 512 -
	{
		map skpk/textures/scampie/scampsky2.tga
		tcMod scale 3 2
		tcMod scroll 0.15 0.15
		depthWrite
	}
	{
		map textures/skies/topclouds.tga
		blendFunc GL_ONE GL_ONE
		tcMod rotate 45
		tcMod scale 3 3
		tcMod scroll 0.05 0.05
	}
}

textures/skies_MASTER6/shadblue_clouds
{
	qer_editorImage skpk/qer/6/shadblue_clouds.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyParms - 1024 -
	{
		map textures/skies/dimclouds.tga
		tcMod scale 1.25 1.25
		tcMod scroll 0.015 0.08
	}
	{
		map skpk/textures/shad3hipoly/shad_blueclouds.tga
		blendfunc add
		tcMod scale 1.5 1.5
		tcMod scroll 0.09 0.08
	}
}

textures/skies_MASTER6/shaderlab_potrero_sunset
{
	qer_editorImage skpk/qer/6/shaderlab_potrero_sunset.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 255 150 80 95 -167 6 5 16
	q3map_LightMapFilterRadius 0 64
	q3map_skyLight 40 4 0 90 0
	nopicmip
	skyparms skpk/textures/shaderlab_skies/black 576 -
	{
		map skpk/textures/shaderlab_skies/clouds_2.tga
		tcMod scale 2.75 1.75
		tcMod scroll 0.01 -0.00375
		rgbGen identityLighting
	}
	{
		clampMap skpk/textures/shaderlab_skies/potrero_sunset_1.tga
		blendFunc GL_SRC_ALPHA GL_SRC_COLOR
		tcMod transform 0.75 0 0 0.75 -0.678 -0.678
		rgbGen identityLighting
	}
}

textures/skies_MASTER6/shaderlab_mars_rising
{
	qer_editorImage skpk/qer/6/shaderlab_mars_rising.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 64
	q3map_skyLight 110 4
	nopicmip
	skyparms skpk/textures/shaderlab_skies/space 512 -
	{
		clampMap skpk/textures/shaderlab_skies/mars.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		tcMod transform 2.25 0 0 2 -3 -3
		rgbGen identityLighting
	}
}

textures/skies_MASTER6/shaderlab_maskedClouds
{
	qer_editorImage skpk/qer/6/shaderlab_maskedClouds.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 90 -35 22 2 16
	q3map_LightMapFilterRadius 0 64
	q3map_lightRGB 0.9 0.96 1.0
	q3map_skyLight 60 4 0 90 0
	nopicmip
	skyParms skpk/textures/shaderlab_skybox/env/sky 1024 -
	{
		map skpk/textures/shaderlab_skybox/sky_clouds.tga
		rgbGen identityLighting
		tcMod scale 3 3
		tcMod scroll 0.005 -0.0125
	}
	{
		map skpk/textures/shaderlab_skybox/sky_arc_masked.tga
		blendfunc gl_one_minus_src_alpha gl_src_alpha
		rgbGen identityLighting
		tcMod transform 0.25 0 0 0.25 0.1075 0.1075
	}
}

textures/skies_MASTER6/shaderlab_sorting_fun
{
	qer_editorImage skpk/qer/6/shaderlab_sorting_fun.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 255 255 255 40 -122 13 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 75 4 0 90 0
	nopicmip
	skyParms skpk/textures/shaderlab_skies/black 576 -
	{
		map skpk/textures/shaderlab_skies/clouds_2.tga
		rgbGen identityLighting
		tcMod scale 2.75 1.75
		tcMod scroll 0.01 -0.00375
	}
	{
		clampmap skpk/textures/shaderlab_sorting_fun/sky.tga
		blendfunc gl_src_alpha gl_src_color
		rgbGen identityLighting
		tcMod transform 0.75 0 0 0.75 -0.678 -0.678
	}
}

textures/skies_MASTER2/lbsky2_shkiper
{
	qer_editorImage skpk/qer/env/lbsky2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	nopicmip
	skyparms skpk/env/lbsky2 - -

	// light values tuned for -gamma 2 -compensate 4
	// 				R		G		B		bright	yaw		pitch	dev	samp
	q3map_sunExt	1.00	0.90	0.80	150.0	17.123	48.822	0	16		// the big yellow one
	q3map_sunExt	0.7451	0.9228	1.0		20.8505	127.32	-86.86	2	16		// underlights
	
	// The Rest of The Blue Stuff //
	// East 	(BOCTOK = 0) 					// 	315 <-360/0-> 45
	q3map_sunExt	0.5283	0.7968	1.0		7.0345	332.96	27.179	2	16
	q3map_sunExt	0.8126	0.9329	1.0		6.0419	336.79	7.3258	2	16
	q3map_sunExt	0.6714	0.8729	1.0		9.9313	353.79	18.759	2	16
	q3map_sunExt	0.4945	0.7755	1.0		9.5803	37.399	35.329	2	16
	q3map_sunExt	0.7695	0.9092	1.0		4.2623	43.610	0.3438	2	16
	q3map_sunExt	0.6259	0.8739	1.0		9.9599	13.894	28.792	2	16
	q3map_sunExt	0.8563	0.9499	1.0		1.4454	334.58	-32.80	2	16
	q3map_sunExt	0.8011	0.9237	1.0		3.5108	12.751	-11.37	2	16
	q3map_sunExt	0.7232	0.8937	1.0		0.7624	24.233	-50.62	2	16

	// Nord 	(CEBEP = 90) 					// 	45  <-90-> 135
	q3map_sunExt	0.4744	0.7463	1.0		5.6085	73.250	19.172	2	16
	q3map_sunExt	0.4573	0.7575	1.0		5.9619	62.266	36.831	2	16
	q3map_sunExt	0.6873	0.8762	1.0		4.2276	105.49	2.9141	2	16
	q3map_sunExt	0.3919	0.6978	1.0		2.8316	103.99	38.348	2	16
	q3map_sunExt	0.6645	0.8419	1.0		5.1380	129.71	38.400	2	16
	q3map_sunExt	0.7125	0.8651	1.0		6.5596	115.43	57.076	2	16
	q3map_sunExt	0.8519	0.9610	1.0		1.3755	66.249	-33.98	2	16
	q3map_sunExt	0.8685	0.9591	1.0		1.4714	86.920	-46.64	2	16
	
	// West 	(3AnAD = 180) 					// 	135 <-180-> 225
	q3map_sunExt	0.7481	0.8897	1.0		5.5626	154.58	32.801	2	16
	q3map_sunExt	0.6039	0.8304	1.0		2.1635	142.92	3.0233	2	16
	q3map_sunExt	0.3855	0.7023	1.0		2.6832	197.25	31.121	2	16
	q3map_sunExt	0.7076	0.8732	1.0		2.6345	174.66	2.1282	2	16
	q3map_sunExt	0.2762	0.6545	1.0		1.4207	221.83	35.078	2	16
	q3map_sunExt	0.7008	0.8735	1.0		2.6714	206.35	0.5979	2	16
	q3map_sunExt	0.8587	0.9561	1.0		1.6206	147.40	-46.88	2	16
	q3map_sunExt	0.8380	0.9489	1.0		1.4543	172.72	-38.83	2	16
	q3map_sunExt	0.7347	0.9285	1.0		0.7111	217.39	-35.32	2	16

	// South 	(IOr = 270) 					// 	225 <-270-> 315
	q3map_sunExt	0.3007	0.6602	1.0		2.1553	246.24	33.984	2	16
	q3map_sunExt	0.5941	0.8030	1.0		4.6915	285.70	32.546	2	16
	q3map_sunExt	0.5850	0.8002	1.0		4.9306	297.09	50.914	2	16
	q3map_sunExt	0.7972	0.9108	1.0		5.1333	254.81	15.417	2	16
	q3map_sunExt	0.7443	0.8936	1.0		1.8799	243.68	-1.394	2	16
	q3map_sunExt	0.7474	0.8959	1.0		2.3860	264.57	-2.306	2	16
	q3map_sunExt	0.7284	0.8994	1.0		0.9087	242.26	-36.83	2	16
	q3map_sunExt	0.6744	0.8647	1.0		0.7637	274.59	-19.96	2	16
	q3map_sunExt	0.7980	0.9438	1.0		1.1175	309.71	-38.40	2	16
}

textures/skies_MASTER6/ctf6sky
{
	qer_editorImage skpk/qer/6/ctf6sky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms - 512 -
	{
		map skpk/textures/skies2/ctf6sky2.tga
		tcMod scale 3 3
		tcMod scroll 0.01 0.01
		depthWrite
	}
	{
		map skpk/textures/skies2/ctf6sky.tga
		blendfunc Add
		tcMod scale 1.2 0.9
		tcMod scroll .013 .002
	}
}

textures/skies_MASTER6/ctf6sky_ter
{
	qer_editorImage skpk/qer/6/ctf6sky_ter.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms - 512 -
	{
		map skpk/textures/skies2/ctf6sky2.tga
		tcMod scale 3 3
		tcMod scroll 0.05 0.05
		depthWrite
	}
	{
		map skpk/textures/skies2/ctf6skyb.tga
		blendfunc Add
		tcMod scale 1.2 0.9
		tcMod scroll .013 .002
	}
}

textures/skies_MASTER2/nebula2
{
	qer_editorImage skpk/qer/textures/skies2/env/nebula2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt .75 .37 .19 75 67 56 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 85 4
	nopicmip
	skyparms skpk/textures/skies2/env/nebula2 - -
}

textures/skies_MASTER2/nebula
{
	qer_editorImage skpk/qer/textures/skies2/env/nebula.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms skpk/textures/skies2/env/nebula - -
}

textures/skies_MASTER2/desert
{
	qer_editorImage skpk/qer/textures/env/desert.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.75 0.75 0.75 75 60 10 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 65 4
	nopicmip
	skyparms skpk/textures/env/desert - -
}

textures/skies_MASTER6/xnight2-intelredclouds
{
	qer_editorImage skpk/qer/6/xnight2-intelredclouds.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 20 -43 60 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 60 4
	nopicmip
	skyparms env/xnight2 512 -
	{
		map textures/skies/intelredclouds.tga
		blendFunc GL_ONE GL_ONE
		tcMod scroll 0.05 0.05
		tcMod scale 3 3
	}
}

textures/skies_MASTER6/sockter_skybox
{
	qer_editorImage skpk/qer/6/sockter_skybox.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 .96 .87 100 325 80 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 150 4
	nopicmip
	skyparms skpk/env/mono/148-142-128 512 -
	{
		map skpk/textures/sockter/sky_clouds.tga
		tcMod scale 2.5 2.5
		tcMod scroll 0.0075 -0.0015
		rgbGen identityLighting
	}
	{
		map skpk/textures/sockter/sky_mask.tga
		blendFunc GL_ONE_MINUS_SRC_ALPHA GL_SRC_ALPHA
		tcMod transform 0.25 0 0 0.25 0.1075 0.1075
		rgbGen identityLighting
	}
}

textures/skies_MASTER6/0color_grey3
{
	qer_editorImage skpk/qer/textures/kamchatka/fog_hull/kam.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 125 4
	nopicmip
	skyparms skpk/textures/kamchatka/fog_hull/kam - -
}

textures/skies_MASTER6/spirit3_nightsky
{
	qer_editorImage skpk/qer/6/spirit3_nightsky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 115 4
	nopicmip
	skyParms env/space1 128 -
	{
		map skpk/textures/spirit3t3_sky/lun_stars.tga
		tcMod scale 30 30
		depthWrite
	}
	{
		map skpk/textures/ikbase_sky/ik_sky_night_front.tga
		blendfunc add
		tcMod scale 3 2
		tcMod scroll 0.1 0.1
	}
	{
		map skpk/textures/ikbase_sky/ik_sky_night_back.tga
		blendfunc add
		tcMod scale 3 3
		tcMod scroll 0.05 0.05
	}
}

textures/skies_MASTER6/splatctf1_nightsky
{
	qer_editorImage skpk/qer/6/splatctf1_nightsky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.4752 0.5785 1 30 48 56 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 100 4
	nopicmip
	skyParms skpk/env/nightsky 512 -
	{
		map skpk/textures/splatctf1/alienclouds.tga
		blendfunc GL_ONE GL_ONE
		tcMod scroll 0.009 0.009
		tcMod scale 2 3
	}
}

textures/skies_MASTER/hip_grimm-clouds2
{
	qer_editorImage skpk/qer/env/hip_grimm/grimmnight-clouds2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 40 341 22 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/hip_grimm/grimmnight - -
	{
		map skpk/textures/sq3t2env/clouds.tga
		tcMod scale 4 4
		tcMod scroll 0.01 0.01
		blendFunc GL_ONE GL_ONE
	}
}

textures/skies_MASTER6/scan_chemsky
{
	qer_editorImage skpk/qer/6/scan_chemsky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms - 512 -
	{
		map skpk/textures/ssub/scan_chemsky.tga
		tcMod scroll 0.02 0
		tcMod scale 1 1
		depthWrite
	}
	{
		map skpk/textures/ssub/scan_chemsky.tga
		blendfunc GL_DST_COLOR GL_ZERO
		tcMod scroll 0.02 0.01
		tcMod scale 3 3
	}
}

textures/skies_MASTER/stad
{
	qer_editorImage skpk/qer/env/stad/stad.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.934 0.956 1 20 -89 19 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 105 4
	nopicmip
	skyparms skpk/env/stad/stad - -
}

textures/skies_MASTER/C-Hazard
{
	qer_editorImage skpk/qer/env/C-Hazard/starbox01.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 120 4 -45 90 1
	nopicmip
	skyparms skpk/env/C-Hazard/starbox01 - -
}

//_dn texture is fucked.
textures/skies_MASTER2/stecki_sub01
{
	qer_editorImage skpk/qer/textures/stecki/sub01.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 80 -179 52 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 60 4
	nopicmip
	skyparms skpk/textures/stecki/sub01 - -
}

textures/skies_MASTER6/purplesky3
{
	qer_editorImage skpk/qer/6/purplesky3.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms - 512 -
	{
		map skpk/textures/steven/sky/purple1.tga
		tcMod scroll 0.02 0
		tcMod scale 2 2
		depthWrite
	}
	{
		map skpk/textures/steven/sky/purple2.tga
		blendfunc GL_ONE GL_ONE
		tcMod scroll 0.01 0.06
	}
}

textures/skies_MASTER2/shallows
{
	qer_editorImage skpk/qer/env/shallows.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 75 -155 30 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 60 4
	nopicmip
	skyparms skpk/env/shallows - -
}

textures/skies_MASTER2/null_hills3
{
	qer_editorImage skpk/qer/env/null_hills3/null_hills3-512.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 125 4
	nopicmip
	skyparms skpk/env/null_hills3/null_hills3-512 - -
}

textures/skies_MASTER6/kaznexdm1_dust
{
	qer_editorImage skpk/qer/6/kaznexdm1_dust.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 120 4
	nopicmip
	skyParms skpk/env/kaznexdm1/dust 1200 -
	{
		map skpk/textures/cardigan_skies1/circlegradlightningblur2.tga
		blendfunc add
		rgbGen wave noise 0 1 0 8
		tcMod scale 0.32 0.32
		tcMod rotate -20
	}
	{
		map skpk/textures/cardigan_skies1/bright_orange_nebula.tga
		blendfunc filter
		tcMod scroll 0.02 0.06
	}
}

textures/skies_MASTER6/assa_cloud1
{
	qer_editorImage skpk/qer/6/assa_cloud1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 120 4
	nopicmip
	skyparms - 2048 -
	{
		map skpk/textures/skies/newclouds.tga
		tcMod scale 3 3
		tcMod scroll 0.01 0.01
		depthWrite
	}
	{
		map skpk/textures/g1zm0_skies/g1z_dimclouds.tga
		blendFunc GL_ONE GL_ONE
		tcMod scale 3 2
		tcMod scroll 0.015 0.015
	}
}

textures/skies_MASTER2/sub20b1_skybox
{
	qer_editorImage skpk/qer/env/sub20b1/sub20b1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.5 1 1 60 -57 33 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 65 4
	nopicmip
	skyparms skpk/env/sub20b1/sub20b1 - -
}

textures/skies_MASTER6/summersky
{
	qer_editorImage skpk/qer/6/summersky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms - 512 -
	{
		map skpk/textures/summersky/summersky_clouds.tga
		tcMod scroll 0.009 .009
		tcMod scale 3 2
	}
	{
		map skpk/textures/summersky/summersky_clouds.tga
		blendfunc GL_ONE GL_ONE
		tcMod scroll 0.009 0.009
		tcMod scale 3 3
	}
}

textures/skies_MASTER6/t4_sky_skybox
{
	qer_editorImage skpk/qer/6/t4_sky_skybox.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 105 4
	nopicmip
	skyparms skpk/env/t4_sky/t4_sky - -
	{
		map skpk/textures/zfs_sky/zfs_nuages_4.tga
		tcmod scale 5 7
		tcMod Scroll -.1 0
		blendFunc gl_one gl_one
	}
}

textures/skies_MASTER6/t8sky1
{
	qer_editorImage skpk/qer/6/t8sky1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms - 512 -
	{
		map skpk/textures/t8dm5/t8sky1.tga
		tcMod scale 2 2
		depthWrite
	}
	{
		map skpk/textures/t8dm5/stmcloud.tga
		blendfunc GL_ONE GL_ONE
		tcMod scroll -0.01 -0.01
		tcMod scale 2 2
	}
}

textures/skies_MASTER6/xnight2-senn_sky
{
	qer_editorImage skpk/qer/6/xnight2-senn_sky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 20 -43 60 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 60 4
	nopicmip
	skyparms env/xnight2 256 -
	{
		map skpk/textures/t8dm6/senn_sky.tga
		blendFunc add
		tcMod scroll 0.03 0.03
		tcMod scale 4 5
	}
}

textures/skies_MASTER6/0color_tab_sky
{
	qer_editorImage skpk/qer/env/tabq1dm5/tabq1dm5sky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyparms skpk/env/tabq1dm5/tabq1dm5sky 256 -
}

textures/skies_MASTER6/tab_sky
{
	qer_editorImage skpk/qer/6/tab_sky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyparms skpk/env/tabq1dm5/tabq1dm5sky 256 -
	{
		map skpk/textures/tabq1dm5/tab_clouddeck.tga
		tcMod scale 8 8
		tcMod scroll 0.02 0.01
	}
	{
		map skpk/textures/tabq1dm5/tab_clouddeck.tga
		tcMod scale 5 5
		tcMod scroll 0.05 0.04
		blendFunc filter
	}
}

textures/skies_MASTER6/archq1_sky
{
	qer_editorImage skpk/qer/6/archq1_sky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms - 512 -
	{
		map skpk/textures/archql_sky/pjbasesky04.tga
		tcMod scale 2 2
		tcMod scroll 0.03 0.03
		depthWrite
	}
	{
		map textures/skies/topclouds.tga
		blendFunc GL_ONE GL_ONE
		tcMod scale 3 3
		tcMod scroll 0.01 0.01
	}
}

textures/skies_MASTER2/5th_starsky-cloudflash
{
	qer_editorImage skpk/qer/env/5th_starsky/starsky-cloudflash.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.7 0.7 1 25 37 52 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 100 4
	nopicmip
	skyparms skpk/env/5th_starsky/starzsky 512 -
	{
		map skpk/textures/5th_clouds/clouds-5.tga
		blendfunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		tcMod scale 3 3
		tcMod scroll 0.003 0.005
	}
	{
		map skpk/textures/5th_clouds/ltg_1.tga
		blendFunc GL_SRC_ALPHA GL_ONE
		rgbGen wave triangle -8 9 0.33 0.137
		tcMod scale 2 1
		tcMod scroll 0.002 -0.0025
	}
}

textures/skies_MASTER6/0color_tanker_clouds
{
	qer_editorImage skpk/qer/6/0color_tanker_clouds.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.4 0.5 0.6 50 -34 52 5 16
	q3map_LightMapFilterRadius 0 64
	q3map_skyLight 80 4
	nopicmip
	skyparms skpk/textures/tc_tanker2/env/sky1 4096 -
	{
		map skpk/textures/shaderlab_1337/sky_clouds.tga
		tcMod scroll 0.0025 -0.0075
		rgbGen identityLighting
	}
	{
		map skpk/textures/tc_tanker2/sky/sky1_mask.tga
		blendFunc GL_ONE_MINUS_SRC_ALPHA GL_SRC_ALPHA
		tcMod transform 0.25 0 0 0.25 0.1075 0.1075
		rgbGen identityLighting
	}
}

textures/skies_MASTER6/0color_blue-greyish
{
	qer_editorImage skpk/qer/textures/tc_tanker2/env/sky1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 64
	q3map_skyLight 135 4
	nopicmip
	skyparms skpk/textures/tc_tanker2/env/sky1 4096 -
}

textures/skies_MASTER6/temple_sky
{
	qer_editorImage skpk/qer/6/temple_sky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 120 4
	nopicmip
	skyparms - 200 -
	{
		map skpk/textures/eo/eo_clouds.tga
		tcMod scroll 0.015 0.016
		tcMod scale 3 3
		depthWrite
	}
	{
		map skpk/textures/temple/temple_sky.tga
		blendfunc GL_ONE GL_ONE
		tcMod scroll -0.01 -0.012
		tcMod scale 5 5
	}
}

textures/skies_MASTER2/tenshi
{
	qer_editorImage skpk/qer/env/desert/c.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_sunExt .75 .58 .42 70 -119 34 11 16
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/desert/c - -
}

textures/skies_MASTER6/xnight2-teqsky
{
	qer_editorImage skpk/qer/6/xnight2-teqsky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 20 -43 60 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 60 4
	nopicmip
	skyparms env/xnight2 - -
	{
		map skpk/textures/tequila/teqsky05.tga
		blendfunc GL_ONE GL_ONE
		tcMod scroll 0.05 0.06
		tcMod scale 1 1
	}
}

textures/skies_MASTER2/marspace_skybox
{
	qer_editorImage skpk/qer/env/tfzdm1/tfzspace.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 .8 .8 80 -90 10 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 60 4
	nopicmip
	skyparms skpk/env/tfzdm1/tfzspace - -
}

textures/skies_MASTER2/tfzmars_skybox
{
	qer_editorImage skpk/qer/env/tfzdm1/tfzmars.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 .8 .8 85 134 33 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/tfzdm1/tfzmars - -
}

textures/skies_MASTER6/blood_blue-cloud
{
	qer_editorImage skpk/qer/6/blood_blue-cloud.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyParms - 512 -
	{
		map skpk/textures/the_forge/blood_grey_cloud.tga
		blendfunc blend
		rgbGen identity
		tcMod scale 3 2
		tcMod scroll 0.05 0.08
	}
	{
		map skpk/textures/the_forge/blood_blue_cloud.tga
		blendfunc add
		rgbGen identity
		tcMod scroll 0.075 0.0456
		tcMod scale 2 1
	}
	{
		map skpk/textures/the_forge/blood_red_cloud.tga
		blendfunc filter
		rgbGen identity
		tcMod scroll 0.07 0.11
	}
}

textures/skies_MASTER/ame_thickerthanwater
{
	qer_editorImage skpk/qer/env/amethyst7/thickerthanwater/thickerthanwater.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 .7 .8 70 90 25 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 75 4
	nopicmip
	skyparms skpk/env/amethyst7/thickerthanwater/thickerthanwater - -
}

textures/skies_MASTER6/1redthunder
{
	qer_editorImage skpk/qer/6/1redthunder.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 125 4
	nopicmip
	skyparms - 1024 -
	{
		map skpk/textures/geocontest/redsky.tga
		tcmod scale 6 6
		tcmod scroll 0.015 0.015
		depthwrite
	}
	{
		map skpk/textures/common/white.tga
		blendfunc gl_one gl_one
		rgbgen wave inversesawtooth 0.8 -100 0 0.10
	}
	{
		map skpk/textures/common/white.tga
		blendfunc gl_one gl_one
		rgbgen wave inversesawtooth 0.8 -100 0.011 0.15
	}
}

textures/skies_MASTER6/tig_sky1
{
	qer_editorImage skpk/qer/6/tig_sky1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms - 384 -
	{
		map textures/skies/killsky_2.tga
		tcMod scroll 0.03 0.05
		tcMod scale 2 2
		depthWrite
	}
	{
		map skpk/textures/jb3dm13/jb_sky1_fog.tga
		blendfunc GL_ONE GL_ONE
		tcMod scroll 0.0025 0.003
		tcMod scale 3 2
	}
}

textures/skies_MASTER2/tlq3dm_nightsky
{
	qer_editorImage skpk/qer/textures/tlq3dm1_sky/nightsky/env/nightsky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 0.945 0.925 50 170 4 2 12
	q3map_sunExt 0.78 0.75 1 50 -11 8 3 12
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 80 4
	nopicmip
	skyparms skpk/textures/tlq3dm1_sky/nightsky/env/nightsky - -
}

textures/skies_MASTER6/xnight2-bluedimclouds
{
	qer_editorImage skpk/qer/6/xnight2-bluedimclouds.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_sunExt 1 1 1 20 50 66 18 16
	q3map_skylight 60 4
	nopicmip
	skyparms skpk/env/black - -
	{
		map textures/skies/bluedimclouds.tga
		blendfunc gl_one gl_one
		tcMod scale 3 2
		tcMod scroll 0.15 0.05
	}
	{
		map textures/skies/dimclouds.tga
		blendFunc GL_ONE GL_ONE
		tcMod scroll 0.01 0.02
		tcMod scale 3 3
	}
}

textures/skies_MASTER6/tm4sky01
{
	qer_editorImage skpk/qer/6/tm4sky01.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms - 512 -
	{
		map skpk/textures/tm4_shallow/skylurid.tga
		tcMod scale 2 2
		tcMod scroll 0.02 0.02
		depthWrite
	}
	{
		map skpk/textures/tm4_shallow/skyclouds.tga
		tcMod scale 3 3
		tcMod scroll 0.03 0.04
		blendfunc filter
		depthWrite
	}
}

textures/skies_MASTER2/tm4_Vaarscha
{
	qer_editorImage skpk/qer/env/tm4_Vaarscha/tm4_Vaarscha.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.95 0.95 0.55 90 40 21 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 80 4
	nopicmip
	skyparms skpk/env/tm4_Vaarscha/tm4_Vaarscha - -
}

textures/skies_MASTER6/tomsky_skybox
{
	qer_editorImage skpk/qer/6/tomsky_skybox.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 255 200 176 70 -29 13 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 80 4
	nopicmip
	skyparms skpk/env/tomsky/tomsky - -
	{
		map skpk/textures/tom_spec/tomsky_nuages.tga
		blendfunc GL_ONE GL_ONE
		tcMod scroll 0.05 0.06
		tcMod scale 3 2
	}
}

//wtf is this sky
textures/skies_MASTER6/tron_sky
{
	qer_editorImage skpk/qer/6/tron_sky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 120 4
	nopicmip
	skyparms skpk/env/tron/ring01 - -
	{
		map skpk/textures/tron_sky/1SKY15.tga
		blendfunc GL_ONE GL_ONE
		tcMod scroll 0.04 0.04
		tcMod scale 1 1
	}
	{
		map skpk/textures/tron_sfx/TRIPPY_5.tga
		blendfunc GL_ONE GL_ONE
		tcMod scroll 0.05 0.05
		tcMod scale 2 2
	}
}

textures/skies_MASTER6/dubsky
{
	qer_editorImage skpk/qer/6/dubsky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms - 512 -
	{
		map skpk/textures/tuto/sky/brownclouds.tga
		tcMod scale 3 2
		tcMod scroll 0.15 0.15
		depthWrite
	}
	{
		map skpk/textures/tuto/sky/blueclouds.tga
		blendFunc GL_ONE GL_ONE
		tcMod scale 3 3
		tcMod scroll 0.05 0.05
	}
}

textures/skies_MASTER2/tymoskybox
{
	qer_editorImage skpk/qer/env/tymo3t2/tymobox.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 0.663968 0.412955 80 61 25 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 60 4
	nopicmip
	skyparms skpk/env/tymo3t2/tymobox - -
}

textures/skies_MASTER2/doom_sky
{
	qer_editorImage skpk/qer/env/doom1/doom1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.643 0.643 0.643 30 174 65 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 90 4
	nopicmip
	skyparms skpk/env/doom1/doom1 - -
}

textures/skies_MASTER/fullmoon-killskyclouds
{
	qer_editorImage skpk/qer/env/fullmoon/fullmoon-killskyclouds.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 241 224 255 65 -97 29 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 80 4
	nopicmip
	skyparms skpk/env/fullmoon/fullmoon 512 -
	{
		map textures/skies/killsky_2.tga
		blendfunc GL_ONE GL_ONE
		tcMod scroll 0.05 0.06
		tcMod scale 3 2
	}
}

textures/skies_MASTER2/morpheus
{
	qer_editorImage skpk/qer/textures/morpheus/env/morpheus.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.35 0.55 0.85 65 -69 43 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 90 4
	nopicmip
	skyparms skpk/textures/morpheus/env/morpheus - -
}

textures/skies_MASTER2/darkdeepspace
{
	qer_editorImage skpk/qer/env/ctf_vdl/vdl.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyParms skpk/env/ctf_vdl/vdl - -
}

textures/skies_MASTER6/ut_daysky_1
{
	qer_editorImage skpk/qer/6/ut_daysky_1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 130 4
	nopicmip
	skyparms - 512 -
	{
		map skpk/textures/urban_terror/daysky_1.tga
		depthWrite
	}
}

textures/skies_MASTER/jf_forest-dark-clouds
{
	qer_editorImage skpk/qer/env/rommel-clouds.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 255 250 235 70 45 55 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/rommel - -
	{
		map skpk/textures/sweetnutz2/sn_clouds1.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		tcMod scroll 0.005 0.002
		tcMod scale 2 2
	}
}

textures/skies_MASTER6/0color_grey6
{
	qer_editorImage skpk/qer/textures/ut_suburb2/night/foghull_nightsky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 120 4
	nopicmip
	skyparms skpk/textures/ut_suburb2/night/foghull_nightsky - -
}

textures/skies_MASTER/kothic_dragonvale-clouds
{
	qer_editorImage skpk/qer/env/dragonvale/dragonvale-clouds.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 .9 .7 60 290 35 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 120 4
	nopicmip
	skyparms skpk/env/dragonvale/dragonvale - -
	{
		map textures/skies/topclouds.tga
		blendFunc GL_ONE GL_ONE
		tcMod scale 3 3
		tcMod scroll 0.01 0.02
	}
}

textures/skies_MASTER6/vexarsky
{
	qer_editorImage skpk/qer/6/vexarsky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms - 512 -
	{
		map skpk/textures/vexar/skybluesky.tga
		tcMod scroll 0.01 0
		tcMod scale 2 2
	}
	{
		map skpk/textures/vexar/cloud1a.tga
		blendfunc GL_ONE GL_ONE
		tcMod scroll 0.002 0.005
		tcMod scale 2 2
	}
}

textures/skies_MASTER6/viking_sky1
{
	qer_editorImage skpk/qer/6/viking_sky1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 120 4
	nopicmip
	skyparms - 512 -
	{
		map skpk/textures/viking/sky1.tga
		tcMod scroll 0.05 .1
		tcMod scale 2 2
	}
	{
		map skpk/textures/viking/sky1.tga
		blendfunc GL_ONE GL_ONE
		tcMod scroll 0.05 0.06
		tcMod scale 3 2
	}
}

textures/skies_MASTER/mudriver-topclouds
{
	qer_editorImage skpk/qer/env/mudriver/valley-topclouds.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt .924 .948 1 35 220 60 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/mudriver/valley - -
	{
		map textures/skies/topclouds.tga
		blendfunc GL_ONE GL_ONE
		tcMod scroll 0.05 0.06
		tcMod scale 3 2
	}
}

textures/skies_MASTER6/wasp_sky
{
	qer_editorImage skpk/qer/6/wasp_sky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms - 512 -
	{
		map skpk/textures/tequila/teqsky05.tga
		tcMod scale 2 2
		tcMod scroll 0.01 0.01
		depthWrite
	}
	{
		map skpk/textures/nova1/dimclouds.tga
		blendFunc GL_ONE GL_ONE
		tcMod scale 3 3
		tcMod scroll 0.02 0.02
	}
}

textures/skies_MASTER2/weirdwood
{
	qer_editorImage skpk/qer/env/skybox.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 80 -138 25 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 65 4
	nopicmip
	skyparms skpk/env/skybox - -
}

textures/skies_MASTER2/ik_lake-dunwich
{
	qer_editorImage skpk/qer/env/dunwich_big/dunwich.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 125 4
	nopicmip
	skyparms skpk/env/dunwich_big/dunwich - -
}

textures/skies_MASTER2/Ethora_sky
{
	qer_editorImage skpk/qer/env/Ethora/Ethora.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt .55 .5 .52 70 -89 3 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 85 4
	nopicmip
	skyparms skpk/env/Ethora/Ethora - -
}

textures/skies_MASTER2/d2
{
	qer_editorImage skpk/qer/textures/env/d2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 90 40 50 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 85 4
	nopicmip
	skyparms skpk/textures/env/d2 - -
}

textures/skies_MASTER2/wg_env
{
	qer_editorImage skpk/qer/textures/winter/env/wg_env.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.95 0.9 1 55 -131 51 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 85 4
	nopicmip
	skyparms skpk/textures/winter/env/wg_env - -
}

textures/skies_MASTER2/wmgdm1v4_skybox
{
	qer_editorImage skpk/qer/env/wmgdm1v4/wmgdm1v4sky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt .5 .37 .19 50 -40 15 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 85 4
	nopicmip
	skyparms skpk/env/wmgdm1v4/wmgdm1v4sky - -
}

textures/skies_MASTER6/diamondsky
{
	qer_editorImage skpk/qer/6/diamondsky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 125 4
	nopicmip
	skyparms - - -
	{
		map skpk/textures/deathmatch/dm1skybot.tga
		tcMod scale 4 4
		tcMod scroll .01 0
		depthWrite
	}
	{
		map skpk/textures/deathmatch/dm1skytop.tga
		blendFunc GL_ONE GL_ONE
		tcMod scale 4 4
		tcMod scroll 0.02 0.02
	}
}

textures/skies_MASTER2/wvwq3dm3sky
{
	qer_editorImage skpk/qer/textures/wvwq3dm3/env/wvwq3dm3sky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.239216 0.223529 0.415686 45 150 41 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 95 4
	nopicmip
	skyParms skpk/textures/wvwq3dm3/env/wvwq3dm3sky - -
}

textures/skies_MASTER2/sp01-blue
{
	qer_editorImage skpk/qer/textures/wvwq3dm5/env/wvw5_sky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.0352941 0.360784 0.607843 75 -87 -2 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 105 4
	nopicmip
	skyParms skpk/textures/wvwq3dm5/env/wvw5_sky - -
}

textures/skies_MASTER2/sp02
{
	qer_editorImage skpk/qer/env/sp02.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 125 4
	nopicmip
	skyparms skpk/env/sp02 - -
}

textures/skies_MASTER6/0color_green-plantation
{
	qer_editorImage skpk/qer/textures/wvwq3dm7/foghull/wvw7hull.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 120 4
	nopicmip
	skyParms skpk/textures/wvwq3dm7/foghull/wvw7hull - -
}

textures/skies_MASTER6/ww_cov-clouds
{
	qer_editorImage skpk/qer/6/ww_cov-clouds.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 .8 .8 75 0 55 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 120 4
	nopicmip
	skyparms skpk/env/ww_covsky/ww_covsky 2048 -
	{
		map skpk/textures/cov/ww_covclouds.tga
		blendFunc add
		tcMod scroll 0.03 0.08
		tcMod scale 2 2
	}
}

textures/skies_MASTER6/intelredclouds-fast
{
	qer_editorImage skpk/qer/6/intelredclouds-fast.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms - 512 -
	{
		map textures/skies/inteldimclouds.tga
		tcMod scroll 0.8 0.8
		tcMod scale 3 2
		depthWrite
	}
	{
		map textures/skies/intelredclouds.tga
		blendFunc GL_ONE GL_ONE
		tcMod scroll 0.4 0.4
		tcMod scale 3 3
	}
}

textures/skies_MASTER2/Xnamek_skybox
{
	qer_editorImage skpk/qer/env/Xnamek/Xnamek.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.934 0.956 1 40 140 40 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 85 4
	nopicmip
	skyparms skpk/env/Xnamek/Xnamek - -
}

textures/skies_MASTER2/yngwie
{
	qer_editorImage skpk/qer/env/yngwie.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 120 4
	nopicmip
	skyparms skpk/env/yngwie - -
}

textures/skies_MASTER2/yngwie-clouds
{
	qer_editorImage skpk/qer/env/yngwie-clouds.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 120 4
	nopicmip
	skyparms skpk/env/yngwie 64 -
	{
		map textures/skies/dimclouds.tga
		blendFunc add
		tcMod scroll 0.05 0.05
		tcMod scale 3 3
	}
}

textures/skies_MASTER6/yog_starysky-cloud
{
	qer_editorImage skpk/qer/6/yog_starysky-cloud.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms - 512 -
	{
		map skpk/textures/yogi/stars.tga
		tcMod scale 9 9
		tcMod scroll 0.005 0.005
		depthWrite
	}
	{
		map skpk/textures/ikbase_sky/ik_sky_night_front.tga
		tcMod scale 4 4
		tcMod scroll 0.09 0.09
		blendFunc GL_ONE GL_ONE
	}
}

textures/skies_MASTER6/xnight2-yogi_bot1
{
	qer_editorImage skpk/qer/6/xnight2-yogi_bot1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 20 -43 60 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 60 4
	nopicmip
	skyparms env/xnight2 512 -
	{
		map skpk/textures/yogi/yogi_top1.tga
		blendfunc GL_ONE GL_ONE
		tcMod scroll 0.015 0.016
		tcMod scale 3 3
	}
	{
		map skpk/textures/yogi/yogi_bot1.tga
		blendFunc GL_ONE GL_ONE
		tcMod scroll -0.01 -0.012
		tcMod scale 5 5
	}
}

textures/skies_MASTER2/zs_nebe_box
{
	qer_editorImage skpk/qer/env/trainyard/trainyard.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.780392 0.792157 0.839216 90 -120 25 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 60 4
	nopicmip
	skyParms skpk/env/trainyard/trainyard - -
}

textures/skies_MASTER2/redgon_skybox
{
	qer_editorImage skpk/qer/env/zaxxonia/redgon.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt .5 .37 .19 65 -47 11 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 90 4
	nopicmip
	skyparms skpk/env/zaxxonia/redgon - -
}

textures/skies_MASTER2/zeitgeist
{
	qer_editorImage skpk/qer/env/zeitgeist/zeitgeist.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.7 1 0.75 130 59 24 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 90 4
	nopicmip
	skyParms skpk/env/zeitgeist/zeitgeist - -
}

textures/skies_MASTER2/zfssky
{
	qer_editorImage skpk/qer/env/zfssky/zfssky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 69 35 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 90 4
	nopicmip
	skyparms skpk/env/zfssky/zfssky - -
}

textures/skies_MASTER2/zfssky-clouds
{
	qer_editorImage skpk/qer/env/zfssky/zfssky-clouds.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 75 69 35 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 90 4
	nopicmip
	skyparms skpk/env/zfssky/zfssky - -
	{
		map skpk/textures/zfs_sky/zfs_nuages_4.tga
		tcmod scale 5 7
		tcMod Scroll -.1 0
		blendFunc gl_one gl_one
	}
}

textures/skies_MASTER2/gaja_sky
{
	qer_editorImage skpk/qer/textures/zih_gaja/sky2/painted2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt .9 .4 .0 35 -79 30 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 100 4
	nopicmip
	skyparms skpk/textures/zih_gaja/sky2/painted2 - -
}

textures/skies_MASTER2/zih_roof
{
	qer_editorImage skpk/qer/textures/zih_roof/zihr.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt .6 .6 .5 25 -106 28 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 110 4
	nopicmip
	skyparms skpk/textures/zih_roof/zihr - -
}

textures/skies_MASTER2/zih_weirdf
{
	qer_editorImage skpk/qer/textures/zih_weirdf/sky/01.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms skpk/textures/zih_weirdf/sky/01 - -
}

textures/skies_MASTER6/0color_terra_clouds2
{
	qer_editorImage skpk/qer/6/0color_terra_clouds2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms skpk/textures/shaderlab_skybox/env/sky 512 -
	{
		map skpk/textures/shaderlab_skybox/sky_clouds.tga
		tcMod scale 3 3
		tcMod scroll 0.005 -0.0125
		rgbGen identityLighting
	}
	{
		clampmap skpk/textures/slterra/sky_arc_masked.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		tcMod scale 0.956 0.956
		tcMod transform 1 0 0 1 -1 -1
		rgbGen identityLighting
	}
}

textures/skies_MASTER6/0color_terra_mask
{
	qer_editorImage skpk/qer/6/0color_terra_mask.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms skpk/textures/shaderlab_skybox/env/sky 512 -
	{
		clampmap skpk/textures/slterra/sky_arc_masked.tga
		tcMod scale 0.956 0.956
		tcMod transform 1 0 0 1 -1 -1
		rgbGen identityLighting
	}
}

textures/skies_MASTER6/shaderlab_amt-fs4
{
	qer_editorImage skpk/qer/6/shaderlab_amt-fs4.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 64
	q3map_skyLight 99 4 0 90 0
	nopicmip
	skyparms skpk/textures/shaderlab_skies/black 256 -
	{
		animMap 0.01 skpk/textures/amt-fs4_sky/spring.tga skpk/textures/amt-fs4_sky/autumn.tga
		tcMod transform 0.75 0 0 0.75 -0.678 -0.678
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen identityLighting
		alphaGen wave sin 0 2.5 0.5 .01
	}
	{
		animMap 0.01 skpk/textures/amt-fs4_sky/winter.tga skpk/textures/amt-fs4_sky/summer.tga
		tcMod transform 0.75 0 0 0.75 -0.678 -0.678
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen identityLighting
		alphaGen wave sin 0 2.5 0 .01
	}
}

textures/skies_MASTER6/0color_babyBlue_clouds2
{
	qer_editorImage skpk/qer/6/0color_babyBlue_clouds2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 64
	q3map_skyLight 155 4
	nopicmip
	skyParms skpk/textures/mdw-colors/sky_blue 512 -
	{
		map skpk/textures/mdw-colors/clouds.tga
		tcMod scroll 0.05 0.05
		tcMod scale 3 2
		depthwrite
	}
}

textures/skies_MASTER6/0color_blue-orchid
{
	qer_editorimage skpk/qer/textures/mdw-colors/sky_blue.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 64
	q3map_skyLight 140 4
	nopicmip
	skyParms skpk/textures/mdw-colors/sky_blue 512 -
}

textures/skies_MASTER6/rdogdm4basesky
{
	qer_editorImage skpk/qer/6/rdogdm4basesky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 155 4
	nopicmip
	skyParms - 512 -
	{
		map textures/skies/dimclouds.tga
		tcMod scroll 0.01 0.01
		tcMod scale 3 3
		depthWrite
	}
	{
		map skpk/textures/rdogdm4_tex/rdogdm4basesky.tga
		blendfunc add
		tcMod scroll -0.01 -0.01
		tcMod scale 5 5
	}
}

textures/skies_MASTER6/cloudsky_3
{
	qer_editorImage skpk/qer/6/cloudsky_3.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyParms - 512 -
	{
		map skpk/textures/skies/cloudsky_1.tga
		tcMod scroll 0.05 .1
		tcMod scale 2 2
		depthWrite
	}
	{
		map skpk/textures/skies/cloudsky_2.tga
		blendfunc add
		tcMod scroll 0.05 0.06
		tcMod scale 3 2
	}
}

textures/skies_MASTER6/0color_gradientBabyBlue2
{
	qer_editorImage skpk/qer/textures/01/sky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 125 4
	nopicmip
	skyParms skpk/textures/01/sky - -
}

textures/skies_MASTER2/dm150
{
	qer_editorImage skpk/qer/env/dm/dm.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 75 -119 24 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 80 4
	nopicmip
	skyParms skpk/env/dm/dm - -
}

textures/skies_MASTER2/flat3
{
	qer_editorImage skpk/qer/textures/flat3/sky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 75 60 41 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 95 4
	nopicmip
	skyParms skpk/textures/flat3/sky - -
}

textures/skies_MASTER2/lighthousesky3
{
	qer_editorImage skpk/qer/env/skybox_6/mohnightfog.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 120 4
	nopicmip
	skyParms skpk/env/skybox_6/mohnightfog - -
}

textures/skies_MASTER2/m5l2
{
	qer_editorImage skpk/qer/env/skybox_10/m5l2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 120 4
	nopicmip
	skyParms skpk/env/skybox_10/m5l2 - -
}

textures/skies_MASTER2/lighthousesky
{
	qer_editorImage skpk/qer/env/skybox_11/lighthousesky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 120 4
	nopicmip
	skyParms skpk/env/skybox_11/lighthousesky - -
}

textures/skies_MASTER2/ef
{
	qer_editorImage skpk/qer/env/skybox_ut2/ef.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 120 4
	nopicmip
	skyParms skpk/env/skybox_ut2/ef - -
}

textures/skies_MASTER6/0color_blue-steel
{
	qer_editorImage skpk/qer/textures/ahmo2/env/sky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 120 4
	nopicmip
	skyParms skpk/textures/ahmo2/env/sky 512 -
}

textures/skies_MASTER6/0color_babyBlue_clouds
{
	qer_editorImage skpk/qer/6/0color_babyBlue_clouds.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 120 4
	nopicmip
	skyParms skpk/textures/ahmo2/env/sky 512 -
	{
		map skpk/textures/ahmo2/skybb.tga
		tcMod scroll 0.0015 -0.003
		rgbGen identityLighting
	}
}

textures/skies_MASTER6/88sky
{
	qer_editorImage skpk/qer/6/88sky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyParms - 512 -
	{
		map skpk/textures/88/sky2.tga
		tcMod scale 3 2
		tcMod scroll 0.15 0.15
		depthWrite
	}
	{
		map skpk/textures/88/sky1.tga
		blendfunc add
		tcMod scale 3 3
		tcMod scroll 0.05 0.05
	}
}

textures/skies_MASTER2/ast_sky
{
	qer_editorImage skpk/qer/env/ast/ast.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyParms skpk/env/ast/ast - -
}

textures/skies_MASTER2/bcm4_sky
{
	qer_editorImage skpk/qer/env/bcm4.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 65 -29 25 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyParms skpk/env/bcm4 - -
}

textures/skies_MASTER6/bgcomp10-2
{
	qer_editorImage skpk/qer/6/bgcomp10-2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyParms - 512 -
	{
		map textures/skies/dimclouds.tga
		tcMod scroll 0.02 0
		tcMod scale 1 1
		tcMod rotate 0.01
		depthWrite
	}
	{
		map textures/skies/dimclouds.tga
		blendfunc filter
		tcMod scroll 0.02 0.01
		tcMod scale 3 3
		tcMod rotate 0.01
	}
}

textures/skies_MASTER6/bierskyred
{
	qer_editorImage skpk/qer/6/bierskyred.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 95 4
	nopicmip
	skyParms skpk/textures/bierskys/bierskyred - -
	{
		map textures/skies/topclouds.tga
		blendfunc add
		tcMod scroll 0.05 0.06
		tcMod scale 3 2
	}
}

textures/skies_MASTER6/bierskygreen
{
	qer_editorImage skpk/qer/6/bierskygreen.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 95 4
	nopicmip
	skyParms skpk/textures/bierskys/bierskygreen - -
	{
		map textures/skies/topclouds.tga
		blendfunc add
		tcMod scroll 0.05 0.06
		tcMod scale 3 2
	}
}

textures/skies_MASTER6/bierskyblack
{
	qer_editorImage skpk/qer/textures/bierskys/bierskyblack.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 50 60 25 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 80 4
	nopicmip
	skyParms skpk/textures/bierskys/bierskyblack - -
}

textures/skies_MASTER2/blueplanet
{
	qer_editorImage skpk/qer/env/blueplanet/blueplanet.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 65 -29 24 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 85 4
	nopicmip
	skyParms skpk/env/blueplanet/blueplanet - -
}

textures/skies_MASTER6/bluesky5
{
	qer_editorImage skpk/qer/6/bluesky5.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyParms - 512 -
	{
		map skpk/textures/bluesky/bluesky.tga
		tcMod scroll 0.02 0.02
		tcMod scale 1 1
	}
	{
		map skpk/textures/bluesky/bluesky.tga
		blendFunc add
		tcMod scroll .02 .02
		tcMod scale 2 2
	}
}

textures/skies_MASTER2/blue_skybox
{
	qer_editorImage skpk/qer/env/blue/blue.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 65 -90 0 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyParms skpk/env/blue/blue - -
}

textures/skies_MASTER2/box
{
	qer_editorImage skpk/qer/env/box/box.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyParms skpk/env/box/box - -
}

textures/skies_MASTER2/bra5
{
	qer_editorImage skpk/qer/env/bra5.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 65 -29 24 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 85 4
	nopicmip
	skyParms skpk/env/bra5 - -
}

textures/skies_MASTER2/charon3dm12sky
{
	qer_editorImage skpk/qer/textures/charon_dm12/sea.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyParms skpk/textures/charon_dm12/sea - -
}

textures/skies_MASTER2/charon3dm12sky-clouds
{
	qer_editorImage skpk/qer/textures/charon_dm12/sea-clouds.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyParms skpk/textures/charon_dm12/sea - -
	{
		map textures/skies/topclouds.tga
		blendfunc add
		tcMod scroll 0.05 0.06
		tcMod scale 3 2
	}
}

textures/skies_MASTER6/cityrocket_blueskypic
{
	qer_editorImage skpk/qer/6/cityrocket_blueskypic.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 145 4
	nopicmip
	skyParms - 512 -
	{
		map skpk/textures/cityrocket/blueskypic.tga
		tcMod scale 3 2
		tcMod scroll 0.04 0.04
		depthWrite
	}
	{
		map skpk/textures/cityrocket/blueskypic.tga
		blendfunc add
		tcMod scale 3 3
		tcMod scroll 0.01 0.01
	}
}

textures/skies_MASTER2/cm6
{
	qer_editorImage skpk/qer/env/cm6/cm6.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 25 89 36 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 90 4
	nopicmip
	skyParms skpk/env/cm6/cm6 - -
}

textures/skies_MASTER/sb_nightball-tecksky
{
	qer_editorImage skpk/qer/env/sb_nightball/nightball-clouds.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt .851 .945 1 15 -50 40 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyParms skpk/env/sb_nightball/nightball 128 -
	{
		map skpk/textures/cmc05/tecksky.tga
		blendfunc add
		tcMod scale 1.5 1.5
		tcMod scroll 0.02 -0.02
	}
}

textures/skies_MASTER/ame_comawhite
{
	qer_editorImage skpk/qer/env/amethyst7/comawhite/comawhite.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyParms skpk/env/amethyst7/comawhite/comawhite - -
}

textures/skies_MASTER6/cooltrain
{
	qer_editorImage skpk/qer/6/cooltrain.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyParms skpk/textures/shaderlab_skybox/env/sky 1024 -
	{
		map skpk/textures/cooltrain/clouds2.tga
		tcMod scale 3 3
		tcMod scroll 0.05 0.05
	}
	{
		map skpk/textures/cooltrain/clouds1.tga
		blendFunc GL_one_minus_SRC_ALPHA GL_SRC_ALPHA
		tcMod transform 0.25 0 0 0.25 0.1075 0.1075
		rgbGen identityLighting
	}
}

textures/skies_MASTER6/path_sky1
{
	qer_editorImage skpk/qer/6/path_sky1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyParms - 512 -
	{
		map skpk/textures/crosspath/path_sky1.tga
		tcMod scroll 0.01 0.01
		tcMod scale 3 3
		depthWrite
	}
	{
		map skpk/textures/crosspath/path_sky1.tga
		blendfunc add
		tcMod scroll -0.01 -0.01
		tcMod scale 5 5
	}
}

textures/skies_MASTER6/path_sky2
{
	qer_editorImage skpk/qer/6/path_sky2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyParms - 512 -
	{
		map skpk/textures/crosspath/path_sky2.tga
		tcMod scroll 0.01 0.01
		tcMod scale 3 3
		depthWrite
	}
	{
		map skpk/textures/crosspath/path_sky2.tga
		blendfunc add
		tcMod scroll -0.01 -0.01
		tcMod scale 5 5
	}
}

textures/skies_MASTER6/cyberstorm-clouds03
{
	qer_editorImage skpk/qer/6/cyberstorm-clouds03.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyParms - 1024 -
	{
		map skpk/textures/custom_skies/cyberstorm-clouds03.tga
		tcMod scale 3 3
		tcMod scroll 0.02 0.02
	}
	{
		map skpk/textures/custom_skies/cyberstorm-clouds02.tga
		blendFunc GL_DST_COLOR GL_SRC_ALPHA
		tcMod scale 3 3
		tcMod scroll 0.010 0.010
	}
}

textures/skies_MASTER2/cyberstormspace
{
	qer_editorImage skpk/qer/env/cspace/cspace.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 130 4
	nopicmip
	skyParms skpk/env/cspace/cspace - -
}

textures/skies_MASTER2/Icy_Planet
{
	qer_editorImage skpk/qer/env/Icy_Planet_Sky/icey_planet.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 130 4
	nopicmip
	skyParms skpk/env/Icy_Planet_Sky/icey_planet - -
}

textures/skies_MASTER2/Dini_skai
{
	qer_editorImage skpk/qer/textures/Dini_skai/sky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 75 -77 22 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 60 4
	nopicmip
	skyParms skpk/textures/Dini_skai/sky - -
}

textures/skies_MASTER2/e3257
{
	qer_editorImage skpk/qer/textures/e3257/sky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 140 4
	nopicmip
	skyParms skpk/textures/e3257/sky - -
}

textures/skies_MASTER2/eggrun
{
	qer_editorImage skpk/qer/textures/eggrun/sky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 140 4
	nopicmip
	skyParms skpk/textures/eggrun/sky - -
}

textures/skies_MASTER/kothic_troubadour-gray
{
	qer_editorImage skpk/qer/env/env_med-troubadour-gray/med-troubadour-gray.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 30 114 48 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 95 4
	nopicmip
	skyParms skpk/env/env_med-troubadour-gray/med-troubadour-gray - -
}

textures/skies_MASTER2/frozencolors
{
	qer_editorImage skpk/qer/env/K_sky/ice640.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_sunExt 1 1 1 30 137 33 8 16
	q3map_skylight 90 4
	nopicmip
	skyParms skpk/env/K_sky/ice640 - -
}

textures/skies_MASTER6/cardigan_blueLightning3
{
	qer_editorImage skpk/qer/6/cardigan_blueLightning3.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 140 4
	nopicmip
	skyParms skpk/env/cardigan/purewhitej 1200 -
	{
		map skpk/textures/cardigan_skies1/circlegradlightningblur2.tga
		blendfunc add
		rgbGen wave noise 0 1 0 10
		tcMod scale 0.32 0.32
		tcMod rotate -20
	}
	{
		map skpk/textures/gewitter/gewitterhimmel.tga
		blendfunc filter
		tcMod scroll 0.02 0.03
	}
}

textures/skies_MASTER/lmcity_clouds_lightning
{
	qer_editorImage skpk/qer/env/lmcity/lmcity-clouds.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 30 0 90 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 60 4
	nopicmip
	skyparms skpk/env/lmcity/lmcity - -
	{
		map textures/skies/dimclouds.tga
		blendfunc add
		tcMod scroll 0.05 0.06
		tcMod scale 3 2
	}
	{
		map skpk/textures/ct3tourney2/env/lightning.tga
		blendfunc add
		rgbGen wave noise 0 1 0 5
		tcMod scale 0.32 0.32
		tcMod rotate 20
	}
}

textures/skies_MASTER6/ghost_pinksky3
{
	qer_editorImage skpk/qer/6/ghost_pinksky3.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyParms - 512 -
	{
		map skpk/textures/skies/pinkclouds.tga
		tcMod scale 3 2
		tcMod scroll 0.15 0.15
		depthWrite
	}
	{
		map skpk/textures/skies/pinkclouds.tga
		blendfunc add
		tcMod scale 3 3
		tcMod scroll 0.05 0.05
	}
}

textures/skies_MASTER6/crazygreensky
{
	qer_editorImage skpk/qer/6/crazygreensky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 125 4
	nopicmip
	skyParms - 512 -
	{
		map skpk/textures/skies/crazyclouds2.tga
		tcMod scroll .15 .15
		tcMod scale 2 2
		depthWrite
	}
	{
		map skpk/textures/skies/greenclouds.tga
		blendfunc add
		tcMod scroll .15 .15
		tcMod scale 3 3
	}
}

textures/skies_MASTER6/crazysky
{
	qer_editorImage skpk/qer/6/crazysky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 120 4
	nopicmip
	skyParms - 512 -
	{
		map skpk/textures/skies/crazyclouds1.tga
		tcMod scroll 0.05 0.01
		tcMod scale 1 1
		depthWrite
	}
	{
		map skpk/textures/skies/darkclouds.tga
		blendfunc add
		tcMod scroll 0.05 0.06
		tcMod scale 3 3
	}
}

textures/skies_MASTER6/yellow_sky
{
	qer_editorImage skpk/qer/6/yellow_sky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyParms - 512 -
	{
		map skpk/textures/skies/yellowclouds.tga
		tcMod scroll .05 .05
		tcMod scale 2 2
		depthWrite
	}
	{
		map skpk/textures/skies/yellowclouds.tga
		blendfunc add
		tcMod scroll -.05 -.05
		tcMod scale 3 3
	}
}

textures/skies_MASTER6/psy7
{
	qer_editorImage skpk/qer/6/psy7.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyParms - - -
	{
		map skpk/textures/yave-glaseado/psy7.tga
		tcMod turb 0.04 0.04 0 0.09
		tcmod scroll 0.13 0.18
		rgbGen wave sin 0.9 0.2 0 0.2
	}
}

textures/skies_MASTER6/cardigan_blackLightning
{
	qer_editorImage skpk/qer/6/cardigan_blackLightning.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyParms skpk/env/cardigan/purewhitej 1200 -
	{
		map skpk/textures/cardigan_skies1/circlegradlightningblur3.tga
		blendfunc add
		rgbGen wave noise 0 1 0 5
		tcMod scale 0.32 0.32
		tcMod rotate -20
	}
	{
		map skpk/textures/gnj/dense_black_nebula.tga
		blendfunc filter
		tcMod scroll 0.02 0.03
	}
}

textures/skies_MASTER2/grbox
{
	qer_editorImage skpk/qer/env/grbox/gr.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 30 72 22 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 85 4
	nopicmip
	skyParms skpk/env/grbox/gr - -
}

textures/skies_MASTER6/wrdf-greensky
{
	qer_editorImage skpk/qer/6/wrdf-greensky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyParms - 512 -
	{
		map skpk/textures/wrdf/greensky.tga
		tcMod scroll 0.05 .1
		tcMod scale 2 2
	}
	{
		map skpk/textures/wrdf/greensky.tga
		blendfunc add
		tcMod scroll 0.05 0.06
		tcMod scale 3 2
	}
}

textures/skies_MASTER3/muad_cloudy
{
	qer_editorImage skpk/qer/env/muad_cloudy/cloudy.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyParms skpk/env/muad_cloudy/cloudy - -
}

textures/skies_MASTER2/rkyisle
{
	qer_editorImage skpk/qer/env/rkyisle/rkyisle.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 50 174 50 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyParms skpk/env/rkyisle/rkyisle - -
}

textures/skies_MASTER2/h-advance
{
	qer_editorImage skpk/qer/env/h-advance/h-advance.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 60 -71 81 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 75 4
	nopicmip
	skyParms skpk/env/h-advance/h-advance - -
}

textures/skies_MASTER2/h-frozen
{
	qer_editorImage skpk/qer/env/h-frozen/h-frozen.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 60 -79 82 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 75 4
	nopicmip
	skyParms skpk/env/h-frozen/h-frozen - -
}

textures/skies_MASTER6/himmels
{
	qer_editorImage skpk/qer/6/himmels.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyParms - 512 -
	{
		map skpk/textures/himmels/himmel.tga
		tcMod scale 2 2
		tcMod scroll 0.00 0.00
		depthWrite
	}
}

textures/skies_MASTER2/ifx-2
{
	qer_editorImage skpk/qer/env/ifx-2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 60 179 29 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 80 4
	nopicmip
	skyParms skpk/env/ifx-2 - -
}

textures/skies_MASTER6/crazyclouds2
{
	qer_editorImage skpk/qer/6/crazyclouds2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyParms - 512 -
	{
		map skpk/textures/skies/crazyclouds2.tga
		tcMod scroll 0.05 0
		tcMod scale 2 2
		depthWrite
	}
}

textures/skies_MASTER6/crazyclouds3
{
	qer_editorImage skpk/qer/6/crazyclouds3.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 150 4
	nopicmip
	skyParms - 512 -
	{
		map skpk/textures/skies/crazyclouds3.tga
		tcMod scroll 0.05 0
		tcMod scale 2 2
		depthWrite
	}
}

textures/skies_MASTER6/purpleclouds
{
	qer_editorImage skpk/qer/6/purpleclouds.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 130 4
	nopicmip
	skyParms - 512 -
	{
		map skpk/textures/skies/purpleclouds.tga
		tcMod scroll 0.05 0
		tcMod scale 2 2
		depthWrite
	}
}

textures/skies_MASTER/jajice1
{
	qer_editorImage skpk/qer/env/jajice1/jajice1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 75 -60 14 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 65 4
	nopicmip
	skyParms skpk/env/jajice1/jajice1 - -
}

textures/skies_MASTER/jaj_lands1
{
	qer_editorImage skpk/qer/env/jajlands1/jajlands1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 65 -29 24 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 80 4
	nopicmip
	skyParms skpk/env/jajlands1/jajlands1 - -
}

textures/skies_MASTER/jaj_mars
{
	qer_editorImage skpk/qer/env/jajmars/jajmars.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 70 -29 20 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 100 4
	nopicmip
	skyParms skpk/env/jajmars/jajmars - -
}

textures/skies_MASTER/jaj_snow1a
{
	qer_editorImage skpk/qer/env/jajsnow1a/jajsnow1a.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 20 -30 11 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyParms skpk/env/jajsnow1a/jajsnow1a - -
}

textures/skies_MASTER2/lake1
{
	qer_editorImage skpk/qer/env/lake1/lake1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 80 -90 30 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 75 4
	nopicmip
	skyParms skpk/env/lake1/lake1 - -
}

textures/skies_MASTER/ame_oasisday
{
	qer_editorImage skpk/qer/env/amethyst7/oasisday/oasisday.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 80 -89 32 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyParms skpk/env/amethyst7/oasisday/oasisday - -
}

textures/skies_MASTER2/jms
{
	qer_editorImage skpk/qer/env/jms/jms.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 80 -23 13 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 60 4
	nopicmip
	skyParms skpk/env/jms/jms - -
}

textures/skies_MASTER2/snowblind
{
	qer_editorImage skpk/qer/env/snowblind/snowblind.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 80 -18 15 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 80 4
	nopicmip
	skyParms skpk/env/snowblind/snowblind - -
}

textures/skies_MASTER6/0color_gradientBabyBlue
{
	qer_editorImage skpk/qer/textures/nishi/SKY.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyParms skpk/textures/nishi/SKY - -
}

textures/skies_MASTER6/0color_grey
{
	qer_editorImage skpk/qer/env/mc_graysky/mc_graysky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyParms skpk/env/mc_graysky/mc_graysky - -
}

textures/skies_MASTER2/mega_evening_sky
{
	qer_editorImage skpk/qer/env/mega_evening/mega_evening.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.978088 0.664607 0.216999 80 137 4 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 90 4
	nopicmip
	skyParms skpk/env/mega_evening/mega_evening - -
}

textures/skies_MASTER6/mmp-starrun1
{
	qer_editorImage skpk/qer/6/mmp-starrun1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyParms - 512 -
	{
		map skpk/textures/mmp-starrun1/star.tga
		rgbGen wave sin 0.95 0.10 0 0.5
		tcMod scale 6 6
		tcMod scroll 0.008 0.008
	}
	{
		map skpk/textures/mmp-starrun1/star.tga
		rgbGen wave sin 0.95 0.10 0 0.6
		blendfunc add
		tcMod scale 8 9
		tcMod scroll -0.006 -0.005
	}
}

textures/skies_MASTER2/mojobox
{
	qer_editorImage skpk/qer/env/mojo/mojo.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 40 -163 64 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 100 4
	nopicmip
	skyParms skpk/env/mojo/mojo - -
}

textures/skies_MASTER6/moteof_skyportal
{
	qer_editorImage skpk/qer/6/moteof_skyportal.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 50 -119 62 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 100 4
	nopicmip
	skyParms skpk/textures/moteof/env/barren 1500 -
	{
		map skpk/textures/moteof/env/fog_mask.tga
		blendFunc GL_ONE_MINUS_SRC_ALPHA GL_SRC_ALPHA
		tcMod transform 0.25 0 0 0.25 0.1 0.1
		tcMod turb 1 0.01 sin 0.05
		rgbGen identityLighting
	}
}

textures/skies_MASTER/mp_xono
{
	qer_editorImage skpk/qer/env/mp_xono/xono.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_sunExt 255 240 220 80 -18 13 8 16
	q3map_skylight 50 4
	nopicmip
	skyParms skpk/env/mp_xono/xono - -
}

textures/skies_MASTER2/mymap_skybox
{
	qer_editorImage skpk/qer/env/mymap/skybox.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 60 -29 26 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 95 4
	nopicmip
	skyParms skpk/env/mymap/skybox - -
}

textures/skies_MASTER2/n1kwaterrock
{
	qer_editorImage skpk/qer/env/niklas/n1kwaterrock/n1kwaterrock.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 60 -119 25 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 90 4
	nopicmip
	skyParms skpk/env/niklas/n1kwaterrock/n1kwaterrock - -
}

textures/skies_MASTER6/nacht_moond
{
	qer_editorImage skpk/qer/6/nacht_moond.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyParms - 512 -
	{
		map skpk/textures/nacht/moond.tga
		tcMod scroll 0.00 0
		tcMod scale 2 2
		depthWrite
	}
}

textures/skies_MASTER2/neodox
{
	qer_editorImage skpk/qer/env/neodox/neodox_env.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.8 0.8 1 85 110 10 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 75 4
	nopicmip
	skyParms skpk/env/neodox/neodox_env - -
}

textures/skies_MASTER2/ArticSky
{
	qer_editorImage skpk/qer/env/artic.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 70 145 29 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 95 4
	nopicmip
	skyParms skpk/env/artic - -
}

textures/skies_MASTER6/0color_babyPink_clouds
{
	qer_editorImage skpk/qer/6/0color_babyPink_clouds.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 30 -35 10 5 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyParms skpk/textures/nt11/env/sky - -
	{
		map skpk/textures/nt11/sky_clouds.tga
		tcMod scroll 0.0025 -0.0075
		rgbGen identityLighting
	}
	{
		map skpk/textures/nt11/sky_mask.tga
		blendFunc GL_ONE_MINUS_SRC_ALPHA GL_SRC_ALPHA
		tcMod transform 0.25 0 0 0.25 0.1075 0.1075
		rgbGen identityLighting
	}
}

textures/skies_MASTER6/0color_babyPink2
{
	qer_editorImage skpk/qer/textures/nt11/env/sky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 140 4
	nopicmip
	skyParms skpk/textures/nt11/env/sky - -
}

textures/skies_MASTER6/0color_greyDark
{
	qer_editorImage skpk/qer/env/nunukcompsky/nunukcompsky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyParms skpk/env/nunukcompsky/nunukcompsky - -
}

textures/skies_MASTER/ame_orangecream
{
	qer_editorImage skpk/qer/env/amethyst7/orangecream/orangecream.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 70 84 34 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 100 4
	nopicmip
	skyParms skpk/env/amethyst7/orangecream/orangecream - -
}

textures/skies_MASTER6/orionsky
{
	qer_editorImage skpk/qer/6/orionsky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 70 151 2 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 120 4
	nopicmip
	skyParms skpk/env/orionsky - -
	{
		map textures/skies/killsky_2.tga
		blendfunc add
		tcMod scroll 0.05 0.06
		tcMod scale 3 2
	}
}

//wtf...why?
textures/skies_MASTER2/paperthin01
{
	qer_editorImage skpk/qer/textures/paperthin01/env/sk.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyParms skpk/textures/paperthin01/env/sk - -
}

textures/skies_MASTER2/paperthin02
{
	qer_editorImage skpk/qer/textures/paperthin02/env/sk.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_lightRGB 255 245 235
	q3map_skylight 100 4 0 90 0
	nopicmip
	skyParms skpk/textures/paperthin02/env/sk - -
}

textures/skies_MASTER2/pea_shitsky
{
	qer_editorImage skpk/qer/env/pea_shitsky/pea_shitsky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 100 4
	nopicmip
	skyParms skpk/env/pea_shitsky/pea_shitsky - -
}

textures/skies_MASTER2/pea_xwierdx
{
	qer_editorImage skpk/qer/textures/pea_xwierdx/blah.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyParms skpk/textures/pea_xwierdx/blah - -
}

textures/skies_MASTER6/blau
{
	qer_editorImage skpk/qer/6/blau.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 111 4
	nopicmip
	skyParms - 225 -
	{
		map skpk/textures/prohimmel/blau.tga
		tcMod scroll 0.05 0
		tcMod scale 2 2
		depthWrite
	}
}

textures/skies_MASTER6/q32thecore_1
{
	qer_editorImage skpk/qer/6/q32thecore_1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyParms - 512 -
	{
		map skpk/textures/q32thecore_txtset1_sky/sky_layer1.tga
		tcMod scale 3 2
		tcMod scroll 0.15 0.15
		depthWrite
	}
	{
		map skpk/textures/q32thecore_txtset1_sky/sky_layer2.tga
		blendfunc filter
		tcMod scale 3 3
		tcMod scroll 0.08 0.08
	}
}

textures/skies_MASTER6/random1
{
	qer_editorImage skpk/qer/6/random1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 111 4
	nopicmip
	skyParms - 512 -
	{
		map skpk/textures/random1/r1_sky.tga
		tcMod scroll 0.01 0.01
		tcMod scale 3 3
		depthWrite
	}
	{
		map skpk/textures/random1/r1_sky.tga
		blendfunc add
		tcMod scroll -0.01 -0.01
		tcMod scale 5 5
	}
}

textures/skies_MASTER2/redsky
{
	qer_editorImage skpk/qer/textures/skies/redsky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.971328 0.415778 0.415778 60 101 48 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 105 4
	nopicmip
	skyParms skpk/textures/skies/redsky - -
}

textures/skies_MASTER2/redsunset
{
	qer_editorImage skpk/qer/env/redsunset/redsunset.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.971313 0.781247 0.415778 30 61 7 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyParms skpk/env/redsunset/redsunset - -
}

textures/skies_MASTER2/dos
{
	qer_editorImage skpk/qer/textures/sw-skies2/dos.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 60 -134 38 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyParms skpk/textures/sw-skies2/dos - -
}

textures/skies_MASTER2/simplesky
{
	qer_editorImage skpk/qer/env/simplesky/simplesky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyParms skpk/env/simplesky/simplesky - -
}

textures/skies_MASTER6/shaderlab_1337
{
	qer_editorImage skpk/qer/6/shaderlab_1337.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	// light values tuned for -gamma 2 -compensate 4
	q3map_LightMapFilterRadius 0 8
	q3map_sunExt 1 1 1 400 -34 28 8 12
	q3map_skyLight 75 4
	nopicmip
	skyParms skpk/textures/shaderlab_skybox/env/sky 1337 -
	{
		map skpk/textures/shaderlab_1337/sky_clouds.tga
		tcMod scroll 0.0025 -0.0075
		rgbGen identityLighting
	}
	{
		map skpk/textures/shaderlab_skybox/sky_arc_masked.tga
		blendFunc GL_ONE_MINUS_SRC_ALPHA GL_SRC_ALPHA
		tcMod transform 0.25 0 0 0.25 0.1075 0.1075
		rgbGen identityLighting
	}
}

textures/skies_MASTER6/0color_beige
{
	qer_editorImage skpk/qer/textures/shaderlab_skybox/env/sky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 100 4
	nopicmip
	skyparms skpk/textures/shaderlab_skybox/env/sky 1337 -
}

textures/skies_MASTER6/thdskie
{
	qer_editorImage skpk/qer/6/thdskie.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 125 4
	nopicmip
	skyParms - 512 -
	{
		map skpk/textures/skie/thdskie.tga
		tcMod scroll 0.05 0
		tcMod scale 2 2
		depthWrite
	}
}

textures/skies_MASTER6/0color_wurzburg_mask
{
	qer_editorImage skpk/qer/6/0color_wurzburg_mask.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 125 4
	nopicmip
	skyParms skpk/textures/skies_sd/wurzburg_env/sky 512 -
	{
		clampmap skpk/textures/skies_sd/siwa_mask.tga
		blendFunc GL_ONE_MINUS_SRC_ALPHA GL_SRC_ALPHA
		tcMod scale 0.956 0.956
		tcMod transform 1 0 0 1 -1 -1
		rgbGen identityLighting
	}
}

textures/skies_MASTER6/nacht
{
	qer_editorImage skpk/qer/6/nacht.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 99 4
	nopicmip
	skyParms - 512 -
	{
		map skpk/textures/skie/nacht.tga
		tcMod scroll 0.05 0
		tcMod scale 2 2
		depthWrite
	}
}

textures/skies_MASTER6/winter-cloud
{
	qer_editorImage skpk/qer/6/winter-cloud.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyParms - 512 -
	{
		map skpk/textures/skywinter/lowclouds.tga
		tcMod scale 3 2
		tcMod scroll 0.15 0.15
		depthWrite
	}
	{
		map skpk/textures/skywinter/highclouds.tga
		blendfunc add
		tcMod scale 3 3
		tcMod scroll 0.05 0.05
	}
}

textures/skies_MASTER2/sky_maison
{
	qer_editorImage skpk/qer/env/sky_maison/sky_maison.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 60 -30 26 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 95 4
	nopicmip
	skyParms skpk/env/sky_maison/sky_maison - -
}

textures/skies_MASTER6/eigene-sky_red
{
	qer_editorImage skpk/qer/6/eigene-sky_red.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 120 4
	nopicmip
	skyParms - 600 -
	{
		map skpk/textures/eigene/sky_red1_3.tga
		tcMod scale 2 2
		tcMod scroll 0.03 0.1
	}
	{
		map skpk/textures/eigene/sky_red1_2.tga
		blendfunc add
		tcMod scroll 0.04 0.05
		tcMod scale 3 2
	}
}

textures/skies_MASTER2/snowlake
{
	qer_editorImage skpk/qer/env/snowlake/snowlake.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 60 59 29 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyParms skpk/env/snowlake/snowlake - -
}

textures/skies_MASTER/sb_strato-red
{
	qer_editorImage skpk/qer/env/stratosphere_red/stratosphere_red.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_sunExt 166 66 66 85 0 45 15 16
	q3map_skylight 50 4
	nopicmip
	skyParms skpk/env/stratosphere_red/stratosphere_red - -
}

textures/skies_MASTER2/sun_skybox
{
	qer_editorImage skpk/qer/env/sun/sun.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 60 41 4 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyParms skpk/env/sun/sun - -
}

textures/skies_MASTER2/sunset_a
{
	qer_editorImage skpk/qer/env/sunset_a/sunset_a.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 45 -90 10 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyParms skpk/env/sunset_a/sunset_a - -
}

textures/skies_MASTER2/skytoony
{
	qer_editorImage skpk/qer/textures/s_sky/skytoony/sky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 45 44 74 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 100 4
	nopicmip
	skyParms skpk/textures/s_sky/skytoony/sky - -
}

textures/skies_MASTER2/t3
{
	qer_editorImage skpk/qer/env/t3.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 65 60 25 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 95 4
	nopicmip
	skyParms skpk/env/t3 - -
}

textures/skies_MASTER6/wolken
{
	qer_editorImage skpk/qer/6/wolken.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 145 4
	nopicmip
	skyParms - 512 -
	{
		map skpk/textures/tag/wolken.tga
		tcMod scroll 0.05 0
		tcMod scale 2 2
		depthWrite
	}
}

textures/skies_MASTER6/rosawolken
{
	qer_editorImage skpk/qer/6/rosawolken.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 150 4
	nopicmip
	skyParms - 512 -
	{
		map skpk/textures/tagig/rosawolken.tga
		tcMod scroll 0.05 0
		tcMod scale 2 2
		depthWrite
	}
}

textures/skies_MASTER6/terrast
{
	qer_editorImage skpk/qer/6/terrast.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_lightRGB 178 214 255
	q3map_skylight 155 4 0 90 0
	nopicmip
	skyParms skpk/textures/terrast/sky 1500 -
	{
		map skpk/textures/skies/cloudsky_1.tga
		tcMod scroll 0.05 .1
		tcMod scale 2 2
		depthWrite
	}
	{
		map skpk/textures/terrast/cloudsky_2.tga
		blendfunc add
		tcMod scroll 0.05 0.06
		tcMod scale 3 2
	}
}

textures/skies_MASTER6/0color_blue-azure
{
	qer_editorImage skpk/qer/textures/terrast/sky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 175 4
	nopicmip
	skyParms skpk/textures/terrast/sky 1500 -
}

textures/skies_MASTER2/tex
{
	qer_editorImage skpk/qer/env/tex/tex.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 70 30 69 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 100 4
	nopicmip
	skyParms skpk/env/tex/tex - -
}

textures/skies_MASTER6/todeshimmel
{
	qer_editorImage skpk/qer/6/todeshimmel.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyParms - 512 -
	{
		map skpk/textures/todes/todeshimmel.tga
		tcMod scroll 0.00 0
		tcMod scale 2 2
		depthWrite
	}
}

textures/skies_MASTER6/0color_greyBright
{
	qer_editorImage skpk/qer/env/uc_sky/uc_sky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyParms skpk/env/uc_sky/uc_sky - -
}

textures/skies_MASTER2/cp_facesky
{
	qer_editorImage skpk/qer/env/ut_sky02/cp_facesky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 125 4
	nopicmip
	skyParms skpk/env/ut_sky02/cp_facesky - -
}

textures/skies_MASTER6/0color_white
{
	qer_editorImage skpk/qer/env/whitesky/white.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyParms skpk/env/whitesky/white - -
}

textures/skies_MASTER2/wildwest_sky
{
	qer_editorImage skpk/qer/env/wildwest/wildwest.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 0.755184 0.437278 55 -89 19 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 100 4
	nopicmip
	skyParms skpk/env/wildwest/wildwest - -
}

textures/skies_MASTER2/winterskybox
{
	qer_editorImage skpk/qer/env/winter.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 75 -51 29 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 60 4
	nopicmip
	skyParms skpk/env/winter - -
}

textures/skies_MASTER2/rainbow
{
	qer_editorImage skpk/qer/textures/xyligan-block/space1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 125 4
	nopicmip
	skyParms skpk/textures/xyligan-block/space1 - -
}

textures/skies_MASTER2/xyloote_skybox
{
	qer_editorImage skpk/qer/env/xyloote/xyloote.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 120 4
	nopicmip
	skyparms skpk/env/xyloote/xyloote - -
}

textures/skies_MASTER2/ocean2
{
	qer_editorImage skpk/qer/env/woebane/ocean.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 70 -90 2 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 100 4
	nopicmip
	skyParms skpk/env/woebane/ocean - -
}

textures/skies_MASTER2/network
{
	qer_editorImage skpk/qer/env/network/network.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 20 -157 14 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyParms skpk/env/network/network - -
}

textures/skies_MASTER6/zeal_sky03
{
	qer_editorImage skpk/qer/6/zeal_sky03.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyParms - 512 -
	{
		map skpk/textures/tc_skies/clouds_high.tga
		tcMod scroll 0.05 0
		tcMod scale 2 2
		depthWrite
	}
	{
		map skpk/textures/tc_skies/clouds_high.tga
		blendfunc add
		tcMod scroll 0.05 0.06
	}
}

textures/skies_MASTER6/zer0_sky
{
	qer_editorImage skpk/qer/6/zer0_sky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyParms - 512 -
	{
		map skpk/textures/zer0/sky.tga
		rgbGen identity
		tcMod scroll 0.05 0.1
		tcMod scale 2 2
	}
}

textures/skies_MASTER2/zep
{
	qer_editorImage skpk/qer/textures/zep/zep.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 65 87 41 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 85 4
	nopicmip
	skyParms skpk/textures/zep/zep - -
}

textures/skies_MASTER6/anoice1
{
	qer_editorImage skpk/qer/6/anoice1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 120 4
	nopicmip
	skyParms skpk/env/anoice1/anoice1 - -
	{
		map skpk/textures/skies/anoice1.tga
		blendfunc filter
		tcmod scale 3 2
		tcmod scroll .01 .02
		rgbgen identity
	}
}

textures/skies_MASTER6/blx
{
	qer_editorImage skpk/qer/6/blx.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 120 4
	nopicmip
	skyParms - 512 -
	{
		map skpk/textures/blx_wtest3/blx_wt3_sky.tga
		tcMod scale 8 8
		tcMod scroll 0.01 0.0
		depthWrite
	}
	{
		map skpk/textures/ikbase_sky/ik_sky_night_front.tga
		blendfunc add
		tcMod scale 2 2
		tcMod scroll 0.01 0.01
	}
}

textures/skies_MASTER6/cross-03-aren
{
	qer_editorImage skpk/qer/6/cross-03-aren.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 65 0 90 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 85 4
	nopicmip
	skyParms skpk/env/cross-03-aren/sky128x128 256 -
	{
		map skpk/textures/cross-03-aren/cloud128x128.tga
		blendfunc blend
		tcmod scale 2 2
		tcmod scroll .01 .04
	}
	{
		map skpk/textures/cross-03-aren/cloud128x128.tga
		blendfunc blend
		tcmod scale 1 1
		tcmod scroll .05 .025
	}
}

textures/skies_MASTER/hip_inter-green
{
	qer_editorImage skpk/qer/env/khaosky/khaosky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_sunExt 1 1 1 80 340 49 11 16
	q3map_skylight 50 4
	nopicmip
	skyParms skpk/env/khaosky/khaosky - -
}

textures/skies_MASTER6/nitesky
{
	qer_editorImage skpk/qer/6/nitesky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyParms - 1280 -
	{
		map skpk/textures/skies/stars.tga
		tcMod scale 3 3
	}
	{
		map skpk/textures/skies/nitesky.tga
		blendfunc add
		tcMod scroll 0.02 0.07
	}
}

textures/skies_MASTER2/cross-04-aren
{
	qer_editorImage skpk/qer/env/cross-04-aren/sky128x128.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 65 20 49 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 85 4
	nopicmip
	skyParms skpk/env/cross-04-aren/sky128x128 - -
}

textures/skies_MASTER2/sikpark
{
	qer_editorImage skpk/qer/env/sikpark/sikpark.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 120 4
	nopicmip
	skyParms skpk/env/sikpark/sikpark - -
}

textures/skies_MASTER2/Idm_pink
{
	qer_editorImage skpk/qer/env/Idm_pink_Skybox/Idm_pink_Skybox.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_sunExt 1 1 1 75 87 3 11 16
	q3map_skylight 35 4
	nopicmip
	skyParms skpk/env/Idm_pink_Skybox/Idm_pink_Skybox - -
}

textures/skies_MASTER2/pains
{
	qer_editorImage skpk/qer/env/pains/sky1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 65 60 27 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 85 4
	nopicmip
	skyParms skpk/env/pains/sky1 - -
}

textures/skies_MASTER/swamp2
{
	qer_editorImage skpk/qer/env/swamp2/swamp2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 105 4
	nopicmip
	skyParms skpk/env/swamp2/swamp2 - -
}

textures/skies_MASTER2/paisaje3
{
	qer_editorImage skpk/qer/env/paisaje3.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 85 4
	nopicmip
	skyParms skpk/env/paisaje3 - -
}

textures/skies_MASTER6/0color_lightBlue_clouds
{
	qer_editorImage skpk/qer/6/0color_lightBlue_clouds.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 155 4
	nopicmip
	skyParms skpk/env/breakasky/sky 1024 -
	{
		map skpk/textures/breaker/breakasky_cloud.tga
		tcMod scale 3 3
		tcMod scroll 0.005 -0.0125
		rgbGen identityLighting
	}
	{
		map skpk/textures/breaker/breakasky_flare.tga
		blendfunc add
		tcMod transform 0.25 0 0 0.25 0.1075 0.1075
		rgbGen identityLighting
	}
}

textures/skies_MASTER6/0color_blue-cyan
{
	qer_editorImage skpk/qer/env/breakasky/sky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 155 4
	nopicmip
	skyParms skpk/env/breakasky/sky 1024 -
}

textures/skies_MASTER2/bug3_skybox
{
	qer_editorImage skpk/qer/env/bug3/skybox.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 65 -29 24 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 85 4
	nopicmip
	skyParms skpk/env/bug3/skybox - -
}

textures/skies_MASTER6/bug5_sky
{
	qer_editorImage skpk/qer/6/bug5_sky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyParms - - -
	{
		map skpk/textures/bug5/sky_sunbeams1_scroll.tga
		tcmod scroll 0.065 0
	}
}

textures/skies_MASTER6/bug5_skybox
{
	qer_editorImage skpk/qer/textures/bug5/sky_sunbeams1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 255 245 230 55 43 38 3 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 55 4
	nopicmip
	skyParms skpk/textures/bug5/sky_sunbeams1 - -
}

textures/skies_MASTER6/0color_grey4
{
	qer_editorImage skpk/qer/env/bug6/skybox.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 85 4
	nopicmip
	skyParms skpk/env/bug6/skybox - -
}

textures/skies_MASTER6/bug_bluesky1
{
	qer_editorImage skpk/qer/6/bug_bluesky1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 125 4
	nopicmip
	skyParms - 512 -
	{
		map skpk/textures/bugtures/bug_skies/blueskyclouds.tga
		tcMod scroll 0.01 0.01
		tcMod scale 3 3
		depthWrite
	}
	{
		map skpk/textures/bugtures/bug_skies/blueskybase.tga
		blendfunc add
		tcMod scroll -0.01 -0.01
		tcMod scale 5 5
	}
}

textures/skies_MASTER2/strangecloudy01
{
	qer_editorImage skpk/qer/env/sky_strangecloudy01/strangecloudy_01.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 125 4
	nopicmip
	skyParms skpk/env/sky_strangecloudy01/strangecloudy_01 - -
}

textures/skies_MASTER2/52h05skies
{
	qer_editorImage skpk/qer/env/52h05.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 60 152 24 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 80 4
	nopicmip
	skyParms skpk/env/52h05 - -
}

textures/skies_MASTER/mp_depression-clouds
{
	qer_editorImage skpk/qer/env/mp_depression/depression-pass-clouds.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 90 4
	nopicmip
	skyParms skpk/env/mp_depression/depression-pass 1024 -
	{
		map skpk/env/cloudsGl01.tga
		tcmod scroll 0.02 0.002
		blendfunc blend
	}
}

textures/skies_MASTER2/mlkw01-clouds
{
	qer_editorImage skpk/qer/env/mlkw01-clouds.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 120 4
	nopicmip
	skyParms skpk/env/mlkw01 512 -
	{
		map skpk/env/cloudsGl01.tga
		tcmod scroll 0.009 0.001
		blendfunc blend
	}
}

textures/skies_MASTER2/terra1
{
	qer_editorImage skpk/qer/textures/skies/env/terra1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 40 46 30 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 95 4
	nopicmip
	skyParms skpk/textures/skies/env/terra1 - -
}

textures/skies_MASTER2/devilish
{
	qer_editorImage skpk/qer/textures/skies/env/devilish.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 40 -18 21 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 95 4
	nopicmip
	skyParms skpk/textures/skies/env/devilish - -
}

//no comment
textures/skies_MASTER6/nes_comic
{
	qer_editorImage skpk/qer/6/nes_comic.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 125 4
	nopicmip
	skyParms skpk/env/nes_comic/nes_comic 512 -
	{
		map skpk/env/nes_comic/pinkclouds.tga
		tcMod scale 3 3
		tcMod scroll 0.2 -0.125
		blendfunc add
		rgbGen identity
	}
}

textures/skies_MASTER2/sky_22
{
	qer_editorImage skpk/qer/env/sky_22/sky22.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 120 4
	nopicmip
	skyParms skpk/env/sky_22/sky22 - -
}

textures/skies_MASTER2/sky_8
{
	qer_editorImage skpk/qer/env/sky_8/sky8.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 65 -103 24 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 85 4
	nopicmip
	skyParms skpk/env/sky_8/sky8 - -
}

textures/skies_MASTER2/sky_45
{
	qer_editorImage skpk/qer/env/sky_45/sky45.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 125 4
	nopicmip
	skyParms skpk/env/sky_45/sky45 - -
}

textures/skies_MASTER2/sky_16
{
	qer_editorImage skpk/qer/env/sky_16/sky16.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyParms skpk/env/sky_16/sky16 - -
}

textures/skies_MASTER2/sky_46
{
	qer_editorImage skpk/qer/env/sky_46/sky46.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 125 4
	nopicmip
	skyParms skpk/env/sky_46/sky46 - -
}

textures/skies_MASTER2/sky_47
{
	qer_editorImage skpk/qer/env/sky_47/sky47.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 125 4
	nopicmip
	skyParms skpk/env/sky_47/sky47 - -
}

textures/skies_MASTER2/sky_beta
{
	qer_editorImage skpk/qer/env/beta/beta.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 55 61 3 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 85 4
	nopicmip
	skyParms skpk/env/beta/beta - -
}

textures/skies_MASTER2/mlkw01
{
	qer_editorImage skpk/qer/env/mlkw01.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 111 4
	nopicmip
	skyParms skpk/env/mlkw01 - -
}

textures/skies_MASTER2/spacedonald
{
	qer_editorImage skpk/qer/env/spacedonald/spacedonald1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyParms skpk/env/spacedonald/spacedonald1 - -
}

textures/skies_MASTER6/cardigan_purpNebula2
{
	qer_editorImage skpk/qer/6/cardigan_purpNebula2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyParms - 512 -
	{
		map skpk/textures/cardigan_skies1/dense_purple_nebula.tga
		tcMod scroll 0.05 .1
		tcMod scale 2 2
	}
	{
		map skpk/textures/cardigan_skies1/sparse_purple_nebula.tga
		blendfunc add
		tcMod scroll 0.05 0.06
		tcMod scale 3 2
	}
}

textures/skies_MASTER6/act_sky
{
	qer_editorImage skpk/qer/6/act_sky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyParms - 512 -
	{
		map skpk/textures/act/act_sky1.tga
		tcMod scroll 0.4 0.2
		tcMod scale 3 2
	}
	{
		map skpk/textures/act/act_sky1_overlay.tga
		blendFunc add
		tcMod scroll 0.7 0.7
		tcMod scale 3 3
	}
}

textures/skies_MASTER6/altsky02
{
	qer_editorImage skpk/qer/6/altsky02.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyParms - 512 -
	{
		map skpk/textures/altsky2/sky02.tga
		tcMod scale 3 2
		tcMod scroll 0.15 0.15
		depthWrite
	}
	{
		map textures/skies/topclouds.tga
		blendfunc add
		tcMod scale 3 3
		tcMod scroll 0.05 0.05
	}
}

textures/skies_MASTER6/bug_pixels
{
	qer_editorImage skpk/qer/6/bug_pixels.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 130 4
	nopicmip
	skyParms - 512 -
	{
		map skpk/textures/bug_pixels/bluedimclouds_pixels.tga
		tcMod scale 3 2
		tcMod scroll 0.15 0.15
	}
	{
		map skpk/textures/bug_pixels/topclouds_pixels.tga
		blendfunc add
		tcMod scale 3 3
		tcMod scroll 0.05 0.05
	}
}

textures/skies_MASTER2/celaria
{
	qer_editorImage skpk/qer/textures/celaria/celaria_skybox.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_lightRGB 161 220 247
	q3map_skylight 150 4 0 90 0
	nopicmip
	skyParms skpk/textures/celaria/celaria_skybox - -
}

textures/skies_MASTER2/crater-lake
{
	qer_editorImage skpk/qer/env/crater-lake/crater-lake.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 10 64 20 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 120 4
	nopicmip
	skyParms skpk/env/crater-lake/crater-lake - -
}

textures/skies_MASTER2/ct_skybox
{
	qer_editorImage skpk/qer/env/ct/skybox.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 60 -89 9 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 85 4
	nopicmip
	skyParms skpk/env/ct/skybox - -
}

textures/skies_MASTER2/cyberpunk-street
{
	qer_editorImage skpk/qer/env/cyberpunk-street.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 130 4
	nopicmip
	skyParms skpk/env/cyberpunk-street - -
}

textures/skies_MASTER3/avoc_darkness-terr-clouds2
{
	qer_editorImage skpk/qer/textures/toxic_facility_skybox/darkness_sky-clouds2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 15 -94 51 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 110 4
	nopicmip
	skyParms skpk/textures/toxic_facility_skybox/darkness_sky 2048 -
	{
		map skpk/textures/eltz/env/eltz_clouds2.tga
		blendFunc filter
		tcMod scroll 0.005 0.005
		tcMod scale 2 2
	}
}

textures/skies_MASTER2/dunes2
{
	qer_editorImage skpk/qer/env/dunes2/dunes2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 70 -30 47 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 85 4
	nopicmip
	skyParms skpk/env/dunes2/dunes2 - -
}

textures/skies_MASTER6/eksha_q1-sky4
{
	qer_editorImage skpk/qer/6/eksha_q1-sky4.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyParms - 512 -
	{
		map skpk/textures/quake1textureshd/sky4_solid.tga
		tcMod scale 5 5
		tcMod scroll -0.04 -0.04
	}
	{
		map skpk/textures/quake1textureshd/sky4_alpha_asd.tga
		blendfunc add
		tcMod scale 10 10
		tcMod scroll -0.16 -0.16
	}
}

textures/skies_MASTER6/0color_blue-dodger
{
	qer_editorImage skpk/qer/env/ekshabluesky/asd.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 150 4
	nopicmip
	skyParms skpk/env/ekshabluesky/asd - -
}

textures/skies_MASTER6/fueldumpsky
{
	qer_editorImage skpk/qer/6/fueldumpsky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 120 4
	nopicmip
	skyParms - 200 -
	{
		map skpk/textures/skies/fueldump_clouds.tga
		rgbGen identitylighting
	}
	{
		map skpk/textures/skies/fueldump_clouds.tga
		blendfunc blend
		rgbGen identitylighting
		tcMod scroll 0.007 0.00
		tcMod scale 2 1
	}
}

textures/skies_MASTER2/fysokolskybox
{
	qer_editorImage skpk/qer/textures/fy_sokol/fysokolskybox.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 65 33 81 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 85 4
	nopicmip
	skyParms skpk/textures/fy_sokol/fysokolskybox - -
}

textures/skies_MASTER6/kaw_stadium
{
	qer_editorImage skpk/qer/6/kaw_stadium.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyParms - 128 -
	{
		map skpk/textures/kaw-stadium/clouds.tga
		tcMod scroll 0.001 0.001
		tcMod scale 3 3
		depthWrite
	}
	{
		map skpk/textures/kaw-stadium/sky-dark.tga
		blendfunc add
		tcMod scroll -0.001 -0.001
		tcMod scale 5 5
	}
}

textures/skies_MASTER6/0color_whiteLick-serenity
{
	qer_editorImage skpk/qer/6/0color_whiteLick-serenity.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 55 -31 64 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyParms skpk/textures/lick-serenity/lick_sky019/env/sky 1200 -
	{
		map skpk/textures/lick-serenity/lick_sky019/lick_sky019v2.tga
		tcMod scroll 0.025 -0.0145
		tcMod scale 2 2
		rgbGen identityLighting
	}
	{
		map skpk/textures/lick-serenity/lick_sky019/lick_sky019_mask.tga
		blendFunc GL_ONE_MINUS_SRC_ALPHA GL_SRC_ALPHA
		tcMod transform 0.25 0 0 0.25 0.1075 0.1075
		rgbGen identityLighting
	}
}

textures/skies_MASTER6/0color_white2
{
	qer_editorImage skpk/qer/textures/lick-serenity/lick_sky019/env/sky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 95 4
	nopicmip
	skyParms skpk/textures/lick-serenity/lick_sky019/env/sky 1200 -
}

textures/skies_MASTER/nec_hell-acid
{
	qer_editorImage skpk/qer/env/mario64df/bowser1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyParms skpk/env/mario64df/bowser1 - -
}

textures/skies_MASTER2/shortest_skyx2
{
	qer_editorImage skpk/qer/env/sky2/sky2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 125 4
	nopicmip
	skyParms skpk/env/sky2/sky2 - -
}

textures/skies_MASTER6/0color_whiteSkyBlue
{
	qer_editorImage skpk/qer/textures/sl1k_smk/bluesky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyParms skpk/textures/sl1k_smk/bluesky - -
}

textures/skies_MASTER6/0color_daySky
{
	qer_editorImage skpk/qer/textures/sl1k_smk/donutsky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyParms skpk/textures/sl1k_smk/donutsky - -
}

textures/skies_MASTER6/0color_sea
{
	qer_editorImage skpk/qer/textures/sl1k_smk/seasky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 150 4
	nopicmip
	skyParms skpk/textures/sl1k_smk/seasky - -
}

textures/skies_MASTER6/0color_fire
{
	qer_editorImage skpk/qer/textures/sl1k_smk/firesky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyParms skpk/textures/sl1k_smk/firesky - -
}

textures/skies_MASTER6/0color_snow
{
	qer_editorImage skpk/qer/textures/sl1k_smk/snowsky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 105 4
	nopicmip
	skyParms skpk/textures/sl1k_smk/snowsky - -
}

textures/skies_MASTER6/0color_night
{
	qer_editorImage skpk/qer/textures/sl1k_smk/nightsky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 145 4
	nopicmip
	skyParms skpk/textures/sl1k_smk/nightsky - -
}

textures/skies_MASTER6/0color_late
{
	qer_editorImage skpk/qer/textures/sl1k_smk/latesky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 105 4
	nopicmip
	skyParms skpk/textures/sl1k_smk/latesky - -
}

textures/skies_MASTER2/sl1k_smk_ghostsky
{
	qer_editorImage skpk/qer/textures/sl1k_smk/ghostsky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 155 4
	nopicmip
	skyParms skpk/textures/sl1k_smk/ghostsky - -
}

textures/skies_MASTER6/meth_clouds_green
{
	qer_editorImage skpk/qer/6/meth_clouds_green.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyParms - 512 -
	{
		map skpk/textures/slide7hd/meth_clouds_green.tga
		tcMod scale 3 2
		tcMod scroll 0.04 0.04
		depthWrite
	}
	{
		map skpk/textures/slide7hd/meth_clouds_green2.tga
		blendfunc filter
		tcMod scale 10 10
		tcMod scroll .1 .1
	}
	{
		map textures/skies/topclouds.tga
		blendfunc add
		tcMod scale 3 3
		tcMod scroll 0.09 0.09
	}
}

textures/skies_MASTER2/slideballzsky
{
	qer_editorImage skpk/qer/textures/slideballz/slideballzsky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyParms skpk/textures/slideballz/slideballzsky - -
}

textures/skies_MASTER2/xLarve_darky2
{
	qer_editorImage skpk/qer/env/xLarve_darky2/xLarve_darky2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 55 174 10 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 85 4
	nopicmip
	skyParms skpk/env/xLarve_darky2/xLarve_darky2 - -
}

textures/skies_MASTER6/crn_schadq3w1
{
	qer_editorImage skpk/qer/6/crn_schadq3w1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms - 1400 -
	{
		map skpk/textures/crn_schadq3w1/clouds1.tga
		tcMod scroll 0.08 0.02
		tcMod scale 1 1.5
	}
	{
		map skpk/textures/crn_schadq3w1/clouds.tga
		blendfunc add
		tcMod scroll 0.08 0.01
		tcMod scale 1 3
	}
}

textures/skies_MASTER6/ikbase_dawn
{
	qer_editorImage skpk/qer/6/ikbase_dawn.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms env/xnight2 512 -
	{
		map skpk/textures/ikbase_sky/ik_sky_dawn_back.tga
		blendfunc add
		tcMod scroll 0.015 0.016
		tcMod scale 3 3
	}
	{
		map skpk/textures/ikbase_sky/ik_sky_night_front.tga
		blendfunc add
		tcMod scroll -0.01 -0.012
		tcMod scale 5 5
	}
}

textures/skies_MASTER6/shaderlab_mars_cha
{
	qer_editorImage skpk/qer/6/cpmctf1_sky2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 65 0 90 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 85 4
	nopicmip
	skyparms skpk/textures/shaderlab_skies/space 512 -
	{
		clampMap skpk/textures/cpmctf1/mars2.tga
		blendfunc blend
		tcMod transform 2.25 0 0 2 -3 -3
		rgbGen identityLighting
	}
	{
		map textures/skies/topclouds.tga
		blendfunc add
		tcMod scale 3 3
		tcMod scroll 0.1 0.1
	}
}

textures/skies_MASTER6/mapel4sky1
{
	qer_editorImage skpk/qer/6/mapel4sky1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms - 256 -
	{
		map skpk/textures/mapel4/clouds1.tga
		tcMod scale 3 3
		tcMod scroll 0.012 0.015
		depthWrite
	}
	{
		map skpk/textures/mapel4/skytes1.tga
		blendfunc add
		tcMod scale 5 5
		tcMod scroll -0.010 -0.12
	}
}

textures/skies_MASTER6/shaderlab_stars
{
	qer_editorImage skpk/qer/6/shaderlab_stars.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 99 4 0 90 0
	nopicmip
	skyParms skpk/textures/shaderlab_skies/black 1200 -
	{
		map skpk/textures/qxctf2_base/qxctf2_stars.tga
		blendfunc add
		rgbGen identity
	}
}

textures/skies_MASTER6/silentrun
{
	qer_editorImage skpk/qer/6/silentrun.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 65 -37 35 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 85 4
	nopicmip
	skyparms skpk/textures/silentrun/env/alpine 1500 -
	{
		map skpk/textures/silentrun/skybox_mask.tga
		blendFunc GL_ONE_MINUS_SRC_ALPHA GL_SRC_ALPHA
		tcMod transform 0.25 0 0 0.25 0.1075 0.1075
		rgbGen identityLighting
	}
}

textures/skies_MASTER6/dark_n_stormy
{
	qer_editorImage skpk/qer/6/dark_n_stormy.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 10 -90 80 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 110 4
	nopicmip
	skyparms skpk/textures/twbb/backsky 512 -
	{
		map skpk/textures/twbb/dark_n_stormy.tga
		blendfunc add
		tcMod scale 3 2.5
		tcMod scroll 0.005 0.01
		rgbGen identityLighting
	}
}

//top (ceiling) sky only
textures/skies_MASTER6/13octo_sky
{
	qer_editorImage skpk/qer/6/13octo_sky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyParms - 8000 -
	{
		map skpk/textures/13octo/sky.tga
		tcMod scale 0.15 0.3981
		tcMod scroll 0.01 0
	}
}

textures/skies_MASTER6/0color_black-ebony
{
	qer_editorImage skpk/qer/env/5th_foghull/fog_hull1/foghull1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyparms skpk/env/5th_foghull/fog_hull1/foghull1 - -
}

textures/skies_MASTER6/0color_green-camo
{
	qer_editorImage skpk/qer/env/5th_foghull/fog_jung/fogjung.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyparms skpk/env/5th_foghull/fog_jung/fogjung - -
}

textures/skies_MASTER2/5th_dskdesrt-clouds
{
	qer_editorImage skpk/qer/env/5th_dskdesrt/desrtsky-clouds.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 255 250 222 70 -30 44 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 60 4
	nopicmip
	skyparms skpk/env/5th_dskdesrt/desrtsky - -
	{
		map skpk/textures/5th_clouds/clouds-3.tga
		blendfunc blend
		tcMod scale 3 3
		tcMod scroll 0.003 0.005
	}
}

textures/skies_MASTER6/9osky
{
	qer_editorImage skpk/qer/6/9osky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms - 180 -
	{
		map skpk/textures/9oclock/9osky2.tga
		tcMod scroll -0.002 -0.003
		tcMod scale 9 9
	}
}

textures/skies_MASTER6/fx_dm3sky
{
	qer_editorImage skpk/qer/6/fx_dm3sky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms - 512 -
	{
		map skpk/textures/acc_dm3/sp_flatsky.tga
	}
	{
		map skpk/textures/acc_dm3/sp_flatsky2.tga
		blendfunc blend
		tcMod scroll 0.002 0.01
		tcMod scale 3 3
		rgbgen identity
	}
}

textures/skies_MASTER6/necronomicon_sky_1
{
	qer_editorImage skpk/qer/6/necronomicon_sky_1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyParms - 512 -
	{
		map textures/skies/killsky_1.tga
		rgbGen identity
		tcMod scroll 0.02 0.02
		tcMod scale 5 4
		depthWrite
	}
	{
		map textures/skies/dimclouds.tga
		blendfunc add
		rgbGen identity
		tcMod scroll 0.01 0.01
		tcMod scale 4 5
	}
}

textures/skies_MASTER2/railfest_sky
{
	qer_editorImage skpk/qer/textures/ailfest2b/env/rail.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 120 4
	nopicmip
	skyparms skpk/textures/ailfest2b/env/rail - -
}

textures/skies_MASTER/mp_badomen-noComet
{
	qer_editorImage skpk/qer/env/badomen512.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_sunExt 228 81 11 50 64 3 8 16
	q3map_skylight 60 4
	nopicmip
	skyparms skpk/env/badomen512 - -
}

textures/skies_MASTER/box20
{
	qer_editorImage skpk/qer/env/box20/box20.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 55 -179 17 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 90 4
	nopicmip
	skyparms skpk/env/box20/box20 - -
}

textures/skies_MASTER/box25
{
	qer_editorImage skpk/qer/env/box25/box25.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 0.828931 0.358022 65 179 6 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 95 4
	nopicmip
	skyparms skpk/env/box25/box25 - -
}

textures/skies_MASTER6/brad_sky_blue
{
	qer_editorImage skpk/qer/6/brad_sky_blue.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms - 1024 -
	{
		map skpk/textures/centipede/darkbluesky.tga
		tcMod scale 3 2
		tcMod scroll 0.01 0.01
		depthWrite
	}
	{
		map textures/skies/pjbasesky.tga
		blendfunc add
		tcMod scale 3 3
		tcMod scroll 0.05 0.05
	}
}

textures/skies_MASTER6/greencarbonsky
{
	qer_editorImage skpk/qer/6/greencarbonsky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms - 512 -
	{
		map skpk/textures/carbon/green.tga
		tcMod scale 3 2
		tcMod scroll 0.012 0.012
		depthWrite
	}
}

textures/skies_MASTER6/catq3ctf01-blue_sky
{
	qer_editorImage skpk/qer/6/catq3ctf01-blue_sky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 125 4
	nopicmip
	skyparms - 512 -
	{
		map skpk/textures/catq3ctf01/dim_blue_clouds.tga
		tcMod scale 3 2
		tcMod scroll 0.25 0.25
		depthWrite
	}
	{
		map skpk/textures/catq3ctf01/blue_clouds.tga
		blendfunc add
		tcMod scale 3 3
		tcMod scroll 0.05 0.05
	}
}

textures/skies_MASTER6/catq3ctf01-red_sky
{
	qer_editorImage skpk/qer/6/catq3ctf01-red_sky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 125 4
	nopicmip
	skyparms - 512 -
	{
		map skpk/textures/catq3ctf01/dim_red_clouds.tga
		tcMod scale 3 2
		tcMod scroll 0.25 0.25
		depthWrite
	}
	{
		map skpk/textures/catq3ctf01/red_clouds.tga
		blendfunc add
		tcMod scale 3 3
		tcMod scroll 0.05 0.05
	}
}

textures/skies_MASTER6/0color_terra_clouds
{
	qer_editorImage skpk/qer/6/0color_terra_clouds.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms skpk/textures/shaderlab_skybox/env/sky 512 -
	{
		map skpk/textures/ikbase_sky/ik_sky_day_back.tga
		tcMod scale 2 2
		tcMod scroll 0.01 0.01
		rgbGen identityLighting
	}
	{
		clampmap skpk/textures/slterra/sky_arc_masked.tga
		blendfunc blend
		tcMod scale 0.956 0.956
		tcMod transform 1 0 0 1 -1 -1
		rgbGen identityLighting
	}
}

textures/skies_MASTER6/centipede_whitesky
{
	qer_editorImage skpk/qer/6/centipede_whitesky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms - 320 -
	{
		map skpk/textures/centipede/darkbluesky.tga
		tcMod scroll 0.01 0.01
		tcMod scale 6 4
		depthWrite
	}
	{
		map skpk/textures/centipede/bluesky2_cent.tga
		blendfunc add
		tcMod scroll 0.025 0.025
		tcMod scale 6 6
	}
}

textures/skies_MASTER6/ctfmikie
{
	qer_editorImage skpk/qer/6/ctfmikie.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 125 4
	nopicmip
	skyparms - 256 -
	{
		map skpk/textures/ctfmikie/clouds1.tga
		tcMod scale 3 2
		tcMod scroll 0.025 0.025
		depthWrite
	}
	{
		map skpk/textures/ctfmikie/clouds2.tga
		blendfunc add
		tcMod scale 3 3
		tcMod scroll 0.015 0.015
	}
}

textures/skies_MASTER6/ct_ct3ctf2_dark2
{
	qer_editorImage skpk/qer/6/ct_ct3ctf2_dark2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms - 256 -
	{
		map skpk/textures/ct_ct3ctf2/env/sky_dark_2.tga
		tcMod scale 10 10
		tcMod scroll .05 .09
		depthWrite
	}
	{
		map skpk/textures/ct_ct3ctf2/env/sky_dark.tga
		blendfunc add
		tcMod scale 4 4
		tcMod scroll 0.01 0.01
	}
}

textures/skies_MASTER6/sunsetsky
{
	qer_editorImage skpk/qer/6/sunsetsky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms - 800 -
	{
		map textures/skies/pjbasesky.tga
		tcMod scroll .002 .004
		depthWrite
	}
	{
		blendfunc add
		map textures/skies/intelredclouds.tga
		blendfunc filter
		tcMod scroll 0.008 0.006
		tcMod scale 4 2
	}
}

textures/skies_MASTER6/camo_bluesky
{
	qer_editorImage skpk/qer/6/camo_bluesky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 165 4
	nopicmip
	skyparms - 512 -
	{
		map skpk/textures/_tpmc/tpmc_bluesky1.tga
		tcMod scroll 0.05 .1
		tcMod scale 2 2
	}
	{
		map skpk/textures/_tpmc/tpmc_bluesky2.tga
		blendfunc add
		tcMod scroll 0.05 0.06
		tcMod scale 3 2
	}
}

textures/skies_MASTER6/camo_redsky
{
	qer_editorImage skpk/qer/6/camo_redsky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 165 4
	nopicmip
	skyparms - 512 -
	{
		map skpk/textures/_tpmc/tpmc_redsky1.tga
		tcMod scroll 0.05 .1
		tcMod scale 2 2
	}
	{
		map skpk/textures/_tpmc/tpmc_redsky2.tga
		blendfunc add
		tcMod scroll 0.05 0.06
		tcMod scale 3 2
	}
}

textures/skies_MASTER6/dwsky
{
	qer_editorImage skpk/qer/6/dwsky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms - 512 -
	{
		map skpk/textures/dw/dwsky1.tga
		tcMod scale 3 2
		tcMod scroll 0.05 0.05
		depthWrite
	}
	{
		map skpk/textures/dw/dwsky2.tga
		blendfunc add
		tcMod scale 3 3
		tcMod scroll 0.015 0.015
	}
}

textures/skies_MASTER/eggdm1sky-clouds
{
	qer_editorImage skpk/qer/env/eggdm1sky-clouds.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 45 -30 24 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 85 4
	nopicmip
	skyparms skpk/env/eggdm1sky 512 -
	{
		map skpk/textures/eggdm1/eggdm1sky.tga
		tcmod scroll .0004 .0008
		blendfunc add
	}
}

textures/skies_MASTER4/entropy
{
	qer_editorImage skpk/qer/textures/entropy/env/entropy.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 45 34 60 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 90 4
	nopicmip
	skyparms skpk/textures/entropy/env/entropy - -
}

textures/skies_MASTER6/equinox_nebula
{
	qer_editorImage skpk/qer/6/equinox_nebula.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyparms skpk/textures/equinox_env/nebula3 - -
	{
		map skpk/textures/common/ex_plazma_blue.tga
		blendfunc filter
		tcMod scroll -0.03 -0.03
		tcMod scale 5 5
	}
}

textures/skies_MASTER2/golf-clouds
{
	qer_editorImage skpk/qer/env/golf-clouds.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 255 255 240 80 120 25 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 60 4
	nopicmip
	skyparms skpk/env/golf - -
	{
		map skpk/textures/golf/clouds.tga
		blendfunc blend
		tcmod scale 3 3
		tcMod scroll 0.1 0.1
	}
}

textures/skies_MASTER/jf_canyon
{
	qer_editorImage skpk/qer/env/jf-canyon/mine.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 65 137 50 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 85 4
	nopicmip
	skyparms skpk/env/jf-canyon/mine - -
}

textures/skies_MASTER6/hellctfsky
{
	qer_editorImage skpk/qer/6/hellctfsky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 165 4
	nopicmip
	skyparms - 512 -
	{
		map textures/skies/killsky_1.tga
		tcMod scroll 0.1 0.1
		tcMod scale 3 2
		depthWrite
	}
	{
		map textures/skies/killsky_2.tga
		blendfunc add
		tcMod scroll 0.05 0.05
		tcMod scale 3 3
	}
}

textures/skies_MASTER6/japanc_q3w_bluesky
{
	qer_editorImage skpk/qer/6/japanc_q3w_bluesky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_lightRGB 62 77 88
	q3map_skylight 70 4
	nopicmip
	skyparms - 512 -
	{
		map textures/skies/bluedimclouds.tga
		tcMod scale 3 2
		tcMod scroll 0.015 0.015
		depthWrite
	}
	{
		map skpk/textures/japanc_q3w/bluesky1.tga
		blendfunc add
		tcMod scale 3 3
		tcMod scroll 0.01 0.01
	}
}

textures/skies_MASTER6/japanc-ta_bluesky
{
	qer_editorImage skpk/qer/6/japanc-ta_bluesky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 130 4
	nopicmip
	skyparms - 512 -
	{
		map skpk/textures/skies/nightsky.tga
		tcMod scale 3 2
		tcMod scroll 0.015 0.015
		depthWrite
	}
	{
		map skpk/textures/japanc_q3w/bluesky1.tga
		blendfunc add
		tcMod scale 3 3
		tcMod scroll 0.01 0.01
	}
}

textures/skies_MASTER6/Eveningsky2
{
	qer_editorImage skpk/qer/6/Eveningsky2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms - 512 -
	{
		map skpk/textures/skies/sky_blue.tga
		tcMod scale 1 1
		depthWrite
	}
}

textures/skies_MASTER6/tim_dm14_b
{
	qer_editorImage skpk/qer/6/tim_dm14_b.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 125 4
	nopicmip
	skyparms - 512 -
	{
		map skpk/textures/ra3combat2/bluesky4.tga
		tcMod scroll 0.05 .1
		tcMod scale 2 2
		depthWrite
	}
	{
		map skpk/textures/ra3combat2/bluesky3.tga
		blendfunc add
		tcMod scroll 0.05 0.06
		tcMod scale 3 2
	}
}

textures/skies_MASTER6/jokictf2sky
{
	qer_editorImage skpk/qer/6/jokictf2sky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 0.647898 0.437278 65 -108 2 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 85 4
	nopicmip
	skyparms skpk/textures/joki_sky/jokictf2sky - -
	{
		map textures/skies/topclouds.tga
		blendfunc add
		tcMod scroll 0.02 0.025
		tcMod scale 3 2
	}
}

textures/skies_MASTER6/pj_ctf1sky_slow
{
	qer_editorImage skpk/qer/6/pj_ctf1sky_slow.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms - 512 -
	{
		map textures/skies/dimclouds.tga
		tcMod scroll 0.003 0.003
		tcMod scale 3 3
		depthWrite
	}
	{
		map textures/skies/pjbasesky.tga
		blendfunc add
		tcMod scroll -0.01 -0.012
		tcMod scale 5 5
	}
}

textures/skies_MASTER6/0color_blue-geyser
{
	qer_editorImage skpk/qer/env/kingdomsky/kingdomsky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 110 4
	nopicmip
	skyparms skpk/env/kingdomsky/kingdomsky - -
}

textures/skies_MASTER2/kireimagicsky02
{
	qer_editorImage skpk/qer/textures/kirei/kachu.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.961898 0.675624 0.140307 75 90 24 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 85 4
	nopicmip
	skyparms skpk/textures/kirei/kachu - -
}

textures/skies_MASTER/jf_nebula-rotated
{
	qer_editorImage skpk/qer/textures/leone3ctf1/env/leoNebular.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 35 180 2 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_sunExt 255 245 245 15 -110 50 8 16                //top nebula
	q3map_sunExt 255 245 245 35 -92 12 11 16                //bottom nebula
	q3map_skylight 85 4
	nopicmip
	skyparms skpk/textures/leone3ctf1/env/leoNebular - -
}

textures/skies_MASTER/nebula3-grid-blue
{
	qer_editorImage skpk/qer/textures/flat/env/nebulax.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 90 4
	nopicmip
	skyparms skpk/textures/flat/env/nebulax - -
}

textures/skies_MASTER6/thirdsign-cloud
{
	qer_editorImage skpk/qer/6/thirdsign-cloud.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms skpk/textures/thirdsign/env/sky 1500 -
	{
		map skpk/textures/thirdsign/clouds.tga
		tcMod scroll 0.0055 -0.005
		blendFunc blend
		rgbGen identityLighting
	}
	{
		map skpk/textures/thirdsign/mask.tga
		blendFunc GL_ONE_MINUS_SRC_ALPHA GL_SRC_ALPHA
		tcMod transform 0.25 0 0 0.25 0.1075 0.1075
		rgbGen identityLighting
	}
}

textures/skies_MASTER6/0color_blueDusk_clouds
{
	qer_editorImage skpk/qer/6/0color_blueDusk_clouds.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 125 4
	nopicmip
	skyparms skpk/textures/mister_sky/env/sky_blue_dusk 512 -
	{
		map skpk/textures/mister_sky/sky_blue_dusk.tga
		tcMod scale 3 3
		tcMod scroll 0.005 -0.0125
		rgbGen identityLighting
	}
	{
		clampmap skpk/textures/mister_sky/sky_blue_dusk_mask.tga
		blendfunc blend
		tcMod scale 0.956 0.956
		tcMod transform 1 0 0 1 -1 -1
		rgbGen identityLighting
	}
}

textures/skies_MASTER6/0color_peach
{
	qer_editorImage skpk/qer/textures/mister_sky/env/sky_blue_dusk.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyparms skpk/textures/mister_sky/env/sky_blue_dusk 512 -
}

textures/skies_MASTER2/moon2
{
	qer_editorImage skpk/qer/textures/moon/moon2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyParms skpk/textures/moon/moon2 - -
}

textures/skies_MASTER2/spmoon
{
	qer_editorImage skpk/qer/textures/moon/spmoon.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_lightRGB 255 255 255
	q3map_skylight 135 4 0 90 0
	nopicmip
	skyParms skpk/textures/moon/spmoon - -
}

textures/skies_MASTER/nebula3bw
{
	qer_editorImage skpk/qer/textures/nkstrmp1/nebula3remake.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms skpk/textures/nkstrmp1/nebula3remake - -
}

textures/skies_MASTER6/noval_darksky
{
	qer_editorImage skpk/qer/6/noval_darksky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms - 512 -
	{
		map skpk/textures/nova1/dimclouds.tga
		tcMod scroll 0.05 0
		tcMod scale 2 2
		depthWrite
	}
}

textures/skies_MASTER6/noval_lightning
{
	qer_editorImage skpk/qer/6/noval_lightning.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms - 512 -
	{
		map skpk/textures/nova1/dimclouds.tga
		tcMod scroll 0.05 0
		tcMod scale 2 2
		depthWrite
	}
	{
		map skpk/textures/nova1/skylightning.tga
		rgbGen wave square 0 1 0 .125
		blendfunc add
		tcMod scale .01 1
		tcMod scroll 1 0
	}
}

textures/skies_MASTER2/nuke_arctic
{
	qer_editorImage skpk/qer/textures/nuke/arctic.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.939895 0.755322 0.470924 40 -15 14 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 90 4
	nopicmip
	skyparms skpk/textures/nuke/arctic - -
}

textures/skies_MASTER2/olispace
{
	qer_editorImage skpk/qer/textures/olictf/env/olispace.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms skpk/textures/olictf/env/olispace - -
}

textures/skies_MASTER6/purpclouds
{
	qer_editorImage skpk/qer/6/purpclouds.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms - 256 -
	{
		map skpk/textures/skies/s3.tga
		tcmod scale 2 3
		tcmod scroll 0.018 -0.025
	}
	{
		map skpk/textures/skies/s4.tga
		blendfunc filter
		tcmod scale 3 2
		tcmod scroll 0.023 -0.016
	}
	{
		map skpk/textures/skies/s14.tga
		blendfunc filter
		tcmod scale 2 3
		tcmod scroll 0.015 0.025
	}
}

textures/skies_MASTER2/bl4b_darkHighClouds
{
	qer_editorImage skpk/qer/env/bl4b_darkHighClouds.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 20 138 59 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 95 4
	nopicmip
	skyparms skpk/env/bl4b 512 -
	{
		map skpk/textures/tc_skies/clouds_high.tga
		blendfunc add
		tcMod scale 3 3
		tcMod scroll 0.005 0.007
	}
	{
		map skpk/textures/tc_skies/clouds_dark.tga
		blendfunc add
		tcMod scale 3 3
		tcMod scroll 0.03 0.03
	}
}

textures/skies_MASTER6/0color_gradientBlue_clouds
{
	qer_editorImage skpk/qer/6/0color_gradientBlue_clouds.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 140 4
	nopicmip
	skyparms skpk/env/hdsbox2 128 -
	{
		map skpk/textures/tc_skies/clouds.tga
		blendfunc blend
		depthwrite
		tcmod scale 3 3
		tcmod scroll 0.0005 0.001
	}
	{
		map skpk/textures/tc_skies/clouds.tga
		blendfunc add
		depthwrite
		tcmod scale 3 3
		tcmod scroll 0.001 0.003
	}
}

textures/skies_MASTER6/hds_daysky
{
	qer_editorImage skpk/qer/6/hds_daysky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms skpk/textures/q3tc_cc2/hds2/hdsbox2 128 -
	{
		map skpk/textures/tc_skies/clouds.tga
		blendfunc blend
		depthWrite
		tcMod scale 3 3
		tcMod scroll 0.0005 0.001
	}
	{
		map skpk/textures/tc_skies/clouds.tga
		blendfunc add
		depthWrite
		tcMod scale 3 3
		tcMod scroll 0.001 0.003
	}
}

textures/skies_MASTER6/s_bluehell
{
	qer_editorImage skpk/qer/6/s_bluehell.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms - 256 -
	{
		map skpk/textures/ra3combat2/bluesky1.tga
		tcMod scroll 0.05 -.1
		tcMod scale 4 4
		depthWrite
	}
	{
		map skpk/textures/ra3combat2/bluesky2.tga
		blendfunc add
		tcMod scroll 0.05 -0.06
		tcMod scale 6 4
	}
}

textures/skies_MASTER6/redsky-flash
{
	qer_editorImage skpk/qer/6/redsky-flash.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 125 4
	nopicmip
	skyparms - 1024 -
	{
		map textures/skies/killsky_1.tga
		tcMod scroll 0.05 .1
		tcMod scale 2 2
		depthWrite
	}
	{
		map textures/sfx/proto_zzztpink.tga
		blendfunc filter
		tcMod scroll 0.04 0.05
		tcMod scale 3 2
		rgbGen wave noise 0.75 0.25 0 10
	}
}

textures/skies_MASTER6/light_blue_clouds
{
	qer_editorImage skpk/qer/6/light_blue_clouds.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_lightRGB 188 188 255
	q3map_skylight 99 4 0 90 0
	nopicmip
	skyparms - 5192 -
	{
		map skpk/textures/tblmpak0/light_blue_clouds.tga
		tcMod scroll 0.05 0
		tcMod scale 2 2
		depthWrite
	}
}

textures/skies_MASTER2/lostcolossus-dark
{
	qer_editorImage skpk/qer/textures/titans_ump/colossus_sky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 255 250 240 40 0 90 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 60 4
	nopicmip
	skyparms skpk/textures/titans_ump/colossus_sky - -
}

textures/skies_MASTER4/venus
{
	qer_editorImage skpk/qer/textures/skies2/env/venus.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 160 4
	nopicmip
	skyparms skpk/textures/skies2/env/venus - -
}

textures/skies_MASTER6/darksky_cloudy
{
	qer_editorImage skpk/qer/6/darksky_cloudy.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 125 4
	nopicmip
	skyparms - 512 -
	{
		map textures/skies/pjbasesky.tga
		tcMod scroll 0.005 0.005
		tcMod scale 2 2
		depthWrite
	}
}

textures/skies_MASTER6/0color_black
{
	qer_editorImage skpk/qer/textures/shaderlab_skies/black.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 100 4 0 90 0
	nopicmip
	skyparms skpk/textures/shaderlab_skies/black - -
}

textures/skies_MASTER6/bluecloudsky
{
	qer_editorImage skpk/qer/6/bluecloudsky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 125 4
	nopicmip
	skyparms skpk/env/scrsky/blue/sky - -
	{
		map skpk/textures/scrotch/sky_cloudsblue.tga
		tcMod scroll 0.0025 -0.0075
		rgbGen identityLighting
	}
	{
		map skpk/textures/scrotch/sky_maskblue.tga
		blendFunc GL_ONE_MINUS_SRC_ALPHA GL_SRC_ALPHA
		tcMod transform 0.25 0 0 0.25 0.1075 0.1075
		rgbGen identityLighting
	}
}

textures/skies_MASTER6/0color_blue-carolina2
{
	qer_editorImage skpk/qer/env/scrsky/blue/sky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 125 4
	nopicmip
	skyparms skpk/env/scrsky/blue/sky - -
}

textures/skies_MASTER6/xproto_sky2
{
	qer_editorImage skpk/qer/6/xproto_sky2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms - 512 -
	{
		map skpk/textures/skies/proto_sky.tga
		tcMod scroll .02 .04
		tcMod scale 3 4
		depthWrite
	}
	{
		map skpk/textures/skies/proto_sky2.tga
		blendfunc add
		tcMod scroll 0.005 0.005
		tcMod scale 3 3
	}
}

textures/skies_MASTER/box310
{
	qer_editorImage skpk/qer/env/box310/box310.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 30 88 13 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 95 4
	nopicmip
	skyparms skpk/env/box310/box310 - -
}

textures/skies_MASTER3/simpsons_sky-clouds
{
	qer_editorImage skpk/qer/env/ssky-clouds.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 127 4
	nopicmip
	skyParms skpk/env/ssky 128 -
	{
		map skpk/textures/simpsons-sky/ssky-clouds.tga
		blendfunc add
		tcMod scroll 0.001 0.001
		tcMod scale 8 7
		alphaFunc GE128
	}
}

textures/skies_MASTER6/darkgloomclouds
{
	qer_editorImage skpk/qer/6/darkgloomclouds.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms - 512 -
	{
		map skpk/env/ame_darkgloom/clouds.tga
		tcMod scroll 0.05 0
		tcMod scale 2 2
		depthWrite
	}
}

textures/skies_MASTER3/siberia-clouds
{
	qer_editorImage skpk/qer/env/siberia/siberia-clouds.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 20 -28 20 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 90 4
	nopicmip
	skyparms skpk/env/siberia/siberia - -
	{
		map skpk/textures/sweetnutz2/sn_clouds1.tga
		blendfunc blend
		tcMod scroll 0.005 0.002
		tcMod scale 2 2
	}
}

textures/skies_MASTER/grnplsnt-clouds
{
	qer_editorImage skpk/qer/env/grnplsnt/grnplsnt-clouds.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 120 4
	nopicmip
	skyparms skpk/env/grnplsnt/grnplsnt 512 -
	{
		map textures/skies/topclouds.tga
		blendfunc filter
		tcMod scale 3 3
		tcMod scroll 0.009 0.012
	}
}

textures/skies_MASTER/q3tc_nightsky-clouds
{
	qer_editorImage skpk/qer/env/q3tc_nightsky-clouds.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 5 -77 60 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 125 4
	nopicmip
	skyparms skpk/env/q3tc_nightsky 512 -
	{
		map skpk/textures/q3tc_liq/q3tc_clouds_high.tga
		blendfunc blend
		tcMod scale 3 3
		tcMod scroll 0.003 0.005
	}
}

textures/skies_MASTER2/blk-killsky
{
	qer_editorImage skpk/qer/env/blk-killclouds.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms skpk/env/blk - -
	{
		map skpk/textures/tc_skies/killsky_2.tga
		blendfunc add
		tcmod scale 3 3
		tcmod scroll 0.009 0.012
	}
}

textures/skies_MASTER/q3tc_nightsky-killclouds
{
	qer_editorImage skpk/qer/env/q3tc_nightsky-killclouds.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms skpk/env/q3tc_nightsky 512 -
	{
		map skpk/textures/tc_skies/killsky_2.tga
		blendfunc add
		tcmod scale 3 3
		tcmod scroll 0.003 0.005
	}
}

textures/skies_MASTER2/blk-tclouds
{
	qer_editorImage skpk/qer/env/blk-tclouds.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms skpk/env/blk 512 -
	{
		map skpk/textures/tc_skies/clouds_lc.tga
		blendfunc filter
		tcMod scale 3 3
		tcMod scroll 0.009 0.012
	}
}

textures/skies_MASTER4/ut_turnpike
{
	qer_editorImage skpk/qer/env/turnpike/tp_sky2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 120 4
	nopicmip
	skyparms skpk/env/turnpike/tp_sky2 - -
}

textures/skies_MASTER6/dimclouds-flashing
{
	qer_editorImage skpk/qer/6/dimclouds-flashing.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms - 256 -
	{
		map textures/skies/dimclouds.tga
		tcMod scroll 0.01 0.01
		tcMod scale 3 3
	}
	{
		map textures/skies/pjbasesky.tga
		rgbGen identity
		blendfunc add
		tcMod scroll -0.01 -0.01
		tcMod scale 5 5
	}
	{
		map textures/base_trim/tin.tga
		blendfunc filter
		rgbGen identity
	}
	{
		map skpk/textures/nova1/skylightning.tga
		rgbGen wave square 0 1 0 .25
		blendfunc add
		tcMod scale .01 1
		tcMod scroll 1 0
	}
}

textures/skies_MASTER6/twf_space_sky
{
	qer_editorImage skpk/qer/6/twf_space_sky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 110 4
	nopicmip
	skyparms env/space1 256 -
	{
		map skpk/textures/twf/warp.tga
		blendfunc gl_src_alpha gl_one
		alphaFunc GT0
		tcMod scale 3 3
		tcMod scroll .01 .05
	}
	{
		map skpk/textures/twf/warp.tga
		blendfunc gl_src_alpha gl_one
		alphaFunc GT0
		tcMod scale -1.5 -1.5
		tcMod scroll .01 -.25
	}
}

textures/skies_MASTER6/ut4_suburbs
{
	qer_editorImage skpk/qer/6/ut4_suburbs.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms - 1024 -
	{
		map skpk/textures/ut4_suburbs/shm_nightclouds.tga
		tcMod turb 0 0.005 0.35 0.004
		tcMod scroll 0.004 -0.0075
		rgbGen identityLighting
	}
	{
		map skpk/textures/ut4_suburbs/shm_sky_mask.tga
		blendFunc GL_ONE_MINUS_SRC_ALPHA GL_SRC_ALPHA
		rgbGen identityLighting
	}
}

textures/skies_MASTER6/shaderlab_sky_mod
{
	qer_editorImage skpk/qer/6/shaderlab_sky_mod.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 40 -61 68 5 16
	q3map_LightMapFilterRadius 0 64
	q3map_lightRGB 0.9 0.96 1.0
	q3map_skyLight 60 4 0 90 0
	nopicmip
	skyparms skpk/textures/shaderlab_skies/black 1024 -
	{
		map skpk/textures/shaderlab_skybox/sky_clouds.tga
		tcMod scale 3 3
		tcMod scroll 0.005 -0.0125
		rgbGen identityLighting
	}
	{
		map skpk/textures/shaderlab_skybox/sky_arc_maskedmod.tga
		blendFunc GL_ONE_MINUS_SRC_ALPHA GL_SRC_ALPHA
		tcMod transform 0.25 0 0 0.25 0.1075 0.1075
		rgbGen identityLighting
	}
}

textures/skies_MASTER4/rjlut1
{
	qer_editorImage skpk/qer/textures/rjlut1/env/skybox.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 0.893935 0.437278 55 -145 36 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 65 4
	nopicmip
	skyparms skpk/textures/rjlut1/env/skybox - -
}

textures/skies_MASTER4/rjlut1-clouds
{
	qer_editorImage skpk/qer/textures/rjlut1/env/skybox-clouds.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 0.893935 0.437278 55 -145 36 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 65 4
	nopicmip
	skyparms skpk/textures/rjlut1/env/skybox 256 -
	{
		map skpk/textures/rjlut1/clouds.tga
		blendFunc filter
		tcMod scroll 0.002 0.002
		tcMod scale 5 5
	}
}

textures/skies_MASTER/mp_nightwalk2-greenish
{
	qer_editorImage skpk/qer/textures/ut_dville/env/dville.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.984482 0.788327 0.318608 50 76 16 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 90 4
	nopicmip
	skyparms skpk/textures/ut_dville/env/dville - -
}

textures/skies_MASTER6/ut_intermodal
{
	qer_editorImage skpk/qer/6/ut_intermodal.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 125 4
	nopicmip
	skyparms - 1024 -
	{
		map skpk/textures/ut_intermodal/sky.tga
		tcMod scale 0.4 0.4
	}
}

textures/skies_MASTER3/ut_laberinto
{
	qer_editorImage skpk/qer/env/ut_laberinto/med.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_sunExt 255 245 230 70 -137 60 15 16
	q3map_skylight 40 4
	nopicmip
	skyparms skpk/env/ut_laberinto/med - -
}

textures/skies_MASTER6/clouds1
{
	qer_editorImage skpk/qer/6/clouds1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms - 512 -
	{
		map skpk/textures/build/clouda1.tga
		tcMod scroll .03 .009 .009
		tcMod scale 1 1
		depthWrite
	}
	{
		map skpk/textures/build/cloudb1.tga
		blendfunc add
		tcMod scroll .01 .01 .02
		tcMod scale 5 5
	}
}

textures/skies_MASTER/jf_nebula
{
	qer_editorImage skpk/qer/env/jf_nebula/nebular.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 25 0 90 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_sunExt 255 245 245 35 81 7 8 16           //left nebula
	q3map_sunExt 255 245 245 35 15 4 11 16          //right nebula
	q3map_skylight 85 4
	nopicmip
	skyparms skpk/env/jf_nebula/Nebular - -
}

textures/skies_MASTER4/grece_skybox
{
	qer_editorImage skpk/qer/env/grece_skybox/skygrece.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 80 59 24 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/grece_skybox/skygrece - -
}

//FML

textures/skies_MASTER4/arc_day
{
	qer_editorImage skpk/qer/env/arcd.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 0.829114 0.925551 75 -78 11 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 85 4
	nopicmip
	skyparms skpk/env/arcd - -
}

textures/skies_MASTER4/arc_sunset
{
	qer_editorImage skpk/qer/env/arcss.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.879133 0.564569 0.263935 75 118 8 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 85 4
	nopicmip
	skyparms skpk/env/arcss - -
}

textures/skies_MASTER4/arctic3
{
	qer_editorImage skpk/qer/env/arctic3/arctic.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 80 -25 41 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 85 4
	nopicmip
	skyparms skpk/env/arctic3/arctic - -
}

textures/skies_MASTER4/berg
{
	qer_editorImage skpk/qer/env/berg.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 75 177 67 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 80 4
	nopicmip
	skyparms skpk/env/berg - -
}

textures/skies_MASTER4/desertday
{
	qer_editorImage skpk/qer/env/desertday/desertday.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 80 104 43 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 85 4
	nopicmip
	skyparms skpk/env/desertday/desertday - -
}

textures/skies_MASTER4/desertnite
{
	qer_editorImage skpk/qer/env/desertnite/desertnite.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 25 104 43 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 125 4
	nopicmip
	skyparms skpk/env/desertnite/desertnite - -
}

textures/skies_MASTER4/icecrater
{
	qer_editorImage skpk/qer/env/icecrater/icecrater.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 120 4
	nopicmip
	skyparms skpk/env/icecrater/icecrater - -
}

textures/skies_MASTER4/iceworld4
{
	qer_editorImage skpk/qer/env/iceworld4/iceworld4.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 35 92 48 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 110 4
	nopicmip
	skyparms skpk/env/iceworld4/iceworld4 - -
}

textures/skies_MASTER4/jhcanyon4
{
	qer_editorImage skpk/qer/env/jhcanyon4.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms skpk/env/jhcanyon4 - -
}

textures/skies_MASTER4/lunar3
{
	qer_editorImage skpk/qer/env/lunar3/lunar3.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 75 -90 68 2 16   //sun
	q3map_sunExt 1 1 1 5 90 26 2 16     //earth
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/lunar3/lunar3 - -
}

textures/skies_MASTER4/xenzone
{
	qer_editorImage skpk/qer/env/xenzone/xenzone.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms skpk/env/xenzone/xenzone - -
}

textures/skies_MASTER4/andes
{
	qer_editorImage skpk/qer/env/andes/andes.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 80 0 5 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 75 4
	nopicmip
	skyparms skpk/env/andes/andes - -
}

textures/skies_MASTER4/arctic1
{
	qer_editorImage skpk/qer/env/arctic1/arctic1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 70 -148 25 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 80 4
	nopicmip
	skyparms skpk/env/arctic1/arctic1 - -
}

textures/skies_MASTER4/ariel
{
	qer_editorImage skpk/qer/env/woebane/ariel.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 35 -172 60 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 95 4
	nopicmip
	skyparms skpk/env/woebane/ariel - -
}

textures/skies_MASTER4/ax_darkclouds
{
	qer_editorImage skpk/qer/env/ax_darkclouds/ax_darkclouds.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 125 4
	nopicmip
	skyparms skpk/env/ax_darkclouds/ax_darkclouds - -
}

textures/skies_MASTER4/ax_dfoaap_1
{
	qer_editorImage skpk/qer/env/ax_dfoaap_1/REDAS.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.987182 0.308522 0.316426 75 150 25 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 90 4
	nopicmip
	skyparms skpk/env/ax_dfoaap_1/REDAS - -
}

textures/skies_MASTER4/ax_sb-skyHL
{
	qer_editorImage skpk/qer/env/ax_sb-skyHL/sb.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 80 150 24 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 75 4
	nopicmip
	skyparms skpk/env/ax_sb-skyHL/sb - -
}

textures/skies_MASTER4/aztec
{
	qer_editorImage skpk/qer/env/aztec/aztec.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 35 -155 30 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 100 4
	nopicmip
	skyparms skpk/env/aztec/aztec - -
}

textures/skies_MASTER4/backalley
{
	qer_editorImage skpk/qer/env/backalley/backalley.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 50 3 73 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms skpk/env/backalley/backalley - -
}

textures/skies_MASTER3/barrendesert
{
	qer_editorImage skpk/qer/env/barrendesert/barrendesert.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 0.848112 0.59443 85 -89 10 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 85 4
	nopicmip
	skyparms skpk/env/barrendesert/barrendesert - -
}

textures/skies_MASTER3/blueplanet
{
	qer_editorImage skpk/qer/env/blueplanet.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 65 -92 4 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 100 4
	nopicmip
	skyparms skpk/env/blueplanet - -
}

textures/skies_MASTER/mp_chill-bone
{
	qer_editorImage skpk/qer/env/mp_bone/bone-chill512.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 25 -80 14 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 110 4
	nopicmip
	skyparms skpk/env/mp_bone/bone-chill512 - -
}

textures/skies_MASTER3/brooding
{
	qer_editorImage skpk/qer/env/brooding/brooding.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 160 4
	nopicmip
	skyparms skpk/env/brooding/brooding - -
}

textures/skies_MASTER3/bud1
{
	qer_editorImage skpk/qer/env/bud1/bud1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 75 -29 7 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 90 4
	nopicmip
	skyparms skpk/env/bud1/bud1 - -
}

textures/skies_MASTER3/bud6
{
	qer_editorImage skpk/qer/env/bud6/bud6.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 75 -29 24 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 65 4
	nopicmip
	skyparms skpk/env/bud6/bud6 - -
}

textures/skies_MASTER3/budcaps
{
	qer_editorImage skpk/qer/env/budcaps/budcaps.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 50 -29 25 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/budcaps/budcaps - -
}

textures/skies_MASTER2/c2day
{
	qer_editorImage skpk/qer/env/c2pub.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 80 0 90 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 85 4
	nopicmip
	skyparms skpk/env/c2pub - -
}

textures/skies_MASTER3/caliban
{
	qer_editorImage skpk/qer/env/woebane/caliban.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms skpk/env/woebane/caliban - -
}

textures/skies_MASTER3/celest
{
	qer_editorImage skpk/qer/env/celest/celest.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms skpk/env/celest/celest - -
}

textures/skies_MASTER/mp_cinnabar
{
	qer_editorImage skpk/qer/env/mp_cinnabar/cinnabar-valley512.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 0.770993 0.32253 60 -53 6 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 85 4
	nopicmip
	skyparms skpk/env/mp_cinnabar/cinnabar-valley512 - -
}

textures/skies_MASTER3/city2_sky
{
	qer_editorImage skpk/qer/env/woebane/city2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms skpk/env/woebane/city2 - -
}

textures/skies_MASTER3/cliff2
{
	qer_editorImage skpk/qer/env/cliff2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms skpk/env/cliff2 - -
}

textures/skies_MASTER3/cm-forest
{
	qer_editorImage skpk/qer/env/cm-forest/cm-forest512.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 120 4
	nopicmip
	skyparms skpk/env/cm-forest/cm-forest512 - -
}

textures/skies_MASTER3/cm-pinky
{
	qer_editorImage skpk/qer/env/cm-pinky/cm-pinky256.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 125 4
	nopicmip
	skyparms skpk/env/cm-pinky/cm-pinky256 - -
}

textures/skies_MASTER3/cm-scove
{
	qer_editorImage skpk/qer/env/cm-scove/cm-scove256.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms skpk/env/cm-scove/cm-scove256 - -
}

textures/skies_MASTER3/cm-thosemntns
{
	qer_editorImage skpk/qer/env/cm-thosemntns/cm-thosemntns256.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms skpk/env/cm-thosemntns/cm-thosemntns256 - -
}

textures/skies_MASTER3/cm-twildes
{
	qer_editorImage skpk/qer/env/cm-twildes/cm-twildes512.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyparms skpk/env/cm-twildes/cm-twildes512 - -
}

textures/skies_MASTER3/cm3
{
	qer_editorImage skpk/qer/env/cm3/cm3.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 120 4
	nopicmip
	skyparms skpk/env/cm3/cm3 - -
}

textures/skies_MASTER3/cm_bch1
{
	qer_editorImage skpk/qer/env/cm_bch1/cm_bch1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms skpk/env/cm_bch1/cm_bch1 - -
}

textures/skies_MASTER3/cm_des1
{
	qer_editorImage skpk/qer/env/cm_des1/cm_des1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_sunExt 255 250 230 60 82 32 10 16
	q3map_skylight 60 4
	nopicmip
	skyparms skpk/env/cm_des1/cm_des1 - -
}

textures/skies_MASTER3/cm_gala
{
	qer_editorImage skpk/qer/env/cm_gala/cm_gala.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 111 4
	nopicmip
	skyparms skpk/env/cm_gala/cm_gala - -
}

textures/skies_MASTER3/cm_ice1
{
	qer_editorImage skpk/qer/env/cm_ice1/cm_ice1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 20 -132 82 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 85 4
	nopicmip
	skyparms skpk/env/cm_ice1/cm_ice1 - -
}

textures/skies_MASTER3/cm_lake
{
	qer_editorImage skpk/qer/env/cm_lake/cm_lake.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 140 4
	nopicmip
	skyparms skpk/env/cm_lake/cm_lake - -
}

textures/skies_MASTER3/cm_mntn
{
	qer_editorImage skpk/qer/env/cm_mntn/cm_mntn.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_sunExt 1 1 1 60 -170 60 33 16
	q3map_skylight 60 4
	nopicmip
	skyparms skpk/env/cm_mntn/cm_mntn - -
}

textures/skies_MASTER3/cm_ncan
{
	qer_editorImage skpk/qer/env/cm_ncan/cm_ncan.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_sunExt 1 1 1 30 -133 55 20 16
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/cm_ncan/cm_ncan - -
}

textures/skies_MASTER3/cm_sea
{
	qer_editorImage skpk/qer/env/cm_sea/cm_sea256.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 75 168 16 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 65 4
	nopicmip
	skyparms skpk/env/cm_sea/cm_sea256 - -
}

textures/skies_MASTER3/cm_shady
{
	qer_editorImage skpk/qer/env/cm_shady/cm_shady.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 130 4
	nopicmip
	skyparms skpk/env/cm_shady/cm_shady - -
}

textures/skies_MASTER3/cm_smok
{
	qer_editorImage skpk/qer/env/cm_smok/cm_smok.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyparms skpk/env/cm_smok/cm_smok - -
}

textures/skies_MASTER3/coliseum
{
	qer_editorImage skpk/qer/env/coliseum/coliseum.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 125 4
	nopicmip
	skyparms skpk/env/coliseum/coliseum - -
}

textures/skies_MASTER3/conflictlg
{
	qer_editorImage skpk/qer/env/conflictlg/conflictlg.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 75 -99 69 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 75 4
	nopicmip
	skyparms skpk/env/conflictlg/conflictlg - -
}

textures/skies_MASTER/mp_summit
{
	qer_editorImage skpk/qer/env/mp_summit/corporate-summit512.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.950973 0.408255 0.158938 60 -131 24 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 85 4
	nopicmip
	skyparms skpk/env/mp_summit/corporate-summit512 - -
}

textures/skies_MASTER3/corr
{
	qer_editorImage skpk/qer/env/woebane/corr.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 99 4
	nopicmip
	skyparms skpk/env/woebane/corr - -
}

textures/skies_MASTER3/crater
{
	qer_editorImage skpk/qer/env/crater.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 120 4
	nopicmip
	skyparms skpk/env/crater - -
}

textures/skies_MASTER3/DalePeninsula
{
	qer_editorImage skpk/qer/env/DalePeninsula/DalePeninsula.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 125 4
	nopicmip
	skyparms skpk/env/DalePeninsula/DalePeninsula - -
}

textures/skies_MASTER3/des
{
	qer_editorImage skpk/qer/env/des/des.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 120 4
	nopicmip
	skyparms skpk/env/des/des - -
}

textures/skies_MASTER3/desdusk
{
	qer_editorImage skpk/qer/env/desdusk/desdusk.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 80 157 22 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 65 4
	nopicmip
	skyparms skpk/env/desdusk/desdusk - -
}

textures/skies_MASTER3/desert1
{
	qer_editorImage skpk/qer/env/desert1/desert1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 80 179 40 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 55 4
	nopicmip
	skyparms skpk/env/desert1/desert1 - -
}

textures/skies_MASTER3/desert2
{
	qer_editorImage skpk/qer/env/desert2/desert2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 80 149 27 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 55 4
	nopicmip
	skyparms skpk/env/desert2/desert2 - -
}

textures/skies_MASTER3/dfcliff
{
	qer_editorImage skpk/qer/env/dfcliff/dfcliff.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 70 -89 28 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 65 4
	nopicmip
	skyparms skpk/env/dfcliff/dfcliff - -
}

textures/skies_MASTER3/dfdmist
{
	qer_editorImage skpk/qer/env/dfdmist/dfdmist.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 25 0 30 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 85 4
	nopicmip
	skyparms skpk/env/dfdmist/dfdmist - -
}

textures/skies_MASTER3/dold
{
	qer_editorImage skpk/qer/env/woebane/dold.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 130 4
	nopicmip
	skyparms skpk/env/woebane/dold - -
}

textures/skies_MASTER3/doom1-1
{
	qer_editorImage skpk/qer/env/doom1-1/doom1-1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 120 4
	nopicmip
	skyparms skpk/env/doom1-1/doom1-1 - -
}

textures/skies_MASTER3/doom3
{
	qer_editorImage skpk/qer/env/doom3/doom3.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 160 4
	nopicmip
	skyparms skpk/env/doom3/doom3 - -
}

textures/skies_MASTER3/drkg
{
	qer_editorImage skpk/qer/env/drkg/drkg.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 120 4
	nopicmip
	skyparms skpk/env/drkg/drkg - -
}

textures/skies_MASTER3/dryg
{
	qer_editorImage skpk/qer/env/dryg/dryg.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 75 -37 67 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/dryg/dryg - -
}

textures/skies_MASTER3/dryland
{
	qer_editorImage skpk/qer/env/dryland/dryland512.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 0.927718 0.654521 65 -77 23 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 80 4
	nopicmip
	skyparms skpk/env/dryland/dryland512 - -
}

textures/skies_MASTER3/dusty
{
	qer_editorImage skpk/qer/env/dusty/dusty.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 0.927718 0.654521 50 -37 29 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 85 4
	nopicmip
	skyparms skpk/env/dusty/dusty - -
}

textures/skies_MASTER3/earth2
{
	qer_editorImage skpk/qer/env/earth/earth.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 55 -171 30 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 85 4
	nopicmip
	skyparms skpk/env/earth/earth - -
}

textures/skies_MASTER/mp_frost
{
	qer_editorImage skpk/qer/env/mp_frost/frost-bite512.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 15 -84 25 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 110 4
	nopicmip
	skyparms skpk/env/mp_frost/frost-bite512 - -
}

textures/skies_MASTER3/giger-hive
{
	qer_editorImage skpk/qer/env/giger-hive/giger-hive-512.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 120 4
	nopicmip
	skyparms skpk/env/giger-hive/giger-hive-512 - -
}

textures/skies_MASTER/mp_bay
{
	qer_editorImage skpk/qer/env/mp_bay/uranium-bay512.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 0.687465 0.333486 85 -67 23 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 60 4
	nopicmip
	skyparms skpk/env/mp_bay/uranium-bay512 - -
}

textures/skies_MASTER/mp_petesoasis-sunset
{
	qer_editorImage skpk/qer/env/mp_tropdep/tropdep512.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 125 4
	nopicmip
	skyparms skpk/env/mp_tropdep/tropdep512 - -
}

textures/skies_MASTER/mp_oxygen
{
	qer_editorImage skpk/qer/env/mp_oxygen/lack-of-oxygen512.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 0.687465 0.333486 30 -141 6 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 95 4
	nopicmip
	skyparms skpk/env/mp_oxygen/lack-of-oxygen512 - -
}

textures/skies_MASTER3/jump
{
	qer_editorImage skpk/qer/env/jump/jump.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.916838 0.696193 0.326833 70 126 62 2 16
	q3map_sunExt 1 1 1 35 -62 -19 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 75 4
	nopicmip
	skyparms skpk/env/jump/jump - -
}

textures/skies_MASTER3/g_morning
{
	qer_editorImage skpk/qer/env/g_morning/g_morning.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 60 -102 8 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 90 4
	nopicmip
	skyparms skpk/env/g_morning/g_morning - -
}

textures/skies_MASTER3/g_night
{
	qer_editorImage skpk/qer/env/g_night/g_night.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms skpk/env/g_night/g_night - -
}

textures/skies_MASTER3/gaswks
{
	qer_editorImage skpk/qer/env/gaswks/gaswks.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_sunExt 155 120 162 50 -87 73 10 16
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/gaswks/gaswks - -
}

textures/skies_MASTER3/goneril
{
	qer_editorImage skpk/qer/env/woebane/goneril.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 75 -153 25 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 85 4
	nopicmip
	skyparms skpk/env/woebane/goneril - -
}

textures/skies_MASTER3/grass
{
	qer_editorImage skpk/qer/env/grass/grass.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyparms skpk/env/grass/grass - -
}

textures/skies_MASTER3/greencity
{
	qer_editorImage skpk/qer/env/greencity/greencity.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 125 4
	nopicmip
	skyparms skpk/env/greencity/greencity - -
}

textures/skies_MASTER3/greenlake
{
	qer_editorImage skpk/qer/env/greenlake/greenlake.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 75 -29 20 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 90 4
	nopicmip
	skyparms skpk/env/greenlake/greenlake - -
}

textures/skies_MASTER3/gulf1
{
	qer_editorImage skpk/qer/env/gulf1/gulf1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 60 -41 28 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 95 4
	nopicmip
	skyparms skpk/env/gulf1/gulf1 - -
}

textures/skies_MASTER3/hazy
{
	qer_editorImage skpk/qer/env/hazy/hazy.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 120 4
	nopicmip
	skyparms skpk/env/hazy/hazy - -
}

textures/skies_MASTER3/hellish
{
	qer_editorImage skpk/qer/env/hellish/hellish.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 150 4
	nopicmip
	skyparms skpk/env/hellish/hellish - -
}

textures/skies_MASTER3/hellsgate
{
	qer_editorImage skpk/qer/env/hellsgate/gate.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 60 150 9 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 100 4
	nopicmip
	skyparms skpk/env/hellsgate/gate - -
}

textures/skies_MASTER3/holo
{
	qer_editorImage skpk/qer/env/holo/holo.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 35 -55 57 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 85 4
	nopicmip
	skyparms skpk/env/holo/holo - -
}

textures/skies_MASTER3/husk
{
	qer_editorImage skpk/qer/env/woebane/husk.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.982071 0.84007 0.264759 60 127 16 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 75 4
	nopicmip
	skyparms skpk/env/woebane/husk - -
}

textures/skies_MASTER3/iago
{
	qer_editorImage skpk/qer/env/woebane/iago.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 111 4
	nopicmip
	skyparms skpk/env/woebane/iago - -
}

textures/skies_MASTER3/iceberg1
{
	qer_editorImage skpk/qer/env/iceberg1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 75 -19.5 23 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 85 4
	nopicmip
	skyparms skpk/env/iceberg1 - -
}

textures/skies_MASTER3/icemt
{
	qer_editorImage skpk/qer/env/icemt/icemt.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 120 4
	nopicmip
	skyparms skpk/env/icemt/icemt - -
}

textures/skies_MASTER3/imogen
{
	qer_editorImage skpk/qer/env/woebane/imogen.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 255 250 240 11 -89 82 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 122 4
	nopicmip
	skyparms skpk/env/woebane/imogen - -
}

textures/skies_MASTER3/inds
{
	qer_editorImage skpk/qer/env/inds/inds.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 125 4
	nopicmip
	skyparms skpk/env/inds/inds - -
}

textures/skies_MASTER3/island
{
	qer_editorImage skpk/qer/env/island/island.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyparms skpk/env/island/island - -
}

textures/skies_MASTER/mp_jc
{
	qer_editorImage skpk/qer/env/mp_jc/jc.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 130 4
	nopicmip
	skyparms skpk/env/mp_jc/jc - -
}

textures/skies_MASTER3/jesunset
{
	qer_editorImage skpk/qer/env/jesunset/jesunset.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 75 -118 6 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 85 4
	nopicmip
	skyparms skpk/env/jesunset/jesunset - -
}

textures/skies_MASTER3/jungle1
{
	qer_editorImage skpk/qer/env/jungle1/jungle1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 99 4
	nopicmip
	skyparms skpk/env/jungle1/jungle1 - -
}

textures/skies_MASTER3/ka_deadnight
{
	qer_editorImage skpk/qer/env/deadnight/deadnight.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 20 -22 65 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 95 4
	nopicmip
	skyparms skpk/env/deadnight/deadnight - -
}

textures/skies_MASTER3/ka_redplanet
{
	qer_editorImage skpk/qer/env/redplanet/redplanet.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 200 4
	nopicmip
	skyparms skpk/env/redplanet/redplanet - -
}

textures/skies_MASTER3/katharina
{
	qer_editorImage skpk/qer/env/woebane/katharina.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 255 250 220 60 -155 42 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 60 4
	nopicmip
	skyparms skpk/env/woebane/katharina - -
}

textures/skies_MASTER/mp_labrat
{
	qer_editorImage skpk/qer/env/mp_labrat/labrat.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 125 4
	nopicmip
	skyparms skpk/env/mp_labrat/labrat - -
}

textures/skies_MASTER3/lake2
{
	qer_editorImage skpk/qer/env/lake2/lake2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_lightRGB 244 247 255
	q3map_skylight 120 4 0 90 0
	nopicmip
	skyparms skpk/env/lake2/lake2 - -
}

textures/skies_MASTER3/lear
{
	qer_editorImage skpk/qer/env/woebane/lear.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 125 4
	nopicmip
	skyparms skpk/env/woebane/lear - -
}

textures/skies_MASTER/mp_lost_lagoon
{
	qer_editorImage skpk/qer/env/mp_ll/ll.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 50 -8 67 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 100 4
	nopicmip
	skyparms skpk/env/mp_ll/ll - -
}

textures/skies_MASTER/mp_lake_mandelbrot
{
	qer_editorImage skpk/qer/env/mp_lm/lm.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 125 4
	nopicmip
	skyparms skpk/env/mp_lm/lm - -
}

textures/skies_MASTER2/LMmnts_1
{
	qer_editorImage skpk/qer/env/LMmnts_1/LMmnts_1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 22 -147 49 3 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 55 4
	nopicmip
	skyparms skpk/env/LMmnts_1/LMmnts_1 - -
}

textures/skies_MASTER3/lsw_2
{
	qer_editorImage skpk/qer/env/lsw_2/lsw_2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 65 112 61 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 85 4
	nopicmip
	skyparms skpk/env/lsw_2/lsw_2 - -
}

textures/skies_MASTER3/macbeth
{
	qer_editorImage skpk/qer/env/woebane/macbeth.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 120 4
	nopicmip
	skyparms skpk/env/woebane/macbeth - -
}

textures/skies_MASTER3/malrav3
{
	qer_editorImage skpk/qer/env/malrav3/malrav3sky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 80 -179 50 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 65 4
	nopicmip
	skyparms skpk/env/malrav3/malrav3sky - -
}

textures/skies_MASTER3/malrav11
{
	qer_editorImage skpk/qer/env/malrav11/malrav11sky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 75 -120 35 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 65 4
	nopicmip
	skyparms skpk/env/malrav11/malrav11sky - -
}

textures/skies_MASTER3/mars_env
{
	qer_editorImage skpk/qer/env/mars_env/mars_env.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 255 128 128 55 60 25 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/mars_env/mars_env - -
}

textures/skies_MASTER3/marsstorm
{
	qer_editorImage skpk/qer/env/marsstorm/marsstorm.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 111 4
	nopicmip
	skyparms skpk/env/marsstorm/marsstorm - -
}

textures/skies_MASTER3/meglop
{
	qer_editorImage skpk/qer/env/meglop/meglop.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 100 0 90 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/meglop/meglop - -
}

textures/skies_MASTER3/mira
{
	qer_editorImage skpk/qer/env/mira.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 177 4
	nopicmip
	skyparms skpk/env/mira - -
}

textures/skies_MASTER3/montagne
{
	qer_editorImage skpk/qer/env/montagne/montagne.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 60 -78 32 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 95 4
	nopicmip
	skyparms skpk/env/montagne/montagne - -
}

textures/skies_MASTER3/montnotte
{
	qer_editorImage skpk/qer/env/montnotte/montnotte.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_sunExt 255 250 240 50 -65 27 11 16
	q3map_skylight 100 4
	nopicmip
	skyparms skpk/env/montnotte/montnotte - -
}

textures/skies_MASTER3/mountain2
{
	qer_editorImage skpk/qer/env/mountain2/mountain2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 90 4
	nopicmip
	skyparms skpk/env/mountain2/mountain2 - -
}

textures/skies_MASTER3/mountain3
{
	qer_editorImage skpk/qer/env/mountain3/mountain3.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 111 4
	nopicmip
	skyparms skpk/env/mountain3/mountain3 - -
}

textures/skies_MASTER3/mountainlakes
{
	qer_editorImage skpk/qer/env/mountainlakes/mountainlakes.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_sunExt 1 1 1 33 -143 11 9 16
	q3map_skylight 60 4
	nopicmip
	skyparms skpk/env/mountainlakes/mountainlakes - -
}

textures/skies_MASTER3/mrc-desert
{
	qer_editorImage skpk/qer/env/mrc-desert/mrc-desert.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 255 245 235 60 17 62 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 60 4
	nopicmip
	skyparms skpk/env/mrc-desert/mrc-desert - -
}

textures/skies_MASTER3/mtnsun
{
	qer_editorImage skpk/qer/env/mtnsun/mtnsun.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 40 -171 6 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 95 4
	nopicmip
	skyparms skpk/env/mtnsun/mtnsun - -
}

textures/skies_MASTER3/muad_glacial
{
	qer_editorImage skpk/qer/env/muad_glacial/glacial.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 45 -107 29 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 95 4
	nopicmip
	skyparms skpk/env/muad_glacial/glacial - -
}

textures/skies_MASTER3/muad_marsh
{
	qer_editorImage skpk/qer/env/muad_marsh/marsh.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms skpk/env/muad_marsh/marsh - -
}

textures/skies_MASTER3/muad_nitey
{
	qer_editorImage skpk/qer/env/muad_nitey/nitey.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 45 0 90 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 95 4
	nopicmip
	skyparms skpk/env/muad_nitey/nitey - -
}

textures/skies_MASTER3/muad_ocean
{
	qer_editorImage skpk/qer/env/muad_ocean/ocean.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 25 0 90 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 110 4
	nopicmip
	skyparms skpk/env/muad_ocean/ocean - -
}

textures/skies_MASTER3/muad_snowy
{
	qer_editorImage skpk/qer/env/muad_snowy/snw.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 60 78 21 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 85 4
	nopicmip
	skyparms skpk/env/muad_snowy/snw - -
}

textures/skies_MASTER3/nc-desert
{
	qer_editorImage skpk/qer/env/nc-desert/desrt1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 70 25 30 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 75 4
	nopicmip
	skyparms skpk/env/nc-desert/desrt1 - -
}

textures/skies_MASTER3/nightsea
{
	qer_editorImage skpk/qer/env/nightsea/nightsea.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 35 106 1 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 100 4
	nopicmip
	skyparms skpk/env/nightsea/nightsea - -
}

textures/skies_MASTER3/nms2
{
	qer_editorImage skpk/qer/env/nms2/nms2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_sunExt 255 255 182 35 44 33 9 16
	q3map_sunExt 255 255 240 30 150 48 9 16
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/nms2/nms2 - -
}

textures/skies_MASTER3/nogmars1
{
	qer_editorImage skpk/qer/env/nogmars1/nogmars1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 111 4
	nopicmip
	skyparms skpk/env/nogmars1/nogmars1 - -
}

textures/skies_MASTER3/nuke2
{
	qer_editorImage skpk/qer/env/nuke2/nuke2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms skpk/env/nuke2/nuke2 - -
}

textures/skies_MASTER3/null_barren
{
	qer_editorImage skpk/qer/env/null_barren/null_barren512.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 80 7 16 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 75 4
	nopicmip
	skyparms skpk/env/null_barren/null_barren512 - -
}

textures/skies_MASTER3/null_hill
{
	qer_editorImage skpk/qer/env/null_hill/null_hill512.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 60 100 56 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 80 4
	nopicmip
	skyparms skpk/env/null_hill/null_hill512 - -
}

textures/skies_MASTER3/null_lake
{
	qer_editorImage skpk/qer/env/null_lake/null_lake512.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms skpk/env/null_lake/null_lake512 - -
}

textures/skies_MASTER3/null_plainsky
{
	qer_editorImage skpk/qer/env/null_plainsky/null_plainsky512.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 120 4
	nopicmip
	skyparms skpk/env/null_plainsky/null_plainsky512 - -
}

textures/skies_MASTER3/null_rusty
{
	qer_editorImage skpk/qer/env/null_rusty/null_rusty512.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.890196 0.760784 0.552941 55 -169 19 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 85 4
	nopicmip
	skyparms skpk/env/null_rusty/null_rusty512 - -
}

textures/skies_MASTER3/null_seabed
{
	qer_editorImage skpk/qer/env/null_seabed/null_seabed512.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 25 4 77 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms skpk/env/null_seabed/null_seabed512 - -
}

textures/skies_MASTER3/office
{
	qer_editorImage skpk/qer/env/office/office.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms skpk/env/office/office - -
}

textures/skies_MASTER3/overcast
{
	qer_editorImage skpk/qer/env/overcast/overcast.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms skpk/env/overcast/overcast - -
}

textures/skies_MASTER3/planetmeat
{
	qer_editorImage skpk/qer/env/planetmeat/planetmeat.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms skpk/env/planetmeat/planetmeat - -
}

textures/skies_MASTER/mp_predator
{
	qer_editorImage skpk/qer/env/mp_predator/predator.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms skpk/env/mp_predator/predator - -
}

textures/skies_MASTER3/primordial
{
	qer_editorImage skpk/qer/env/primordial/primordial.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 35 58 27 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 85 4
	nopicmip
	skyparms skpk/env/primordial/primordial - -
}

textures/skies_MASTER3/prospero
{
	qer_editorImage skpk/qer/env/woebane/prospero.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_sunExt 255 235 250 60 -121 27 10 16
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/woebane/prospero - -
}

textures/skies_MASTER3/riverscape1
{
	qer_editorImage skpk/qer/env/riverscape1/riverscape1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 75 13 24 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 65 4
	nopicmip
	skyparms skpk/env/riverscape1/riverscape1 - -
}

textures/skies_MASTER3/rsky4
{
	qer_editorImage skpk/qer/env/rsky4/rsky4.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 111 4
	nopicmip
	skyparms skpk/env/rsky4/rsky4 - -
}

textures/skies_MASTER/icymatrix
{
	qer_editorImage skpk/qer/env/icematrix/icematrix.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt .8 .8 .8 80 38 35 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 75 4
	nopicmip
	skyparms skpk/env/icematrix/icematrix - -
}

textures/skies_MASTER3/sea
{
	qer_editorImage skpk/qer/env/sea/sea.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.880156 0.68423 0.370199 60 122 5 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 85 4
	nopicmip
	skyparms skpk/env/sea/sea - -
}

textures/skies_MASTER3/sky1
{
	qer_editorImage skpk/qer/env/sky1/sky1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 75 -68 15 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 75 4
	nopicmip
	skyparms skpk/env/sky1/sky1 - -
}

textures/skies_MASTER3/sky3
{
	qer_editorImage skpk/qer/env/sky3/sky3.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms skpk/env/sky3/sky3 - -
}

textures/skies_MASTER3/sky4
{
	qer_editorImage skpk/qer/env/sky4/sky4.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 65 -95 60 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 80 4
	nopicmip
	skyparms skpk/env/sky4/sky4 - -
}

textures/skies_MASTER3/sky8
{
	qer_editorImage skpk/qer/env/sky8/sky8.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 60 -71 13 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 80 4
	nopicmip
	skyparms skpk/env/sky8/sky8 - -
}

textures/skies_MASTER3/snow
{
	qer_editorImage skpk/qer/env/snow/snow.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 70 -140 23 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 85 4
	nopicmip
	skyparms skpk/env/snow/snow - -
}

textures/skies_MASTER3/snow2
{
	qer_editorImage skpk/qer/env/snow2/snow2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 40 -126 60 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 95 4
	nopicmip
	skyparms skpk/env/snow2/snow2 - -
}

textures/skies_MASTER3/snowcliff
{
	qer_editorImage skpk/qer/env/snowcliff/snowcliff.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 65 48 24 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 85 4
	nopicmip
	skyparms skpk/env/snowcliff/snowcliff - -
}

textures/skies_MASTER3/snowy
{
	qer_editorImage skpk/qer/env/snowy/snowy.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 30 59 25 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 100 4
	nopicmip
	skyparms skpk/env/snowy/snowy - -
}

textures/skies_MASTER3/snowymount
{
	qer_editorImage skpk/qer/env/snowymount/snowymount.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 45 18 52 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 95 4
	nopicmip
	skyparms skpk/env/snowymount/snowymount - -
}

textures/skies_MASTER3/spa
{
	qer_editorImage skpk/qer/env/spa/spa.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.87451 0.717647 0.32549 70 89 58 2 16
	q3map_sunExt 0.356863 .588235 .929412 40 -68 16 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 100 4
	nopicmip
	skyparms skpk/env/spa/spa - -
}

textures/skies_MASTER3/spa-jump
{
	qer_editorImage skpk/qer/env/spa-jump/spa-jump.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 70 -36 13 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 80 4
	nopicmip
	skyparms skpk/env/spa-jump/spa-jump - -
}

textures/skies_MASTER3/spa-snow
{
	qer_editorImage skpk/qer/env/spa-snow/spa-snow.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms skpk/env/spa-snow/spa-snow - -
}

textures/skies_MASTER3/spa-snow2
{
	qer_editorImage skpk/qer/env/spa-snow2/spa-snow2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 30 40 63 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 100 4
	nopicmip
	skyparms skpk/env/spa-snow2/spa-snow2 - -
}

textures/skies_MASTER/mp_stope_rat
{
	qer_editorImage skpk/qer/env/mp_srat/srat.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms skpk/env/mp_srat/srat - -
}

textures/skies_MASTER3/stars
{
	qer_editorImage skpk/qer/env/stars/stars.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 173 -7 2 16
	q3map_sunExt 1 1 1 50 58 20 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 90 4
	nopicmip
	skyparms skpk/env/stars/stars - -
}

textures/skies_MASTER3/stonehenge
{
	qer_editorImage skpk/qer/env/stoneh/stoneh.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms skpk/env/stoneh/stoneh - -
}

textures/skies_MASTER3/storm
{
	qer_editorImage skpk/qer/env/storm.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 88 4
	nopicmip
	skyparms skpk/env/storm - -
}

textures/skies_MASTER3/stormynight
{
	qer_editorImage skpk/qer/env/stormynight/stormynight.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 125 4
	nopicmip
	skyparms skpk/env/stormynight/stormynight - -
}

textures/skies_MASTER3/sunbeams
{
	qer_editorImage skpk/qer/env/sunbeams/sunbeams.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms skpk/env/sunbeams/sunbeams - -
}

textures/skies_MASTER3/sunset1
{
	qer_editorImage skpk/qer/env/sunset1/sunset1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.967269 0.744762 0.37554 80 87 4 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 85 4
	nopicmip
	skyparms skpk/env/sunset1/sunset1 - -
}

textures/skies_MASTER3/sunset02
{
	qer_editorImage skpk/qer/env/sunset02/sunset02.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 0.744762 0.37554 80 -69 3 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 85 4
	nopicmip
	skyparms skpk/env/sunset02/sunset02 - -
}

textures/skies_MASTER3/theft
{
	qer_editorImage skpk/qer/env/theft/theft.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 65 88 16 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 90 4
	nopicmip
	skyparms skpk/env/theft/theft - -
}

textures/skies_MASTER3/throne1
{
	qer_editorImage skpk/qer/env/woebane/throne1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms skpk/env/woebane/throne1 - -
}

textures/skies_MASTER3/throne3
{
	qer_editorImage skpk/qer/env/woebane/throne3.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 120 4
	nopicmip
	skyparms skpk/env/woebane/throne3 - -
}

textures/skies_MASTER3/throne6
{
	qer_editorImage skpk/qer/env/woebane/throne6.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 -24 35 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 60 4
	nopicmip
	skyparms skpk/env/woebane/throne6 - -
}

textures/skies_MASTER3/thunderstorm
{
	qer_editorImage skpk/qer/env/thunderstorm/thunderstorm.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms skpk/env/thunderstorm/thunderstorm - -
}

textures/skies_MASTER/mp_tls
{
	qer_editorImage skpk/qer/env/mp_tls/tls.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms skpk/env/mp_tls/tls - -
}

textures/skies_MASTER3/toxic_spires
{
	qer_editorImage skpk/qer/env/toxic_spires/toxic.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 130 4
	nopicmip
	skyparms skpk/env/toxic_spires/toxic - -
}

textures/skies_MASTER3/tramonto
{
	qer_editorImage skpk/qer/env/tramonto/tramonto.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.984421 0.88925 0.44184 50 -121 12 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 95 4
	nopicmip
	skyparms skpk/env/tramonto/tramonto - -
}

textures/skies_MASTER3/tree
{
	qer_editorImage skpk/qer/env/tree/tree.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 45 112 41 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 100 4
	nopicmip
	skyparms skpk/env/tree/tree - -
}

textures/skies_MASTER3/treefog
{
	qer_editorImage skpk/qer/env/treefog/treefog.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 70 26 16 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms skpk/env/treefog/treefog - -
}

textures/skies_MASTER/tropical-sunset
{
	qer_editorImage skpk/qer/env/tropical2/tropical2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 25 37 1 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 105 4
	nopicmip
	skyparms skpk/env/tropical2/tropical2 - -
}

textures/skies_MASTER4/CSO_tsccity-original
{
	qer_editorImage skpk/qer/env/tsccity/tsccity.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms skpk/env/tsccity/tsccity - -
}

textures/skies_MASTER3/tsm_1
{
	qer_editorImage skpk/qer/env/tsm_1/tsm_1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 111 4
	nopicmip
	skyparms skpk/env/tsm_1/tsm_1 - -
}

textures/skies_MASTER/mp_universe
{
	qer_editorImage skpk/qer/env/mp_un/un.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 125 4
	nopicmip
	skyparms skpk/env/mp_un/un - -
}

textures/skies_MASTER3/unk1
{
	qer_editorImage skpk/qer/env/woebane/unk1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 55 -88 66 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 85 4
	nopicmip
	skyparms skpk/env/woebane/unk1 - -
}

textures/skies_MASTER3/unk2
{
	qer_editorImage skpk/qer/env/woebane/unk2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyparms skpk/env/woebane/unk2 - -
}

textures/skies_MASTER3/valley1
{
	qer_editorImage skpk/qer/env/valley1/valley1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.967254 0.833097 0.37554 55 92 15 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 85 4
	nopicmip
	skyparms skpk/env/valley1/valley1 - -
}

textures/skies_MASTER3/vlcno
{
	qer_editorImage skpk/qer/env/vlcno/vlcno.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 125 4
	nopicmip
	skyparms skpk/env/vlcno/vlcno - -
}

textures/skies_MASTER3/vulcano
{
	qer_editorImage skpk/qer/env/vulcano/vulcano.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms skpk/env/vulcano/vulcano - -
}

textures/skies_MASTER3/warp
{
	qer_editorImage skpk/qer/env/woebane/warp.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 79 16 51 33 -18 3 5 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 60 4
	nopicmip
	skyparms skpk/env/woebane/warp - -
}

textures/skies_MASTER3/waste
{
	qer_editorImage skpk/qer/env/waste/waste.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 90 136 33 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 60 4
	nopicmip
	skyparms skpk/env/waste/waste - -
}

textures/skies_MASTER3/wdesert1
{
	qer_editorImage skpk/qer/env/wdesert1/wdesert1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms skpk/env/wdesert1/wdesert1 - -
}

textures/skies_MASTER3/wildsky
{
	qer_editorImage skpk/qer/env/wildsky/wildsky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 125 4
	nopicmip
	skyparms skpk/env/wildsky/wildsky - -
}

textures/skies_MASTER3/winter
{
	qer_editorImage skpk/qer/env/winter/winter.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.882353 0.698039 0.678431 50 -30 25 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 80 4
	nopicmip
	skyparms skpk/env/winter/winter - -
}

textures/skies_MASTER3/wruins1
{
	qer_editorImage skpk/qer/env/wruins1/wruins1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 120 4
	nopicmip
	skyparms skpk/env/wruins1/wruins1 - -
}

textures/skies_MASTER3/forest
{
	qer_editorImage skpk/qer/env/forest.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms skpk/env/forest - -
}

textures/skies_MASTER3/callystam11
{
	qer_editorImage skpk/qer/env/callystam11/callystam11sky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 65 -100 37 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 65 4
	nopicmip
	skyparms skpk/env/callystam11/callystam11sky - -
}

textures/skies_MASTER/ame_bleached
{
	qer_editorImage skpk/qer/env/amethyst7/bleached/bleached.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 .95 75 0 90 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 80 4
	nopicmip
	skyparms skpk/env/amethyst7/bleached/bleached - -
}

textures/skies_MASTER/ame_powderpeaknight
{
	qer_editorImage skpk/qer/env/amethyst7/powderpeaknight/powderpeaknight.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt .934 .835 1 50 -179 8 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/amethyst7/powderpeaknight/powderpeaknight - -
}

textures/skies_MASTER/box374
{
	qer_editorImage skpk/qer/env/box374/box374.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.960113 0.887068 0.440696 65 90 11 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 90 4
	nopicmip
	skyparms skpk/env/box374/box374 - -
}

textures/skies_MASTER3/furusato3
{
	qer_editorImage skpk/qer/env/furusato3/furusato_sky3.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt .960113 0.887068 0.440696 70 -44 29 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 80 4
	nopicmip
	skyparms skpk/env/furusato3/furusato_sky3 - -
}

textures/skies_MASTER3/casa2
{
	qer_editorImage skpk/qer/env/casa2/dd_casa_sky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 80 47 71 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 60 4
	nopicmip
	skyparms skpk/env/casa2/dd_casa_sky - -
}

textures/skies_MASTER/kothic_epiphany
{
	qer_editorImage skpk/qer/env/epiphany/epiphany.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 60 0 90 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 75 4
	nopicmip
	skyparms skpk/env/epiphany/epiphany - -
}

textures/skies_MASTER/hip_inter-red
{
	qer_editorImage skpk/qer/env/mp_monolith/monolith.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_sunExt 0.980545 0.597757 0.400092 80 340 49 11 16
	q3map_skylight 65 4
	nopicmip
	skyparms skpk/env/mp_monolith/monolith - -
}

textures/skies_MASTER3/reflex_dust
{
	qer_editorImage skpk/qer/textures/reflex_skies/dust_01.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms skpk/textures/reflex_skies/dust_01 - -
}

textures/skies_MASTER3/reflex_green
{
	qer_editorImage skpk/qer/textures/reflex_skies/green_01.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms skpk/textures/reflex_skies/green_01 - -
}

textures/skies_MASTER3/reflex_rock
{
	qer_editorImage skpk/qer/textures/reflex_skies/rock_01.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 35 -30 19 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 95 4
	nopicmip
	skyparms skpk/textures/reflex_skies/rock_01 - -
}

textures/skies_MASTER3/reflex_snow
{
	qer_editorImage skpk/qer/textures/reflex_skies/snow_01.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 125 4
	nopicmip
	skyparms skpk/textures/reflex_skies/snow_01 - -
}

//============================================

textures/skies_MASTER3/osirion-sky01
{
	qer_editorImage skpk/qer/env/osirion/sky01.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 120 4
	nopicmip
	skyparms skpk/env/osirion/sky01 - -
}

textures/skies_MASTER3/osirion-sky02
{
	qer_editorImage skpk/qer/env/osirion/sky02.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 120 4
	nopicmip
	skyparms skpk/env/osirion/sky02 - -
}

textures/skies_MASTER3/osirion-sky03
{
	qer_editorImage skpk/qer/env/osirion/sky03.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 120 4
	nopicmip
	skyparms skpk/env/osirion/sky03 - -
}

textures/skies_MASTER3/osirion-sky04
{
	qer_editorImage skpk/qer/env/osirion/sky04.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 145 4
	nopicmip
	skyparms skpk/env/osirion/sky04 - -
}

textures/skies_MASTER3/osirion-sky05
{
	qer_editorImage skpk/qer/env/osirion/sky05.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 150 4
	nopicmip
	skyparms skpk/env/osirion/sky05 - -
}

textures/skies_MASTER3/osirion-sky06
{
	qer_editorImage skpk/qer/env/osirion/sky06.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 150 4
	nopicmip
	skyparms skpk/env/osirion/sky06 - -
}

textures/skies_MASTER3/osirion-sky07
{
	qer_editorImage skpk/qer/env/osirion/sky07.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 120 4
	nopicmip
	skyparms skpk/env/osirion/sky07 - -
}

textures/skies_MASTER3/osirion-sky08
{
	qer_editorImage skpk/qer/env/osirion/sky08.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 120 4
	nopicmip
	skyparms skpk/env/osirion/sky08 - -
}

textures/skies_MASTER3/osirion-sky09
{
	qer_editorImage skpk/qer/env/osirion/sky09.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 120 4
	nopicmip
	skyparms skpk/env/osirion/sky09 - -
}

textures/skies_MASTER3/osirion-sky10
{
	qer_editorImage skpk/qer/env/osirion/sky10.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 120 4
	nopicmip
	skyparms skpk/env/osirion/sky10 - -
}

textures/skies_MASTER3/osirion-sky11
{
	qer_editorImage skpk/qer/env/osirion/sky11.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 120 4
	nopicmip
	skyparms skpk/env/osirion/sky11 - -
}

textures/skies_MASTER3/osirion-sky12
{
	qer_editorImage skpk/qer/env/osirion/sky12.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 120 4
	nopicmip
	skyparms skpk/env/osirion/sky12 - -
}

textures/skies_MASTER3/osirion-sky13
{
	qer_editorImage skpk/qer/env/osirion/sky13.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 120 4
	nopicmip
	skyparms skpk/env/osirion/sky13 - -
}

textures/skies_MASTER3/osirion-sky14
{
	qer_editorImage skpk/qer/env/osirion/sky14.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 120 4
	nopicmip
	skyparms skpk/env/osirion/sky14 - -
}

textures/skies_MASTER3/osirion-sky15
{
	qer_editorImage skpk/qer/env/osirion/sky15.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 120 4
	nopicmip
	skyparms skpk/env/osirion/sky15 - -
}

textures/skies_MASTER3/osirion-sky16
{
	qer_editorImage skpk/qer/env/osirion/sky16.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 120 4
	nopicmip
	skyparms skpk/env/osirion/sky16 - -
}

textures/skies_MASTER3/osirion-sky17
{
	qer_editorImage skpk/qer/env/osirion/sky17.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 120 4
	nopicmip
	skyparms skpk/env/osirion/sky17 - -
}

textures/skies_MASTER3/osirion-sky18
{
	qer_editorImage skpk/qer/env/osirion/sky18.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 120 4
	nopicmip
	skyparms skpk/env/osirion/sky18 - -
}

textures/skies_MASTER3/osirion-sky19
{
	qer_editorImage skpk/qer/env/osirion/sky19.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 120 4
	nopicmip
	skyparms skpk/env/osirion/sky19 - -
}

textures/skies_MASTER3/osirion-sky20
{
	qer_editorImage skpk/qer/env/osirion/sky20.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 120 4
	nopicmip
	skyparms skpk/env/osirion/sky20 - -
}

//============================================

textures/skies_MASTER3/14-above
{
	qer_editorImage skpk/qer/env/14/above/above.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 55 91 12 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 80 4
	nopicmip
	skyparms skpk/env/14/above/above - -
}

textures/skies_MASTER3/14-city-day
{
	qer_editorImage skpk/qer/env/14/city-day/city-day.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms skpk/env/14/city-day/city-day - -
}

textures/skies_MASTER3/14-city-night
{
	qer_editorImage skpk/qer/env/14/city-night/city-night.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 125 4
	nopicmip
	skyparms skpk/env/14/city-night/city-night - -
}

textures/skies_MASTER3/14-cloudy
{
	qer_editorImage skpk/qer/env/14/cloudy/cloudy.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms skpk/env/14/cloudy/cloudy - -
}

textures/skies_MASTER3/14-dark
{
	qer_editorImage skpk/qer/env/14/dark/dark.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 65 -56 37 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 75 4
	nopicmip
	skyparms skpk/env/14/dark/dark - -
}

textures/skies_MASTER3/14-darkening
{
	qer_editorImage skpk/qer/env/14/darkening/darkening.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 65 -170 23 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 75 4
	nopicmip
	skyparms skpk/env/14/darkening/darkening - -
}

textures/skies_MASTER3/14-dawn
{
	qer_editorImage skpk/qer/env/14/dawn/dawn.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 50 48 36 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 80 4
	nopicmip
	skyparms skpk/env/14/dawn/dawn - -
}

textures/skies_MASTER3/14-dusk
{
	qer_editorImage skpk/qer/env/14/dusk/dusk.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 65 -165 20 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 75 4
	nopicmip
	skyparms skpk/env/14/dusk/dusk - -
}

textures/skies_MASTER3/14-fog
{
	qer_editorImage skpk/qer/env/14/fog/fog.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms skpk/env/14/fog/fog - -
}

textures/skies_MASTER3/14-mountain
{
	qer_editorImage skpk/qer/env/14/mountain/mountain.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms skpk/env/14/mountain/mountain - -
}

textures/skies_MASTER3/14-night
{
	qer_editorImage skpk/qer/env/14/night/night.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 130 4
	nopicmip
	skyparms skpk/env/14/night/night - -
}

textures/skies_MASTER3/14-redsky
{
	qer_editorImage skpk/qer/env/14/redsky/redsky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 120 4
	nopicmip
	skyparms skpk/env/14/redsky/redsky - -
}

textures/skies_MASTER3/14-sky
{
	qer_editorImage skpk/qer/env/14/sky/sky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms skpk/env/14/sky/sky - -
}

textures/skies_MASTER3/14-village
{
	qer_editorImage skpk/qer/env/14/village/village.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms skpk/env/14/village/village - -
}

//============================================

textures/skies_MASTER3/avoc_arabian_nights
{
	qer_editorImage skpk/qer/textures/arabian_nights/arabian_nights.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.85098 0.6 0.258824 65 -96 7 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 80 4
	nopicmip
	skyParms skpk/textures/arabian_nights/arabian_nights - -
}

textures/skies_MASTER3/avoc_darkness
{
	qer_editorImage skpk/qer/textures/darkness_sky/darkness_sky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.68 0.68 0.90 85 -93 51 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 75 4
	nopicmip
	skyParms skpk/textures/darkness_sky/darkness_sky - -
}

textures/skies_MASTER3/avoc_endless
{
	qer_editorImage skpk/qer/textures/endless_sky/endless.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 .9 .8 80 -87 23 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 80 4
	nopicmip
	skyParms skpk/textures/endless_sky/endless - -
}

textures/skies_MASTER3/avoc_frozen
{
	qer_editorImage skpk/qer/textures/frozen_sky/frozen.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.90 0.68 0.77 80 -138 11 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 100 4
	nopicmip
	skyParms skpk/textures/frozen_sky/frozen - -
}

textures/skies_MASTER3/avoc_heat
{
	qer_editorImage skpk/qer/textures/heat_sky/heat.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.901961 0.745098 0.384314 80 -177 4 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 75 4
	nopicmip
	skyParms skpk/textures/heat_sky/heat - -
}

textures/skies_MASTER3/avoc_horizon
{
	qer_editorImage skpk/qer/textures/horizon_sky/horizon.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 .8 .7 50 90 35 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 100 4
	nopicmip
	skyParms skpk/textures/horizon_sky/horizon - -
}

textures/skies_MASTER3/avoc_overcast
{
	qer_editorImage skpk/qer/textures/overcast_sky/overcast.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 130 4
	nopicmip
	skyParms skpk/textures/overcast_sky/overcast - -
}

textures/skies_MASTER3/avoc_overcast-clouds
{
	qer_editorImage skpk/qer/textures/overcast_sky/overcast-clouds.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyParms skpk/textures/overcast_sky/overcast 2048 -
	{
		map skpk/textures/avoc_common/blue_detailed_clouds.tga
		blendfunc gl_src_alpha gl_one_minus_src_alpha
		tcMod scroll 0.005 0.005
		tcmod scale 3 3
	}
}

textures/skies_MASTER3/avoc_rufus
{
	qer_editorImage skpk/qer/textures/rufus_sky/rufus_sky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 130 4
	nopicmip
	skyParms skpk/textures/rufus_sky/rufus_sky - -
}

textures/skies_MASTER3/avoc_turbulent
{
	qer_editorImage skpk/qer/textures/turbulent_blue/turbulent.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt .9 .9 .9 50 -126 27 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 105 4
	nopicmip
	skyParms skpk/textures/turbulent_blue/turbulent - -
}

textures/skies_MASTER3/avoc_vanilla
{
	qer_editorImage skpk/qer/textures/vanilla_sky/vanilla_sky-clouds.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt .9 .8 .85 80 55 12 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 60 4
	nopicmip
	skyParms skpk/textures/vanilla_sky/vanilla_sky 2048 -
	{
		map skpk/textures/avoc_common/vanilla_clouds.tga
		blendfunc gl_src_alpha gl_one_minus_src_alpha
		tcMod scroll -0.025 0.025
		tcmod scale 1 1
	}
}

textures/skies_MASTER3/avoc_vanilla_frost
{
	qer_editorImage skpk/qer/textures/vanilla_sky/vanilla_sky_frost-clouds.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt .9 .8 .85 70 -128 11 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 75 4
	nopicmip
	skyParms skpk/textures/vanilla_sky/vanilla_sky_frost 2048 -
	{
		map skpk/textures/avoc_common/vanilla_clouds.tga
		blendfunc gl_src_alpha gl_one_minus_src_alpha
		tcMod scroll -0.025 0.025
		tcmod scale 1 1
	}
}

textures/skies_MASTER3/eksha_cosmos1
{
	qer_editorImage skpk/qer/env/eksha_cosmos/cosmos.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt .9 .9 .9 85 86 -8 3 16
	q3map_LightMapFilterRadius 0 8
	q3map_skyLight 65 4
	nopicmip
	skyparms skpk/env/eksha_cosmos/cosmos - -
}

//mix of good and bad skies below :) pulled from JK Hub

textures/skies_MASTER3/abregaddo
{
	qer_editorImage skpk/qer/env/abregaddo/abregado.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 5 123 45 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 95 4
	nopicmip
	skyparms skpk/env/abregaddo/abregado - -
}

textures/skies_MASTER3/acceh
{
	qer_editorImage skpk/qer/env/acceh/skyr.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 100 4
	nopicmip
	skyparms skpk/env/acceh/skyr - -
}

textures/skies_MASTER3/korb-aeten
{
	qer_editorImage skpk/qer/env/aeten/aeten.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 35 -89 46 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 60 4
	nopicmip
	skyparms skpk/env/aeten/aeten - -
}

textures/skies_MASTER3/byss-asteroids
{
	qer_editorImage skpk/qer/env/ald_skies/alderaan_space.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.792157 0.694118 0.45098 55 -153 25 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 60 4
	nopicmip
	skyparms skpk/env/ald_skies/alderaan_space - -
}

textures/skies_MASTER3/Arrevanous
{
	qer_editorImage skpk/qer/env/Arrevanous/Arrevanous.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 90 4
	nopicmip
	skyparms skpk/env/Arrevanous/Arrevanous - -
}

textures/skies_MASTER3/asia
{
	qer_editorImage skpk/qer/env/asia/asky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 20 -11 66 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 90 4
	nopicmip
	skyparms skpk/env/asia/asky - -
}

textures/skies_MASTER3/byss-asteroids2
{
	qer_editorImage skpk/qer/env/asteroid_3/asteroid.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 10 171 22 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 85 4
	nopicmip
	skyparms skpk/env/asteroid_3/asteroid - -
}

textures/skies_MASTER3/atlantica
{
	qer_editorImage skpk/qer/env/atlantica/atlantica.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 75 40 27 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 60 4
	nopicmip
	skyparms skpk/env/atlantica/atlantica - -
}

textures/skies_MASTER3/atmo
{
	qer_editorImage skpk/qer/env/atmo/atmo_skybox.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 65 148 12 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 55 4
	nopicmip
	skyparms skpk/env/atmo/atmo_skybox - -
}

textures/skies_MASTER3/basesky
{
	qer_editorImage skpk/qer/env/basesky/basesky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 30 -43 66 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 60 4
	nopicmip
	skyparms skpk/env/basesky/basesky - -
}

textures/skies_MASTER3/sfspace-battleover
{
	qer_editorImage skpk/qer/env/battleover/space.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 105 4
	nopicmip
	skyparms skpk/env/battleover/space - -
}

textures/skies_MASTER2/bespin-dusk
{
	qer_editorImage skpk/qer/env/bcorsky/bcorsky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 90 4
	nopicmip
	skyparms skpk/env/bcorsky/bcorsky - -
}

textures/skies_MASTER3/bespin
{
	qer_editorImage skpk/qer/env/bespin/bespin.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 90 4
	nopicmip
	skyparms skpk/env/bespin/bespin - -
}

textures/skies_MASTER3/bespin_blue
{
	qer_editorImage skpk/qer/env/bespin_blue/bespin.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt .997 .924 .418 75 92 4 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 60 4
	nopicmip
	skyparms skpk/env/bespin_blue/bespin - -
}

textures/skies_MASTER3/bespin_city
{
	qer_editorImage skpk/qer/env/bespin_city/jh3.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 45 135 30 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/bespin_city/jh3 - -
}

textures/skies_MASTER3/bespin_red
{
	qer_editorImage skpk/qer/env/bespin_red/redonly.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt .997 .710 .418 55 -160 19 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 60 4
	nopicmip
	skyparms skpk/env/bespin_red/redonly - -
}

textures/skies_MASTER3/bespin_shaft
{
	qer_editorImage skpk/qer/env/bespin_shaft/shaft.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 95 4
	nopicmip
	skyparms skpk/env/bespin_shaft/shaft - -
}

textures/skies_MASTER/hip_stormy-saturated
{
	qer_editorImage skpk/qer/env/bespin_sky/Bespin.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt .997 .710 .418 75 134 18 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/bespin_sky/Bespin - -
}

textures/skies_MASTER3/bespin2
{
	qer_editorImage skpk/qer/env/bespinsky/bespinsky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 55 164 33 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 60 4
	nopicmip
	skyparms skpk/env/bespinsky/bespinsky - -
}

textures/skies_MASTER3/jk_blue
{
	qer_editorImage skpk/qer/env/jk_blue/Blue.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 70 -88 21 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/jk_blue/Blue - -
}

textures/skies_MASTER3/bodhisattva
{
	qer_editorImage skpk/qer/env/bodhisattva/Bodhisattva.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 55 55 56 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 60 4
	nopicmip
	skyparms skpk/env/bodhisattva/Bodhisattva - -
}

textures/skies_MASTER3/bramblegambo
{
	qer_editorImage skpk/qer/env/bramblegambol2/bg2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt .997 .710 .418 75 90 11 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 60 4
	nopicmip
	skyparms skpk/env/bramblegambol2/bg2 - -
}

textures/skies_MASTER3/callisto
{
	qer_editorImage skpk/qer/env/callisto/callisto.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 55 124 77 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/callisto/callisto - -
}

textures/skies_MASTER3/casa_fog
{
	qer_editorImage skpk/qer/env/cantina_desert/desert.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 60 -72 83 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 60 4
	nopicmip
	skyparms skpk/env/cantina_desert/desert - -
}

textures/skies_MASTER3/casa_day
{
	qer_editorImage skpk/qer/env/casa_day/casa.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 75 -74 83 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 60 4
	nopicmip
	skyparms skpk/env/casa_day/casa - -
}

textures/skies_MASTER3/casa_night
{
	qer_editorImage skpk/qer/env/casa_night/casa_n.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 5 -92 80 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms skpk/env/casa_night/casa_n - -
}

textures/skies_MASTER3/ch_clearsky
{
	qer_editorImage skpk/qer/env/ch/ch.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 125 4
	nopicmip
	skyparms skpk/env/ch/ch - -
}

textures/skies_MASTER3/midgar_plains2
{
	qer_editorImage skpk/qer/env/chocobranch/chocoboranchv3.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 55 0 90 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 60 4
	nopicmip
	skyparms skpk/env/chocobranch/chocoboranchv3 - -
}

textures/skies_MASTER3/midgard_slums-whiteFog
{
	qer_editorImage skpk/qer/env/churchv3/churchv3.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms skpk/env/churchv3/churchv3 - -
}

textures/skies_MASTER3/clsky
{
	qer_editorImage skpk/qer/env/clsky/clsky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 35 -110 19 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/clsky/clsky - -
}

textures/skies_MASTER3/coruscant-lower
{
	qer_editorImage skpk/qer/env/cor_lowersky/sky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 35 90 41 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 80 4
	nopicmip
	skyparms skpk/env/cor_lowersky/sky - -
}

textures/skies_MASTER3/coruscant-day
{
	qer_editorImage skpk/qer/env/corday/corday.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 20 -165 82 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 90 4
	nopicmip
	skyparms skpk/env/corday/corday - -
}

textures/skies_MASTER3/sfspace-core
{
	qer_editorImage skpk/qer/env/corespace/corespace.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_lightRGB 1 1 1
	q3map_skylight 130 4 0 90 0
	nopicmip
	skyparms skpk/env/corespace/corespace - -
}

textures/skies_MASTER3/coru
{
	qer_editorImage skpk/qer/env/coru/coru.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt .982 .821 .657 80 -44 2 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 60 4
	nopicmip
	skyparms skpk/env/coru/coru - -
}

textures/skies_MASTER3/corusantsky
{
	qer_editorImage skpk/qer/env/corusantsky/coruscantsky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 120 4
	nopicmip
	skyparms skpk/env/corusantsky/coruscantsky - -
}

textures/skies_MASTER3/coruscant
{
	qer_editorImage skpk/qer/env/coruscant/cor.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 110 4
	nopicmip
	skyparms skpk/env/coruscant/cor - -
}

textures/skies_MASTER3/cosmo
{
	qer_editorImage skpk/qer/env/cosmo/cosmo.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 110 4
	nopicmip
	skyparms skpk/env/cosmo/cosmo - -
}

textures/skies_MASTER2/bespin-taris
{
	qer_editorImage skpk/qer/env/cotaris_sky/taris.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 105 4
	nopicmip
	skyparms skpk/env/cotaris_sky/taris - -
}

textures/skies_MASTER3/crt_sky
{
	qer_editorImage skpk/qer/env/crt_sky/crt_sky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 75 117 7 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 75 4
	nopicmip
	skyparms skpk/env/crt_sky/crt_sky - -
}

textures/skies_MASTER3/crt_sky2
{
	qer_editorImage skpk/qer/env/crt_sky2/crt_sky2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 75 117 7 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 65 4
	nopicmip
	skyparms skpk/env/crt_sky2/crt_sky2 - -
}

textures/skies_MASTER3/cthulhu
{
	qer_editorImage skpk/qer/env/cthulhu/cthulhu.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 35 29 40 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 85 4
	nopicmip
	skyparms skpk/env/cthulhu/cthulhu - -
}

textures/skies_MASTER3/ctw
{
	qer_editorImage skpk/qer/env/ctw/ctw.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 0.859 0 25 -172 26 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/ctw/ctw - -
}

textures/skies_MASTER3/jk_yavin-hot
{
	qer_editorImage skpk/qer/env/dantooine/dantooine.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 45 -165 80 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 60 4
	nopicmip
	skyparms skpk/env/dantooine/dantooine - -
}

textures/skies_MASTER3/dantooine2
{
	qer_editorImage skpk/qer/env/dantooine2/dantooine.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 75 135 20 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 60 4
	nopicmip
	skyparms skpk/env/dantooine2/dantooine - -
}

textures/skies_MASTER2/dos-red
{
	qer_editorImage skpk/qer/env/darklord/sky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 110 4
	nopicmip
	skyparms skpk/env/darklord/sky - -
}

textures/skies_MASTER3/darkpalace
{
	qer_editorImage skpk/qer/env/darkpalace/jk1_darkpalace.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 110 4
	nopicmip
	skyparms skpk/env/darkpalace/jk1_darkpalace - -
}

textures/skies_MASTER3/darkside
{
	qer_editorImage skpk/qer/env/darkside/darkside.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 100 4
	nopicmip
	skyparms skpk/env/darkside/darkside - -
}

textures/skies_MASTER3/day
{
	qer_editorImage skpk/qer/env/day/day.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 75 178 6 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/day/day - -
}

textures/skies_MASTER3/hevil-dark
{
	qer_editorImage skpk/qer/env/denon/denon.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 90 4
	nopicmip
	skyparms skpk/env/denon/denon - -
}

textures/skies_MASTER3/desert_evening
{
	qer_editorImage skpk/qer/env/desert_evening/Desert_evening.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 100 4
	nopicmip
	skyparms skpk/env/desert_evening/Desert_evening - -
}

textures/skies_MASTER3/sfspace-dje
{
	qer_editorImage skpk/qer/env/dje_skybox/dje_tat_space.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 60 -81 8 2 16                //white planet
	q3map_sunExt 1 .816 .495 75 71 6 2 16           //orange planet
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 60 4
	nopicmip
	skyparms skpk/env/dje_skybox/dje_tat_space - -
}

textures/skies_MASTER3/dje_tatooine
{
	qer_editorImage skpk/qer/env/dje_tatooine/dje_tatooine.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 .641 .182 50 -116 79 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/dje_tatooine/dje_tatooine - -
}

textures/skies_MASTER3/korb-dos
{
	qer_editorImage skpk/qer/env/dos/dos.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 20 123 50 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 80 4
	nopicmip
	skyparms skpk/env/dos/dos - -
}

textures/skies_MASTER3/dsky
{
	qer_editorImage skpk/qer/env/dsky/dsky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 35 -175 63 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 60 4
	nopicmip
	skyparms skpk/env/dsky/dsky - -
}

textures/skies_MASTER3/emp_to
{
	qer_editorImage skpk/qer/env/emp_to/space.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 35 -124 61 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/emp_to/space - -
}

textures/skies_MASTER3/endor
{
	qer_editorImage skpk/qer/env/endor/endor.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 75 -88 45 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/endor/endor - -
}

textures/skies_MASTER4/64elysky1-satellite
{
	qer_editorImage skpk/qer/env/endor_sky/endor2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 75 -63 26 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/endor_sky/endor2 - -
}

textures/skies_MASTER3/erulanei
{
	qer_editorImage skpk/qer/env/erulanei/erulanei.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 65 85 80 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 55 4
	nopicmip
	skyparms skpk/env/erulanei/erulanei - -
}

textures/skies_MASTER3/estate
{
	qer_editorImage skpk/qer/env/estate/estate.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 90 4
	nopicmip
	skyparms skpk/env/estate/estate - -
}

textures/skies_MASTER3/abregaddo-eviltwin
{
	qer_editorImage skpk/qer/env/eviltwin/eviltwin.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 5 123 40 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 100 4
	nopicmip
	skyparms skpk/env/eviltwin/eviltwin - -
}

textures/skies_MASTER3/face
{
	qer_editorImage skpk/qer/env/face/sky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 75 -115 37 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 60 4
	nopicmip
	skyparms skpk/env/face/sky - -
}

textures/skies_MASTER3/kaminosjc-fog
{
	qer_editorImage skpk/qer/env/farcry/farcry.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.963 0.926 0.652 25 122 49 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 80 4
	nopicmip
	skyparms skpk/env/farcry/farcry - -
}

textures/skies_MASTER3/fatal
{
	qer_editorImage skpk/qer/env/fatal/fatal.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.981 0.936 0.594 75 8 31 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 60 4
	nopicmip
	skyparms skpk/env/fatal/fatal - -
}

textures/skies_MASTER2/bespin-fog
{
	qer_editorImage skpk/qer/env/fearis/fearis.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 100 4
	nopicmip
	skyparms skpk/env/fearis/fearis - -
}

textures/skies_MASTER3/fer_sector
{
	qer_editorImage skpk/qer/env/fer_sector/ferosky1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 65 173 8 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/fer_sector/ferosky1 - -
}

textures/skies_MASTER3/galaxy
{
	qer_editorImage skpk/qer/env/galaxy/galaxy.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 15 65 27 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 90 4
	nopicmip
	skyparms skpk/env/galaxy/galaxy - -
}

textures/skies_MASTER3/garrison
{
	qer_editorImage skpk/qer/env/garrison/tatdusk.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.965 0.908 0.498 50 90 14 2 16            //yellow sun
	q3map_sunExt 0.990 0.651 0.651 50 82 5 2 16             //red sun
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 80 4
	nopicmip
	skyparms skpk/env/garrison/tatdusk - -
}

textures/skies_MASTER2/dos-arid
{
	qer_editorImage skpk/qer/env/geosky/geosky_arid.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 45 -134 38 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/geosky/geosky_arid - -
}

textures/skies_MASTER3/gjs3
{
	qer_editorImage skpk/qer/env/gjs3/SKY_001.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 100 4
	nopicmip
	skyparms skpk/env/gjs3/SKY_001 - -
}

textures/skies_MASTER3/wedge-grey
{
	qer_editorImage skpk/qer/env/graveyard/graveyard.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 15 27 19 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 95 4
	nopicmip
	skyparms skpk/env/graveyard/graveyard - -
}

textures/skies_MASTER6/0color_greyLight
{
	qer_editorImage skpk/qer/env/grey/grey.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 85 4
	nopicmip
	skyparms skpk/env/grey/grey - -
}

textures/skies_MASTER3/grid
{
	qer_editorImage skpk/qer/env/grid/grid.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 75 4
	nopicmip
	skyparms skpk/env/grid/grid - -
}

textures/skies_MASTER3/gungan
{
	qer_editorImage skpk/qer/env/gungan/gungan.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 30 -166 80 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 60 4
	nopicmip
	skyparms skpk/env/gungan/gungan - -
}

textures/skies_MASTER3/h2o
{
	qer_editorImage skpk/qer/env/h2o/h2o.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/h2o/h2o - -
}

textures/skies_MASTER3/hallo
{
	qer_editorImage skpk/qer/env/hallo/hallo.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 25 156 32 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 80 4
	nopicmip
	skyparms skpk/env/hallo/hallo - -
}

textures/skies_MASTER3/homestead_day
{
	qer_editorImage skpk/qer/env/homestead_day/sjcday.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 50 177 55 2 16
	q3map_sunExt 1 1 1 50 168 50 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/homestead_day/sjcday - -
}

textures/skies_MASTER3/homestead_night
{
	qer_editorImage skpk/qer/env/homestead_night/sjctat.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 .567 .371 75 140 7.5 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 60 4
	nopicmip
	skyparms skpk/env/homestead_night/sjctat - -
}

textures/skies_MASTER3/hoth
{
	qer_editorImage skpk/qer/env/hoth/sky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 75 152 26 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/hoth/sky - -
}

textures/skies_MASTER3/abregaddo-hyperbolic
{
	qer_editorImage skpk/qer/env/hyperbolic/hyperbolic.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 90 4
	nopicmip
	skyparms skpk/env/hyperbolic/hyperbolic - -
}

textures/skies_MASTER3/ice_
{
	qer_editorImage skpk/qer/env/ice_/ice.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt .281 .314 1 30 164 82 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/ice_/ice - -
}

textures/skies_MASTER3/hevil-blue
{
	qer_editorImage skpk/qer/env/ilum/ilum.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 90 4
	nopicmip
	skyparms skpk/env/ilum/ilum - -
}

textures/skies_MASTER3/isle_of_cthulu
{
	qer_editorImage skpk/qer/env/isle_of_cthulu/isle_of_cthulhu.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 75 -20 79 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 60 4
	nopicmip
	skyparms skpk/env/isle_of_cthulu/isle_of_cthulhu - -
}

textures/skies_MASTER3/jedha
{
	qer_editorImage skpk/qer/env/jedha/pyro_jedha_sky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 55 127 6 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 60 4
	nopicmip
	skyparms skpk/env/jedha/pyro_jedha_sky - -
}

textures/skies_MASTER3/jedi_temple
{
	qer_editorImage skpk/qer/env/jedi_temple/jeditemple.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 90 4
	nopicmip
	skyparms skpk/env/jedi_temple/jeditemple - -
}

textures/skies_MASTER3/jedi_temple2/
{
	qer_editorImage skpk/qer/env/jedi_temple2/jeditemple.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 90 4
	nopicmip
	skyparms skpk/env/jedi_temple2/jeditemple - -
}

textures/skies_MASTER3/jjhmt
{
	qer_editorImage skpk/qer/env/jjhmt/jjhmtsky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 45 59 21 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 75 4
	nopicmip
	skyparms skpk/env/jjhmt/jjhmtsky - -
}

textures/skies_MASTER3/jk_council_city
{
	qer_editorImage skpk/qer/env/jk_council_city/city.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 30 -100 11 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/jk_council_city/city - -
}

textures/skies_MASTER3/sfspace-jk
{
	qer_editorImage skpk/qer/env/jk_space/space.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_lightRGB 1 1 1
	q3map_skylight 120 4 0 90 0
	nopicmip
	skyparms skpk/env/jk_space/space - -
}

textures/skies_MASTER3/jk3pirates
{
	qer_editorImage skpk/qer/env/jk3pirates/jk3piratas.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 75 70 11 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 60 4
	nopicmip
	skyparms skpk/env/jk3pirates/jk3piratas - -
}

textures/skies_MASTER3/kaminosjc
{
	qer_editorImage skpk/qer/env/kaminosjc/kaminosjc.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 25 122 49 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 80 4
	nopicmip
	skyparms skpk/env/kaminosjc/kaminosjc - -
}

textures/skies_MASTER2/dos-fog
{
	qer_editorImage skpk/qer/env/kas/kas.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 65 -134 38 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/kas/kas - -
}

textures/skies_MASTER3/jk_yavin-dark
{
	qer_editorImage skpk/qer/env/kharzet/kharzet.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 10 -167 82 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 90 4
	nopicmip
	skyparms skpk/env/kharzet/kharzet - -
}

textures/skies_MASTER3/wedge-orange
{
	qer_editorImage skpk/qer/env/kor2/kor.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 110 4
	nopicmip
	skyparms skpk/env/kor2/kor - -
}

textures/skies_MASTER3/korb-red
{
	qer_editorImage skpk/qer/env/korb/korb.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 .264 .240 55 -90 46 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 60 4
	nopicmip
	skyparms skpk/env/korb/korb - -
}

textures/skies_MASTER3/korb-fog
{
	qer_editorImage skpk/qer/env/korb2/korb.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 .873 .537 60 -89 47 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/korb2/korb - -
}

textures/skies_MASTER3/korriban
{
	qer_editorImage skpk/qer/env/korriban/korriban.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 0.537 .9 55 90 3 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 60 4
	nopicmip
	skyparms skpk/env/korriban/korriban - -
}

textures/skies_MASTER3/wedge
{
	qer_editorImage skpk/qer/env/krildor/krildor.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 105 4
	nopicmip
	skyparms skpk/env/krildor/krildor - -
}

textures/skies_MASTER3/lastnight
{
	qer_editorImage skpk/qer/env/lastnight/ls.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 25 93 35 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 80 4
	nopicmip
	skyparms skpk/env/lastnight/ls - -
}

textures/skies_MASTER3/sfspace-leviathan2
{
	qer_editorImage skpk/qer/env/leviathan2/leviathan.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 100 4
	nopicmip
	skyparms skpk/env/leviathan2/leviathan - -
}

textures/skies_MASTER3/little_italy_sky
{
	qer_editorImage skpk/qer/env/little_italy_sky/little_italy.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt .955 .627 .262 75 -8 4 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 60 4
	nopicmip
	skyparms skpk/env/little_italy_sky/little_italy - -
}

textures/skies_MASTER3/casa_city
{
	qer_editorImage skpk/qer/env/lobby/lobby.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 75 -76 83 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 60 4
	nopicmip
	skyparms skpk/env/lobby/lobby - -
}

textures/skies_MASTER3/lowrezspace
{
	qer_editorImage skpk/qer/env/lowrezspace/sky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 85 4
	nopicmip
	skyparms skpk/env/lowrezspace/sky - -
}

textures/skies_MASTER3/mantell_skies
{
	qer_editorImage skpk/qer/env/mantell_skies/city.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 60 41 31 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/mantell_skies/city - -
}

textures/skies_MASTER3/mario
{
	qer_editorImage skpk/qer/env/mario/mariostyle.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 80 4
	nopicmip
	skyparms skpk/env/mario/mariostyle - -
}

textures/skies_MASTER3/y4sky1-dark
{
	qer_editorImage skpk/qer/env/massassi/sky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 65 -89 61 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/massassi/sky - -
}

textures/skies_MASTER3/y4sky1-night-clouds
{
	qer_editorImage skpk/qer/env/massassi_clouds/skyn-clouds.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_lightRGB 1 1 1
	q3map_skylight 135 4 0 90 0
	nopicmip
	skyparms skpk/env/massassi_clouds/skyn - -
	{
		map skpk/env/massassi_clouds/sky-cloudlayer.tga
		blendFunc GL_ONE GL_ONE
		tcMod scale 3 3
		tcMod scroll 0.01 0.02
	}
}

textures/skies_MASTER3/y4sky1-night
{
	qer_editorImage skpk/qer/env/massassi_clouds/skyn.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 90 4
	nopicmip
	skyparms skpk/env/massassi_clouds/skyn - -
}

textures/skies_MASTER3/matrix_day
{
	qer_editorImage skpk/qer/env/matrix_day/matrixv4.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 75 -77 83 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 60 4
	nopicmip
	skyparms skpk/env/matrix_day/matrixv4 - -
}

textures/skies_MASTER3/matrix_night
{
	qer_editorImage skpk/qer/env/matrix_night/nathnite.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 120 4
	nopicmip
	skyparms skpk/env/matrix_night/nathnite - -
}

textures/skies_MASTER3/mccontest
{
	qer_editorImage skpk/qer/env/mccontest/cyansky1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 30 92 3 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 120 4
	nopicmip
	skyparms skpk/env/mccontest/cyansky1 - -
}

textures/skies_MASTER2/mcsky3
{
	qer_editorImage skpk/qer/env/mcSky/mc.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 75 -154 67 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 60 4
	nopicmip
	skyparms skpk/env/mcSky/mc - -
}

textures/skies_MASTER3/jk_yavin-darker
{
	qer_editorImage skpk/qer/env/mechsky/JA_yavin.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 5 162 59 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 120 4
	nopicmip
	skyparms skpk/env/mechsky/JA_yavin - -
}

textures/skies_MASTER3/midgar_highway
{
	qer_editorImage skpk/qer/env/midgar_highway/midgarhighwayv3.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.390 1 0.222 15 -29 16 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 80 4
	nopicmip
	skyparms skpk/env/midgar_highway/midgarhighwayv3 - -
}

textures/skies_MASTER3/midgar_old
{
	qer_editorImage skpk/qer/env/midgar_old/midgarv3old.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 15 -36 56 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 90 4
	nopicmip
	skyparms skpk/env/midgar_old/midgarv3old - -
}

textures/skies_MASTER3/midgar_plains
{
	qer_editorImage skpk/qer/env/midgar_plains/midgarplains.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 15 -36 56 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 90 4
	nopicmip
	skyparms skpk/env/midgar_plains/midgarplains - -
}

textures/skies_MASTER3/jk_yavin-midgar
{
	qer_editorImage skpk/qer/env/midgar_valley/midgarv3.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 105 4
	nopicmip
	skyparms skpk/env/midgar_valley/midgarv3 - -
}

textures/skies_MASTER3/midgard_shinra
{
	qer_editorImage skpk/qer/env/midgard_shinra/shinrahqv3high.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 15 -38 56 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 80 4
	nopicmip
	skyparms skpk/env/midgard_shinra/shinrahqv3high - -
}

textures/skies_MASTER3/midgard_shinra_low
{
	qer_editorImage skpk/qer/env/midgard_shinra_low/shinrahqv3low.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 25 28 14 2 16        //left
	q3map_sunExt 1 1 1 25 -28 14 2 16       //right
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/midgard_shinra_low/shinrahqv3low - -
}

textures/skies_MASTER3/midgard_slums
{
	qer_editorImage skpk/qer/env/midgard_slums/slumsv3.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 10 89 43 2 16
	q3map_sunExt 1 1 1 10 -89 42 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 60 4
	nopicmip
	skyparms skpk/env/midgard_slums/slumsv3 - -
}

//this is insane

textures/skies_MASTER3/midnightdreams
{
	qer_editorImage skpk/qer/env/midnightdreams/midnightdreams.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 50 -40 33 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/midnightdreams/midnightdreams - -
}

textures/skies_MASTER3/minecraft
{
	qer_editorImage skpk/qer/env/minecraft/minecraft.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 75 90 67 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/minecraft/minecraft - -
}

textures/skies_MASTER3/mistysky
{
	qer_editorImage skpk/qer/env/mistysky/mistysky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 60 0 90 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/mistysky/mistysky - -
}

textures/skies_MASTER3/byss-huePlanets
{
	qer_editorImage skpk/qer/env/mkbkyavinp/mkbkyavinp.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 .695 .222 75 176 14 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 60 4
	nopicmip
	skyparms skpk/env/mkbkyavinp/mkbkyavinp - -
}

textures/skies_MASTER3/mmg-hoth
{
	qer_editorImage skpk/qer/env/mmg-hoth/hothsky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 60 61 49 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/mmg-hoth/hothsky - -
}

textures/skies_MASTER3/moes_tavern
{
	qer_editorImage skpk/qer/env/moes_tavern/moes_sky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 100 4
	nopicmip
	skyparms skpk/env/moes_tavern/moes_sky - -
}

textures/skies_MASTER3/moonbase
{
	qer_editorImage skpk/qer/env/moonbase/moonbasesky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_lightRGB 0.55874 0.547051 0.518029
	q3map_skylight 135 4 0 90 0
	nopicmip
	skyparms skpk/env/moonbase/moonbasesky - -
}

textures/skies_MASTER3/korb-moost
{
	qer_editorImage skpk/qer/env/moost/moost.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 10 123 49 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 95 4
	nopicmip
	skyparms skpk/env/moost/moost - -
}

textures/skies_MASTER3/wedge-blueishGrey
{
	qer_editorImage skpk/qer/env/mots_skies/mots.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 110 4
	nopicmip
	skyparms skpk/env/mots_skies/mots - -
}

textures/skies_MASTER3/muf
{
	qer_editorImage skpk/qer/env/muf/muf.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.987869 0.405539 0.383642 35 -133 12 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/muf/muf - -
}

textures/skies_MASTER3/hevil-fog
{
	qer_editorImage skpk/qer/env/mygeeto/myg.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 90 4
	nopicmip
	skyparms skpk/env/mygeeto/myg - -
}

textures/skies_MASTER3/nab
{
	qer_editorImage skpk/qer/env/nab/nab.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 60 -116 32 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/nab/nab - -
}

textures/skies_MASTER3/naboo
{
	qer_editorImage skpk/qer/env/naboo/naboo.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 70 150 16 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/naboo/naboo - -
}

textures/skies_MASTER3/naboo_day
{
	qer_editorImage skpk/qer/env/naboo_day/naboo.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 60 -165 82 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 75 4
	nopicmip
	skyparms skpk/env/naboo_day/naboo - -
}

textures/skies_MASTER3/naboo_night
{
	qer_editorImage skpk/qer/env/naboo_night/naboonight12.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 15 108 34 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 85 4
	nopicmip
	skyparms skpk/env/naboo_night/naboonight12 - -
}

textures/skies_MASTER3/naboo_sky
{
	qer_editorImage skpk/qer/env/naboo_sky/naboo_sky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 25 -29 24 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 90 4
	nopicmip
	skyparms skpk/env/naboo_sky/naboo_sky - -
}

textures/skies_MASTER3/naboo_sunset
{
	qer_editorImage skpk/qer/env/naboo_sunset/naboosunset01.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.987854 0.791867 0.383627 30 60 24 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 75 4
	nopicmip
	skyparms skpk/env/naboo_sunset/naboosunset01 - -
}

textures/skies_MASTER3/Namaste
{
	qer_editorImage skpk/qer/env/Namaste/Namaste.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 0.306004 0.330541 45 149 12 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 80 4
	nopicmip
	skyparms skpk/env/Namaste/Namaste - -
}

textures/skies_MASTER3/nebula_skybox
{
	qer_editorImage skpk/qer/env/nebula_skybox/nebula_skybox.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 95 4
	nopicmip
	skyparms skpk/env/nebula_skybox/nebula_skybox - -
}

textures/skies_MASTER3/hevil-brightBlue
{
	qer_editorImage skpk/qer/env/nelvaan/nelvaan.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 80 4
	nopicmip
	skyparms skpk/env/nelvaan/nelvaan - -
}

textures/skies_MASTER3/neotokyo
{
	qer_editorImage skpk/qer/env/neotokyo/neotokyosky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 20 -107 76 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 80 4
	nopicmip
	skyparms skpk/env/neotokyo/neotokyosky - -
}

textures/skies_MASTER3/night
{
	qer_editorImage skpk/qer/env/night/night.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 110 4
	nopicmip
	skyparms skpk/env/night/night - -
}

textures/skies_MASTER3/night_skybox
{
	qer_editorImage skpk/qer/env/night_skybox/night_skybox.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 40 -92 29 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/night_skybox/night_skybox - -
}

textures/skies_MASTER3/ord1-fog
{
	qer_editorImage skpk/qer/env/nightfall/nightfall.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 10 -85 66 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 80 4
	nopicmip
	skyparms skpk/env/nightfall/nightfall - -
}

textures/skies_MASTER3/nightfallxmas
{
	qer_editorImage skpk/qer/env/nightfallxmas/nightfallxmas.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 50 100 5 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 65 4
	nopicmip
	skyparms skpk/env/nightfallxmas/nightfallxmas - -
}

textures/skies_MASTER3/ord1
{
	qer_editorImage skpk/qer/env/ord1/ord1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 95 4
	nopicmip
	skyparms skpk/env/ord1/ord1 - -
}

textures/skies_MASTER3/ordmantellcourtyard
{
	qer_editorImage skpk/qer/env/ordmantellcourtyard/ordmantell.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.858824 0.796078 0.564706 35 -89 14 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 75 4
	nopicmip
	skyparms skpk/env/ordmantellcourtyard/ordmantell - -
}

textures/skies_MASTER3/otahgunga
{
	qer_editorImage skpk/qer/env/otahgunga/gungansky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 55 0 90 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 60 4
	nopicmip
	skyparms skpk/env/otahgunga/gungansky - -
}

textures/skies_MASTER3/outlaw
{
	qer_editorImage skpk/qer/env/outlaw/outlaw.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 80 -29 62 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/outlaw/outlaw - -
}

textures/skies_MASTER3/casa_structure
{
	qer_editorImage skpk/qer/env/padme/pad.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 60 -78 82 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 60 4
	nopicmip
	skyparms skpk/env/padme/pad - -
}

textures/skies_MASTER3/naboo_sky2
{
	qer_editorImage skpk/qer/env/pcot/pcot1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 35 -29 25 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 75 4
	nopicmip
	skyparms skpk/env/pcot/pcot1 - -
}

textures/skies_MASTER3/peaks
{
	qer_editorImage skpk/qer/env/peaks/peaks.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 45 100 4 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 75 4
	nopicmip
	skyparms skpk/env/peaks/peaks - -
}

textures/skies_MASTER6/0color_pkmn
{
	qer_editorImage skpk/qer/env/pkmn/pkmn.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 100 4
	nopicmip
	skyparms skpk/env/pkmn/pkmn - -
}

textures/skies_MASTER3/hevil-structure
{
	qer_editorImage skpk/qer/env/pmygsky/pmygsky1a.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 20 -100 52 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 80 4
	nopicmip
	skyparms skpk/env/pmygsky/pmygsky1a - -
}

textures/skies_MASTER/mp_goldrush-rocks
{
	qer_editorImage skpk/qer/env/pnd/pnd.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 60 -159 59 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/pnd/pnd - -
}

textures/skies_MASTER3/wedge-greyMoon
{
	qer_editorImage skpk/qer/env/pro_grey/pro.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 95 4
	nopicmip
	skyparms skpk/env/pro_grey/pro - -
}

textures/skies_MASTER3/sfspace
{
	qer_editorImage skpk/qer/env/pro_night/sfspace.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_lightRGB 0.74902 0.721569 0.666667
	q3map_skylight 115 4 0 90 0
	nopicmip
	skyparms skpk/env/pro_night/sfspace - -
}

textures/skies_MASTER3/ras_sky
{
	qer_editorImage skpk/qer/env/ras_sky/ras.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 25 93 35 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 75 4
	nopicmip
	skyparms skpk/env/ras_sky/ras - -
}

textures/skies_MASTER3/wedge-red
{
	qer_editorImage skpk/qer/env/rattatak/rattatak.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 95 4
	nopicmip
	skyparms skpk/env/rattatak/rattatak - -
}

textures/skies_MASTER3/ravager
{
	qer_editorImage skpk/qer/env/ravager/ravager.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4 0 90 0
	nopicmip
	skyparms skpk/env/ravager/ravager - -
}

textures/skies_MASTER3/bespin3
{
	qer_editorImage skpk/qer/env/rbnight/rbnight.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 105 4
	nopicmip
	skyparms skpk/env/rbnight/rbnight - -
}

textures/skies_MASTER3/rebel
{
	qer_editorImage skpk/qer/env/rebel/rep.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 100 4
	nopicmip
	skyparms skpk/env/rebel/rep - -
}

textures/skies_MASTER3/redsaurus
{
	qer_editorImage skpk/qer/env/redsaurus/raxus.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 0.715618 0.469123 75 150 42 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 60 4
	nopicmip
	skyparms skpk/env/redsaurus/raxus - -
}

textures/skies_MASTER3/Retreat_sky
{
	qer_editorImage skpk/qer/env/Retreat_sky/Ocean.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 70 -29 23 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 60 4
	nopicmip
	skyparms skpk/env/Retreat_sky/Ocean - -
}

textures/skies_MASTER3/revansflagship
{
	qer_editorImage skpk/qer/env/revansflagship/revansflagship.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 50 26 26 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 60 4
	nopicmip
	skyparms skpk/env/revansflagship/revansflagship - -
}

textures/skies_MASTER3/hevil-y4
{
	qer_editorImage skpk/qer/env/riverside/y4sky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 100 4
	nopicmip
	skyparms skpk/env/riverside/y4sky - -
}

textures/skies_MASTER3/rp_blue
{
	qer_editorImage skpk/qer/env/rp_blue/rp.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 70 150 25 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/rp_blue/rp - -
}

textures/skies_MASTER3/rp_red
{
	qer_editorImage skpk/qer/env/rp_red/rp.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 80 51 30 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/rp_red/rp - -
}

textures/skies_MASTER3/sfspace-sb
{
	qer_editorImage skpk/qer/env/sbsky/sbspace.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_lightRGB 1 1 1
	q3map_skylight 115 4 0 90 0
	nopicmip
	skyparms skpk/env/sbsky/sbspace - -
}

textures/skies_MASTER3/scriptsky
{
	qer_editorImage skpk/qer/env/scriptsky/scriptsky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.984314 0.639216 0.572549 30 0 90 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 105 4
	nopicmip
	skyparms skpk/env/scriptsky/scriptsky - -
}

textures/skies_MASTER3/yavin_dark2
{
	qer_editorImage skpk/qer/env/sedri/sedri.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 105 4
	nopicmip
	skyparms skpk/env/sedri/sedri - -
}

textures/skies_MASTER3/serenity_rp
{
	qer_editorImage skpk/qer/env/serenity_rp/serenity_rp.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 105 4
	nopicmip
	skyparms skpk/env/serenity_rp/serenity_rp - -
}

textures/skies_MASTER2/dos-bright
{
	qer_editorImage skpk/qer/env/sgvalley/sg_vally.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.871336 0.849943 0.700191 60 -134 38 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 80 4
	nopicmip
	skyparms skpk/env/sgvalley/sg_vally - -
}

textures/skies_MASTER3/shambla
{
	qer_editorImage skpk/qer/env/shambla/shambala.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 70 0 90 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 80 4
	nopicmip
	skyparms skpk/env/shambla/shambala - -
}

textures/skies_MASTER3/shambla_dand
{
	qer_editorImage skpk/qer/env/shambla_dand/dandc.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 60 50 54 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 65 4
	nopicmip
	skyparms skpk/env/shambla_dand/dandc - -
}

textures/skies_MASTER3/shambla_kb
{
	qer_editorImage skpk/qer/env/shambla_kb/kb.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_sunExt 1 1 1 40 88 14 8 16
	q3map_skylight 75 4
	nopicmip
	skyparms skpk/env/shambla_kb/kb - -
}

textures/skies_MASTER2/bespin-violet
{
	qer_editorImage skpk/qer/env/sileron/sileron.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 90 4
	nopicmip
	skyparms skpk/env/sileron/sileron - -
}

textures/skies_MASTER3/hevil-dim
{
	qer_editorImage skpk/qer/env/sithcouncil/sithcouncilsky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 95 4
	nopicmip
	skyparms skpk/env/sithcouncil/sithcouncilsky - -
}

textures/skies_MASTER3/sfspace-sithcouncil2
{
	qer_editorImage skpk/qer/env/sithcouncil2/sithcouncil2sky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_lightRGB 1 1 1
	q3map_skylight 125 4 0 90 0
	nopicmip
	skyparms skpk/env/sithcouncil2/sithcouncil2sky - -
}

textures/skies_MASTER3/skb_sky
{
	qer_editorImage skpk/qer/env/skb_sky/skb_sky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 55 67 22 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/skb_sky/skb_sky - -
}

textures/skies_MASTER3/skiesmgc
{
	qer_editorImage skpk/qer/env/skiesmgc/hk1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 35 -93 27 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/skiesmgc/hk1 - -
}

textures/skies_MASTER3/sky_jof_hoth
{
	qer_editorImage skpk/qer/env/sky_jof_hoth/jof_hoth.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 25 -119 25 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 80 4
	nopicmip
	skyparms skpk/env/sky_jof_hoth/jof_hoth - -
}

textures/skies_MASTER3/byss-hue
{
	qer_editorImage skpk/qer/env/spaceboundsky/night2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.959289 0.64567 1 20 172 22 2 16
	q3map_sunExt 0.959289 0.64567 1 15 -100 5 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 80 4
	nopicmip
	skyparms skpk/env/spaceboundsky/night2 - -
}

textures/skies_MASTER3/starforge
{
	qer_editorImage skpk/qer/env/starforge/sfsky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 15 129 75 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 95 4
	nopicmip
	skyparms skpk/env/starforge/sfsky - -
}

textures/skies_MASTER3/starkiller
{
	qer_editorImage skpk/qer/env/starkiller/pipextex_starkiller.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 55 60 20 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 75 4
	nopicmip
	skyparms skpk/env/starkiller/pipextex_starkiller - -
}

textures/skies_MASTER3/storage
{
	qer_editorImage skpk/qer/env/storage/storage.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 65 -63 25 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 60 4
	nopicmip
	skyparms skpk/env/storage/storage - -
}

textures/skies_MASTER3/submetro
{
	qer_editorImage skpk/qer/env/submetro/submetro.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 30 54 73 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 75 4
	nopicmip
	skyparms skpk/env/submetro/submetro - -
}

textures/skies_MASTER3/sunset_skybox
{
	qer_editorImage skpk/qer/env/sunset_skybox/sunset_skybox.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 0.535439 0.410956 45 -110 11 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 80 4
	nopicmip
	skyparms skpk/env/sunset_skybox/sunset_skybox - -
}

textures/skies_MASTER3/surf
{
	qer_editorImage skpk/qer/env/surf/surf.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 75 -58 25 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 60 4
	nopicmip
	skyparms skpk/env/surf/surf - -
}

textures/skies_MASTER2/bespin-tarisp
{
	qer_editorImage skpk/qer/env/taris_skies/tarisrp.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 20 34 29 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 85 4
	nopicmip
	skyparms skpk/env/taris_skies/tarisrp - -
}

textures/skies_MASTER3/sfspace-tatooine
{
	qer_editorImage skpk/qer/env/tatooine_space/space.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_lightRGB 0.705882 0.670588 0.65098
	q3map_skylight 125 4 0 90 0
	nopicmip
	skyparms skpk/env/tatooine_space/space - -
}

textures/skies_MASTER3/sfspace-tatooinenights
{
	qer_editorImage skpk/qer/env/tatooinenights/tatooinenights.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_lightRGB 1 1 1
	q3map_skylight 115 4 0 90 0
	nopicmip
	skyparms skpk/env/tatooinenights/tatooinenights - -
}

textures/skies_MASTER3/tatooinesky
{
	qer_editorImage skpk/qer/env/tatooinesky/sands.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 75 -29 24 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 60 4
	nopicmip
	skyparms skpk/env/tatooinesky/sands - -
}

textures/skies_MASTER3/tatooinesky2
{
	qer_editorImage skpk/qer/env/tatooinesky2/sands2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 75 -29 24 2 16
	q3map_sunExt 1 0.877607 0.410956 60 -73 10 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 75 4
	nopicmip
	skyparms skpk/env/tatooinesky2/sands2 - -
}

textures/skies_MASTER3/y4sky1
{
	qer_editorImage skpk/qer/env/temple/y4sky1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 70 -90 59 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 75 4
	nopicmip
	skyparms skpk/env/temple/y4sky1 - -
}

textures/skies_MASTER3/temple_dawn
{
	qer_editorImage skpk/qer/env/temple_dawn/dawn.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 255 190 125 20 159 5 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 85 4
	nopicmip
	skyparms skpk/env/temple_dawn/dawn - -
}

textures/skies_MASTER3/ord1-city
{
	qer_editorImage skpk/qer/env/thearenasky/cs.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 100 4
	nopicmip
	skyparms skpk/env/thearenasky/cs - -
}

textures/skies_MASTER3/casa_terrain
{
	qer_editorImage skpk/qer/env/thearenasky2/ta.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 75 -80 82 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 60 4
	nopicmip
	skyparms skpk/env/thearenasky2/ta - -
}

textures/skies_MASTER3/to
{
	qer_editorImage skpk/qer/env/to/to.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 0.98352 0.591409 40 -130 63 2 16         //yellow sun
	q3map_sunExt 1 1 1 40 90 80 2 16                        //white sun
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 80 4
	nopicmip
	skyparms skpk/env/to/to - -
}

textures/skies_MASTER3/tokyo
{
	qer_editorImage skpk/qer/env/tokyo/tokyo_t_h.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 70 149 26 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 60 4
	nopicmip
	skyparms skpk/env/tokyo/tokyo_t_h - -
}

textures/skies_MASTER3/towersky
{
	qer_editorImage skpk/qer/env/towersky/towersky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 70 -43 65 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/towersky/towersky - -
}

textures/skies_MASTER3/korb-night
{
	qer_editorImage skpk/qer/env/tpcsky2/tpc_night.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_lightRGB 1 1 1
	q3map_skylight 100 4 0 90 0
	nopicmip
	skyparms skpk/env/tpcsky2/tpc_night - -
}

textures/skies_MASTER3/byss-planets
{
	qer_editorImage skpk/qer/env/tpcsky3/tpc_space.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 20 171 21 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 85 4
	nopicmip
	skyparms skpk/env/tpcsky3/tpc_space - -
}

textures/skies_MASTER3/sfspace-trade
{
	qer_editorImage skpk/qer/env/trade/trade.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.623529 0.921569 0.917647 60 89 29 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 65 4
	nopicmip
	skyparms skpk/env/trade/trade - -
}

textures/skies_MASTER3/jk_yavin-dim
{
	qer_editorImage skpk/qer/env/tsc/tsc.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 110 4
	nopicmip
	skyparms skpk/env/tsc/tsc - -
}

textures/skies_MASTER3/tsuken_day
{
	qer_editorImage skpk/qer/env/tsuken_day/Day1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 30 -143 66 2 16
	q3map_sunExt 1 1 1 30 2 82 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/tsuken_day/Day1 - -
}

textures/skies_MASTER3/homestead_night2
{
	qer_editorImage skpk/qer/env/tusken_dusk/dusk.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 0.666468 0.279042 25 145 2 2 16          //dim sun
	q3map_sunExt 1 0.666468 0.279042 35 140 7 2 16          //bright sun
	q3map_sunExt 1 1 1 7 -36 25 2 16                        //large moon
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 60 4
	nopicmip
	skyparms skpk/env/tusken_dusk/dusk - -
}

textures/skies_MASTER3/underwater
{
	qer_editorImage skpk/qer/env/underwater/underwater.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 105 4
	nopicmip
	skyparms skpk/env/underwater/underwater - -
}

textures/skies_MASTER3/underwater_sky
{
	qer_editorImage skpk/qer/env/underwater_sky/uwsky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 10 -125 61 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 80 4
	nopicmip
	skyparms skpk/env/underwater_sky/uwsky - -
}

textures/skies_MASTER2/bespin-blanch
{
	qer_editorImage skpk/qer/env/vers_sky/sky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 95 4
	nopicmip
	skyparms skpk/env/vers_sky/sky - -
}

textures/skies_MASTER3/voj
{
	qer_editorImage skpk/qer/env/voj/voj.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 35 150 25 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 80 4
	nopicmip
	skyparms skpk/env/voj/voj - -
}

textures/skies_MASTER3/hevil
{
	qer_editorImage skpk/qer/env/warcom/warcom1a.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 90 4
	nopicmip
	skyparms skpk/env/warcom/warcom1a - -
}

textures/skies_MASTER6/0color_blue-zodiac
{
	qer_editorImage skpk/qer/env/whoville_sky/who_sky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyparms skpk/env/whoville_sky/who_sky - -
}

textures/skies_MASTER2/bespin-wov
{
	qer_editorImage skpk/qer/env/wov/wovsky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 110 4
	nopicmip
	skyparms skpk/env/wov/wovsky - -
}

textures/skies_MASTER3/yavin_dark
{
	qer_editorImage skpk/qer/env/yavin_dark/darkyavin.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 100 4
	nopicmip
	skyparms skpk/env/yavin_dark/darkyavin - -
}

textures/skies_MASTER3/jk_yavin
{
	qer_editorImage skpk/qer/env/yavin_day/yavin.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 105 4
	nopicmip
	skyparms skpk/env/yavin_day/yavin - -
}

textures/skies_MASTER3/jk_yavin-purple
{
	qer_editorImage skpk/qer/env/ziost/ziost.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 100 4
	nopicmip
	skyparms skpk/env/ziost/ziost - -
}

//nearly done

textures/skies_MASTER4/64elysky1
{
	qer_editorImage skpk/qer/env/64/elysky1/xl.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 27 26 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 60 4
	nopicmip
	skyparms skpk/env/64/elysky1/xl - -
}

textures/skies_MASTER4/64elysky2
{
	qer_editorImage skpk/qer/env/64/elysky2/sa2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 55 -27 30 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 75 4
	nopicmip
	skyparms skpk/env/64/elysky2/sa2 - -
}

textures/skies_MASTER4/64elysky3
{
	qer_editorImage skpk/qer/env/64/elysky3/sa.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 60 20 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 55 4
	nopicmip
	skyparms skpk/env/64/elysky3/sa - -
}

textures/skies_MASTER4/64elysky4
{
	qer_editorImage skpk/qer/env/64/elysky4/zz.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms skpk/env/64/elysky4/zz - -
}

textures/skies_MASTER4/64faesky01
{
	qer_editorImage skpk/qer/env/64/fae01/faesky01.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms skpk/env/64/fae01/faesky01 - -
}

textures/skies_MASTER4/64faesky02
{
	qer_editorImage skpk/qer/env/64/fae02/faesky02.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 80 -10 11 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/64/fae02/faesky02 - -
}

textures/skies_MASTER4/64faesky03
{
	qer_editorImage skpk/qer/env/64/fae03/faesky03.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 15 -11 13 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 85 4
	nopicmip
	skyparms skpk/env/64/fae03/faesky03 - -
}

textures/skies_MASTER4/64faesky04
{
	qer_editorImage skpk/qer/env/64/fae04/faesky04.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 125 4
	nopicmip
	skyparms skpk/env/64/fae04/faesky04 - -
}

textures/skies_MASTER4/64LNHcanyon1
{
	qer_editorImage skpk/qer/env/64/LNHcanyon1/lnhcanyons1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 75 -81 35 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 80 4
	nopicmip
	skyparms skpk/env/64/LNHcanyon1/lnhcanyons1 - -
}

textures/skies_MASTER4/64LNHcanyon2
{
	qer_editorImage skpk/qer/env/64/LNHcanyon2/lnhcanyon2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 125 4
	nopicmip
	skyparms skpk/env/64/LNHcanyon2/lnhcanyon2 - -
}

textures/skies_MASTER4/64LNHmtnsea1
{
	qer_editorImage skpk/qer/env/64/LNHmtnsea1/lnhmtns1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 80 -28 24 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 60 4
	nopicmip
	skyparms skpk/env/64/LNHmtnsea1/lnhmtns1 - -
}

textures/skies_MASTER4/64lnhsenv2a
{
	qer_editorImage skpk/qer/env/64/lnhsenv2a/lnhenvs6.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms skpk/env/64/lnhsenv2a/lnhenvs6 - -
}

textures/skies_MASTER4/64lnhsenv2b
{
	qer_editorImage skpk/qer/env/64/lnhsenv2b/lnhenvf6.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms skpk/env/64/lnhsenv2b/lnhenvf6 - -
}

textures/skies_MASTER4/64lnhsenv2c
{
	qer_editorImage skpk/qer/env/64/lnhsenv2c/lnhenvw6.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 125 4
	nopicmip
	skyparms skpk/env/64/lnhsenv2c/lnhenvw6 - -
}

textures/skies_MASTER4/64lnhsenv2d
{
	qer_editorImage skpk/qer/env/64/lnhsenv2d/lnhenv1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 120 4
	nopicmip
	skyparms skpk/env/64/lnhsenv2d/lnhenv1 - -
}

textures/skies_MASTER4/64LNHsFall1
{
	qer_editorImage skpk/qer/env/64/LNHsFall1/lnhfall1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 125 4
	nopicmip
	skyparms skpk/env/64/LNHsFall1/lnhfall1 - -
}

textures/skies_MASTER4/64LNHsMtns1
{
	qer_editorImage skpk/qer/env/64/LNHsMtns1/lnhmtn1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 80 -89 49 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 65 4
	nopicmip
	skyparms skpk/env/64/LNHsMtns1/lnhmtn1 - -
}

textures/skies_MASTER4/64LNHsRockies2
{
	qer_editorImage skpk/qer/env/64/LNHsRockies2/lnh_rockies2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 80 -29 25 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 65 4
	nopicmip
	skyparms skpk/env/64/LNHsRockies2/lnh_rockies2 - -
}

textures/skies_MASTER4/64LNHsSkyboxSet1a
{
	qer_editorImage skpk/qer/env/64/LNHsSkyboxSet1a/lnhdawn.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 80 -89 20 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 60 4
	nopicmip
	skyparms skpk/env/64/LNHsSkyboxSet1a/lnhdawn - -
}

textures/skies_MASTER4/64LNHsSkyboxSet1b
{
	qer_editorImage skpk/qer/env/64/LNHsSkyboxSet1b/lnhday.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 80 -89 45 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 65 4
	nopicmip
	skyparms skpk/env/64/LNHsSkyboxSet1b/lnhday - -
}

textures/skies_MASTER4/64LNHsSkyboxSet1c
{
	qer_editorImage skpk/qer/env/64/LNHsSkyboxSet1c/lnhdusk.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.949386 0.723796 0.349477 75 90 20 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/64/LNHsSkyboxSet1c/lnhdusk - -
}

textures/skies_MASTER4/64LNHsSkyboxSet1d
{
	qer_editorImage skpk/qer/env/64/LNHsSkyboxSet1d/lnhnight.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 130 4
	nopicmip
	skyparms skpk/env/64/LNHsSkyboxSet1d/lnhnight - -
}

textures/skies_MASTER4/64LNHsSkyboxSet2a
{
	qer_editorImage skpk/qer/env/64/LNHsSkyboxSet2a/lnhspiritglow1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 75 -89 27 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 65 4
	nopicmip
	skyparms skpk/env/64/LNHsSkyboxSet2a/lnhspiritglow1 - -
}

textures/skies_MASTER4/64LNHsSkyboxSet2b
{
	qer_editorImage skpk/qer/env/64/LNHsSkyboxSet2b/lnhspiritglow2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 35 0 90 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 90 4
	nopicmip
	skyparms skpk/env/64/LNHsSkyboxSet2b/lnhspiritglow2 - -
}

textures/skies_MASTER4/64LNHsSkyboxSet2c
{
	qer_editorImage skpk/qer/env/64/LNHsSkyboxSet2c/lnhspiritglow3.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 0.867231 0.514199 65 91 28 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 90 4
	nopicmip
	skyparms skpk/env/64/LNHsSkyboxSet2c/lnhspiritglow3 - -
}

textures/skies_MASTER4/64LNHsSkyboxSet2d
{
	qer_editorImage skpk/qer/env/64/LNHsSkyboxSet2d/lnhspiritglow4.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 130 4
	nopicmip
	skyparms skpk/env/64/LNHsSkyboxSet2d/lnhspiritglow4 - -
}

textures/skies_MASTER4/64LNHsSpring1
{
	qer_editorImage skpk/qer/env/64/LNHsSpring1/lnhspring1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 40 0 90 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 105 4
	nopicmip
	skyparms skpk/env/64/LNHsSpring1/lnhspring1 - -
}

textures/skies_MASTER4/64LNHsSummer1
{
	qer_editorImage skpk/qer/env/64/LNHsSummer1/lnhsummer1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 40 0 90 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 105 4
	nopicmip
	skyparms skpk/env/64/LNHsSummer1/lnhsummer1 - -
}

textures/skies_MASTER4/64LNHsWinter1
{
	qer_editorImage skpk/qer/env/64/LNHsWinter1/lnhwinter1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 40 0 90 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 105 4
	nopicmip
	skyparms skpk/env/64/LNHsWinter1/lnhwinter1 - -
}

textures/skies_MASTER4/64salsky001
{
	qer_editorImage skpk/qer/env/64/salsky001/test2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms skpk/env/64/salsky001/test2 - -
}

textures/skies_MASTER4/64salsky002
{
	qer_editorImage skpk/qer/env/64/salsky002/test3.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 25 1 23 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 110 4
	nopicmip
	skyparms skpk/env/64/salsky002/test3 - -
}

textures/skies_MASTER4/64salsky003
{
	qer_editorImage skpk/qer/env/64/salsky003/test4.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 75 0 90 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 60 4
	nopicmip
	skyparms skpk/env/64/salsky003/test4 - -
}

textures/skies_MASTER4/64salsky004
{
	qer_editorImage skpk/qer/env/64/salsky004/test5.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyparms skpk/env/64/salsky004/test5 - -
}

textures/skies_MASTER4/64salsky005
{
	qer_editorImage skpk/qer/env/64/salsky005/test6.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 20 57 18 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 110 4
	nopicmip
	skyparms skpk/env/64/salsky005/test6 - -
}

textures/skies_MASTER4/64salsky006
{
	qer_editorImage skpk/qer/env/64/salsky006/test7.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 40 9 22 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 105 4
	nopicmip
	skyparms skpk/env/64/salsky006/test7 - -
}

textures/skies_MASTER4/64salsky007
{
	qer_editorImage skpk/qer/env/64/salsky007/tes9.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 130 4
	nopicmip
	skyparms skpk/env/64/salsky007/tes9 - -
}

textures/skies_MASTER4/64salsky008
{
	qer_editorImage skpk/qer/env/64/salsky008/test9.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 60 1 27 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 80 4
	nopicmip
	skyparms skpk/env/64/salsky008/test9 - -
}

textures/skies_MASTER4/64sky1
{
	qer_editorImage skpk/qer/env/64/sky1/s37.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 80 -30 32 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 65 4
	nopicmip
	skyparms skpk/env/64/sky1/s37 - -
}

textures/skies_MASTER4/64sky4
{
	qer_editorImage skpk/qer/env/64/sky4/o1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 75 28 24 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/64/sky4/o1 - -
}

textures/skies_MASTER4/64sky5
{
	qer_editorImage skpk/qer/env/64/sky5/o18.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 50 -40 3 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 80 4
	nopicmip
	skyparms skpk/env/64/sky5/o18 - -
}

textures/skies_MASTER4/64sky7
{
	qer_editorImage skpk/qer/env/64/sky7/aw2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.948333 0.754147 0.649302 35 -35 11 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 85 4
	nopicmip
	skyparms skpk/env/64/sky7/aw2 - -
}

textures/skies_MASTER4/64sky9
{
	qer_editorImage skpk/qer/env/64/sky9/snow1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 50 -146 15 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 80 4
	nopicmip
	skyparms skpk/env/64/sky9/snow1 - -
}

textures/skies_MASTER4/64sky12
{
	qer_editorImage skpk/qer/env/64/sky12/ax2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 60 0 32 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 95 4
	nopicmip
	skyparms skpk/env/64/sky12/ax2 - -
}

textures/skies_MASTER4/64sky14
{
	qer_editorImage skpk/qer/env/64/sky14/1h.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 40 -4 28 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 90 4
	nopicmip
	skyparms skpk/env/64/sky14/1h - -
}

textures/skies_MASTER4/64sky16
{
	qer_editorImage skpk/qer/env/64/sky16/w3.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 80 -35 33 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/64/sky16/w3 - -
}

textures/skies_MASTER/ely_nevada-pale
{
	qer_editorImage skpk/qer/env/64/sky18/red2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 60 98 32 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 80 4
	nopicmip
	skyparms skpk/env/64/sky18/red2 - -
}

textures/skies_MASTER4/64skyboxsun5deg
{
	qer_editorImage skpk/qer/env/64/skyboxsun5deg/skyrender.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.981765 0.814359 0.536599 70 -134 6 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 75 4
	nopicmip
	skyparms skpk/env/64/skyboxsun5deg/skyrender - -
}

textures/skies_MASTER4/64skyboxsun5deg2
{
	qer_editorImage skpk/qer/env/64/skyboxsun5deg2/skyrender.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.981765 0.814359 0.536599 70 -134 5 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 75 4
	nopicmip
	skyparms skpk/env/64/skyboxsun5deg2/skyrender - -
}

textures/skies_MASTER4/64skyboxsun25degtest
{
	qer_editorImage skpk/qer/env/64/skyboxsun25degtest/skyrender.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 80 -132 25 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 60 4
	nopicmip
	skyparms skpk/env/64/skyboxsun25degtest/skyrender - -
}

textures/skies_MASTER4/64skyboxsun45deg
{
	qer_editorImage skpk/qer/env/64/skyboxsun45deg/skyrender.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 80 -133 45 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/64/skyboxsun45deg/skyrender - -
}

textures/skies_MASTER4/64taosky001
{
	qer_editorImage skpk/qer/env/64/taosky001/skybox1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 -176 26 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 75 4
	nopicmip
	skyparms skpk/env/64/taosky001/skybox1 - -
}

textures/skies_MASTER4/64taosky002
{
	qer_editorImage skpk/qer/env/64/taosky002/skybox2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 120 4
	nopicmip
	skyparms skpk/env/64/taosky002/skybox2 - -
}

textures/skies_MASTER4/64taosky003
{
	qer_editorImage skpk/qer/env/64/taosky003/skybox3.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms skpk/env/64/taosky003/skybox3 - -
}

textures/skies_MASTER4/64taosky004
{
	qer_editorImage skpk/qer/env/64/taosky004/skybox4.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 50 5 7 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 85 4
	nopicmip
	skyparms skpk/env/64/taosky004/skybox4 - -
}

//============================================

textures/skies_MASTER6/xnight2-night1
{
	qer_editorImage skpk/qer/6/xnight2-night1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 20 -43 60 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 60 4
	nopicmip
	skyparms env/xnight2 - -
	{
		map skpk/textures/skies/night1.tga
		blendfunc GL_ONE GL_ONE
		tcMod scroll 0.05 .1
	}
	{
		map skpk/textures/skies/night2.tga
		blendFunc GL_ONE GL_ONE
		tcMod scroll 0.05 0.06
	}
}

textures/skies_MASTER6/killsky_anim
{
	qer_editorImage skpk/qer/6/killsky_anim.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 180 4
	nopicmip
	skyparms - 512 -
	{
		map textures/skies/killsky_1.tga
		tcMod scroll 0.02 0
		tcMod scale 2 2
	}
	{
		map textures/skies/killsky_2.tga
		blendFunc GL_ONE GL_ONE
		tcMod scale 3 3
		tcMod scroll 0.02 0.01
	}
	{
		animMap 2 skpk/textures/skies/zdh_lightning1k1b.tga skpk/textures/skies/empty1.tga skpk/textures/skies/empty1.tga skpk/textures/skies/zdh_lightning1k2b2.tga skpk/textures/skies/zdh_lightning1k3b.tga skpk/textures/skies/empty1.tga skpk/textures/skies/empty1.tga
		blendFunc GL_ONE GL_ONE
		rgbGen identity
		rgbGen wave inverseSawtooth 0 1 0 2
		tcMod scale 3 3
	}
}

textures/skies_MASTER6/dark_anim
{
	qer_editorImage skpk/qer/6/dark_anim.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 120 4
	nopicmip
	skyparms - 512 -
	{
		map textures/skies/dimclouds.tga
		tcMod scroll 0.05 .1
		tcMod scale 2 2
		depthWrite
	}
	{
		map skpk/textures/skies/gray2.tga
		blendfunc GL_ONE GL_ONE
		tcMod scroll 0.05 0.06
		tcMod scale 3 2
	}
	{
		animMap 2 skpk/textures/skies/zdh_lightning1k1b.tga skpk/textures/skies/empty1.tga skpk/textures/skies/empty1.tga skpk/textures/skies/zdh_lightning1k2b2.tga skpk/textures/skies/zdh_lightning1k3b.tga skpk/textures/skies/empty1.tga skpk/textures/skies/empty1.tga
		blendFunc GL_ONE GL_ONE
		rgbGen identity
		rgbGen wave inverseSawtooth 0 1 0 2
		tcMod scale 3 3
	}
}

textures/skies_MASTER6/dark2_anim
{
	qer_editorImage skpk/qer/6/dark2_anim.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 120 4
	nopicmip
	skyparms - 512 -
	{
		map skpk/textures/skies/clouds3.tga
		tcMod scroll 0.02 0
		tcMod scale 2 2
	}
	{
		map skpk/textures/skies/clouds3.tga
		blendFunc GL_ONE GL_ONE
		tcMod scale .25 .25
		tcMod scroll 0.02 0.01
	}
	{
		animMap 2 skpk/textures/skies/lightning_dark.tga skpk/textures/skies/empty1.tga skpk/textures/skies/empty1.tga skpk/textures/skies/lightning_dark.tga skpk/textures/skies/lightning_dark.tga skpk/textures/skies/empty1.tga skpk/textures/skies/empty1.tga
		blendFunc GL_ONE GL_ONE
		rgbGen identity
		rgbGen wave inverseSawtooth 0 1 0 2
		tcMod scale .25 .25
		tcMod scroll 0.02 0.01
	}
}

textures/skies_MASTER6/dark3_anim
{
	qer_editorImage skpk/qer/6/dark3_anim.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 120 4
	nopicmip
	skyparms - 512 -
	{
		map skpk/textures/skies/ldark1a.tga
		tcMod scroll .005 .01
		tcMod scale 2 2
		depthWrite
	}
	{
		map skpk/textures/skies/ldark1b.tga
		blendfunc GL_ONE GL_ONE
		tcMod scroll .05 .06
		tcMod scale 3 2
	}
	{
		animMap 3 skpk/textures/skies/gray4.tga skpk/textures/skies/empty1.tga skpk/textures/skies/empty1.tga skpk/textures/skies/gray4.tga skpk/textures/skies/empty1.tga skpk/textures/skies/gray4.tga skpk/textures/skies/empty1.tga skpk/textures/skies/empty1.tga
		blendFunc GL_ONE GL_ONE
		rgbGen identity
		tcMod scroll .005 .006
	}
}

textures/skies_MASTER6/xnight2-clouds4
{
	qer_editorImage skpk/qer/6/xnight2-clouds4.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 20 -43 60 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 60 4
	nopicmip
	skyparms env/xnight2 - -
	{
		map skpk/textures/skies/clouds3.tga
		blendFunc GL_ONE GL_ONE
		tcMod scale 5 5
		tcMod scroll 0.02 0.01
	}
}

textures/skies_MASTER6/test_sky_zdh
{
	qer_editorImage skpk/qer/6/test_sky_zdh.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 120 4
	nopicmip
	skyparms - 512 -
	{
		map skpk/textures/skies/clouds3.tga
		tcMod scroll 0.02 0
		tcMod scale 2 2
	}
	{
		map skpk/textures/skies/clouds3.tga
		blendFunc GL_ONE GL_ONE
		tcMod scale .25 .25
		tcMod scroll 0.02 0.01
	}
	{
		animMap 2 skpk/textures/skies/lightning_dark.tga skpk/textures/skies/empty1.tga skpk/textures/skies/empty1.tga skpk/textures/skies/lightning_dark.tga skpk/textures/skies/lightning_dark.tga skpk/textures/skies/empty1.tga skpk/textures/skies/empty1.tga
		blendFunc GL_ONE GL_ONE
		rgbGen identity
		tcMod scale .25 .25
		tcMod scroll 0.02 0.01
	}
}

textures/skies_MASTER6/darksky1
{
	qer_editorImage skpk/qer/6/darksky1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 120 4
	nopicmip
	skyparms - 512 -
	{
		map textures/skies/dimclouds.tga
		tcMod scroll 0.05 .1
		tcMod scale 2 2
		depthWrite
	}
	{
		map skpk/textures/skies/gray2.tga
		blendfunc GL_ONE GL_ONE
		tcMod scroll 0.05 0.06
		tcMod scale 3 2
	}
}

textures/skies_MASTER6/bluesky1z
{
	qer_editorImage skpk/qer/6/bluesky1z.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 120 4
	nopicmip
	skyparms - 512 -
	{
		map skpk/textures/skies/clouds2b.tga
		tcMod scroll 0.02 0
		tcMod scale 2 2
	}
	{
		map skpk/textures/skies/clouds1.tga
		blendFunc GL_ONE GL_ONE
		tcMod scale 5 5
		tcMod scroll 0.02 0.01
	}
}

textures/skies_MASTER6/hellsky1
{
	qer_editorImage skpk/qer/6/hellsky1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 180 4
	nopicmip
	skyparms - 512 -
	{
		map textures/skies/killsky_1.tga
		tcMod scroll 0.02 0
		tcMod scale 2 2
	}
	{
		map skpk/textures/skies/hellsky1zdh.tga
		blendFunc GL_ONE GL_ONE
		tcMod scale 3 3
		tcMod scroll 0.02 0.01
	}
}

textures/skies_MASTER6/zdh_darkness
{
	qer_editorImage skpk/qer/6/zdh_darkness.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 120 4
	nopicmip
	skyparms - 512 -
	{
		map skpk/textures/skies/darkness1.tga
		tcMod scroll 0.02 0
		tcMod scale 3 3
	}
	{
		map skpk/textures/skies/darkness2.tga
		blendFunc GL_ONE GL_ONE
		tcMod scale 5 5
		tcMod scroll 0.02 0.01
	}
}

textures/skies_MASTER6/zdh_hell
{
	qer_editorImage skpk/qer/6/zdh_hell.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 120 4
	nopicmip
	skyparms - 512 -
	{
		map skpk/textures/skies/hell1.tga
		tcMod scroll 0.02 0
		tcMod scale 3 3
	}
	{
		map skpk/textures/skies/hell2.tga
		blendFunc GL_ONE GL_ONE
		tcMod scale 5 5
		tcMod scroll 0.02 0.01
	}
}

textures/skies_MASTER2/sky1LA
{
	qer_editorImage skpk/qer/env/sky1LA.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyparms skpk/env/sky1LA - -
}

//============================================

//various images pulled from Google search
//used qbit to generate sky textures

textures/skies_MASTER3/ghost_milky
{
	qer_editorImage skpk/qer/env/ghost_milky/milky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 15 87 3 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 80 4
	nopicmip
	skyparms skpk/env/ghost_milky/milky - -
}

textures/skies_MASTER3/ghost_sky_01
{
	qer_editorImage skpk/qer/env/deviant_art_neb_/deviant_art_neb.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 55 85 6 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 60 4
	nopicmip
	skyparms skpk/env/deviant_art_neb_/deviant_art_neb - -
}

textures/skies_MASTER3/ghost_sky_02
{
	qer_editorImage skpk/qer/env/deviant_art_blender_1/blender1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.188235 0.803922 0.898039 60 -128 57 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 60 4
	nopicmip
	skyparms skpk/env/deviant_art_blender_1/blender1 - -
}

textures/skies_MASTER3/ghost_sky_04
{
	qer_editorImage skpk/qer/env/deviant_art_blender_2/blender4.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 50 37 30 2 16
	q3map_sunExt 1 1 1 25 169 12 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/deviant_art_blender_2/blender4 - -
}

textures/skies_MASTER3/ghost_sky_05
{
	qer_editorImage skpk/qer/env/ghost_milky_hole/milky_hole.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 25 -25 22 2 16       //left
	q3map_sunExt 1 1 1 25 -65 22 2 16       //right
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 60 4
	nopicmip
	skyparms skpk/env/ghost_milky_hole/milky_hole - -
}

textures/skies_MASTER3/ghost_sky_06
{
	qer_editorImage skpk/qer/env/deviant_art_dragon/deviant_art_dragon.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 0.536995 0.161868 65 10 22 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 80 4
	nopicmip
	skyparms skpk/env/deviant_art_dragon/deviant_art_dragon - -
}

textures/skies_MASTER3/ghost_sky_07
{
	qer_editorImage skpk/qer/env/deviant_art_blender_3/deviant_art_blender3.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 55 80 3 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 80 4
	nopicmip
	skyparms skpk/env/deviant_art_blender_3/deviant_art_blender3 - -
}

textures/skies_MASTER3/ghost_sky_08
{
	qer_editorImage skpk/qer/env/deviant_art_blender_4/deviant_art_blender_4.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 30 -135 55 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 80 4
	nopicmip
	skyparms skpk/env/deviant_art_blender_4/deviant_art_blender_4 - -
}

textures/skies_MASTER3/ghost_sky_09
{
	qer_editorImage skpk/qer/env/deviant_art_blender_5/deviant_art_blender_5.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 50 75 12 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 80 4
	nopicmip
	skyparms skpk/env/deviant_art_blender_5/deviant_art_blender_5 - -
}

textures/skies_MASTER3/ghost_sky_10
{
	qer_editorImage skpk/qer/env/deviant_art_blender_6/deviant_art_blender_6.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 30 89 10 2 16
	q3map_sunExt 1 1 1 30 -44 13 2 16
	q3map_sunExt 0.992096 0.463554 1 15 -131 8 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/deviant_art_blender_6/deviant_art_blender_6 - -
}

textures/skies_MASTER3/ghost_sky_11
{
	qer_editorImage skpk/qer/env/deviant_art_blender_7/deviant_art_blender_7.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 40 76 12 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 85 4
	nopicmip
	skyparms skpk/env/deviant_art_blender_7/deviant_art_blender_7 - -
}

textures/skies_MASTER3/ghost_sky_12
{
	qer_editorImage skpk/qer/env/deviant_art_neb_1/deviant_art_neb_1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.67451 0.67451 0.909804 35 55 3 2 16
	q3map_sunExt 0.671778 0.523384 0.775311 45 -103 23 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 95 4
	nopicmip
	skyparms skpk/env/deviant_art_neb_1/deviant_art_neb_1 - -
}

textures/skies_MASTER3/ghost_sky_13
{
	qer_editorImage skpk/qer/env/deviant_art_neb_2/deviant_art_neb_2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.38088 0.734661 1 65 17 70 2 16
	q3map_sunExt 0.814817 0.814817 0.649348 25 62 -14 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 80 4
	nopicmip
	skyparms skpk/env/deviant_art_neb_2/deviant_art_neb_2 - -
}

textures/skies_MASTER3/ghost_sky_14
{
	qer_editorImage skpk/qer/env/deviant_art_neb_3/deviant_art_neb_3.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 60 76 13 2 16
	q3map_sunExt 0.74902 0.556863 0.835294 60 -12 35 2 16           //purple
	q3map_sunExt 0.2 0.509804 0.776471 55 141 37 2 16               //blue
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 80 4
	nopicmip
	skyparms skpk/env/deviant_art_neb_3/deviant_art_neb_3 - -
}

textures/skies_MASTER3/ghost_sky_15
{
	qer_editorImage skpk/qer/env/deviant_art_neb_4/deviant_art_neb_4.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.47451 0.870588 0.956863 70 -21 51 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 85 4
	nopicmip
	skyparms skpk/env/deviant_art_neb_4/deviant_art_neb_4 - -
}

textures/skies_MASTER3/ghost_sky_16
{
	qer_editorImage skpk/qer/env/deviant_art_neb_5/deviant_art_neb_5.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.549416 0.940261 0.986877 70 40 27 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 60 4
	nopicmip
	skyparms skpk/env/deviant_art_neb_5/deviant_art_neb_5 - -
}

textures/skies_MASTER3/ghost_sky_17
{
	qer_editorImage skpk/qer/env/deviant_art_neb_6/deviant_art_neb_6.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.701961 0.65098 0.929412 65 -21 8 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 80 4
	nopicmip
	skyparms skpk/env/deviant_art_neb_6/deviant_art_neb_6 - -
}

textures/skies_MASTER3/ghost_sky_18
{
	qer_editorImage skpk/qer/env/deviant_art_neb_7/deviant_art_neb_7.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 0.626261 0.463554 35 -89 27 2 16
	q3map_sunExt 1 1 1 40 50 12 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 90 4
	nopicmip
	skyparms skpk/env/deviant_art_neb_7/deviant_art_neb_7 - -
}

textures/skies_MASTER3/ghost_sky_19
{
	qer_editorImage skpk/qer/env/deviant_art_neb_8/deviant_art_neb_8.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 35 54 15 2 16
	q3map_sunExt 1 1 1 25 86 7 2 16
	q3map_sunExt 1 0.445472 0.381704 35 -125 14 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 80 4
	nopicmip
	skyparms skpk/env/deviant_art_neb_8/deviant_art_neb_8 - -
}

textures/skies_MASTER3/ghost_sky_20
{
	qer_editorImage skpk/qer/env/deviant_art_neb_9/deviant_art_neb_9.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 70 50 28 2 16
	q3map_sunExt 0.928756 0.556237 0.498024 50 178 49 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 80 4
	nopicmip
	skyparms skpk/env/deviant_art_neb_9/deviant_art_neb_9 - -
}

textures/skies_MASTER3/ghost_sky_21
{
	qer_editorImage skpk/qer/env/deviant_art_neb_10/deviant_art_neb_10.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 30 -77 9 2 16
	q3map_sunExt 1 1 1 45 -2 30 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 80 4
	nopicmip
	skyparms skpk/env/deviant_art_neb_10/deviant_art_neb_10 - -
}

textures/skies_MASTER3/ghost_sky_22
{
	qer_editorImage skpk/qer/env/deviant_art_neb_11/deviant_art_neb_11.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 35 -30 -4 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 90 4
	nopicmip
	skyparms skpk/env/deviant_art_neb_11/deviant_art_neb_11 - -
}

textures/skies_MASTER3/ghost_sky_23
{
	qer_editorImage skpk/qer/env/deviant_art_neb_12/deviant_art_neb_12.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 10 93 35 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 95 4
	nopicmip
	skyparms skpk/env/deviant_art_neb_12/deviant_art_neb_12 - -
}

textures/skies_MASTER3/ghost_sky_24
{
	qer_editorImage skpk/qer/env/deviant_art_neb_13/deviant_art_neb_13.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 50 99 20 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 80 4
	nopicmip
	skyparms skpk/env/deviant_art_neb_13/deviant_art_neb_13 - -
}

textures/skies_MASTER3/ghost_sky_25
{
	qer_editorImage skpk/qer/env/deviant_art_neb_14/deviant_art_neb_14.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 45 47 6 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 60 4
	nopicmip
	skyparms skpk/env/deviant_art_neb_14/deviant_art_neb_14 - -
}

textures/skies_MASTER3/ghost_sky_26
{
	qer_editorImage skpk/qer/env/deviant_art_neb_15/deviant_art_neb_15.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.694011 0.840497 1 65 141 57 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms skpk/env/deviant_art_neb_15/deviant_art_neb_15 - -
}

textures/skies_MASTER3/ghost_sky_27
{
	qer_editorImage skpk/qer/env/ghost_blueyellow/ghost_blueyellow.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 50 97 59 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 60 4
	nopicmip
	skyparms skpk/env/ghost_blueyellow/ghost_blueyellow - -
}

textures/skies_MASTER3/ghost_sky_28
{
	qer_editorImage skpk/qer/env/ghost_darkred/ghost_darkred.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 50 -161 45 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 60 4
	nopicmip
	skyparms skpk/env/ghost_darkred/ghost_darkred - -
}

textures/skies_MASTER3/ghost_sky_29
{
	qer_editorImage skpk/qer/env/ghost_darksky/ghost_darksky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 50 -162 8 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 60 4
	nopicmip
	skyparms skpk/env/ghost_darksky/ghost_darksky - -
}

textures/skies_MASTER3/ghost_sky_30
{
	qer_editorImage skpk/qer/env/ghost_greenblue/ghost_greenblue.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 30 -1 -23 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 90 4
	nopicmip
	skyparms skpk/env/ghost_greenblue/ghost_greenblue - -
}

textures/skies_MASTER3/ghost_sky_31
{
	qer_editorImage skpk/qer/env/ghost_greensky/ghost_greensky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 35 -172 59 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 80 4
	nopicmip
	skyparms skpk/env/ghost_greensky/ghost_greensky - -
}

textures/skies_MASTER3/ghost_sky_32
{
	qer_editorImage skpk/qer/env/ghost_lightpurp/ghost_lightpurp.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 40 80 68 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 75 4
	nopicmip
	skyparms skpk/env/ghost_lightpurp/ghost_lightpurp - -
}

textures/skies_MASTER3/ghost_sky_33
{
	qer_editorImage skpk/qer/env/ghost_nosun_brown/ghost_nosun_brown.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 95 4
	nopicmip
	skyparms skpk/env/ghost_nosun_brown/ghost_nosun_brown - -
}

textures/skies_MASTER3/ghost_sky_34
{
	qer_editorImage skpk/qer/env/ghost_nosun_greenorange/ghost_nosun_greenorange.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 95 4
	nopicmip
	skyparms skpk/env/ghost_nosun_greenorange/ghost_nosun_greenorange - -
}

textures/skies_MASTER3/ghost_sky_35
{
	qer_editorImage skpk/qer/env/ghost_nosun_greenwhite/ghost_nosun_greenwhite.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 95 4
	nopicmip
	skyparms skpk/env/ghost_nosun_greenwhite/ghost_nosun_greenwhite - -
}

textures/skies_MASTER3/ghost_sky_36
{
	qer_editorImage skpk/qer/env/ghost_nosun_greenyellow/ghost_nosun_greenyellow.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 95 4
	nopicmip
	skyparms skpk/env/ghost_nosun_greenyellow/ghost_nosun_greenyellow - -
}

textures/skies_MASTER3/ghost_sky_37
{
	qer_editorImage skpk/qer/env/ghost_nosun_lightblue/ghost_nosun_lightblue.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 95 4
	nopicmip
	skyparms skpk/env/ghost_nosun_lightblue/ghost_nosun_lightblue - -
}

textures/skies_MASTER3/ghost_sky_38
{
	qer_editorImage skpk/qer/env/ghost_nosun_lightpurp/ghost_nosun_lightpurp.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 95 4
	nopicmip
	skyparms skpk/env/ghost_nosun_lightpurp/ghost_nosun_lightpurp - -
}

textures/skies_MASTER3/ghost_sky_39
{
	qer_editorImage skpk/qer/env/abstract_twotone/abstract_twotone.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_lightRGB 1 1 1
	q3map_skylight 125 4 0 90 0
	nopicmip
	skyparms skpk/env/abstract_twotone/abstract_twotone - -
}

textures/skies_MASTER3/ghost_sky_40
{
	qer_editorImage skpk/qer/env/earth_night/earth_night.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_lightRGB 1 1 1
	q3map_skylight 125 4 0 90 0
	nopicmip
	skyparms skpk/env/earth_night/earth_night - -
}

textures/skies_MASTER3/ghost_sky_41
{
	qer_editorImage skpk/qer/env/megastructures/megastructures.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_lightRGB 1 1 1
	q3map_skylight 125 4 0 90 0
	nopicmip
	skyparms skpk/env/megastructures/megastructures - -
}

textures/skies_MASTER3/ghost_sky_42
{
	qer_editorImage skpk/qer/env/landscape_moon/landscape_moon.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 95 4
	nopicmip
	skyparms skpk/env/landscape_moon/landscape_moon - -
}

textures/skies_MASTER3/ghost_sky_43
{
	qer_editorImage skpk/qer/env/not_earth/not_earth.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 80 4
	nopicmip
	skyparms skpk/env/not_earth/not_earth - -
}

textures/skies_MASTER3/ghost_sky_44
{
	qer_editorImage skpk/qer/env/octo_ruin/octo_ruin.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.854551 0.481422 1 60 -60 23 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 90 4
	nopicmip
	skyparms skpk/env/octo_ruin/octo_ruin - -
}

textures/skies_MASTER3/ghost_sky_45
{
	qer_editorImage skpk/qer/env/yeti_nebula/yeti_nebula.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 85 4
	nopicmip
	skyparms skpk/env/yeti_nebula/yeti_nebula - -
}

textures/skies_MASTER6/kingdomsky
{
	qer_editorImage skpk/qer/6/kingdomsky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 255 245 235 22 -35 9 8 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 99 4
	nopicmip
	skyparms skpk/textures/tc_tanker2/env/sky1 - -
	{
		map skpk/textures/sky/kingdomskyclouds.tga
		tcMod scroll 0.0025 -0.0075
		tcMod scale 2 2
		rgbGen identityLighting
	}
	{
		map skpk/textures/tc_tanker2/sky/sky1_mask.tga
		blendFunc GL_ONE_MINUS_SRC_ALPHA GL_SRC_ALPHA
		tcMod transform 0.25 0 0 0.25 0.1075 0.1075
		rgbGen identityLighting
	}
}

textures/skies_MASTER3/86455248
{
	qer_editorImage skpk/qer/env/86455248.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_LightMapFilterRadius 0 8
	q3map_sunExt 255 245 230 70 -132 18 10 16
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/86455248 - -
}

textures/skies_MASTER3/autumn_forest_04
{
	qer_editorImage skpk/qer/env/autumn_forest_04.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 255 255 166 50 -36 8 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_lightRGB 240 240 255
	q3map_skylight 80 4 0 90 0
	nopicmip
	skyparms skpk/env/autumn_forest_04 - -
}

textures/skies_MASTER5/matrix
{
	qer_editorImage skpk/qer/env/thematrix.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 145 4 -90 90 1
	nopicmip
	skyparms skpk/env/thematrix - -
}


// Below pulled from gamebannana, thx to quBit for finding
// Thx to kairos for web scraping

textures/skies_MASTER4/badlands
{
	qer_editorImage skpk/qer/env/csgo/badlands.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 30 39 -9 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 100 4
	nopicmip
	skyparms skpk/env/csgo/badlands - -
}

textures/skies_MASTER4/baggage
{
	qer_editorImage skpk/qer/env/csgo/baggage.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 125 4
	nopicmip
	skyparms skpk/env/csgo/baggage - -
}

textures/skies_MASTER4/b_bartuc_canyon
{
	qer_editorImage skpk/qer/env/csgo/bartuc/bartuc_canyon.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyparms skpk/env/csgo/bartuc/bartuc_canyon - -
}

textures/skies_MASTER4/b_bartuc_grey_sky
{
	qer_editorImage skpk/qer/env/csgo/bartuc/bartuc_grey_sky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 50 -104 16 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 100 4
	nopicmip
	skyparms skpk/env/csgo/bartuc/bartuc_grey_sky - -
}

textures/skies_MASTER4/b_extreme_glaciation
{
	qer_editorImage skpk/qer/env/csgo/bartuc/extreme_glaciation.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 50 -89 15 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyparms skpk/env/csgo/bartuc/extreme_glaciation - -
}

textures/skies_MASTER4/b_persistent_fog
{
	qer_editorImage skpk/qer/env/csgo/bartuc/persistent_fog.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 140 4
	nopicmip
	skyparms skpk/env/csgo/bartuc/persistent_fog - -
}

textures/skies_MASTER4/b_polluted_atm
{
	qer_editorImage skpk/qer/env/csgo/bartuc/polluted_atm.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.81677 0.79852 0.2112 85 -89 39 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/csgo/bartuc/polluted_atm - -
}

textures/skies_MASTER4/b_toxic_atm
{
	qer_editorImage skpk/qer/env/csgo/bartuc/toxic_atm.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.513985 0.81677 0.211185 85 -89 39 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/csgo/bartuc/toxic_atm - -
}

textures/skies_MASTER4/b_water_sunset
{
	qer_editorImage skpk/qer/env/csgo/bartuc/water_sunset.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 -89 4 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/csgo/bartuc/water_sunset - -
}

textures/skies_MASTER4/cirus_02
{
	qer_editorImage skpk/qer/env/csgo/cirus_02.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 69 64 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/csgo/cirus_02 - -
}

textures/skies_MASTER4/cirus
{
	qer_editorImage skpk/qer/env/csgo/cirus.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 40 20 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/csgo/cirus - -
}

textures/skies_MASTER4/city2
{
	qer_editorImage skpk/qer/env/csgo/city.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 70 -46 1.5 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 90 4
	nopicmip
	skyparms skpk/env/csgo/city - -
}

textures/skies_MASTER4/Clear_night
{
	qer_editorImage skpk/qer/env/csgo/Clear_night.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 130 4
	nopicmip
	skyparms skpk/env/csgo/Clear_night - -
}

textures/skies_MASTER6/0color_clearsky
{
	qer_editorImage skpk/qer/env/csgo/clearsky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 130 4
	nopicmip
	skyparms skpk/env/csgo/clearsky - -
}

textures/skies_MASTER4/cloudy
{
	qer_editorImage skpk/qer/env/csgo/cloudy.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 6 29 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/csgo/cloudy - -
}

textures/skies_MASTER4/cloudynight
{
	qer_editorImage skpk/qer/env/csgo/cloudynight.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 55 -29 45 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 85 4
	nopicmip
	skyparms skpk/env/csgo/cloudynight - -
}

textures/skies_MASTER4/dark_sunset
{
	qer_editorImage skpk/qer/env/csgo/dark_sunset.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 125 4 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/csgo/dark_sunset - -
}

textures/skies_MASTER4/descent
{
	qer_editorImage skpk/qer/env/csgo/descent.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 140 4
	nopicmip
	skyparms skpk/env/csgo/descent - -
}

textures/skies_MASTER4/desert_3
{
	qer_editorImage skpk/qer/env/csgo/desert_3.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 81 37 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/csgo/desert_3 - -
}

textures/skies_MASTER4/desert_mountains
{
	qer_editorImage skpk/qer/env/csgo/desert_mountains.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 145 4
	nopicmip
	skyparms skpk/env/csgo/desert_mountains - -
}

textures/skies_MASTER4/EarthSpace01
{
	qer_editorImage skpk/qer/env/csgo/EarthSpace01.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 75 -3 62 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 80 4
	nopicmip
	skyparms skpk/env/csgo/EarthSpace01 - -
}

textures/skies_MASTER4/EarthSpace02_2k
{
	qer_editorImage skpk/qer/env/csgo/EarthSpace02_2k.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 50 52 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/csgo/EarthSpace02_2k - -
}

textures/skies_MASTER4/EarthSpace02b
{
	qer_editorImage skpk/qer/env/csgo/EarthSpace02b.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 20 50 52 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 120 4
	nopicmip
	skyparms skpk/env/csgo/EarthSpace02b - -
}

textures/skies_MASTER4/EarthSpace03
{
	qer_editorImage skpk/qer/env/csgo/EarthSpace03.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 65 -113 60 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 85 4
	nopicmip
	skyparms skpk/env/csgo/EarthSpace03 - -
}

textures/skies_MASTER4/EarthSpace03b
{
	qer_editorImage skpk/qer/env/csgo/EarthSpace03b.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 89 75 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/csgo/EarthSpace03b - -
}

textures/skies_MASTER4/EarthSpace03c
{
	qer_editorImage skpk/qer/env/csgo/EarthSpace03c.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 25 89 75 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 130 4
	nopicmip
	skyparms skpk/env/csgo/EarthSpace03c - -
}

textures/skies_MASTER4/EarthSpace04
{
	qer_editorImage skpk/qer/env/csgo/EarthSpace04.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 166 53 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/csgo/EarthSpace04 - -
}

textures/skies_MASTER4/EarthSpace04b
{
	qer_editorImage skpk/qer/env/csgo/EarthSpace04b.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyparms skpk/env/csgo/EarthSpace04b - -
}

textures/skies_MASTER4/EarthSpace04c
{
	qer_editorImage skpk/qer/env/csgo/EarthSpace04c.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 65 -89 17 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 90 4
	nopicmip
	skyparms skpk/env/csgo/EarthSpace04c - -
}

textures/skies_MASTER4/fallguys
{
	qer_editorImage skpk/qer/env/csgo/fallguys.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 125 4
	nopicmip
	skyparms skpk/env/csgo/fallguys - -
}

textures/skies_MASTER4/familyguy
{
	qer_editorImage skpk/qer/env/csgo/familyguy.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 125 4
	nopicmip
	skyparms skpk/env/csgo/familyguy - -
}

textures/skies_MASTER4/fjord
{
	qer_editorImage skpk/qer/env/csgo/fjord.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 -37 24 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/csgo/fjord - -
}

textures/skies_MASTER6/0color_green
{
	qer_editorImage skpk/qer/env/csgo/greensky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_lightRGB 0.612894 1 0.418036
	q3map_skylight 150 4 0 90 0
	nopicmip
	skyparms skpk/env/csgo/greensky - -
}

textures/skies_MASTER4/h3desert
{
	qer_editorImage skpk/qer/env/csgo/h3desert.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 -81 38 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/csgo/h3desert - -
}

textures/skies_MASTER4/hackerworld
{
	qer_editorImage skpk/qer/env/csgo/hackerworld.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 130 4
	nopicmip
	skyparms skpk/env/csgo/hackerworld - -
}

textures/skies_MASTER4/harvest
{
	qer_editorImage skpk/qer/env/csgo/harvest.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.946624 0.596292 0.528695 25 108 16 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 100 4
	nopicmip
	skyparms skpk/env/csgo/harvest - -
}

textures/skies_MASTER4/hdr_cliffside
{
	qer_editorImage skpk/qer/env/csgo/hdr/cliffside.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 -32 30 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/csgo/hdr/cliffside - -
}

textures/skies_MASTER4/hdr_goegap
{
	qer_editorImage skpk/qer/env/csgo/hdr/goegap.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 -38 46 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/csgo/hdr/goegap - -
}

textures/skies_MASTER4/hdr_OutdoorBeach
{
	qer_editorImage skpk/qer/env/csgo/hdr/HdrOutdoorBeachSunsetClear001.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 85 .9 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/csgo/hdr/HdrOutdoorBeachSunsetClear001 - -
}

textures/skies_MASTER4/hdr_hikers_cave
{
	qer_editorImage skpk/qer/env/csgo/hdr/hikers_cave.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 130 4
	nopicmip
	skyparms skpk/env/csgo/hdr/hikers_cave - -
}

textures/skies_MASTER4/hdr_moonless_golf
{
	qer_editorImage skpk/qer/env/csgo/hdr/moonless_golf.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 130 4
	nopicmip
	skyparms skpk/env/csgo/hdr/moonless_golf - -
}

textures/skies_MASTER4/hdr_shanghai_bund
{
	qer_editorImage skpk/qer/env/csgo/hdr/shanghai_bund.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 130 4
	nopicmip
	skyparms skpk/env/csgo/hdr/shanghai_bund - -
}

textures/skies_MASTER4/hdr_studio_small_01
{
	qer_editorImage skpk/qer/env/csgo/hdr/studio_small_01.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 45 43 28 2 16
	q3map_sunExt 1 1 1 45 -68 5 2 16
	q3map_sunExt 1 1 1 45 124 2 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/csgo/hdr/studio_small_01 - -
}

textures/skies_MASTER4/hdr_viale_giuseppe_garibaldi
{
	qer_editorImage skpk/qer/env/csgo/hdr/viale_giuseppe_garibaldi.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.955718 0.834882 0.584588 50 54 29 2 16
	q3map_sunExt 0.955718 0.834882 0.584588 50 -70 16 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 85 4
	nopicmip
	skyparms skpk/env/csgo/hdr/viale_giuseppe_garibaldi - -
}

textures/skies_MASTER5/mr_night-red
{
	qer_editorImage skpk/qer/env/csgo/hlw_night.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.933333 0.792157 0.498039 85 64 24 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 85 4
	nopicmip
	skyparms skpk/env/csgo/hlw_night - -
}

textures/skies_MASTER4/Installation05_01
{
	qer_editorImage skpk/qer/env/csgo/Installation05_01.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 -42 51 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/csgo/Installation05_01 - -
}

textures/skies_MASTER4/lunacy_sml_earth
{
	qer_editorImage skpk/qer/env/csgo/lunacy_sml_earth.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 -114 50 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/csgo/lunacy_sml_earth - -
}

textures/skies_MASTER4/marslike01
{
	qer_editorImage skpk/qer/env/csgo/marslike01.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.868574 0.75581 0.459907 65 -68 12 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 85 4
	nopicmip
	skyparms skpk/env/csgo/marslike01 - -
}

textures/skies_MASTER2/mcsky6
{
	qer_editorImage skpk/qer/env/csgo/MCLITE.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 -45 82 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/csgo/MCLITE - -
}

textures/skies_MASTER4/MilkyWAy
{
	qer_editorImage skpk/qer/env/csgo/MilkyWAy.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 125 4
	nopicmip
	skyparms skpk/env/csgo/MilkyWAy - -
}

textures/skies_MASTER4/mistystorm
{
	qer_editorImage skpk/qer/env/csgo/mistystorm.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 45 -36 75 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 90 4
	nopicmip
	skyparms skpk/env/csgo/mistystorm - -
}

textures/skies_MASTER4/Moonset
{
	qer_editorImage skpk/qer/env/csgo/Moonset.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 120 4
	nopicmip
	skyparms skpk/env/csgo/Moonset - -
}

textures/skies_MASTER4/mtt_engineer_01
{
	qer_editorImage skpk/qer/env/csgo/mtt_engineer_01.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyparms skpk/env/csgo/mtt_engineer_01 - -
}

textures/skies_MASTER4/nane
{
	qer_editorImage skpk/qer/env/csgo/nane.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 60 -124 28 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 80 4
	nopicmip
	skyparms skpk/env/csgo/nane - -
}

textures/skies_MASTER4/nebula_01
{
	qer_editorImage skpk/qer/env/csgo/nebula_01.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 125 4
	nopicmip
	skyparms skpk/env/csgo/nebula_01 - -
}

textures/skies_MASTER4/nebula_02
{
	qer_editorImage skpk/qer/env/csgo/nebula_02.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 0.655787 0.294255 70 0 90 2 16
	q3map_sunExt 0.909804 0.690196 0.0117647 85 -111 80 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 75 4
	nopicmip
	skyparms skpk/env/csgo/nebula_02 - -
}

textures/skies_MASTER4/nebula_03
{
	qer_editorImage skpk/qer/env/csgo/nebula_03.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 150 4
	nopicmip
	skyparms skpk/env/csgo/nebula_03 - -
}

textures/skies_MASTER4/nebula_04
{
	qer_editorImage skpk/qer/env/csgo/nebula_04.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 125 4
	nopicmip
	skyparms skpk/env/csgo/nebula_04 - -
}

textures/skies_MASTER4/nebula_05
{
	qer_editorImage skpk/qer/env/csgo/nebula_05.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 125 4
	nopicmip
	skyparms skpk/env/csgo/nebula_05 - -
}

textures/skies_MASTER4/nebula_06
{
	qer_editorImage skpk/qer/env/csgo/nebula_06.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 145 4
	nopicmip
	skyparms skpk/env/csgo/nebula_06 - -
}

textures/skies_MASTER4/nebula_07
{
	qer_editorImage skpk/qer/env/csgo/nebula_07.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 140 4
	nopicmip
	skyparms skpk/env/csgo/nebula_07 - -
}

textures/skies_MASTER4/nebula_08
{
	qer_editorImage skpk/qer/env/csgo/nebula_08.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyparms skpk/env/csgo/nebula_08 - -
}

textures/skies_MASTER4/nebula_09
{
	qer_editorImage skpk/qer/env/csgo/nebula_09.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 125 4
	nopicmip
	skyparms skpk/env/csgo/nebula_09 - -
}

textures/skies_MASTER4/nebula_10
{
	qer_editorImage skpk/qer/env/csgo/nebula_10.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 140 4
	nopicmip
	skyparms skpk/env/csgo/nebula_10 - -
}

textures/skies_MASTER4/nebula_11
{
	qer_editorImage skpk/qer/env/csgo/nebula_11.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 70 84 87 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 85 4
	nopicmip
	skyparms skpk/env/csgo/nebula_11 - -
}

textures/skies_MASTER4/nebula_12
{
	qer_editorImage skpk/qer/env/csgo/nebula_12.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 125 4
	nopicmip
	skyparms skpk/env/csgo/nebula_12 - -
}

textures/skies_MASTER4/new_year
{
	qer_editorImage skpk/qer/env/csgo/new_year.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 60 -92 33 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 140 4
	nopicmip
	skyparms skpk/env/csgo/new_year - -
}

textures/skies_MASTER4/oblako_01
{
	qer_editorImage skpk/qer/env/csgo/oblako_01.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyparms skpk/env/csgo/oblako_01 - -
}

textures/skies_MASTER4/purplehaze
{
	qer_editorImage skpk/qer/env/csgo/purplehaze.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.984314 0.603922 0.466667 65 74 25 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 80 4
	nopicmip
	skyparms skpk/env/csgo/purplehaze - -
}

textures/skies_MASTER4/ridge
{
	qer_editorImage skpk/qer/env/csgo/ridge.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 0.895903 0.750164 65 -34 32 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyparms skpk/env/csgo/ridge - -
}

textures/skies_MASTER4/simpsonshd
{
	qer_editorImage skpk/qer/env/csgo/simpsonshd.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyparms skpk/env/csgo/simpsonshd - -
}

textures/skies_MASTER4/sky1
{
	qer_editorImage skpk/qer/env/csgo/sky1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 -29 24 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/csgo/sky1 - -
}

textures/skies_MASTER4/sky2mh
{
	qer_editorImage skpk/qer/env/csgo/sky2mh.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.558221 0.983642 1 85 159 23 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 80 4
	nopicmip
	skyparms skpk/env/csgo/sky2mh - -
}

textures/skies_MASTER4/sky_dust
{
	qer_editorImage skpk/qer/env/csgo/sky_dust.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 130 4
	nopicmip
	skyparms skpk/env/csgo/sky_dust - -
}

textures/skies_MASTER4/sky_dust2
{
	qer_editorImage skpk/qer/env/csgo/sky_dust2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyparms skpk/env/csgo/sky_dust2 - -
}

textures/skies_MASTER4/sky_dust3
{
	qer_editorImage skpk/qer/env/csgo/sky_dust3.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyparms skpk/env/csgo/sky_dust3 - -
}

textures/skies_MASTER4/skylab_01
{
	qer_editorImage skpk/qer/env/csgo/skylab_01.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 55 -161 32 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 95 4
	nopicmip
	skyparms skpk/env/csgo/skylab_01 - -
}

textures/skies_MASTER4/Snow2048
{
	qer_editorImage skpk/qer/env/csgo/Snow2048.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 125 4
	nopicmip
	skyparms skpk/env/csgo/Snow2048 - -
}

textures/skies_MASTER4/se_earthlike_01
{
	qer_editorImage skpk/qer/env/csgo/spaceengine1/earthlike_01.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 101 0 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 120 4
	nopicmip
	skyparms skpk/env/csgo/spaceengine1/earthlike_01 - -
}

textures/skies_MASTER4/se_earthlike_02
{
	qer_editorImage skpk/qer/env/csgo/spaceengine1/earthlike_02.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 80 -6 75 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/csgo/spaceengine1/earthlike_02 - -
}

textures/skies_MASTER4/se_HazyMoon_01
{
	qer_editorImage skpk/qer/env/csgo/spaceengine1/HazyMoon_01.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 145 4
	nopicmip
	skyparms skpk/env/csgo/spaceengine1/HazyMoon_01 - -
}

textures/skies_MASTER4/se_MarsLike_01
{
	qer_editorImage skpk/qer/env/csgo/spaceengine1/MarsLike_01.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 109 39 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/csgo/spaceengine1/MarsLike_01 - -
}

textures/skies_MASTER4/se_MarsLike_02
{
	qer_editorImage skpk/qer/env/csgo/spaceengine1/MarsLike_02.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 104 57 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/csgo/spaceengine1/MarsLike_02 - -
}

textures/skies_MASTER4/se_MarsLike_Night
{
	qer_editorImage skpk/qer/env/csgo/spaceengine1/MarsLike_Night.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 140 4
	nopicmip
	skyparms skpk/env/csgo/spaceengine1/MarsLike_Night - -
}

textures/skies_MASTER4/se_MoonHab_01
{
	qer_editorImage skpk/qer/env/csgo/spaceengine1/MoonHab_01.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 71 33 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/csgo/spaceengine1/MoonHab_01 - -
}

textures/skies_MASTER4/se_MoonHab_02
{
	qer_editorImage skpk/qer/env/csgo/spaceengine1/MoonHab_02.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 58 1 2 16
	q3map_sunExt 1 1 1 20 -1 5 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms skpk/env/csgo/spaceengine1/MoonHab_02 - -
}

textures/skies_MASTER4/se_MoonHab_03
{
	qer_editorImage skpk/qer/env/csgo/spaceengine1/MoonHab_03.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 35 124 58 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 80 4
	nopicmip
	skyparms skpk/env/csgo/spaceengine1/MoonHab_03 - -
}

textures/skies_MASTER4/se_DesPlan_01
{
	qer_editorImage skpk/qer/env/csgo/spaceengine2/DesPlan_01.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 70 -82 84 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 80 4
	nopicmip
	skyparms skpk/env/csgo/spaceengine2/DesPlan_01 - -
}

textures/skies_MASTER4/se_DesPlan_02
{
	qer_editorImage skpk/qer/env/csgo/spaceengine2/DesPlan_02.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 75 88 9 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 80 4
	nopicmip
	skyparms skpk/env/csgo/spaceengine2/DesPlan_02 - -
}

textures/skies_MASTER4/se_reddwarfplan_01
{
	qer_editorImage skpk/qer/env/csgo/spaceengine2/reddwarfplan_01.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.952941 0.670588 0.211765 65 -29 2 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 90 4
	nopicmip
	skyparms skpk/env/csgo/spaceengine2/reddwarfplan_01 - -
}

textures/skies_MASTER4/se_reddwarfplan_02
{
	qer_editorImage skpk/qer/env/csgo/spaceengine2/reddwarfplan_02.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.952941 0.670588 0.211765 65 -89 0 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 100 4
	nopicmip
	skyparms skpk/env/csgo/spaceengine2/reddwarfplan_02 - -
}

textures/skies_MASTER4/se_RingTerra_01
{
	qer_editorImage skpk/qer/env/csgo/spaceengine2/RingTerra_01.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 92 29 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/csgo/spaceengine2/RingTerra_01 - -
}

textures/skies_MASTER4/sunrise_01
{
	qer_editorImage skpk/qer/env/csgo/sunrise_01.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 0.900389 0.674952 85 -14 5 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/csgo/sunrise_01 - -
}

textures/skies_MASTER4/trainnight_01
{
	qer_editorImage skpk/qer/env/csgo/trainnight_01.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 45 115 54 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 95 4
	nopicmip
	skyparms skpk/env/csgo/trainnight_01 - -
}

textures/skies_MASTER4/workshop
{
	qer_editorImage skpk/qer/env/csgo/workshop.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_lightRGB 1 1 1
	q3map_skylight 120 4 0 90 0
	nopicmip
	skyparms skpk/env/csgo/workshop - -
}

textures/skies_MASTER4/2desert
{
	qer_editorImage skpk/qer/env/cs/2desert.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 120 4
	nopicmip
	skyparms skpk/env/cs/2desert - -
}

textures/skies_MASTER4/3dm747
{
	qer_editorImage skpk/qer/env/cs/3dm747.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 45 -121 25 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 85 4
	nopicmip
	skyparms skpk/env/cs/3dm747 - -
}

textures/skies_MASTER4/3dmfalls
{
	qer_editorImage skpk/qer/env/cs/3dmfalls.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 -118 25 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/cs/3dmfalls - -
}

textures/skies_MASTER4/52h08
{
	qer_editorImage skpk/qer/env/cs/52h08.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 0.900389 0.674952 85 -17 18 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/cs/52h08 - -
}

textures/skies_MASTER4/52h09
{
	qer_editorImage skpk/qer/env/cs/52h09.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 80 104 16 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 75 4
	nopicmip
	skyparms skpk/env/cs/52h09 - -
}

textures/skies_MASTER4/air
{
	qer_editorImage skpk/qer/env/cs/air.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 120 4
	nopicmip
	skyparms skpk/env/cs/air - -
}

textures/skies_MASTER4/altstadt2k
{
	qer_editorImage skpk/qer/env/cs/altstadt2k.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 38 36 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/cs/altstadt2k - -
}

textures/skies_MASTER4/anachronism
{
	qer_editorImage skpk/qer/env/cs/anachronism.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 60 19 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/cs/anachronism - -
}

textures/skies_MASTER4/antarctic_wizdom
{
	qer_editorImage skpk/qer/env/cs/antarctic_wizdom.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 130 4
	nopicmip
	skyparms skpk/env/cs/antarctic_wizdom - -
}

textures/skies_MASTER4/AuntArctica
{
	qer_editorImage skpk/qer/env/cs/AuntArctica.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 -97 15 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 75 4
	nopicmip
	skyparms skpk/env/cs/AuntArctica - -
}

textures/skies_MASTER4/autumn_day1
{
	qer_editorImage skpk/qer/env/cs/autumn_day1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 125 4
	nopicmip
	skyparms skpk/env/cs/autumn_day1 - -
}

textures/skies_MASTER4/backalley2
{
	qer_editorImage skpk/qer/env/cs/backalley.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyparms skpk/env/cs/backalley - -
}

textures/skies_MASTER4/beta_2desert
{
	qer_editorImage skpk/qer/env/cs/betaskies/2desert.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 40 32 4 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 95 4
	nopicmip
	skyparms skpk/env/cs/betaskies/2desert - -
}

textures/skies_MASTER4/beta_desert
{
	qer_editorImage skpk/qer/env/cs/betaskies/desert.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 130 4
	nopicmip
	skyparms skpk/env/cs/betaskies/desert - -
}

textures/skies_MASTER4/beta_night
{
	qer_editorImage skpk/qer/env/cs/betaskies/night.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 40 32 4 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 95 4
	nopicmip
	skyparms skpk/env/cs/betaskies/night - -
}

textures/skies_MASTER4/sqpants
{
	qer_editorImage skpk/qer/env/cs/bikini_bottom.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 130 4
	nopicmip
	skyparms skpk/env/cs/bikini_bottom - -
}

textures/skies_MASTER4/sqpants2
{
	qer_editorImage skpk/qer/env/cs/bikini_bottom2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 130 4
	nopicmip
	skyparms skpk/env/cs/bikini_bottom2 - -
}

textures/skies_MASTER4/blue_lightning
{
	qer_editorImage skpk/qer/env/cs/blue_lightning.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyparms skpk/env/cs/blue_lightning - -
}

textures/skies_MASTER4/bluenebula
{
	qer_editorImage skpk/qer/env/cs/bluenebula.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.45098 0.854902 0.870588 85 -172 28 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 75 4
	nopicmip
	skyparms skpk/env/cs/bluenebula - -
}

textures/skies_MASTER4/bluesky-dim
{
	qer_editorImage skpk/qer/env/cs/bluesky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyparms skpk/env/cs/bluesky - -
}

textures/skies_MASTER4/citrain
{
	qer_editorImage skpk/qer/env/cs/citrain.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 130 4
	nopicmip
	skyparms skpk/env/cs/citrain - -
}

//very low quality
textures/skies_MASTER4/city3
{
	qer_editorImage skpk/qer/env/cs/city.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 125 4
	nopicmip
	skyparms skpk/env/cs/city - -
}

textures/skies_MASTER4/city_nite
{
	qer_editorImage skpk/qer/env/cs/city_nite.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 125 4
	nopicmip
	skyparms skpk/env/cs/city_nite - -
}

textures/skies_MASTER4/cl_desert
{
	qer_editorImage skpk/qer/env/cs/cl_desert.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.885039 0.812314 0.547097 65 -118 31 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 75 4
	nopicmip
	skyparms skpk/env/cs/cl_desert - -
}

textures/skies_MASTER4/clear
{
	qer_editorImage skpk/qer/env/cs/clear.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 0.986297 0.82179 85 0 90 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/cs/clear - -
}

textures/skies_MASTER4/cloudy11
{
	qer_editorImage skpk/qer/env/cs/cloudy11.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 145 4
	nopicmip
	skyparms skpk/env/cs/cloudy11 - -
}

textures/skies_MASTER4/cobble
{
	qer_editorImage skpk/qer/env/cs/cobble.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 120 4
	nopicmip
	skyparms skpk/env/cs/cobble - -
}

textures/skies_MASTER4/csgo
{
	qer_editorImage skpk/qer/env/cs/csgo.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 60 -131 41 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 85 4
	nopicmip
	skyparms skpk/env/cs/csgo - -
}

textures/skies_MASTER4/cso2
{
	qer_editorImage skpk/qer/env/cs/cso2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 120 4
	nopicmip
	skyparms skpk/env/cs/cso2 - -
}

textures/skies_MASTER4/CSO_cliff-night
{
	qer_editorImage skpk/qer/env/cs/CSOlDJB/2cliff.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyparms skpk/env/cs/CSOlDJB/2cliff - -
}

textures/skies_MASTER4/CSO_dsnow-office
{
	qer_editorImage skpk/qer/env/cs/CSOlDJB/2office.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 120 4
	nopicmip
	skyparms skpk/env/cs/CSOlDJB/2office - -
}

textures/skies_MASTER4/CSO_tsccity-green
{
	qer_editorImage skpk/qer/env/cs/CSOlDJB/ae.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 35 15 51 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 85 4
	nopicmip
	skyparms skpk/env/cs/CSOlDJB/ae - -
}

textures/skies_MASTER4/CSO_an
{
	qer_editorImage skpk/qer/env/cs/CSOlDJB/an.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyparms skpk/env/cs/CSOlDJB/an - -
}

textures/skies_MASTER4/CSO_backalley
{
	qer_editorImage skpk/qer/env/cs/CSOlDJB/backalley.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 80 2 60 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/cs/CSOlDJB/backalley - -
}

textures/skies_MASTER4/CSO_bb
{
	qer_editorImage skpk/qer/env/cs/CSOlDJB/bb.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 125 4
	nopicmip
	skyparms skpk/env/cs/CSOlDJB/bb - -
}

textures/skies_MASTER4/CSO_blue
{
	qer_editorImage skpk/qer/env/cs/CSOlDJB/blue.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 -76 4 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/cs/CSOlDJB/blue - -
}

textures/skies_MASTER4/CSO_camo
{
	qer_editorImage skpk/qer/env/cs/CSOlDJB/camo.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 -53 36 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/cs/CSOlDJB/camo - -
}

textures/skies_MASTER4/CSO_city1
{
	qer_editorImage skpk/qer/env/cs/CSOlDJB/city1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 125 4
	nopicmip
	skyparms skpk/env/cs/CSOlDJB/city1 - -
}

textures/skies_MASTER4/CSO_cliff
{
	qer_editorImage skpk/qer/env/cs/CSOlDJB/cliff.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 -152 29 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/cs/CSOlDJB/cliff - -
}

textures/skies_MASTER4/CSO_camo-yellower
{
	qer_editorImage skpk/qer/env/cs/CSOlDJB/cx2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.954452 0.873243 0.406104 70 -71 75 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 80 4
	nopicmip
	skyparms skpk/env/cs/CSOlDJB/cx2 - -
}

textures/skies_MASTER4/CSO_camo-yellow
{
	qer_editorImage skpk/qer/env/cs/CSOlDJB/cx.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 0.894789 0.549996 85 -84 79 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/cs/CSOlDJB/cx - -
}

textures/skies_MASTER4/CSO_de_storm
{
	qer_editorImage skpk/qer/env/cs/CSOlDJB/de_storm.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyparms skpk/env/cs/CSOlDJB/de_storm - -
}

textures/skies_MASTER4/CSO_des
{
	qer_editorImage skpk/qer/env/cs/CSOlDJB/des.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 -179 60 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/cs/CSOlDJB/des - -
}

textures/skies_MASTER4/CSO_desert
{
	qer_editorImage skpk/qer/env/cs/CSOlDJB/desert.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 0.986297 0.82179 85 65 73 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/cs/CSOlDJB/desert - -
}

textures/skies_MASTER4/CSO_doom1
{
	qer_editorImage skpk/qer/env/cs/CSOlDJB/doom1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 120 4
	nopicmip
	skyparms skpk/env/cs/CSOlDJB/doom1 - -
}

textures/skies_MASTER4/CSO_dsnow
{
	qer_editorImage skpk/qer/env/cs/CSOlDJB/dsnow.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 120 4
	nopicmip
	skyparms skpk/env/cs/CSOlDJB/dsnow - -
}

textures/skies_MASTER4/CSO_desert-dusk
{
	qer_editorImage skpk/qer/env/cs/CSOlDJB/dusk.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.954452 0.81265 0.406104 30 132 9 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 95 4
	nopicmip
	skyparms skpk/env/cs/CSOlDJB/dusk - -
}

textures/skies_MASTER4/CSO_green
{
	qer_editorImage skpk/qer/env/cs/CSOlDJB/green.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyparms skpk/env/cs/CSOlDJB/green - -
}

textures/skies_MASTER4/CSO_grnplsnt
{
	qer_editorImage skpk/qer/env/cs/CSOlDJB/grnplsnt.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 60 60 15 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 80 4
	nopicmip
	skyparms skpk/env/cs/CSOlDJB/grnplsnt - -
}

textures/skies_MASTER4/CSO_grsky
{
	qer_editorImage skpk/qer/env/cs/CSOlDJB/grsky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 45 -139 10 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 85 4
	nopicmip
	skyparms skpk/env/cs/CSOlDJB/grsky - -
}

textures/skies_MASTER4/CSO_har
{
	qer_editorImage skpk/qer/env/cs/CSOlDJB/har.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 130 4
	nopicmip
	skyparms skpk/env/cs/CSOlDJB/har - -
}

textures/skies_MASTER4/CSO_hav
{
	qer_editorImage skpk/qer/env/cs/CSOlDJB/hav.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_lightRGB 255 222 152
	q3map_skylight 55 4 0 90 0
	nopicmip
	skyparms skpk/env/cs/CSOlDJB/hav - -
}

textures/skies_MASTER4/CSO_hk
{
	qer_editorImage skpk/qer/env/cs/CSOlDJB/hk.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 55 1 60 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 80 4
	nopicmip
	skyparms skpk/env/cs/CSOlDJB/hk - -
}

textures/skies_MASTER4/CSO_hs4
{
	qer_editorImage skpk/qer/env/cs/CSOlDJB/hs4.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 15 -93 -7 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyparms skpk/env/cs/CSOlDJB/hs4 - -
}

textures/skies_MASTER4/CSO_hs
{
	qer_editorImage skpk/qer/env/cs/CSOlDJB/hs.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 40 1 47 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 90 4
	nopicmip
	skyparms skpk/env/cs/CSOlDJB/hs - -
}

textures/skies_MASTER4/CSO_an-dim
{
	qer_editorImage skpk/qer/env/cs/CSOlDJB/lc.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyparms skpk/env/cs/CSOlDJB/lc - -
}

textures/skies_MASTER4/CSO_mist
{
	qer_editorImage skpk/qer/env/cs/CSOlDJB/mist.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 125 4
	nopicmip
	skyparms skpk/env/cs/CSOlDJB/mist - -
}

textures/skies_MASTER4/CSO_moon
{
	qer_editorImage skpk/qer/env/cs/CSOlDJB/moon.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 20 -23 49 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 100 4
	nopicmip
	skyparms skpk/env/cs/CSOlDJB/moon - -
}

textures/skies_MASTER4/CSO_morningdew
{
	qer_editorImage skpk/qer/env/cs/CSOlDJB/morningdew.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.985595 0.74844 1 85 -150 12 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/cs/CSOlDJB/morningdew - -
}

textures/skies_MASTER4/CSO_ntdm2
{
	qer_editorImage skpk/qer/env/cs/CSOlDJB/ntdm2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 -4 42 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/cs/CSOlDJB/ntdm2 - -
}

textures/skies_MASTER4/CSO_ntdm3
{
	qer_editorImage skpk/qer/env/cs/CSOlDJB/ntdm3.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 30 -4 42 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 100 4
	nopicmip
	skyparms skpk/env/cs/CSOlDJB/ntdm3 - -
}

textures/skies_MASTER4/CSO_dsnow-office-clear
{
	qer_editorImage skpk/qer/env/cs/CSOlDJB/office.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 60 -64 66 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 85 4
	nopicmip
	skyparms skpk/env/cs/CSOlDJB/office - -
}

textures/skies_MASTER4/CSO_desert-reddusk
{
	qer_editorImage skpk/qer/env/cs/CSOlDJB/reddusk.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 20 132 8 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 100 4
	nopicmip
	skyparms skpk/env/cs/CSOlDJB/reddusk - -
}

textures/skies_MASTER4/CSO_redsky
{
	qer_editorImage skpk/qer/env/cs/CSOlDJB/redsky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 0.574029 0.391653 70 55 11 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 90 4
	nopicmip
	skyparms skpk/env/cs/CSOlDJB/redsky - -
}

textures/skies_MASTER4/CSO_san
{
	qer_editorImage skpk/qer/env/cs/CSOlDJB/san.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 45 55 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/cs/CSOlDJB/san - -
}

textures/skies_MASTER4/CSO_sienna
{
	qer_editorImage skpk/qer/env/cs/CSOlDJB/sienna.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 60 1 81 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 85 4
	nopicmip
	skyparms skpk/env/cs/CSOlDJB/sienna - -
}

textures/skies_MASTER4/CSO_sky
{
	qer_editorImage skpk/qer/env/cs/CSOlDJB/sky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.988037 0.926284 0.676509 85 0 90 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/cs/CSOlDJB/sky - -
}

textures/skies_MASTER4/CSO_snowlake
{
	qer_editorImage skpk/qer/env/cs/CSOlDJB/snowlake.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 50 43 25 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 95 4
	nopicmip
	skyparms skpk/env/cs/CSOlDJB/snowlake - -
}

textures/skies_MASTER4/CSO_desert-pale
{
	qer_editorImage skpk/qer/env/cs/CSOlDJB/strange.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 70 66 75 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 85 4
	nopicmip
	skyparms skpk/env/cs/CSOlDJB/strange - -
}

textures/skies_MASTER4/CSO_tomb
{
	qer_editorImage skpk/qer/env/cs/CSOlDJB/tomb.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 30 21 51 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 95 4
	nopicmip
	skyparms skpk/env/cs/CSOlDJB/tomb - -
}

textures/skies_MASTER4/CSO_sienna-trace
{
	qer_editorImage skpk/qer/env/cs/CSOlDJB/trace.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 60 2 81 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 85 4
	nopicmip
	skyparms skpk/env/cs/CSOlDJB/trace - -
}

textures/skies_MASTER4/CSO_trainyard
{
	qer_editorImage skpk/qer/env/cs/CSOlDJB/trainyard.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 -179 35 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/cs/CSOlDJB/trainyard - -
}

textures/skies_MASTER4/CSO_tsccity
{
	qer_editorImage skpk/qer/env/cs/CSOlDJB/tsccity.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 60 16 52 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 80 4
	nopicmip
	skyparms skpk/env/cs/CSOlDJB/tsccity - -
}

textures/skies_MASTER4/CSO_vostok
{
	qer_editorImage skpk/qer/env/cs/CSOlDJB/vostok.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 120 4
	nopicmip
	skyparms skpk/env/cs/CSOlDJB/vostok - -
}

textures/skies_MASTER4/CSO_z3
{
	qer_editorImage skpk/qer/env/cs/CSOlDJB/z3.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 145 4
	nopicmip
	skyparms skpk/env/cs/CSOlDJB/z3 - -
}

textures/skies_MASTER4/CSO_z4line
{
	qer_editorImage skpk/qer/env/cs/CSOlDJB/z4line.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.885039 0.812314 0.547097 70 125 22 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 75 4
	nopicmip
	skyparms skpk/env/cs/CSOlDJB/z4line - -
}

textures/skies_MASTER4/CSO_tsccity-ruined
{
	qer_editorImage skpk/qer/env/cs/CSOlDJB/zs5ae.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 60 16 52 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 80 4
	nopicmip
	skyparms skpk/env/cs/CSOlDJB/zs5ae - -
}

textures/skies_MASTER4/day2
{
	qer_editorImage skpk/qer/env/cs/day2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 -33 58 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/cs/day2 - -
}

textures/skies_MASTER4/day757
{
	qer_editorImage skpk/qer/env/cs/day757.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.968627 0.980392 0.741176 85 -75 12 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/cs/day757 - -
}

textures/skies_MASTER4/day_cloudy
{
	qer_editorImage skpk/qer/env/cs/day_cloudy.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 125 4
	nopicmip
	skyparms skpk/env/cs/day_cloudy - -
}

textures/skies_MASTER4/Des
{
	qer_editorImage skpk/qer/env/cs/Des.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 130 4
	nopicmip
	skyparms skpk/env/cs/Des - -
}

textures/skies_MASTER4/desert194
{
	qer_editorImage skpk/qer/env/cs/desert194.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 6 31 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/cs/desert194 - -
}

textures/skies_MASTER4/desert
{
	qer_editorImage skpk/qer/env/cs/desert.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.962493 0.829435 0.291279 85 89 10 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/cs/desert - -
}

textures/skies_MASTER4/deserted
{
	qer_editorImage skpk/qer/env/cs/deserted.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 -29 25 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/cs/deserted - -
}

textures/skies_MASTER4/dev_kuncle
{
	qer_editorImage skpk/qer/env/cs/dev_kuncle.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_lightRGB 1 1 1
	q3map_skylight 125 4 0 90 0
	nopicmip
	skyparms skpk/env/cs/dev_kuncle - -
}

textures/skies_MASTER4/dios_camp1
{
	qer_editorImage skpk/qer/env/cs/dios_camp1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyparms skpk/env/cs/dios_camp1 - -
}

textures/skies_MASTER4/Embassy
{
	qer_editorImage skpk/qer/env/cs/Embassy.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 125 4
	nopicmip
	skyparms skpk/env/cs/Embassy - -
}

textures/skies_MASTER4/Foggy_Sun
{
	qer_editorImage skpk/qer/env/cs/Foggy_Sun.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.960784 0.870588 0.643137 80 83 12 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/cs/Foggy_Sun - -
}

//top sky only
textures/skies_MASTER4/furien_Blue
{
	qer_editorImage skpk/qer/env/cs/furien_sky/BlueSky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 -166 2 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/cs/furien_sky/BlueSky - -
}

textures/skies_MASTER4/furien_blood
{
	qer_editorImage skpk/qer/env/cs/furien_sky_2/blood.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.943786 0.537987 0.355383 65 -119 64 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 85 4
	nopicmip
	skyparms skpk/env/cs/furien_sky_2/blood - -
}

textures/skies_MASTER4/garden
{
	qer_editorImage skpk/qer/env/cs/garden.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 60 35 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/cs/garden - -
}

textures/skies_MASTER4/gars
{
	qer_editorImage skpk/qer/env/cs/gars.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 -105 22 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/cs/gars - -
}

textures/skies_MASTER4/Geoz
{
	qer_editorImage skpk/qer/env/cs/Geoz.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 130 4
	nopicmip
	skyparms skpk/env/cs/Geoz - -
}

textures/skies_MASTER4/grand_night
{
	qer_editorImage skpk/qer/env/cs/grand_night.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 -83 41 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/cs/grand_night - -
}

textures/skies_MASTER4/greenland71
{
	qer_editorImage skpk/qer/env/cs/greenland71.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 50 29 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/cs/greenland71 - -
}

textures/skies_MASTER4/height
{
	qer_editorImage skpk/qer/env/cs/height.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 150 18 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/cs/height - -
}

textures/skies_MASTER4/highland77
{
	qer_editorImage skpk/qer/env/cs/highland77.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyparms skpk/env/cs/highland77 - -
}

//top sky only
textures/skies_MASTER4/insurgency
{
	qer_editorImage skpk/qer/env/cs/insurgency.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 -25 53 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/cs/insurgency - -
}

textures/skies_MASTER4/jungle
{
	qer_editorImage skpk/qer/env/cs/jungle.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 130 4
	nopicmip
	skyparms skpk/env/cs/jungle - -
}

textures/skies_MASTER4/junglehills
{
	qer_editorImage skpk/qer/env/cs/junglehills.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 75 -29 17 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 80 4
	nopicmip
	skyparms skpk/env/cs/junglehills - -
}

textures/skies_MASTER4/lakes
{
	qer_editorImage skpk/qer/env/cs/lakes.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 70 60 25 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 85 4
	nopicmip
	skyparms skpk/env/cs/lakes - -
}

textures/skies_MASTER4/leto
{
	qer_editorImage skpk/qer/env/cs/leto.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.97026 0.842664 0.326558 85 77 18 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/cs/leto - -
}

textures/skies_MASTER4/lochness
{
	qer_editorImage skpk/qer/env/cs/lochness.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 60 21 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/cs/lochness - -
}

textures/skies_MASTER4/m_bas
{
	qer_editorImage skpk/qer/env/cs/m_bas.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.729015 0.975799 1 85 -153 2 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 95 4
	nopicmip
	skyparms skpk/env/cs/m_bas - -
}

textures/skies_MASTER4/maplenight
{
	qer_editorImage skpk/qer/env/cs/maplenight.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 20 -82 36 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 110 4
	nopicmip
	skyparms skpk/env/cs/maplenight - -
}

textures/skies_MASTER4/mars
{
	qer_editorImage skpk/qer/env/cs/mars.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 35 -20 36 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 100 4
	nopicmip
	skyparms skpk/env/cs/mars - -
}

textures/skies_MASTER2/mcsky
{
	qer_editorImage skpk/qer/env/cs/mc.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyparms skpk/env/cs/mc - -
}

textures/skies_MASTER4/MilkWorld
{
	qer_editorImage skpk/qer/env/cs/MilkWorld.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyparms skpk/env/cs/MilkWorld - -
}

textures/skies_MASTER4/milky
{
	qer_editorImage skpk/qer/env/cs/milky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 130 4
	nopicmip
	skyparms skpk/env/cs/milky - -
}

textures/skies_MASTER4/moonlight
{
	qer_editorImage skpk/qer/env/cs/moonlight.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.54902 0.803922 0.901961 85 -119 24 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/cs/moonlight - -
}

textures/skies_MASTER4/mountains
{
	qer_editorImage skpk/qer/env/cs/mountains.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 2 19 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/cs/mountains - -
}

textures/skies_MASTER4/mpa08
{
	qer_editorImage skpk/qer/env/cs/mpa_cs/mpa08_cs.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.958297 0.873243 0.599847 85 60 35 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/cs/mpa_cs/mpa08_cs - -
}

textures/skies_MASTER4/mpa12
{
	qer_editorImage skpk/qer/env/cs/mpa_cs/mpa12_cs.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 35 62 34 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 105 4
	nopicmip
	skyparms skpk/env/cs/mpa_cs/mpa12_cs - -
}

textures/skies_MASTER4/mpa30
{
	qer_editorImage skpk/qer/env/cs/mpa_cs/mpa30_cs.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 0.703349 0.211093 85 59 3 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/cs/mpa_cs/mpa30_cs - -
}

textures/skies_MASTER4/mpa31
{
	qer_editorImage skpk/qer/env/cs/mpa_cs/mpa31_cs.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.958297 0.873243 0.599847 70 90 31 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 85 4
	nopicmip
	skyparms skpk/env/cs/mpa_cs/mpa31_cs - -
}

textures/skies_MASTER4/mpa32
{
	qer_editorImage skpk/qer/env/cs/mpa_cs/mpa32_cs.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.878431 0.854902 0.588235 60 90 31 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 90 4
	nopicmip
	skyparms skpk/env/cs/mpa_cs/mpa32_cs - -
}

textures/skies_MASTER4/mpa33
{
	qer_editorImage skpk/qer/env/cs/mpa_cs/mpa33_cs.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 120 4
	nopicmip
	skyparms skpk/env/cs/mpa_cs/mpa33_cs - -
}

textures/skies_MASTER4/mpa34
{
	qer_editorImage skpk/qer/env/cs/mpa_cs/mpa34_cs.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.991897 1 0.71986 60 66 36 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 90 4
	nopicmip
	skyparms skpk/env/cs/mpa_cs/mpa34_cs - -
}

textures/skies_MASTER4/mpa51
{
	qer_editorImage skpk/qer/env/cs/mpa_cs/mpa51_cs.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.975875 0.78616 0.409842 85 117 18 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/cs/mpa_cs/mpa51_cs - -
}

textures/skies_MASTER4/mpa64
{
	qer_editorImage skpk/qer/env/cs/mpa_cs/mpa64_cs.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 20 62 21 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms skpk/env/cs/mpa_cs/mpa64_cs - -
}

textures/skies_MASTER4/mpa65
{
	qer_editorImage skpk/qer/env/cs/mpa_cs/mpa65_cs.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 20 7 23 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms skpk/env/cs/mpa_cs/mpa65_cs - -
}

textures/skies_MASTER4/mpa82_2
{
	qer_editorImage skpk/qer/env/cs/mpa_cs/mpa82_2_cs.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 32 15 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/cs/mpa_cs/mpa82_2_cs - -
}

textures/skies_MASTER4/mpa82
{
	qer_editorImage skpk/qer/env/cs/mpa_cs/mpa82_cs.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.85098 0.941176 0.458824 85 31 16 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/cs/mpa_cs/mpa82_cs - -
}

textures/skies_MASTER4/mpa_dust01
{
	qer_editorImage skpk/qer/env/cs/mpa_cs/mpa_dust01_cs.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.957244 0.967773 0.604074 30 60 29 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 110 4
	nopicmip
	skyparms skpk/env/cs/mpa_cs/mpa_dust01_cs - -
}

textures/skies_MASTER4/mpa_dust02
{
	qer_editorImage skpk/qer/env/cs/mpa_cs/mpa_dust02_cs.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 60 33 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/cs/mpa_cs/mpa_dust02_cs - -
}

textures/skies_MASTER4/mpa_sand
{
	qer_editorImage skpk/qer/env/cs/mpa_cs/mpa_sand_cs.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 35 61 35 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 105 4
	nopicmip
	skyparms skpk/env/cs/mpa_cs/mpa_sand_cs - -
}

textures/skies_MASTER4/nebo1
{
	qer_editorImage skpk/qer/env/cs/nebo1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.996002 0.815656 0.37583 85 -29 23 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/cs/nebo1 - -
}

textures/skies_MASTER4/nebo2
{
	qer_editorImage skpk/qer/env/cs/nebo2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 146 26 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/cs/nebo2 - -
}

textures/skies_MASTER4/nebo3
{
	qer_editorImage skpk/qer/env/cs/nebo3.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 0.908003 0.588785 75 98 12 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 85 4
	nopicmip
	skyparms skpk/env/cs/nebo3 - -
}

textures/skies_MASTER4/nebo4
{
	qer_editorImage skpk/qer/env/cs/nebo4.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 0.750195 0.588785 60 90 14 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 95 4
	nopicmip
	skyparms skpk/env/cs/nebo4 - -
}

textures/skies_MASTER4/nebo5
{
	qer_editorImage skpk/qer/env/cs/nebo5.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 -29 25 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/cs/nebo5 - -
}

textures/skies_MASTER4/nebo6
{
	qer_editorImage skpk/qer/env/cs/nebo6.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 35 -44 35 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 100 4
	nopicmip
	skyparms skpk/env/cs/nebo6 - -
}

textures/skies_MASTER4/nebo7
{
	qer_editorImage skpk/qer/env/cs/nebo7.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 0.968139 0.602228 85 -30 25 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/cs/nebo7 - -
}

textures/skies_MASTER4/nebo8
{
	qer_editorImage skpk/qer/env/cs/nebo8.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 0.872984 0.602228 25 -11 22 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 110 4
	nopicmip
	skyparms skpk/env/cs/nebo8 - -
}

textures/skies_MASTER4/nebo9
{
	qer_editorImage skpk/qer/env/cs/nebo9.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 -29 25 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/cs/nebo9 - -
}

textures/skies_MASTER4/nebosky1
{
	qer_editorImage skpk/qer/env/cs/nebosky1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.980392 0.898039 0.784314 85 88 10 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/cs/nebosky1 - -
}

textures/skies_MASTER4/neotokyo
{
	qer_editorimage skpk/qer/env/cs/neotokyo.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 111 4
	nopicmip
	skyparms skpk/env/cs/neotokyo - -
}

textures/skies_MASTER4/niceday2
{
	qer_editorImage skpk/qer/env/cs/niceday2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 120 4
	nopicmip
	skyparms skpk/env/cs/niceday2 - -
}

textures/skies_MASTER4/night_cloudy
{
	qer_editorImage skpk/qer/env/cs/night_skyboxes/nightsky_cloudy.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 125 4
	nopicmip
	skyparms skpk/env/cs/night_skyboxes/nightsky_cloudy - -
}

textures/skies_MASTER4/night_sky
{
	qer_editorImage skpk/qer/env/cs/night_skyboxes/nightsky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyparms skpk/env/cs/night_skyboxes/nightsky - -
}

textures/skies_MASTER4/nothingness
{
	qer_editorImage skpk/qer/env/cs/nothingness.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 150 4
	nopicmip
	skyparms skpk/env/cs/nothingness - -
}

textures/skies_MASTER4/nyc
{
	qer_editorImage skpk/qer/env/cs/nyc.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 60 137 71 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 90 4
	nopicmip
	skyparms skpk/env/cs/nyc - -
}

textures/skies_MASTER4/Parfait
{
	qer_editorImage skpk/qer/env/cs/Parfait.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 130 4
	nopicmip
	skyparms skpk/env/cs/Parfait - -
}

textures/skies_MASTER4/perl
{
	qer_editorImage skpk/qer/env/cs/perl.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 70 60 24 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 85 4
	nopicmip
	skyparms skpk/env/cs/perl - -
}

textures/skies_MASTER/hip_miramar-cyan
{
	qer_editorImage skpk/qer/env/cs/picnic_weather.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 146 4
	nopicmip
	skyparms skpk/env/cs/picnic_weather - -
}

textures/skies_MASTER4/planina
{
	qer_editorImage skpk/qer/env/cs/planina.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.992157 0.898039 0.74902 85 -89 25 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/cs/planina - -
}

textures/skies_MASTER4/PP
{
	qer_editorImage skpk/qer/env/cs/PP.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 50 100 32 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 105 4
	nopicmip
	skyparms skpk/env/cs/PP - -
}

textures/skies_MASTER4/purplegalaxy
{
	qer_editorImage skpk/qer/env/cs/purplegalaxy.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 150 4
	nopicmip
	skyparms skpk/env/cs/purplegalaxy - -
}

textures/skies_MASTER4/rainbow
{
	qer_editorImage skpk/qer/env/cs/rainbow.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 130 4
	nopicmip
	skyparms skpk/env/cs/rainbow - -
}

textures/skies_MASTER4/red_centre
{
	qer_editorImage skpk/qer/env/cs/red_centre.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 -30 25 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/cs/red_centre - -
}

textures/skies_MASTER4/redlight
{
	qer_editorImage skpk/qer/env/cs/redlight.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 145 4
	nopicmip
	skyparms skpk/env/cs/redlight - -
}

textures/skies_MASTER4/redplanet
{
	qer_editorImage skpk/qer/env/cs/redplanet.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 0.274403 0.352026 85 -92 86 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/cs/redplanet - -
}

textures/skies_MASTER3/gulf1-dimSky
{
	qer_editorImage skpk/qer/env/cs/redsand.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyparms skpk/env/cs/redsand - -
}

textures/skies_MASTER4/rio
{
	qer_editorImage skpk/qer/env/cs/rio.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 130 4
	nopicmip
	skyparms skpk/env/cs/rio - -
}

textures/skies_MASTER4/scud
{
	qer_editorImage skpk/qer/env/cs/scud.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 147 62 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/cs/scud - -
}

textures/skies_MASTER4/sky_2
{
	qer_editorImage skpk/qer/env/cs/sky_2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 -90 22 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/cs/sky_2 - -
}

textures/skies_MASTER4/sky_lake_night
{
	qer_editorImage skpk/qer/env/cs/sky_lake_night.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.983612 0.639368 0.393927 35 59 1 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 110 4
	nopicmip
	skyparms skpk/env/cs/sky_lake_night - -
}

textures/skies_MASTER4/sky_pink
{
	qer_editorImage skpk/qer/env/cs/sky_pink.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyparms skpk/env/cs/sky_pink - -
}

textures/skies_MASTER4/sky_venice
{
	qer_editorImage skpk/qer/env/cs/sky_venice.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 -39 50 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/cs/sky_venice - -
}

textures/skies_MASTER4/skybox01
{
	qer_editorImage skpk/qer/env/cs/skybox01.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 40 45 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/cs/skybox01 - -
}

textures/skies_MASTER4/skybox02
{
	qer_editorImage skpk/qer/env/cs/skybox02.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.988876 0.880232 0.488426 40 59 10 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 90 4
	nopicmip
	skyparms skpk/env/cs/skybox02 - -
}

textures/skies_MASTER4/skybox03
{
	qer_editorImage skpk/qer/env/cs/skybox03.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.988876 0.880232 0.488426 40 60 10 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 85 4
	nopicmip
	skyparms skpk/env/cs/skybox03 - -
}

textures/skies_MASTER4/skybox04
{
	qer_editorImage skpk/qer/env/cs/skybox04.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 60 60 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/cs/skybox04 - -
}

textures/skies_MASTER4/skybox05
{
	qer_editorImage skpk/qer/env/cs/skybox05.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 125 4
	nopicmip
	skyparms skpk/env/cs/skybox05 - -
}

textures/skies_MASTER4/skybox06
{
	qer_editorImage skpk/qer/env/cs/skybox06.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.988861 0.833097 0.488411 85 60 14 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/cs/skybox06 - -
}

textures/skies_MASTER4/skybox07
{
	qer_editorImage skpk/qer/env/cs/skybox07.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.988861 0.833097 0.488411 85 60 14 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/cs/skybox07 - -
}

textures/skies_MASTER4/skybox08
{
	qer_editorImage skpk/qer/env/cs/skybox08.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 62 60 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/cs/skybox08 - -
}

textures/skies_MASTER4/skybox09
{
	qer_editorImage skpk/qer/env/cs/skybox09.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyparms skpk/env/cs/skybox09 - -
}

textures/skies_MASTER4/skybox10
{
	qer_editorImage skpk/qer/env/cs/skybox10.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 60 24 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/cs/skybox10 - -
}

textures/skies_MASTER4/skybox11
{
	qer_editorImage skpk/qer/env/cs/skybox11.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 62 19 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/cs/skybox11 - -
}

textures/skies_MASTER4/skybox12
{
	qer_editorImage skpk/qer/env/cs/skybox12.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 40 60 19 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 100 4
	nopicmip
	skyparms skpk/env/cs/skybox12 - -
}

textures/skies_MASTER4/skybox13
{
	qer_editorImage skpk/qer/env/cs/skybox13.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 60 0 14 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 90 4
	nopicmip
	skyparms skpk/env/cs/skybox13 - -
}

textures/skies_MASTER4/skybox14
{
	qer_editorImage skpk/qer/env/cs/skybox14.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.96585 0.851728 0.368154 85 60 24 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/cs/skybox14 - -
}

textures/skies_MASTER4/skybox15
{
	qer_editorImage skpk/qer/env/cs/skybox15.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 59 24 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/cs/skybox15 - -
}

textures/skies_MASTER4/skybox16
{
	qer_editorImage skpk/qer/env/cs/skybox16.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 60 24 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/cs/skybox16 - -
}

textures/skies_MASTER4/skybox17
{
	qer_editorImage skpk/qer/env/cs/skybox17.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 60 25 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/cs/skybox17 - -
}

textures/skies_MASTER4/skybox18
{
	qer_editorImage skpk/qer/env/cs/skybox18.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 -59 25 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/cs/skybox18 - -
}

textures/skies_MASTER4/skybox19
{
	qer_editorImage skpk/qer/env/cs/skybox19.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 60 15 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/cs/skybox19 - -
}

textures/skies_MASTER4/skybox20
{
	qer_editorImage skpk/qer/env/cs/skybox20.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 -59 05 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/cs/skybox20 - -
}

textures/skies_MASTER4/sp_darkness
{
	qer_editorImage skpk/qer/env/cs/skybox_texture_pack/darkness.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 25 161 82 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms skpk/env/cs/skybox_texture_pack/darkness - -
}

textures/skies_MASTER4/sp_dusk2
{
	qer_editorImage skpk/qer/env/cs/skybox_texture_pack/dusk2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyparms skpk/env/cs/skybox_texture_pack/dusk2 - -
}

textures/skies_MASTER4/sp_dusk
{
	qer_editorImage skpk/qer/env/cs/skybox_texture_pack/dusk.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 60 177 36 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 85 4
	nopicmip
	skyparms skpk/env/cs/skybox_texture_pack/dusk - -
}

textures/skies_MASTER4/sp_islandsunset
{
	qer_editorImage skpk/qer/env/cs/skybox_texture_pack/islandsunset.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 -29 16 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/cs/skybox_texture_pack/islandsunset - -
}

textures/skies_MASTER4/sp_moonrock
{
	qer_editorImage skpk/qer/env/cs/skybox_texture_pack/moonrock.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 -26 28 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/cs/skybox_texture_pack/moonrock - -
}

textures/skies_MASTER4/sp_mountain2
{
	qer_editorImage skpk/qer/env/cs/skybox_texture_pack/mountain2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 152 75 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/cs/skybox_texture_pack/mountain2 - -
}

textures/skies_MASTER4/sp_mountain
{
	qer_editorImage skpk/qer/env/cs/skybox_texture_pack/mountain.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyparms skpk/env/cs/skybox_texture_pack/mountain - -
}

textures/skies_MASTER4/sp_nightlinecity
{
	qer_editorImage skpk/qer/env/cs/skybox_texture_pack/nightlinecity.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 140 4
	nopicmip
	skyparms skpk/env/cs/skybox_texture_pack/nightlinecity - -
}

textures/skies_MASTER4/sp_nynight
{
	qer_editorImage skpk/qer/env/cs/skybox_texture_pack/nynight.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 15 141 56 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 120 4
	nopicmip
	skyparms skpk/env/cs/skybox_texture_pack/nynight - -
}

textures/skies_MASTER4/sp01
{
	qer_editorImage skpk/qer/env/cs/skypack_v1/sky01.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 55 49 14 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 95 4
	nopicmip
	skyparms skpk/env/cs/skypack_v1/sky01 - -
}

textures/skies_MASTER4/sp02
{
	qer_editorImage skpk/qer/env/cs/skypack_v1/sky02.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 -56 26 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/cs/skypack_v1/sky02 - -
}

textures/skies_MASTER4/sp03
{
	qer_editorImage skpk/qer/env/cs/skypack_v1/sky03.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.952941 0.952941 0.72549 85 -28 70 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/cs/skypack_v1/sky03 - -
}

textures/skies_MASTER4/sp04
{
	qer_editorImage skpk/qer/env/cs/skypack_v1/sky04.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 -28 25 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/cs/skypack_v1/sky04 - -
}

textures/skies_MASTER4/sp05
{
	qer_editorImage skpk/qer/env/cs/skypack_v1/sky05.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 60 154 13 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 95 4
	nopicmip
	skyparms skpk/env/cs/skypack_v1/sky05 - -
}

textures/skies_MASTER4/sp06
{
	qer_editorImage skpk/qer/env/cs/skypack_v1/sky06.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.996078 0.752941 0.415686 85 0 6 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/cs/skypack_v1/sky06 - -
}

textures/skies_MASTER4/sp07
{
	qer_editorImage skpk/qer/env/cs/skypack_v1/sky07.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyparms skpk/env/cs/skypack_v1/sky07 - -
}

textures/skies_MASTER4/sp08
{
	qer_editorImage skpk/qer/env/cs/skypack_v1/sky08.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 150 4
	nopicmip
	skyparms skpk/env/cs/skypack_v1/sky08 - -
}

textures/skies_MASTER4/sp09
{
	qer_editorImage skpk/qer/env/cs/skypack_v1/sky09.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.965835 0.851713 0.368139 85 60 24 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/cs/skypack_v1/sky09 - -
}

textures/skies_MASTER4/sp10
{
	qer_editorImage skpk/qer/env/cs/skypack_v1/sky10.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 120 4
	nopicmip
	skyparms skpk/env/cs/skypack_v1/sky10 - -
}

textures/skies_MASTER4/sp11
{
	qer_editorImage skpk/qer/env/cs/skypack_v1/sky11.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 140 4
	nopicmip
	skyparms skpk/env/cs/skypack_v1/sky11 - -
}

textures/skies_MASTER4/sp12
{
	qer_editorImage skpk/qer/env/cs/skypack_v1/sky12.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 -127 25 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/cs/skypack_v1/sky12 - -
}

textures/skies_MASTER4/sp13
{
	qer_editorImage skpk/qer/env/cs/skypack_v1/sky13.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyparms skpk/env/cs/skypack_v1/sky13 - -
}

textures/skies_MASTER4/sp14
{
	qer_editorImage skpk/qer/env/cs/skypack_v1/sky14.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 0.526864 0.98613 25 60 25 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 110 4
	nopicmip
	skyparms skpk/env/cs/skypack_v1/sky14 - -
}

textures/skies_MASTER4/sp15
{
	qer_editorImage skpk/qer/env/cs/skypack_v1/sky15.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.941176 0.733333 0.670588 50 59 1 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 100 4
	nopicmip
	skyparms skpk/env/cs/skypack_v1/sky15 - -
}

textures/skies_MASTER4/sp16
{
	qer_editorImage skpk/qer/env/cs/skypack_v1/sky16.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 134 14 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/cs/skypack_v1/sky16 - -
}

textures/skies_MASTER4/smb_sky
{
	qer_editorImage skpk/qer/env/cs/smb_sky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 155 4
	nopicmip
	skyparms skpk/env/cs/smb_sky - -
}

textures/skies_MASTER4/spacey
{
	qer_editorImage skpk/qer/env/cs/spacey.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyparms skpk/env/cs/spacey - -
}

textures/skies_MASTER4/SpockFavelaD
{
	qer_editorImage skpk/qer/env/cs/SpockFavelaD.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 -88 60 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/cs/SpockFavelaD - -
}

textures/skies_MASTER4/SpockruaD
{
	qer_editorImage skpk/qer/env/cs/SpockruaD.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms skpk/env/cs/SpockruaD - -
}

textures/skies_MASTER4/spock_desert-overcast
{
	qer_editorImage skpk/qer/env/cs/spockskypack2_3/2desert.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 0 90 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/cs/spockskypack2_3/2desert - -
}

textures/skies_MASTER4/spock_city
{
	qer_editorImage skpk/qer/env/cs/spockskypack2_3/city.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyparms skpk/env/cs/spockskypack2_3/city - -
}

textures/skies_MASTER4/spock_Cliff
{
	qer_editorImage skpk/qer/env/cs/spockskypack2_3/Cliff.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 -178 60 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/cs/spockskypack2_3/Cliff - -
}

textures/skies_MASTER4/spock_desert
{
	qer_editorImage skpk/qer/env/cs/spockskypack2_3/desert.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 0 90 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/cs/spockskypack2_3/desert - -
}

textures/skies_MASTER4/spock_desert-dusk
{
	qer_editorImage skpk/qer/env/cs/spockskypack2_3/dusk.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 0.90634 0.526864 85 179 45 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/cs/spockskypack2_3/dusk - -
}

textures/skies_MASTER4/spock_desert-morning
{
	qer_editorImage skpk/qer/env/cs/spockskypack2_3/morning.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 -90 28 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/cs/spockskypack2_3/morning - -
}

textures/skies_MASTER4/spock_desert-night
{
	qer_editorImage skpk/qer/env/cs/spockskypack2_3/night.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 40 -45 75 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 110 4
	nopicmip
	skyparms skpk/env/cs/spockskypack2_3/night - -
}

textures/skies_MASTER4/stars
{
	qer_editorImage skpk/qer/env/cs/stars.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.027451 0.662745 0.913725 85 -87 0 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/cs/stars - -
}

textures/skies_MASTER4/summer_day1
{
	qer_editorImage skpk/qer/env/cs/summer_day1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 125 4
	nopicmip
	skyparms skpk/env/cs/summer_day1 - -
}

textures/skies_MASTER4/sunnight
{
	qer_editorImage skpk/qer/env/cs/sunnight.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 0.654398 0.221424 85 112 12 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 130 4
	nopicmip
	skyparms skpk/env/cs/sunnight - -
}

textures/skies_MASTER4/Suns
{
	qer_editorImage skpk/qer/env/cs/Suns.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 0.584039 0 85 -178 27 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/cs/Suns - -
}

textures/skies_MASTER4/ter_water_jfk
{
	qer_editorImage skpk/qer/env/cs/ter_water_jfk.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_sunExt 1 1 1 35 -53 14 2 16
	q3map_skylight 115 4
	nopicmip
	skyparms skpk/env/cs/ter_water_jfk - -
}

textures/skies_MASTER4/Tibet
{
	qer_editorImage skpk/qer/env/cs/Tibet.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 125 4
	nopicmip
	skyparms skpk/env/cs/Tibet - -
}

textures/skies_MASTER4/toon
{
	qer_editorImage skpk/qer/env/cs/toon.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 -140 74 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/cs/toon - -
}

textures/skies_MASTER4/furien_toxic
{
	qer_editorImage skpk/qer/env/cs/toxiczm.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 -117 65 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/cs/toxiczm - -
}

textures/skies_MASTER4/train
{
	qer_editorImage skpk/qer/env/cs/train.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 130 4
	nopicmip
	skyparms skpk/env/cs/train - -
}

textures/skies_MASTER/grnplsnt-saturated
{
	qer_editorImage skpk/qer/env/cs/ultimate_sky_pack/des_blue.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.976471 0.929412 0.694118 85 60 19 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/cs/ultimate_sky_pack/des_blue - -
}

textures/skies_MASTER4/u_des_cloudy
{
	qer_editorImage skpk/qer/env/cs/ultimate_sky_pack/des_cloudy.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 25 14 43 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 110 4
	nopicmip
	skyparms skpk/env/cs/ultimate_sky_pack/des_cloudy - -
}

textures/skies_MASTER4/u_des_desert
{
	qer_editorImage skpk/qer/env/cs/ultimate_sky_pack/des_desert.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 0.938766 0.638254 85 -144 35 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/cs/ultimate_sky_pack/des_desert - -
}

textures/skies_MASTER4/u_des_night
{
	qer_editorImage skpk/qer/env/cs/ultimate_sky_pack/des_night.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 40 156 82 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 100 4
	nopicmip
	skyparms skpk/env/cs/ultimate_sky_pack/des_night - -
}

textures/skies_MASTER4/u_trainyard
{
	qer_editorImage skpk/qer/env/cs/ultimate_sky_pack/trainyard.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 129 73 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 85 4
	nopicmip
	skyparms skpk/env/cs/ultimate_sky_pack/trainyard - -
}

textures/skies_MASTER4/vertigo
{
	qer_editorImage skpk/qer/env/cs/vertigo.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 55 -137 30 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 96 4
	nopicmip
	skyparms skpk/env/cs/vertigo - -
}

textures/skies_MASTER4/violet02
{
	qer_editorImage skpk/qer/env/cs/violet02.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 130 4
	nopicmip
	skyparms skpk/env/cs/violet02 - -
}

textures/skies_MASTER4/violet
{
	qer_editorImage skpk/qer/env/cs/violet.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 130 4
	nopicmip
	skyparms skpk/env/cs/violet - -
}

textures/skies_MASTER4/volare
{
	qer_editorImage skpk/qer/env/cs/volare.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 43 65 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/cs/volare - -
}

textures/skies_MASTER4/vp_club
{
	qer_editorImage skpk/qer/env/cs/vp_club.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 -120 24 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/cs/vp_club - -
}

textures/skies_MASTER4/vr_coopcloudy
{
	qer_editorImage skpk/qer/env/cs/vr_coopcloudy.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 140 4
	nopicmip
	skyparms skpk/env/cs/vr_coopcloudy - -
}

textures/skies_MASTER4/vr_coopsunset
{
	qer_editorImage skpk/qer/env/cs/vr_coopsunset.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.985336 0.912428 0.766598 45 -38 26 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 100 4
	nopicmip
	skyparms skpk/env/cs/vr_coopsunset - -
}

textures/skies_MASTER4/vr_skydaytudura
{
	qer_editorImage skpk/qer/env/cs/vr_skydaytudura.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.941314 0.960693 0.766873 60 -134 10 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 90 4
	nopicmip
	skyparms skpk/env/cs/vr_skydaytudura - -
}

textures/skies_MASTER4/vr_skynight00
{
	qer_editorImage skpk/qer/env/cs/vr_skynight00.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 140 4
	nopicmip
	skyparms skpk/env/cs/vr_skynight00 - -
}

textures/skies_MASTER4/vrb_camptriggerfish
{
	qer_editorImage skpk/qer/env/cs/vrb_camptriggerfish.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 140 4
	nopicmip
	skyparms skpk/env/cs/vrb_camptriggerfish - -
}

textures/skies_MASTER4/vrb_skydaytime00
{
	qer_editorImage skpk/qer/env/cs/vrb_skydaytime00.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 140 4
	nopicmip
	skyparms skpk/env/cs/vrb_skydaytime00 - -
}

textures/skies_MASTER4/winterskyday1
{
	qer_editorImage skpk/qer/env/cs/winterskyday1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 0.86334 0.638239 85 90 22 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/cs/winterskyday1 - -
}

textures/skies_MASTER4/winterskyday2
{
	qer_editorImage skpk/qer/env/cs/winterskyday2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 0.845167 0.471519 85 90 13 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/cs/winterskyday2 - -
}

textures/skies_MASTER4/winterskyday3
{
	qer_editorImage skpk/qer/env/cs/winterskyday3.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyparms skpk/env/cs/winterskyday3 - -
}

textures/skies_MASTER4/winterskyday
{
	qer_editorImage skpk/qer/env/cs/winterskyday.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 94 24 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/cs/winterskyday - -
}

textures/skies_MASTER4/x1u1
{
	qer_editorImage skpk/qer/env/cs/x1u1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 0.616632 0.471504 85 71 33 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/cs/x1u1 - -
}

textures/skies_MASTER4/xen1
{
	qer_editorImage skpk/qer/env/cs/xenskyfinal/bmxen1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.72549 0.941176 0.764706 40 -17 32 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 105 4
	nopicmip
	skyparms skpk/env/cs/xenskyfinal/bmxen1 - -
}

textures/skies_MASTER4/xen2
{
	qer_editorImage skpk/qer/env/cs/xenskyfinal/bmxen2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyparms skpk/env/cs/xenskyfinal/bmxen2 - -
}

textures/skies_MASTER4/xen3
{
	qer_editorImage skpk/qer/env/cs/xenskyfinal/bmxen3.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyparms skpk/env/cs/xenskyfinal/bmxen3 - -
}

textures/skies_MASTER4/xenend
{
	qer_editorImage skpk/qer/env/cs/xenskyfinal/xenend.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.745251 1 0.393118 85 170 23 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 80 4
	nopicmip
	skyparms skpk/env/cs/xenskyfinal/xenend - -
}

textures/skies_MASTER4/YellowSoft02
{
	qer_editorImage skpk/qer/env/cs/YellowSoft02.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 -145 33 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/cs/YellowSoft02 - -
}

textures/skies_MASTER4/zeleno
{
	qer_editorImage skpk/qer/env/cs/zeleno.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.955795 0.937118 0.51548 85 -92 19 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/cs/zeleno - -
}

textures/skies_MASTER4/zimskonebo2
{
	qer_editorImage skpk/qer/env/cs/zimskonebo2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 25 93 24 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 125 4
	nopicmip
	skyparms skpk/env/cs/zimskonebo2 - -
}

textures/skies_MASTER4/zimskonebo
{
	qer_editorImage skpk/qer/env/cs/zimskonebo.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 50 89 17 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 105 4
	nopicmip
	skyparms skpk/env/cs/zimskonebo - -
}

textures/skies_MASTER4/zolsky06
{
	qer_editorImage skpk/qer/env/cs/zolsky06.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 25 60 25 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 110 4
	nopicmip
	skyparms skpk/env/cs/zolsky06 - -
}

textures/skies_MASTER4/zolsky07
{
	qer_editorImage skpk/qer/env/cs/zolsky07.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyparms skpk/env/cs/zolsky07 - -
}

textures/skies_MASTER/hip_inter-blue
{
	qer_editorImage skpk/qer/env/cs/Gora.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 80 340 49 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/cs/Gora - -
}

textures/skies_MASTER/hip_inter-rust
{
	qer_editorImage skpk/qer/env/sky_is_rusk/is_rusk.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 80 340 49 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/sky_is_rusk/is_rusk - -
}

textures/skies_MASTER/hip_inter-sepia
{
	qer_editorImage skpk/qer/env/mp_sdfsky/sdfsky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 80 340 49 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/mp_sdfsky/sdfsky - -
}

textures/skies_MASTER5/cloudy_day
{
	qer_editorImage skpk/qer/env/banana/163.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 30 171 42 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 110 4
	nopicmip
	skyparms skpk/env/banana/163 - -
}

textures/skies_MASTER5/sunseting
{
	qer_editorImage skpk/qer/env/banana/170.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 0.781415 0.583978 25 137 2 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms skpk/env/banana/170 - -
}

textures/skies_MASTER5/sunrising
{
	qer_editorImage skpk/qer/env/banana/172.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 0.859373 0.583978 35 -8 9 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 105 4
	nopicmip
	skyparms skpk/env/banana/172 - -
}

textures/skies_MASTER5/sunrise_field
{
	qer_editorImage skpk/qer/env/banana/174.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.981308 0.862882 0.420554 40 115 4 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 90 4
	nopicmip
	skyparms skpk/env/banana/174 - -
}

textures/skies_MASTER5/cloudy_field
{
	qer_editorImage skpk/qer/env/banana/175.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 35 -89 24 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 100 4
	nopicmip
	skyparms skpk/env/banana/175 - -
}

textures/skies_MASTER5/sunset_field
{
	qer_editorImage skpk/qer/env/banana/177.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 130 4
	nopicmip
	skyparms skpk/env/banana/177 - -
}

textures/skies_MASTER5/sunny_field
{
	qer_editorImage skpk/qer/env/banana/179.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 83 40 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/banana/179 - -
}

textures/skies_MASTER5/cloudy_field2
{
	qer_editorImage skpk/qer/env/banana/180.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 130 4
	nopicmip
	skyparms skpk/env/banana/180 - -
}

textures/skies_MASTER5/amethyst
{
	qer_editorImage skpk/qer/env/banana/amethyst.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.974334 0.964096 0.544244 85 102 13 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/banana/amethyst - -
}

textures/skies_MASTER5/auroraborealis
{
	qer_editorImage skpk/qer/env/banana/auroraborealis.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 145 4
	nopicmip
	skyparms skpk/env/banana/auroraborealis - -
}

textures/skies_MASTER5/aurorasky
{
	qer_editorImage skpk/qer/env/banana/aurorasky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 145 4
	nopicmip
	skyparms skpk/env/banana/aurorasky - -
}

textures/skies_MASTER5/foggy_blue
{
	qer_editorImage skpk/qer/env/banana/bhop_otter-1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 150 4
	nopicmip
	skyparms skpk/env/banana/bhop_otter-1 - -
}

textures/skies_MASTER5/blackplanet
{
	qer_editorImage skpk/qer/env/banana/blackplanet.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 150 4
	nopicmip
	skyparms skpk/env/banana/blackplanet - -
}

textures/skies_MASTER5/blizzard
{
	qer_editorImage skpk/qer/env/banana/blizzard.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_lightRGB 0.47451 0.611765 0.67451
	q3map_skylight 120 4 0 90 0
	nopicmip
	skyparms skpk/env/banana/blizzard - -
}

textures/skies_MASTER5/blueplanet
{
	qer_editorImage skpk/qer/env/banana/blueplanet.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 140 4
	nopicmip
	skyparms skpk/env/banana/blueplanet - -
}

textures/skies_MASTER5/Bluesky2
{
	qer_editorImage skpk/qer/env/banana/Bluesky2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 53 79 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/banana/Bluesky2 - -
}

textures/skies_MASTER5/bluesky
{
	qer_editorImage skpk/qer/env/banana/bluesky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 148 24 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/banana/bluesky - -
}

textures/skies_MASTER5/brightday
{
	qer_editorImage skpk/qer/env/banana/brightday.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 -142 80 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/banana/brightday - -
}

textures/skies_MASTER5/Castle
{
	qer_editorImage skpk/qer/env/banana/Castle.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyparms skpk/env/banana/Castle - -
}

textures/skies_MASTER5/champagne
{
	qer_editorImage skpk/qer/env/banana/champagne.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyparms skpk/env/banana/champagne - -
}

textures/skies_MASTER5/Chop_housesky_night
{
	qer_editorImage skpk/qer/env/banana/Chopsskybaxes/housesky_night.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 145 4
	nopicmip
	skyparms skpk/env/banana/Chopsskybaxes/housesky_night - -
}

textures/skies_MASTER5/Chop_osk_arctic02
{
	qer_editorImage skpk/qer/env/banana/Chopsskybaxes/osk_arctic02.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 140 4
	nopicmip
	skyparms skpk/env/banana/Chopsskybaxes/osk_arctic02 - -
}

textures/skies_MASTER5/Chop_osk_nighttime01
{
	qer_editorImage skpk/qer/env/banana/Chopsskybaxes/osk_nighttime01.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_lightRGB 1 1 1
	q3map_skylight 125 4 0 90 0
	nopicmip
	skyparms skpk/env/banana/Chopsskybaxes/osk_nighttime01 - -
}

textures/skies_MASTER5/Chop_airy01
{
	qer_editorImage skpk/qer/env/banana/Chopsskybaxes/sky_airy01.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 140 4
	nopicmip
	skyparms skpk/env/banana/Chopsskybaxes/sky_airy01 - -
}

textures/skies_MASTER5/Chop_alto01
{
	qer_editorImage skpk/qer/env/banana/Chopsskybaxes/sky_alto01.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 35 159 17 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 110 4
	nopicmip
	skyparms skpk/env/banana/Chopsskybaxes/sky_alto01 - -
}

textures/skies_MASTER5/Chop_blueday01
{
	qer_editorImage skpk/qer/env/banana/Chopsskybaxes/sky_blueday01.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 125 4
	nopicmip
	skyparms skpk/env/banana/Chopsskybaxes/sky_blueday01 - -
}

textures/skies_MASTER5/Chop_buye
{
	qer_editorImage skpk/qer/env/banana/Chopsskybaxes/sky_buye.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.974319 0.896803 0.544244 85 165 4 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/banana/Chopsskybaxes/sky_buye - -
}

textures/skies_MASTER5/Chop_castover01
{
	qer_editorImage skpk/qer/env/banana/Chopsskybaxes/sky_castover01.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 50 -28 42 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 105 4
	nopicmip
	skyparms skpk/env/banana/Chopsskybaxes/sky_castover01 - -
}

textures/skies_MASTER5/Chop_citynight01
{
	qer_editorImage skpk/qer/env/banana/Chopsskybaxes/sky_citynight01.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 40 74 35 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 110 4
	nopicmip
	skyparms skpk/env/banana/Chopsskybaxes/sky_citynight01 - -
}

textures/skies_MASTER5/Chop_darkdays01
{
	qer_editorImage skpk/qer/env/banana/Chopsskybaxes/sky_darkdays01.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 130 4
	nopicmip
	skyparms skpk/env/banana/Chopsskybaxes/sky_darkdays01 - -
}

textures/skies_MASTER5/Chop_dejablue01
{
	qer_editorImage skpk/qer/env/banana/Chopsskybaxes/sky_dejablue01.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyparms skpk/env/banana/Chopsskybaxes/sky_dejablue01 - -
}

textures/skies_MASTER5/Chop_dust01
{
	qer_editorImage skpk/qer/env/banana/Chopsskybaxes/sky_dust01.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 50 178 8 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 105 4
	nopicmip
	skyparms skpk/env/banana/Chopsskybaxes/sky_dust01 - -
}

textures/skies_MASTER5/Chop_gm_blue01
{
	qer_editorImage skpk/qer/env/banana/Chopsskybaxes/sky_gm_blue01.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 145 4
	nopicmip
	skyparms skpk/env/banana/Chopsskybaxes/sky_gm_blue01 - -
}

textures/skies_MASTER5/Chop_gm_sunset01
{
	qer_editorImage skpk/qer/env/banana/Chopsskybaxes/sky_gm_sunset01.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 150 4
	nopicmip
	skyparms skpk/env/banana/Chopsskybaxes/sky_gm_sunset01 - -
}

textures/skies_MASTER5/Chop_halo01
{
	qer_editorImage skpk/qer/env/banana/Chopsskybaxes/sky_halo01.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 145 4
	nopicmip
	skyparms skpk/env/banana/Chopsskybaxes/sky_halo01 - -
}

//clear sky
textures/skies_MASTER5/Chop_invest01
{
	qer_editorImage skpk/qer/env/banana/Chopsskybaxes/sky_invest01.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 140 4
	nopicmip
	skyparms skpk/env/banana/Chopsskybaxes/sky_invest01 - -
}

textures/skies_MASTER5/Chop_invest03
{
	qer_editorImage skpk/qer/env/banana/Chopsskybaxes/sky_invest03.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyparms skpk/env/banana/Chopsskybaxes/sky_invest03 - -
}

textures/skies_MASTER5/Chop_lazyday01
{
	qer_editorImage skpk/qer/env/banana/Chopsskybaxes/sky_lazyday01.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 45 44 17 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 110 4
	nopicmip
	skyparms skpk/env/banana/Chopsskybaxes/sky_lazyday01 - -
}

textures/skies_MASTER5/Chop_main01
{
	qer_editorImage skpk/qer/env/banana/Chopsskybaxes/sky_main01.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyparms skpk/env/banana/Chopsskybaxes/sky_main01 - -
}

textures/skies_MASTER5/Chop_midthunderstorm01
{
	qer_editorImage skpk/qer/env/banana/Chopsskybaxes/sky_midthunderstorm01.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 145 4
	nopicmip
	skyparms skpk/env/banana/Chopsskybaxes/sky_midthunderstorm01 - -
}

textures/skies_MASTER5/Chop_moodyday01
{
	qer_editorImage skpk/qer/env/banana/Chopsskybaxes/sky_moodyday01.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyparms skpk/env/banana/Chopsskybaxes/sky_moodyday01 - -
}

textures/skies_MASTER5/Chop_nightmare01
{
	qer_editorImage skpk/qer/env/banana/Chopsskybaxes/sky_nightmare01.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.975738 0.883131 0.64976 40 -20 30 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 105 4
	nopicmip
	skyparms skpk/env/banana/Chopsskybaxes/sky_nightmare01 - -
}

textures/skies_MASTER5/Chop_nighttime01
{
	qer_editorImage skpk/qer/env/banana/Chopsskybaxes/sky_nighttime01.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 140 4
	nopicmip
	skyparms skpk/env/banana/Chopsskybaxes/sky_nighttime01 - -
}

textures/skies_MASTER5/Chop_overcast01-2
{
	qer_editorImage skpk/qer/env/banana/Chopsskybaxes/sky_overcast01-2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 155 4
	nopicmip
	skyparms skpk/env/banana/Chopsskybaxes/sky_overcast01-2 - -
}

textures/skies_MASTER5/Chop_overcast01
{
	qer_editorImage skpk/qer/env/banana/Chopsskybaxes/sky_overcast01.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 155 4
	nopicmip
	skyparms skpk/env/banana/Chopsskybaxes/sky_overcast01 - -
}

textures/skies_MASTER5/Chop_reddusk01
{
	qer_editorImage skpk/qer/env/banana/Chopsskybaxes/sky_reddusk01.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 25 -9 6 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 130 4
	nopicmip
	skyparms skpk/env/banana/Chopsskybaxes/sky_reddusk01 - -
}

textures/skies_MASTER5/Chop_smnight01
{
	qer_editorImage skpk/qer/env/banana/Chopsskybaxes/sky_smnight01.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyparms skpk/env/banana/Chopsskybaxes/sky_smnight01 - -
}

textures/skies_MASTER5/Chop_snowyday01
{
	qer_editorImage skpk/qer/env/banana/Chopsskybaxes/sky_snowyday01.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 130 4
	nopicmip
	skyparms skpk/env/banana/Chopsskybaxes/sky_snowyday01 - -
}

textures/skies_MASTER5/Chop_solemn
{
	qer_editorImage skpk/qer/env/banana/Chopsskybaxes/sky_solemn.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 60 -23 51 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 95 4
	nopicmip
	skyparms skpk/env/banana/Chopsskybaxes/sky_solemn - -
}

textures/skies_MASTER5/Chop_storm01
{
	qer_editorImage skpk/qer/env/banana/Chopsskybaxes/sky_storm01.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 145 4
	nopicmip
	skyparms skpk/env/banana/Chopsskybaxes/sky_storm01 - -
}

textures/skies_MASTER5/Chop_sunset01
{
	qer_editorImage skpk/qer/env/banana/Chopsskybaxes/sky_sunset01.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.975723 0.846067 0.64976 20 177 6 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyparms skpk/env/banana/Chopsskybaxes/sky_sunset01 - -
}

textures/skies_MASTER5/Chop_sunset02
{
	qer_editorImage skpk/qer/env/banana/Chopsskybaxes/sky_sunset02.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.988434 0.814557 0.551308 25 5 2 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/banana/Chopsskybaxes/sky_sunset02 - -
}

textures/skies_MASTER5/Chop_sunsetshock01
{
	qer_editorImage skpk/qer/env/banana/Chopsskybaxes/sky_sunsetshock01.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.983536 0.796109 0.419181 25 60 0 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/banana/Chopsskybaxes/sky_sunsetshock01 - -
}

textures/skies_MASTER5/Chop_torn
{
	qer_editorImage skpk/qer/env/banana/Chopsskybaxes/sky_torn.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 145 4
	nopicmip
	skyparms skpk/env/banana/Chopsskybaxes/sky_torn - -
}

textures/skies_MASTER5/Chop_tornado01
{
	qer_editorImage skpk/qer/env/banana/Chopsskybaxes/sky_tornado01.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 145 4
	nopicmip
	skyparms skpk/env/banana/Chopsskybaxes/sky_tornado01 - -
}

textures/skies_MASTER5/cleansky
{
	qer_editorImage skpk/qer/env/banana/cleansky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 -24 30 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/banana/cleansky - -
}

textures/skies_MASTER5/cloudy90
{
	qer_editorImage skpk/qer/env/banana/cloudy90.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 145 4
	nopicmip
	skyparms skpk/env/banana/cloudy90 - -
}

textures/skies_MASTER5/cloudy
{
	qer_editorImage skpk/qer/env/banana/cloudy.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 145 4
	nopicmip
	skyparms skpk/env/banana/cloudy - -
}

textures/skies_MASTER5/crisp
{
	qer_editorImage skpk/qer/env/banana/crisp.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 60 118 39 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 95 4
	nopicmip
	skyparms skpk/env/banana/crisp - -
}

textures/skies_MASTER5/cruel_night_ovl_hq
{
	qer_editorImage skpk/qer/env/banana/cruel_night_ovl_hq.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 35 -19 26 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 100 4
	nopicmip
	skyparms skpk/env/banana/cruel_night_ovl_hq - -
}

textures/skies_MASTER5/cstrike_sky01
{
	qer_editorImage skpk/qer/env/banana/cstrike/sky01.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 130 4
	nopicmip
	skyparms skpk/env/banana/cstrike/sky01 - -
}

textures/skies_MASTER5/cstrike_sky02
{
	qer_editorImage skpk/qer/env/banana/cstrike/sky02.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 35 -15 25 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 105 4
	nopicmip
	skyparms skpk/env/banana/cstrike/sky02 - -
}

textures/skies_MASTER5/cstrike_sky03
{
	qer_editorImage skpk/qer/env/banana/cstrike/sky03.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 -9 11 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/banana/cstrike/sky03 - -
}

textures/skies_MASTER5/cstrike_sky04
{
	qer_editorImage skpk/qer/env/banana/cstrike/sky04.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 130 4
	nopicmip
	skyparms skpk/env/banana/cstrike/sky04 - -
}

textures/skies_MASTER5/cstrike_sky05
{
	qer_editorImage skpk/qer/env/banana/cstrike/sky05.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 -89 12 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/banana/cstrike/sky05 - -
}

textures/skies_MASTER5/cstrike_sky06
{
	qer_editorImage skpk/qer/env/banana/cstrike/sky06.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 60 -115 30 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/banana/cstrike/sky06 - -
}

textures/skies_MASTER5/cstrike_sky07
{
	qer_editorImage skpk/qer/env/banana/cstrike/sky07.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 130 4
	nopicmip
	skyparms skpk/env/banana/cstrike/sky07 - -
}

textures/skies_MASTER5/cstrike_sky08
{
	qer_editorImage skpk/qer/env/banana/cstrike/sky08.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyparms skpk/env/banana/cstrike/sky08 - -
}

textures/skies_MASTER5/cstrike_sky09
{
	qer_editorImage skpk/qer/env/banana/cstrike/sky09.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 -104 38 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/banana/cstrike/sky09 - -
}

textures/skies_MASTER5/cstrike_sky10
{
	qer_editorImage skpk/qer/env/banana/cstrike/sky10.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 125 4
	nopicmip
	skyparms skpk/env/banana/cstrike/sky10 - -
}

textures/skies_MASTER5/cstrike_sky11
{
	qer_editorImage skpk/qer/env/banana/cstrike/sky11.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 55 113 15 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 100 4
	nopicmip
	skyparms skpk/env/banana/cstrike/sky11 - -
}

textures/skies_MASTER5/cstrike_sky12
{
	qer_editorImage skpk/qer/env/banana/cstrike/sky12.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyparms skpk/env/banana/cstrike/sky12 - -
}

textures/skies_MASTER5/cstrike_sky13
{
	qer_editorImage skpk/qer/env/banana/cstrike/sky13.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyparms skpk/env/banana/cstrike/sky13 - -
}

textures/skies_MASTER5/cstrike_sky14
{
	qer_editorImage skpk/qer/env/banana/cstrike/sky14.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 130 4
	nopicmip
	skyparms skpk/env/banana/cstrike/sky14 - -
}

textures/skies_MASTER5/cstrike_sky15
{
	qer_editorImage skpk/qer/env/banana/cstrike/sky15.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 125 4
	nopicmip
	skyparms skpk/env/banana/cstrike/sky15 - -
}

textures/skies_MASTER5/cstrike_sky16
{
	qer_editorImage skpk/qer/env/banana/cstrike/sky16.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.99028 0.897841 0.59292 85 -13 13 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/banana/cstrike/sky16 - -
}

textures/skies_MASTER5/cstrike_sky17
{
	qer_editorImage skpk/qer/env/banana/cstrike/sky17.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.969665 0.771405 0.315343 85 -89 6 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 85 4
	nopicmip
	skyparms skpk/env/banana/cstrike/sky17 - -
}

textures/skies_MASTER5/cstrike_sky18
{
	qer_editorImage skpk/qer/env/banana/cstrike/sky18.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 0.865095 0.554742 50 0 3.5 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 90 4
	nopicmip
	skyparms skpk/env/banana/cstrike/sky18 - -
}

textures/skies_MASTER5/cstrike_sky19
{
	qer_editorImage skpk/qer/env/banana/cstrike/sky19.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.968627 0.643137 0.427451 40 -105 4 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms skpk/env/banana/cstrike/sky19 - -
}

textures/skies_MASTER5/cstrike_sky20
{
	qer_editorImage skpk/qer/env/banana/cstrike/sky20.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 25 7 23 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 105 4
	nopicmip
	skyparms skpk/env/banana/cstrike/sky20 - -
}

textures/skies_MASTER5/cstrike_sky21
{
	qer_editorImage skpk/qer/env/banana/cstrike/sky21.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyparms skpk/env/banana/cstrike/sky21 - -
}

textures/skies_MASTER5/cstrike_sky22
{
	qer_editorImage skpk/qer/env/banana/cstrike/sky22.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 0.765057 0.35465 25 -104 3 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 95 4
	nopicmip
	skyparms skpk/env/banana/cstrike/sky22 - -
}

textures/skies_MASTER5/cstrike_sky23
{
	qer_editorImage skpk/qer/env/banana/cstrike/sky23.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 55 -107 18 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 100 4
	nopicmip
	skyparms skpk/env/banana/cstrike/sky23 - -
}

textures/skies_MASTER5/cstrike_sky24
{
	qer_editorImage skpk/qer/env/banana/cstrike/sky24.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 25 103 8 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms skpk/env/banana/cstrike/sky24 - -
}

textures/skies_MASTER5/cstrike_sky25
{
	qer_editorImage skpk/qer/env/banana/cstrike/sky25.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 50 -103 14 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 95 4
	nopicmip
	skyparms skpk/env/banana/cstrike/sky25 - -
}

textures/skies_MASTER5/cstrike_sky26
{
	qer_editorImage skpk/qer/env/banana/cstrike/sky26.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 45 62 28 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 100 4
	nopicmip
	skyparms skpk/env/banana/cstrike/sky26 - -
}

textures/skies_MASTER5/cstrike_sky27
{
	qer_editorImage skpk/qer/env/banana/cstrike/sky27.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 69 24 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/banana/cstrike/sky27 - -
}

textures/skies_MASTER5/cstrike_sky28
{
	qer_editorImage skpk/qer/env/banana/cstrike/sky28.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 -103 32 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/banana/cstrike/sky28 - -
}

textures/skies_MASTER5/cstrike_sky29
{
	qer_editorImage skpk/qer/env/banana/cstrike/sky29.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyparms skpk/env/banana/cstrike/sky29 - -
}

textures/skies_MASTER5/cstrike_sky30
{
	qer_editorImage skpk/qer/env/banana/cstrike/sky30.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 -57 42 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/banana/cstrike/sky30 - -
}

textures/skies_MASTER5/cstrike_sky31
{
	qer_editorImage skpk/qer/env/banana/cstrike/sky31.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 65 -48 9 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 80 4
	nopicmip
	skyparms skpk/env/banana/cstrike/sky31 - -
}

textures/skies_MASTER5/cstrike_sky32
{
	qer_editorImage skpk/qer/env/banana/cstrike/sky32.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyparms skpk/env/banana/cstrike/sky32 - -
}

textures/skies_MASTER5/cstrike_sky33
{
	qer_editorImage skpk/qer/env/banana/cstrike/sky33.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 -79 23 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/banana/cstrike/sky33 - -
}

textures/skies_MASTER5/cstrike_sky34
{
	qer_editorImage skpk/qer/env/banana/cstrike/sky34.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 28 39 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/banana/cstrike/sky34 - -
}

textures/skies_MASTER5/cstrike_sky35
{
	qer_editorImage skpk/qer/env/banana/cstrike/sky35.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 -103 23 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/banana/cstrike/sky35 - -
}

textures/skies_MASTER5/cstrike_sky36
{
	qer_editorImage skpk/qer/env/banana/cstrike/sky36.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 70 85 34 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 80 4
	nopicmip
	skyparms skpk/env/banana/cstrike/sky36 - -
}

textures/skies_MASTER5/cstrike_sky37
{
	qer_editorImage skpk/qer/env/banana/cstrike/sky37.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 140 4
	nopicmip
	skyparms skpk/env/banana/cstrike/sky37 - -
}

textures/skies_MASTER5/cstrike_sky38
{
	qer_editorImage skpk/qer/env/banana/cstrike/sky38.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.98027 0.867414 0.670817 25 -103 6 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms skpk/env/banana/cstrike/sky38 - -
}

textures/skies_MASTER5/cstrike_sky39
{
	qer_editorImage skpk/qer/env/banana/cstrike/sky39.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 25 -104 9 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 125 4
	nopicmip
	skyparms skpk/env/banana/cstrike/sky39 - -
}

textures/skies_MASTER5/cstrike_sky40
{
	qer_editorImage skpk/qer/env/banana/cstrike/sky40.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 145 4
	nopicmip
	skyparms skpk/env/banana/cstrike/sky40 - -
}

textures/skies_MASTER5/cstrike_sky41
{
	qer_editorImage skpk/qer/env/banana/cstrike/sky41.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.980255 0.951354 0.670802 30 -26 2 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/banana/cstrike/sky41 - -
}

textures/skies_MASTER5/cstrike_sky42
{
	qer_editorImage skpk/qer/env/banana/cstrike/sky42.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 -104 43 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/banana/cstrike/sky42 - -
}

textures/skies_MASTER5/cstrike_sky43
{
	qer_editorImage skpk/qer/env/banana/cstrike/sky43.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 0.683146 0.44303 35 -104 5 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/banana/cstrike/sky43 - -
}

textures/skies_MASTER5/cstrike_sky44
{
	qer_editorImage skpk/qer/env/banana/cstrike/sky44.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 20 -104 21 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyparms skpk/env/banana/cstrike/sky44 - -
}

textures/skies_MASTER5/cstrike_sky45
{
	qer_editorImage skpk/qer/env/banana/cstrike/sky45.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 140 4
	nopicmip
	skyparms skpk/env/banana/cstrike/sky45 - -
}

textures/skies_MASTER5/cstrike_sky46
{
	qer_editorImage skpk/qer/env/banana/cstrike/sky46.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.952911 0.623026 0.373053 30 -103 5 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/banana/cstrike/sky46 - -
}

textures/skies_MASTER5/cstrike_sky47
{
	qer_editorImage skpk/qer/env/banana/cstrike/sky47.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 0.71487 0.498802 85 3 7 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/banana/cstrike/sky47 - -
}

textures/skies_MASTER5/cstrike_sky48
{
	qer_editorImage skpk/qer/env/banana/cstrike/sky48.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 40 -24 8 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 90 4
	nopicmip
	skyparms skpk/env/banana/cstrike/sky48 - -
}

textures/skies_MASTER5/cstrike_sky49
{
	qer_editorImage skpk/qer/env/banana/cstrike/sky49.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 70 69 16 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 90 4
	nopicmip
	skyparms skpk/env/banana/cstrike/sky49 - -
}

textures/skies_MASTER5/cstrike_sky50
{
	qer_editorImage skpk/qer/env/banana/cstrike/sky50.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 80 -14 19 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 80 4
	nopicmip
	skyparms skpk/env/banana/cstrike/sky50 - -
}

textures/skies_MASTER5/cstrike_sky51
{
	qer_editorImage skpk/qer/env/banana/cstrike/sky51.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyparms skpk/env/banana/cstrike/sky51 - -
}

textures/skies_MASTER5/cstrike_sky55
{
	qer_editorImage skpk/qer/env/banana/cstrike/sky55.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.997757 0.942885 0.720592 60 -27 4 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 95 4
	nopicmip
	skyparms skpk/env/banana/cstrike/sky55 - -
}

textures/skies_MASTER5/cstrike_sky56
{
	qer_editorImage skpk/qer/env/banana/cstrike/sky56.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.968627 0.886275 0.560784 40 -11 1 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 120 4
	nopicmip
	skyparms skpk/env/banana/cstrike/sky56 - -
}

textures/skies_MASTER2/Darktoon
{
	qer_editorImage skpk/qer/env/banana/Darktoon.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 162 16 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/banana/Darktoon - -
}

textures/skies_MASTER5/Desert_Canyon
{
	qer_editorImage skpk/qer/env/banana/Desert_Canyon.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 -100 31 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/banana/Desert_Canyon - -
}

textures/skies_MASTER5/desert2
{
	qer_editorImage skpk/qer/env/banana/desert.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 44 29 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/banana/desert - -
}

textures/skies_MASTER5/doom
{
	qer_editorImage skpk/qer/env/banana/doom.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.766903 0.962783 0.309972 25 161 12 2 16  //green
	q3map_sunExt 1 0.579355 0.89163 60 1 46 2 16            //pink
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 100 4
	nopicmip
	skyparms skpk/env/banana/doom - -
}

textures/skies_MASTER5/dreams
{
	qer_editorImage skpk/qer/env/banana/dreams.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 80 60 23 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 75 4
	nopicmip
	skyparms skpk/env/banana/dreams - -
}

textures/skies_MASTER5/Dreamworld
{
	qer_editorImage skpk/qer/env/banana/Dreamworld.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 20 -123 24 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms skpk/env/banana/Dreamworld - -
}

textures/skies_MASTER5/DreamworldNight
{
	qer_editorImage skpk/qer/env/banana/DreamworldNight.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 145 4
	nopicmip
	skyparms skpk/env/banana/DreamworldNight - -
}

textures/skies_MASTER5/dreamyOcean
{
	qer_editorImage skpk/qer/env/banana/dreamyOcean.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 80 110 68 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/banana/dreamyOcean - -
}

textures/skies_MASTER5/dry
{
	qer_editorImage skpk/qer/env/banana/dry.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 150 28 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/banana/dry - -
}

textures/skies_MASTER5/dusk
{
	qer_editorImage skpk/qer/env/banana/dusk.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.964706 0.815686 0.47451 25 -40 5 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 125 4
	nopicmip
	skyparms skpk/env/banana/dusk - -
}

textures/skies_MASTER5/earth2
{
	qer_editorImage skpk/qer/env/banana/earth.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 60 129 11 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 80 4
	nopicmip
	skyparms skpk/env/banana/earth - -
}

textures/skies_MASTER5/eve1
{
	qer_editorImage skpk/qer/env/banana/eve1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 0.895094 0.67364 40 -91 22 2 16          //bottom
	q3map_sunExt 1 0.895094 0.67364 45 -81 72 2 16          //top
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/banana/eve1 - -
}

textures/skies_MASTER5/eve2
{
	qer_editorImage skpk/qer/env/banana/eve2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 140 4
	nopicmip
	skyparms skpk/env/banana/eve2 - -
}

textures/skies_MASTER5/eve3
{
	qer_editorImage skpk/qer/env/banana/eve3.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 0.808057 0.363943 55 -177 9 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 100 4
	nopicmip
	skyparms skpk/env/banana/eve3 - -
}

textures/skies_MASTER5/eve4
{
	qer_editorImage skpk/qer/env/banana/eve4.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 0.808057 0.363943 50 -153 11 2 16                //red nebula
	q3map_sunExt 0.729244 0.978744 1 45 -153 11 2 16                //blue nebula
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 90 4
	nopicmip
	skyparms skpk/env/banana/eve4 - -
}

textures/skies_MASTER5/eve5
{
	qer_editorImage skpk/qer/env/banana/eve5.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 0.921721 0.61207 60 -137 66 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 100 4
	nopicmip
	skyparms skpk/env/banana/eve5 - -
}

textures/skies_MASTER5/eve6
{
	qer_editorImage skpk/qer/env/banana/eve6.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 0.921721 0.61207 60 0 90 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 100 4
	nopicmip
	skyparms skpk/env/banana/eve6 - -
}

textures/skies_MASTER5/eve7
{
	qer_editorImage skpk/qer/env/banana/eve7.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.579293 0.989319 0.755184 70 15 8 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 95 4
	nopicmip
	skyparms skpk/env/banana/eve7 - -
}

textures/skies_MASTER5/eve8
{
	qer_editorImage skpk/qer/env/banana/eve8.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 130 4
	nopicmip
	skyparms skpk/env/banana/eve8 - -
}

textures/skies_MASTER5/extremehires07
{
	qer_editorImage skpk/qer/env/banana/extremehires07.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 90 20 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/banana/extremehires07 - -
}

textures/skies_MASTER5/extremehires08
{
	qer_editorImage skpk/qer/env/banana/extremehires08.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 130 4
	nopicmip
	skyparms skpk/env/banana/extremehires08 - -
}

textures/skies_MASTER5/extremehires09
{
	qer_editorImage skpk/qer/env/banana/extremehires09.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.978698 0.961883 0.781216 60 57 8 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 85 4
	nopicmip
	skyparms skpk/env/banana/extremehires09 - -
}

textures/skies_MASTER5/flm02
{
	qer_editorImage skpk/qer/env/banana/flm02.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 0 90 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/banana/flm02 - -
}

textures/skies_MASTER5/flowsky03
{
	qer_editorImage skpk/qer/env/banana/flowsky03.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 35 0 37 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 110 4
	nopicmip
	skyparms skpk/env/banana/flowsky03 - -
}

textures/skies_MASTER5/flowsky04
{
	qer_editorImage skpk/qer/env/banana/flowsky04.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 55 63 46 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 100 4
	nopicmip
	skyparms skpk/env/banana/flowsky04 - -
}

textures/skies_MASTER5/flowsky06
{
	qer_editorImage skpk/qer/env/banana/flowsky06.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 60 44 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/banana/flowsky06 - -
}

textures/skies_MASTER5/flowsky07
{
	qer_editorImage skpk/qer/env/banana/flowsky07.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.972549 0.866667 0.47451 70 0 6 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 100 4
	nopicmip
	skyparms skpk/env/banana/flowsky07 - -
}

textures/skies_MASTER5/flowsky08
{
	qer_editorImage skpk/qer/env/banana/flowsky08.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 0.684306 0.396582 85 60 44 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/banana/flowsky08 - -
}

textures/skies_MASTER5/flowsky09
{
	qer_editorImage skpk/qer/env/banana/flowsky09.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 133 49 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/banana/flowsky09 - -
}

textures/skies_MASTER5/flowsky10
{
	qer_editorImage skpk/qer/env/banana/flowsky10.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 82 23 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/banana/flowsky10 - -
}

textures/skies_MASTER5/flowsky11
{
	qer_editorImage skpk/qer/env/banana/flowsky11.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 40 60 63 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms skpk/env/banana/flowsky11 - -
}

textures/skies_MASTER5/flowsky12
{
	qer_editorImage skpk/qer/env/banana/flowsky12.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 50 36 25 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 105 4
	nopicmip
	skyparms skpk/env/banana/flowsky12 - -
}

textures/skies_MASTER5/flowsky13
{
	qer_editorImage skpk/qer/env/banana/flowsky13.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 4 31 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/banana/flowsky13 - -
}

textures/skies_MASTER5/flowsky14
{
	qer_editorImage skpk/qer/env/banana/flowsky14.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 130 4
	nopicmip
	skyparms skpk/env/banana/flowsky14 - -
}

textures/skies_MASTER5/flowsky15
{
	qer_editorImage skpk/qer/env/banana/flowsky15.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 70 -7 68 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 85 4
	nopicmip
	skyparms skpk/env/banana/flowsky15 - -
}

textures/skies_MASTER5/foggy
{
	qer_editorImage skpk/qer/env/banana/foggy.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 65 150 45 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 90 4
	nopicmip
	skyparms skpk/env/banana/foggy - -
}

textures/skies_MASTER5/foggyocean
{
	qer_editorImage skpk/qer/env/banana/foggyocean.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 50 55 78 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 110 4
	nopicmip
	skyparms skpk/env/banana/foggyocean - -
}

textures/skies_MASTER5/frozen
{
	qer_editorImage skpk/qer/env/banana/frozen.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 -29 21 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/banana/frozen - -
}

textures/skies_MASTER5/GalacticBOO
{
	qer_editorImage skpk/qer/env/banana/GalacticBOO.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 130 4
	nopicmip
	skyparms skpk/env/banana/GalacticBOO - -
}

textures/skies_MASTER5/Galaxy
{
	qer_editorImage skpk/qer/env/banana/Galaxy.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 130 4
	nopicmip
	skyparms skpk/env/banana/Galaxy - -
}

//nice!
textures/skies_MASTER5/game_sky
{
	qer_editorImage skpk/qer/env/banana/game_sky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyparms skpk/env/banana/game_sky - -
}

textures/skies_MASTER5/glorious_morning
{
	qer_editorImage skpk/qer/env/banana/glorious_morning.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 0.942748 0.607813 50 20 18 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 110 4
	nopicmip
	skyparms skpk/env/banana/glorious_morning - -
}

textures/skies_MASTER5/green2
{
	qer_editorImage skpk/qer/env/banana/green.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 45 83 27 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms skpk/env/banana/green - -
}

textures/skies_MASTER5/halloween
{
	qer_editorImage skpk/qer/env/banana/halloween.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.980392 0.654902 0.145098 50 -83 38 2 16          //left eye
	q3map_sunExt 0.980392 0.654902 0.145098 50 -95 39 2 16          //right eye
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 100 4
	nopicmip
	skyparms skpk/env/banana/halloween - -
}

textures/skies_MASTER5/halo_ring
{
	qer_editorImage skpk/qer/env/banana/halo_ring.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 30 -123 31 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 125 4
	nopicmip
	skyparms skpk/env/banana/halo_ring - -
}

textures/skies_MASTER5/halo_sky1
{
	qer_editorImage skpk/qer/env/banana/halo_sky1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 30 -123 31 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 125 4
	nopicmip
	skyparms skpk/env/banana/halo_sky1 - -
}

textures/skies_MASTER5/halo_sky2
{
	qer_editorImage skpk/qer/env/banana/halo_sky2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 -30 25 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/banana/halo_sky2 - -
}

textures/skies_MASTER5/hazy
{
	qer_editorImage skpk/qer/env/banana/hazy.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 125 4
	nopicmip
	skyparms skpk/env/banana/hazy - -
}

textures/skies_MASTER5/highres02
{
	qer_editorImage skpk/qer/env/banana/highres02.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 130 4
	nopicmip
	skyparms skpk/env/banana/highres02 - -
}

textures/skies_MASTER5/highres03
{
	qer_editorImage skpk/qer/env/banana/highres03.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 130 4
	nopicmip
	skyparms skpk/env/banana/highres03 - -
}

//top sky only
textures/skies_MASTER5/highres04
{
	qer_editorImage skpk/qer/env/banana/highres04.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 130 4
	nopicmip
	skyparms skpk/env/banana/highres04 - -
}

textures/skies_MASTER5/highres06
{
	qer_editorImage skpk/qer/env/banana/highres06.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.98352 0.893553 0.636255 85 -179 20 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/banana/highres06 - -
}

textures/skies_MASTER5/highres_fog
{
	qer_editorImage skpk/qer/env/banana/highres_fog.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 130 4
	nopicmip
	skyparms skpk/env/banana/highres_fog - -
}

textures/skies_MASTER5/highres
{
	qer_editorImage skpk/qer/env/banana/highres.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 130 4
	nopicmip
	skyparms skpk/env/banana/highres - -
}

textures/skies_MASTER5/hlwn
{
	qer_editorImage skpk/qer/env/banana/hlwn.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyparms skpk/env/banana/hlwn - -
}

textures/skies_MASTER5/cstrike_sky05-mix303
{
	qer_editorImage skpk/qer/env/banana/hybrid.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyparms skpk/env/banana/hybrid - -
}

textures/skies_MASTER5/icebergs
{
	qer_editorImage skpk/qer/env/banana/icebergs.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 -57 48 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/banana/icebergs - -
}

textures/skies_MASTER5/iraqi
{
	qer_editorImage skpk/qer/env/banana/iraqi.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 0.698482 0.332296 65 91 17 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 95 4
	nopicmip
	skyparms skpk/env/banana/iraqi - -
}

textures/skies_MASTER5/italy_csgo
{
	qer_editorImage skpk/qer/env/banana/italy_csgo.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyparms skpk/env/banana/italy_csgo - -
}

textures/skies_MASTER5/jasper_Airex01
{
	qer_editorImage skpk/qer/env/banana/jasper/Sky_Airex01.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 25 0 8 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 125 4
	nopicmip
	skyparms skpk/env/banana/jasper/Sky_Airex01 - -
}

textures/skies_MASTER5/jasper_AlphaCity01
{
	qer_editorImage skpk/qer/env/banana/jasper/Sky_AlphaCity01.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 150 4
	nopicmip
	skyparms skpk/env/banana/jasper/Sky_AlphaCity01 - -
}

textures/skies_MASTER5/jasper_Arctic01
{
	qer_editorImage skpk/qer/env/banana/jasper/Sky_Arctic01.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 35 -3 7 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 125 4
	nopicmip
	skyparms skpk/env/banana/jasper/Sky_Arctic01 - -
}

textures/skies_MASTER5/jasper_Barren01
{
	qer_editorImage skpk/qer/env/banana/jasper/Sky_Barren01.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 35 -9 15 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 125 4
	nopicmip
	skyparms skpk/env/banana/jasper/Sky_Barren01 - -
}

textures/skies_MASTER5/jasper_Coastal01
{
	qer_editorImage skpk/qer/env/banana/jasper/Sky_Coastal01.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 70 6 29 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 85 4
	nopicmip
	skyparms skpk/env/banana/jasper/Sky_Coastal01 - -
}

textures/skies_MASTER5/jasper_Coastal02
{
	qer_editorImage skpk/qer/env/banana/jasper/Sky_Coastal02.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 40 -10 14 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms skpk/env/banana/jasper/Sky_Coastal02 - -
}

textures/skies_MASTER5/jasper_Dirty01
{
	qer_editorImage skpk/qer/env/banana/jasper/Sky_Dirty01.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 0.936278 0.568109 35 -4 7 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 110 4
	nopicmip
	skyparms skpk/env/banana/jasper/Sky_Dirty01 - -
}

textures/skies_MASTER5/jasper_Everfield01
{
	qer_editorImage skpk/qer/env/banana/jasper/Sky_Everfield01.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 25 -11 12 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyparms skpk/env/banana/jasper/Sky_Everfield01 - -
}

textures/skies_MASTER5/jasper_LosAngeles01
{
	qer_editorImage skpk/qer/env/banana/jasper/Sky_LosAngeles01.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 140 4
	nopicmip
	skyparms skpk/env/banana/jasper/Sky_LosAngeles01 - -
}

textures/skies_MASTER5/jasper_Nekoti01
{
	qer_editorImage skpk/qer/env/banana/jasper/Sky_Nekoti01.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.987427 0.712932 0.386709 60 1 5 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 95 4
	nopicmip
	skyparms skpk/env/banana/jasper/Sky_Nekoti01 - -
}

textures/skies_MASTER5/jasper_Night01
{
	qer_editorImage skpk/qer/env/banana/jasper/Sky_Night01.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 25 -1 19 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 130 4
	nopicmip
	skyparms skpk/env/banana/jasper/Sky_Night01 - -
}

textures/skies_MASTER5/jasper_Night02
{
	qer_editorImage skpk/qer/env/banana/jasper/Sky_Night02.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 25 -1 20 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 130 4
	nopicmip
	skyparms skpk/env/banana/jasper/Sky_Night02 - -
}

textures/skies_MASTER5/jasper_NightTime01
{
	qer_editorImage skpk/qer/env/banana/jasper/Sky_NightTime01.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 30 -3 15 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 125 4
	nopicmip
	skyparms skpk/env/banana/jasper/Sky_NightTime01 - -
}

textures/skies_MASTER5/jasper_Nimeton01
{
	qer_editorImage skpk/qer/env/banana/jasper/Sky_Nimeton01.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.902296 0.848035 0.633509 30 -10 5 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 110 4
	nopicmip
	skyparms skpk/env/banana/jasper/Sky_Nimeton01 - -
}

textures/skies_MASTER5/jasper_Overcast01
{
	qer_editorImage skpk/qer/env/banana/jasper/Sky_Overcast01.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 130 4
	nopicmip
	skyparms skpk/env/banana/jasper/Sky_Overcast01 - -
}

textures/skies_MASTER5/jasper_Overcast02
{
	qer_editorImage skpk/qer/env/banana/jasper/Sky_Overcast02.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 130 4
	nopicmip
	skyparms skpk/env/banana/jasper/Sky_Overcast02 - -
}

textures/skies_MASTER5/jasper_Overcast03
{
	qer_editorImage skpk/qer/env/banana/jasper/Sky_Overcast03.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 130 4
	nopicmip
	skyparms skpk/env/banana/jasper/Sky_Overcast03 - -
}

textures/skies_MASTER5/jasper_Penrith01
{
	qer_editorImage skpk/qer/env/banana/jasper/Sky_Penrith01.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.996521 0.829236 0.630442 40 -2 10 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 105 4
	nopicmip
	skyparms skpk/env/banana/jasper/Sky_Penrith01 - -
}

textures/skies_MASTER5/jasper_Prelude01
{
	qer_editorImage skpk/qer/env/banana/jasper/Sky_Prelude01.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 45 -20 34 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 105 4
	nopicmip
	skyparms skpk/env/banana/jasper/Sky_Prelude01 - -
}

textures/skies_MASTER5/jasper_Prelude02
{
	qer_editorImage skpk/qer/env/banana/jasper/Sky_Prelude02.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 40 -14 25 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 110 4
	nopicmip
	skyparms skpk/env/banana/jasper/Sky_Prelude02 - -
}

textures/skies_MASTER5/jasper_Prelude03
{
	qer_editorImage skpk/qer/env/banana/jasper/Sky_Prelude03.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 35 -15 19 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms skpk/env/banana/jasper/Sky_Prelude03 - -
}

textures/skies_MASTER5/jasper_Prelude04
{
	qer_editorImage skpk/qer/env/banana/jasper/Sky_Prelude04.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 0.8056 0.469841 45 -9 15 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 105 4
	nopicmip
	skyparms skpk/env/banana/jasper/Sky_Prelude04 - -
}

textures/skies_MASTER5/jasper_Prelude05
{
	qer_editorImage skpk/qer/env/banana/jasper/Sky_Prelude05.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 0.8056 0.469841 35 -5 9 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 110 4
	nopicmip
	skyparms skpk/env/banana/jasper/Sky_Prelude05 - -
}

textures/skies_MASTER5/jasper_Prelude06
{
	qer_editorImage skpk/qer/env/banana/jasper/Sky_Prelude06.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.99443 0.757015 0.347005 30 -10 4 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 125 4
	nopicmip
	skyparms skpk/env/banana/jasper/Sky_Prelude06 - -
}

textures/skies_MASTER5/jasper_Prelude07
{
	qer_editorImage skpk/qer/env/banana/jasper/Sky_Prelude07.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.985061 0.830182 0.449973 45 -3 20 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 100 4
	nopicmip
	skyparms skpk/env/banana/jasper/Sky_Prelude07 - -
}

textures/skies_MASTER5/jasper_Prelude08
{
	qer_editorImage skpk/qer/env/banana/jasper/Sky_Prelude08.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.985046 0.736065 0.449958 70 0 4 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 85 4
	nopicmip
	skyparms skpk/env/banana/jasper/Sky_Prelude08 - -
}

textures/skies_MASTER5/jasper_PreludeDusk
{
	qer_editorImage skpk/qer/env/banana/jasper/Sky_PreludeDusk.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.993927 0.725948 0.41796 60 -1 8 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 95 4
	nopicmip
	skyparms skpk/env/banana/jasper/Sky_PreludeDusk - -
}

textures/skies_MASTER5/jasper_PreludeHub
{
	qer_editorImage skpk/qer/env/banana/jasper/Sky_PreludeHub.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 70 0 15 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 85 4
	nopicmip
	skyparms skpk/env/banana/jasper/Sky_PreludeHub - -
}

textures/skies_MASTER5/jasper_PreludeNight01
{
	qer_editorImage skpk/qer/env/banana/jasper/Sky_PreludeNight01.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 55 -1 28 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 100 4
	nopicmip
	skyparms skpk/env/banana/jasper/Sky_PreludeNight01 - -
}

textures/skies_MASTER5/jasper_PreludeOvercast
{
	qer_editorImage skpk/qer/env/banana/jasper/Sky_PreludeOvercast.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 35 -1 13 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 120 4
	nopicmip
	skyparms skpk/env/banana/jasper/Sky_PreludeOvercast - -
}

textures/skies_MASTER5/jasper_PreludeOvercast01
{
	qer_editorImage skpk/qer/env/banana/jasper/Sky_PreludeOvercast01.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 45 -2 73 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 110 4
	nopicmip
	skyparms skpk/env/banana/jasper/Sky_PreludeOvercast01 - -
}

textures/skies_MASTER5/jasper_PreludeOvercast02
{
	qer_editorImage skpk/qer/env/banana/jasper/Sky_PreludeOvercast02.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 30 -1 13 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 125 4
	nopicmip
	skyparms skpk/env/banana/jasper/Sky_PreludeOvercast02 - -
}

textures/skies_MASTER5/jasper_Purple01
{
	qer_editorImage skpk/qer/env/banana/jasper/Sky_Purple01.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 130 4
	nopicmip
	skyparms skpk/env/banana/jasper/Sky_Purple01 - -
}

textures/skies_MASTER5/jasper_Stormy01
{
	qer_editorImage skpk/qer/env/banana/jasper/Sky_Stormy01.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 50 -9 4 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 105 4
	nopicmip
	skyparms skpk/env/banana/jasper/Sky_Stormy01 - -
}

textures/skies_MASTER5/jasper_Stormy02
{
	qer_editorImage skpk/qer/env/banana/jasper/Sky_Stormy02.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 50 -9 4 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 105 4
	nopicmip
	skyparms skpk/env/banana/jasper/Sky_Stormy02 - -
}

textures/skies_MASTER5/jasper_Terrassee01
{
	qer_editorImage skpk/qer/env/banana/jasper/Sky_Terrassee01.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.993927 0.809766 0.41796 50 0 7 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 95 4
	nopicmip
	skyparms skpk/env/banana/jasper/Sky_Terrassee01 - -
}

textures/skies_MASTER5/jasper_Terrassee01-2
{
	qer_editorImage skpk/qer/env/banana/jasper/Sky_Terrassee01-2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 0.874937 0.608865 60 4 10 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 95 4
	nopicmip
	skyparms skpk/env/banana/jasper/Sky_Terrassee01-2 - -
}

textures/skies_MASTER5/jasper_Terrassee02
{
	qer_editorImage skpk/qer/env/banana/jasper/Sky_Terrassee02.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 0.667796 0.398215 65 0 8 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 85 4
	nopicmip
	skyparms skpk/env/banana/jasper/Sky_Terrassee02 - -
}

textures/skies_MASTER5/jasper_TID01
{
	qer_editorImage skpk/qer/env/banana/jasper/Sky_TID01.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 0.972427 0.644877 60 -11 4 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 95 4
	nopicmip
	skyparms skpk/env/banana/jasper/Sky_TID01 - -
}

textures/skies_MASTER5/jasper_Waldon01-2
{
	qer_editorImage skpk/qer/env/banana/jasper/Sky_Waldon01-2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 19 11 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/banana/jasper/Sky_Waldon01-2 - -
}

textures/skies_MASTER5/jasper_Waldon01
{
	qer_editorImage skpk/qer/env/banana/jasper/Sky_Waldon01.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 55 20 10 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 105 4
	nopicmip
	skyparms skpk/env/banana/jasper/Sky_Waldon01 - -
}

textures/skies_MASTER5/jasper_WintersMourn01
{
	qer_editorImage skpk/qer/env/banana/jasper/Sky_WintersMourn01.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.972549 0.745098 0.588235 70 -29 10 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 90 4
	nopicmip
	skyparms skpk/env/banana/jasper/Sky_WintersMourn01 - -
}

textures/skies_MASTER5/jasper_WintersMourn02
{
	qer_editorImage skpk/qer/env/banana/jasper/Sky_WintersMourn02.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 45 -9 25 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 105 4
	nopicmip
	skyparms skpk/env/banana/jasper/Sky_WintersMourn02 - -
}

textures/skies_MASTER5/jasper_WintersMourn03
{
	qer_editorImage skpk/qer/env/banana/jasper/Sky_WintersMourn03.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 45 -7 22 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 105 4
	nopicmip
	skyparms skpk/env/banana/jasper/Sky_WintersMourn03 - -
}

textures/skies_MASTER5/jasper_WintersMourn04
{
	qer_editorImage skpk/qer/env/banana/jasper/Sky_WintersMourn04.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 60 -9 25 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 100 4
	nopicmip
	skyparms skpk/env/banana/jasper/Sky_WintersMourn04 - -
}

textures/skies_MASTER5/jasper_WorldsEnd01
{
	qer_editorImage skpk/qer/env/banana/jasper/Sky_WorldsEnd01.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 0.532921 0.388006 50 0 6 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/banana/jasper/Sky_WorldsEnd01 - -
}

textures/skies_MASTER5/jk_sky1
{
	qer_editorImage skpk/qer/env/banana/jk_sky1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms skpk/env/banana/jk_sky1 - -
}

textures/skies_MASTER5/jungle_csgo
{
	qer_editorImage skpk/qer/env/banana/jungle_csgo.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 50 104 43 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 105 4
	nopicmip
	skyparms skpk/env/banana/jungle_csgo - -
}

textures/skies_MASTER5/kc_acid_wash
{
	qer_editorImage skpk/qer/env/banana/kc_acid_wash.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 130 4
	nopicmip
	skyparms skpk/env/banana/kc_acid_wash - -
}

textures/skies_MASTER5/kc_LSD
{
	qer_editorImage skpk/qer/env/banana/kc_LSD.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 130 4
	nopicmip
	skyparms skpk/env/banana/kc_LSD - -
}

textures/skies_MASTER5/kc_pink_cream
{
	qer_editorImage skpk/qer/env/banana/kc_pink_cream.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 163 8 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/banana/kc_pink_cream - -
}

textures/skies_MASTER5/kc_pink_cream_vibrant
{
	qer_editorImage skpk/qer/env/banana/kc_pink_cream_vibrant.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 163 8 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/banana/kc_pink_cream_vibrant - -
}

textures/skies_MASTER5/kc_tiediesky
{
	qer_editorImage skpk/qer/env/banana/kc_tiediesky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 125 4
	nopicmip
	skyparms skpk/env/banana/kc_tiediesky - -
}

textures/skies_MASTER5/kc_titan
{
	qer_editorImage skpk/qer/env/banana/kc_titan.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 130 4
	nopicmip
	skyparms skpk/env/banana/kc_titan - -
}

textures/skies_MASTER5/kc_titan_vibrant
{
	qer_editorImage skpk/qer/env/banana/kc_titan_vibrant.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 130 4
	nopicmip
	skyparms skpk/env/banana/kc_titan_vibrant - -
}

textures/skies_MASTER5/lake_ocean
{
	qer_editorImage skpk/qer/env/banana/lake_ocean.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 138 60 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/banana/lake_ocean - -
}

textures/skies_MASTER5/lakebox
{
	qer_editorImage skpk/qer/env/banana/lakebox.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 -29 25 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/banana/lakebox - -
}

textures/skies_MASTER5/lakesky
{
	qer_editorImage skpk/qer/env/banana/lakesky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 -1 29 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/banana/lakesky - -
}

textures/skies_MASTER5/land005
{
	qer_editorImage skpk/qer/env/banana/land005.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 -75 8 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/banana/land005 - -
}

textures/skies_MASTER5/lost_at_sea
{
	qer_editorImage skpk/qer/env/banana/lost_at_sea.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 -30 58 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/banana/lost_at_sea - -
}

textures/skies_MASTER5/lunarsky_01
{
	qer_editorImage skpk/qer/env/banana/lunarsky_01.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_lightRGB 1 1 1
	q3map_skylight 135 4 0 90 0
	nopicmip
	skyparms skpk/env/banana/lunarsky_01 - -
}

textures/skies_MASTER5/mario
{
	qer_editorImage skpk/qer/env/banana/mario.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyparms skpk/env/banana/mario - -
}

textures/skies_MASTER5/mars3
{
	qer_editorImage skpk/qer/env/banana/mars3.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 45 -52 4 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 100 4
	nopicmip
	skyparms skpk/env/banana/mars3 - -
}

textures/skies_MASTER5/mars
{
	qer_editorImage skpk/qer/env/banana/mars.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_lightRGB 1 1 1
	q3map_skylight 130 4 0 90 0
	nopicmip
	skyparms skpk/env/banana/mars - -
}

textures/skies_MASTER2/mcsky5
{
	qer_editorImage skpk/qer/env/banana/MCLITE.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyparms skpk/env/banana/MCLITE - -
}

//top sky only
textures/skies_MASTER5/militia_hdr
{
	qer_editorImage skpk/qer/env/banana/militia_hdr.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 140 4
	nopicmip
	skyparms skpk/env/banana/militia_hdr - -
}

textures/skies_MASTER5/minecraftnight
{
	qer_editorImage skpk/qer/env/banana/minecraftnight.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 55 -140 59 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 90 4
	nopicmip
	skyparms skpk/env/banana/minecraftnight - -
}

textures/skies_MASTER5/mms_sky01
{
	qer_editorImage skpk/qer/env/banana/mms_sky01.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 59 24 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/banana/mms_sky01 - -
}

textures/skies_MASTER5/mms_sky02
{
	qer_editorImage skpk/qer/env/banana/mms_sky02.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyparms skpk/env/banana/mms_sky02 - -
}

textures/skies_MASTER5/mms_sky03
{
	qer_editorImage skpk/qer/env/banana/mms_sky03.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 0.74902 0.387991 85 -90 11 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/banana/mms_sky03 - -
}

textures/skies_MASTER5/mms_sky04
{
	qer_editorImage skpk/qer/env/banana/mms_sky04.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 70 -90 3 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 90 4
	nopicmip
	skyparms skpk/env/banana/mms_sky04 - -
}

textures/skies_MASTER5/mpa001
{
	qer_editorImage skpk/qer/env/banana/mpa01.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 140 4
	nopicmip
	skyparms skpk/env/banana/mpa01 - -
}

textures/skies_MASTER5/mpa002
{
	qer_editorImage skpk/qer/env/banana/mpa02.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 60 19 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/banana/mpa02 - -
}

textures/skies_MASTER5/mpa003
{
	qer_editorImage skpk/qer/env/banana/mpa03.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 130 4
	nopicmip
	skyparms skpk/env/banana/mpa03 - -
}

textures/skies_MASTER5/mpa005
{
	qer_editorImage skpk/qer/env/banana/mpa05.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyparms skpk/env/banana/mpa05 - -
}

textures/skies_MASTER5/mpa007
{
	qer_editorImage skpk/qer/env/banana/mpa07.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 80 50 41 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 75 4
	nopicmip
	skyparms skpk/env/banana/mpa07 - -
}

textures/skies_MASTER5/mpa008_2
{
	qer_editorImage skpk/qer/env/banana/mpa08_2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 125 4
	nopicmip
	skyparms skpk/env/banana/mpa08_2 - -
}

textures/skies_MASTER5/mpa008
{
	qer_editorImage skpk/qer/env/banana/mpa08.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 125 4
	nopicmip
	skyparms skpk/env/banana/mpa08 - -
}

textures/skies_MASTER5/mpa009
{
	qer_editorImage skpk/qer/env/banana/mpa09.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.99292 0.94023 0.513268 85 60 39 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/banana/mpa09 - -
}

textures/skies_MASTER5/mpa010
{
	qer_editorImage skpk/qer/env/banana/mpa10.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 130 4
	nopicmip
	skyparms skpk/env/banana/mpa10 - -
}

textures/skies_MASTER5/mpa011
{
	qer_editorImage skpk/qer/env/banana/mpa11.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 125 4
	nopicmip
	skyparms skpk/env/banana/mpa11 - -
}

textures/skies_MASTER5/mpa012
{
	qer_editorImage skpk/qer/env/banana/mpa12.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 130 4
	nopicmip
	skyparms skpk/env/banana/mpa12 - -
}

textures/skies_MASTER5/mpa013
{
	qer_editorImage skpk/qer/env/banana/mpa13.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.92549 0.898039 0.776471 85 60 38 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/banana/mpa13 - -
}

textures/skies_MASTER5/mpa014
{
	qer_editorImage skpk/qer/env/banana/mpa14.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 140 4
	nopicmip
	skyparms skpk/env/banana/mpa14 - -
}

textures/skies_MASTER5/mpa015_2
{
	qer_editorImage skpk/qer/env/banana/mpa15_2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.949966 0.960006 0.559686 85 58 36 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/banana/mpa15_2 - -
}

textures/skies_MASTER5/mpa015
{
	qer_editorImage skpk/qer/env/banana/mpa15.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.949966 0.960006 0.559686 85 58 36 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/banana/mpa15 - -
}

textures/skies_MASTER5/mpa016
{
	qer_editorImage skpk/qer/env/banana/mpa16.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 140 4
	nopicmip
	skyparms skpk/env/banana/mpa16 - -
}

textures/skies_MASTER5/mpa017_2
{
	qer_editorImage skpk/qer/env/banana/mpa17_2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyparms skpk/env/banana/mpa17_2 - -
}

textures/skies_MASTER5/mpa017
{
	qer_editorImage skpk/qer/env/banana/mpa17.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyparms skpk/env/banana/mpa17 - -
}

textures/skies_MASTER5/mpa018
{
	qer_editorImage skpk/qer/env/banana/mpa18.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyparms skpk/env/banana/mpa18 - -
}

textures/skies_MASTER5/mpa019
{
	qer_editorImage skpk/qer/env/banana/mpa19.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 130 4
	nopicmip
	skyparms skpk/env/banana/mpa19 - -
}

textures/skies_MASTER5/mpa020
{
	qer_editorImage skpk/qer/env/banana/mpa20.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 60 -2 24 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 95 4
	nopicmip
	skyparms skpk/env/banana/mpa20 - -
}

textures/skies_MASTER5/mpa021
{
	qer_editorImage skpk/qer/env/banana/mpa21.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 125 4
	nopicmip
	skyparms skpk/env/banana/mpa21 - -
}

textures/skies_MASTER5/mpa022
{
	qer_editorImage skpk/qer/env/banana/mpa22.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 130 4
	nopicmip
	skyparms skpk/env/banana/mpa22 - -
}

textures/skies_MASTER5/mpa023
{
	qer_editorImage skpk/qer/env/banana/mpa23.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyparms skpk/env/banana/mpa23 - -
}

textures/skies_MASTER5/mpa024
{
	qer_editorImage skpk/qer/env/banana/mpa24.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyparms skpk/env/banana/mpa24 - -
}

textures/skies_MASTER5/mpa025
{
	qer_editorImage skpk/qer/env/banana/mpa25.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 0.773816 0.429572 70 60 17 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 85 4
	nopicmip
	skyparms skpk/env/banana/mpa25 - -
}

textures/skies_MASTER5/mpa027
{
	qer_editorImage skpk/qer/env/banana/mpa27.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyparms skpk/env/banana/mpa27 - -
}

textures/skies_MASTER5/mpa028
{
	qer_editorImage skpk/qer/env/banana/mpa28.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 125 4
	nopicmip
	skyparms skpk/env/banana/mpa28 - -
}

textures/skies_MASTER5/mpa029
{
	qer_editorImage skpk/qer/env/banana/mpa29.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 125 4
	nopicmip
	skyparms skpk/env/banana/mpa29 - -
}

textures/skies_MASTER5/mpa030
{
	qer_editorImage skpk/qer/env/banana/mpa30.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 0.675654 0.354849 85 57 5 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/banana/mpa30 - -
}

textures/skies_MASTER5/mpa035
{
	qer_editorImage skpk/qer/env/banana/mpa35.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 130 4
	nopicmip
	skyparms skpk/env/banana/mpa35 - -
}

textures/skies_MASTER5/mpa037
{
	qer_editorImage skpk/qer/env/banana/mpa37.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 0.820981 0.454353 55 19 6 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 100 4
	nopicmip
	skyparms skpk/env/banana/mpa37 - -
}

textures/skies_MASTER5/mpa038
{
	qer_editorImage skpk/qer/env/banana/mpa38.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 140 4
	nopicmip
	skyparms skpk/env/banana/mpa38 - -
}

textures/skies_MASTER5/mpa040
{
	qer_editorImage skpk/qer/env/banana/mpa40.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 140 4
	nopicmip
	skyparms skpk/env/banana/mpa40 - -
}

textures/skies_MASTER5/mpa041
{
	qer_editorImage skpk/qer/env/banana/mpa41.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 140 4
	nopicmip
	skyparms skpk/env/banana/mpa41 - -
}

textures/skies_MASTER5/mpa043
{
	qer_editorImage skpk/qer/env/banana/mpa43.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 45 10 11 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 100 4
	nopicmip
	skyparms skpk/env/banana/mpa43 - -
}

textures/skies_MASTER5/mpa044
{
	qer_editorImage skpk/qer/env/banana/mpa44_b_w.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 45 69 13 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 110 4
	nopicmip
	skyparms skpk/env/banana/mpa44_b_w - -
}

textures/skies_MASTER5/mpa044_blue
{
	qer_editorImage skpk/qer/env/banana/mpa44_blue.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.407065 0.881575 0.961089 55 69 13 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 110 4
	nopicmip
	skyparms skpk/env/banana/mpa44_blue - -
}

textures/skies_MASTER5/mpa044_green
{
	qer_editorImage skpk/qer/env/banana/mpa44_green.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.825513 1 0.266224 55 69 13 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 110 4
	nopicmip
	skyparms skpk/env/banana/mpa44_green - -
}

textures/skies_MASTER5/mpa044_orange
{
	qer_editorImage skpk/qer/env/banana/mpa44_orange.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 0.886809 0.363775 55 69 13 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 110 4
	nopicmip
	skyparms skpk/env/banana/mpa44_orange - -
}

textures/skies_MASTER5/mpa045
{
	qer_editorImage skpk/qer/env/banana/mpa45.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 145 4
	nopicmip
	skyparms skpk/env/banana/mpa45 - -
}

textures/skies_MASTER5/mpa046
{
	qer_editorImage skpk/qer/env/banana/mpa46.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 130 4
	nopicmip
	skyparms skpk/env/banana/mpa46 - -
}

textures/skies_MASTER5/mpa047
{
	qer_editorImage skpk/qer/env/banana/mpa47.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 125 4
	nopicmip
	skyparms skpk/env/banana/mpa47 - -
}

textures/skies_MASTER5/mpa048
{
	qer_editorImage skpk/qer/env/banana/mpa48.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 130 4
	nopicmip
	skyparms skpk/env/banana/mpa48 - -
}

textures/skies_MASTER5/mpa049
{
	qer_editorImage skpk/qer/env/banana/mpa49.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 130 4
	nopicmip
	skyparms skpk/env/banana/mpa49 - -
}

textures/skies_MASTER5/mpa050
{
	qer_editorImage skpk/qer/env/banana/mpa50.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyparms skpk/env/banana/mpa50 - -
}

textures/skies_MASTER5/mpa051
{
	qer_editorImage skpk/qer/env/banana/mpa51.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 0.876295 0.454353 85 90 16 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/banana/mpa51 - -
}

textures/skies_MASTER5/mpa052
{
	qer_editorImage skpk/qer/env/banana/mpa52.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.978759 0.808179 0.316701 40 -27 25 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyparms skpk/env/banana/mpa52 - -
}

textures/skies_MASTER5/mpa053
{
	qer_editorImage skpk/qer/env/banana/mpa53.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyparms skpk/env/banana/mpa53 - -
}

textures/skies_MASTER5/mpa054
{
	qer_editorImage skpk/qer/env/banana/mpa54.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 0.836667 0.454353 40 62 17 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyparms skpk/env/banana/mpa54 - -
}

textures/skies_MASTER5/mpa055
{
	qer_editorImage skpk/qer/env/banana/mpa55.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 0.649958 0.802945 50 69 16 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 110 4
	nopicmip
	skyparms skpk/env/banana/mpa55 - -
}

textures/skies_MASTER5/mpa056
{
	qer_editorImage skpk/qer/env/banana/mpa56.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 0.756298 0.491951 50 72 11 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 105 4
	nopicmip
	skyparms skpk/env/banana/mpa56 - -
}

textures/skies_MASTER5/mpa057
{
	qer_editorImage skpk/qer/env/banana/mpa57.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_lightRGB 1 1 1
	q3map_skylight 130 4 0 90 0
	nopicmip
	skyparms skpk/env/banana/mpa57 - -
}

textures/skies_MASTER5/mpa058
{
	qer_editorImage skpk/qer/env/banana/mpa58.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 130 4
	nopicmip
	skyparms skpk/env/banana/mpa58 - -
}

textures/skies_MASTER5/mpa059
{
	qer_editorImage skpk/qer/env/banana/mpa59.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 0.811566 0.491951 55 75 11 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 100 4
	nopicmip
	skyparms skpk/env/banana/mpa59 - -
}

textures/skies_MASTER5/mpa061
{
	qer_editorImage skpk/qer/env/banana/mpa61.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 130 4
	nopicmip
	skyparms skpk/env/banana/mpa61 - -
}

textures/skies_MASTER5/mpa062
{
	qer_editorImage skpk/qer/env/banana/mpa62.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 125 4
	nopicmip
	skyparms skpk/env/banana/mpa62 - -
}

textures/skies_MASTER5/mpa062_planet
{
	qer_editorImage skpk/qer/env/banana/mpa62_planet.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 125 4
	nopicmip
	skyparms skpk/env/banana/mpa62_planet - -
}

textures/skies_MASTER5/mpa063
{
	qer_editorImage skpk/qer/env/banana/mpa63.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 -56 59 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/banana/mpa63 - -
}

textures/skies_MASTER5/mpa066
{
	qer_editorImage skpk/qer/env/banana/mpa66.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 45 5 26 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 110 4
	nopicmip
	skyparms skpk/env/banana/mpa66 - -
}

textures/skies_MASTER5/mpa067
{
	qer_editorImage skpk/qer/env/banana/mpa67.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 125 4
	nopicmip
	skyparms skpk/env/banana/mpa67 - -
}

textures/skies_MASTER5/mpa068
{
	qer_editorImage skpk/qer/env/banana/mpa68.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 60 -91 58 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 100 4
	nopicmip
	skyparms skpk/env/banana/mpa68 - -
}

textures/skies_MASTER5/mpa069
{
	qer_editorImage skpk/qer/env/banana/mpa69.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 40 -21 19 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 110 4
	nopicmip
	skyparms skpk/env/banana/mpa69 - -
}

textures/skies_MASTER5/mpa070
{
	qer_editorImage skpk/qer/env/banana/mpa70.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 130 4
	nopicmip
	skyparms skpk/env/banana/mpa70 - -
}

textures/skies_MASTER5/mpa070v2
{
	qer_editorImage skpk/qer/env/banana/mpa70v2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 140 4
	nopicmip
	skyparms skpk/env/banana/mpa70v2 - -
}

textures/skies_MASTER5/mpa071
{
	qer_editorImage skpk/qer/env/banana/mpa71.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 75 80 20 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 80 4
	nopicmip
	skyparms skpk/env/banana/mpa71 - -
}

textures/skies_MASTER5/mpa072
{
	qer_editorImage skpk/qer/env/banana/mpa72.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyparms skpk/env/banana/mpa72 - -
}

textures/skies_MASTER5/mpa073
{
	qer_editorImage skpk/qer/env/banana/mpa73.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyparms skpk/env/banana/mpa73 - -
}

textures/skies_MASTER5/mpa074
{
	qer_editorImage skpk/qer/env/banana/mpa74.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyparms skpk/env/banana/mpa74 - -
}

textures/skies_MASTER5/mpa075
{
	qer_editorImage skpk/qer/env/banana/mpa75.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 145 4
	nopicmip
	skyparms skpk/env/banana/mpa75 - -
}

textures/skies_MASTER5/mpa076
{
	qer_editorImage skpk/qer/env/banana/mpa76.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyparms skpk/env/banana/mpa76 - -
}

textures/skies_MASTER5/mpa077
{
	qer_editorImage skpk/qer/env/banana/mpa77.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.870817 1 0.491951 85 7 23 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/banana/mpa77 - -
}

textures/skies_MASTER5/mpa078
{
	qer_editorImage skpk/qer/env/banana/mpa78.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyparms skpk/env/banana/mpa78 - -
}

textures/skies_MASTER5/mpa079
{
	qer_editorImage skpk/qer/env/banana/mpa79.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyparms skpk/env/banana/mpa79 - -
}

textures/skies_MASTER5/mpa080
{
	qer_editorImage skpk/qer/env/banana/mpa80.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 0.898299 0.415824 85 -98 74 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/banana/mpa80 - -
}

textures/skies_MASTER5/mpa081
{
	qer_editorImage skpk/qer/env/banana/mpa81.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 130 4
	nopicmip
	skyparms skpk/env/banana/mpa81 - -
}

textures/skies_MASTER5/mpa083
{
	qer_editorImage skpk/qer/env/banana/mpa83.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 145 4
	nopicmip
	skyparms skpk/env/banana/mpa83 - -
}

textures/skies_MASTER5/mpa084
{
	qer_editorImage skpk/qer/env/banana/mpa84.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 145 4
	nopicmip
	skyparms skpk/env/banana/mpa84 - -
}

textures/skies_MASTER5/mpa085
{
	qer_editorImage skpk/qer/env/banana/mpa85.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 145 4
	nopicmip
	skyparms skpk/env/banana/mpa85 - -
}

textures/skies_MASTER5/mpa086
{
	qer_editorImage skpk/qer/env/banana/mpa86.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 117 24 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/banana/mpa86 - -
}

textures/skies_MASTER5/mpa088
{
	qer_editorImage skpk/qer/env/banana/mpa88.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 70 -84 9 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 90 4
	nopicmip
	skyparms skpk/env/banana/mpa88 - -
}

textures/skies_MASTER5/mpa090
{
	qer_editorImage skpk/qer/env/banana/mpa90.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 125 4
	nopicmip
	skyparms skpk/env/banana/mpa90 - -
}

textures/skies_MASTER5/mpa091
{
	qer_editorImage skpk/qer/env/banana/mpa91.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 145 4
	nopicmip
	skyparms skpk/env/banana/mpa91 - -
}

textures/skies_MASTER5/mpa092
{
	qer_editorImage skpk/qer/env/banana/mpa92.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyparms skpk/env/banana/mpa92 - -
}

textures/skies_MASTER5/mpa093
{
	qer_editorImage skpk/qer/env/banana/mpa93.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 25 90 30 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 120 4
	nopicmip
	skyparms skpk/env/banana/mpa93 - -
}

textures/skies_MASTER5/mpa094
{
	qer_editorImage skpk/qer/env/banana/mpa94.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 45 3 15 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 120 4
	nopicmip
	skyparms skpk/env/banana/mpa94 - -
}

textures/skies_MASTER5/mpa095
{
	qer_editorImage skpk/qer/env/banana/mpa95.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 0.78146 0.533913 60 -20 7 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 100 4
	nopicmip
	skyparms skpk/env/banana/mpa95 - -
}

textures/skies_MASTER5/mpa096
{
	qer_editorImage skpk/qer/env/banana/mpa96.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 0.78146 0.533913 35 7 24 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 110 4
	nopicmip
	skyparms skpk/env/banana/mpa96 - -
}

textures/skies_MASTER5/mpa097
{
	qer_editorImage skpk/qer/env/banana/mpa97.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyparms skpk/env/banana/mpa97 - -
}

textures/skies_MASTER5/mpa098
{
	qer_editorImage skpk/qer/env/banana/mpa98.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 -95 39 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/banana/mpa98 - -
}

textures/skies_MASTER5/mpa099
{
	qer_editorImage skpk/qer/env/banana/mpa99.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.898039 0.796078 0.486275 50 -31 13 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 105 4
	nopicmip
	skyparms skpk/env/banana/mpa99 - -
}

textures/skies_MASTER5/mpa100
{
	qer_editorImage skpk/qer/env/banana/mpa100.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 60 -12 23 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 90 4
	nopicmip
	skyparms skpk/env/banana/mpa100 - -
}

textures/skies_MASTER5/mpa101
{
	qer_editorImage skpk/qer/env/banana/mpa101.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 60 -93 55 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 90 4
	nopicmip
	skyparms skpk/env/banana/mpa101 - -
}

textures/skies_MASTER5/mpa102
{
	qer_editorImage skpk/qer/env/banana/mpa102.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.99292 0.771542 0.513268 50 -37 7 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 105 4
	nopicmip
	skyparms skpk/env/banana/mpa102 - -
}

textures/skies_MASTER5/mpa104
{
	qer_editorImage skpk/qer/env/banana/mpa104.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 130 4
	nopicmip
	skyparms skpk/env/banana/mpa104 - -
}

textures/skies_MASTER5/mpa105
{
	qer_editorImage skpk/qer/env/banana/mpa105.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyparms skpk/env/banana/mpa105 - -
}

textures/skies_MASTER5/mpa106
{
	qer_editorImage skpk/qer/env/banana/mpa106.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 60 11 18 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 95 4
	nopicmip
	skyparms skpk/env/banana/mpa106 - -
}

textures/skies_MASTER5/mpa108
{
	qer_editorImage skpk/qer/env/banana/mpa108.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.972549 0.988235 0.364706 50 -102 28 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 105 4
	nopicmip
	skyparms skpk/env/banana/mpa108 - -
}

textures/skies_MASTER5/mpa109
{
	qer_editorImage skpk/qer/env/banana/mpa109.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 55 -7 25 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 100 4
	nopicmip
	skyparms skpk/env/banana/mpa109 - -
}

textures/skies_MASTER5/mpa111
{
	qer_editorImage skpk/qer/env/banana/mpa111.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 145 4
	nopicmip
	skyparms skpk/env/banana/mpa111 - -
}

textures/skies_MASTER5/mpa112
{
	qer_editorImage skpk/qer/env/banana/mpa112.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 145 4
	nopicmip
	skyparms skpk/env/banana/mpa112 - -
}

textures/skies_MASTER5/mpa113
{
	qer_editorImage skpk/qer/env/banana/mpa113.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 22 63 29 5 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 66 4
	nopicmip
	skyparms skpk/env/banana/mpa113 - -
}

textures/skies_MASTER5/mpa114
{
	qer_editorImage skpk/qer/env/banana/mpa114.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 55 17 25 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 100 4
	nopicmip
	skyparms skpk/env/banana/mpa114 - -
}

textures/skies_MASTER5/mpa115
{
	qer_editorImage skpk/qer/env/banana/mpa115.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 60 114 24 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 95 4
	nopicmip
	skyparms skpk/env/banana/mpa115 - -
}

textures/skies_MASTER5/mpa116
{
	qer_editorImage skpk/qer/env/banana/mpa116.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 61 58 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/banana/mpa116 - -
}

textures/skies_MASTER5/mpa117
{
	qer_editorImage skpk/qer/env/banana/mpa117.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 0.737667 0.949142 45 -134 15 2 16
	q3map_sunExt 1 0.737667 0.949142 45 -178 34 2 16
	q3map_sunExt 1 0.737667 0.949142 45 134 14 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 95 4
	nopicmip
	skyparms skpk/env/banana/mpa117 - -
}

textures/skies_MASTER5/mpa118
{
	qer_editorImage skpk/qer/env/banana/mpa118.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 55 88 53 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 95 4
	nopicmip
	skyparms skpk/env/banana/mpa118 - -
}

textures/skies_MASTER5/mpa119
{
	qer_editorImage skpk/qer/env/banana/mpa119.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 55 -30 10 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 100 4
	nopicmip
	skyparms skpk/env/banana/mpa119 - -
}

textures/skies_MASTER5/mpa120
{
	qer_editorImage skpk/qer/env/banana/mpa120.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyparms skpk/env/banana/mpa120 - -
}

textures/skies_MASTER5/mpa121
{
	qer_editorImage skpk/qer/env/banana/mpa121.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 -57 44 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/banana/mpa121 - -
}

textures/skies_MASTER5/mpa123
{
	qer_editorImage skpk/qer/env/banana/mpa123.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 60 129 12 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 95 4
	nopicmip
	skyparms skpk/env/banana/mpa123 - -
}

textures/skies_MASTER5/mpa124
{
	qer_editorImage skpk/qer/env/banana/mpa124.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 45 -25 24 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 110 4
	nopicmip
	skyparms skpk/env/banana/mpa124 - -
}

textures/skies_MASTER5/mpa125
{
	qer_editorImage skpk/qer/env/banana/mpa125.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 55 -21 50 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 100 4
	nopicmip
	skyparms skpk/env/banana/mpa125 - -
}

textures/skies_MASTER5/mpa_abstrakt_gelb
{
	qer_editorImage skpk/qer/env/banana/mpa_abstrakt_gelb.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 125 4
	nopicmip
	skyparms skpk/env/banana/mpa_abstrakt_gelb - -
}

textures/skies_MASTER5/mpa_blacklight
{
	qer_editorImage skpk/qer/env/banana/mpa_blacklight.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 145 4
	nopicmip
	skyparms skpk/env/banana/mpa_blacklight - -
}

textures/skies_MASTER5/mpa_blood_orange
{
	qer_editorImage skpk/qer/env/banana/mpa_blood_orange.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.929412 0.909804 0.603922 80 60.5 33 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 75 4
	nopicmip
	skyparms skpk/env/banana/mpa_blood_orange - -
}

textures/skies_MASTER5/mpa_feuerundeis
{
	qer_editorImage skpk/qer/env/banana/mpa_feuerundeis.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 0.878294 0.574502 85 60 24 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/banana/mpa_feuerundeis - -
}

textures/skies_MASTER5/mpa_star
{
	qer_editorImage skpk/qer/env/banana/mpa_star.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 55 65 28 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms skpk/env/banana/mpa_star - -
}

textures/skies_MASTER5/mpa_star_pink
{
	qer_editorImage skpk/qer/env/banana/mpa_star_pink.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.47451 0.611765 0.67451 55 65 28 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 145 4
	nopicmip
	skyparms skpk/env/banana/mpa_star_pink - -
}

textures/skies_MASTER5/mpa_zombie2
{
	qer_editorImage skpk/qer/env/banana/mpa_zombie2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 140 4
	nopicmip
	skyparms skpk/env/banana/mpa_zombie2 - -
}

textures/skies_MASTER5/mr1
{
	qer_editorImage skpk/qer/env/banana/mr1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.956863 0.772549 0.764706 60 102 12 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 95 4
	nopicmip
	skyparms skpk/env/banana/mr1 - -
}

textures/skies_MASTER5/mr_01
{
	qer_editorImage skpk/qer/env/banana/mr_01.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 130 4
	nopicmip
	skyparms skpk/env/banana/mr_01 - -
}

textures/skies_MASTER5/mr_02
{
	qer_editorImage skpk/qer/env/banana/mr_02.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 40 -21 39 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 110 4
	nopicmip
	skyparms skpk/env/banana/mr_02 - -
}

textures/skies_MASTER5/mr_03
{
	qer_editorImage skpk/qer/env/banana/mr_03.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 145 4
	nopicmip
	skyparms skpk/env/banana/mr_03 - -
}

textures/skies_MASTER5/mr_04
{
	qer_editorImage skpk/qer/env/banana/mr_04.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 140 4
	nopicmip
	skyparms skpk/env/banana/mr_04 - -
}

textures/skies_MASTER5/mr_05
{
	qer_editorImage skpk/qer/env/banana/mr_05.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 145 4
	nopicmip
	skyparms skpk/env/banana/mr_05 - -
}

textures/skies_MASTER5/mr_06
{
	qer_editorImage skpk/qer/env/banana/mr_06.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 140 4
	nopicmip
	skyparms skpk/env/banana/mr_06 - -
}

textures/skies_MASTER5/mr_07
{
	qer_editorImage skpk/qer/env/banana/mr_07.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 40 0 90 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms skpk/env/banana/mr_07 - -
}

textures/skies_MASTER5/mr_08
{
	qer_editorImage skpk/qer/env/banana/mr_08.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 70 0 11 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 85 4
	nopicmip
	skyparms skpk/env/banana/mr_08 - -
}

textures/skies_MASTER5/mr_09
{
	qer_editorImage skpk/qer/env/banana/mr_09.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_lightRGB 1 1 1
	q3map_skylight 130 4 0 90 0
	nopicmip
	skyparms skpk/env/banana/mr_09 - -
}

textures/skies_MASTER5/mr_10
{
	qer_editorImage skpk/qer/env/banana/mr_10.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.987213 0.84567 0.438361 70 -79 13 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 85 4
	nopicmip
	skyparms skpk/env/banana/mr_10 - -
}

textures/skies_MASTER5/mr_10new
{
	qer_editorImage skpk/qer/env/banana/mr_10new.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.987213 0.84567 0.438361 70 -79 13 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 85 4
	nopicmip
	skyparms skpk/env/banana/mr_10new - -
}

textures/skies_MASTER5/mr_12
{
	qer_editorImage skpk/qer/env/banana/mr_12.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.518868 0.990951 0.429068 60 54 14 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 95 4
	nopicmip
	skyparms skpk/env/banana/mr_12 - -
}

textures/skies_MASTER5/mr_13
{
	qer_editorImage skpk/qer/env/banana/mr_13.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyparms skpk/env/banana/mr_13 - -
}

textures/skies_MASTER5/mr_15
{
	qer_editorImage skpk/qer/env/banana/mr_15.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 150 4
	nopicmip
	skyparms skpk/env/banana/mr_15 - -
}

textures/skies_MASTER5/mr_16
{
	qer_editorImage skpk/qer/env/banana/mr_16.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.987213 0.84567 0.438361 70 -85 7 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 85 4
	nopicmip
	skyparms skpk/env/banana/mr_16 - -
}

textures/skies_MASTER5/mr_21
{
	qer_editorImage skpk/qer/env/banana/mr_21.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 130 4
	nopicmip
	skyparms skpk/env/banana/mr_21 - -
}

textures/skies_MASTER5/mr_22b
{
	qer_editorImage skpk/qer/env/banana/mr_22b.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.768627 1 1 80 -79 11 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 80 4
	nopicmip
	skyparms skpk/env/banana/mr_22b - -
}

textures/skies_MASTER5/mr_22r
{
	qer_editorImage skpk/qer/env/banana/mr_22r.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt .987213 0.84567 0.438361 80 -79 11 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 80 4
	nopicmip
	skyparms skpk/env/banana/mr_22r - -
}

textures/skies_MASTER5/mr_30
{
	qer_editorImage skpk/qer/env/banana/mr_30.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 145 4
	nopicmip
	skyparms skpk/env/banana/mr_30 - -
}

textures/skies_MASTER5/mr_31
{
	qer_editorImage skpk/qer/env/banana/mr_31.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 145 4
	nopicmip
	skyparms skpk/env/banana/mr_31 - -
}

textures/skies_MASTER5/mr_32
{
	qer_editorImage skpk/qer/env/banana/mr_32.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 30 -14 18 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 125 4
	nopicmip
	skyparms skpk/env/banana/mr_32 - -
}

textures/skies_MASTER5/mr_50
{
	qer_editorImage skpk/qer/env/banana/mr_50.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 0.84152 0.509819 45 -165 31 2 16
	q3map_sunExt 1 0.84152 0.509819 30 -179 9 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms skpk/env/banana/mr_50 - -
}

textures/skies_MASTER5/mr_51
{
	qer_editorImage skpk/qer/env/banana/mr_51.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 0.84152 0.509819 55 179 10 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 100 4
	nopicmip
	skyparms skpk/env/banana/mr_51 - -
}

textures/skies_MASTER5/mr_52
{
	qer_editorImage skpk/qer/env/banana/mr_52.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 145 4
	nopicmip
	skyparms skpk/env/banana/mr_52 - -
}

textures/skies_MASTER5/mr_53
{
	qer_editorImage skpk/qer/env/banana/mr_53.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 0.84152 0.509819 30 179 10 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 125 4
	nopicmip
	skyparms skpk/env/banana/mr_53 - -
}

textures/skies_MASTER5/mr_54
{
	qer_editorImage skpk/qer/env/banana/mr_54.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 0.84152 0.509819 45 146 10 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 100 4
	nopicmip
	skyparms skpk/env/banana/mr_54 - -
}

textures/skies_MASTER5/mr_55
{
	qer_editorImage skpk/qer/env/banana/mr_55.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyparms skpk/env/banana/mr_55 - -
}

textures/skies_MASTER5/mr_56
{
	qer_editorImage skpk/qer/env/banana/mr_56.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 0.84152 0.509819 45 0 10 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 100 4
	nopicmip
	skyparms skpk/env/banana/mr_56 - -
}

textures/skies_MASTER5/mr_57
{
	qer_editorImage skpk/qer/env/banana/mr_57.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 0.84152 0.509819 45 -102 10 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 100 4
	nopicmip
	skyparms skpk/env/banana/mr_57 - -
}

textures/skies_MASTER5/mr_58
{
	qer_editorImage skpk/qer/env/banana/mr_58.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 0.84152 0.509819 40 70 5 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms skpk/env/banana/mr_58 - -
}

textures/skies_MASTER5/mr_ice
{
	qer_editorImage skpk/qer/env/banana/mr_ice.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 45 94 38 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms skpk/env/banana/mr_ice - -
}

textures/skies_MASTER5/mr_moon
{
	qer_editorImage skpk/qer/env/banana/mr_moon.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 40 -172 32 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 120 4
	nopicmip
	skyparms skpk/env/banana/mr_moon - -
}

textures/skies_MASTER5/mr_night
{
	qer_editorImage skpk/qer/env/banana/mr_night.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 40 65 25 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 120 4
	nopicmip
	skyparms skpk/env/banana/mr_night - -
}

textures/skies_MASTER5/mr_space
{
	qer_editorImage skpk/qer/env/banana/mr_space.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 145 4
	nopicmip
	skyparms skpk/env/banana/mr_space - -
}

textures/skies_MASTER5/mystic
{
	qer_editorImage skpk/qer/env/banana/mystic.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 50 35 39 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 105 4
	nopicmip
	skyparms skpk/env/banana/mystic - -
}

textures/skies_MASTER5/nightfall
{
	qer_editorImage skpk/qer/env/banana/nightfall.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 130 4
	nopicmip
	skyparms skpk/env/banana/nightfall - -
}

textures/skies_MASTER5/nightocean
{
	qer_editorImage skpk/qer/env/banana/nightocean.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 145 4
	nopicmip
	skyparms skpk/env/banana/nightocean - -
}

textures/skies_MASTER5/night_world
{
	qer_editorImage skpk/qer/env/banana/nightplanet_.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 145 4
	nopicmip
	skyparms skpk/env/banana/nightplanet_ - -
}

textures/skies_MASTER5/nightplanet
{
	qer_editorImage skpk/qer/env/banana/nightplanet.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 140 4
	nopicmip
	skyparms skpk/env/banana/nightplanet - -
}

textures/skies_MASTER5/oblivionisle
{
	qer_editorImage skpk/qer/env/banana/oblivionisle.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 125 4
	nopicmip
	skyparms skpk/env/banana/oblivionisle - -
}

textures/skies_MASTER5/ocean3
{
	qer_editorImage skpk/qer/env/banana/ocean.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.962875 0.851911 0.557382 45 -3 10 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 85 4
	nopicmip
	skyparms skpk/env/banana/ocean - -
}

textures/skies_MASTER5/ocean_mountain
{
	qer_editorImage skpk/qer/env/banana/ocean_mountain.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 65 130 53 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 60 4
	nopicmip
	skyparms skpk/env/banana/ocean_mountain - -
}

textures/skies_MASTER5/OrcSky2
{
	qer_editorImage skpk/qer/env/banana/OrcSky2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 125 4
	nopicmip
	skyparms skpk/env/banana/OrcSky2 - -
}

textures/skies_MASTER5/OrcSky
{
	qer_editorImage skpk/qer/env/banana/OrcSky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 125 4
	nopicmip
	skyparms skpk/env/banana/OrcSky - -
}

textures/skies_MASTER5/otherworld
{
	qer_editorImage skpk/qer/env/banana/otherworld.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 0.753643 0.948806 50 60 24 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 75 4
	nopicmip
	skyparms skpk/env/banana/otherworld - -
}

textures/skies_MASTER5/pandora_b
{
	qer_editorImage skpk/qer/env/banana/pandora_b.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 125 4
	nopicmip
	skyparms skpk/env/banana/pandora_b - -
}

textures/skies_MASTER5/pandora_f
{
	qer_editorImage skpk/qer/env/banana/pandora_f.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyparms skpk/env/banana/pandora_f - -
}

textures/skies_MASTER5/pink
{
	qer_editorImage skpk/qer/env/banana/pink.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 125 4
	nopicmip
	skyparms skpk/env/banana/pink - -
}

textures/skies_MASTER5/planet_x
{
	qer_editorImage skpk/qer/env/banana/planet_x.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyparms skpk/env/banana/planet_x - -
}

textures/skies_MASTER5/poisonsky
{
	qer_editorImage skpk/qer/env/banana/poisonsky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.846525 1 0.429755 85 -85 8 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/banana/poisonsky - -
}

textures/skies_MASTER5/purplebeach
{
	qer_editorImage skpk/qer/env/banana/purplebeach.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 80 -128 20 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 75 4
	nopicmip
	skyparms skpk/env/banana/purplebeach - -
}

//top sky only!
textures/skies_MASTER5/Real_SkySunset
{
	qer_editorImage skpk/qer/env/banana/Real_SkySunset.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 0.963699 0.631464 55 0 16 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/banana/Real_SkySunset - -
}

textures/skies_MASTER5/realsky1
{
	qer_editorImage skpk/qer/env/banana/realsky1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 35 72 56 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 95 4
	nopicmip
	skyparms skpk/env/banana/realsky1 - -
}

textures/skies_MASTER5/realsky2
{
	qer_editorImage skpk/qer/env/banana/realsky2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 130 4
	nopicmip
	skyparms skpk/env/banana/realsky2 - -
}

textures/skies_MASTER5/realsky3
{
	qer_editorImage skpk/qer/env/banana/realsky3.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 0.876234 0.592874 45 161 6 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 85 4
	nopicmip
	skyparms skpk/env/banana/realsky3 - -
}

textures/skies_MASTER5/realsky4
{
	qer_editorImage skpk/qer/env/banana/realsky4.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyparms skpk/env/banana/realsky4 - -
}

textures/skies_MASTER5/realsky5
{
	qer_editorImage skpk/qer/env/banana/realsky5.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 35 127 9 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 95 4
	nopicmip
	skyparms skpk/env/banana/realsky5 - -
}

textures/skies_MASTER5/realsky6
{
	qer_editorImage skpk/qer/env/banana/realsky6.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 40 -125 8 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 80 4
	nopicmip
	skyparms skpk/env/banana/realsky6 - -
}

textures/skies_MASTER5/red
{
	qer_editorImage skpk/qer/env/banana/red.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 0.861692 0.463691 50 -22 17 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 85 4
	nopicmip
	skyparms skpk/env/banana/red - -
}

textures/skies_MASTER5/red_planet
{
	qer_editorImage skpk/qer/env/banana/red_planet.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 0.528801 0.370779 85 0 14 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/banana/red_planet - -
}

textures/skies_MASTER5/redcloud
{
	qer_editorImage skpk/qer/env/banana/redcloud.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 0.734585 0.499901 35 134 9 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 95 4
	nopicmip
	skyparms skpk/env/banana/redcloud - -
}

textures/skies_MASTER5/retrosun
{
	qer_editorImage skpk/qer/env/banana/retrosun.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 0.967224 0.594217 50 0 30 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 85 4
	nopicmip
	skyparms skpk/env/banana/retrosun - -
}

textures/skies_MASTER5/seanight
{
	qer_editorImage skpk/qer/env/banana/seanight.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 0.686839 0.384421 35 7 5 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 95 4
	nopicmip
	skyparms skpk/env/banana/seanight - -
}

textures/skies_MASTER5/sh_starry
{
	qer_editorImage skpk/qer/env/banana/sh_starry_sky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyparms skpk/env/banana/sh_starry_sky - -
}

textures/skies_MASTER5/simpsons2
{
	qer_editorImage skpk/qer/env/banana/simpsons2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 125 4
	nopicmip
	skyparms skpk/env/banana/simpsons2 - -
}

textures/skies_MASTER5/sky1-2
{
	qer_editorImage skpk/qer/env/banana/sky1-2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 130 4
	nopicmip
	skyparms skpk/env/banana/sky1-2 - -
}

textures/skies_MASTER5/sky1-3
{
	qer_editorImage skpk/qer/env/banana/sky1-3.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 0.945708 0.592737 45 54 6 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/banana/sky1-3 - -
}

textures/skies_MASTER5/sky002
{
	qer_editorImage skpk/qer/env/banana/sky002.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyparms skpk/env/banana/sky002 - -
}

textures/skies_MASTER5/sky003
{
	qer_editorImage skpk/qer/env/banana/sky003.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 130 4
	nopicmip
	skyparms skpk/env/banana/sky003 - -
}

textures/skies_MASTER5/sky004
{
	qer_editorImage skpk/qer/env/banana/sky004.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 0.665034 0.289769 55 -179 23 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/banana/sky004 - -
}

textures/skies_MASTER5/sky77
{
	qer_editorImage skpk/qer/env/banana/sky77.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 0.887388 0.496666 85 0 1 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/banana/sky77 - -
}

textures/skies_MASTER5/sky78
{
	qer_editorImage skpk/qer/env/banana/sky78.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 0.750576 0.426688 50 66 5 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 75 4
	nopicmip
	skyparms skpk/env/banana/sky78 - -
}

textures/skies_MASTER5/sky100
{
	qer_editorImage skpk/qer/env/banana/sky100.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 125 4
	nopicmip
	skyparms skpk/env/banana/sky100 - -
}

textures/skies_MASTER5/sky101
{
	qer_editorImage skpk/qer/env/banana/sky101.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 130 4
	nopicmip
	skyparms skpk/env/banana/sky101 - -
}

textures/skies_MASTER5/sky102
{
	qer_editorImage skpk/qer/env/banana/sky102.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 0.582757 0.201083 30 40 31 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 95 4
	nopicmip
	skyparms skpk/env/banana/sky102 - -
}

textures/skies_MASTER5/sky103
{
	qer_editorImage skpk/qer/env/banana/sky103.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 60 1 23 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/banana/sky103 - -
}

textures/skies_MASTER5/sky104
{
	qer_editorImage skpk/qer/env/banana/sky104.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 0.776837 0.379019 55 -179 14 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/banana/sky104 - -
}

textures/skies_MASTER5/sky105
{
	qer_editorImage skpk/qer/env/banana/sky105.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyparms skpk/env/banana/sky105 - -
}

textures/skies_MASTER5/sky106
{
	qer_editorImage skpk/qer/env/banana/sky106.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.992157 0.639216 0.462745 40 105 12 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 85 4
	nopicmip
	skyparms skpk/env/banana/sky106 - -
}

textures/skies_MASTER5/sky107
{
	qer_editorImage skpk/qer/env/banana/sky107.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyparms skpk/env/banana/sky107 - -
}

textures/skies_MASTER5/sky108
{
	qer_editorImage skpk/qer/env/banana/sky108.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 130 4
	nopicmip
	skyparms skpk/env/banana/sky108 - -
}

textures/skies_MASTER5/sky109
{
	qer_editorImage skpk/qer/env/banana/sky109.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.978912 0.794079 0.552071 60 109 10 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/banana/sky109 - -
}

textures/skies_MASTER5/sky110
{
	qer_editorImage skpk/qer/env/banana/sky110.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.990005 0.864027 0.468132 85 98 14 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/banana/sky110 - -
}

textures/skies_MASTER5/sky111
{
	qer_editorImage skpk/qer/env/banana/sky111.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 130 4
	nopicmip
	skyparms skpk/env/banana/sky111 - -
}

textures/skies_MASTER5/sky112
{
	qer_editorImage skpk/qer/env/banana/sky112.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 130 4
	nopicmip
	skyparms skpk/env/banana/sky112 - -
}

textures/skies_MASTER5/sky113
{
	qer_editorImage skpk/qer/env/banana/sky113.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyparms skpk/env/banana/sky113 - -
}

textures/skies_MASTER5/sky114
{
	qer_editorImage skpk/qer/env/banana/sky114.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 0.74902 0.282353 60 7 19 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/banana/sky114 - -
}

textures/skies_MASTER5/sky115
{
	qer_editorImage skpk/qer/env/banana/sky115.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 0.682017 0.365484 70 0 90 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/banana/sky115 - -
}

textures/skies_MASTER5/sky116
{
	qer_editorImage skpk/qer/env/banana/sky116.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.983474 0.902968 0.54377 30 0 0 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 95 4
	nopicmip
	skyparms skpk/env/banana/sky116 - -
}

textures/skies_MASTER5/sky117
{
	qer_editorImage skpk/qer/env/banana/sky117.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.983459 0.816266 0.543755 30 0 0 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 95 4
	nopicmip
	skyparms skpk/env/banana/sky117 - -
}

textures/skies_MASTER5/sky118
{
	qer_editorImage skpk/qer/env/banana/sky118.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 0.719051 0.399466 45 14 8 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 80 4
	nopicmip
	skyparms skpk/env/banana/sky118 - -
}

textures/skies_MASTER5/sky119
{
	qer_editorImage skpk/qer/env/banana/sky119.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 130 4
	nopicmip
	skyparms skpk/env/banana/sky119 - -
}

textures/skies_MASTER5/sky120
{
	qer_editorImage skpk/qer/env/banana/sky120.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyparms skpk/env/banana/sky120 - -
}

textures/skies_MASTER5/sky121
{
	qer_editorImage skpk/qer/env/banana/sky121.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.982025 0.790234 0.572076 40 1 0 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 85 4
	nopicmip
	skyparms skpk/env/banana/sky121 - -
}

textures/skies_MASTER5/sky122
{
	qer_editorImage skpk/qer/env/banana/sky122.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.982025 0.790234 0.572076 65 -179 23 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 60 4
	nopicmip
	skyparms skpk/env/banana/sky122 - -
}

textures/skies_MASTER5/sky123
{
	qer_editorImage skpk/qer/env/banana/sky123.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyparms skpk/env/banana/sky123 - -
}

textures/skies_MASTER5/sky124
{
	qer_editorImage skpk/qer/env/banana/sky124.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.993133 0.74519 0.349981 65 92 25 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 80 4
	nopicmip
	skyparms skpk/env/banana/sky124 - -
}

textures/skies_MASTER5/sky125
{
	qer_editorImage skpk/qer/env/banana/sky125.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.986206 0.847501 0.637461 35 91 8 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/banana/sky125 - -
}

textures/skies_MASTER5/sky126
{
	qer_editorImage skpk/qer/env/banana/sky126.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.993133 0.74519 0.349981 35 91 8 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 90 4
	nopicmip
	skyparms skpk/env/banana/sky126 - -
}

textures/skies_MASTER5/sky127
{
	qer_editorImage skpk/qer/env/banana/sky127.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.993133 0.74519 0.349981 35 89 6 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 90 4
	nopicmip
	skyparms skpk/env/banana/sky127 - -
}

textures/skies_MASTER5/sky128
{
	qer_editorImage skpk/qer/env/banana/sky128.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.989548 0.763119 0.402136 35 -159 6 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 90 4
	nopicmip
	skyparms skpk/env/banana/sky128 - -
}

textures/skies_MASTER5/sky129
{
	qer_editorImage skpk/qer/env/banana/sky129.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyparms skpk/env/banana/sky129 - -
}

textures/skies_MASTER5/sky130
{
	qer_editorImage skpk/qer/env/banana/sky130.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 0.755077 0.505928 40 0 0 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/banana/sky130 - -
}

textures/skies_MASTER5/sky131
{
	qer_editorImage skpk/qer/env/banana/sky131.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 55 0 33 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/banana/sky131 - -
}

textures/skies_MASTER5/sky132
{
	qer_editorImage skpk/qer/env/banana/sky132.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 0.755062 0.505913 35 0 17 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 90 4
	nopicmip
	skyparms skpk/env/banana/sky132 - -
}

textures/skies_MASTER5/sky133
{
	qer_editorImage skpk/qer/env/banana/sky133.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.983749 0.654704 0.381888 40 89 30 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 75 4
	nopicmip
	skyparms skpk/env/banana/sky133 - -
}

textures/skies_MASTER5/sky134
{
	qer_editorImage skpk/qer/env/banana/sky134.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyparms skpk/env/banana/sky134 - -
}

textures/skies_MASTER5/sky135
{
	qer_editorImage skpk/qer/env/banana/sky135.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.983734 0.713756 0.381888 40 177 7 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 75 4
	nopicmip
	skyparms skpk/env/banana/sky135 - -
}

textures/skies_MASTER5/sky136
{
	qer_editorImage skpk/qer/env/banana/sky136.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyparms skpk/env/banana/sky136 - -
}

textures/skies_MASTER5/sky137
{
	qer_editorImage skpk/qer/env/banana/sky137.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyparms skpk/env/banana/sky137 - -
}

textures/skies_MASTER5/sky138
{
	qer_editorImage skpk/qer/env/banana/sky138.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 145 4
	nopicmip
	skyparms skpk/env/banana/sky138 - -
}

textures/skies_MASTER5/sky138a
{
	qer_editorImage skpk/qer/env/banana/sky138a.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyparms skpk/env/banana/sky138a - -
}

textures/skies_MASTER5/sky139
{
	qer_editorImage skpk/qer/env/banana/sky139.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 125 4
	nopicmip
	skyparms skpk/env/banana/sky139 - -
}

textures/skies_MASTER5/sky139a
{
	qer_editorImage skpk/qer/env/banana/sky139a.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 0.90692 0.706264 30 -117 7 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 80 4
	nopicmip
	skyparms skpk/env/banana/sky139a - -
}

textures/skies_MASTER5/sky140
{
	qer_editorImage skpk/qer/env/banana/sky140.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 140 4
	nopicmip
	skyparms skpk/env/banana/sky140 - -
}

textures/skies_MASTER5/sky141
{
	qer_editorImage skpk/qer/env/banana/sky141.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 0.848783 0.522805 30 25 15 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 95 4
	nopicmip
	skyparms skpk/env/banana/sky141 - -
}

textures/skies_MASTER5/sky142
{
	qer_editorImage skpk/qer/env/banana/sky142.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 130 4
	nopicmip
	skyparms skpk/env/banana/sky142 - -
}

textures/skies_MASTER5/sky143
{
	qer_editorImage skpk/qer/env/banana/sky143.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.992157 0.698039 0.690196 70 -85 18 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/banana/sky143 - -
}

textures/skies_MASTER5/sky144
{
	qer_editorImage skpk/qer/env/banana/sky144.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyparms skpk/env/banana/sky144 - -
}

textures/skies_MASTER5/sky145
{
	qer_editorImage skpk/qer/env/banana/sky145.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 130 4
	nopicmip
	skyparms skpk/env/banana/sky145 - -
}

textures/skies_MASTER5/sky147
{
	qer_editorImage skpk/qer/env/banana/sky147.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 35 -162 10 2 16
	q3map_sunExt 1 1 1 35 36 6 2 16
	q3map_sunExt 1 0.58941 0.301778 85 0 28 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/banana/sky147 - -
}

textures/skies_MASTER5/sky148
{
	qer_editorImage skpk/qer/env/banana/sky148.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 145 4
	nopicmip
	skyparms skpk/env/banana/sky148 - -
}

textures/skies_MASTER5/sky149
{
	qer_editorImage skpk/qer/env/banana/sky149.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.766964 1 1 35 -17 18 2 16
	q3map_sunExt 1 0.606714 0.889158 40 -31 24 2 16
	q3map_sunExt 0.766964 1 1 35 171 21 2 16
	q3map_sunExt 1 0.606714 0.889158 40 -157 11 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/banana/sky149 - -
}

textures/skies_MASTER5/sky150
{
	qer_editorImage skpk/qer/env/banana/sky150.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 0.801068 0.606714 40 89 22 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 85 4
	nopicmip
	skyparms skpk/env/banana/sky150 - -
}

textures/skies_MASTER5/sky150day
{
	qer_editorImage skpk/qer/env/banana/sky150day.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 60 90 22 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 65 4
	nopicmip
	skyparms skpk/env/banana/sky150day - -
}

textures/skies_MASTER5/sky151
{
	qer_editorImage skpk/qer/env/banana/sky151.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 140 4
	nopicmip
	skyparms skpk/env/banana/sky151 - -
}

textures/skies_MASTER5/sky152
{
	qer_editorImage skpk/qer/env/banana/sky152.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 50 -91 33 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 75 4
	nopicmip
	skyparms skpk/env/banana/sky152 - -
}

textures/skies_MASTER5/sky153
{
	qer_editorImage skpk/qer/env/banana/sky153.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyparms skpk/env/banana/sky153 - -
}

textures/skies_MASTER5/sky154
{
	qer_editorImage skpk/qer/env/banana/sky154.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 140 4
	nopicmip
	skyparms skpk/env/banana/sky154 - -
}

textures/skies_MASTER5/sky155
{
	qer_editorImage skpk/qer/env/banana/sky155.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 140 4
	nopicmip
	skyparms skpk/env/banana/sky155 - -
}

textures/skies_MASTER5/sky156
{
	qer_editorImage skpk/qer/env/banana/sky156.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 130 4
	nopicmip
	skyparms skpk/env/banana/sky156 - -
}

textures/skies_MASTER5/sky157
{
	qer_editorImage skpk/qer/env/banana/sky157.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.951965 0.69398 0.375784 40 99 19 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 85 4
	nopicmip
	skyparms skpk/env/banana/sky157 - -
}

textures/skies_MASTER5/sky158
{
	qer_editorImage skpk/qer/env/banana/sky158.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 125 4
	nopicmip
	skyparms skpk/env/banana/sky158 - -
}

textures/skies_MASTER5/sky159
{
	qer_editorImage skpk/qer/env/banana/sky159.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 125 4
	nopicmip
	skyparms skpk/env/banana/sky159 - -
}

textures/skies_MASTER5/sky161
{
	qer_editorImage skpk/qer/env/banana/sky161.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 145 4
	nopicmip
	skyparms skpk/env/banana/sky161 - -
}

textures/skies_MASTER5/sky161s
{
	qer_editorImage skpk/qer/env/banana/sky161s.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 130 4
	nopicmip
	skyparms skpk/env/banana/sky161s - -
}

textures/skies_MASTER5/sky162
{
	qer_editorImage skpk/qer/env/banana/sky162.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 125 4
	nopicmip
	skyparms skpk/env/banana/sky162 - -
}

textures/skies_MASTER5/sky163
{
	qer_editorImage skpk/qer/env/banana/sky163.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyparms skpk/env/banana/sky163 - -
}

textures/skies_MASTER5/sky164
{
	qer_editorImage skpk/qer/env/banana/sky164.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 130 4
	nopicmip
	skyparms skpk/env/banana/sky164 - -
}

textures/skies_MASTER5/sky165
{
	qer_editorImage skpk/qer/env/banana/sky165.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 140 4
	nopicmip
	skyparms skpk/env/banana/sky165 - -
}

textures/skies_MASTER5/sky166
{
	qer_editorImage skpk/qer/env/banana/sky166.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 35 174 3 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 90 4
	nopicmip
	skyparms skpk/env/banana/sky166 - -
}

textures/skies_MASTER5/sky167
{
	qer_editorImage skpk/qer/env/banana/sky167.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyparms skpk/env/banana/sky167 - -
}

textures/skies_MASTER5/sky168
{
	qer_editorImage skpk/qer/env/banana/sky168.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.98584 0.63859 0.231861 65 -14 18 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/banana/sky168 - -
}

textures/skies_MASTER5/sky169
{
	qer_editorImage skpk/qer/env/banana/sky169.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 140 4
	nopicmip
	skyparms skpk/env/banana/sky169 - -
}

textures/skies_MASTER5/sky170
{
	qer_editorImage skpk/qer/env/banana/sky170.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 125 4
	nopicmip
	skyparms skpk/env/banana/sky170 - -
}

textures/skies_MASTER5/sky171
{
	qer_editorImage skpk/qer/env/banana/sky171.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 0.801175 0.515801 50 -89 26 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 80 4
	nopicmip
	skyparms skpk/env/banana/sky171 - -
}

textures/skies_MASTER5/sky172
{
	qer_editorImage skpk/qer/env/banana/sky172.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 0.878431 0.407843 35 -84 20 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 105 4
	nopicmip
	skyparms skpk/env/banana/sky172 - -
}

textures/skies_MASTER5/sky173
{
	qer_editorImage skpk/qer/env/banana/sky173.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 50 0 27 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 105 4
	nopicmip
	skyparms skpk/env/banana/sky173 - -
}

textures/skies_MASTER5/sky174
{
	qer_editorImage skpk/qer/env/banana/sky174.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyparms skpk/env/banana/sky174 - -
}

textures/skies_MASTER5/sky175
{
	qer_editorImage skpk/qer/env/banana/sky175.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 130 4
	nopicmip
	skyparms skpk/env/banana/sky175 - -
}

textures/skies_MASTER5/sky176
{
	qer_editorImage skpk/qer/env/banana/sky176.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 140 4
	nopicmip
	skyparms skpk/env/banana/sky176 - -
}

textures/skies_MASTER5/sky177
{
	qer_editorImage skpk/qer/env/banana/sky177.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyparms skpk/env/banana/sky177 - -
}

textures/skies_MASTER5/sky178
{
	qer_editorImage skpk/qer/env/banana/sky178.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 140 4
	nopicmip
	skyparms skpk/env/banana/sky178 - -
}

textures/skies_MASTER5/sky179
{
	qer_editorImage skpk/qer/env/banana/sky179.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyparms skpk/env/banana/sky179 - -
}

textures/skies_MASTER5/sky180
{
	qer_editorImage skpk/qer/env/banana/sky180.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 140 4
	nopicmip
	skyparms skpk/env/banana/sky180 - -
}

textures/skies_MASTER5/sky181
{
	qer_editorImage skpk/qer/env/banana/sky181.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.999771 0.906401 0.732723 35 -154 14 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 100 4
	nopicmip
	skyparms skpk/env/banana/sky181 - -
}

textures/skies_MASTER5/sky182
{
	qer_editorImage skpk/qer/env/banana/sky182.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.957351 0.752789 0.37232 35 -40 6 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 100 4
	nopicmip
	skyparms skpk/env/banana/sky182 - -
}

textures/skies_MASTER5/sky183
{
	qer_editorImage skpk/qer/env/banana/sky183.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 140 4
	nopicmip
	skyparms skpk/env/banana/sky183 - -
}

textures/skies_MASTER5/sky184
{
	qer_editorImage skpk/qer/env/banana/sky184.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 40 -38 33 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 95 4
	nopicmip
	skyparms skpk/env/banana/sky184 - -
}

textures/skies_MASTER5/sky185
{
	qer_editorImage skpk/qer/env/banana/sky185.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 140 4
	nopicmip
	skyparms skpk/env/banana/sky185 - -
}

textures/skies_MASTER5/sky186
{
	qer_editorImage skpk/qer/env/banana/sky186.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyparms skpk/env/banana/sky186 - -
}

textures/skies_MASTER5/sky187
{
	qer_editorImage skpk/qer/env/banana/sky187.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 145 4
	nopicmip
	skyparms skpk/env/banana/sky187 - -
}

textures/skies_MASTER5/sky190
{
	qer_editorImage skpk/qer/env/banana/sky190.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.997925 0.839017 0.491173 45 8 3 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 95 4
	nopicmip
	skyparms skpk/env/banana/sky190 - -
}

textures/skies_MASTER5/sky191-2
{
	qer_editorImage skpk/qer/env/banana/sky191-2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.939437 0.73228 0.298711 55 64 26 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 80 4
	nopicmip
	skyparms skpk/env/banana/sky191-2 - -
}

textures/skies_MASTER5/sky191
{
	qer_editorImage skpk/qer/env/banana/sky191.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 125 4
	nopicmip
	skyparms skpk/env/banana/sky191 - -
}

textures/skies_MASTER5/sky192
{
	qer_editorImage skpk/qer/env/banana/sky192.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.939437 0.582391 0.298711 55 54 10 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 80 4
	nopicmip
	skyparms skpk/env/banana/sky192 - -
}

textures/skies_MASTER5/sky200
{
	qer_editorImage skpk/qer/env/banana/sky200.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.957137 0.650645 0.407141 40 109 7 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 110 4
	nopicmip
	skyparms skpk/env/banana/sky200 - -
}

textures/skies_MASTER5/sky302
{
	qer_editorImage skpk/qer/env/banana/sky302.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.990494 0.871656 0.651102 55 64 3 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 80 4
	nopicmip
	skyparms skpk/env/banana/sky302 - -
}

textures/skies_MASTER5/sky303
{
	qer_editorImage skpk/qer/env/banana/sky303.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 55 -70 24 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 80 4
	nopicmip
	skyparms skpk/env/banana/sky303 - -
}

textures/skies_MASTER5/sky_001
{
	qer_editorImage skpk/qer/env/banana/sky_001.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyparms skpk/env/banana/sky_001 - -
}

textures/skies_MASTER5/sky_79
{
	qer_editorImage skpk/qer/env/banana/sky_79.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.990494 0.920226 0.651087 65 9.8 4 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 85 4
	nopicmip
	skyparms skpk/env/banana/sky_79 - -
}

textures/skies_MASTER5/sky_ascend01
{
	qer_editorImage skpk/qer/env/banana/sky_ascend01.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.990494 0.776013 0.651072 40 80 2 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 90 4
	nopicmip
	skyparms skpk/env/banana/sky_ascend01 - -
}

textures/skies_MASTER5/sky_aurora_
{
	qer_editorImage skpk/qer/env/banana/sky_aurora_.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 45 88 3 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 95 4
	nopicmip
	skyparms skpk/env/banana/sky_aurora_ - -
}

textures/skies_MASTER5/sky_aurora
{
	qer_editorImage skpk/qer/env/banana/sky_aurora.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 140 4
	nopicmip
	skyparms skpk/env/banana/sky_aurora - -
}

textures/skies_MASTER5/sky_blue
{
	qer_editorImage skpk/qer/env/banana/sky_blue.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 145 4
	nopicmip
	skyparms skpk/env/banana/sky_blue - -
}

textures/skies_MASTER5/sky_day1
{
	qer_editorImage skpk/qer/env/banana/sky_day1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.990494 0.90808 0.651072 60 99 13 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/banana/sky_day1 - -
}

textures/skies_MASTER5/sky_day2
{
	qer_editorImage skpk/qer/env/banana/sky_day2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyparms skpk/env/banana/sky_day2 - -
}

textures/skies_MASTER5/sky_day3
{
	qer_editorImage skpk/qer/env/banana/sky_day3.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.990494 0.90808 0.651072 85 153 13 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/banana/sky_day3 - -
}

textures/skies_MASTER5/sky_day4
{
	qer_editorImage skpk/qer/env/banana/sky_day4.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 60 18 12 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 85 4
	nopicmip
	skyparms skpk/env/banana/sky_day4 - -
}

textures/skies_MASTER5/sky_gta5
{
	qer_editorImage skpk/qer/env/banana/sky_gta5.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.992279 0.858061 0.439536 55 154 8 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 100 4
	nopicmip
	skyparms skpk/env/banana/sky_gta5 - -
}

textures/skies_MASTER5/sky_halloween
{
	qer_editorImage skpk/qer/env/banana/sky_halloween.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.930892 0.566903 0.247898 85 89 29 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/banana/sky_halloween - -
}

textures/skies_MASTER5/sky_kc_105
{
	qer_editorImage skpk/qer/env/banana/sky_kc_105.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 152 77 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/banana/sky_kc_105 - -
}

textures/skies_MASTER5/sky_l
{
	qer_editorImage skpk/qer/env/banana/sky_l.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 0.721843 0.478065 40 -70 3 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 95 4
	nopicmip
	skyparms skpk/env/banana/sky_l - -
}

textures/skies_MASTER5/sky_moon
{
	qer_editorImage skpk/qer/env/banana/sky_moon.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 50 178 26 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 80 4
	nopicmip
	skyparms skpk/env/banana/sky_moon - -
}

textures/skies_MASTER5/sky_moonlight01
{
	qer_editorImage skpk/qer/env/banana/sky_moonlight01.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 45 155 22 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 95 4
	nopicmip
	skyparms skpk/env/banana/sky_moonlight01 - -
}

textures/skies_MASTER5/sky_morning
{
	qer_editorImage skpk/qer/env/banana/sky_morning.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 60 -93 26 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 85 4
	nopicmip
	skyparms skpk/env/banana/sky_morning - -
}

textures/skies_MASTER5/sky_nightstorm
{
	qer_editorImage skpk/qer/env/banana/sky_nightstorm.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 30 95 15 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 125 4
	nopicmip
	skyparms skpk/env/banana/sky_nightstorm - -
}

textures/skies_MASTER5/sky_oblivion
{
	qer_editorImage skpk/qer/env/banana/sky_oblivion.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 104 39 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/banana/sky_oblivion - -
}

textures/skies_MASTER5/sky_oblivion2
{
	qer_editorImage skpk/qer/env/banana/sky_oblivion2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 -33 58 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/banana/sky_oblivion2 - -
}

textures/skies_MASTER5/sky_oblivion3
{
	qer_editorImage skpk/qer/env/banana/sky_oblivion3.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 92 59 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/banana/sky_oblivion3 - -
}

textures/skies_MASTER5/sky_orange
{
	qer_editorImage skpk/qer/env/banana/sky_orange.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.945357 0.740993 0.361746 55 -79 16 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 105 4
	nopicmip
	skyparms skpk/env/banana/sky_orange - -
}

textures/skies_MASTER5/sky_purple
{
	qer_editorImage skpk/qer/env/banana/sky_purple.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 140 4
	nopicmip
	skyparms skpk/env/banana/sky_purple - -
}

textures/skies_MASTER5/sky_rainbow
{
	qer_editorImage skpk/qer/env/banana/sky_rainbow.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyparms skpk/env/banana/sky_rainbow - -
}

textures/skies_MASTER5/sky_space
{
	qer_editorImage skpk/qer/env/banana/sky_space.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 60 -60 86 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 85 4
	nopicmip
	skyparms skpk/env/banana/sky_space - -
}

textures/skies_MASTER5/sky_starfield
{
	qer_editorImage skpk/qer/env/banana/sky_starfield.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 30 0 90 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyparms skpk/env/banana/sky_starfield - -
}

textures/skies_MASTER5/sky_storm
{
	qer_editorImage skpk/qer/env/banana/sky_storm.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 30 92 18 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyparms skpk/env/banana/sky_storm - -
}

textures/skies_MASTER5/sky_sunset2
{
	qer_editorImage skpk/qer/env/banana/sky_sunset2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 150 25 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/banana/sky_sunset2 - -
}

textures/skies_MASTER5/sky_sunset
{
	qer_editorImage skpk/qer/env/banana/sky_sunset.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.947005 0.652125 0.329305 30 13 3 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 125 4
	nopicmip
	skyparms skpk/env/banana/sky_sunset - -
}

textures/skies_MASTER5/sky_universe
{
	qer_editorImage skpk/qer/env/banana/sky_universe.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.661051 0.950134 0.939818 70 -148 26 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 85 4
	nopicmip
	skyparms skpk/env/banana/sky_universe - -
}

textures/skies_MASTER5/sky_vaga01
{
	qer_editorImage skpk/qer/env/banana/sky_vaga01.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.992157 0.816098 0.309804 85 43 6 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/banana/sky_vaga01 - -
}

textures/skies_MASTER5/sky_wave
{
	qer_editorImage skpk/qer/env/banana/sky_wave.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 140 4
	nopicmip
	skyparms skpk/env/banana/sky_wave - -
}

textures/skies_MASTER5/sky_z
{
	qer_editorImage skpk/qer/env/banana/sky_z.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.985061 0.785885 0.449973 45 25 7 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 110 4
	nopicmip
	skyparms skpk/env/banana/sky_z - -
}

textures/skies_MASTER5/skybox_battleblock
{
	qer_editorImage skpk/qer/env/banana/skybox_battleblock.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 125 4
	nopicmip
	skyparms skpk/env/banana/skybox_battleblock - -
}

textures/skies_MASTER5/snowy_day
{
	qer_editorImage skpk/qer/env/banana/snowy_day.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 40 -23 17 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 105 4
	nopicmip
	skyparms skpk/env/banana/snowy_day - -
}

textures/skies_MASTER5/space-2
{
	qer_editorImage skpk/qer/env/banana/space-2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 125 4
	nopicmip
	skyparms skpk/env/banana/space-2 - -
}

textures/skies_MASTER5/space-3
{
	qer_editorImage skpk/qer/env/banana/space-3.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 140 4
	nopicmip
	skyparms skpk/env/banana/space-3 - -
}

textures/skies_MASTER5/space1
{
	qer_editorImage skpk/qer/env/banana/space1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 0 90 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/banana/space1 - -
}

textures/skies_MASTER5/space3
{
	qer_editorImage skpk/qer/env/banana/space3.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 140 4
	nopicmip
	skyparms skpk/env/banana/space3 - -
}

textures/skies_MASTER3/ghost_sky_18-saturated
{
	qer_editorImage skpk/qer/env/banana/space/sky1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 0.805676 0.967605 40 -88 27 2 16
	q3map_sunExt 0.695247 1 1 60 49 13 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 85 4
	nopicmip
	skyparms skpk/env/banana/space/sky1 - -
}

textures/skies_MASTER5/space_sky2
{
	qer_editorImage skpk/qer/env/banana/space/sky2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 145 4
	nopicmip
	skyparms skpk/env/banana/space/sky2 - -
}

textures/skies_MASTER5/space_sky3
{
	qer_editorImage skpk/qer/env/banana/space/sky3.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 140 4
	nopicmip
	skyparms skpk/env/banana/space/sky3 - -
}

textures/skies_MASTER5/space_sky4
{
	qer_editorImage skpk/qer/env/banana/space/sky4.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 65 120 23 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 90 4
	nopicmip
	skyparms skpk/env/banana/space/sky4 - -
}

textures/skies_MASTER5/space_sky5
{
	qer_editorImage skpk/qer/env/banana/space/sky5.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 130 4
	nopicmip
	skyparms skpk/env/banana/space/sky5 - -
}

textures/skies_MASTER5/space_sky6
{
	qer_editorImage skpk/qer/env/banana/space/sky6.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 45 -178 40 2 16
	q3map_sunExt 1 1 1 45 35 23 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/banana/space/sky6 - -
}

textures/skies_MASTER5/space01
{
	qer_editorImage skpk/qer/env/banana/space_01.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 45 -112 72 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 110 4
	nopicmip
	skyparms skpk/env/banana/space_01 - -
}

textures/skies_MASTER5/space_01
{
	qer_editorImage skpk/qer/env/banana/space_1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 60 102 72 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 95 4
	nopicmip
	skyparms skpk/env/banana/space_1 - -
}

textures/skies_MASTER5/space_02
{
	qer_editorImage skpk/qer/env/banana/space_2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 0 3 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/banana/space_2 - -
}

textures/skies_MASTER5/space_03
{
	qer_editorImage skpk/qer/env/banana/space_3.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.979156 0.824704 0.668147 85 16 18 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/banana/space_3 - -
}

textures/skies_MASTER5/space_04
{
	qer_editorImage skpk/qer/env/banana/space_4.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.668147 0.917311 0.979141 55 -127 61 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 100 4
	nopicmip
	skyparms skpk/env/banana/space_4 - -
}

textures/skies_MASTER5/space_05
{
	qer_editorImage skpk/qer/env/banana/space_5.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 0.622766 0.426596 45 -115 63 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 110 4
	nopicmip
	skyparms skpk/env/banana/space_5 - -
}

textures/skies_MASTER5/space_06
{
	qer_editorImage skpk/qer/env/banana/space_6.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 -90 0 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/banana/space_6 - -
}

textures/skies_MASTER5/space_07
{
	qer_editorImage skpk/qer/env/banana/space_7.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 145 4
	nopicmip
	skyparms skpk/env/banana/space_7 - -
}

textures/skies_MASTER5/space_08
{
	qer_editorImage skpk/qer/env/banana/space_8.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 174 13 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/banana/space_8 - -
}

textures/skies_MASTER5/space_09
{
	qer_editorImage skpk/qer/env/banana/space_9.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 65 101 56 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 90 4
	nopicmip
	skyparms skpk/env/banana/space_9 - -
}

textures/skies_MASTER5/space_10
{
	qer_editorImage skpk/qer/env/banana/space_10.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.606394 0.975937 1 60 -175 73 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 95 4
	nopicmip
	skyparms skpk/env/banana/space_10 - -
}

textures/skies_MASTER5/space_11
{
	qer_editorImage skpk/qer/env/banana/space_11.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 50 47 29 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 95 4
	nopicmip
	skyparms skpk/env/banana/space_11 - -
}

textures/skies_MASTER5/space_12
{
	qer_editorImage skpk/qer/env/banana/space_12.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 40 -112 77 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms skpk/env/banana/space_12 - -
}

textures/skies_MASTER5/space_13
{
	qer_editorImage skpk/qer/env/banana/space_13.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 55 -37 61 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 105 4
	nopicmip
	skyparms skpk/env/banana/space_13 - -
}

textures/skies_MASTER5/space_14
{
	qer_editorImage skpk/qer/env/banana/space_14.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.699153 0.981613 1 45 178 20 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 110 4
	nopicmip
	skyparms skpk/env/banana/space_14 - -
}

textures/skies_MASTER5/space_15
{
	qer_editorImage skpk/qer/env/banana/space_15.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 75 123 45 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 80 4
	nopicmip
	skyparms skpk/env/banana/space_15 - -
}

textures/skies_MASTER5/space_16
{
	qer_editorImage skpk/qer/env/banana/space_16.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.970977 0.684916 0.421103 60 63 63 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 95 4
	nopicmip
	skyparms skpk/env/banana/space_16 - -
}

textures/skies_MASTER5/space_17
{
	qer_editorImage skpk/qer/env/banana/space_17.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 140 4
	nopicmip
	skyparms skpk/env/banana/space_17 - -
}

textures/skies_MASTER5/space_18
{
	qer_editorImage skpk/qer/env/banana/space_18.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.668162 0.979171 0.961074 45 -159 38 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 110 4
	nopicmip
	skyparms skpk/env/banana/space_18 - -
}

textures/skies_MASTER5/space_19
{
	qer_editorImage skpk/qer/env/banana/space_19.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyparms skpk/env/banana/space_19 - -
}

textures/skies_MASTER5/space_20
{
	qer_editorImage skpk/qer/env/banana/space_20.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.998215 0.990662 0.700755 85 33 1 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/banana/space_20 - -
}

textures/skies_MASTER5/space_22
{
	qer_editorImage skpk/qer/env/banana/space_22.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 140 4
	nopicmip
	skyparms skpk/env/banana/space_22 - -
}

textures/skies_MASTER5/space_26
{
	qer_editorImage skpk/qer/env/banana/space_26.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyparms skpk/env/banana/space_26 - -
}

textures/skies_MASTER5/space_30
{
	qer_editorImage skpk/qer/env/banana/space_30.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyparms skpk/env/banana/space_30 - -
}

textures/skies_MASTER5/halo_sky
{
	qer_editorImage skpk/qer/env/banana/space.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 45 -123 31 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 100 4
	nopicmip
	skyparms skpk/env/banana/space - -
}

textures/skies_MASTER5/spongebob
{
	qer_editorImage skpk/qer/env/banana/spongebob.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 150 4
	nopicmip
	skyparms skpk/env/banana/spongebob - -
}

textures/skies_MASTER5/SPsky
{
	qer_editorImage skpk/qer/env/banana/SPsky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 125 4
	nopicmip
	skyparms skpk/env/banana/SPsky - -
}

textures/skies_MASTER5/starrynight
{
	qer_editorImage skpk/qer/env/banana/starrynight.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 140 4
	nopicmip
	skyparms skpk/env/banana/starrynight - -
}

textures/skies_MASTER5/stars01
{
	qer_editorImage skpk/qer/env/banana/stars01.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyparms skpk/env/banana/stars01 - -
}

textures/skies_MASTER5/starwars
{
	qer_editorImage skpk/qer/env/banana/starwars.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 140 4
	nopicmip
	skyparms skpk/env/banana/starwars - -
}

textures/skies_MASTER5/storm
{
	qer_editorImage skpk/qer/env/banana/storm.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyparms skpk/env/banana/storm - -
}

textures/skies_MASTER5/stormymountain
{
	qer_editorImage skpk/qer/env/banana/stormymountain.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 140 4
	nopicmip
	skyparms skpk/env/banana/stormymountain - -
}

textures/skies_MASTER5/stranded
{
	qer_editorImage skpk/qer/env/banana/stranded.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 140 4
	nopicmip
	skyparms skpk/env/banana/stranded - -
}

textures/skies_MASTER5/Sunset2
{
	qer_editorImage skpk/qer/env/banana/Sunset2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.992889 0.694026 0.388891 85 60 24 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/banana/Sunset2 - -
}

textures/skies_MASTER5/sunset_
{
	qer_editorImage skpk/qer/env/banana/sunset_.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 145 4
	nopicmip
	skyparms skpk/env/banana/sunset_ - -
}

textures/skies_MASTER5/sunset
{
	qer_editorImage skpk/qer/env/banana/sunset.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 0.675761 0.300313 85 -6 6 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/banana/sunset - -
}

textures/skies_MASTER5/sunsetmountain
{
	qer_editorImage skpk/qer/env/banana/sunsetmountain.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 0.969802 0.449744 85 22 14 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/banana/sunsetmountain - -
}

textures/skies_MASTER5/swampbox
{
	qer_editorImage skpk/qer/env/banana/swampbox.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 59 24 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/banana/swampbox - -
}

textures/skies_MASTER5/SwirlyClouds
{
	qer_editorImage skpk/qer/env/banana/SwirlyClouds.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 6 32 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/banana/SwirlyClouds - -
}

textures/skies_MASTER5/turquoise
{
	qer_editorImage skpk/qer/env/banana/turquoise.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 40 58 24 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms skpk/env/banana/turquoise - -
}

textures/skies_MASTER5/Undersea
{
	qer_editorImage skpk/qer/env/banana/Undersea.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 155 4
	nopicmip
	skyparms skpk/env/banana/Undersea - -
}

textures/skies_MASTER5/Underwater
{
	qer_editorImage skpk/qer/env/banana/Underwater.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.487312 0.996567 0.996567 35 25 60 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 125 4
	nopicmip
	skyparms skpk/env/banana/Underwater - -
}

textures/skies_MASTER5/volcano
{
	qer_editorImage skpk/qer/env/banana/volcano.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 0.665965 0 70 128 40 2 16
	q3map_sunExt 1 0.665965 0 70 -141 9 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 95 4
	nopicmip
	skyparms skpk/env/banana/volcano - -
}

textures/skies_MASTER5/water
{
	qer_editorImage skpk/qer/env/banana/water.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 40 -45 59 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms skpk/env/banana/water - -
}

textures/skies_MASTER5/Whale
{
	qer_editorImage skpk/qer/env/banana/Whale.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 130 4
	nopicmip
	skyparms skpk/env/banana/Whale - -
}

textures/skies_MASTER5/WhiteDwarf
{
	qer_editorImage skpk/qer/env/banana/WhiteDwarf.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 45 -22 34 2 16
	q3map_sunExt 1 1 1 45 -160 23 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 95 4
	nopicmip
	skyparms skpk/env/banana/WhiteDwarf - -
}

textures/skies_MASTER5/winter1
{
	qer_editorImage skpk/qer/env/banana/winter1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 -29 15 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/banana/winter1 - -
}

textures/skies_MASTER5/winterplanet
{
	qer_editorImage skpk/qer/env/banana/winterplanet.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.980758 0.751339 0.54789 85 36 44 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/banana/winterplanet - -
}

textures/skies_MASTER5/x-mas
{
	qer_editorImage skpk/qer/env/banana/x-mas.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 145 4
	nopicmip
	skyparms skpk/env/banana/x-mas - -
}

textures/skies_MASTER6/0color_blue-cornflower
{
	qer_editorImage skpk/qer/env/banana/colors/color01.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 145 4
	nopicmip
	skyparms skpk/env/banana/colors/color01 - -
}

textures/skies_MASTER6/0color_purple
{
	qer_editorImage skpk/qer/env/banana/colors/color02.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 145 4
	nopicmip
	skyparms skpk/env/banana/colors/color02 - -
}

textures/skies_MASTER6/0color_purple-lilac
{
	qer_editorImage skpk/qer/env/banana/colors/color03.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 145 4
	nopicmip
	skyparms skpk/env/banana/colors/color03 - -
}

textures/skies_MASTER6/0color_pink-rose
{
	qer_editorImage skpk/qer/env/banana/colors/color04.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 145 4
	nopicmip
	skyparms skpk/env/banana/colors/color04 - -
}

textures/skies_MASTER6/0color_red-bean
{
	qer_editorImage skpk/qer/env/banana/colors/color05.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 145 4
	nopicmip
	skyparms skpk/env/banana/colors/color05 - -
}

textures/skies_MASTER6/0color_cyan-pale
{
	qer_editorImage skpk/qer/env/banana/colors/color06.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 145 4
	nopicmip
	skyparms skpk/env/banana/colors/color06 - -
}

textures/skies_MASTER6/0color_yellow
{
	qer_editorImage skpk/qer/env/banana/colors/color07.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 145 4
	nopicmip
	skyparms skpk/env/banana/colors/color07 - -
}

textures/skies_MASTER6/0color_green-turquoise
{
	qer_editorImage skpk/qer/env/banana/colors/color08.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 145 4
	nopicmip
	skyparms skpk/env/banana/colors/color08 - -
}

textures/skies_MASTER6/0color_green-pale
{
	qer_editorImage skpk/qer/env/banana/colors/color09.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 145 4
	nopicmip
	skyparms skpk/env/banana/colors/color09 - -
}

textures/skies_MASTER6/0color_orange-pale
{
	qer_editorImage skpk/qer/env/banana/colors/color10.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 145 4
	nopicmip
	skyparms skpk/env/banana/colors/color10 - -
}

//+ws

textures/skies_MASTER6/cardigan_stormyskyice
{
	qer_editorimage skpk/qer/6/cardigan_stormyskyice.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_lightRGB 1 1 1
	q3map_skylight 115 4 0 90 0
	nopicmip
	skyParms skpk/env/cardigan/purewhitej 1200 -
	{
		map skpk/textures/cardigan_skies1/circlegradlightningblur2.tga
		blendfunc add
		rgbGen wave noise 0 1 0 10
		tcMod scale 0.32 0.32
		tcMod rotate -20
	}
	{
		map skpk/textures/1anebu/stormyskyice.tga
		blendfunc filter
		tcMod scroll 0.05 0.06
	}
}

textures/skies_MASTER2/sky12
{
	qer_editorimage skpk/qer/textures/sky12/sky12.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_lightRGB 1 1 1
	q3map_skylight 115 4 0 90 0
	nopicmip
	skyparms skpk/textures/sky12/sky12 - -
}

textures/skies_MASTER2/asddeepspace
{
	qer_editorimage skpk/qer/env/asddeepspace/deepspace.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_lightRGB 1 1 1
	q3map_skylight 115 4 0 90 0
	nopicmip
	skyparms skpk/env/asddeepspace/deepspace - -
}

textures/skies_MASTER2/azlcmb1_jump
{
	qer_editorimage skpk/qer/env/azlcmb1_jumps/jump.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_lightRGB 1 1 1
	q3map_skylight 115 4 0 90 0
	nopicmip
	skyparms skpk/env/azlcmb1_jumps/jump - -
}

textures/skies_MASTER2/azlcmb1_pirate_land
{
	qer_editorimage skpk/qer/env/azlcmb1_pirate_land/pr.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 .997119 0.99 85 0 21 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/azlcmb1_pirate_land/pr - -
}

textures/skies_MASTER2/beijing
{
	qer_editorimage skpk/qer/textures/beijing/env/dark_night1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 115 4 0 90 0
	nopicmip
	skyParms skpk/textures/beijing/env/dark_night1 - -
}

textures/skies_MASTER6/0color_blue-deep
{
	qer_editorimage skpk/qer/env/bluesky/bluesky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 145 4
	nopicmip
	skyparms skpk/env/bluesky/bluesky - -
}

textures/skies_MASTER6/blx_new_sky
{
	qer_editorimage skpk/qer/6/blx_new_sky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 125 4
	nopicmip
	skyParms - 512 -
	{
		map skpk/textures/blx/new_sky.tga
		tcMod scale 8 8
		tcMod scroll 0.0 0.0
		depthWrite
	}
	{
		map skpk/textures/ikbase_sky/ik_sky_night_front.tga
		blendfunc add
		tcMod scale 2 2
		tcMod scroll 0.1 0.1
	}
}

textures/skies_MASTER2/bucovina
{
	qer_editorimage skpk/qer/env/bucovina_sky/bucovina.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyparms skpk/env/bucovina_sky/bucovina - -
}

textures/skies_MASTER2/cat_skybox
{
	qer_editorimage skpk/qer/envcat/skybox.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 125 4
	nopicmip
	skyparms skpk/envcat/skybox - -
}

textures/skies_MASTER2/cel_hell
{
	qer_editorimage skpk/qer/env/cel_hell/cel.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 140 4
	nopicmip
	skyparms skpk/env/cel_hell/cel - -
}

textures/skies_MASTER6/cemetery
{
	qer_editorimage skpk/qer/6/cemetery.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyparms skpk/textures/chili_skies/env/sky 2048 -
	{
		map skpk/textures/cemetery/sky_cem.tga
		tcMod scale 1 1
		tcMod scroll 0.005 -0.0125
		rgbGen identityLighting
	}
	{
		animMap .9 skpk/textures/chili_skies/thunderbolt_1.tga skpk/textures/colors/black.tga skpk/textures/colors/black.tga skpk/textures/chili_skies/thunderbolt_2.tga skpk/textures/chili_skies/thunderbolt_3.tga skpk/textures/colors/black.tga skpk/textures/colors/black.tga
		blendFunc add
		rgbGen identity
		rgbGen wave Sin 0 1 0 1.1
	}
}

textures/skies_MASTER/hip_inter-vibrant
{
	qer_editorimage skpk/qer/env/cerulean/cerulean.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 80 340 49 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/cerulean/cerulean 1024 -
}

textures/skies_MASTER6/sunset_ct3ctf1
{
	qer_editorimage skpk/qer/6/sunset_ct3ctf1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 125 4
	nopicmip
	skyparms - 1024 -
	{
		map skpk/textures/deception_sky/sky_clouds.tga
		tcMod scroll .03 .005
		tcmod scale 2 2
		rgbGen identityLighting
	}
	{
		map skpk/textures/ct3ctf1/env/clouds_02.tga
		tcMod scale 4 4
		tcMod scroll 0.05 0.05
		blendFunc GL_ONE GL_ONE
	}
}

textures/skies_MASTER6/daanstrafe01
{
	qer_editorimage skpk/qer/6/daanstrafe01.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 60 46 30 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/textures/skies/env/terra1 - -
	{
		map skpk/textures/qskies/meth_clouds2.tga
		blendfunc add
		tcMod scale 4 1
		tcMod scroll 0.07 0.09
	}
	{
		map skpk/textures/qskies/meth_clouds2.tga
		blendfunc add
		tcMod scale 15 13
		tcMod scroll .02 .01
	}
	{
		animMap 0.6 skpk/textures/skies/lightn_clouds1.tga skpk/textures/skies/lightn_clouds1.tga skpk/textures/skies/lightn_clouds1.tga skpk/textures/skies/lightn_clouds1.tga skpk/textures/skies/lightn_clouds2.tga skpk/textures/skies/lightn_clouds1.tga skpk/textures/skies/lightn_clouds1.tga skpk/textures/skies/lightn_clouds1.tga skpk/textures/skies/lightn_clouds1.tga skpk/textures/skies/lightn_clouds1.tga skpk/textures/skies/lightn_clouds1.tga skpk/textures/skies/lightn_clouds1.tga skpk/textures/skies/lightn_clouds1.tga skpk/textures/skies/lightn_clouds1.tga skpk/textures/skies/lightn_clouds1.tga skpk/textures/skies/lightn_clouds1.tga skpk/textures/skies/lightn_clouds1.tga skpk/textures/skies/lightn_clouds1.tga skpk/textures/skies/lightn_clouds1.tga skpk/textures/skies/lightn_clouds1.tga skpk/textures/skies/lightn_clouds1.tga skpk/textures/skies/lightn_clouds1.tga skpk/textures/skies/lightn_clouds1.tga
		blendfunc add
		rgbGen wave sin 0.1 0.3 0.2 1.4
		tcMod scale 12 8
		tcMod scroll .006 .004
	}
}

textures/skies_MASTER6/dc_q3tourney5
{
	qer_editorimage skpk/qer/6/dc_q3tourney5.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyparms - 768 -
	{
		map skpk/textures/skies/nightsky.tga
		rgbgen const ( 0.30 0.30 0.40 )
		tcmod scroll 0.01 0.05
		tcmod scale 4 4
		depthwrite
	}
	{
		map skpk/textures/skies/skylayer2.tga
		rgbgen const ( 0.32 0.30 0.27 )
		blendfunc add
		tcmod scroll 0.06 0.08
		tcmod scale 5 5
	}
}

textures/skies_MASTER6/dc_q3dm0
{
	qer_editorimage skpk/qer/6/dc_q3dm0.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_lightRGB 1 1 1
	q3map_skylight 115 4 0 90 0
	nopicmip
	skyparms - 512 -
	{
		map skpk/textures/skies/nightsky.tga
		rgbgen const ( 0.26 0.34 0.42 )
		tcmod scroll 0.01 0.05
		tcmod scale 4 4
		depthwrite
	}
	{
		map skpk/textures/skies/skylayer2.tga
		rgbgen const ( 0.40 0.23 0.05 )
		blendfunc add
		tcmod scroll 0.06 0.08
		tcmod scale 5 5
	}
}

textures/skies_MASTER6/dc_xmptourney1
{
	qer_editorimage skpk/qer/6/dc_xmptourney1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms - 768 -
	{
		map skpk/textures/skies/nightsky.tga
		rgbgen const ( 0.20 0.18 0.23 )
		tcmod scroll 0.01 0.05
		tcmod scale 4 4
		depthwrite
	}
	{
		map skpk/textures/skies/skylayer2.tga
		rgbgen const ( 0.07 0.05 0.09 )
		blendfunc add
		tcmod scroll 0.06 0.08
		tcmod scale 5 5
	}
}

textures/skies_MASTER6/dc_mptourney4
{
	qer_editorimage skpk/qer/6/dc_mptourney4.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 120 4
	nopicmip
	skyparms - 768 -
	{
		map skpk/textures/skies/nightsky.tga
		rgbgen const ( 0.18 0.20 0.30 )
		tcmod scroll 0.01 0.05
		tcmod scale 4 4
		depthwrite
	}
	{
		map skpk/textures/skies/skylayer2.tga
		rgbgen const ( 0.07 0.05 0.09 )
		blendfunc add
		tcmod scroll 0.06 0.08
		tcmod scale 5 5
	}
}

textures/skies_MASTER3/byss-violet
{
	qer_editorimage skpk/qer/textures/ddd_city/space.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.93521 0.614145 0.307286 45 -4 29 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyParms skpk/textures/ddd_city/space 512 -
}

textures/skies_MASTER6/deception
{
	qer_editorimage skpk/qer/6/deception.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt .7 .5 .3 70 36 23 3 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/textures/deception_sky/env/sky 1024 -
	{
		map skpk/textures/deception_sky/sky_clouds.tga
		tcMod scale 2 2
		tcMod scroll 0.002 -0.0100
		rgbGen identityLighting
	}
	{
		map skpk/textures/deception_sky/sky_arc_masked.tga
		blendFunc GL_ONE_MINUS_SRC_ALPHA GL_SRC_ALPHA
		tcMod transform 0.25 0 0 0.25 0.1075 0.1075
		rgbGen identityLighting
	}
}

textures/skies_MASTER6/dfwc2021_kabcorp
{
	qer_editorimage skpk/qer/6/dfwc2021_kabcorp.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 159 48 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/dfwc2021_kabcorp/dfwc2021_kabcorp_sky - -
	{
		map skpk/textures/dfwc2021_kabcorp/clouds.tga
		blendFunc add
		tcMod scale 8 8
		tcMod scroll 0.1 -0.2
		rgbGen wave sin 1 1 0 0
	}
}

textures/skies_MASTER6/toxicskytim_peej
{
	qer_editorimage skpk/qer/6/toxicskytim_peej.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 125 4
	nopicmip
	skyparms - 512 -
	{
		map skpk/textures/peej/inteldimclouds.tga
		tcMod scale 3 2
		tcMod scroll 0.01 0.02
		depthWrite
	}
	{
		map textures/skies/intelredclouds.tga
		blendFunc GL_ONE GL_ONE
		tcMod scale 3 3
		tcMod scroll 0.05 0.05
	}
}

textures/skies_MASTER6/ztnsky1_s3
{
	qer_editorimage skpk/qer/6/ztnsky1_s3.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_lightRGB 1 1 1
	q3map_skylight 120 4 0 90 0
	nopicmip
	skyparms - 512 -
	{
		map skpk/textures/ztn/bluesky2.tga
		tcMod scale 3 2
		tcMod scroll 0.15 0.15
		depthWrite
	}
	{
		map skpk/textures/ztn/bluesky1.tga
		blendFunc GL_ONE GL_ONE
		tcMod scale 3 3
		tcMod scroll 0.05 0.05
	}
}

textures/skies_MASTER2/c2nite-clouds
{
	qer_editorimage skpk/qer/env/c2nite-clouds.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 30 45 45 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/c2nite - -
	{
		map textures/skies/topclouds.tga
		blendFunc GL_ONE GL_ONE
		tcMod scale 3 3
		tcMod scroll 0.05 0.05
	}
}

textures/skies_MASTER2/eksha_noise1
{
	qer_editorimage skpk/qer/env/eksha_cruelSky/noise1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 120 5
	nopicmip
	skyparms skpk/env/eksha_cruelSky/noise1 - -
}

textures/skies_MASTER6/blx_wt3
{
	qer_editorimage skpk/qer/6/blx_wt3.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 125 4
	nopicmip
	skyParms - 512 -
	{
		map skpk/textures/blx_wtest3/blx_wt3_sky.tga
		rgbgen const ( .45 .45 .45 )
		tcMod scale 2 2
		tcMod scroll 0.1 0.1
		depthWrite
	}
	{
		map skpk/textures/blx_wtest3/blx_wt3_sky.tga
		rgbgen const ( .15 .15 .15 )
		blendfunc add
		tcMod scale 3 3
		tcMod scroll 0.2 0.2
	}
}

textures/skies_MASTER2/london-clouds
{
	qer_editorimage skpk/qer/env/london/london-clouds.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_lightRGB 0.380819 0.475959 0.500298
	q3map_skylight 115 4 0 90 0
	nopicmip
	skyParms skpk/env/london/london 128 -
	{
		map textures/skies/topclouds.tga
		blendfunc add
		tcMod scroll 0.05 0.06
		tcMod scale 3 2
	}
}

textures/skies_MASTER/hip_inter-dark
{
	qer_editorimage skpk/qer/textures/excejumps/skybox/space_sky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 80 340 49 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/textures/excejumps/skybox/space_sky - -
}

textures/skies_MASTER2/part_nightsky
{
	qer_editorimage skpk/qer/env/part_nightsky/sky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_lightRGB .8 .9 1
	q3map_skylight 130 4 0 90 0
	nopicmip
	skyparms skpk/env/part_nightsky/sky - -
}

textures/skies_MASTER2/part_blacksky
{
	qer_editorimage skpk/qer/env/part_blacksky/sky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_lightRGB .8 .9 1
	q3map_skylight 130 4 0 90 0
	nopicmip
	skyparms skpk/env/part_blacksky/sky - -
}

textures/skies_MASTER2/Laberinto2
{
	qer_editorimage skpk/qer/env/lab/islandsky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.953704 0.953704 0.638148 85 -29 25 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/lab/islandsky - -
}

textures/skies_MASTER6/0color_green-avocado
{
	qer_editorimage skpk/qer/textures/goodspeed-wfa/ravfog2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyParms skpk/textures/goodspeed-wfa/ravfog2 - -
}

textures/skies_MASTER/darkhollow-clouds
{
	qer_editorimage skpk/qer/env/darkhollow/darkhollow-clouds.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyparms skpk/env/darkhollow/darkhollow 512 -
	{
		map textures/skies/killsky_2.tga
		blendfunc GL_ONE GL_ONE
		tcMod scroll 0.05 0.06
		tcMod scale 3 2
	}
}

textures/skies_MASTER/hw_nightsky-dark
{
	qer_editorimage skpk/qer/textures/happyworldjumps_skies/nightsky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.537453 0.75642 0.901381 100 223 33 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/textures/happyworldjumps_skies/nightsky - -
}

textures/skies_MASTER6/cardigan_greenStars3
{
	qer_editorimage skpk/qer/6/cardigan_greenStars3.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 100 4
	nopicmip
	skyParms skpk/env/cardigan/purewhitej - -
	{
		map skpk/textures/cardigan_skies1/starfield2.tga
		blendfunc add
		rgbGen identity
		tcMod scroll -0.03 0.01
		tcMod scale 3 3
	}
	{
		map skpk/textures/happyworldjumps_skies/sparse_green_nebula.tga
		blendfunc filter
		tcMod scroll -0.05 0.02
	}
}

textures/skies_MASTER6/stencil_ciel
{
	qer_editorimage skpk/qer/6/stencil_ciel.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyparms - 512 -
	{
		map skpk/textures/citadelle/ciel01.tga
		tcMod scale 3 3
		tcMod scroll 0.0200 0.00200
	}
}

textures/skies_MASTER/kothic_brightblue-clouds
{
	qer_editorimage skpk/qer/env/brightblue/brightblue-clouds.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 60 350 77 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 125 4
	nopicmip
	skyparms skpk/env/brightblue/brightblue - -
	{
		map skpk/textures/hugojumps/env/clouds.tga
		tcMod scale 3 3
		tcMod scroll 0.006 0.006
		blendFunc gl_src_alpha gl_one_minus_src_alpha
	}
}

textures/skies_MASTER2/iiss_earth
{
	qer_editorimage skpk/qer/env/iiss/earth01.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 0.98 0.87 85 -178 80 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/iiss/earth01 - -
}

textures/skies_MASTER6/0color_greyBright2
{
	qer_editorimage skpk/qer/env/imhplasma1/w050.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms skpk/env/imhplasma1/w050 - -
}

textures/skies_MASTER2/skyspawn
{
	qer_editorimage skpk/qer/env/ironman/spawn.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 -138 45 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/ironman/spawn - -
}

textures/skies_MASTER2/skyend
{
	qer_editorimage skpk/qer/env/ironman/skyend.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_lightRGB 1 1 1
	q3map_skylight 125 4 0 90 0
	nopicmip
	skyparms skpk/env/ironman/skyend - -
}

textures/skies_MASTER2/skyb
{
	qer_editorimage skpk/qer/env/ironman/skyb.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 50 138 47 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 80 4
	nopicmip
	skyparms skpk/env/ironman/skyb - -
}

textures/skies_MASTER6/jnydm4
{
	qer_editorimage skpk/qer/6/jnydm4.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 125 4
	nopicmip
	skyparms - 384 -
	{
		map skpk/textures/jnydm4/jnydm4sky1.tga
		tcMod scale 2 2
		tcMod scroll 0.06 0.12
		depthWrite
	}
	{
		map skpk/textures/jnydm4/jnydm4sky2.tga
		blendFunc GL_ONE GL_ONE
		tcMod scale 3 2
		tcMod scroll 0.08 0.09
	}
}

textures/skies_MASTER6/atsea
{
	qer_editorimage skpk/qer/6/atsea.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 125 4
	nopicmip
	skyparms - 512 -
	{
		map skpk/textures/skies/dimclouds2.tga
		tcMod scroll 0.02 0
		tcMod scale 1 1
		depthWrite
	}
	{
		map skpk/textures/skies/dimclouds2.tga
		blendFunc add
		tcMod scroll 0.02 0.01
		tcMod scale 3 3
	}
}

textures/skies_MASTER6/kabcorp_sky1
{
	qer_editorimage skpk/qer/6/kabcorp_sky1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 125 4
	nopicmip
	skyParms - 512 -
	{
		map textures/skies/dimclouds.tga
		tcMod scroll -0.01 0.01
		tcMod scale 2 2
	}
	{
		map textures/sfx/tesla1.tga
		blendfunc gl_one_minus_dst_color gl_one
		tcMod scroll 0.01 0
		tcMod scale 1 1
		depthWrite
	}
}

// motion blur fx
textures/skies_MASTER6/kabcorp_sky2
{
	qer_editorimage skpk/qer/6/kabcorp_sky2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_lightRGB 255 250 240
	q3map_skylight 88 4 0 90 0
	nopicmip
	skyParms - 512 -
	{
		map textures/skies/dimclouds.tga
		blendfunc gl_one_minus_dst_color gl_one
		tcMod scroll -0.01 0.01
		tcMod scale 2 2
	}
	{
		map textures/sfx/tesla1.tga
		blendfunc gl_one_minus_dst_color gl_one
		tcMod scroll 0.01 0
		tcMod scale 1 1
		depthWrite
	}
}

textures/skies_MASTER6/lavahellsky
{
	qer_editorimage skpk/qer/6/lavahellsky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 145 4
	nopicmip
	skyparms - 512 -
	{
		map textures/skies/killsky_1.tga
		tcMod scroll 0.05 .1
		tcMod scale 2 2
	}
	{
		map textures/liquids/lavahell.tga
		blendfunc GL_ONE GL_ONE
		tcMod scroll 0.05 0.06
		tcMod scale 3 2
	}
}

textures/skies_MASTER/sb_frozendusk-kapot
{
	qer_editorimage skpk/qer/env/kapot/kapot.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 0.84 0 85 250 20 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/kapot/kapot - -
}

textures/skies_MASTER6/kingdomskyfix
{
	qer_editorimage skpk/qer/6/kingdomskyfix.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 255 245 235 22 -35 9 8 16
	q3map_LightMapFilterRadius 0 64
	q3map_skylight 99 4
	nopicmip
	skyparms skpk/textures/shaderlab_skybox/env/sky 512 -
	{
		map skpk/textures/sky/kingdomskyclouds.tga
		tcMod scale 3 3
		tcMod scroll 0.005 -0.0125
		rgbGen identityLighting
	}
	{
		clampmap skpk/textures/slterra/sky_arc_masked.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		tcMod scale 0.956 0.956
		tcMod transform 1 0 0 1 -1 -1
		rgbGen identityLighting
	}
}

textures/skies_MASTER2/LanC_Space
{
	qer_editorimage skpk/qer/env/LanC_Space/LanC-Space.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt .9 .9 .9 85 61 -4 3 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 105 4
	nopicmip
	skyparms skpk/env/LanC_Space/LanC-Space - -
}

textures/skies_MASTER2/n1kicey
{
	qer_editorimage skpk/qer/env/niklas/n1kicey/n1kicey.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 70 -179 39 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 85 4
	nopicmip
	skyparms skpk/env/niklas/n1kicey/n1kicey - -
}

textures/skies_MASTER2/dark_night
{
	qer_editorimage skpk/qer/textures/dark_night/dark_night.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 130 4
	nopicmip
	skyParms skpk/textures/dark_night/dark_night 2048 -
}

textures/skies_MASTER2/hope
{
	qer_editorimage skpk/qer/textures/hope/rays.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 65 -119 29 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 90 4
	nopicmip
	skyparms skpk/textures/hope/rays - -
}

textures/skies_MASTER2/mayajungle
{
	qer_editorimage skpk/qer/textures/mayan/junglesky/jsky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 -25 51 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/textures/mayan/junglesky/jsky - -
}

textures/skies_MASTER2/mcsky2
{
	qer_editorimage skpk/qer/textures/mcsky/mc.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.814054 0.756985 0.389197 85 -89 26 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/textures/mcsky/mc - -
}

textures/skies_MASTER3/abregaddo-metalorn
{
	qer_editorimage skpk/qer/textures/metalorn/metalorn.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyParms skpk/textures/metalorn/metalorn 512 -
}

textures/skies_MASTER6/metro
{
	qer_editorimage skpk/qer/6/metro.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 0.957681 0.721848 85 59 23 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/metro/puresky - -
	{
		map skpk/textures/metro/clouds.tga
		blendfunc blend
		tcMod scroll 0.0014 0.0015
		tcMod scale 4 4
		depthWrite
	}
	{
		map skpk/textures/metro/clouds.tga
		blendfunc blend
		tcMod scroll 0.0008 0.0011
		tcMod scale 2 2
		depthWrite
	}
}

textures/skies_MASTER6/stencil_ciel2
{
	qer_editorimage skpk/qer/6/stencil_ciel2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 140 4
	nopicmip
	skyparms - 512 -
	{
		map skpk/textures/futur/ciel01.tga
		tcMod scale 6 6
		tcMod scroll 0.0355 0.0355
		depthWrite
	}
	{
		map skpk/textures/futur/ciel02.tga
		blendFunc GL_ONE GL_ONE
		tcMod scale 6 6
		tcMod scroll 0.0125 0.0125
	}
}

textures/skies_MASTER2/dsb
{
	qer_editorimage skpk/qer/env/dsb/dsbstars.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_lightRGB 1 1 1
	q3map_skylight 130 4 0 90 0
	nopicmip
	skyparms skpk/env/dsb/dsbstars - -
}

textures/skies_MASTER3/sfspace-ctf1
{
	qer_editorimage skpk/qer/textures/skies/space.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_lightRGB 1 1 1
	q3map_skylight 130 4 0 90 0
	nopicmip
	skyParms skpk/textures/skies/space 512 -
}

textures/skies_MASTER2/desert3
{
	qer_editorimage skpk/qer/textures/skies/desert.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyParms skpk/textures/skies/desert 512 -
}

textures/skies_MASTER6/stencil_ciel3
{
	qer_editorimage skpk/qer/6/stencil_ciel3.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 130 4
	nopicmip
	skyparms - 512 -
	{
		map skpk/textures/palais/cieletoile01.tga
		tcMod scale 14 14
		tcMod scroll 0.0090 0.0090
		depthWrite
	}
	{
		map skpk/textures/palais/ciel01.tga
		blendFunc GL_ONE GL_ONE
		tcMod scale 3 3
		tcMod scroll 0.0200 0.0200
	}
}

textures/skies_MASTER6/stencil_ciel4
{
	qer_editorimage skpk/qer/6/stencil_ciel4.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 125 4
	nopicmip
	skyparms - 512 -
	{
		map skpk/textures/paris/ciel01.tga
		tcMod scale 3 3
		tcMod scroll 0.0200 0.00200
	}
}

textures/skies_MASTER2/penthouse
{
	qer_editorimage skpk/qer/env/penthouse.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_lightRGB 1 1 1
	q3map_skylight 70 4 0 90 0
	nopicmip
	skyparms skpk/env/penthouse 512 -
}

textures/skies_MASTER6/lblood
{
	qer_editorimage skpk/qer/6/lblood.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyparms - 128 -
	{
		map textures/skies/killsky_1.tga
		tcMod scroll 0.02 0
		tcMod scale 2 2
	}
	{
		animMap 2 skpk/textures/skies/empty1.tga skpk/textures/skies/empty1.tga skpk/textures/skies/zdh_lightning1k2b2.tga skpk/textures/skies/zdh_lightning1k3b.tga skpk/textures/skies/empty1.tga skpk/textures/skies/empty1.tga skpk/textures/skies/empty1.tga skpk/textures/skies/empty1.tga skpk/textures/skies/empty1.tga skpk/textures/skies/empty1.tga
		blendFunc GL_ONE GL_ONE
		rgbGen identity
		rgbGen wave inverseSawtooth 0 1 0 2
		tcMod scale 3 3
	}
}

textures/skies_MASTER6/pulchr01
{
	qer_editorimage skpk/qer/6/pulchr01.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyParms - 512 -
	{
		map skpk/textures/pulchr_skies/skypulchr01.tga
		tcMod scale 1 1
		tcMod scroll 0.2 0.2
		depthWrite
	}
	{
		map skpk/textures/pulchr_skies/skypulchr02.tga
		blendfunc add
		tcMod scale 2 2
		tcMod scroll 0.05 0.05
	}
}

textures/skies_MASTER6/shaderlab_potrero_sunset_q3dmp9
{
	qer_editorimage skpk/qer/6/shaderlab_potrero_sunset_q3dmp9.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.921874 0.83267 0.376013 85 -165 10 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/textures/shaderlab_skies/black 576 -
	{
		map skpk/textures/shaderlab_skies/clouds_2.tga
		tcMod scale 2.75 1.75
		tcMod scroll 0.01 -0.00375
		rgbGen identityLighting
	}
	{
		clampMap skpk/textures/q3dmp9/potrero_sunset_1.tga
		blendFunc GL_SRC_ALPHA GL_SRC_COLOR
		tcMod transform 0.75 0 0 0.75 -0.678 -0.678
		rgbGen identityLighting
	}
}

textures/skies_MASTER2/qlwc21_round2
{
	qer_editorimage skpk/qer/env/qlwc21_round2/space1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 0.775479 0.378607 70 -85 18 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 80 4
	nopicmip
	skyparms skpk/env/qlwc21_round2/space1 - -
}

textures/skies_MASTER2/quBit_a01
{
	qer_editorimage skpk/qer/textures/quBit_a01/sky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_lightRGB 1 1 1
	q3map_skylight 115 4 0 90 0
	nopicmip
	skyparms skpk/textures/quBit_a01/sky - -
}

textures/skies_MASTER/hip_stormy-cyan
{
	qer_editorimage skpk/qer/env/nebo/stormydays.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt .6 0.6 0.8 75 -44 19 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/nebo/stormydays - -
}

textures/skies_MASTER2/NY
{
	qer_editorimage skpk/qer/textures/racearena/NY.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_lightRGB 1 1 1
	q3map_skylight 130 4 0 90 0
	nopicmip
	skyParms skpk/textures/racearena/NY - -
}

textures/skies_MASTER6/blic_cloudsky
{
	qer_editorimage skpk/qer/6/blic_cloudsky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 90 -8 61 1 32
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 65 6
	nopicmip
	skyParms skpk/env/romanduel 1280 -
	{
		map textures/skies/dimclouds.tga
		blendfunc add
		tcMod scroll 0.005 0.006
		tcMod scale 3 3
		depthWrite
	}
}

textures/skies_MASTER2/shadow_temple
{
	qer_editorimage skpk/qer/textures/shadow_temple/sky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt .98 1 .8 85 135 45 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/textures/shadow_temple/sky 128 -
}

textures/skies_MASTER3/korb-moostLava
{
	qer_editorimage skpk/qer/textures/skies/moost.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 .997119 0.857641 45 123 50 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 95 4
	nopicmip
	skyParms skpk/textures/skies/moost 512 -
}

textures/skies_MASTER6/gothicrage
{
	qer_editorimage skpk/qer/6/gothicrage.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 140 4
	nopicmip
	skyparms - 512 -
	{
		map skpk/textures/skies/redclouds.tga
		tcMod scroll 0.05 .1
		tcMod scale 2 2
		depthWrite
	}
	{
		map textures/skies/killsky_2.tga
		blendfunc add
		tcMod scroll 0.05 0.06
		tcMod scale 3 2
	}
}

textures/skies_MASTER/night1-clouds
{
	qer_editorimage skpk/qer/env/night1-clouds.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_lightRGB 1 1 1
	q3map_skylight 125 4 0 90 0
	nopicmip
	skyParms skpk/env/night1 512 -
	{
		map textures/skies/topclouds.tga
		blendFunc GL_ONE GL_ONE
		tcMod scale 3 3
		tcMod scroll 0.05 0.05
	}
}

textures/skies_MASTER6/sk8ciel_03B
{
	qer_editorimage skpk/qer/6/sk8ciel_03B.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyparms - 512 -
	{
		map skpk/textures/sk8argent/sk8cielpourpre0B.tga
		tcMod scroll 0.05 0.05
		tcMod scale 3 2
	}
	{
		map skpk/textures/sk8argent/sk8cielpourpre0B.tga
		blendFunc add
		tcMod scroll 0.01 0.01
		tcMod scale 3 3
	}
}

textures/skies_MASTER6/sk8ciel_04B
{
	qer_editorimage skpk/qer/6/sk8ciel_04B.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyparms - 512 -
	{
		map skpk/textures/sk8argent/sk8cielbleu1.tga
		tcMod scroll 0.05 0.05
		tcMod scale 3 2
	}
	{
		map skpk/textures/sk8argent/sk8cielbleu1.tga
		blendFunc add
		tcMod scroll 0.01 0.01
		tcMod scale 3 3
	}
}

textures/skies_MASTER/hip_inter-darkWarm
{
	qer_editorimage skpk/qer/env/space_sky/space_sky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt .941 .984 1 80 340 49 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/space_sky/space_sky - -
}

textures/skies_MASTER2/Space
{
	qer_editorimage skpk/qer/textures/pink/Spacepics/Space.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_lightRGB 1 1 1
	q3map_skylight 120 4 0 90 0
	nopicmip
	skyParms skpk/textures/pink/Spacepics/Space 512 -
}

textures/skies_MASTER/kothic_grassland-dimmer
{
	qer_editorimage skpk/qer/env/massacre/massacre.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 70 59 39 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 50 4
	nopicmip
	skyparms skpk/env/massacre/massacre - -
}

textures/skies_MASTER2/smc02_quBit
{
	qer_editorimage skpk/qer/textures/smc02_quBit/sky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyparms skpk/textures/smc02_quBit/sky 512 -
}

textures/skies_MASTER2/smc06_silly
{
	qer_editorimage skpk/qer/textures/smc06_silly/sky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_lightRGB 1 1 1
	q3map_skylight 120 4 0 90 0
	nopicmip
	skyparms skpk/textures/smc06_silly/sky - -
}

textures/skies_MASTER/ely_cloudtop-pale
{
	qer_editorimage skpk/qer/env/spazz_ripwinter/cloudtop.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 .99 .807 80 -163 19 4 32
	q3map_LightMapFilterRadius 0 16
	q3map_skylight 50 5
	nopicmip
	skyparms skpk/env/spazz_ripwinter/cloudtop - -
}

textures/skies_MASTER6/spazz_space
{
	qer_editorimage skpk/qer/6/spazz_space.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_lightRGB 1 1 1
	q3map_skylight 130 4 0 90 0
	nopicmip
	skyparms skpk/env/spazz_space/spazz_space 1024 -
	{
		map skpk/textures/spazz_space/spacedust.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaFunc GT0
		depthWrite
		tcMod scroll 0.1 0.01
		rgbGen identityLighting
	}
	{
		map skpk/textures/spazz_space/spacedust2.tga
		rgbgen wave sin 0.2 0.1 0.5 0.3
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaFunc GT0
		depthWrite
		tcMod scroll -0.01 -0.005
		rgbGen identityLighting
	}
}

textures/skies_MASTER6/spog_whitesky
{
	qer_editorimage skpk/qer/6/spog_whitesky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyparms - 512 -
	{
		map skpk/textures/spog/bluesky1.tga
		tcMod scroll 0.05 0.05
		tcMod scale 6 4
		depthWrite
	}
	{
		map skpk/textures/spog/bluesky2.tga
		rgbgen const ( .2 .2 .2 )
		blendFunc GL_ONE GL_ONE
		tcMod scroll 0.025 0.025
		tcMod scale 6 6
	}
}

textures/skies_MASTER2/th3k1ll3r_jumps
{
	qer_editorimage skpk/qer/env/th3k1ll3r_sky/sky05.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_lightRGB 1 .5 .25
	q3map_skylight 135 4 0 90 0
	nopicmip
	skyparms skpk/env/th3k1ll3r_sky/sky05 - -
}

textures/skies_MASTER2/toonsky
{
	qer_editorimage skpk/qer/env/toonsky/frsth_sky3.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyParms skpk/env/toonsky/frsth_sky3 256 -
}

textures/skies_MASTER6/torp_concept01
{
	qer_editorimage skpk/qer/6/torp_concept01.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 115 4
	nopicmip
	skyparms - 512 -
	{
		map skpk/textures/qskies/meth_clouds2.tga
		tcMod scale 10 10
		tcMod scroll .09 .09
		depthWrite
	}
	{
		animMap 2.1 skpk/textures/skies/lightn_clouds1.tga skpk/textures/skies/lightn_clouds1.tga skpk/textures/skies/lightn_clouds1.tga skpk/textures/skies/lightn_clouds1.tga skpk/textures/skies/lightn_clouds2.tga skpk/textures/skies/lightn_clouds1.tga skpk/textures/skies/lightn_clouds1.tga
		blendfunc add
		rgbGen wave sin 0.2 0.4 0 1.1
		tcMod scale 10 10
		tcMod scroll .09 .09
	}
	{
		map textures/skies/topclouds.tga
		blendfunc add
		tcMod scale 4 4
		tcMod scroll 0.07 0.07
	}
}

textures/skies_MASTER6/torp_concept04
{
	qer_editorimage skpk/qer/6/torp_concept04.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 110 75 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 5
	nopicmip
	skyparms skpk/env/torp_concept04/sky 1024 -
	{
		map skpk/env/torp_concept04/clouds.tga
		tcMod scale 1.25 1.25
		tcMod scroll 0.0075 -0.0075
		blendFunc blend
		rgbgen identityLighting
	}
}

textures/skies_MASTER6/torp_concept05
{
	qer_editorimage skpk/qer/6/torp_concept05.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 135 5
	nopicmip
	skyParms skpk/env/torp_concept05/sky 1500 -
	{
		map skpk/textures/torp_concept05/sky_clouds.tga
		blendfunc blend
		rgbGen identityLighting
		tcMod scroll 0.0215 -0.0155
	}
	{
		map skpk/textures/torp_concept05/sky_horizon.tga
		blendfunc gl_one_minus_src_alpha gl_src_alpha
		rgbGen identityLighting
		tcMod transform 0.25 0 0 0.25 0.1075 0.1075
	}
}

textures/skies_MASTER6/torp_concept07
{
	qer_editorimage skpk/qer/6/torp_concept07.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 40 -17 21 2 16
	q3map_lightmapFilterRadius 0 16
	q3map_skylight 110 4
	nopicmip
	skyparms skpk/textures/skies/env/devilish 512 -
	{
		map skpk/textures/skies/meth_clouds3.tga
		blendfunc filter
		tcMod scale 3 2
		tcMod scroll 0.02 0.04
	}
	{
		map skpk/textures/skies/devilish_dimclouds.tga
		blendfunc add
		tcMod scale 5 5
		tcMod scroll 0.02 0.02
	}
}

textures/skies_MASTER6/torp_reborn
{
	qer_editorimage skpk/qer/6/torp_reborn.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 125 4
	nopicmip
	skyparms skpk/env/torp_reborn/torp_reborn_sky 1500 -
	{
		map skpk/textures/skies/meth_clouds3.tga
		blendfunc filter
		tcMod scale 3 2
		tcMod scroll .04 .08
	}
	{
		animMap 0.93 skpk/env/torp_reborn/lightn_clouds1.tga skpk/env/torp_reborn/lightn_clouds1.tga skpk/env/torp_reborn/lightn_clouds1.tga skpk/env/torp_reborn/lightn_clouds2.tga skpk/env/torp_reborn/lightn_clouds1.tga skpk/env/torp_reborn/lightn_clouds1.tga skpk/env/torp_reborn/lightn_clouds1.tga skpk/env/torp_reborn/lightn_clouds1.tga
		rgbGen wave sawtooth 0.0 0.4 0 1.7
		tcMod scale 3 2
		tcMod scroll .01 .01
	}
	{
		map skpk/textures/skies/devilish_dimclouds.tga
		blendfunc add
		tcMod scale 2 2
		tcMod scroll .04 .04
	}
	{
		map skpk/env/torp_reborn/torp_reborn_sky_mask.tga
		blendFunc GL_ONE_MINUS_SRC_ALPHA GL_SRC_ALPHA
		tcMod transform 0.25 0 0 0.25 0.1075 0.1075
		rgbGen identityLighting
	}
}

textures/skies_MASTER/hip_inter-is
{
	qer_editorimage skpk/qer/env/torp_spracer/is.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt .941 .984 1 80 340 49 2 16
	q3map_LightMapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/torp_spracer/is - -
}

textures/skies_MASTER6/trdm
{
	qer_editorimage skpk/qer/6/trdm.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyparms - 512 -
	{
		map skpk/textures/trdm/trsky1light.tga
		tcMod scroll 0.05 0.05
		tcMod scale 2 1
		depthWrite
	}
	{
		map skpk/textures/Maxx/trsky1dark.tga
		blendFunc GL_ONE GL_ONE
		tcMod scroll 0.005 0.005
		tcMod scale 2 2
	}
}

textures/skies_MASTER2/ulbshort1
{
	qer_editorimage skpk/qer/textures/ulbshort1/sky03.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyparms skpk/textures/ulbshort1/sky03 - -
}

textures/skies_MASTER2/uni
{
	qer_editorimage skpk/qer/env/uni/uni.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyparms skpk/env/uni/uni - -
}

textures/skies_MASTER2/mcsky4
{
	qer_editorimage skpk/qer/textures/tex/sky/mcsky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 145 4
	nopicmip
	skyParms skpk/textures/tex/sky/mcsky 512 -
}

textures/skies_MASTER2/ut4_cube
{
	qer_editorimage skpk/qer/env/ut4_cube/sky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_lightRGB 0.564095 0.393149 0.779171
	q3map_skylight 120 4 0 90 0
	nopicmip
	skyparms skpk/env/ut4_cube/sky 1024 -
}

textures/skies_MASTER2/ut4_gula
{
	qer_editorimage skpk/qer/textures/ut4_gula/sky19.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 135 4
	nopicmip
	skyparms skpk/textures/ut4_gula/sky19 - -
}

textures/skies_MASTER6/0color_blue-kashmir
{
	qer_editorimage skpk/qer/env/ut4_jumps2/blue_sky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 150 4
	nopicmip
	skyparms skpk/env/ut4_jumps2/blue_sky - -
}

textures/skies_MASTER6/mario_atmosphere
{
	qer_editorimage skpk/qer/6/mario_atmosphere.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 140 4
	nopicmip
	skyparms skpk/textures/mario_atmosphere/sky_blue 1024 -
	{
		map skpk/textures/mario_atmosphere/sky_clouds.tga
		blendFunc blend
		tcMod scroll 0.003 0.003
		tcMod scale 3 2
	}
}

textures/skies_MASTER2/ut4_saturn_beta2
{
	qer_editorimage skpk/qer/env/ut4_saturn_beta2/bjump.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_lightRGB 1 1 1
	q3map_skylight 130 4 0 90 0
	nopicmip
	skyparms skpk/env/ut4_saturn_beta2/bjump - -
}

textures/skies_MASTER2/ut4_uranus
{
	qer_editorimage skpk/qer/env/uranussky/uranussky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_lightRGB 1 1 1
	q3map_skylight 130 4 0 90 0
	nopicmip
	skyparms skpk/env/uranussky/uranussky - -
}

textures/skies_MASTER2/valahia
{
	qer_editorimage skpk/qer/env/vio1/blucloud.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 130 4
	nopicmip
	skyparms skpk/env/vio1/blucloud - -
}

textures/skies_MASTER2/vulcano
{
	qer_editorimage skpk/qer/env/vulcano/vulcan.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt .6 .6 .6 85 -70 23 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/vulcano/vulcan - -
}

textures/skies_MASTER6/industrysky
{
	qer_editorimage skpk/qer/6/industrysky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 125 4
	nopicmip
	skyparms - 800 -
	{
		map $whiteimage
		rgbgen const ( 0.137255 0.172549 0.227451 )
	}
	{
		map textures/skies/topclouds.tga
		blendfunc add
		rgbgen const ( 0.219608 0.396078 0.588235 )
		tcmod scroll -0.004 0.004
		tcmod scale 2 2
	}
}

textures/skies_MASTER6/wswtest
{
	qer_editorimage skpk/qer/6/wswtest.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 130 4
	nopicmip
	skyParms - 512 -
	{
		map skpk/textures/wswtest/sky.tga
		tcMod scale 8 8
		depthWrite
	}
}

textures/skies_MASTER6/yellowsky
{
	qer_editorimage skpk/qer/6/yellowsky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 130 4
	nopicmip
	skyparms - 512 -
	{
		map skpk/textures/xsky/yellowsky.tga
		tcMod scroll 0.05 0.05
		tcMod scale 3 2
	}
	{
		map skpk/textures/xsky/yellowsky.tga
		blendFunc add
		tcMod scroll 0.01 0.01
		tcMod scale 3 3
	}
}

textures/skies_MASTER2/blacksun
{
	qer_editorimage skpk/qer/textures/zeppelin-plutonic_sky/blacksun.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 60 0 90 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 95 4
	nopicmip
	skyparms skpk/textures/zeppelin-plutonic_sky/blacksun 1024 -
}

//+ws_extra

textures/skies_MASTER3/ghost_milky-purple
{
	qer_editorimage skpk/qer/textures/amt-fs5_sky/space1.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 145 4
	nopicmip
	skyparms skpk/textures/amt-fs5_sky/space1 - -
}

textures/skies_MASTER2/codey1_oilbox02
{
	qer_editorimage skpk/qer/textures/codey1/oilbox02.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.95819 0.918059 0.637049 70 175 39 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 85 4
	nopicmip
	skyparms skpk/textures/codey1/oilbox02 - -
}

textures/skies_MASTER2/codey1_oilbox02-v2
{
	qer_editorimage skpk/qer/textures/codey1/v2/oilbox02.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.95819 0.918059 0.637049 70 175 39 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 85 4
	nopicmip
	skyparms skpk/textures/codey1/v2/oilbox02 - -
}

textures/skies_MASTER2/codey2_herring
{
	qer_editorimage skpk/qer/textures/codey2/herring_sky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 60 -94 40 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 95 4
	nopicmip
	skyparms skpk/textures/codey2/herring_sky - -
}

textures/skies_MASTER2/evil8
{
	qer_editorimage skpk/qer/textures/evil8_env/e8.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_lightmapFilterRadius 0 8
	q3map_lightRGB 1 1 1
	q3map_skylight 120 4 0 90 0
	nopicmip
	skyparms skpk/textures/evil8_env/e8 - -
}

textures/skies_MASTER2/desert2
{
	qer_editorimage skpk/qer/textures/skies/desert2.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 85 44 30 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/textures/skies/desert2 - -
}

textures/skies_MASTER2/unit3
{
	qer_editorimage skpk/qer/env/unit3.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 1 1 1 60 -44 35 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 95 4
	nopicmip
	skyparms skpk/env/unit3 - -
}

textures/skies_MASTER2/sidrialdm1
{
	qer_editorimage skpk/qer/env/sidrialdm1/sidrialdm1sky.tga
	surfaceparm noimpact
	surfaceparm nolightmap
	surfaceparm sky
	q3map_sunExt 0.937255 0.937255 0.517647 85 -118 19 2 16
	q3map_lightmapFilterRadius 0 8
	q3map_skylight 70 4
	nopicmip
	skyparms skpk/env/sid